Feature: commit verbosely

  Background:
    Given a Git repo with origin
    And the branches
      | NAME     | TYPE    | PARENT   | LOCATIONS     |
      | branch-1 | feature | main     | local, origin |
      | branch-2 | feature | branch-1 | local, origin |
    And the commits
      | BRANCH   | LOCATION      | MESSAGE   | FILE NAME | FILE CONTENT |
      | branch-1 | local, origin | commit 1a | file_1    | content 1    |
      | branch-2 | local, origin | commit 2a | file_2    | content 2    |
    And the current branch is "branch-2"
    And an uncommitted file "changes" with content "my changes"
    And I ran "git add changes"
    When I run "git-town commit --down -m commit-1b --verbose"

  Scenario: result
    Then Git Town runs the commands
      | BRANCH   | COMMAND                                                                                                                                                                                                                                                                                                                                          |
      |          | git version                                                                                                                                                                                                                                                                                                                                      |
      |          | git rev-parse --show-toplevel                                                                                                                                                                                                                                                                                                                    |
      |          | git config -lz --global                                                                                                                                                                                                                                                                                                                          |
      |          | git config -lz --local                                                                                                                                                                                                                                                                                                                           |
      |          | git config -lz                                                                                                                                                                                                                                                                                                                                   |
      |          | git rev-parse --verify --abbrev-ref @{-1}                                                                                                                                                                                                                                                                                                        |
      |          | git for-each-ref "--format=refname:%(refname) branchname:%(refname:lstrip=2) sha:%(objectname) head:%(if)%(HEAD)%(then)Y%(else)N%(end) worktree:%(if)%(worktreepath)%(then)Y%(else)N%(end) symref:%(if)%(symref)%(then)Y%(else)N%(end) upstream:%(upstream:lstrip=2) track:%(upstream:track,nobracket)" --sort=refname refs/heads/ refs/remotes/ |
      |          | git status -z --ignore-submodules                                                                                                                                                                                                                                                                                                                |
      |          | git rev-parse --verify -q MERGE_HEAD                                                                                                                                                                                                                                                                                                             |
      |          | git rev-parse --absolute-git-dir                                                                                                                                                                                                                                                                                                                 |
      |          | git remote get-url origin                                                                                                                                                                                                                                                                                                                        |
      |          | git stash list                                                                                                                                                                                                                                                                                                                                   |
      |          | git for-each-ref "--format=refname:%(refname) branchname:%(refname:lstrip=2) sha:%(objectname) head:%(if)%(HEAD)%(then)Y%(else)N%(end) worktree:%(if)%(worktreepath)%(then)Y%(else)N%(end) symref:%(if)%(symref)%(then)Y%(else)N%(end) upstream:%(upstream:lstrip=2) track:%(upstream:track,nobracket)" --sort=refname refs/heads/ refs/remotes/ |
      |          | git remote                                                                                                                                                                                                                                                                                                                                       |
      |          | git log branch-1..branch-2 --format=%s --reverse                                                                                                                                                                                                                                                                                                 |
      | branch-2 | git checkout branch-1                                                                                                                                                                                                                                                                                                                            |
      | branch-1 | git commit -m commit-1b                                                                                                                                                                                                                                                                                                                          |
      |          | git checkout branch-2                                                                                                                                                                                                                                                                                                                            |
      |          | git log --no-merges --format=%H refs/heads/branch-1 ^refs/heads/branch-2                                                                                                                                                                                                                                                                         |
      |          | git rev-parse branch-2 origin/branch-2                                                                                                                                                                                                                                                                                                           |
      | branch-2 | git merge --no-edit --ff branch-1                                                                                                                                                                                                                                                                                                                |
      |          | git rev-parse --verify -q refs/heads/branch-1                                                                                                                                                                                                                                                                                                    |
      |          | git for-each-ref "--format=refname:%(refname) branchname:%(refname:lstrip=2) sha:%(objectname) head:%(if)%(HEAD)%(then)Y%(else)N%(end) worktree:%(if)%(worktreepath)%(then)Y%(else)N%(end) symref:%(if)%(symref)%(then)Y%(else)N%(end) upstream:%(upstream:lstrip=2) track:%(upstream:track,nobracket)" --sort=refname refs/heads/ refs/remotes/ |
      |          | git config -lz --global                                                                                                                                                                                                                                                                                                                          |
      |          | git config -lz --local                                                                                                                                                                                                                                                                                                                           |
      |          | git stash list                                                                                                                                                                                                                                                                                                                                   |
    And Git Town prints:
      """
      Ran 26 shell commands.
      """
    And these commits exist now
      | BRANCH   | LOCATION      | MESSAGE                               | FILE NAME | FILE CONTENT |
      | branch-1 | local, origin | commit 1a                             | file_1    | content 1    |
      |          | local         | commit-1b                             | changes   | my changes   |
      | branch-2 | local, origin | commit 2a                             | file_2    | content 2    |
      |          | local         | Merge branch 'branch-1' into branch-2 |           |              |

  Scenario: undo
    When I run "git-town undo --verbose"
    Then Git Town runs the commands
      | BRANCH   | COMMAND                                                                                                                                                                                                                                                                                                                                          |
      |          | git version                                                                                                                                                                                                                                                                                                                                      |
      |          | git rev-parse --show-toplevel                                                                                                                                                                                                                                                                                                                    |
      |          | git config -lz --global                                                                                                                                                                                                                                                                                                                          |
      |          | git config -lz --local                                                                                                                                                                                                                                                                                                                           |
      |          | git config -lz                                                                                                                                                                                                                                                                                                                                   |
      |          | git status -z --ignore-submodules                                                                                                                                                                                                                                                                                                                |
      |          | git rev-parse --verify -q MERGE_HEAD                                                                                                                                                                                                                                                                                                             |
      |          | git rev-parse --absolute-git-dir                                                                                                                                                                                                                                                                                                                 |
      |          | git remote get-url origin                                                                                                                                                                                                                                                                                                                        |
      |          | git stash list                                                                                                                                                                                                                                                                                                                                   |
      |          | git for-each-ref "--format=refname:%(refname) branchname:%(refname:lstrip=2) sha:%(objectname) head:%(if)%(HEAD)%(then)Y%(else)N%(end) worktree:%(if)%(worktreepath)%(then)Y%(else)N%(end) symref:%(if)%(symref)%(then)Y%(else)N%(end) upstream:%(upstream:lstrip=2) track:%(upstream:track,nobracket)" --sort=refname refs/heads/ refs/remotes/ |
      |          | git remote                                                                                                                                                                                                                                                                                                                                       |
      |          | git rev-parse --verify --abbrev-ref @{-1}                                                                                                                                                                                                                                                                                                        |
      | branch-2 | git checkout branch-1                                                                                                                                                                                                                                                                                                                            |
      |          | git rev-parse HEAD                                                                                                                                                                                                                                                                                                                               |
      | branch-1 | git reset --hard {{ sha 'commit 1a' }}                                                                                                                                                                                                                                                                                                           |
      |          | git checkout branch-2                                                                                                                                                                                                                                                                                                                            |
      |          | git rev-parse HEAD                                                                                                                                                                                                                                                                                                                               |
      | branch-2 | git reset --hard {{ sha 'commit 2a' }}                                                                                                                                                                                                                                                                                                           |
    And Git Town prints:
      """
      Ran 19 shell commands.
      """
    And the initial branches and lineage exist now
    And the initial commits exist now
