// SPDX-License-Identifier: Unlicense OR BSD-3-Clause

package tables

import (
	"encoding/binary"
	"fmt"
)

//lint:file-ignore SA4006 The code generator is not smart enough to remove unused variables.

// Code generated by binarygen from ot_gpos_src.go. DO NOT EDIT

func (item *AnchorFormat1) mustParse(src []byte) {
	_ = src[5] // early bound checking
	item.anchorFormat = binary.BigEndian.Uint16(src[0:])
	item.XCoordinate = int16(binary.BigEndian.Uint16(src[2:]))
	item.YCoordinate = int16(binary.BigEndian.Uint16(src[4:]))
}

func (item *AnchorFormat2) mustParse(src []byte) {
	_ = src[7] // early bound checking
	item.anchorFormat = binary.BigEndian.Uint16(src[0:])
	item.XCoordinate = int16(binary.BigEndian.Uint16(src[2:]))
	item.YCoordinate = int16(binary.BigEndian.Uint16(src[4:]))
	item.AnchorPoint = binary.BigEndian.Uint16(src[6:])
}

func (item *DeviceTableHeader) mustParse(src []byte) {
	_ = src[5] // early bound checking
	item.first = binary.BigEndian.Uint16(src[0:])
	item.second = binary.BigEndian.Uint16(src[2:])
	item.deltaFormat = binary.BigEndian.Uint16(src[4:])
}

func (item *MarkRecord) mustParse(src []byte) {
	_ = src[3] // early bound checking
	item.MarkClass = binary.BigEndian.Uint16(src[0:])
	item.markAnchorOffset = Offset16(binary.BigEndian.Uint16(src[2:]))
}

func ParseAnchor(src []byte) (Anchor, int, error) {
	var item Anchor

	if L := len(src); L < 2 {
		return item, 0, fmt.Errorf("reading Anchor: "+"EOF: expected length: 2, got %d", L)
	}
	format := uint16(binary.BigEndian.Uint16(src[0:]))
	var (
		read int
		err  error
	)
	switch format {
	case 1:
		item, read, err = ParseAnchorFormat1(src[0:])
	case 2:
		item, read, err = ParseAnchorFormat2(src[0:])
	case 3:
		item, read, err = ParseAnchorFormat3(src[0:])
	default:
		err = fmt.Errorf("unsupported Anchor format %d", format)
	}
	if err != nil {
		return item, 0, fmt.Errorf("reading Anchor: %s", err)
	}

	return item, read, nil
}

func ParseAnchorFormat1(src []byte) (AnchorFormat1, int, error) {
	var item AnchorFormat1
	n := 0
	if L := len(src); L < 6 {
		return item, 0, fmt.Errorf("reading AnchorFormat1: "+"EOF: expected length: 6, got %d", L)
	}
	item.mustParse(src)
	n += 6
	return item, n, nil
}

func ParseAnchorFormat2(src []byte) (AnchorFormat2, int, error) {
	var item AnchorFormat2
	n := 0
	if L := len(src); L < 8 {
		return item, 0, fmt.Errorf("reading AnchorFormat2: "+"EOF: expected length: 8, got %d", L)
	}
	item.mustParse(src)
	n += 8
	return item, n, nil
}

func ParseAnchorFormat3(src []byte) (AnchorFormat3, int, error) {
	var item AnchorFormat3
	n := 0
	if L := len(src); L < 10 {
		return item, 0, fmt.Errorf("reading AnchorFormat3: "+"EOF: expected length: 10, got %d", L)
	}
	_ = src[9] // early bound checking
	item.anchorFormat = binary.BigEndian.Uint16(src[0:])
	item.XCoordinate = int16(binary.BigEndian.Uint16(src[2:]))
	item.YCoordinate = int16(binary.BigEndian.Uint16(src[4:]))
	item.xDeviceOffset = Offset16(binary.BigEndian.Uint16(src[6:]))
	item.yDeviceOffset = Offset16(binary.BigEndian.Uint16(src[8:]))
	n += 10

	{

		err := item.parseXDevice(src[:])
		if err != nil {
			return item, 0, fmt.Errorf("reading AnchorFormat3: %s", err)
		}
	}
	{

		err := item.parseYDevice(src[:])
		if err != nil {
			return item, 0, fmt.Errorf("reading AnchorFormat3: %s", err)
		}
	}
	return item, n, nil
}

func ParseBaseArray(src []byte, offsetsCount int) (BaseArray, int, error) {
	var item BaseArray
	n := 0
	if L := len(src); L < 2 {
		return item, 0, fmt.Errorf("reading BaseArray: "+"EOF: expected length: 2, got %d", L)
	}
	arrayLengthBaseRecords := int(binary.BigEndian.Uint16(src[0:]))
	n += 2

	{

		offset := 2
		for i := 0; i < arrayLengthBaseRecords; i++ {
			elem, read, err := parseAnchorOffsets(src[offset:], offsetsCount)
			if err != nil {
				return item, 0, fmt.Errorf("reading BaseArray: %s", err)
			}
			item.baseRecords = append(item.baseRecords, elem)
			offset += read
		}
		n = offset
	}
	{

		item.data = src[0:]
		n = len(src)
	}
	return item, n, nil
}

func ParseChainedContextualPos(src []byte) (ChainedContextualPos, int, error) {
	var item ChainedContextualPos
	n := 0
	{
		var (
			err  error
			read int
		)
		item.Data, read, err = ParseChainedContextualPosITF(src[0:])
		if err != nil {
			return item, 0, fmt.Errorf("reading ChainedContextualPos: %s", err)
		}
		n += read
	}
	return item, n, nil
}

func ParseChainedContextualPos1(src []byte) (ChainedContextualPos1, int, error) {
	var item ChainedContextualPos1
	n := 0
	if L := len(src); L < 6 {
		return item, 0, fmt.Errorf("reading ChainedContextualPos1: "+"EOF: expected length: 6, got %d", L)
	}
	_ = src[5] // early bound checking
	item.format = binary.BigEndian.Uint16(src[0:])
	offsetCoverage := int(binary.BigEndian.Uint16(src[2:]))
	arrayLengthChainedSeqRuleSet := int(binary.BigEndian.Uint16(src[4:]))
	n += 6

	{

		if offsetCoverage != 0 { // ignore null offset
			if L := len(src); L < offsetCoverage {
				return item, 0, fmt.Errorf("reading ChainedContextualPos1: "+"EOF: expected length: %d, got %d", offsetCoverage, L)
			}

			var (
				err  error
				read int
			)
			item.coverage, read, err = ParseCoverage(src[offsetCoverage:])
			if err != nil {
				return item, 0, fmt.Errorf("reading ChainedContextualPos1: %s", err)
			}
			offsetCoverage += read
		}
	}
	{

		if L := len(src); L < 6+arrayLengthChainedSeqRuleSet*2 {
			return item, 0, fmt.Errorf("reading ChainedContextualPos1: "+"EOF: expected length: %d, got %d", 6+arrayLengthChainedSeqRuleSet*2, L)
		}

		item.ChainedSeqRuleSet = make([]ChainedSequenceRuleSet, arrayLengthChainedSeqRuleSet) // allocation guarded by the previous check
		for i := range item.ChainedSeqRuleSet {
			offset := int(binary.BigEndian.Uint16(src[6+i*2:]))
			// ignore null offsets
			if offset == 0 {
				continue
			}

			if L := len(src); L < offset {
				return item, 0, fmt.Errorf("reading ChainedContextualPos1: "+"EOF: expected length: %d, got %d", offset, L)
			}

			var err error
			item.ChainedSeqRuleSet[i], _, err = ParseChainedSequenceRuleSet(src[offset:])
			if err != nil {
				return item, 0, fmt.Errorf("reading ChainedContextualPos1: %s", err)
			}
		}
		n += arrayLengthChainedSeqRuleSet * 2
	}
	return item, n, nil
}

func ParseChainedContextualPos2(src []byte) (ChainedContextualPos2, int, error) {
	var item ChainedContextualPos2
	n := 0
	if L := len(src); L < 12 {
		return item, 0, fmt.Errorf("reading ChainedContextualPos2: "+"EOF: expected length: 12, got %d", L)
	}
	_ = src[11] // early bound checking
	item.format = binary.BigEndian.Uint16(src[0:])
	offsetCoverage := int(binary.BigEndian.Uint16(src[2:]))
	offsetBacktrackClassDef := int(binary.BigEndian.Uint16(src[4:]))
	offsetInputClassDef := int(binary.BigEndian.Uint16(src[6:]))
	offsetLookaheadClassDef := int(binary.BigEndian.Uint16(src[8:]))
	arrayLengthChainedClassSeqRuleSet := int(binary.BigEndian.Uint16(src[10:]))
	n += 12

	{

		if offsetCoverage != 0 { // ignore null offset
			if L := len(src); L < offsetCoverage {
				return item, 0, fmt.Errorf("reading ChainedContextualPos2: "+"EOF: expected length: %d, got %d", offsetCoverage, L)
			}

			var (
				err  error
				read int
			)
			item.coverage, read, err = ParseCoverage(src[offsetCoverage:])
			if err != nil {
				return item, 0, fmt.Errorf("reading ChainedContextualPos2: %s", err)
			}
			offsetCoverage += read
		}
	}
	{

		if offsetBacktrackClassDef != 0 { // ignore null offset
			if L := len(src); L < offsetBacktrackClassDef {
				return item, 0, fmt.Errorf("reading ChainedContextualPos2: "+"EOF: expected length: %d, got %d", offsetBacktrackClassDef, L)
			}

			var (
				err  error
				read int
			)
			item.BacktrackClassDef, read, err = ParseClassDef(src[offsetBacktrackClassDef:])
			if err != nil {
				return item, 0, fmt.Errorf("reading ChainedContextualPos2: %s", err)
			}
			offsetBacktrackClassDef += read
		}
	}
	{

		if offsetInputClassDef != 0 { // ignore null offset
			if L := len(src); L < offsetInputClassDef {
				return item, 0, fmt.Errorf("reading ChainedContextualPos2: "+"EOF: expected length: %d, got %d", offsetInputClassDef, L)
			}

			var (
				err  error
				read int
			)
			item.InputClassDef, read, err = ParseClassDef(src[offsetInputClassDef:])
			if err != nil {
				return item, 0, fmt.Errorf("reading ChainedContextualPos2: %s", err)
			}
			offsetInputClassDef += read
		}
	}
	{

		if offsetLookaheadClassDef != 0 { // ignore null offset
			if L := len(src); L < offsetLookaheadClassDef {
				return item, 0, fmt.Errorf("reading ChainedContextualPos2: "+"EOF: expected length: %d, got %d", offsetLookaheadClassDef, L)
			}

			var (
				err  error
				read int
			)
			item.LookaheadClassDef, read, err = ParseClassDef(src[offsetLookaheadClassDef:])
			if err != nil {
				return item, 0, fmt.Errorf("reading ChainedContextualPos2: %s", err)
			}
			offsetLookaheadClassDef += read
		}
	}
	{

		if L := len(src); L < 12+arrayLengthChainedClassSeqRuleSet*2 {
			return item, 0, fmt.Errorf("reading ChainedContextualPos2: "+"EOF: expected length: %d, got %d", 12+arrayLengthChainedClassSeqRuleSet*2, L)
		}

		item.ChainedClassSeqRuleSet = make([]ChainedSequenceRuleSet, arrayLengthChainedClassSeqRuleSet) // allocation guarded by the previous check
		for i := range item.ChainedClassSeqRuleSet {
			offset := int(binary.BigEndian.Uint16(src[12+i*2:]))
			// ignore null offsets
			if offset == 0 {
				continue
			}

			if L := len(src); L < offset {
				return item, 0, fmt.Errorf("reading ChainedContextualPos2: "+"EOF: expected length: %d, got %d", offset, L)
			}

			var err error
			item.ChainedClassSeqRuleSet[i], _, err = ParseChainedSequenceRuleSet(src[offset:])
			if err != nil {
				return item, 0, fmt.Errorf("reading ChainedContextualPos2: %s", err)
			}
		}
		n += arrayLengthChainedClassSeqRuleSet * 2
	}
	return item, n, nil
}

func ParseChainedContextualPos3(src []byte) (ChainedContextualPos3, int, error) {
	var item ChainedContextualPos3
	n := 0
	if L := len(src); L < 4 {
		return item, 0, fmt.Errorf("reading ChainedContextualPos3: "+"EOF: expected length: 4, got %d", L)
	}
	_ = src[3] // early bound checking
	item.format = binary.BigEndian.Uint16(src[0:])
	arrayLengthBacktrackCoverages := int(binary.BigEndian.Uint16(src[2:]))
	n += 4

	{

		if L := len(src); L < 4+arrayLengthBacktrackCoverages*2 {
			return item, 0, fmt.Errorf("reading ChainedContextualPos3: "+"EOF: expected length: %d, got %d", 4+arrayLengthBacktrackCoverages*2, L)
		}

		item.BacktrackCoverages = make([]Coverage, arrayLengthBacktrackCoverages) // allocation guarded by the previous check
		for i := range item.BacktrackCoverages {
			offset := int(binary.BigEndian.Uint16(src[4+i*2:]))
			// ignore null offsets
			if offset == 0 {
				continue
			}

			if L := len(src); L < offset {
				return item, 0, fmt.Errorf("reading ChainedContextualPos3: "+"EOF: expected length: %d, got %d", offset, L)
			}

			var err error
			item.BacktrackCoverages[i], _, err = ParseCoverage(src[offset:])
			if err != nil {
				return item, 0, fmt.Errorf("reading ChainedContextualPos3: %s", err)
			}
		}
		n += arrayLengthBacktrackCoverages * 2
	}
	if L := len(src); L < n+2 {
		return item, 0, fmt.Errorf("reading ChainedContextualPos3: "+"EOF: expected length: n + 2, got %d", L)
	}
	arrayLengthInputCoverages := int(binary.BigEndian.Uint16(src[n:]))
	n += 2

	{

		if L := len(src); L < n+arrayLengthInputCoverages*2 {
			return item, 0, fmt.Errorf("reading ChainedContextualPos3: "+"EOF: expected length: %d, got %d", n+arrayLengthInputCoverages*2, L)
		}

		item.InputCoverages = make([]Coverage, arrayLengthInputCoverages) // allocation guarded by the previous check
		for i := range item.InputCoverages {
			offset := int(binary.BigEndian.Uint16(src[n+i*2:]))
			// ignore null offsets
			if offset == 0 {
				continue
			}

			if L := len(src); L < offset {
				return item, 0, fmt.Errorf("reading ChainedContextualPos3: "+"EOF: expected length: %d, got %d", offset, L)
			}

			var err error
			item.InputCoverages[i], _, err = ParseCoverage(src[offset:])
			if err != nil {
				return item, 0, fmt.Errorf("reading ChainedContextualPos3: %s", err)
			}
		}
		n += arrayLengthInputCoverages * 2
	}
	if L := len(src); L < n+2 {
		return item, 0, fmt.Errorf("reading ChainedContextualPos3: "+"EOF: expected length: n + 2, got %d", L)
	}
	arrayLengthLookaheadCoverages := int(binary.BigEndian.Uint16(src[n:]))
	n += 2

	{

		if L := len(src); L < n+arrayLengthLookaheadCoverages*2 {
			return item, 0, fmt.Errorf("reading ChainedContextualPos3: "+"EOF: expected length: %d, got %d", n+arrayLengthLookaheadCoverages*2, L)
		}

		item.LookaheadCoverages = make([]Coverage, arrayLengthLookaheadCoverages) // allocation guarded by the previous check
		for i := range item.LookaheadCoverages {
			offset := int(binary.BigEndian.Uint16(src[n+i*2:]))
			// ignore null offsets
			if offset == 0 {
				continue
			}

			if L := len(src); L < offset {
				return item, 0, fmt.Errorf("reading ChainedContextualPos3: "+"EOF: expected length: %d, got %d", offset, L)
			}

			var err error
			item.LookaheadCoverages[i], _, err = ParseCoverage(src[offset:])
			if err != nil {
				return item, 0, fmt.Errorf("reading ChainedContextualPos3: %s", err)
			}
		}
		n += arrayLengthLookaheadCoverages * 2
	}
	if L := len(src); L < n+2 {
		return item, 0, fmt.Errorf("reading ChainedContextualPos3: "+"EOF: expected length: n + 2, got %d", L)
	}
	arrayLengthSeqLookupRecords := int(binary.BigEndian.Uint16(src[n:]))
	n += 2

	{

		if L := len(src); L < n+arrayLengthSeqLookupRecords*4 {
			return item, 0, fmt.Errorf("reading ChainedContextualPos3: "+"EOF: expected length: %d, got %d", n+arrayLengthSeqLookupRecords*4, L)
		}

		item.SeqLookupRecords = make([]SequenceLookupRecord, arrayLengthSeqLookupRecords) // allocation guarded by the previous check
		for i := range item.SeqLookupRecords {
			item.SeqLookupRecords[i].mustParse(src[n+i*4:])
		}
		n += arrayLengthSeqLookupRecords * 4
	}
	return item, n, nil
}

func ParseChainedContextualPosITF(src []byte) (ChainedContextualPosITF, int, error) {
	var item ChainedContextualPosITF

	if L := len(src); L < 2 {
		return item, 0, fmt.Errorf("reading ChainedContextualPosITF: "+"EOF: expected length: 2, got %d", L)
	}
	format := uint16(binary.BigEndian.Uint16(src[0:]))
	var (
		read int
		err  error
	)
	switch format {
	case 1:
		item, read, err = ParseChainedContextualPos1(src[0:])
	case 2:
		item, read, err = ParseChainedContextualPos2(src[0:])
	case 3:
		item, read, err = ParseChainedContextualPos3(src[0:])
	default:
		err = fmt.Errorf("unsupported ChainedContextualPosITF format %d", format)
	}
	if err != nil {
		return item, 0, fmt.Errorf("reading ChainedContextualPosITF: %s", err)
	}

	return item, read, nil
}

func ParseChainedSequenceRule(src []byte) (ChainedSequenceRule, int, error) {
	var item ChainedSequenceRule
	n := 0
	if L := len(src); L < 2 {
		return item, 0, fmt.Errorf("reading ChainedSequenceRule: "+"EOF: expected length: 2, got %d", L)
	}
	arrayLengthBacktrackSequence := int(binary.BigEndian.Uint16(src[0:]))
	n += 2

	{

		if L := len(src); L < 2+arrayLengthBacktrackSequence*2 {
			return item, 0, fmt.Errorf("reading ChainedSequenceRule: "+"EOF: expected length: %d, got %d", 2+arrayLengthBacktrackSequence*2, L)
		}

		item.BacktrackSequence = make([]uint16, arrayLengthBacktrackSequence) // allocation guarded by the previous check
		for i := range item.BacktrackSequence {
			item.BacktrackSequence[i] = binary.BigEndian.Uint16(src[2+i*2:])
		}
		n += arrayLengthBacktrackSequence * 2
	}
	if L := len(src); L < n+2 {
		return item, 0, fmt.Errorf("reading ChainedSequenceRule: "+"EOF: expected length: n + 2, got %d", L)
	}
	item.inputGlyphCount = binary.BigEndian.Uint16(src[n:])
	n += 2

	{
		arrayLength := int(item.inputGlyphCount - 1)

		if L := len(src); L < n+arrayLength*2 {
			return item, 0, fmt.Errorf("reading ChainedSequenceRule: "+"EOF: expected length: %d, got %d", n+arrayLength*2, L)
		}

		item.InputSequence = make([]uint16, arrayLength) // allocation guarded by the previous check
		for i := range item.InputSequence {
			item.InputSequence[i] = binary.BigEndian.Uint16(src[n+i*2:])
		}
		n += arrayLength * 2
	}
	if L := len(src); L < n+2 {
		return item, 0, fmt.Errorf("reading ChainedSequenceRule: "+"EOF: expected length: n + 2, got %d", L)
	}
	arrayLengthLookaheadSequence := int(binary.BigEndian.Uint16(src[n:]))
	n += 2

	{

		if L := len(src); L < n+arrayLengthLookaheadSequence*2 {
			return item, 0, fmt.Errorf("reading ChainedSequenceRule: "+"EOF: expected length: %d, got %d", n+arrayLengthLookaheadSequence*2, L)
		}

		item.LookaheadSequence = make([]uint16, arrayLengthLookaheadSequence) // allocation guarded by the previous check
		for i := range item.LookaheadSequence {
			item.LookaheadSequence[i] = binary.BigEndian.Uint16(src[n+i*2:])
		}
		n += arrayLengthLookaheadSequence * 2
	}
	if L := len(src); L < n+2 {
		return item, 0, fmt.Errorf("reading ChainedSequenceRule: "+"EOF: expected length: n + 2, got %d", L)
	}
	arrayLengthSeqLookupRecords := int(binary.BigEndian.Uint16(src[n:]))
	n += 2

	{

		if L := len(src); L < n+arrayLengthSeqLookupRecords*4 {
			return item, 0, fmt.Errorf("reading ChainedSequenceRule: "+"EOF: expected length: %d, got %d", n+arrayLengthSeqLookupRecords*4, L)
		}

		item.SeqLookupRecords = make([]SequenceLookupRecord, arrayLengthSeqLookupRecords) // allocation guarded by the previous check
		for i := range item.SeqLookupRecords {
			item.SeqLookupRecords[i].mustParse(src[n+i*4:])
		}
		n += arrayLengthSeqLookupRecords * 4
	}
	return item, n, nil
}

func ParseChainedSequenceRuleSet(src []byte) (ChainedSequenceRuleSet, int, error) {
	var item ChainedSequenceRuleSet
	n := 0
	if L := len(src); L < 2 {
		return item, 0, fmt.Errorf("reading ChainedSequenceRuleSet: "+"EOF: expected length: 2, got %d", L)
	}
	arrayLengthChainedSeqRules := int(binary.BigEndian.Uint16(src[0:]))
	n += 2

	{

		if L := len(src); L < 2+arrayLengthChainedSeqRules*2 {
			return item, 0, fmt.Errorf("reading ChainedSequenceRuleSet: "+"EOF: expected length: %d, got %d", 2+arrayLengthChainedSeqRules*2, L)
		}

		item.ChainedSeqRules = make([]ChainedSequenceRule, arrayLengthChainedSeqRules) // allocation guarded by the previous check
		for i := range item.ChainedSeqRules {
			offset := int(binary.BigEndian.Uint16(src[2+i*2:]))
			// ignore null offsets
			if offset == 0 {
				continue
			}

			if L := len(src); L < offset {
				return item, 0, fmt.Errorf("reading ChainedSequenceRuleSet: "+"EOF: expected length: %d, got %d", offset, L)
			}

			var err error
			item.ChainedSeqRules[i], _, err = ParseChainedSequenceRule(src[offset:])
			if err != nil {
				return item, 0, fmt.Errorf("reading ChainedSequenceRuleSet: %s", err)
			}
		}
		n += arrayLengthChainedSeqRules * 2
	}
	return item, n, nil
}

func ParseContextualPos(src []byte) (ContextualPos, int, error) {
	var item ContextualPos
	n := 0
	{
		var (
			err  error
			read int
		)
		item.Data, read, err = ParseContextualPosITF(src[0:])
		if err != nil {
			return item, 0, fmt.Errorf("reading ContextualPos: %s", err)
		}
		n += read
	}
	return item, n, nil
}

func ParseContextualPos1(src []byte) (ContextualPos1, int, error) {
	var item ContextualPos1
	n := 0
	if L := len(src); L < 6 {
		return item, 0, fmt.Errorf("reading ContextualPos1: "+"EOF: expected length: 6, got %d", L)
	}
	_ = src[5] // early bound checking
	item.format = binary.BigEndian.Uint16(src[0:])
	offsetCoverage := int(binary.BigEndian.Uint16(src[2:]))
	arrayLengthSeqRuleSet := int(binary.BigEndian.Uint16(src[4:]))
	n += 6

	{

		if offsetCoverage != 0 { // ignore null offset
			if L := len(src); L < offsetCoverage {
				return item, 0, fmt.Errorf("reading ContextualPos1: "+"EOF: expected length: %d, got %d", offsetCoverage, L)
			}

			var (
				err  error
				read int
			)
			item.coverage, read, err = ParseCoverage(src[offsetCoverage:])
			if err != nil {
				return item, 0, fmt.Errorf("reading ContextualPos1: %s", err)
			}
			offsetCoverage += read
		}
	}
	{

		if L := len(src); L < 6+arrayLengthSeqRuleSet*2 {
			return item, 0, fmt.Errorf("reading ContextualPos1: "+"EOF: expected length: %d, got %d", 6+arrayLengthSeqRuleSet*2, L)
		}

		item.SeqRuleSet = make([]SequenceRuleSet, arrayLengthSeqRuleSet) // allocation guarded by the previous check
		for i := range item.SeqRuleSet {
			offset := int(binary.BigEndian.Uint16(src[6+i*2:]))
			// ignore null offsets
			if offset == 0 {
				continue
			}

			if L := len(src); L < offset {
				return item, 0, fmt.Errorf("reading ContextualPos1: "+"EOF: expected length: %d, got %d", offset, L)
			}

			var err error
			item.SeqRuleSet[i], _, err = ParseSequenceRuleSet(src[offset:])
			if err != nil {
				return item, 0, fmt.Errorf("reading ContextualPos1: %s", err)
			}
		}
		n += arrayLengthSeqRuleSet * 2
	}
	return item, n, nil
}

func ParseContextualPos2(src []byte) (ContextualPos2, int, error) {
	var item ContextualPos2
	n := 0
	if L := len(src); L < 8 {
		return item, 0, fmt.Errorf("reading ContextualPos2: "+"EOF: expected length: 8, got %d", L)
	}
	_ = src[7] // early bound checking
	item.format = binary.BigEndian.Uint16(src[0:])
	offsetCoverage := int(binary.BigEndian.Uint16(src[2:]))
	offsetClassDef := int(binary.BigEndian.Uint16(src[4:]))
	arrayLengthClassSeqRuleSet := int(binary.BigEndian.Uint16(src[6:]))
	n += 8

	{

		if offsetCoverage != 0 { // ignore null offset
			if L := len(src); L < offsetCoverage {
				return item, 0, fmt.Errorf("reading ContextualPos2: "+"EOF: expected length: %d, got %d", offsetCoverage, L)
			}

			var (
				err  error
				read int
			)
			item.coverage, read, err = ParseCoverage(src[offsetCoverage:])
			if err != nil {
				return item, 0, fmt.Errorf("reading ContextualPos2: %s", err)
			}
			offsetCoverage += read
		}
	}
	{

		if offsetClassDef != 0 { // ignore null offset
			if L := len(src); L < offsetClassDef {
				return item, 0, fmt.Errorf("reading ContextualPos2: "+"EOF: expected length: %d, got %d", offsetClassDef, L)
			}

			var (
				err  error
				read int
			)
			item.ClassDef, read, err = ParseClassDef(src[offsetClassDef:])
			if err != nil {
				return item, 0, fmt.Errorf("reading ContextualPos2: %s", err)
			}
			offsetClassDef += read
		}
	}
	{

		if L := len(src); L < 8+arrayLengthClassSeqRuleSet*2 {
			return item, 0, fmt.Errorf("reading ContextualPos2: "+"EOF: expected length: %d, got %d", 8+arrayLengthClassSeqRuleSet*2, L)
		}

		item.ClassSeqRuleSet = make([]SequenceRuleSet, arrayLengthClassSeqRuleSet) // allocation guarded by the previous check
		for i := range item.ClassSeqRuleSet {
			offset := int(binary.BigEndian.Uint16(src[8+i*2:]))
			// ignore null offsets
			if offset == 0 {
				continue
			}

			if L := len(src); L < offset {
				return item, 0, fmt.Errorf("reading ContextualPos2: "+"EOF: expected length: %d, got %d", offset, L)
			}

			var err error
			item.ClassSeqRuleSet[i], _, err = ParseSequenceRuleSet(src[offset:])
			if err != nil {
				return item, 0, fmt.Errorf("reading ContextualPos2: %s", err)
			}
		}
		n += arrayLengthClassSeqRuleSet * 2
	}
	return item, n, nil
}

func ParseContextualPos3(src []byte) (ContextualPos3, int, error) {
	var item ContextualPos3
	n := 0
	if L := len(src); L < 6 {
		return item, 0, fmt.Errorf("reading ContextualPos3: "+"EOF: expected length: 6, got %d", L)
	}
	_ = src[5] // early bound checking
	item.format = binary.BigEndian.Uint16(src[0:])
	item.glyphCount = binary.BigEndian.Uint16(src[2:])
	item.seqLookupCount = binary.BigEndian.Uint16(src[4:])
	n += 6

	{
		arrayLength := int(item.glyphCount)

		if L := len(src); L < 6+arrayLength*2 {
			return item, 0, fmt.Errorf("reading ContextualPos3: "+"EOF: expected length: %d, got %d", 6+arrayLength*2, L)
		}

		item.Coverages = make([]Coverage, arrayLength) // allocation guarded by the previous check
		for i := range item.Coverages {
			offset := int(binary.BigEndian.Uint16(src[6+i*2:]))
			// ignore null offsets
			if offset == 0 {
				continue
			}

			if L := len(src); L < offset {
				return item, 0, fmt.Errorf("reading ContextualPos3: "+"EOF: expected length: %d, got %d", offset, L)
			}

			var err error
			item.Coverages[i], _, err = ParseCoverage(src[offset:])
			if err != nil {
				return item, 0, fmt.Errorf("reading ContextualPos3: %s", err)
			}
		}
		n += arrayLength * 2
	}
	{
		arrayLength := int(item.seqLookupCount)

		if L := len(src); L < n+arrayLength*4 {
			return item, 0, fmt.Errorf("reading ContextualPos3: "+"EOF: expected length: %d, got %d", n+arrayLength*4, L)
		}

		item.SeqLookupRecords = make([]SequenceLookupRecord, arrayLength) // allocation guarded by the previous check
		for i := range item.SeqLookupRecords {
			item.SeqLookupRecords[i].mustParse(src[n+i*4:])
		}
		n += arrayLength * 4
	}
	return item, n, nil
}

func ParseContextualPosITF(src []byte) (ContextualPosITF, int, error) {
	var item ContextualPosITF

	if L := len(src); L < 2 {
		return item, 0, fmt.Errorf("reading ContextualPosITF: "+"EOF: expected length: 2, got %d", L)
	}
	format := uint16(binary.BigEndian.Uint16(src[0:]))
	var (
		read int
		err  error
	)
	switch format {
	case 1:
		item, read, err = ParseContextualPos1(src[0:])
	case 2:
		item, read, err = ParseContextualPos2(src[0:])
	case 3:
		item, read, err = ParseContextualPos3(src[0:])
	default:
		err = fmt.Errorf("unsupported ContextualPosITF format %d", format)
	}
	if err != nil {
		return item, 0, fmt.Errorf("reading ContextualPosITF: %s", err)
	}

	return item, read, nil
}

func ParseCursivePos(src []byte) (CursivePos, int, error) {
	var item CursivePos
	n := 0
	if L := len(src); L < 6 {
		return item, 0, fmt.Errorf("reading CursivePos: "+"EOF: expected length: 6, got %d", L)
	}
	_ = src[5] // early bound checking
	item.posFormat = binary.BigEndian.Uint16(src[0:])
	offsetCoverage := int(binary.BigEndian.Uint16(src[2:]))
	arrayLengthEntryExitRecords := int(binary.BigEndian.Uint16(src[4:]))
	n += 6

	{

		if offsetCoverage != 0 { // ignore null offset
			if L := len(src); L < offsetCoverage {
				return item, 0, fmt.Errorf("reading CursivePos: "+"EOF: expected length: %d, got %d", offsetCoverage, L)
			}

			var (
				err  error
				read int
			)
			item.coverage, read, err = ParseCoverage(src[offsetCoverage:])
			if err != nil {
				return item, 0, fmt.Errorf("reading CursivePos: %s", err)
			}
			offsetCoverage += read
		}
	}
	{

		if L := len(src); L < 6+arrayLengthEntryExitRecords*4 {
			return item, 0, fmt.Errorf("reading CursivePos: "+"EOF: expected length: %d, got %d", 6+arrayLengthEntryExitRecords*4, L)
		}

		item.entryExitRecords = make([]entryExitRecord, arrayLengthEntryExitRecords) // allocation guarded by the previous check
		for i := range item.entryExitRecords {
			item.entryExitRecords[i].mustParse(src[6+i*4:])
		}
		n += arrayLengthEntryExitRecords * 4
	}
	{

		err := item.parseEntryExits(src[:])
		if err != nil {
			return item, 0, fmt.Errorf("reading CursivePos: %s", err)
		}
	}
	return item, n, nil
}

func ParseDeviceTableHeader(src []byte) (DeviceTableHeader, int, error) {
	var item DeviceTableHeader
	n := 0
	if L := len(src); L < 6 {
		return item, 0, fmt.Errorf("reading DeviceTableHeader: "+"EOF: expected length: 6, got %d", L)
	}
	item.mustParse(src)
	n += 6
	return item, n, nil
}

func ParseEntryExit(src []byte) (EntryExit, int, error) {
	var item EntryExit
	n := 0
	{
		var (
			err  error
			read int
		)
		item.EntryAnchor, read, err = ParseAnchor(src[0:])
		if err != nil {
			return item, 0, fmt.Errorf("reading EntryExit: %s", err)
		}
		n += read
	}
	{
		var (
			err  error
			read int
		)
		item.ExitAnchor, read, err = ParseAnchor(src[n:])
		if err != nil {
			return item, 0, fmt.Errorf("reading EntryExit: %s", err)
		}
		n += read
	}
	return item, n, nil
}

func ParseExtensionPos(src []byte) (ExtensionPos, int, error) {
	var item ExtensionPos
	n := 0
	if L := len(src); L < 8 {
		return item, 0, fmt.Errorf("reading ExtensionPos: "+"EOF: expected length: 8, got %d", L)
	}
	_ = src[7] // early bound checking
	item.substFormat = binary.BigEndian.Uint16(src[0:])
	item.ExtensionLookupType = binary.BigEndian.Uint16(src[2:])
	item.ExtensionOffset = Offset32(binary.BigEndian.Uint32(src[4:]))
	n += 8

	{

		item.RawData = src[0:]
		n = len(src)
	}
	return item, n, nil
}

func ParseLigatureArray(src []byte, offsetsCount int) (LigatureArray, int, error) {
	var item LigatureArray
	n := 0
	if L := len(src); L < 2 {
		return item, 0, fmt.Errorf("reading LigatureArray: "+"EOF: expected length: 2, got %d", L)
	}
	arrayLengthLigatureAttachs := int(binary.BigEndian.Uint16(src[0:]))
	n += 2

	{

		if L := len(src); L < 2+arrayLengthLigatureAttachs*2 {
			return item, 0, fmt.Errorf("reading LigatureArray: "+"EOF: expected length: %d, got %d", 2+arrayLengthLigatureAttachs*2, L)
		}

		item.LigatureAttachs = make([]LigatureAttach, arrayLengthLigatureAttachs) // allocation guarded by the previous check
		for i := range item.LigatureAttachs {
			offset := int(binary.BigEndian.Uint16(src[2+i*2:]))
			// ignore null offsets
			if offset == 0 {
				continue
			}

			if L := len(src); L < offset {
				return item, 0, fmt.Errorf("reading LigatureArray: "+"EOF: expected length: %d, got %d", offset, L)
			}

			var err error
			item.LigatureAttachs[i], _, err = ParseLigatureAttach(src[offset:], offsetsCount)
			if err != nil {
				return item, 0, fmt.Errorf("reading LigatureArray: %s", err)
			}
		}
		n += arrayLengthLigatureAttachs * 2
	}
	return item, n, nil
}

func ParseLigatureAttach(src []byte, offsetsCount int) (LigatureAttach, int, error) {
	var item LigatureAttach
	n := 0
	if L := len(src); L < 2 {
		return item, 0, fmt.Errorf("reading LigatureAttach: "+"EOF: expected length: 2, got %d", L)
	}
	arrayLengthComponentRecords := int(binary.BigEndian.Uint16(src[0:]))
	n += 2

	{

		offset := 2
		for i := 0; i < arrayLengthComponentRecords; i++ {
			elem, read, err := parseAnchorOffsets(src[offset:], offsetsCount)
			if err != nil {
				return item, 0, fmt.Errorf("reading LigatureAttach: %s", err)
			}
			item.componentRecords = append(item.componentRecords, elem)
			offset += read
		}
		n = offset
	}
	{

		item.data = src[0:]
		n = len(src)
	}
	return item, n, nil
}

func ParseMark2Array(src []byte, offsetsCount int) (Mark2Array, int, error) {
	var item Mark2Array
	n := 0
	if L := len(src); L < 2 {
		return item, 0, fmt.Errorf("reading Mark2Array: "+"EOF: expected length: 2, got %d", L)
	}
	arrayLengthMark2Records := int(binary.BigEndian.Uint16(src[0:]))
	n += 2

	{

		offset := 2
		for i := 0; i < arrayLengthMark2Records; i++ {
			elem, read, err := parseAnchorOffsets(src[offset:], offsetsCount)
			if err != nil {
				return item, 0, fmt.Errorf("reading Mark2Array: %s", err)
			}
			item.mark2Records = append(item.mark2Records, elem)
			offset += read
		}
		n = offset
	}
	{

		item.data = src[0:]
		n = len(src)
	}
	return item, n, nil
}

func ParseMarkArray(src []byte) (MarkArray, int, error) {
	var item MarkArray
	n := 0
	if L := len(src); L < 2 {
		return item, 0, fmt.Errorf("reading MarkArray: "+"EOF: expected length: 2, got %d", L)
	}
	arrayLengthMarkRecords := int(binary.BigEndian.Uint16(src[0:]))
	n += 2

	{

		if L := len(src); L < 2+arrayLengthMarkRecords*4 {
			return item, 0, fmt.Errorf("reading MarkArray: "+"EOF: expected length: %d, got %d", 2+arrayLengthMarkRecords*4, L)
		}

		item.MarkRecords = make([]MarkRecord, arrayLengthMarkRecords) // allocation guarded by the previous check
		for i := range item.MarkRecords {
			item.MarkRecords[i].mustParse(src[2+i*4:])
		}
		n += arrayLengthMarkRecords * 4
	}
	{

		err := item.parseMarkAnchors(src[:])
		if err != nil {
			return item, 0, fmt.Errorf("reading MarkArray: %s", err)
		}
	}
	return item, n, nil
}

func ParseMarkBasePos(src []byte) (MarkBasePos, int, error) {
	var item MarkBasePos
	n := 0
	if L := len(src); L < 12 {
		return item, 0, fmt.Errorf("reading MarkBasePos: "+"EOF: expected length: 12, got %d", L)
	}
	_ = src[11] // early bound checking
	item.posFormat = binary.BigEndian.Uint16(src[0:])
	offsetMarkCoverage := int(binary.BigEndian.Uint16(src[2:]))
	offsetBaseCoverage := int(binary.BigEndian.Uint16(src[4:]))
	item.markClassCount = binary.BigEndian.Uint16(src[6:])
	offsetMarkArray := int(binary.BigEndian.Uint16(src[8:]))
	offsetBaseArray := int(binary.BigEndian.Uint16(src[10:]))
	n += 12

	{

		if offsetMarkCoverage != 0 { // ignore null offset
			if L := len(src); L < offsetMarkCoverage {
				return item, 0, fmt.Errorf("reading MarkBasePos: "+"EOF: expected length: %d, got %d", offsetMarkCoverage, L)
			}

			var (
				err  error
				read int
			)
			item.markCoverage, read, err = ParseCoverage(src[offsetMarkCoverage:])
			if err != nil {
				return item, 0, fmt.Errorf("reading MarkBasePos: %s", err)
			}
			offsetMarkCoverage += read
		}
	}
	{

		if offsetBaseCoverage != 0 { // ignore null offset
			if L := len(src); L < offsetBaseCoverage {
				return item, 0, fmt.Errorf("reading MarkBasePos: "+"EOF: expected length: %d, got %d", offsetBaseCoverage, L)
			}

			var (
				err  error
				read int
			)
			item.BaseCoverage, read, err = ParseCoverage(src[offsetBaseCoverage:])
			if err != nil {
				return item, 0, fmt.Errorf("reading MarkBasePos: %s", err)
			}
			offsetBaseCoverage += read
		}
	}
	{

		if offsetMarkArray != 0 { // ignore null offset
			if L := len(src); L < offsetMarkArray {
				return item, 0, fmt.Errorf("reading MarkBasePos: "+"EOF: expected length: %d, got %d", offsetMarkArray, L)
			}

			var err error
			item.MarkArray, _, err = ParseMarkArray(src[offsetMarkArray:])
			if err != nil {
				return item, 0, fmt.Errorf("reading MarkBasePos: %s", err)
			}

		}
	}
	{

		if offsetBaseArray != 0 { // ignore null offset
			if L := len(src); L < offsetBaseArray {
				return item, 0, fmt.Errorf("reading MarkBasePos: "+"EOF: expected length: %d, got %d", offsetBaseArray, L)
			}

			var err error
			item.BaseArray, _, err = ParseBaseArray(src[offsetBaseArray:], int(item.markClassCount))
			if err != nil {
				return item, 0, fmt.Errorf("reading MarkBasePos: %s", err)
			}

		}
	}
	return item, n, nil
}

func ParseMarkLigPos(src []byte) (MarkLigPos, int, error) {
	var item MarkLigPos
	n := 0
	if L := len(src); L < 12 {
		return item, 0, fmt.Errorf("reading MarkLigPos: "+"EOF: expected length: 12, got %d", L)
	}
	_ = src[11] // early bound checking
	item.posFormat = binary.BigEndian.Uint16(src[0:])
	offsetMarkCoverage := int(binary.BigEndian.Uint16(src[2:]))
	offsetLigatureCoverage := int(binary.BigEndian.Uint16(src[4:]))
	item.MarkClassCount = binary.BigEndian.Uint16(src[6:])
	offsetMarkArray := int(binary.BigEndian.Uint16(src[8:]))
	offsetLigatureArray := int(binary.BigEndian.Uint16(src[10:]))
	n += 12

	{

		if offsetMarkCoverage != 0 { // ignore null offset
			if L := len(src); L < offsetMarkCoverage {
				return item, 0, fmt.Errorf("reading MarkLigPos: "+"EOF: expected length: %d, got %d", offsetMarkCoverage, L)
			}

			var (
				err  error
				read int
			)
			item.MarkCoverage, read, err = ParseCoverage(src[offsetMarkCoverage:])
			if err != nil {
				return item, 0, fmt.Errorf("reading MarkLigPos: %s", err)
			}
			offsetMarkCoverage += read
		}
	}
	{

		if offsetLigatureCoverage != 0 { // ignore null offset
			if L := len(src); L < offsetLigatureCoverage {
				return item, 0, fmt.Errorf("reading MarkLigPos: "+"EOF: expected length: %d, got %d", offsetLigatureCoverage, L)
			}

			var (
				err  error
				read int
			)
			item.LigatureCoverage, read, err = ParseCoverage(src[offsetLigatureCoverage:])
			if err != nil {
				return item, 0, fmt.Errorf("reading MarkLigPos: %s", err)
			}
			offsetLigatureCoverage += read
		}
	}
	{

		if offsetMarkArray != 0 { // ignore null offset
			if L := len(src); L < offsetMarkArray {
				return item, 0, fmt.Errorf("reading MarkLigPos: "+"EOF: expected length: %d, got %d", offsetMarkArray, L)
			}

			var err error
			item.MarkArray, _, err = ParseMarkArray(src[offsetMarkArray:])
			if err != nil {
				return item, 0, fmt.Errorf("reading MarkLigPos: %s", err)
			}

		}
	}
	{

		if offsetLigatureArray != 0 { // ignore null offset
			if L := len(src); L < offsetLigatureArray {
				return item, 0, fmt.Errorf("reading MarkLigPos: "+"EOF: expected length: %d, got %d", offsetLigatureArray, L)
			}

			var err error
			item.LigatureArray, _, err = ParseLigatureArray(src[offsetLigatureArray:], int(item.MarkClassCount))
			if err != nil {
				return item, 0, fmt.Errorf("reading MarkLigPos: %s", err)
			}

		}
	}
	return item, n, nil
}

func ParseMarkMarkPos(src []byte) (MarkMarkPos, int, error) {
	var item MarkMarkPos
	n := 0
	if L := len(src); L < 12 {
		return item, 0, fmt.Errorf("reading MarkMarkPos: "+"EOF: expected length: 12, got %d", L)
	}
	_ = src[11] // early bound checking
	item.PosFormat = binary.BigEndian.Uint16(src[0:])
	offsetMark1Coverage := int(binary.BigEndian.Uint16(src[2:]))
	offsetMark2Coverage := int(binary.BigEndian.Uint16(src[4:]))
	item.MarkClassCount = binary.BigEndian.Uint16(src[6:])
	offsetMark1Array := int(binary.BigEndian.Uint16(src[8:]))
	offsetMark2Array := int(binary.BigEndian.Uint16(src[10:]))
	n += 12

	{

		if offsetMark1Coverage != 0 { // ignore null offset
			if L := len(src); L < offsetMark1Coverage {
				return item, 0, fmt.Errorf("reading MarkMarkPos: "+"EOF: expected length: %d, got %d", offsetMark1Coverage, L)
			}

			var (
				err  error
				read int
			)
			item.Mark1Coverage, read, err = ParseCoverage(src[offsetMark1Coverage:])
			if err != nil {
				return item, 0, fmt.Errorf("reading MarkMarkPos: %s", err)
			}
			offsetMark1Coverage += read
		}
	}
	{

		if offsetMark2Coverage != 0 { // ignore null offset
			if L := len(src); L < offsetMark2Coverage {
				return item, 0, fmt.Errorf("reading MarkMarkPos: "+"EOF: expected length: %d, got %d", offsetMark2Coverage, L)
			}

			var (
				err  error
				read int
			)
			item.Mark2Coverage, read, err = ParseCoverage(src[offsetMark2Coverage:])
			if err != nil {
				return item, 0, fmt.Errorf("reading MarkMarkPos: %s", err)
			}
			offsetMark2Coverage += read
		}
	}
	{

		if offsetMark1Array != 0 { // ignore null offset
			if L := len(src); L < offsetMark1Array {
				return item, 0, fmt.Errorf("reading MarkMarkPos: "+"EOF: expected length: %d, got %d", offsetMark1Array, L)
			}

			var err error
			item.Mark1Array, _, err = ParseMarkArray(src[offsetMark1Array:])
			if err != nil {
				return item, 0, fmt.Errorf("reading MarkMarkPos: %s", err)
			}

		}
	}
	{

		if offsetMark2Array != 0 { // ignore null offset
			if L := len(src); L < offsetMark2Array {
				return item, 0, fmt.Errorf("reading MarkMarkPos: "+"EOF: expected length: %d, got %d", offsetMark2Array, L)
			}

			var err error
			item.Mark2Array, _, err = ParseMark2Array(src[offsetMark2Array:], int(item.MarkClassCount))
			if err != nil {
				return item, 0, fmt.Errorf("reading MarkMarkPos: %s", err)
			}

		}
	}
	return item, n, nil
}

func ParsePairPos(src []byte) (PairPos, int, error) {
	var item PairPos
	n := 0
	{
		var (
			err  error
			read int
		)
		item.Data, read, err = ParsePairPosData(src[0:])
		if err != nil {
			return item, 0, fmt.Errorf("reading PairPos: %s", err)
		}
		n += read
	}
	return item, n, nil
}

func ParsePairPosData(src []byte) (PairPosData, int, error) {
	var item PairPosData

	if L := len(src); L < 2 {
		return item, 0, fmt.Errorf("reading PairPosData: "+"EOF: expected length: 2, got %d", L)
	}
	format := uint16(binary.BigEndian.Uint16(src[0:]))
	var (
		read int
		err  error
	)
	switch format {
	case 1:
		item, read, err = ParsePairPosData1(src[0:])
	case 2:
		item, read, err = ParsePairPosData2(src[0:])
	default:
		err = fmt.Errorf("unsupported PairPosData format %d", format)
	}
	if err != nil {
		return item, 0, fmt.Errorf("reading PairPosData: %s", err)
	}

	return item, read, nil
}

func ParsePairPosData1(src []byte) (PairPosData1, int, error) {
	var item PairPosData1
	n := 0
	if L := len(src); L < 10 {
		return item, 0, fmt.Errorf("reading PairPosData1: "+"EOF: expected length: 10, got %d", L)
	}
	_ = src[9] // early bound checking
	item.format = binary.BigEndian.Uint16(src[0:])
	offsetCoverage := int(binary.BigEndian.Uint16(src[2:]))
	item.ValueFormat1 = ValueFormat(binary.BigEndian.Uint16(src[4:]))
	item.ValueFormat2 = ValueFormat(binary.BigEndian.Uint16(src[6:]))
	arrayLengthPairSets := int(binary.BigEndian.Uint16(src[8:]))
	n += 10

	{

		if offsetCoverage != 0 { // ignore null offset
			if L := len(src); L < offsetCoverage {
				return item, 0, fmt.Errorf("reading PairPosData1: "+"EOF: expected length: %d, got %d", offsetCoverage, L)
			}

			var (
				err  error
				read int
			)
			item.coverage, read, err = ParseCoverage(src[offsetCoverage:])
			if err != nil {
				return item, 0, fmt.Errorf("reading PairPosData1: %s", err)
			}
			offsetCoverage += read
		}
	}
	{

		if L := len(src); L < 10+arrayLengthPairSets*2 {
			return item, 0, fmt.Errorf("reading PairPosData1: "+"EOF: expected length: %d, got %d", 10+arrayLengthPairSets*2, L)
		}

		item.PairSets = make([]PairSet, arrayLengthPairSets) // allocation guarded by the previous check
		for i := range item.PairSets {
			offset := int(binary.BigEndian.Uint16(src[10+i*2:]))
			// ignore null offsets
			if offset == 0 {
				continue
			}

			if L := len(src); L < offset {
				return item, 0, fmt.Errorf("reading PairPosData1: "+"EOF: expected length: %d, got %d", offset, L)
			}

			var err error
			item.PairSets[i], _, err = ParsePairSet(src[offset:], ValueFormat(item.ValueFormat1), ValueFormat(item.ValueFormat2))
			if err != nil {
				return item, 0, fmt.Errorf("reading PairPosData1: %s", err)
			}
		}
		n += arrayLengthPairSets * 2
	}
	return item, n, nil
}

func ParsePairPosData2(src []byte) (PairPosData2, int, error) {
	var item PairPosData2
	n := 0
	if L := len(src); L < 16 {
		return item, 0, fmt.Errorf("reading PairPosData2: "+"EOF: expected length: 16, got %d", L)
	}
	_ = src[15] // early bound checking
	item.format = binary.BigEndian.Uint16(src[0:])
	offsetCoverage := int(binary.BigEndian.Uint16(src[2:]))
	item.ValueFormat1 = ValueFormat(binary.BigEndian.Uint16(src[4:]))
	item.ValueFormat2 = ValueFormat(binary.BigEndian.Uint16(src[6:]))
	offsetClassDef1 := int(binary.BigEndian.Uint16(src[8:]))
	offsetClassDef2 := int(binary.BigEndian.Uint16(src[10:]))
	item.class1Count = binary.BigEndian.Uint16(src[12:])
	item.class2Count = binary.BigEndian.Uint16(src[14:])
	n += 16

	{

		if offsetCoverage != 0 { // ignore null offset
			if L := len(src); L < offsetCoverage {
				return item, 0, fmt.Errorf("reading PairPosData2: "+"EOF: expected length: %d, got %d", offsetCoverage, L)
			}

			var (
				err  error
				read int
			)
			item.coverage, read, err = ParseCoverage(src[offsetCoverage:])
			if err != nil {
				return item, 0, fmt.Errorf("reading PairPosData2: %s", err)
			}
			offsetCoverage += read
		}
	}
	{

		if offsetClassDef1 != 0 { // ignore null offset
			if L := len(src); L < offsetClassDef1 {
				return item, 0, fmt.Errorf("reading PairPosData2: "+"EOF: expected length: %d, got %d", offsetClassDef1, L)
			}

			var (
				err  error
				read int
			)
			item.ClassDef1, read, err = ParseClassDef(src[offsetClassDef1:])
			if err != nil {
				return item, 0, fmt.Errorf("reading PairPosData2: %s", err)
			}
			offsetClassDef1 += read
		}
	}
	{

		if offsetClassDef2 != 0 { // ignore null offset
			if L := len(src); L < offsetClassDef2 {
				return item, 0, fmt.Errorf("reading PairPosData2: "+"EOF: expected length: %d, got %d", offsetClassDef2, L)
			}

			var (
				err  error
				read int
			)
			item.ClassDef2, read, err = ParseClassDef(src[offsetClassDef2:])
			if err != nil {
				return item, 0, fmt.Errorf("reading PairPosData2: %s", err)
			}
			offsetClassDef2 += read
		}
	}
	{

		item.classData = src[0:]
	}
	return item, n, nil
}

func ParsePairSet(src []byte, valueFormat1 ValueFormat, valueFormat2 ValueFormat) (PairSet, int, error) {
	var item PairSet
	n := 0
	if L := len(src); L < 2 {
		return item, 0, fmt.Errorf("reading PairSet: "+"EOF: expected length: 2, got %d", L)
	}
	item.pairValueCount = binary.BigEndian.Uint16(src[0:])
	n += 2

	{

		err := item.parseData(src[:], valueFormat1, valueFormat2)
		if err != nil {
			return item, 0, fmt.Errorf("reading PairSet: %s", err)
		}
	}
	return item, n, nil
}

func ParseSequenceRule(src []byte) (SequenceRule, int, error) {
	var item SequenceRule
	n := 0
	if L := len(src); L < 4 {
		return item, 0, fmt.Errorf("reading SequenceRule: "+"EOF: expected length: 4, got %d", L)
	}
	_ = src[3] // early bound checking
	item.glyphCount = binary.BigEndian.Uint16(src[0:])
	item.seqLookupCount = binary.BigEndian.Uint16(src[2:])
	n += 4

	{
		arrayLength := int(item.glyphCount - 1)

		if L := len(src); L < 4+arrayLength*2 {
			return item, 0, fmt.Errorf("reading SequenceRule: "+"EOF: expected length: %d, got %d", 4+arrayLength*2, L)
		}

		item.InputSequence = make([]uint16, arrayLength) // allocation guarded by the previous check
		for i := range item.InputSequence {
			item.InputSequence[i] = binary.BigEndian.Uint16(src[4+i*2:])
		}
		n += arrayLength * 2
	}
	{
		arrayLength := int(item.seqLookupCount)

		if L := len(src); L < n+arrayLength*4 {
			return item, 0, fmt.Errorf("reading SequenceRule: "+"EOF: expected length: %d, got %d", n+arrayLength*4, L)
		}

		item.SeqLookupRecords = make([]SequenceLookupRecord, arrayLength) // allocation guarded by the previous check
		for i := range item.SeqLookupRecords {
			item.SeqLookupRecords[i].mustParse(src[n+i*4:])
		}
		n += arrayLength * 4
	}
	return item, n, nil
}

func ParseSequenceRuleSet(src []byte) (SequenceRuleSet, int, error) {
	var item SequenceRuleSet
	n := 0
	if L := len(src); L < 2 {
		return item, 0, fmt.Errorf("reading SequenceRuleSet: "+"EOF: expected length: 2, got %d", L)
	}
	arrayLengthSeqRule := int(binary.BigEndian.Uint16(src[0:]))
	n += 2

	{

		if L := len(src); L < 2+arrayLengthSeqRule*2 {
			return item, 0, fmt.Errorf("reading SequenceRuleSet: "+"EOF: expected length: %d, got %d", 2+arrayLengthSeqRule*2, L)
		}

		item.SeqRule = make([]SequenceRule, arrayLengthSeqRule) // allocation guarded by the previous check
		for i := range item.SeqRule {
			offset := int(binary.BigEndian.Uint16(src[2+i*2:]))
			// ignore null offsets
			if offset == 0 {
				continue
			}

			if L := len(src); L < offset {
				return item, 0, fmt.Errorf("reading SequenceRuleSet: "+"EOF: expected length: %d, got %d", offset, L)
			}

			var err error
			item.SeqRule[i], _, err = ParseSequenceRule(src[offset:])
			if err != nil {
				return item, 0, fmt.Errorf("reading SequenceRuleSet: %s", err)
			}
		}
		n += arrayLengthSeqRule * 2
	}
	return item, n, nil
}

func ParseSinglePos(src []byte) (SinglePos, int, error) {
	var item SinglePos
	n := 0
	{
		var (
			err  error
			read int
		)
		item.Data, read, err = ParseSinglePosData(src[0:])
		if err != nil {
			return item, 0, fmt.Errorf("reading SinglePos: %s", err)
		}
		n += read
	}
	return item, n, nil
}

func ParseSinglePosData(src []byte) (SinglePosData, int, error) {
	var item SinglePosData

	if L := len(src); L < 2 {
		return item, 0, fmt.Errorf("reading SinglePosData: "+"EOF: expected length: 2, got %d", L)
	}
	format := uint16(binary.BigEndian.Uint16(src[0:]))
	var (
		read int
		err  error
	)
	switch format {
	case 1:
		item, read, err = ParseSinglePosData1(src[0:])
	case 2:
		item, read, err = ParseSinglePosData2(src[0:])
	default:
		err = fmt.Errorf("unsupported SinglePosData format %d", format)
	}
	if err != nil {
		return item, 0, fmt.Errorf("reading SinglePosData: %s", err)
	}

	return item, read, nil
}

func ParseSinglePosData1(src []byte) (SinglePosData1, int, error) {
	var item SinglePosData1
	n := 0
	if L := len(src); L < 6 {
		return item, 0, fmt.Errorf("reading SinglePosData1: "+"EOF: expected length: 6, got %d", L)
	}
	_ = src[5] // early bound checking
	item.format = binary.BigEndian.Uint16(src[0:])
	offsetCoverage := int(binary.BigEndian.Uint16(src[2:]))
	item.ValueFormat = ValueFormat(binary.BigEndian.Uint16(src[4:]))
	n += 6

	{

		if offsetCoverage != 0 { // ignore null offset
			if L := len(src); L < offsetCoverage {
				return item, 0, fmt.Errorf("reading SinglePosData1: "+"EOF: expected length: %d, got %d", offsetCoverage, L)
			}

			var (
				err  error
				read int
			)
			item.coverage, read, err = ParseCoverage(src[offsetCoverage:])
			if err != nil {
				return item, 0, fmt.Errorf("reading SinglePosData1: %s", err)
			}
			offsetCoverage += read
		}
	}
	{

		err := item.parseValueRecord(src[:])
		if err != nil {
			return item, 0, fmt.Errorf("reading SinglePosData1: %s", err)
		}
	}
	return item, n, nil
}

func ParseSinglePosData2(src []byte) (SinglePosData2, int, error) {
	var item SinglePosData2
	n := 0
	if L := len(src); L < 8 {
		return item, 0, fmt.Errorf("reading SinglePosData2: "+"EOF: expected length: 8, got %d", L)
	}
	_ = src[7] // early bound checking
	item.format = binary.BigEndian.Uint16(src[0:])
	offsetCoverage := int(binary.BigEndian.Uint16(src[2:]))
	item.ValueFormat = ValueFormat(binary.BigEndian.Uint16(src[4:]))
	item.valueCount = binary.BigEndian.Uint16(src[6:])
	n += 8

	{

		if offsetCoverage != 0 { // ignore null offset
			if L := len(src); L < offsetCoverage {
				return item, 0, fmt.Errorf("reading SinglePosData2: "+"EOF: expected length: %d, got %d", offsetCoverage, L)
			}

			var (
				err  error
				read int
			)
			item.coverage, read, err = ParseCoverage(src[offsetCoverage:])
			if err != nil {
				return item, 0, fmt.Errorf("reading SinglePosData2: %s", err)
			}
			offsetCoverage += read
		}
	}
	{

		err := item.parseValueRecords(src[:])
		if err != nil {
			return item, 0, fmt.Errorf("reading SinglePosData2: %s", err)
		}
	}
	return item, n, nil
}

func (item *SequenceLookupRecord) mustParse(src []byte) {
	_ = src[3] // early bound checking
	item.SequenceIndex = binary.BigEndian.Uint16(src[0:])
	item.LookupListIndex = binary.BigEndian.Uint16(src[2:])
}

func (item *entryExitRecord) mustParse(src []byte) {
	_ = src[3] // early bound checking
	item.entryAnchorOffset = Offset16(binary.BigEndian.Uint16(src[0:]))
	item.exitAnchorOffset = Offset16(binary.BigEndian.Uint16(src[2:]))
}

func parseAnchorOffsets(src []byte, offsetsCount int) (anchorOffsets, int, error) {
	var item anchorOffsets
	n := 0
	{

		if L := len(src); L < offsetsCount*2 {
			return item, 0, fmt.Errorf("reading anchorOffsets: "+"EOF: expected length: %d, got %d", offsetsCount*2, L)
		}

		item.offsets = make([]Offset16, offsetsCount) // allocation guarded by the previous check
		for i := range item.offsets {
			item.offsets[i] = Offset16(binary.BigEndian.Uint16(src[i*2:]))
		}
		n += offsetsCount * 2
	}
	return item, n, nil
}
