// Copyright 2017 The CRT Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.
//
// Code generated by running "go generate". DO NOT EDIT.

// +build windows

package crt // import "modernc.org/ccgo/crt"

import (
	"fmt"
	"os"
	"syscall"
	"unsafe"
)

var (
	modkernel32                   = syscall.NewLazyDLL("kernel32.dll")
	procAreFileApisANSI           = modkernel32.NewProc("AreFileApisANSI")
	procCreateFileA               = modkernel32.NewProc("CreateFileA")
	procCreateFileW               = modkernel32.NewProc("CreateFileW")
	procCreateFileMappingA        = modkernel32.NewProc("CreateFileMappingA")
	procCreateFileMappingW        = modkernel32.NewProc("CreateFileMappingW")
	procCreateMutexW              = modkernel32.NewProc("CreateMutexW")
	procCloseHandle               = modkernel32.NewProc("CloseHandle")
	procDeleteCriticalSection     = modkernel32.NewProc("DeleteCriticalSection")
	procDeleteFileA               = modkernel32.NewProc("DeleteFileA")
	procDeleteFileW               = modkernel32.NewProc("DeleteFileW")
	procEnterCriticalSection      = modkernel32.NewProc("EnterCriticalSection")
	procFlushFileBuffers          = modkernel32.NewProc("FlushFileBuffers")
	procFlushViewOfFile           = modkernel32.NewProc("FlushViewOfFile")
	procFormatMessageA            = modkernel32.NewProc("FormatMessageA")
	procFormatMessageW            = modkernel32.NewProc("FormatMessageW")
	procFreeLibrary               = modkernel32.NewProc("FreeLibrary")
	procGetCurrentProcessId       = modkernel32.NewProc("GetCurrentProcessId")
	procGetDiskFreeSpaceA         = modkernel32.NewProc("GetDiskFreeSpaceA")
	procGetDiskFreeSpaceW         = modkernel32.NewProc("GetDiskFreeSpaceW")
	procGetFileAttributesExW      = modkernel32.NewProc("GetFileAttributesExW")
	procGetFileAttributesA        = modkernel32.NewProc("GetFileAttributesA")
	procGetFileAttributesW        = modkernel32.NewProc("GetFileAttributesW")
	procGetFileSize               = modkernel32.NewProc("GetFileSize")
	procGetFullPathNameA          = modkernel32.NewProc("GetFullPathNameA")
	procGetFullPathNameW          = modkernel32.NewProc("GetFullPathNameW")
	procGetProcAddress            = modkernel32.NewProc("GetProcAddress")
	procGetProcessHeap            = modkernel32.NewProc("GetProcessHeap")
	procGetSystemInfo             = modkernel32.NewProc("GetSystemInfo")
	procGetSystemTime             = modkernel32.NewProc("GetSystemTime")
	procGetSystemTimeAsFileTime   = modkernel32.NewProc("GetSystemTimeAsFileTime")
	procGetTempPathA              = modkernel32.NewProc("GetTempPathA")
	procGetTempPathW              = modkernel32.NewProc("GetTempPathW")
	procGetTickCount              = modkernel32.NewProc("GetTickCount")
	procGetVersionExA             = modkernel32.NewProc("GetVersionExA")
	procGetVersionExW             = modkernel32.NewProc("GetVersionExW")
	procHeapAlloc                 = modkernel32.NewProc("HeapAlloc")
	procHeapCompact               = modkernel32.NewProc("HeapCompact")
	procHeapCreate                = modkernel32.NewProc("HeapCreate")
	procHeapDestroy               = modkernel32.NewProc("HeapDestroy")
	procHeapFree                  = modkernel32.NewProc("HeapFree")
	procHeapReAlloc               = modkernel32.NewProc("HeapReAlloc")
	procHeapSize                  = modkernel32.NewProc("HeapSize")
	procHeapValidate              = modkernel32.NewProc("HeapValidate")
	procInitializeCriticalSection = modkernel32.NewProc("InitializeCriticalSection")
	procLeaveCriticalSection      = modkernel32.NewProc("LeaveCriticalSection")
	procLoadLibraryA              = modkernel32.NewProc("LoadLibraryA")
	procLoadLibraryW              = modkernel32.NewProc("LoadLibraryW")
	procLocalFree                 = modkernel32.NewProc("LocalFree")
	procLockFile                  = modkernel32.NewProc("LockFile")
	procLockFileEx                = modkernel32.NewProc("LockFileEx")
	procMapViewOfFile             = modkernel32.NewProc("MapViewOfFile")
	procMultiByteToWideChar       = modkernel32.NewProc("MultiByteToWideChar")
	procOutputDebugStringA        = modkernel32.NewProc("OutputDebugStringA")
	procOutputDebugStringW        = modkernel32.NewProc("OutputDebugStringW")
	procQueryPerformanceCounter   = modkernel32.NewProc("QueryPerformanceCounter")
	procReadFile                  = modkernel32.NewProc("ReadFile")
	procSetEndOfFile              = modkernel32.NewProc("SetEndOfFile")
	procSetFilePointer            = modkernel32.NewProc("SetFilePointer")
	procSleep                     = modkernel32.NewProc("Sleep")
	procSystemTimeToFileTime      = modkernel32.NewProc("SystemTimeToFileTime")
	procUnlockFile                = modkernel32.NewProc("UnlockFile")
	procUnlockFileEx              = modkernel32.NewProc("UnlockFileEx")
	procUnmapViewOfFile           = modkernel32.NewProc("UnmapViewOfFile")
	procWaitForSingleObject       = modkernel32.NewProc("WaitForSingleObject")
	procWaitForSingleObjectEx     = modkernel32.NewProc("WaitForSingleObjectEx")
	procWideCharToMultiByte       = modkernel32.NewProc("WideCharToMultiByte")
	procWriteFile                 = modkernel32.NewProc("WriteFile")
)

// //sys: BOOL   	AreFileApisANSI();
func XAreFileApisANSI(tls *TLS) int32 {

	ret, _, err := syscall.Syscall(procAreFileApisANSI.Addr(), 0, 0,
		0,
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "AreFileApisANSI() %#x %v\n", ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (int32)(ret)
}

// //sys: HANDLE 	CreateFileA(LPCTSTR lpFileName, DWORD dwDesiredAccess, DWORD dwShareMode, LPSECURITY_ATTRIBUTES lpSecurityAttributes, DWORD dwCreationDisposition, DWORD dwFlagsAndAttributes, HANDLE hTemplateFile);
func XCreateFileA(tls *TLS, lpFileName *int8, dwDesiredAccess uint32, dwShareMode uint32, lpSecurityAttributes *XSECURITY_ATTRIBUTES, dwCreationDisposition uint32, dwFlagsAndAttributes uint32, hTemplateFile unsafe.Pointer) unsafe.Pointer {

	ret, _, err := syscall.Syscall9(procCreateFileA.Addr(), 7, uintptr(unsafe.Pointer(lpFileName)),
		uintptr(dwDesiredAccess),
		uintptr(dwShareMode),
		uintptr(unsafe.Pointer(lpSecurityAttributes)),
		uintptr(dwCreationDisposition),
		uintptr(dwFlagsAndAttributes),
		uintptr(hTemplateFile),
		0,
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "CreateFileA(%s, %#x, %#x, %#x, %#x, %#x, %#x) %#x %v\n", GoUTF16String(unsafe.Pointer(lpFileName)),
			dwDesiredAccess,
			dwShareMode,
			lpSecurityAttributes,
			dwCreationDisposition,
			dwFlagsAndAttributes,
			hTemplateFile,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (unsafe.Pointer)(ret)
}

// //sys: HANDLE 	CreateFileW(LPCWSTR lpFileName, DWORD dwDesiredAccess, DWORD dwShareMode, LPSECURITY_ATTRIBUTES lpSecurityAttributes, DWORD dwCreationDisposition, DWORD dwFlagsAndAttributes, HANDLE hTemplateFile);
func XCreateFileW(tls *TLS, lpFileName *uint16, dwDesiredAccess uint32, dwShareMode uint32, lpSecurityAttributes *XSECURITY_ATTRIBUTES, dwCreationDisposition uint32, dwFlagsAndAttributes uint32, hTemplateFile unsafe.Pointer) unsafe.Pointer {

	ret, _, err := syscall.Syscall9(procCreateFileW.Addr(), 7, uintptr(unsafe.Pointer(lpFileName)),
		uintptr(dwDesiredAccess),
		uintptr(dwShareMode),
		uintptr(unsafe.Pointer(lpSecurityAttributes)),
		uintptr(dwCreationDisposition),
		uintptr(dwFlagsAndAttributes),
		uintptr(hTemplateFile),
		0,
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "CreateFileW(%s, %#x, %#x, %#x, %#x, %#x, %#x) %#x %v\n", lpFileName,
			dwDesiredAccess,
			dwShareMode,
			lpSecurityAttributes,
			dwCreationDisposition,
			dwFlagsAndAttributes,
			hTemplateFile,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (unsafe.Pointer)(ret)
}

// //sys: HANDLE 	CreateFileMappingA(HANDLE hFile, LPSECURITY_ATTRIBUTES lpAttributes, DWORD flProtect, DWORD dwMaximumSizeHigh, DWORD dwMaximumSizeLow, LPCTSTR lpName);
func XCreateFileMappingA(tls *TLS, hFile unsafe.Pointer, lpAttributes *XSECURITY_ATTRIBUTES, flProtect uint32, dwMaximumSizeHigh uint32, dwMaximumSizeLow uint32, lpName *int8) unsafe.Pointer {

	ret, _, err := syscall.Syscall6(procCreateFileMappingA.Addr(), 6, uintptr(hFile),
		uintptr(unsafe.Pointer(lpAttributes)),
		uintptr(flProtect),
		uintptr(dwMaximumSizeHigh),
		uintptr(dwMaximumSizeLow),
		uintptr(unsafe.Pointer(lpName)))
	if strace {
		fmt.Fprintf(os.Stderr, "CreateFileMappingA(%#x, %#x, %#x, %#x, %#x, %s) %#x %v\n", hFile,
			lpAttributes,
			flProtect,
			dwMaximumSizeHigh,
			dwMaximumSizeLow,
			GoUTF16String(unsafe.Pointer(lpName)),
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (unsafe.Pointer)(ret)
}

// //sys: HANDLE 	CreateFileMappingW(HANDLE hFile, LPSECURITY_ATTRIBUTES lpAttributes, DWORD flProtect, DWORD dwMaximumSizeHigh, DWORD dwMaximumSizeLow, LPCWSTR lpName);
func XCreateFileMappingW(tls *TLS, hFile unsafe.Pointer, lpAttributes *XSECURITY_ATTRIBUTES, flProtect uint32, dwMaximumSizeHigh uint32, dwMaximumSizeLow uint32, lpName *uint16) unsafe.Pointer {

	ret, _, err := syscall.Syscall6(procCreateFileMappingW.Addr(), 6, uintptr(hFile),
		uintptr(unsafe.Pointer(lpAttributes)),
		uintptr(flProtect),
		uintptr(dwMaximumSizeHigh),
		uintptr(dwMaximumSizeLow),
		uintptr(unsafe.Pointer(lpName)))
	if strace {
		fmt.Fprintf(os.Stderr, "CreateFileMappingW(%#x, %#x, %#x, %#x, %#x, %s) %#x %v\n", hFile,
			lpAttributes,
			flProtect,
			dwMaximumSizeHigh,
			dwMaximumSizeLow,
			lpName,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (unsafe.Pointer)(ret)
}

// //sys: HANDLE 	CreateMutexW(LPSECURITY_ATTRIBUTES lpMutexAttributes, BOOL bInitialOwner, LPCWSTR lpName);
func XCreateMutexW(tls *TLS, lpMutexAttributes *XSECURITY_ATTRIBUTES, bInitialOwner int32, lpName *uint16) unsafe.Pointer {

	ret, _, err := syscall.Syscall(procCreateMutexW.Addr(), 3, uintptr(unsafe.Pointer(lpMutexAttributes)),
		uintptr(bInitialOwner),
		uintptr(unsafe.Pointer(lpName)))
	if strace {
		fmt.Fprintf(os.Stderr, "CreateMutexW(%#x, %#x, %s) %#x %v\n", lpMutexAttributes,
			bInitialOwner,
			lpName,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (unsafe.Pointer)(ret)
}

// //sys: BOOL   	CloseHandle(HANDLE hObject);
func XCloseHandle(tls *TLS, hObject unsafe.Pointer) int32 {

	ret, _, err := syscall.Syscall(procCloseHandle.Addr(), 1, uintptr(hObject),
		0,
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "CloseHandle(%#x) %#x %v\n", hObject,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (int32)(ret)
}

// //sys: void   	DeleteCriticalSection(LPCRITICAL_SECTION lpCriticalSection);
func XDeleteCriticalSection(tls *TLS, lpCriticalSection *XCRITICAL_SECTION) {

	ret, _, err := syscall.Syscall(procDeleteCriticalSection.Addr(), 1, uintptr(unsafe.Pointer(lpCriticalSection)),
		0,
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "DeleteCriticalSection(%#x) %d %v\n", lpCriticalSection,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
}

// //sys: BOOL   	DeleteFileA(LPCTSTR lpFileName);
func XDeleteFileA(tls *TLS, lpFileName *int8) int32 {

	ret, _, err := syscall.Syscall(procDeleteFileA.Addr(), 1, uintptr(unsafe.Pointer(lpFileName)),
		0,
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "DeleteFileA(%s) %#x %v\n", GoUTF16String(unsafe.Pointer(lpFileName)),
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (int32)(ret)
}

// //sys: BOOL   	DeleteFileW(LPCWSTR lpFileName);
func XDeleteFileW(tls *TLS, lpFileName *uint16) int32 {

	ret, _, err := syscall.Syscall(procDeleteFileW.Addr(), 1, uintptr(unsafe.Pointer(lpFileName)),
		0,
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "DeleteFileW(%s) %#x %v\n", lpFileName,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (int32)(ret)
}

// //sys: void   	EnterCriticalSection(LPCRITICAL_SECTION lpCriticalSection);
func XEnterCriticalSection(tls *TLS, lpCriticalSection *XCRITICAL_SECTION) {

	ret, _, err := syscall.Syscall(procEnterCriticalSection.Addr(), 1, uintptr(unsafe.Pointer(lpCriticalSection)),
		0,
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "EnterCriticalSection(%#x) %d %v\n", lpCriticalSection,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
}

// //sys: BOOL   	FlushFileBuffers(HANDLE hFile);
func XFlushFileBuffers(tls *TLS, hFile unsafe.Pointer) int32 {

	ret, _, err := syscall.Syscall(procFlushFileBuffers.Addr(), 1, uintptr(hFile),
		0,
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "FlushFileBuffers(%#x) %#x %v\n", hFile,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (int32)(ret)
}

// //sys: BOOL     FlushViewOfFile(LPCVOID lpBaseAddress, SIZE_T dwNumberOfBytesToFlush);
func XFlushViewOfFile(tls *TLS, lpBaseAddress unsafe.Pointer, dwNumberOfBytesToFlush uint32) int32 {

	ret, _, err := syscall.Syscall(procFlushViewOfFile.Addr(), 2, uintptr(lpBaseAddress),
		uintptr(dwNumberOfBytesToFlush),
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "FlushViewOfFile(%#x, %#x) %#x %v\n", lpBaseAddress,
			dwNumberOfBytesToFlush,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (int32)(ret)
}

// //sys: DWORD  	FormatMessageA(DWORD dwFlags, LPCVOID lpSource, DWORD dwMessageId, DWORD dwLanguageId, LPTSTR lpBuffer, DWORD nSize, va_list* Arguments);
func XFormatMessageA(tls *TLS, dwFlags uint32, lpSource unsafe.Pointer, dwMessageId uint32, dwLanguageId uint32, lpBuffer *int8, nSize uint32, Arguments *[]interface{}) uint32 {

	ret, _, err := syscall.Syscall9(procFormatMessageA.Addr(), 7, uintptr(dwFlags),
		uintptr(lpSource),
		uintptr(dwMessageId),
		uintptr(dwLanguageId),
		uintptr(unsafe.Pointer(lpBuffer)),
		uintptr(nSize),
		uintptr(unsafe.Pointer(Arguments)),
		0,
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "FormatMessageA(%#x, %#x, %#x, %#x, %s, %#x, %#x) %#x %v\n", dwFlags,
			lpSource,
			dwMessageId,
			dwLanguageId,
			GoUTF16String(unsafe.Pointer(lpBuffer)),
			nSize,
			Arguments,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (uint32)(ret)
}

// //sys: DWORD  	FormatMessageW(DWORD dwFlags, LPCVOID lpSource, DWORD dwMessageId, DWORD dwLanguageId, LPCWSTR lpBuffer, DWORD nSize, va_list* Arguments);
func XFormatMessageW(tls *TLS, dwFlags uint32, lpSource unsafe.Pointer, dwMessageId uint32, dwLanguageId uint32, lpBuffer *uint16, nSize uint32, Arguments *[]interface{}) uint32 {

	ret, _, err := syscall.Syscall9(procFormatMessageW.Addr(), 7, uintptr(dwFlags),
		uintptr(lpSource),
		uintptr(dwMessageId),
		uintptr(dwLanguageId),
		uintptr(unsafe.Pointer(lpBuffer)),
		uintptr(nSize),
		uintptr(unsafe.Pointer(Arguments)),
		0,
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "FormatMessageW(%#x, %#x, %#x, %#x, %s, %#x, %#x) %#x %v\n", dwFlags,
			lpSource,
			dwMessageId,
			dwLanguageId,
			lpBuffer,
			nSize,
			Arguments,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (uint32)(ret)
}

// //sys: BOOL   	FreeLibrary(HMODULE hModule);
func XFreeLibrary(tls *TLS, hModule *XHMODULE) int32 {

	ret, _, err := syscall.Syscall(procFreeLibrary.Addr(), 1, uintptr(unsafe.Pointer(hModule)),
		0,
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "FreeLibrary(%#x) %#x %v\n", hModule,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (int32)(ret)
}

// //sys: DWORD  	GetCurrentProcessId();
func XGetCurrentProcessId(tls *TLS) uint32 {

	ret, _, err := syscall.Syscall(procGetCurrentProcessId.Addr(), 0, 0,
		0,
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "GetCurrentProcessId() %#x %v\n", ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (uint32)(ret)
}

// //sys: BOOL   	GetDiskFreeSpaceA(LPCTSTR lpRootPathName, LPDWORD lpSectorsPerCluster, LPDWORD lpBytesPerSector, LPDWORD lpNumberOfFreeClusters, LPDWORD lpTotalNumberOfClusters);
func XGetDiskFreeSpaceA(tls *TLS, lpRootPathName *int8, lpSectorsPerCluster *uint32, lpBytesPerSector *uint32, lpNumberOfFreeClusters *uint32, lpTotalNumberOfClusters *uint32) int32 {

	ret, _, err := syscall.Syscall6(procGetDiskFreeSpaceA.Addr(), 5, uintptr(unsafe.Pointer(lpRootPathName)),
		uintptr(unsafe.Pointer(lpSectorsPerCluster)),
		uintptr(unsafe.Pointer(lpBytesPerSector)),
		uintptr(unsafe.Pointer(lpNumberOfFreeClusters)),
		uintptr(unsafe.Pointer(lpTotalNumberOfClusters)),
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "GetDiskFreeSpaceA(%s, %#x, %#x, %#x, %#x) %#x %v\n", GoUTF16String(unsafe.Pointer(lpRootPathName)),
			lpSectorsPerCluster,
			lpBytesPerSector,
			lpNumberOfFreeClusters,
			lpTotalNumberOfClusters,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (int32)(ret)
}

// //sys: BOOL   	GetDiskFreeSpaceW(LPCWSTR lpRootPathName, LPDWORD lpSectorsPerCluster, LPDWORD lpBytesPerSector, LPDWORD lpNumberOfFreeClusters, LPDWORD lpTotalNumberOfClusters);
func XGetDiskFreeSpaceW(tls *TLS, lpRootPathName *uint16, lpSectorsPerCluster *uint32, lpBytesPerSector *uint32, lpNumberOfFreeClusters *uint32, lpTotalNumberOfClusters *uint32) int32 {

	ret, _, err := syscall.Syscall6(procGetDiskFreeSpaceW.Addr(), 5, uintptr(unsafe.Pointer(lpRootPathName)),
		uintptr(unsafe.Pointer(lpSectorsPerCluster)),
		uintptr(unsafe.Pointer(lpBytesPerSector)),
		uintptr(unsafe.Pointer(lpNumberOfFreeClusters)),
		uintptr(unsafe.Pointer(lpTotalNumberOfClusters)),
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "GetDiskFreeSpaceW(%s, %#x, %#x, %#x, %#x) %#x %v\n", lpRootPathName,
			lpSectorsPerCluster,
			lpBytesPerSector,
			lpNumberOfFreeClusters,
			lpTotalNumberOfClusters,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (int32)(ret)
}

// //sys: BOOL   	GetFileAttributesExW(LPCWSTR lpFileName, GET_FILEEX_INFO_LEVELS fInfoLevelId, LPVOID lpFileInformation);
func XGetFileAttributesExW(tls *TLS, lpFileName *uint16, fInfoLevelId int32, lpFileInformation unsafe.Pointer) int32 {

	ret, _, err := syscall.Syscall(procGetFileAttributesExW.Addr(), 3, uintptr(unsafe.Pointer(lpFileName)),
		uintptr(fInfoLevelId),
		uintptr(lpFileInformation))
	if strace {
		fmt.Fprintf(os.Stderr, "GetFileAttributesExW(%s, %#x, %#x) %#x %v\n", lpFileName,
			fInfoLevelId,
			lpFileInformation,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (int32)(ret)
}

// //sys: DWORD  	GetFileAttributesA(LPCTSTR lpFileName);
func XGetFileAttributesA(tls *TLS, lpFileName *int8) uint32 {

	ret, _, err := syscall.Syscall(procGetFileAttributesA.Addr(), 1, uintptr(unsafe.Pointer(lpFileName)),
		0,
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "GetFileAttributesA(%s) %#x %v\n", GoUTF16String(unsafe.Pointer(lpFileName)),
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (uint32)(ret)
}

// //sys: DWORD  	GetFileAttributesW(LPCWSTR lpFileName);
func XGetFileAttributesW(tls *TLS, lpFileName *uint16) uint32 {

	ret, _, err := syscall.Syscall(procGetFileAttributesW.Addr(), 1, uintptr(unsafe.Pointer(lpFileName)),
		0,
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "GetFileAttributesW(%s) %#x %v\n", lpFileName,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (uint32)(ret)
}

// //sys: DWORD  	GetFileSize(HANDLE hFile, LPDWORD lpFileSizeHigh);
func XGetFileSize(tls *TLS, hFile unsafe.Pointer, lpFileSizeHigh *uint32) uint32 {

	ret, _, err := syscall.Syscall(procGetFileSize.Addr(), 2, uintptr(hFile),
		uintptr(unsafe.Pointer(lpFileSizeHigh)),
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "GetFileSize(%#x, %#x) %#x %v\n", hFile,
			lpFileSizeHigh,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (uint32)(ret)
}

// //sys: DWORD  	GetFullPathNameA( LPCTSTR lpFileName, DWORD nBufferLength, LPTSTR lpBuffer, LPTSTR* lpFilePart);
func XGetFullPathNameA(tls *TLS, lpFileName *int8, nBufferLength uint32, lpBuffer *int8, lpFilePart **int8) uint32 {

	ret, _, err := syscall.Syscall6(procGetFullPathNameA.Addr(), 4, uintptr(unsafe.Pointer(lpFileName)),
		uintptr(nBufferLength),
		uintptr(unsafe.Pointer(lpBuffer)),
		uintptr(unsafe.Pointer(lpFilePart)),
		0,
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "GetFullPathNameA(%s, %#x, %s, %#x) %#x %v\n", GoUTF16String(unsafe.Pointer(lpFileName)),
			nBufferLength,
			GoUTF16String(unsafe.Pointer(lpBuffer)),
			lpFilePart,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (uint32)(ret)
}

// //sys: DWORD  	GetFullPathNameW( LPCWSTR lpFileName, DWORD nBufferLength, LPCWSTR lpBuffer, LPCWSTR* lpFilePart);
func XGetFullPathNameW(tls *TLS, lpFileName *uint16, nBufferLength uint32, lpBuffer *uint16, lpFilePart **uint16) uint32 {

	ret, _, err := syscall.Syscall6(procGetFullPathNameW.Addr(), 4, uintptr(unsafe.Pointer(lpFileName)),
		uintptr(nBufferLength),
		uintptr(unsafe.Pointer(lpBuffer)),
		uintptr(unsafe.Pointer(lpFilePart)),
		0,
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "GetFullPathNameW(%s, %#x, %s, %#x) %#x %v\n", lpFileName,
			nBufferLength,
			lpBuffer,
			lpFilePart,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (uint32)(ret)
}

// //sys: FARPROC 	GetProcAddress(HMODULE hModule, LPCSTR lpProcName);
func XGetProcAddress(tls *TLS, hModule *XHMODULE, lpProcName *int8) func(*TLS) int32 {

	ret, _, err := syscall.Syscall(procGetProcAddress.Addr(), 2, uintptr(unsafe.Pointer(hModule)),
		uintptr(unsafe.Pointer(lpProcName)),
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "GetProcAddress(%#x, %s) %#x %v\n", hModule,
			GoUTF16String(unsafe.Pointer(lpProcName)),
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return *(*func(*TLS) int32)(unsafe.Pointer(ret))
}

// //sys: HANDLE   GetProcessHeap();
func XGetProcessHeap(tls *TLS) unsafe.Pointer {

	ret, _, err := syscall.Syscall(procGetProcessHeap.Addr(), 0, 0,
		0,
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "GetProcessHeap() %#x %v\n", ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (unsafe.Pointer)(ret)
}

// //sys: void   	GetSystemInfo(LPSYSTEM_INFO lpSystemInfo);
func XGetSystemInfo(tls *TLS, lpSystemInfo *XSYSTEM_INFO) {

	ret, _, err := syscall.Syscall(procGetSystemInfo.Addr(), 1, uintptr(unsafe.Pointer(lpSystemInfo)),
		0,
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "GetSystemInfo(%#x) %d %v\n", lpSystemInfo,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
}

// //sys: void   	GetSystemTime(LPSYSTEMTIME lpSystemTime);
func XGetSystemTime(tls *TLS, lpSystemTime *XSYSTEMTIME) {

	ret, _, err := syscall.Syscall(procGetSystemTime.Addr(), 1, uintptr(unsafe.Pointer(lpSystemTime)),
		0,
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "GetSystemTime(%#x) %d %v\n", lpSystemTime,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
}

// //sys: void     GetSystemTimeAsFileTime(LPFILETIME lpSystemTimeAsFileTime);
func XGetSystemTimeAsFileTime(tls *TLS, lpSystemTimeAsFileTime *XFILETIME) {

	ret, _, err := syscall.Syscall(procGetSystemTimeAsFileTime.Addr(), 1, uintptr(unsafe.Pointer(lpSystemTimeAsFileTime)),
		0,
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "GetSystemTimeAsFileTime(%#x) %d %v\n", lpSystemTimeAsFileTime,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
}

// //sys: DWORD    GetTempPathA(DWORD nBufferLength, LPTSTR lpBuffer);
func XGetTempPathA(tls *TLS, nBufferLength uint32, lpBuffer *int8) uint32 {

	ret, _, err := syscall.Syscall(procGetTempPathA.Addr(), 2, uintptr(nBufferLength),
		uintptr(unsafe.Pointer(lpBuffer)),
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "GetTempPathA(%#x, %s) %#x %v\n", nBufferLength,
			GoUTF16String(unsafe.Pointer(lpBuffer)),
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (uint32)(ret)
}

// //sys: DWORD    GetTempPathW(DWORD nBufferLength, LPCWSTR lpBuffer);
func XGetTempPathW(tls *TLS, nBufferLength uint32, lpBuffer *uint16) uint32 {

	ret, _, err := syscall.Syscall(procGetTempPathW.Addr(), 2, uintptr(nBufferLength),
		uintptr(unsafe.Pointer(lpBuffer)),
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "GetTempPathW(%#x, %s) %#x %v\n", nBufferLength,
			lpBuffer,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (uint32)(ret)
}

// //sys: DWORD  	GetTickCount();
func XGetTickCount(tls *TLS) uint32 {

	ret, _, err := syscall.Syscall(procGetTickCount.Addr(), 0, 0,
		0,
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "GetTickCount() %#x %v\n", ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (uint32)(ret)
}

// //sys: BOOL   	GetVersionExA(LPOSVERSIONINFO lpVersionInfo);
func XGetVersionExA(tls *TLS, lpVersionInfo *XOSVERSIONINFOA) int32 {

	ret, _, err := syscall.Syscall(procGetVersionExA.Addr(), 1, uintptr(unsafe.Pointer(lpVersionInfo)),
		0,
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "GetVersionExA(%#x) %#x %v\n", lpVersionInfo,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (int32)(ret)
}

// //sys: BOOL   	GetVersionExW(LPOSVERSIONINFOW lpVersionInfo);
func XGetVersionExW(tls *TLS, lpVersionInfo *XOSVERSIONINFOW) int32 {

	ret, _, err := syscall.Syscall(procGetVersionExW.Addr(), 1, uintptr(unsafe.Pointer(lpVersionInfo)),
		0,
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "GetVersionExW(%#x) %#x %v\n", lpVersionInfo,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (int32)(ret)
}

// //sys: LPVOID 	HeapAlloc(HANDLE hHeap, DWORD dwFlags, SIZE_T dwBytes);
func XHeapAlloc(tls *TLS, hHeap unsafe.Pointer, dwFlags uint32, dwBytes uint32) unsafe.Pointer {

	ret, _, err := syscall.Syscall(procHeapAlloc.Addr(), 3, uintptr(hHeap),
		uintptr(dwFlags),
		uintptr(dwBytes))
	if strace {
		fmt.Fprintf(os.Stderr, "HeapAlloc(%#x, %#x, %#x) %#x %v\n", hHeap,
			dwFlags,
			dwBytes,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (unsafe.Pointer)(ret)
}

// //sys: SIZE_T   HeapCompact(HANDLE hHeap, DWORD dwFlags);
func XHeapCompact(tls *TLS, hHeap unsafe.Pointer, dwFlags uint32) uint32 {

	ret, _, err := syscall.Syscall(procHeapCompact.Addr(), 2, uintptr(hHeap),
		uintptr(dwFlags),
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "HeapCompact(%#x, %#x) %#x %v\n", hHeap,
			dwFlags,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (uint32)(ret)
}

// //sys: HANDLE   HeapCreate(DWORD flOptions, SIZE_T dwInitialSize, SIZE_T dwMaximumSize);
func XHeapCreate(tls *TLS, flOptions uint32, dwInitialSize uint32, dwMaximumSize uint32) unsafe.Pointer {

	ret, _, err := syscall.Syscall(procHeapCreate.Addr(), 3, uintptr(flOptions),
		uintptr(dwInitialSize),
		uintptr(dwMaximumSize))
	if strace {
		fmt.Fprintf(os.Stderr, "HeapCreate(%#x, %#x, %#x) %#x %v\n", flOptions,
			dwInitialSize,
			dwMaximumSize,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (unsafe.Pointer)(ret)
}

// //sys: BOOL     HeapDestroy(HANDLE hHeap);
func XHeapDestroy(tls *TLS, hHeap unsafe.Pointer) int32 {

	ret, _, err := syscall.Syscall(procHeapDestroy.Addr(), 1, uintptr(hHeap),
		0,
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "HeapDestroy(%#x) %#x %v\n", hHeap,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (int32)(ret)
}

// //sys: BOOL     HeapFree(HANDLE hHeap, DWORD dwFlags, LPVOID lpMem);
func XHeapFree(tls *TLS, hHeap unsafe.Pointer, dwFlags uint32, lpMem unsafe.Pointer) int32 {

	ret, _, err := syscall.Syscall(procHeapFree.Addr(), 3, uintptr(hHeap),
		uintptr(dwFlags),
		uintptr(lpMem))
	if strace {
		fmt.Fprintf(os.Stderr, "HeapFree(%#x, %#x, %#x) %#x %v\n", hHeap,
			dwFlags,
			lpMem,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (int32)(ret)
}

// //sys: LPVOID   HeapReAlloc(HANDLE hHeap, DWORD dwFlags, LPVOID lpMem, SIZE_T dwBytes);
func XHeapReAlloc(tls *TLS, hHeap unsafe.Pointer, dwFlags uint32, lpMem unsafe.Pointer, dwBytes uint32) unsafe.Pointer {

	ret, _, err := syscall.Syscall6(procHeapReAlloc.Addr(), 4, uintptr(hHeap),
		uintptr(dwFlags),
		uintptr(lpMem),
		uintptr(dwBytes),
		0,
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "HeapReAlloc(%#x, %#x, %#x, %#x) %#x %v\n", hHeap,
			dwFlags,
			lpMem,
			dwBytes,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (unsafe.Pointer)(ret)
}

// //sys: SIZE_T   HeapSize(HANDLE hHeap, DWORD dwFlags, LPCVOID lpMem);
func XHeapSize(tls *TLS, hHeap unsafe.Pointer, dwFlags uint32, lpMem unsafe.Pointer) uint32 {

	ret, _, err := syscall.Syscall(procHeapSize.Addr(), 3, uintptr(hHeap),
		uintptr(dwFlags),
		uintptr(lpMem))
	if strace {
		fmt.Fprintf(os.Stderr, "HeapSize(%#x, %#x, %#x) %#x %v\n", hHeap,
			dwFlags,
			lpMem,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (uint32)(ret)
}

// //sys: BOOL     HeapValidate(HANDLE hHeap, DWORD dwFlags, LPCVOID lpMem);
func XHeapValidate(tls *TLS, hHeap unsafe.Pointer, dwFlags uint32, lpMem unsafe.Pointer) int32 {

	ret, _, err := syscall.Syscall(procHeapValidate.Addr(), 3, uintptr(hHeap),
		uintptr(dwFlags),
		uintptr(lpMem))
	if strace {
		fmt.Fprintf(os.Stderr, "HeapValidate(%#x, %#x, %#x) %#x %v\n", hHeap,
			dwFlags,
			lpMem,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (int32)(ret)
}

// //sys: void   	InitializeCriticalSection(LPCRITICAL_SECTION lpCriticalSection);
func XInitializeCriticalSection(tls *TLS, lpCriticalSection *XCRITICAL_SECTION) {

	ret, _, err := syscall.Syscall(procInitializeCriticalSection.Addr(), 1, uintptr(unsafe.Pointer(lpCriticalSection)),
		0,
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "InitializeCriticalSection(%#x) %d %v\n", lpCriticalSection,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
}

// //sys: void   	LeaveCriticalSection(LPCRITICAL_SECTION lpCriticalSection);
func XLeaveCriticalSection(tls *TLS, lpCriticalSection *XCRITICAL_SECTION) {

	ret, _, err := syscall.Syscall(procLeaveCriticalSection.Addr(), 1, uintptr(unsafe.Pointer(lpCriticalSection)),
		0,
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "LeaveCriticalSection(%#x) %d %v\n", lpCriticalSection,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
}

// //sys: HMODULE  LoadLibraryA(LPCTSTR lpFileName);
func XLoadLibraryA(tls *TLS, lpFileName *int8) *XHMODULE {

	ret, _, err := syscall.Syscall(procLoadLibraryA.Addr(), 1, uintptr(unsafe.Pointer(lpFileName)),
		0,
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "LoadLibraryA(%s) %#x %v\n", GoUTF16String(unsafe.Pointer(lpFileName)),
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (*XHMODULE)(unsafe.Pointer(ret))
}

// //sys: HMODULE  LoadLibraryW(LPCWSTR lpFileName);
func XLoadLibraryW(tls *TLS, lpFileName *uint16) *XHMODULE {

	ret, _, err := syscall.Syscall(procLoadLibraryW.Addr(), 1, uintptr(unsafe.Pointer(lpFileName)),
		0,
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "LoadLibraryW(%s) %#x %v\n", lpFileName,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (*XHMODULE)(unsafe.Pointer(ret))
}

// //sys: HLOCAL 	LocalFree(HLOCAL hMem);
func XLocalFree(tls *TLS, hMem unsafe.Pointer) unsafe.Pointer {

	ret, _, err := syscall.Syscall(procLocalFree.Addr(), 1, uintptr(hMem),
		0,
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "LocalFree(%#x) %#x %v\n", hMem,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (unsafe.Pointer)(ret)
}

// //sys: BOOL     LockFile(HANDLE hFile, DWORD dwFileOffsetLow, DWORD dwFileOffsetHigh, DWORD nNumberOfBytesToLockLow, DWORD nNumberOfBytesToLockHigh);
func XLockFile(tls *TLS, hFile unsafe.Pointer, dwFileOffsetLow uint32, dwFileOffsetHigh uint32, nNumberOfBytesToLockLow uint32, nNumberOfBytesToLockHigh uint32) int32 {

	ret, _, err := syscall.Syscall6(procLockFile.Addr(), 5, uintptr(hFile),
		uintptr(dwFileOffsetLow),
		uintptr(dwFileOffsetHigh),
		uintptr(nNumberOfBytesToLockLow),
		uintptr(nNumberOfBytesToLockHigh),
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "LockFile(%#x, %#x, %#x, %#x, %#x) %#x %v\n", hFile,
			dwFileOffsetLow,
			dwFileOffsetHigh,
			nNumberOfBytesToLockLow,
			nNumberOfBytesToLockHigh,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (int32)(ret)
}

// //sys: BOOL   	LockFileEx(HANDLE hFile, DWORD dwFlags, DWORD dwReserved, DWORD nNumberOfBytesToLockLow, DWORD nNumberOfBytesToLockHigh, LPOVERLAPPED lpOverlapped);
func XLockFileEx(tls *TLS, hFile unsafe.Pointer, dwFlags uint32, dwReserved uint32, nNumberOfBytesToLockLow uint32, nNumberOfBytesToLockHigh uint32, lpOverlapped *XOVERLAPPED) int32 {

	ret, _, err := syscall.Syscall6(procLockFileEx.Addr(), 6, uintptr(hFile),
		uintptr(dwFlags),
		uintptr(dwReserved),
		uintptr(nNumberOfBytesToLockLow),
		uintptr(nNumberOfBytesToLockHigh),
		uintptr(unsafe.Pointer(lpOverlapped)))
	if strace {
		fmt.Fprintf(os.Stderr, "LockFileEx(%#x, %#x, %#x, %#x, %#x, %#x) %#x %v\n", hFile,
			dwFlags,
			dwReserved,
			nNumberOfBytesToLockLow,
			nNumberOfBytesToLockHigh,
			lpOverlapped,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (int32)(ret)
}

// //sys: LPVOID   MapViewOfFile(HANDLE hFileMappingObject, DWORD dwDesiredAccess, DWORD dwFileOffsetHigh, DWORD dwFileOffsetLow, SIZE_T dwNumberOfBytesToMap);
func XMapViewOfFile(tls *TLS, hFileMappingObject unsafe.Pointer, dwDesiredAccess uint32, dwFileOffsetHigh uint32, dwFileOffsetLow uint32, dwNumberOfBytesToMap uint32) unsafe.Pointer {

	ret, _, err := syscall.Syscall6(procMapViewOfFile.Addr(), 5, uintptr(hFileMappingObject),
		uintptr(dwDesiredAccess),
		uintptr(dwFileOffsetHigh),
		uintptr(dwFileOffsetLow),
		uintptr(dwNumberOfBytesToMap),
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "MapViewOfFile(%#x, %#x, %#x, %#x, %#x) %#x %v\n", hFileMappingObject,
			dwDesiredAccess,
			dwFileOffsetHigh,
			dwFileOffsetLow,
			dwNumberOfBytesToMap,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (unsafe.Pointer)(ret)
}

// //sys: int 	  	MultiByteToWideChar(UINT CodePage, DWORD dwFlags, LPCSTR lpMultiByteStr,	int cbMultiByte, LPWSTR lpWideCharStr, int cchWideChar);
func XMultiByteToWideChar(tls *TLS, CodePage uint32, dwFlags uint32, lpMultiByteStr *int8, cbMultiByte int32, lpWideCharStr *uint16, cchWideChar int32) int32 {

	ret, _, err := syscall.Syscall6(procMultiByteToWideChar.Addr(), 6, uintptr(CodePage),
		uintptr(dwFlags),
		uintptr(unsafe.Pointer(lpMultiByteStr)),
		uintptr(cbMultiByte),
		uintptr(unsafe.Pointer(lpWideCharStr)),
		uintptr(cchWideChar))
	if strace {
		fmt.Fprintf(os.Stderr, "MultiByteToWideChar(%#x, %#x, %s, %#x, %s, %#x) %#x %v\n", CodePage,
			dwFlags,
			GoUTF16String(unsafe.Pointer(lpMultiByteStr)),
			cbMultiByte,
			lpWideCharStr,
			cchWideChar,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (int32)(ret)
}

// //sys: void     OutputDebugStringA(LPCTSTR lpOutputString);
func XOutputDebugStringA(tls *TLS, lpOutputString *int8) {

	ret, _, err := syscall.Syscall(procOutputDebugStringA.Addr(), 1, uintptr(unsafe.Pointer(lpOutputString)),
		0,
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "OutputDebugStringA(%s) %d %v\n", GoUTF16String(unsafe.Pointer(lpOutputString)),
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
}

// //sys: void     OutputDebugStringW(LPCWSTR lpOutputString);
func XOutputDebugStringW(tls *TLS, lpOutputString *uint16) {

	ret, _, err := syscall.Syscall(procOutputDebugStringW.Addr(), 1, uintptr(unsafe.Pointer(lpOutputString)),
		0,
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "OutputDebugStringW(%s) %d %v\n", lpOutputString,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
}

// //sys: BOOL   	QueryPerformanceCounter(LARGE_INTEGER* lpPerformanceCount);
func XQueryPerformanceCounter(tls *TLS, lpPerformanceCount *XLARGE_INTEGER) int32 {

	ret, _, err := syscall.Syscall(procQueryPerformanceCounter.Addr(), 1, uintptr(unsafe.Pointer(lpPerformanceCount)),
		0,
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "QueryPerformanceCounter(%#x) %#x %v\n", lpPerformanceCount,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (int32)(ret)
}

// //sys: BOOL   	ReadFile(HANDLE hFile, LPVOID lpBuffer, DWORD nNumberOfBytesToRead, LPDWORD lpNumberOfBytesRead, LPOVERLAPPED lpOverlapped);
func XReadFile(tls *TLS, hFile unsafe.Pointer, lpBuffer unsafe.Pointer, nNumberOfBytesToRead uint32, lpNumberOfBytesRead *uint32, lpOverlapped *XOVERLAPPED) int32 {

	ret, _, err := syscall.Syscall6(procReadFile.Addr(), 5, uintptr(hFile),
		uintptr(lpBuffer),
		uintptr(nNumberOfBytesToRead),
		uintptr(unsafe.Pointer(lpNumberOfBytesRead)),
		uintptr(unsafe.Pointer(lpOverlapped)),
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "ReadFile(%#x, %#x, %#x, %#x, %#x) %#x %v\n", hFile,
			lpBuffer,
			nNumberOfBytesToRead,
			lpNumberOfBytesRead,
			lpOverlapped,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (int32)(ret)
}

// //sys: BOOL     SetEndOfFile(HANDLE hFile);
func XSetEndOfFile(tls *TLS, hFile unsafe.Pointer) int32 {

	ret, _, err := syscall.Syscall(procSetEndOfFile.Addr(), 1, uintptr(hFile),
		0,
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "SetEndOfFile(%#x) %#x %v\n", hFile,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (int32)(ret)
}

// //sys: DWORD    SetFilePointer(HANDLE hFile, LONG lDistanceToMove, PLONG lpDistanceToMoveHigh, DWORD dwMoveMethod);
func XSetFilePointer(tls *TLS, hFile unsafe.Pointer, lDistanceToMove int32, lpDistanceToMoveHigh *int32, dwMoveMethod uint32) uint32 {

	ret, _, err := syscall.Syscall6(procSetFilePointer.Addr(), 4, uintptr(hFile),
		uintptr(lDistanceToMove),
		uintptr(unsafe.Pointer(lpDistanceToMoveHigh)),
		uintptr(dwMoveMethod),
		0,
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "SetFilePointer(%#x, %#x, %#x, %#x) %#x %v\n", hFile,
			lDistanceToMove,
			lpDistanceToMoveHigh,
			dwMoveMethod,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (uint32)(ret)
}

// //sys: void     Sleep(DWORD dwMilliseconds);
func XSleep(tls *TLS, dwMilliseconds uint32) {

	ret, _, err := syscall.Syscall(procSleep.Addr(), 1, uintptr(dwMilliseconds),
		0,
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "Sleep(%#x) %d %v\n", dwMilliseconds,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
}

// //sys: BOOL     SystemTimeToFileTime(SYSTEMTIME* lpSystemTime, LPFILETIME lpFileTime);
func XSystemTimeToFileTime(tls *TLS, lpSystemTime *XSYSTEMTIME, lpFileTime *XFILETIME) int32 {

	ret, _, err := syscall.Syscall(procSystemTimeToFileTime.Addr(), 2, uintptr(unsafe.Pointer(lpSystemTime)),
		uintptr(unsafe.Pointer(lpFileTime)),
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "SystemTimeToFileTime(%#x, %#x) %#x %v\n", lpSystemTime,
			lpFileTime,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (int32)(ret)
}

// //sys: BOOL     UnlockFile(HANDLE hFile, DWORD dwFileOffsetLow, DWORD dwFileOffsetHigh, DWORD nNumberOfBytesToUnlockLow, DWORD nNumberOfBytesToUnlockHigh);
func XUnlockFile(tls *TLS, hFile unsafe.Pointer, dwFileOffsetLow uint32, dwFileOffsetHigh uint32, nNumberOfBytesToUnlockLow uint32, nNumberOfBytesToUnlockHigh uint32) int32 {

	ret, _, err := syscall.Syscall6(procUnlockFile.Addr(), 5, uintptr(hFile),
		uintptr(dwFileOffsetLow),
		uintptr(dwFileOffsetHigh),
		uintptr(nNumberOfBytesToUnlockLow),
		uintptr(nNumberOfBytesToUnlockHigh),
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "UnlockFile(%#x, %#x, %#x, %#x, %#x) %#x %v\n", hFile,
			dwFileOffsetLow,
			dwFileOffsetHigh,
			nNumberOfBytesToUnlockLow,
			nNumberOfBytesToUnlockHigh,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (int32)(ret)
}

// //sys: BOOL   	UnlockFileEx(HANDLE hFile, DWORD dwReserved, DWORD nNumberOfBytesToUnlockLow, DWORD nNumberOfBytesToUnlockHigh, LPOVERLAPPED lpOverlapped);
func XUnlockFileEx(tls *TLS, hFile unsafe.Pointer, dwReserved uint32, nNumberOfBytesToUnlockLow uint32, nNumberOfBytesToUnlockHigh uint32, lpOverlapped *XOVERLAPPED) int32 {

	ret, _, err := syscall.Syscall6(procUnlockFileEx.Addr(), 5, uintptr(hFile),
		uintptr(dwReserved),
		uintptr(nNumberOfBytesToUnlockLow),
		uintptr(nNumberOfBytesToUnlockHigh),
		uintptr(unsafe.Pointer(lpOverlapped)),
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "UnlockFileEx(%#x, %#x, %#x, %#x, %#x) %#x %v\n", hFile,
			dwReserved,
			nNumberOfBytesToUnlockLow,
			nNumberOfBytesToUnlockHigh,
			lpOverlapped,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (int32)(ret)
}

// //sys: BOOL     UnmapViewOfFile(LPCVOID lpBaseAddress);
func XUnmapViewOfFile(tls *TLS, lpBaseAddress unsafe.Pointer) int32 {

	ret, _, err := syscall.Syscall(procUnmapViewOfFile.Addr(), 1, uintptr(lpBaseAddress),
		0,
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "UnmapViewOfFile(%#x) %#x %v\n", lpBaseAddress,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (int32)(ret)
}

// //sys: DWORD    WaitForSingleObject(HANDLE hHandle, DWORD dwMilliseconds);
func XWaitForSingleObject(tls *TLS, hHandle unsafe.Pointer, dwMilliseconds uint32) uint32 {

	ret, _, err := syscall.Syscall(procWaitForSingleObject.Addr(), 2, uintptr(hHandle),
		uintptr(dwMilliseconds),
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "WaitForSingleObject(%#x, %#x) %#x %v\n", hHandle,
			dwMilliseconds,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (uint32)(ret)
}

// //sys: DWORD    WaitForSingleObjectEx(HANDLE hHandle, DWORD dwMilliseconds, BOOL bAlertable);
func XWaitForSingleObjectEx(tls *TLS, hHandle unsafe.Pointer, dwMilliseconds uint32, bAlertable int32) uint32 {

	ret, _, err := syscall.Syscall(procWaitForSingleObjectEx.Addr(), 3, uintptr(hHandle),
		uintptr(dwMilliseconds),
		uintptr(bAlertable))
	if strace {
		fmt.Fprintf(os.Stderr, "WaitForSingleObjectEx(%#x, %#x, %#x) %#x %v\n", hHandle,
			dwMilliseconds,
			bAlertable,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (uint32)(ret)
}

// //sys: int    	WideCharToMultiByte(UINT CodePage, DWORD dwFlags, LPCWSTR lpWideCharStr, int cchWideChar, LPSTR lpMultiByteStr, int cbMultiByte, LPCSTR lpDefaultChar, LPBOOL lpUsedDefaultChar);
func XWideCharToMultiByte(tls *TLS, CodePage uint32, dwFlags uint32, lpWideCharStr *uint16, cchWideChar int32, lpMultiByteStr *int8, cbMultiByte int32, lpDefaultChar *int8, lpUsedDefaultChar *int32) int32 {

	ret, _, err := syscall.Syscall9(procWideCharToMultiByte.Addr(), 8, uintptr(CodePage),
		uintptr(dwFlags),
		uintptr(unsafe.Pointer(lpWideCharStr)),
		uintptr(cchWideChar),
		uintptr(unsafe.Pointer(lpMultiByteStr)),
		uintptr(cbMultiByte),
		uintptr(unsafe.Pointer(lpDefaultChar)),
		uintptr(unsafe.Pointer(lpUsedDefaultChar)),
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "WideCharToMultiByte(%#x, %#x, %s, %#x, %s, %#x, %s, %#x) %#x %v\n", CodePage,
			dwFlags,
			lpWideCharStr,
			cchWideChar,
			GoUTF16String(unsafe.Pointer(lpMultiByteStr)),
			cbMultiByte,
			GoUTF16String(unsafe.Pointer(lpDefaultChar)),
			lpUsedDefaultChar,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (int32)(ret)
}

// //sys: BOOL   	WriteFile(HANDLE hFile, LPCVOID lpBuffer, DWORD nNumberOfBytesToWrite, LPDWORD lpNumberOfBytesWritten, LPOVERLAPPED lpOverlapped);
func XWriteFile(tls *TLS, hFile unsafe.Pointer, lpBuffer unsafe.Pointer, nNumberOfBytesToWrite uint32, lpNumberOfBytesWritten *uint32, lpOverlapped *XOVERLAPPED) int32 {

	ret, _, err := syscall.Syscall6(procWriteFile.Addr(), 5, uintptr(hFile),
		uintptr(lpBuffer),
		uintptr(nNumberOfBytesToWrite),
		uintptr(unsafe.Pointer(lpNumberOfBytesWritten)),
		uintptr(unsafe.Pointer(lpOverlapped)),
		0)
	if strace {
		fmt.Fprintf(os.Stderr, "WriteFile(%#x, %#x, %#x, %#x, %#x) %#x %v\n", hFile,
			lpBuffer,
			nNumberOfBytesToWrite,
			lpNumberOfBytesWritten,
			lpOverlapped,
			ret, err)
	}
	if err != 0 {
		tls.setErrno(err)
	}
	return (int32)(ret)
}
