# v1.0 - Moving Day

![](./v1.0/banner.png)

Off to a shiny new home.

## Organization

Moved repositories to [carapace-sh](https://github.com/carapace-sh).

```diff
import (
- "github.com/rsteube/carapace"
+ "github.com/carapace-sh/carapace"
)
```

## Diff

Added `--diff command[/bridge] ...args` to track changes.

```diff
--- a/zsh/carapace --macro bridge.Zsh git log -
+++ b/carapace/carapace git export git log -
- -- (start file arguments)
  --abbrev (Show the shortest prefix that is at least <n> hexdigits long that uniquely refers)
  --abbrev-commit (Instead of showing the full 40-byte hexadecimal commit object name, show a prefix that names the object uniquely.)
  --after (Show commits more recent than a specific date.)
  --all (Pretend as if all the refs in refs/, along with HEAD, are listed on the command line as <commit>.)
  --all-match (Limit the commits output to ones that match all given --grep, instead of ones that match at least one.)
+ --alternate-refs (Pretend as if all objects mentioned as ref tips of alternate repositories were listed on the command line.)
  --ancestry-path (When given a range of commits to display, only display commits that exist directly on the ancestry chain.)
  --anchored (Generate a diff using the "anchored diff" algorithm.)
  --author (Limit the commits output to ones with author/committer header lines that match the specified pattern)
  --author-date-order (Show no parents before all of its children are shown, but otherwise show commits in the author timestamp order.)
+ --basic-regexp (Consider the limiting patterns to be basic regular expressions; this is the default.)
  --before (Show commits older than a specific date.)
  --binary (In addition to --full-index, output a binary diff that can be applied with git-apply. Implies --patch.)
  --bisect (Pretend as if the bad bisection ref refs/bisect/bad was listed and as if it was followed by --not and the good bisection refs refs/bisect/good-* on the command line.)
  --boundary (Output excluded boundary commits. Boundary commits are prefixed with -.)
  --branches (Pretend as if all the refs in refs/heads are listed on the command line as <commit>.)
  --break-rewrites (Break complete rewrite changes into pairs of delete and create.)
- --cc (combined diff format for merge commits)
  --check (Warn if changes introduce conflict markers or whitespace errors.)
  --cherry (A synonym for --right-only --cherry-mark --no-merges)
```

![](./v1.0/diff.cast)

> The diff simply compares inserted values between completions provided by a [bridge] with those provided by carapace.
> It is just an indicator as there can be good reasons why these vary.

## Clear Cache

Added `--clear-cache` to remove [cached] completions.

![](./v1.0/clearCache.cast)

## Positional Arguments

Positional arguments can now be accessed as script parameters in [exec] macros .

```yaml
# yaml-language-server: $schema=https://carapace.sh/schemas/command.json
name: positional
flags:
  -b, --bool: bool flag
completion:
  positionalany: ["$(echo \"$@\tall arguments\")", "$(echo \"$1\tfirst argument\")"]
```

![](./v1.0/positional.cast)

[bridge]:../spec/bridge.md
[cached]:https://carapace-sh.github.io/carapace/carapace/action/cache.html
[exec]:https://carapace-sh.github.io/carapace-spec/carapace-spec/macros/core.html#exec
