// Code generated by smithy-go-codegen DO NOT EDIT.

package ssm

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ssm/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Gets the contents of the specified Amazon Web Services Systems Manager document
// (SSM document).
func (c *Client) GetDocument(ctx context.Context, params *GetDocumentInput, optFns ...func(*Options)) (*GetDocumentOutput, error) {
	if params == nil {
		params = &GetDocumentInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetDocument", params, optFns, c.addOperationGetDocumentMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetDocumentOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetDocumentInput struct {

	// The name of the SSM document.
	//
	// This member is required.
	Name *string

	// Returns the document in the specified format. The document format can be either
	// JSON or YAML. JSON is the default format.
	DocumentFormat types.DocumentFormat

	// The document version for which you want information.
	DocumentVersion *string

	// An optional field specifying the version of the artifact associated with the
	// document. For example, 12.6. This value is unique across all versions of a
	// document and can't be changed.
	VersionName *string

	noSmithyDocumentSerde
}

type GetDocumentOutput struct {

	// A description of the document attachments, including names, locations, sizes,
	// and so on.
	AttachmentsContent []types.AttachmentContent

	// The contents of the SSM document.
	Content *string

	// The date the SSM document was created.
	CreatedDate *time.Time

	// The friendly name of the SSM document. This value can differ for each version
	// of the document. If you want to update this value, see UpdateDocument.
	DisplayName *string

	// The document format, either JSON or YAML.
	DocumentFormat types.DocumentFormat

	// The document type.
	DocumentType types.DocumentType

	// The document version.
	DocumentVersion *string

	// The name of the SSM document.
	Name *string

	// A list of SSM documents required by a document. For example, an
	// ApplicationConfiguration document requires an ApplicationConfigurationSchema
	// document.
	Requires []types.DocumentRequires

	// The current review status of a new custom Systems Manager document (SSM
	// document) created by a member of your organization, or of the latest version of
	// an existing SSM document.
	//
	// Only one version of an SSM document can be in the APPROVED state at a time.
	// When a new version is approved, the status of the previous version changes to
	// REJECTED.
	//
	// Only one version of an SSM document can be in review, or PENDING, at a time.
	ReviewStatus types.ReviewStatus

	// The status of the SSM document, such as Creating , Active , Updating , Failed ,
	// and Deleting .
	Status types.DocumentStatus

	// A message returned by Amazon Web Services Systems Manager that explains the
	// Status value. For example, a Failed status might be explained by the
	// StatusInformation message, "The specified S3 bucket doesn't exist. Verify that
	// the URL of the S3 bucket is correct."
	StatusInformation *string

	// The version of the artifact associated with the document. For example, 12.6.
	// This value is unique across all versions of a document, and can't be changed.
	VersionName *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetDocumentMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetDocument{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetDocument{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetDocument"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetDocumentValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetDocument(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetDocument(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetDocument",
	}
}
