// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Use this operation to describe a FeatureGroup . The response includes
// information on the creation time, FeatureGroup name, the unique identifier for
// each FeatureGroup , and more.
func (c *Client) DescribeFeatureGroup(ctx context.Context, params *DescribeFeatureGroupInput, optFns ...func(*Options)) (*DescribeFeatureGroupOutput, error) {
	if params == nil {
		params = &DescribeFeatureGroupInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeFeatureGroup", params, optFns, c.addOperationDescribeFeatureGroupMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeFeatureGroupOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeFeatureGroupInput struct {

	// The name or Amazon Resource Name (ARN) of the FeatureGroup you want described.
	//
	// This member is required.
	FeatureGroupName *string

	// A token to resume pagination of the list of Features ( FeatureDefinitions ).
	// 2,500 Features are returned by default.
	NextToken *string

	noSmithyDocumentSerde
}

type DescribeFeatureGroupOutput struct {

	// A timestamp indicating when SageMaker created the FeatureGroup .
	//
	// This member is required.
	CreationTime *time.Time

	// The name of the feature that stores the EventTime of a Record in a FeatureGroup .
	//
	// An EventTime is a point in time when a new event occurs that corresponds to the
	// creation or update of a Record in a FeatureGroup . All Records in the
	// FeatureGroup have a corresponding EventTime .
	//
	// This member is required.
	EventTimeFeatureName *string

	// A list of the Features in the FeatureGroup . Each feature is defined by a
	// FeatureName and FeatureType .
	//
	// This member is required.
	FeatureDefinitions []types.FeatureDefinition

	// The Amazon Resource Name (ARN) of the FeatureGroup .
	//
	// This member is required.
	FeatureGroupArn *string

	// he name of the FeatureGroup .
	//
	// This member is required.
	FeatureGroupName *string

	// A token to resume pagination of the list of Features ( FeatureDefinitions ).
	//
	// This member is required.
	NextToken *string

	// The name of the Feature used for RecordIdentifier , whose value uniquely
	// identifies a record stored in the feature store.
	//
	// This member is required.
	RecordIdentifierFeatureName *string

	// A free form description of the feature group.
	Description *string

	// The reason that the FeatureGroup failed to be replicated in the OfflineStore .
	// This is failure can occur because:
	//
	//   - The FeatureGroup could not be created in the OfflineStore .
	//
	//   - The FeatureGroup could not be deleted from the OfflineStore .
	FailureReason *string

	// The status of the feature group.
	FeatureGroupStatus types.FeatureGroupStatus

	// A timestamp indicating when the feature group was last updated.
	LastModifiedTime *time.Time

	// A value indicating whether the update made to the feature group was successful.
	LastUpdateStatus *types.LastUpdateStatus

	// The configuration of the offline store. It includes the following
	// configurations:
	//
	//   - Amazon S3 location of the offline store.
	//
	//   - Configuration of the Glue data catalog.
	//
	//   - Table format of the offline store.
	//
	//   - Option to disable the automatic creation of a Glue table for the offline
	//   store.
	//
	//   - Encryption configuration.
	OfflineStoreConfig *types.OfflineStoreConfig

	// The status of the OfflineStore . Notifies you if replicating data into the
	// OfflineStore has failed. Returns either: Active or Blocked
	OfflineStoreStatus *types.OfflineStoreStatus

	// The configuration for the OnlineStore .
	OnlineStoreConfig *types.OnlineStoreConfig

	// The size of the OnlineStore in bytes.
	OnlineStoreTotalSizeBytes *int64

	// The Amazon Resource Name (ARN) of the IAM execution role used to persist data
	// into the OfflineStore if an OfflineStoreConfig is provided.
	RoleArn *string

	// Active throughput configuration of the feature group. There are two modes:
	// ON_DEMAND and PROVISIONED . With on-demand mode, you are charged for data reads
	// and writes that your application performs on your feature group. You do not need
	// to specify read and write throughput because Feature Store accommodates your
	// workloads as they ramp up and down. You can switch a feature group to on-demand
	// only once in a 24 hour period. With provisioned throughput mode, you specify the
	// read and write capacity per second that you expect your application to require,
	// and you are billed based on those limits. Exceeding provisioned throughput will
	// result in your requests being throttled.
	//
	// Note: PROVISIONED throughput mode is supported only for feature groups that are
	// offline-only, or use the [Standard]Standard tier online store.
	//
	// [Standard]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OnlineStoreConfig.html#sagemaker-Type-OnlineStoreConfig-StorageType
	ThroughputConfig *types.ThroughputConfigDescription

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeFeatureGroupMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeFeatureGroup{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeFeatureGroup{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeFeatureGroup"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeFeatureGroupValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeFeatureGroup(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeFeatureGroup(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeFeatureGroup",
	}
}
