// Code generated by smithy-go-codegen DO NOT EDIT.

package networkfirewall

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/networkfirewall/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates an Network Firewall Firewall and accompanying FirewallStatus for a VPC.
//
// The firewall defines the configuration settings for an Network Firewall
// firewall. The settings that you can define at creation include the firewall
// policy, the subnets in your VPC to use for the firewall endpoints, and any tags
// that are attached to the firewall Amazon Web Services resource.
//
// After you create a firewall, you can provide additional settings, like the
// logging configuration.
//
// To update the settings for a firewall, you use the operations that apply to the
// settings themselves, for example UpdateLoggingConfiguration, AssociateSubnets, and UpdateFirewallDeleteProtection.
//
// To manage a firewall's tags, use the standard Amazon Web Services resource
// tagging operations, ListTagsForResource, TagResource, and UntagResource.
//
// To retrieve information about firewalls, use ListFirewalls and DescribeFirewall.
//
// To generate a report on the last 30 days of traffic monitored by a firewall,
// use StartAnalysisReport.
func (c *Client) CreateFirewall(ctx context.Context, params *CreateFirewallInput, optFns ...func(*Options)) (*CreateFirewallOutput, error) {
	if params == nil {
		params = &CreateFirewallInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateFirewall", params, optFns, c.addOperationCreateFirewallMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateFirewallOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateFirewallInput struct {

	// The descriptive name of the firewall. You can't change the name of a firewall
	// after you create it.
	//
	// This member is required.
	FirewallName *string

	// The Amazon Resource Name (ARN) of the FirewallPolicy that you want to use for the firewall.
	//
	// This member is required.
	FirewallPolicyArn *string

	// Optional. A setting indicating whether the firewall is protected against
	// changes to its Availability Zone configuration. When set to TRUE , you cannot
	// add or remove Availability Zones without first disabling this protection using UpdateAvailabilityZoneChangeProtection.
	//
	// Default value: FALSE
	AvailabilityZoneChangeProtection bool

	// Required. The Availability Zones where you want to create firewall endpoints
	// for a transit gateway-attached firewall. You must specify at least one
	// Availability Zone. Consider enabling the firewall in every Availability Zone
	// where you have workloads to maintain Availability Zone independence.
	//
	// You can modify Availability Zones later using AssociateAvailabilityZones or DisassociateAvailabilityZones, but this may briefly
	// disrupt traffic. The AvailabilityZoneChangeProtection setting controls whether
	// you can make these modifications.
	AvailabilityZoneMappings []types.AvailabilityZoneMapping

	// A flag indicating whether it is possible to delete the firewall. A setting of
	// TRUE indicates that the firewall is protected against deletion. Use this setting
	// to protect against accidentally deleting a firewall that is in use. When you
	// create a firewall, the operation initializes this flag to TRUE .
	DeleteProtection bool

	// A description of the firewall.
	Description *string

	// An optional setting indicating the specific traffic analysis types to enable on
	// the firewall.
	EnabledAnalysisTypes []types.EnabledAnalysisType

	// A complex type that contains settings for encryption of your firewall resources.
	EncryptionConfiguration *types.EncryptionConfiguration

	// A setting indicating whether the firewall is protected against a change to the
	// firewall policy association. Use this setting to protect against accidentally
	// modifying the firewall policy for a firewall that is in use. When you create a
	// firewall, the operation initializes this setting to TRUE .
	FirewallPolicyChangeProtection bool

	// A setting indicating whether the firewall is protected against changes to the
	// subnet associations. Use this setting to protect against accidentally modifying
	// the subnet associations for a firewall that is in use. When you create a
	// firewall, the operation initializes this setting to TRUE .
	SubnetChangeProtection bool

	// The public subnets to use for your Network Firewall firewalls. Each subnet must
	// belong to a different Availability Zone in the VPC. Network Firewall creates a
	// firewall endpoint in each subnet.
	SubnetMappings []types.SubnetMapping

	// The key:value pairs to associate with the resource.
	Tags []types.Tag

	// Required when creating a transit gateway-attached firewall. The unique
	// identifier of the transit gateway to attach to this firewall. You can provide
	// either a transit gateway from your account or one that has been shared with you
	// through Resource Access Manager.
	//
	// After creating the firewall, you cannot change the transit gateway association.
	// To use a different transit gateway, you must create a new firewall.
	//
	// For information about creating firewalls, see CreateFirewall. For specific guidance about
	// transit gateway-attached firewalls, see [Considerations for transit gateway-attached firewalls]in the Network Firewall Developer Guide.
	//
	// [Considerations for transit gateway-attached firewalls]: https://docs.aws.amazon.com/network-firewall/latest/developerguide/tgw-firewall-considerations.html
	TransitGatewayId *string

	// The unique identifier of the VPC where Network Firewall should create the
	// firewall.
	//
	// You can't change this setting after you create the firewall.
	VpcId *string

	noSmithyDocumentSerde
}

type CreateFirewallOutput struct {

	// The configuration settings for the firewall. These settings include the
	// firewall policy and the subnets in your VPC to use for the firewall endpoints.
	Firewall *types.Firewall

	// Detailed information about the current status of a Firewall. You can retrieve this for
	// a firewall by calling DescribeFirewalland providing the firewall name and ARN.
	//
	// The firewall status indicates a combined status. It indicates whether all
	// subnets are up-to-date with the latest firewall configurations, which is based
	// on the sync states config values, and also whether all subnets have their
	// endpoints fully enabled, based on their sync states attachment values.
	FirewallStatus *types.FirewallStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateFirewallMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpCreateFirewall{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpCreateFirewall{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateFirewall"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateFirewallValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateFirewall(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateFirewall(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateFirewall",
	}
}
