// Code generated by smithy-go-codegen DO NOT EDIT.

package mpa

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/mpa/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of approval teams.
func (c *Client) ListApprovalTeams(ctx context.Context, params *ListApprovalTeamsInput, optFns ...func(*Options)) (*ListApprovalTeamsOutput, error) {
	if params == nil {
		params = &ListApprovalTeamsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListApprovalTeams", params, optFns, c.addOperationListApprovalTeamsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListApprovalTeamsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListApprovalTeamsInput struct {

	// The maximum number of items to return in the response. If more results exist
	// than the specified MaxResults value, a token is included in the response so
	// that you can retrieve the remaining results.
	MaxResults *int32

	// If present, indicates that more output is available than is included in the
	// current response. Use this value in the NextToken request parameter in a next
	// call to the operation to get more output. You can repeat this until the
	// NextToken response element returns null .
	NextToken *string

	noSmithyDocumentSerde
}

type ListApprovalTeamsOutput struct {

	// An array of ListApprovalTeamsResponseApprovalTeam objects. Contains details for
	// approval teams.
	ApprovalTeams []types.ListApprovalTeamsResponseApprovalTeam

	// If present, indicates that more output is available than is included in the
	// current response. Use this value in the NextToken request parameter in a next
	// call to the operation to get more output. You can repeat this until the
	// NextToken response element returns null .
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListApprovalTeamsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListApprovalTeams{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListApprovalTeams{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListApprovalTeams"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListApprovalTeams(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListApprovalTeamsPaginatorOptions is the paginator options for ListApprovalTeams
type ListApprovalTeamsPaginatorOptions struct {
	// The maximum number of items to return in the response. If more results exist
	// than the specified MaxResults value, a token is included in the response so
	// that you can retrieve the remaining results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListApprovalTeamsPaginator is a paginator for ListApprovalTeams
type ListApprovalTeamsPaginator struct {
	options   ListApprovalTeamsPaginatorOptions
	client    ListApprovalTeamsAPIClient
	params    *ListApprovalTeamsInput
	nextToken *string
	firstPage bool
}

// NewListApprovalTeamsPaginator returns a new ListApprovalTeamsPaginator
func NewListApprovalTeamsPaginator(client ListApprovalTeamsAPIClient, params *ListApprovalTeamsInput, optFns ...func(*ListApprovalTeamsPaginatorOptions)) *ListApprovalTeamsPaginator {
	if params == nil {
		params = &ListApprovalTeamsInput{}
	}

	options := ListApprovalTeamsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListApprovalTeamsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListApprovalTeamsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListApprovalTeams page.
func (p *ListApprovalTeamsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListApprovalTeamsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListApprovalTeams(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListApprovalTeamsAPIClient is a client that implements the ListApprovalTeams
// operation.
type ListApprovalTeamsAPIClient interface {
	ListApprovalTeams(context.Context, *ListApprovalTeamsInput, ...func(*Options)) (*ListApprovalTeamsOutput, error)
}

var _ ListApprovalTeamsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListApprovalTeams(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListApprovalTeams",
	}
}
