// Code generated by smithy-go-codegen DO NOT EDIT.

package glue

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/glue/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the history of previous optimizer runs for a specific table.
func (c *Client) ListTableOptimizerRuns(ctx context.Context, params *ListTableOptimizerRunsInput, optFns ...func(*Options)) (*ListTableOptimizerRunsOutput, error) {
	if params == nil {
		params = &ListTableOptimizerRunsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListTableOptimizerRuns", params, optFns, c.addOperationListTableOptimizerRunsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListTableOptimizerRunsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListTableOptimizerRunsInput struct {

	// The Catalog ID of the table.
	//
	// This member is required.
	CatalogId *string

	// The name of the database in the catalog in which the table resides.
	//
	// This member is required.
	DatabaseName *string

	// The name of the table.
	//
	// This member is required.
	TableName *string

	// The type of table optimizer.
	//
	// This member is required.
	Type types.TableOptimizerType

	// The maximum number of optimizer runs to return on each call.
	MaxResults int32

	// A continuation token, if this is a continuation call.
	NextToken *string

	noSmithyDocumentSerde
}

type ListTableOptimizerRunsOutput struct {

	// The Catalog ID of the table.
	CatalogId *string

	// The name of the database in the catalog in which the table resides.
	DatabaseName *string

	// A continuation token for paginating the returned list of optimizer runs,
	// returned if the current segment of the list is not the last.
	NextToken *string

	// The name of the table.
	TableName *string

	// A list of the optimizer runs associated with a table.
	TableOptimizerRuns []types.TableOptimizerRun

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListTableOptimizerRunsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListTableOptimizerRuns{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListTableOptimizerRuns{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListTableOptimizerRuns"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListTableOptimizerRunsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListTableOptimizerRuns(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListTableOptimizerRunsPaginatorOptions is the paginator options for
// ListTableOptimizerRuns
type ListTableOptimizerRunsPaginatorOptions struct {
	// The maximum number of optimizer runs to return on each call.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListTableOptimizerRunsPaginator is a paginator for ListTableOptimizerRuns
type ListTableOptimizerRunsPaginator struct {
	options   ListTableOptimizerRunsPaginatorOptions
	client    ListTableOptimizerRunsAPIClient
	params    *ListTableOptimizerRunsInput
	nextToken *string
	firstPage bool
}

// NewListTableOptimizerRunsPaginator returns a new ListTableOptimizerRunsPaginator
func NewListTableOptimizerRunsPaginator(client ListTableOptimizerRunsAPIClient, params *ListTableOptimizerRunsInput, optFns ...func(*ListTableOptimizerRunsPaginatorOptions)) *ListTableOptimizerRunsPaginator {
	if params == nil {
		params = &ListTableOptimizerRunsInput{}
	}

	options := ListTableOptimizerRunsPaginatorOptions{}
	if params.MaxResults != 0 {
		options.Limit = params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListTableOptimizerRunsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListTableOptimizerRunsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListTableOptimizerRuns page.
func (p *ListTableOptimizerRunsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListTableOptimizerRunsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	params.MaxResults = p.options.Limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListTableOptimizerRuns(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListTableOptimizerRunsAPIClient is a client that implements the
// ListTableOptimizerRuns operation.
type ListTableOptimizerRunsAPIClient interface {
	ListTableOptimizerRuns(context.Context, *ListTableOptimizerRunsInput, ...func(*Options)) (*ListTableOptimizerRunsOutput, error)
}

var _ ListTableOptimizerRunsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListTableOptimizerRuns(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListTableOptimizerRuns",
	}
}
