// Code generated by smithy-go-codegen DO NOT EDIT.

package fsx

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/fsx/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"path"
)

type awsAwsjson11_serializeOpAssociateFileSystemAliases struct {
}

func (*awsAwsjson11_serializeOpAssociateFileSystemAliases) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpAssociateFileSystemAliases) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateFileSystemAliasesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.AssociateFileSystemAliases")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentAssociateFileSystemAliasesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCancelDataRepositoryTask struct {
}

func (*awsAwsjson11_serializeOpCancelDataRepositoryTask) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCancelDataRepositoryTask) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CancelDataRepositoryTaskInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.CancelDataRepositoryTask")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCancelDataRepositoryTaskInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCopyBackup struct {
}

func (*awsAwsjson11_serializeOpCopyBackup) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCopyBackup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CopyBackupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.CopyBackup")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCopyBackupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCopySnapshotAndUpdateVolume struct {
}

func (*awsAwsjson11_serializeOpCopySnapshotAndUpdateVolume) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCopySnapshotAndUpdateVolume) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CopySnapshotAndUpdateVolumeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.CopySnapshotAndUpdateVolume")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCopySnapshotAndUpdateVolumeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateAndAttachS3AccessPoint struct {
}

func (*awsAwsjson11_serializeOpCreateAndAttachS3AccessPoint) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateAndAttachS3AccessPoint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateAndAttachS3AccessPointInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.CreateAndAttachS3AccessPoint")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateAndAttachS3AccessPointInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateBackup struct {
}

func (*awsAwsjson11_serializeOpCreateBackup) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateBackup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateBackupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.CreateBackup")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateBackupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateDataRepositoryAssociation struct {
}

func (*awsAwsjson11_serializeOpCreateDataRepositoryAssociation) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateDataRepositoryAssociation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDataRepositoryAssociationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.CreateDataRepositoryAssociation")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateDataRepositoryAssociationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateDataRepositoryTask struct {
}

func (*awsAwsjson11_serializeOpCreateDataRepositoryTask) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateDataRepositoryTask) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDataRepositoryTaskInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.CreateDataRepositoryTask")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateDataRepositoryTaskInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateFileCache struct {
}

func (*awsAwsjson11_serializeOpCreateFileCache) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateFileCache) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateFileCacheInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.CreateFileCache")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateFileCacheInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateFileSystem struct {
}

func (*awsAwsjson11_serializeOpCreateFileSystem) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateFileSystem) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateFileSystemInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.CreateFileSystem")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateFileSystemInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateFileSystemFromBackup struct {
}

func (*awsAwsjson11_serializeOpCreateFileSystemFromBackup) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateFileSystemFromBackup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateFileSystemFromBackupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.CreateFileSystemFromBackup")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateFileSystemFromBackupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateSnapshot struct {
}

func (*awsAwsjson11_serializeOpCreateSnapshot) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateSnapshot) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateSnapshotInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.CreateSnapshot")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateSnapshotInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateStorageVirtualMachine struct {
}

func (*awsAwsjson11_serializeOpCreateStorageVirtualMachine) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateStorageVirtualMachine) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateStorageVirtualMachineInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.CreateStorageVirtualMachine")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateStorageVirtualMachineInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateVolume struct {
}

func (*awsAwsjson11_serializeOpCreateVolume) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateVolume) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateVolumeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.CreateVolume")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateVolumeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateVolumeFromBackup struct {
}

func (*awsAwsjson11_serializeOpCreateVolumeFromBackup) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateVolumeFromBackup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateVolumeFromBackupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.CreateVolumeFromBackup")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateVolumeFromBackupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteBackup struct {
}

func (*awsAwsjson11_serializeOpDeleteBackup) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteBackup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBackupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.DeleteBackup")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteBackupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteDataRepositoryAssociation struct {
}

func (*awsAwsjson11_serializeOpDeleteDataRepositoryAssociation) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteDataRepositoryAssociation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteDataRepositoryAssociationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.DeleteDataRepositoryAssociation")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteDataRepositoryAssociationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteFileCache struct {
}

func (*awsAwsjson11_serializeOpDeleteFileCache) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteFileCache) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteFileCacheInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.DeleteFileCache")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteFileCacheInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteFileSystem struct {
}

func (*awsAwsjson11_serializeOpDeleteFileSystem) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteFileSystem) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteFileSystemInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.DeleteFileSystem")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteFileSystemInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteSnapshot struct {
}

func (*awsAwsjson11_serializeOpDeleteSnapshot) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteSnapshot) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteSnapshotInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.DeleteSnapshot")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteSnapshotInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteStorageVirtualMachine struct {
}

func (*awsAwsjson11_serializeOpDeleteStorageVirtualMachine) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteStorageVirtualMachine) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteStorageVirtualMachineInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.DeleteStorageVirtualMachine")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteStorageVirtualMachineInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDeleteVolume struct {
}

func (*awsAwsjson11_serializeOpDeleteVolume) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDeleteVolume) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteVolumeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.DeleteVolume")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDeleteVolumeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeBackups struct {
}

func (*awsAwsjson11_serializeOpDescribeBackups) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeBackups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeBackupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.DescribeBackups")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeBackupsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeDataRepositoryAssociations struct {
}

func (*awsAwsjson11_serializeOpDescribeDataRepositoryAssociations) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeDataRepositoryAssociations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeDataRepositoryAssociationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.DescribeDataRepositoryAssociations")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeDataRepositoryAssociationsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeDataRepositoryTasks struct {
}

func (*awsAwsjson11_serializeOpDescribeDataRepositoryTasks) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeDataRepositoryTasks) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeDataRepositoryTasksInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.DescribeDataRepositoryTasks")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeDataRepositoryTasksInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeFileCaches struct {
}

func (*awsAwsjson11_serializeOpDescribeFileCaches) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeFileCaches) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeFileCachesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.DescribeFileCaches")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeFileCachesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeFileSystemAliases struct {
}

func (*awsAwsjson11_serializeOpDescribeFileSystemAliases) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeFileSystemAliases) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeFileSystemAliasesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.DescribeFileSystemAliases")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeFileSystemAliasesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeFileSystems struct {
}

func (*awsAwsjson11_serializeOpDescribeFileSystems) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeFileSystems) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeFileSystemsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.DescribeFileSystems")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeFileSystemsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeS3AccessPointAttachments struct {
}

func (*awsAwsjson11_serializeOpDescribeS3AccessPointAttachments) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeS3AccessPointAttachments) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeS3AccessPointAttachmentsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.DescribeS3AccessPointAttachments")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeS3AccessPointAttachmentsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeSharedVpcConfiguration struct {
}

func (*awsAwsjson11_serializeOpDescribeSharedVpcConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeSharedVpcConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeSharedVpcConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.DescribeSharedVpcConfiguration")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeSharedVpcConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeSnapshots struct {
}

func (*awsAwsjson11_serializeOpDescribeSnapshots) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeSnapshots) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeSnapshotsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.DescribeSnapshots")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeSnapshotsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeStorageVirtualMachines struct {
}

func (*awsAwsjson11_serializeOpDescribeStorageVirtualMachines) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeStorageVirtualMachines) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeStorageVirtualMachinesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.DescribeStorageVirtualMachines")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeStorageVirtualMachinesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeVolumes struct {
}

func (*awsAwsjson11_serializeOpDescribeVolumes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeVolumes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeVolumesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.DescribeVolumes")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeVolumesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDetachAndDeleteS3AccessPoint struct {
}

func (*awsAwsjson11_serializeOpDetachAndDeleteS3AccessPoint) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDetachAndDeleteS3AccessPoint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DetachAndDeleteS3AccessPointInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.DetachAndDeleteS3AccessPoint")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDetachAndDeleteS3AccessPointInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDisassociateFileSystemAliases struct {
}

func (*awsAwsjson11_serializeOpDisassociateFileSystemAliases) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDisassociateFileSystemAliases) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateFileSystemAliasesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.DisassociateFileSystemAliases")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDisassociateFileSystemAliasesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListTagsForResource struct {
}

func (*awsAwsjson11_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.ListTagsForResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListTagsForResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpReleaseFileSystemNfsV3Locks struct {
}

func (*awsAwsjson11_serializeOpReleaseFileSystemNfsV3Locks) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpReleaseFileSystemNfsV3Locks) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ReleaseFileSystemNfsV3LocksInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.ReleaseFileSystemNfsV3Locks")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentReleaseFileSystemNfsV3LocksInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpRestoreVolumeFromSnapshot struct {
}

func (*awsAwsjson11_serializeOpRestoreVolumeFromSnapshot) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpRestoreVolumeFromSnapshot) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RestoreVolumeFromSnapshotInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.RestoreVolumeFromSnapshot")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentRestoreVolumeFromSnapshotInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpStartMisconfiguredStateRecovery struct {
}

func (*awsAwsjson11_serializeOpStartMisconfiguredStateRecovery) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpStartMisconfiguredStateRecovery) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartMisconfiguredStateRecoveryInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.StartMisconfiguredStateRecovery")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentStartMisconfiguredStateRecoveryInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpTagResource struct {
}

func (*awsAwsjson11_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.TagResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUntagResource struct {
}

func (*awsAwsjson11_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.UntagResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUntagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateDataRepositoryAssociation struct {
}

func (*awsAwsjson11_serializeOpUpdateDataRepositoryAssociation) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateDataRepositoryAssociation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateDataRepositoryAssociationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.UpdateDataRepositoryAssociation")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateDataRepositoryAssociationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateFileCache struct {
}

func (*awsAwsjson11_serializeOpUpdateFileCache) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateFileCache) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateFileCacheInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.UpdateFileCache")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateFileCacheInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateFileSystem struct {
}

func (*awsAwsjson11_serializeOpUpdateFileSystem) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateFileSystem) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateFileSystemInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.UpdateFileSystem")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateFileSystemInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateSharedVpcConfiguration struct {
}

func (*awsAwsjson11_serializeOpUpdateSharedVpcConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateSharedVpcConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateSharedVpcConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.UpdateSharedVpcConfiguration")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateSharedVpcConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateSnapshot struct {
}

func (*awsAwsjson11_serializeOpUpdateSnapshot) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateSnapshot) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateSnapshotInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.UpdateSnapshot")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateSnapshotInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateStorageVirtualMachine struct {
}

func (*awsAwsjson11_serializeOpUpdateStorageVirtualMachine) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateStorageVirtualMachine) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateStorageVirtualMachineInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.UpdateStorageVirtualMachine")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateStorageVirtualMachineInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateVolume struct {
}

func (*awsAwsjson11_serializeOpUpdateVolume) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateVolume) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateVolumeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSSimbaAPIService_v20180301.UpdateVolume")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateVolumeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsAwsjson11_serializeDocumentAggregates(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentAlternateDNSNames(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentAutocommitPeriod(v *types.AutocommitPeriod, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.Integer(*v.Value)
	}

	return nil
}

func awsAwsjson11_serializeDocumentAutoExportPolicy(v *types.AutoExportPolicy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Events != nil {
		ok := object.Key("Events")
		if err := awsAwsjson11_serializeDocumentEventTypes(v.Events, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentAutoImportPolicy(v *types.AutoImportPolicy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Events != nil {
		ok := object.Key("Events")
		if err := awsAwsjson11_serializeDocumentEventTypes(v.Events, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentBackupIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentCompletionReport(v *types.CompletionReport, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Enabled != nil {
		ok := object.Key("Enabled")
		ok.Boolean(*v.Enabled)
	}

	if len(v.Format) > 0 {
		ok := object.Key("Format")
		ok.String(string(v.Format))
	}

	if v.Path != nil {
		ok := object.Key("Path")
		ok.String(*v.Path)
	}

	if len(v.Scope) > 0 {
		ok := object.Key("Scope")
		ok.String(string(v.Scope))
	}

	return nil
}

func awsAwsjson11_serializeDocumentCreateAggregateConfiguration(v *types.CreateAggregateConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Aggregates != nil {
		ok := object.Key("Aggregates")
		if err := awsAwsjson11_serializeDocumentAggregates(v.Aggregates, ok); err != nil {
			return err
		}
	}

	if v.ConstituentsPerAggregate != nil {
		ok := object.Key("ConstituentsPerAggregate")
		ok.Integer(*v.ConstituentsPerAggregate)
	}

	return nil
}

func awsAwsjson11_serializeDocumentCreateAndAttachS3AccessPointOpenZFSConfiguration(v *types.CreateAndAttachS3AccessPointOpenZFSConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FileSystemIdentity != nil {
		ok := object.Key("FileSystemIdentity")
		if err := awsAwsjson11_serializeDocumentOpenZFSFileSystemIdentity(v.FileSystemIdentity, ok); err != nil {
			return err
		}
	}

	if v.VolumeId != nil {
		ok := object.Key("VolumeId")
		ok.String(*v.VolumeId)
	}

	return nil
}

func awsAwsjson11_serializeDocumentCreateAndAttachS3AccessPointS3Configuration(v *types.CreateAndAttachS3AccessPointS3Configuration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Policy != nil {
		ok := object.Key("Policy")
		ok.String(*v.Policy)
	}

	if v.VpcConfiguration != nil {
		ok := object.Key("VpcConfiguration")
		if err := awsAwsjson11_serializeDocumentS3AccessPointVpcConfiguration(v.VpcConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentCreateFileCacheDataRepositoryAssociations(v []types.FileCacheDataRepositoryAssociation, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentFileCacheDataRepositoryAssociation(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentCreateFileCacheLustreConfiguration(v *types.CreateFileCacheLustreConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DeploymentType) > 0 {
		ok := object.Key("DeploymentType")
		ok.String(string(v.DeploymentType))
	}

	if v.MetadataConfiguration != nil {
		ok := object.Key("MetadataConfiguration")
		if err := awsAwsjson11_serializeDocumentFileCacheLustreMetadataConfiguration(v.MetadataConfiguration, ok); err != nil {
			return err
		}
	}

	if v.PerUnitStorageThroughput != nil {
		ok := object.Key("PerUnitStorageThroughput")
		ok.Integer(*v.PerUnitStorageThroughput)
	}

	if v.WeeklyMaintenanceStartTime != nil {
		ok := object.Key("WeeklyMaintenanceStartTime")
		ok.String(*v.WeeklyMaintenanceStartTime)
	}

	return nil
}

func awsAwsjson11_serializeDocumentCreateFileSystemLustreConfiguration(v *types.CreateFileSystemLustreConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AutoImportPolicy) > 0 {
		ok := object.Key("AutoImportPolicy")
		ok.String(string(v.AutoImportPolicy))
	}

	if v.AutomaticBackupRetentionDays != nil {
		ok := object.Key("AutomaticBackupRetentionDays")
		ok.Integer(*v.AutomaticBackupRetentionDays)
	}

	if v.CopyTagsToBackups != nil {
		ok := object.Key("CopyTagsToBackups")
		ok.Boolean(*v.CopyTagsToBackups)
	}

	if v.DailyAutomaticBackupStartTime != nil {
		ok := object.Key("DailyAutomaticBackupStartTime")
		ok.String(*v.DailyAutomaticBackupStartTime)
	}

	if len(v.DataCompressionType) > 0 {
		ok := object.Key("DataCompressionType")
		ok.String(string(v.DataCompressionType))
	}

	if v.DataReadCacheConfiguration != nil {
		ok := object.Key("DataReadCacheConfiguration")
		if err := awsAwsjson11_serializeDocumentLustreReadCacheConfiguration(v.DataReadCacheConfiguration, ok); err != nil {
			return err
		}
	}

	if len(v.DeploymentType) > 0 {
		ok := object.Key("DeploymentType")
		ok.String(string(v.DeploymentType))
	}

	if len(v.DriveCacheType) > 0 {
		ok := object.Key("DriveCacheType")
		ok.String(string(v.DriveCacheType))
	}

	if v.EfaEnabled != nil {
		ok := object.Key("EfaEnabled")
		ok.Boolean(*v.EfaEnabled)
	}

	if v.ExportPath != nil {
		ok := object.Key("ExportPath")
		ok.String(*v.ExportPath)
	}

	if v.ImportedFileChunkSize != nil {
		ok := object.Key("ImportedFileChunkSize")
		ok.Integer(*v.ImportedFileChunkSize)
	}

	if v.ImportPath != nil {
		ok := object.Key("ImportPath")
		ok.String(*v.ImportPath)
	}

	if v.LogConfiguration != nil {
		ok := object.Key("LogConfiguration")
		if err := awsAwsjson11_serializeDocumentLustreLogCreateConfiguration(v.LogConfiguration, ok); err != nil {
			return err
		}
	}

	if v.MetadataConfiguration != nil {
		ok := object.Key("MetadataConfiguration")
		if err := awsAwsjson11_serializeDocumentCreateFileSystemLustreMetadataConfiguration(v.MetadataConfiguration, ok); err != nil {
			return err
		}
	}

	if v.PerUnitStorageThroughput != nil {
		ok := object.Key("PerUnitStorageThroughput")
		ok.Integer(*v.PerUnitStorageThroughput)
	}

	if v.RootSquashConfiguration != nil {
		ok := object.Key("RootSquashConfiguration")
		if err := awsAwsjson11_serializeDocumentLustreRootSquashConfiguration(v.RootSquashConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ThroughputCapacity != nil {
		ok := object.Key("ThroughputCapacity")
		ok.Integer(*v.ThroughputCapacity)
	}

	if v.WeeklyMaintenanceStartTime != nil {
		ok := object.Key("WeeklyMaintenanceStartTime")
		ok.String(*v.WeeklyMaintenanceStartTime)
	}

	return nil
}

func awsAwsjson11_serializeDocumentCreateFileSystemLustreMetadataConfiguration(v *types.CreateFileSystemLustreMetadataConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Iops != nil {
		ok := object.Key("Iops")
		ok.Integer(*v.Iops)
	}

	if len(v.Mode) > 0 {
		ok := object.Key("Mode")
		ok.String(string(v.Mode))
	}

	return nil
}

func awsAwsjson11_serializeDocumentCreateFileSystemOntapConfiguration(v *types.CreateFileSystemOntapConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AutomaticBackupRetentionDays != nil {
		ok := object.Key("AutomaticBackupRetentionDays")
		ok.Integer(*v.AutomaticBackupRetentionDays)
	}

	if v.DailyAutomaticBackupStartTime != nil {
		ok := object.Key("DailyAutomaticBackupStartTime")
		ok.String(*v.DailyAutomaticBackupStartTime)
	}

	if len(v.DeploymentType) > 0 {
		ok := object.Key("DeploymentType")
		ok.String(string(v.DeploymentType))
	}

	if v.DiskIopsConfiguration != nil {
		ok := object.Key("DiskIopsConfiguration")
		if err := awsAwsjson11_serializeDocumentDiskIopsConfiguration(v.DiskIopsConfiguration, ok); err != nil {
			return err
		}
	}

	if v.EndpointIpAddressRange != nil {
		ok := object.Key("EndpointIpAddressRange")
		ok.String(*v.EndpointIpAddressRange)
	}

	if v.FsxAdminPassword != nil {
		ok := object.Key("FsxAdminPassword")
		ok.String(*v.FsxAdminPassword)
	}

	if v.HAPairs != nil {
		ok := object.Key("HAPairs")
		ok.Integer(*v.HAPairs)
	}

	if v.PreferredSubnetId != nil {
		ok := object.Key("PreferredSubnetId")
		ok.String(*v.PreferredSubnetId)
	}

	if v.RouteTableIds != nil {
		ok := object.Key("RouteTableIds")
		if err := awsAwsjson11_serializeDocumentRouteTableIds(v.RouteTableIds, ok); err != nil {
			return err
		}
	}

	if v.ThroughputCapacity != nil {
		ok := object.Key("ThroughputCapacity")
		ok.Integer(*v.ThroughputCapacity)
	}

	if v.ThroughputCapacityPerHAPair != nil {
		ok := object.Key("ThroughputCapacityPerHAPair")
		ok.Integer(*v.ThroughputCapacityPerHAPair)
	}

	if v.WeeklyMaintenanceStartTime != nil {
		ok := object.Key("WeeklyMaintenanceStartTime")
		ok.String(*v.WeeklyMaintenanceStartTime)
	}

	return nil
}

func awsAwsjson11_serializeDocumentCreateFileSystemOpenZFSConfiguration(v *types.CreateFileSystemOpenZFSConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AutomaticBackupRetentionDays != nil {
		ok := object.Key("AutomaticBackupRetentionDays")
		ok.Integer(*v.AutomaticBackupRetentionDays)
	}

	if v.CopyTagsToBackups != nil {
		ok := object.Key("CopyTagsToBackups")
		ok.Boolean(*v.CopyTagsToBackups)
	}

	if v.CopyTagsToVolumes != nil {
		ok := object.Key("CopyTagsToVolumes")
		ok.Boolean(*v.CopyTagsToVolumes)
	}

	if v.DailyAutomaticBackupStartTime != nil {
		ok := object.Key("DailyAutomaticBackupStartTime")
		ok.String(*v.DailyAutomaticBackupStartTime)
	}

	if len(v.DeploymentType) > 0 {
		ok := object.Key("DeploymentType")
		ok.String(string(v.DeploymentType))
	}

	if v.DiskIopsConfiguration != nil {
		ok := object.Key("DiskIopsConfiguration")
		if err := awsAwsjson11_serializeDocumentDiskIopsConfiguration(v.DiskIopsConfiguration, ok); err != nil {
			return err
		}
	}

	if v.EndpointIpAddressRange != nil {
		ok := object.Key("EndpointIpAddressRange")
		ok.String(*v.EndpointIpAddressRange)
	}

	if v.EndpointIpv6AddressRange != nil {
		ok := object.Key("EndpointIpv6AddressRange")
		ok.String(*v.EndpointIpv6AddressRange)
	}

	if v.PreferredSubnetId != nil {
		ok := object.Key("PreferredSubnetId")
		ok.String(*v.PreferredSubnetId)
	}

	if v.ReadCacheConfiguration != nil {
		ok := object.Key("ReadCacheConfiguration")
		if err := awsAwsjson11_serializeDocumentOpenZFSReadCacheConfiguration(v.ReadCacheConfiguration, ok); err != nil {
			return err
		}
	}

	if v.RootVolumeConfiguration != nil {
		ok := object.Key("RootVolumeConfiguration")
		if err := awsAwsjson11_serializeDocumentOpenZFSCreateRootVolumeConfiguration(v.RootVolumeConfiguration, ok); err != nil {
			return err
		}
	}

	if v.RouteTableIds != nil {
		ok := object.Key("RouteTableIds")
		if err := awsAwsjson11_serializeDocumentRouteTableIds(v.RouteTableIds, ok); err != nil {
			return err
		}
	}

	if v.ThroughputCapacity != nil {
		ok := object.Key("ThroughputCapacity")
		ok.Integer(*v.ThroughputCapacity)
	}

	if v.WeeklyMaintenanceStartTime != nil {
		ok := object.Key("WeeklyMaintenanceStartTime")
		ok.String(*v.WeeklyMaintenanceStartTime)
	}

	return nil
}

func awsAwsjson11_serializeDocumentCreateFileSystemWindowsConfiguration(v *types.CreateFileSystemWindowsConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ActiveDirectoryId != nil {
		ok := object.Key("ActiveDirectoryId")
		ok.String(*v.ActiveDirectoryId)
	}

	if v.Aliases != nil {
		ok := object.Key("Aliases")
		if err := awsAwsjson11_serializeDocumentAlternateDNSNames(v.Aliases, ok); err != nil {
			return err
		}
	}

	if v.AuditLogConfiguration != nil {
		ok := object.Key("AuditLogConfiguration")
		if err := awsAwsjson11_serializeDocumentWindowsAuditLogCreateConfiguration(v.AuditLogConfiguration, ok); err != nil {
			return err
		}
	}

	if v.AutomaticBackupRetentionDays != nil {
		ok := object.Key("AutomaticBackupRetentionDays")
		ok.Integer(*v.AutomaticBackupRetentionDays)
	}

	if v.CopyTagsToBackups != nil {
		ok := object.Key("CopyTagsToBackups")
		ok.Boolean(*v.CopyTagsToBackups)
	}

	if v.DailyAutomaticBackupStartTime != nil {
		ok := object.Key("DailyAutomaticBackupStartTime")
		ok.String(*v.DailyAutomaticBackupStartTime)
	}

	if len(v.DeploymentType) > 0 {
		ok := object.Key("DeploymentType")
		ok.String(string(v.DeploymentType))
	}

	if v.DiskIopsConfiguration != nil {
		ok := object.Key("DiskIopsConfiguration")
		if err := awsAwsjson11_serializeDocumentDiskIopsConfiguration(v.DiskIopsConfiguration, ok); err != nil {
			return err
		}
	}

	if v.PreferredSubnetId != nil {
		ok := object.Key("PreferredSubnetId")
		ok.String(*v.PreferredSubnetId)
	}

	if v.SelfManagedActiveDirectoryConfiguration != nil {
		ok := object.Key("SelfManagedActiveDirectoryConfiguration")
		if err := awsAwsjson11_serializeDocumentSelfManagedActiveDirectoryConfiguration(v.SelfManagedActiveDirectoryConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ThroughputCapacity != nil {
		ok := object.Key("ThroughputCapacity")
		ok.Integer(*v.ThroughputCapacity)
	}

	if v.WeeklyMaintenanceStartTime != nil {
		ok := object.Key("WeeklyMaintenanceStartTime")
		ok.String(*v.WeeklyMaintenanceStartTime)
	}

	return nil
}

func awsAwsjson11_serializeDocumentCreateOntapVolumeConfiguration(v *types.CreateOntapVolumeConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AggregateConfiguration != nil {
		ok := object.Key("AggregateConfiguration")
		if err := awsAwsjson11_serializeDocumentCreateAggregateConfiguration(v.AggregateConfiguration, ok); err != nil {
			return err
		}
	}

	if v.CopyTagsToBackups != nil {
		ok := object.Key("CopyTagsToBackups")
		ok.Boolean(*v.CopyTagsToBackups)
	}

	if v.JunctionPath != nil {
		ok := object.Key("JunctionPath")
		ok.String(*v.JunctionPath)
	}

	if len(v.OntapVolumeType) > 0 {
		ok := object.Key("OntapVolumeType")
		ok.String(string(v.OntapVolumeType))
	}

	if len(v.SecurityStyle) > 0 {
		ok := object.Key("SecurityStyle")
		ok.String(string(v.SecurityStyle))
	}

	if v.SizeInBytes != nil {
		ok := object.Key("SizeInBytes")
		ok.Long(*v.SizeInBytes)
	}

	if v.SizeInMegabytes != nil {
		ok := object.Key("SizeInMegabytes")
		ok.Integer(*v.SizeInMegabytes)
	}

	if v.SnaplockConfiguration != nil {
		ok := object.Key("SnaplockConfiguration")
		if err := awsAwsjson11_serializeDocumentCreateSnaplockConfiguration(v.SnaplockConfiguration, ok); err != nil {
			return err
		}
	}

	if v.SnapshotPolicy != nil {
		ok := object.Key("SnapshotPolicy")
		ok.String(*v.SnapshotPolicy)
	}

	if v.StorageEfficiencyEnabled != nil {
		ok := object.Key("StorageEfficiencyEnabled")
		ok.Boolean(*v.StorageEfficiencyEnabled)
	}

	if v.StorageVirtualMachineId != nil {
		ok := object.Key("StorageVirtualMachineId")
		ok.String(*v.StorageVirtualMachineId)
	}

	if v.TieringPolicy != nil {
		ok := object.Key("TieringPolicy")
		if err := awsAwsjson11_serializeDocumentTieringPolicy(v.TieringPolicy, ok); err != nil {
			return err
		}
	}

	if len(v.VolumeStyle) > 0 {
		ok := object.Key("VolumeStyle")
		ok.String(string(v.VolumeStyle))
	}

	return nil
}

func awsAwsjson11_serializeDocumentCreateOpenZFSOriginSnapshotConfiguration(v *types.CreateOpenZFSOriginSnapshotConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.CopyStrategy) > 0 {
		ok := object.Key("CopyStrategy")
		ok.String(string(v.CopyStrategy))
	}

	if v.SnapshotARN != nil {
		ok := object.Key("SnapshotARN")
		ok.String(*v.SnapshotARN)
	}

	return nil
}

func awsAwsjson11_serializeDocumentCreateOpenZFSVolumeConfiguration(v *types.CreateOpenZFSVolumeConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CopyTagsToSnapshots != nil {
		ok := object.Key("CopyTagsToSnapshots")
		ok.Boolean(*v.CopyTagsToSnapshots)
	}

	if len(v.DataCompressionType) > 0 {
		ok := object.Key("DataCompressionType")
		ok.String(string(v.DataCompressionType))
	}

	if v.NfsExports != nil {
		ok := object.Key("NfsExports")
		if err := awsAwsjson11_serializeDocumentOpenZFSNfsExports(v.NfsExports, ok); err != nil {
			return err
		}
	}

	if v.OriginSnapshot != nil {
		ok := object.Key("OriginSnapshot")
		if err := awsAwsjson11_serializeDocumentCreateOpenZFSOriginSnapshotConfiguration(v.OriginSnapshot, ok); err != nil {
			return err
		}
	}

	if v.ParentVolumeId != nil {
		ok := object.Key("ParentVolumeId")
		ok.String(*v.ParentVolumeId)
	}

	if v.ReadOnly != nil {
		ok := object.Key("ReadOnly")
		ok.Boolean(*v.ReadOnly)
	}

	if v.RecordSizeKiB != nil {
		ok := object.Key("RecordSizeKiB")
		ok.Integer(*v.RecordSizeKiB)
	}

	if v.StorageCapacityQuotaGiB != nil {
		ok := object.Key("StorageCapacityQuotaGiB")
		ok.Integer(*v.StorageCapacityQuotaGiB)
	}

	if v.StorageCapacityReservationGiB != nil {
		ok := object.Key("StorageCapacityReservationGiB")
		ok.Integer(*v.StorageCapacityReservationGiB)
	}

	if v.UserAndGroupQuotas != nil {
		ok := object.Key("UserAndGroupQuotas")
		if err := awsAwsjson11_serializeDocumentOpenZFSUserAndGroupQuotas(v.UserAndGroupQuotas, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentCreateSnaplockConfiguration(v *types.CreateSnaplockConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuditLogVolume != nil {
		ok := object.Key("AuditLogVolume")
		ok.Boolean(*v.AuditLogVolume)
	}

	if v.AutocommitPeriod != nil {
		ok := object.Key("AutocommitPeriod")
		if err := awsAwsjson11_serializeDocumentAutocommitPeriod(v.AutocommitPeriod, ok); err != nil {
			return err
		}
	}

	if len(v.PrivilegedDelete) > 0 {
		ok := object.Key("PrivilegedDelete")
		ok.String(string(v.PrivilegedDelete))
	}

	if v.RetentionPeriod != nil {
		ok := object.Key("RetentionPeriod")
		if err := awsAwsjson11_serializeDocumentSnaplockRetentionPeriod(v.RetentionPeriod, ok); err != nil {
			return err
		}
	}

	if len(v.SnaplockType) > 0 {
		ok := object.Key("SnaplockType")
		ok.String(string(v.SnaplockType))
	}

	if v.VolumeAppendModeEnabled != nil {
		ok := object.Key("VolumeAppendModeEnabled")
		ok.Boolean(*v.VolumeAppendModeEnabled)
	}

	return nil
}

func awsAwsjson11_serializeDocumentCreateSvmActiveDirectoryConfiguration(v *types.CreateSvmActiveDirectoryConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NetBiosName != nil {
		ok := object.Key("NetBiosName")
		ok.String(*v.NetBiosName)
	}

	if v.SelfManagedActiveDirectoryConfiguration != nil {
		ok := object.Key("SelfManagedActiveDirectoryConfiguration")
		if err := awsAwsjson11_serializeDocumentSelfManagedActiveDirectoryConfiguration(v.SelfManagedActiveDirectoryConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentDataRepositoryAssociationIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentDataRepositoryTaskFilter(v *types.DataRepositoryTaskFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("Name")
		ok.String(string(v.Name))
	}

	if v.Values != nil {
		ok := object.Key("Values")
		if err := awsAwsjson11_serializeDocumentDataRepositoryTaskFilterValues(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentDataRepositoryTaskFilters(v []types.DataRepositoryTaskFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentDataRepositoryTaskFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentDataRepositoryTaskFilterValues(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentDataRepositoryTaskPaths(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentDeleteFileSystemLustreConfiguration(v *types.DeleteFileSystemLustreConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FinalBackupTags != nil {
		ok := object.Key("FinalBackupTags")
		if err := awsAwsjson11_serializeDocumentTags(v.FinalBackupTags, ok); err != nil {
			return err
		}
	}

	if v.SkipFinalBackup != nil {
		ok := object.Key("SkipFinalBackup")
		ok.Boolean(*v.SkipFinalBackup)
	}

	return nil
}

func awsAwsjson11_serializeDocumentDeleteFileSystemOpenZFSConfiguration(v *types.DeleteFileSystemOpenZFSConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FinalBackupTags != nil {
		ok := object.Key("FinalBackupTags")
		if err := awsAwsjson11_serializeDocumentTags(v.FinalBackupTags, ok); err != nil {
			return err
		}
	}

	if v.Options != nil {
		ok := object.Key("Options")
		if err := awsAwsjson11_serializeDocumentDeleteFileSystemOpenZFSOptions(v.Options, ok); err != nil {
			return err
		}
	}

	if v.SkipFinalBackup != nil {
		ok := object.Key("SkipFinalBackup")
		ok.Boolean(*v.SkipFinalBackup)
	}

	return nil
}

func awsAwsjson11_serializeDocumentDeleteFileSystemOpenZFSOptions(v []types.DeleteFileSystemOpenZFSOption, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentDeleteFileSystemWindowsConfiguration(v *types.DeleteFileSystemWindowsConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FinalBackupTags != nil {
		ok := object.Key("FinalBackupTags")
		if err := awsAwsjson11_serializeDocumentTags(v.FinalBackupTags, ok); err != nil {
			return err
		}
	}

	if v.SkipFinalBackup != nil {
		ok := object.Key("SkipFinalBackup")
		ok.Boolean(*v.SkipFinalBackup)
	}

	return nil
}

func awsAwsjson11_serializeDocumentDeleteOpenZFSVolumeOptions(v []types.DeleteOpenZFSVolumeOption, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentDeleteVolumeOntapConfiguration(v *types.DeleteVolumeOntapConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BypassSnaplockEnterpriseRetention != nil {
		ok := object.Key("BypassSnaplockEnterpriseRetention")
		ok.Boolean(*v.BypassSnaplockEnterpriseRetention)
	}

	if v.FinalBackupTags != nil {
		ok := object.Key("FinalBackupTags")
		if err := awsAwsjson11_serializeDocumentTags(v.FinalBackupTags, ok); err != nil {
			return err
		}
	}

	if v.SkipFinalBackup != nil {
		ok := object.Key("SkipFinalBackup")
		ok.Boolean(*v.SkipFinalBackup)
	}

	return nil
}

func awsAwsjson11_serializeDocumentDeleteVolumeOpenZFSConfiguration(v *types.DeleteVolumeOpenZFSConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Options != nil {
		ok := object.Key("Options")
		if err := awsAwsjson11_serializeDocumentDeleteOpenZFSVolumeOptions(v.Options, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentDiskIopsConfiguration(v *types.DiskIopsConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Iops != nil {
		ok := object.Key("Iops")
		ok.Long(*v.Iops)
	}

	if len(v.Mode) > 0 {
		ok := object.Key("Mode")
		ok.String(string(v.Mode))
	}

	return nil
}

func awsAwsjson11_serializeDocumentDnsIps(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentDurationSinceLastAccess(v *types.DurationSinceLastAccess, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Unit) > 0 {
		ok := object.Key("Unit")
		ok.String(string(v.Unit))
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.Long(*v.Value)
	}

	return nil
}

func awsAwsjson11_serializeDocumentEventTypes(v []types.EventType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentFileCacheDataRepositoryAssociation(v *types.FileCacheDataRepositoryAssociation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataRepositoryPath != nil {
		ok := object.Key("DataRepositoryPath")
		ok.String(*v.DataRepositoryPath)
	}

	if v.DataRepositorySubdirectories != nil {
		ok := object.Key("DataRepositorySubdirectories")
		if err := awsAwsjson11_serializeDocumentSubDirectoriesPaths(v.DataRepositorySubdirectories, ok); err != nil {
			return err
		}
	}

	if v.FileCachePath != nil {
		ok := object.Key("FileCachePath")
		ok.String(*v.FileCachePath)
	}

	if v.NFS != nil {
		ok := object.Key("NFS")
		if err := awsAwsjson11_serializeDocumentFileCacheNFSConfiguration(v.NFS, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentFileCacheIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentFileCacheLustreMetadataConfiguration(v *types.FileCacheLustreMetadataConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.StorageCapacity != nil {
		ok := object.Key("StorageCapacity")
		ok.Integer(*v.StorageCapacity)
	}

	return nil
}

func awsAwsjson11_serializeDocumentFileCacheNFSConfiguration(v *types.FileCacheNFSConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DnsIps != nil {
		ok := object.Key("DnsIps")
		if err := awsAwsjson11_serializeDocumentRepositoryDnsIps(v.DnsIps, ok); err != nil {
			return err
		}
	}

	if len(v.Version) > 0 {
		ok := object.Key("Version")
		ok.String(string(v.Version))
	}

	return nil
}

func awsAwsjson11_serializeDocumentFileSystemIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentFileSystemSecondaryGIDs(v []int64, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.Long(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentFilter(v *types.Filter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("Name")
		ok.String(string(v.Name))
	}

	if v.Values != nil {
		ok := object.Key("Values")
		if err := awsAwsjson11_serializeDocumentFilterValues(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentFilters(v []types.Filter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentFilterValues(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentLustreLogCreateConfiguration(v *types.LustreLogCreateConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Destination != nil {
		ok := object.Key("Destination")
		ok.String(*v.Destination)
	}

	if len(v.Level) > 0 {
		ok := object.Key("Level")
		ok.String(string(v.Level))
	}

	return nil
}

func awsAwsjson11_serializeDocumentLustreNoSquashNids(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentLustreReadCacheConfiguration(v *types.LustreReadCacheConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SizeGiB != nil {
		ok := object.Key("SizeGiB")
		ok.Integer(*v.SizeGiB)
	}

	if len(v.SizingMode) > 0 {
		ok := object.Key("SizingMode")
		ok.String(string(v.SizingMode))
	}

	return nil
}

func awsAwsjson11_serializeDocumentLustreRootSquashConfiguration(v *types.LustreRootSquashConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NoSquashNids != nil {
		ok := object.Key("NoSquashNids")
		if err := awsAwsjson11_serializeDocumentLustreNoSquashNids(v.NoSquashNids, ok); err != nil {
			return err
		}
	}

	if v.RootSquash != nil {
		ok := object.Key("RootSquash")
		ok.String(*v.RootSquash)
	}

	return nil
}

func awsAwsjson11_serializeDocumentOpenZFSClientConfiguration(v *types.OpenZFSClientConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Clients != nil {
		ok := object.Key("Clients")
		ok.String(*v.Clients)
	}

	if v.Options != nil {
		ok := object.Key("Options")
		if err := awsAwsjson11_serializeDocumentOpenZFSNfsExportOptions(v.Options, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentOpenZFSClientConfigurations(v []types.OpenZFSClientConfiguration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentOpenZFSClientConfiguration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentOpenZFSCreateRootVolumeConfiguration(v *types.OpenZFSCreateRootVolumeConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CopyTagsToSnapshots != nil {
		ok := object.Key("CopyTagsToSnapshots")
		ok.Boolean(*v.CopyTagsToSnapshots)
	}

	if len(v.DataCompressionType) > 0 {
		ok := object.Key("DataCompressionType")
		ok.String(string(v.DataCompressionType))
	}

	if v.NfsExports != nil {
		ok := object.Key("NfsExports")
		if err := awsAwsjson11_serializeDocumentOpenZFSNfsExports(v.NfsExports, ok); err != nil {
			return err
		}
	}

	if v.ReadOnly != nil {
		ok := object.Key("ReadOnly")
		ok.Boolean(*v.ReadOnly)
	}

	if v.RecordSizeKiB != nil {
		ok := object.Key("RecordSizeKiB")
		ok.Integer(*v.RecordSizeKiB)
	}

	if v.UserAndGroupQuotas != nil {
		ok := object.Key("UserAndGroupQuotas")
		if err := awsAwsjson11_serializeDocumentOpenZFSUserAndGroupQuotas(v.UserAndGroupQuotas, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentOpenZFSFileSystemIdentity(v *types.OpenZFSFileSystemIdentity, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PosixUser != nil {
		ok := object.Key("PosixUser")
		if err := awsAwsjson11_serializeDocumentOpenZFSPosixFileSystemUser(v.PosixUser, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsAwsjson11_serializeDocumentOpenZFSNfsExport(v *types.OpenZFSNfsExport, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientConfigurations != nil {
		ok := object.Key("ClientConfigurations")
		if err := awsAwsjson11_serializeDocumentOpenZFSClientConfigurations(v.ClientConfigurations, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentOpenZFSNfsExportOptions(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentOpenZFSNfsExports(v []types.OpenZFSNfsExport, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentOpenZFSNfsExport(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentOpenZFSPosixFileSystemUser(v *types.OpenZFSPosixFileSystemUser, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Gid != nil {
		ok := object.Key("Gid")
		ok.Long(*v.Gid)
	}

	if v.SecondaryGids != nil {
		ok := object.Key("SecondaryGids")
		if err := awsAwsjson11_serializeDocumentFileSystemSecondaryGIDs(v.SecondaryGids, ok); err != nil {
			return err
		}
	}

	if v.Uid != nil {
		ok := object.Key("Uid")
		ok.Long(*v.Uid)
	}

	return nil
}

func awsAwsjson11_serializeDocumentOpenZFSReadCacheConfiguration(v *types.OpenZFSReadCacheConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SizeGiB != nil {
		ok := object.Key("SizeGiB")
		ok.Integer(*v.SizeGiB)
	}

	if len(v.SizingMode) > 0 {
		ok := object.Key("SizingMode")
		ok.String(string(v.SizingMode))
	}

	return nil
}

func awsAwsjson11_serializeDocumentOpenZFSUserAndGroupQuotas(v []types.OpenZFSUserOrGroupQuota, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentOpenZFSUserOrGroupQuota(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentOpenZFSUserOrGroupQuota(v *types.OpenZFSUserOrGroupQuota, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Id != nil {
		ok := object.Key("Id")
		ok.Integer(*v.Id)
	}

	if v.StorageCapacityQuotaGiB != nil {
		ok := object.Key("StorageCapacityQuotaGiB")
		ok.Integer(*v.StorageCapacityQuotaGiB)
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsAwsjson11_serializeDocumentReleaseConfiguration(v *types.ReleaseConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DurationSinceLastAccess != nil {
		ok := object.Key("DurationSinceLastAccess")
		if err := awsAwsjson11_serializeDocumentDurationSinceLastAccess(v.DurationSinceLastAccess, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentRepositoryDnsIps(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentRestoreOpenZFSVolumeOptions(v []types.RestoreOpenZFSVolumeOption, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentRetentionPeriod(v *types.RetentionPeriod, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.Integer(*v.Value)
	}

	return nil
}

func awsAwsjson11_serializeDocumentRouteTableIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentS3AccessPointAttachmentNames(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentS3AccessPointAttachmentsFilter(v *types.S3AccessPointAttachmentsFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("Name")
		ok.String(string(v.Name))
	}

	if v.Values != nil {
		ok := object.Key("Values")
		if err := awsAwsjson11_serializeDocumentS3AccessPointAttachmentsFilterValues(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentS3AccessPointAttachmentsFilters(v []types.S3AccessPointAttachmentsFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentS3AccessPointAttachmentsFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentS3AccessPointAttachmentsFilterValues(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentS3AccessPointVpcConfiguration(v *types.S3AccessPointVpcConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.VpcId != nil {
		ok := object.Key("VpcId")
		ok.String(*v.VpcId)
	}

	return nil
}

func awsAwsjson11_serializeDocumentS3DataRepositoryConfiguration(v *types.S3DataRepositoryConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AutoExportPolicy != nil {
		ok := object.Key("AutoExportPolicy")
		if err := awsAwsjson11_serializeDocumentAutoExportPolicy(v.AutoExportPolicy, ok); err != nil {
			return err
		}
	}

	if v.AutoImportPolicy != nil {
		ok := object.Key("AutoImportPolicy")
		if err := awsAwsjson11_serializeDocumentAutoImportPolicy(v.AutoImportPolicy, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentSecurityGroupIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentSelfManagedActiveDirectoryConfiguration(v *types.SelfManagedActiveDirectoryConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DnsIps != nil {
		ok := object.Key("DnsIps")
		if err := awsAwsjson11_serializeDocumentDnsIps(v.DnsIps, ok); err != nil {
			return err
		}
	}

	if v.DomainName != nil {
		ok := object.Key("DomainName")
		ok.String(*v.DomainName)
	}

	if v.FileSystemAdministratorsGroup != nil {
		ok := object.Key("FileSystemAdministratorsGroup")
		ok.String(*v.FileSystemAdministratorsGroup)
	}

	if v.OrganizationalUnitDistinguishedName != nil {
		ok := object.Key("OrganizationalUnitDistinguishedName")
		ok.String(*v.OrganizationalUnitDistinguishedName)
	}

	if v.Password != nil {
		ok := object.Key("Password")
		ok.String(*v.Password)
	}

	if v.UserName != nil {
		ok := object.Key("UserName")
		ok.String(*v.UserName)
	}

	return nil
}

func awsAwsjson11_serializeDocumentSelfManagedActiveDirectoryConfigurationUpdates(v *types.SelfManagedActiveDirectoryConfigurationUpdates, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DnsIps != nil {
		ok := object.Key("DnsIps")
		if err := awsAwsjson11_serializeDocumentDnsIps(v.DnsIps, ok); err != nil {
			return err
		}
	}

	if v.DomainName != nil {
		ok := object.Key("DomainName")
		ok.String(*v.DomainName)
	}

	if v.FileSystemAdministratorsGroup != nil {
		ok := object.Key("FileSystemAdministratorsGroup")
		ok.String(*v.FileSystemAdministratorsGroup)
	}

	if v.OrganizationalUnitDistinguishedName != nil {
		ok := object.Key("OrganizationalUnitDistinguishedName")
		ok.String(*v.OrganizationalUnitDistinguishedName)
	}

	if v.Password != nil {
		ok := object.Key("Password")
		ok.String(*v.Password)
	}

	if v.UserName != nil {
		ok := object.Key("UserName")
		ok.String(*v.UserName)
	}

	return nil
}

func awsAwsjson11_serializeDocumentSnaplockRetentionPeriod(v *types.SnaplockRetentionPeriod, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DefaultRetention != nil {
		ok := object.Key("DefaultRetention")
		if err := awsAwsjson11_serializeDocumentRetentionPeriod(v.DefaultRetention, ok); err != nil {
			return err
		}
	}

	if v.MaximumRetention != nil {
		ok := object.Key("MaximumRetention")
		if err := awsAwsjson11_serializeDocumentRetentionPeriod(v.MaximumRetention, ok); err != nil {
			return err
		}
	}

	if v.MinimumRetention != nil {
		ok := object.Key("MinimumRetention")
		if err := awsAwsjson11_serializeDocumentRetentionPeriod(v.MinimumRetention, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentSnapshotFilter(v *types.SnapshotFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("Name")
		ok.String(string(v.Name))
	}

	if v.Values != nil {
		ok := object.Key("Values")
		if err := awsAwsjson11_serializeDocumentSnapshotFilterValues(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentSnapshotFilters(v []types.SnapshotFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentSnapshotFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentSnapshotFilterValues(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentSnapshotIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentStorageVirtualMachineFilter(v *types.StorageVirtualMachineFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("Name")
		ok.String(string(v.Name))
	}

	if v.Values != nil {
		ok := object.Key("Values")
		if err := awsAwsjson11_serializeDocumentStorageVirtualMachineFilterValues(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentStorageVirtualMachineFilters(v []types.StorageVirtualMachineFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentStorageVirtualMachineFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentStorageVirtualMachineFilterValues(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentStorageVirtualMachineIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentSubDirectoriesPaths(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentSubnetIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentTag(v *types.Tag, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsAwsjson11_serializeDocumentTagKeys(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentTags(v []types.Tag, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentTag(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentTaskIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentTieringPolicy(v *types.TieringPolicy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CoolingPeriod != nil {
		ok := object.Key("CoolingPeriod")
		ok.Integer(*v.CoolingPeriod)
	}

	if len(v.Name) > 0 {
		ok := object.Key("Name")
		ok.String(string(v.Name))
	}

	return nil
}

func awsAwsjson11_serializeDocumentUpdateFileCacheLustreConfiguration(v *types.UpdateFileCacheLustreConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.WeeklyMaintenanceStartTime != nil {
		ok := object.Key("WeeklyMaintenanceStartTime")
		ok.String(*v.WeeklyMaintenanceStartTime)
	}

	return nil
}

func awsAwsjson11_serializeDocumentUpdateFileSystemLustreConfiguration(v *types.UpdateFileSystemLustreConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AutoImportPolicy) > 0 {
		ok := object.Key("AutoImportPolicy")
		ok.String(string(v.AutoImportPolicy))
	}

	if v.AutomaticBackupRetentionDays != nil {
		ok := object.Key("AutomaticBackupRetentionDays")
		ok.Integer(*v.AutomaticBackupRetentionDays)
	}

	if v.DailyAutomaticBackupStartTime != nil {
		ok := object.Key("DailyAutomaticBackupStartTime")
		ok.String(*v.DailyAutomaticBackupStartTime)
	}

	if len(v.DataCompressionType) > 0 {
		ok := object.Key("DataCompressionType")
		ok.String(string(v.DataCompressionType))
	}

	if v.DataReadCacheConfiguration != nil {
		ok := object.Key("DataReadCacheConfiguration")
		if err := awsAwsjson11_serializeDocumentLustreReadCacheConfiguration(v.DataReadCacheConfiguration, ok); err != nil {
			return err
		}
	}

	if v.LogConfiguration != nil {
		ok := object.Key("LogConfiguration")
		if err := awsAwsjson11_serializeDocumentLustreLogCreateConfiguration(v.LogConfiguration, ok); err != nil {
			return err
		}
	}

	if v.MetadataConfiguration != nil {
		ok := object.Key("MetadataConfiguration")
		if err := awsAwsjson11_serializeDocumentUpdateFileSystemLustreMetadataConfiguration(v.MetadataConfiguration, ok); err != nil {
			return err
		}
	}

	if v.PerUnitStorageThroughput != nil {
		ok := object.Key("PerUnitStorageThroughput")
		ok.Integer(*v.PerUnitStorageThroughput)
	}

	if v.RootSquashConfiguration != nil {
		ok := object.Key("RootSquashConfiguration")
		if err := awsAwsjson11_serializeDocumentLustreRootSquashConfiguration(v.RootSquashConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ThroughputCapacity != nil {
		ok := object.Key("ThroughputCapacity")
		ok.Integer(*v.ThroughputCapacity)
	}

	if v.WeeklyMaintenanceStartTime != nil {
		ok := object.Key("WeeklyMaintenanceStartTime")
		ok.String(*v.WeeklyMaintenanceStartTime)
	}

	return nil
}

func awsAwsjson11_serializeDocumentUpdateFileSystemLustreMetadataConfiguration(v *types.UpdateFileSystemLustreMetadataConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Iops != nil {
		ok := object.Key("Iops")
		ok.Integer(*v.Iops)
	}

	if len(v.Mode) > 0 {
		ok := object.Key("Mode")
		ok.String(string(v.Mode))
	}

	return nil
}

func awsAwsjson11_serializeDocumentUpdateFileSystemOntapConfiguration(v *types.UpdateFileSystemOntapConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AddRouteTableIds != nil {
		ok := object.Key("AddRouteTableIds")
		if err := awsAwsjson11_serializeDocumentRouteTableIds(v.AddRouteTableIds, ok); err != nil {
			return err
		}
	}

	if v.AutomaticBackupRetentionDays != nil {
		ok := object.Key("AutomaticBackupRetentionDays")
		ok.Integer(*v.AutomaticBackupRetentionDays)
	}

	if v.DailyAutomaticBackupStartTime != nil {
		ok := object.Key("DailyAutomaticBackupStartTime")
		ok.String(*v.DailyAutomaticBackupStartTime)
	}

	if v.DiskIopsConfiguration != nil {
		ok := object.Key("DiskIopsConfiguration")
		if err := awsAwsjson11_serializeDocumentDiskIopsConfiguration(v.DiskIopsConfiguration, ok); err != nil {
			return err
		}
	}

	if v.FsxAdminPassword != nil {
		ok := object.Key("FsxAdminPassword")
		ok.String(*v.FsxAdminPassword)
	}

	if v.HAPairs != nil {
		ok := object.Key("HAPairs")
		ok.Integer(*v.HAPairs)
	}

	if v.RemoveRouteTableIds != nil {
		ok := object.Key("RemoveRouteTableIds")
		if err := awsAwsjson11_serializeDocumentRouteTableIds(v.RemoveRouteTableIds, ok); err != nil {
			return err
		}
	}

	if v.ThroughputCapacity != nil {
		ok := object.Key("ThroughputCapacity")
		ok.Integer(*v.ThroughputCapacity)
	}

	if v.ThroughputCapacityPerHAPair != nil {
		ok := object.Key("ThroughputCapacityPerHAPair")
		ok.Integer(*v.ThroughputCapacityPerHAPair)
	}

	if v.WeeklyMaintenanceStartTime != nil {
		ok := object.Key("WeeklyMaintenanceStartTime")
		ok.String(*v.WeeklyMaintenanceStartTime)
	}

	return nil
}

func awsAwsjson11_serializeDocumentUpdateFileSystemOpenZFSConfiguration(v *types.UpdateFileSystemOpenZFSConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AddRouteTableIds != nil {
		ok := object.Key("AddRouteTableIds")
		if err := awsAwsjson11_serializeDocumentRouteTableIds(v.AddRouteTableIds, ok); err != nil {
			return err
		}
	}

	if v.AutomaticBackupRetentionDays != nil {
		ok := object.Key("AutomaticBackupRetentionDays")
		ok.Integer(*v.AutomaticBackupRetentionDays)
	}

	if v.CopyTagsToBackups != nil {
		ok := object.Key("CopyTagsToBackups")
		ok.Boolean(*v.CopyTagsToBackups)
	}

	if v.CopyTagsToVolumes != nil {
		ok := object.Key("CopyTagsToVolumes")
		ok.Boolean(*v.CopyTagsToVolumes)
	}

	if v.DailyAutomaticBackupStartTime != nil {
		ok := object.Key("DailyAutomaticBackupStartTime")
		ok.String(*v.DailyAutomaticBackupStartTime)
	}

	if v.DiskIopsConfiguration != nil {
		ok := object.Key("DiskIopsConfiguration")
		if err := awsAwsjson11_serializeDocumentDiskIopsConfiguration(v.DiskIopsConfiguration, ok); err != nil {
			return err
		}
	}

	if v.EndpointIpv6AddressRange != nil {
		ok := object.Key("EndpointIpv6AddressRange")
		ok.String(*v.EndpointIpv6AddressRange)
	}

	if v.ReadCacheConfiguration != nil {
		ok := object.Key("ReadCacheConfiguration")
		if err := awsAwsjson11_serializeDocumentOpenZFSReadCacheConfiguration(v.ReadCacheConfiguration, ok); err != nil {
			return err
		}
	}

	if v.RemoveRouteTableIds != nil {
		ok := object.Key("RemoveRouteTableIds")
		if err := awsAwsjson11_serializeDocumentRouteTableIds(v.RemoveRouteTableIds, ok); err != nil {
			return err
		}
	}

	if v.ThroughputCapacity != nil {
		ok := object.Key("ThroughputCapacity")
		ok.Integer(*v.ThroughputCapacity)
	}

	if v.WeeklyMaintenanceStartTime != nil {
		ok := object.Key("WeeklyMaintenanceStartTime")
		ok.String(*v.WeeklyMaintenanceStartTime)
	}

	return nil
}

func awsAwsjson11_serializeDocumentUpdateFileSystemWindowsConfiguration(v *types.UpdateFileSystemWindowsConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuditLogConfiguration != nil {
		ok := object.Key("AuditLogConfiguration")
		if err := awsAwsjson11_serializeDocumentWindowsAuditLogCreateConfiguration(v.AuditLogConfiguration, ok); err != nil {
			return err
		}
	}

	if v.AutomaticBackupRetentionDays != nil {
		ok := object.Key("AutomaticBackupRetentionDays")
		ok.Integer(*v.AutomaticBackupRetentionDays)
	}

	if v.DailyAutomaticBackupStartTime != nil {
		ok := object.Key("DailyAutomaticBackupStartTime")
		ok.String(*v.DailyAutomaticBackupStartTime)
	}

	if v.DiskIopsConfiguration != nil {
		ok := object.Key("DiskIopsConfiguration")
		if err := awsAwsjson11_serializeDocumentDiskIopsConfiguration(v.DiskIopsConfiguration, ok); err != nil {
			return err
		}
	}

	if v.SelfManagedActiveDirectoryConfiguration != nil {
		ok := object.Key("SelfManagedActiveDirectoryConfiguration")
		if err := awsAwsjson11_serializeDocumentSelfManagedActiveDirectoryConfigurationUpdates(v.SelfManagedActiveDirectoryConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ThroughputCapacity != nil {
		ok := object.Key("ThroughputCapacity")
		ok.Integer(*v.ThroughputCapacity)
	}

	if v.WeeklyMaintenanceStartTime != nil {
		ok := object.Key("WeeklyMaintenanceStartTime")
		ok.String(*v.WeeklyMaintenanceStartTime)
	}

	return nil
}

func awsAwsjson11_serializeDocumentUpdateOntapVolumeConfiguration(v *types.UpdateOntapVolumeConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CopyTagsToBackups != nil {
		ok := object.Key("CopyTagsToBackups")
		ok.Boolean(*v.CopyTagsToBackups)
	}

	if v.JunctionPath != nil {
		ok := object.Key("JunctionPath")
		ok.String(*v.JunctionPath)
	}

	if len(v.SecurityStyle) > 0 {
		ok := object.Key("SecurityStyle")
		ok.String(string(v.SecurityStyle))
	}

	if v.SizeInBytes != nil {
		ok := object.Key("SizeInBytes")
		ok.Long(*v.SizeInBytes)
	}

	if v.SizeInMegabytes != nil {
		ok := object.Key("SizeInMegabytes")
		ok.Integer(*v.SizeInMegabytes)
	}

	if v.SnaplockConfiguration != nil {
		ok := object.Key("SnaplockConfiguration")
		if err := awsAwsjson11_serializeDocumentUpdateSnaplockConfiguration(v.SnaplockConfiguration, ok); err != nil {
			return err
		}
	}

	if v.SnapshotPolicy != nil {
		ok := object.Key("SnapshotPolicy")
		ok.String(*v.SnapshotPolicy)
	}

	if v.StorageEfficiencyEnabled != nil {
		ok := object.Key("StorageEfficiencyEnabled")
		ok.Boolean(*v.StorageEfficiencyEnabled)
	}

	if v.TieringPolicy != nil {
		ok := object.Key("TieringPolicy")
		if err := awsAwsjson11_serializeDocumentTieringPolicy(v.TieringPolicy, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentUpdateOpenZFSVolumeConfiguration(v *types.UpdateOpenZFSVolumeConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DataCompressionType) > 0 {
		ok := object.Key("DataCompressionType")
		ok.String(string(v.DataCompressionType))
	}

	if v.NfsExports != nil {
		ok := object.Key("NfsExports")
		if err := awsAwsjson11_serializeDocumentOpenZFSNfsExports(v.NfsExports, ok); err != nil {
			return err
		}
	}

	if v.ReadOnly != nil {
		ok := object.Key("ReadOnly")
		ok.Boolean(*v.ReadOnly)
	}

	if v.RecordSizeKiB != nil {
		ok := object.Key("RecordSizeKiB")
		ok.Integer(*v.RecordSizeKiB)
	}

	if v.StorageCapacityQuotaGiB != nil {
		ok := object.Key("StorageCapacityQuotaGiB")
		ok.Integer(*v.StorageCapacityQuotaGiB)
	}

	if v.StorageCapacityReservationGiB != nil {
		ok := object.Key("StorageCapacityReservationGiB")
		ok.Integer(*v.StorageCapacityReservationGiB)
	}

	if v.UserAndGroupQuotas != nil {
		ok := object.Key("UserAndGroupQuotas")
		if err := awsAwsjson11_serializeDocumentOpenZFSUserAndGroupQuotas(v.UserAndGroupQuotas, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentUpdateOpenZFSVolumeOptions(v []types.UpdateOpenZFSVolumeOption, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentUpdateSnaplockConfiguration(v *types.UpdateSnaplockConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuditLogVolume != nil {
		ok := object.Key("AuditLogVolume")
		ok.Boolean(*v.AuditLogVolume)
	}

	if v.AutocommitPeriod != nil {
		ok := object.Key("AutocommitPeriod")
		if err := awsAwsjson11_serializeDocumentAutocommitPeriod(v.AutocommitPeriod, ok); err != nil {
			return err
		}
	}

	if len(v.PrivilegedDelete) > 0 {
		ok := object.Key("PrivilegedDelete")
		ok.String(string(v.PrivilegedDelete))
	}

	if v.RetentionPeriod != nil {
		ok := object.Key("RetentionPeriod")
		if err := awsAwsjson11_serializeDocumentSnaplockRetentionPeriod(v.RetentionPeriod, ok); err != nil {
			return err
		}
	}

	if v.VolumeAppendModeEnabled != nil {
		ok := object.Key("VolumeAppendModeEnabled")
		ok.Boolean(*v.VolumeAppendModeEnabled)
	}

	return nil
}

func awsAwsjson11_serializeDocumentUpdateSvmActiveDirectoryConfiguration(v *types.UpdateSvmActiveDirectoryConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NetBiosName != nil {
		ok := object.Key("NetBiosName")
		ok.String(*v.NetBiosName)
	}

	if v.SelfManagedActiveDirectoryConfiguration != nil {
		ok := object.Key("SelfManagedActiveDirectoryConfiguration")
		if err := awsAwsjson11_serializeDocumentSelfManagedActiveDirectoryConfigurationUpdates(v.SelfManagedActiveDirectoryConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentVolumeFilter(v *types.VolumeFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("Name")
		ok.String(string(v.Name))
	}

	if v.Values != nil {
		ok := object.Key("Values")
		if err := awsAwsjson11_serializeDocumentVolumeFilterValues(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentVolumeFilters(v []types.VolumeFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentVolumeFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentVolumeFilterValues(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentVolumeIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson11_serializeDocumentWindowsAuditLogCreateConfiguration(v *types.WindowsAuditLogCreateConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuditLogDestination != nil {
		ok := object.Key("AuditLogDestination")
		ok.String(*v.AuditLogDestination)
	}

	if len(v.FileAccessAuditLogLevel) > 0 {
		ok := object.Key("FileAccessAuditLogLevel")
		ok.String(string(v.FileAccessAuditLogLevel))
	}

	if len(v.FileShareAccessAuditLogLevel) > 0 {
		ok := object.Key("FileShareAccessAuditLogLevel")
		ok.String(string(v.FileShareAccessAuditLogLevel))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentAssociateFileSystemAliasesInput(v *AssociateFileSystemAliasesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Aliases != nil {
		ok := object.Key("Aliases")
		if err := awsAwsjson11_serializeDocumentAlternateDNSNames(v.Aliases, ok); err != nil {
			return err
		}
	}

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.FileSystemId != nil {
		ok := object.Key("FileSystemId")
		ok.String(*v.FileSystemId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCancelDataRepositoryTaskInput(v *CancelDataRepositoryTaskInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TaskId != nil {
		ok := object.Key("TaskId")
		ok.String(*v.TaskId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCopyBackupInput(v *CopyBackupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.CopyTags != nil {
		ok := object.Key("CopyTags")
		ok.Boolean(*v.CopyTags)
	}

	if v.KmsKeyId != nil {
		ok := object.Key("KmsKeyId")
		ok.String(*v.KmsKeyId)
	}

	if v.SourceBackupId != nil {
		ok := object.Key("SourceBackupId")
		ok.String(*v.SourceBackupId)
	}

	if v.SourceRegion != nil {
		ok := object.Key("SourceRegion")
		ok.String(*v.SourceRegion)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCopySnapshotAndUpdateVolumeInput(v *CopySnapshotAndUpdateVolumeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if len(v.CopyStrategy) > 0 {
		ok := object.Key("CopyStrategy")
		ok.String(string(v.CopyStrategy))
	}

	if v.Options != nil {
		ok := object.Key("Options")
		if err := awsAwsjson11_serializeDocumentUpdateOpenZFSVolumeOptions(v.Options, ok); err != nil {
			return err
		}
	}

	if v.SourceSnapshotARN != nil {
		ok := object.Key("SourceSnapshotARN")
		ok.String(*v.SourceSnapshotARN)
	}

	if v.VolumeId != nil {
		ok := object.Key("VolumeId")
		ok.String(*v.VolumeId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateAndAttachS3AccessPointInput(v *CreateAndAttachS3AccessPointInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.OpenZFSConfiguration != nil {
		ok := object.Key("OpenZFSConfiguration")
		if err := awsAwsjson11_serializeDocumentCreateAndAttachS3AccessPointOpenZFSConfiguration(v.OpenZFSConfiguration, ok); err != nil {
			return err
		}
	}

	if v.S3AccessPoint != nil {
		ok := object.Key("S3AccessPoint")
		if err := awsAwsjson11_serializeDocumentCreateAndAttachS3AccessPointS3Configuration(v.S3AccessPoint, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateBackupInput(v *CreateBackupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.FileSystemId != nil {
		ok := object.Key("FileSystemId")
		ok.String(*v.FileSystemId)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.VolumeId != nil {
		ok := object.Key("VolumeId")
		ok.String(*v.VolumeId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateDataRepositoryAssociationInput(v *CreateDataRepositoryAssociationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BatchImportMetaDataOnCreate != nil {
		ok := object.Key("BatchImportMetaDataOnCreate")
		ok.Boolean(*v.BatchImportMetaDataOnCreate)
	}

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.DataRepositoryPath != nil {
		ok := object.Key("DataRepositoryPath")
		ok.String(*v.DataRepositoryPath)
	}

	if v.FileSystemId != nil {
		ok := object.Key("FileSystemId")
		ok.String(*v.FileSystemId)
	}

	if v.FileSystemPath != nil {
		ok := object.Key("FileSystemPath")
		ok.String(*v.FileSystemPath)
	}

	if v.ImportedFileChunkSize != nil {
		ok := object.Key("ImportedFileChunkSize")
		ok.Integer(*v.ImportedFileChunkSize)
	}

	if v.S3 != nil {
		ok := object.Key("S3")
		if err := awsAwsjson11_serializeDocumentS3DataRepositoryConfiguration(v.S3, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateDataRepositoryTaskInput(v *CreateDataRepositoryTaskInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CapacityToRelease != nil {
		ok := object.Key("CapacityToRelease")
		ok.Long(*v.CapacityToRelease)
	}

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.FileSystemId != nil {
		ok := object.Key("FileSystemId")
		ok.String(*v.FileSystemId)
	}

	if v.Paths != nil {
		ok := object.Key("Paths")
		if err := awsAwsjson11_serializeDocumentDataRepositoryTaskPaths(v.Paths, ok); err != nil {
			return err
		}
	}

	if v.ReleaseConfiguration != nil {
		ok := object.Key("ReleaseConfiguration")
		if err := awsAwsjson11_serializeDocumentReleaseConfiguration(v.ReleaseConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Report != nil {
		ok := object.Key("Report")
		if err := awsAwsjson11_serializeDocumentCompletionReport(v.Report, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateFileCacheInput(v *CreateFileCacheInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.CopyTagsToDataRepositoryAssociations != nil {
		ok := object.Key("CopyTagsToDataRepositoryAssociations")
		ok.Boolean(*v.CopyTagsToDataRepositoryAssociations)
	}

	if v.DataRepositoryAssociations != nil {
		ok := object.Key("DataRepositoryAssociations")
		if err := awsAwsjson11_serializeDocumentCreateFileCacheDataRepositoryAssociations(v.DataRepositoryAssociations, ok); err != nil {
			return err
		}
	}

	if len(v.FileCacheType) > 0 {
		ok := object.Key("FileCacheType")
		ok.String(string(v.FileCacheType))
	}

	if v.FileCacheTypeVersion != nil {
		ok := object.Key("FileCacheTypeVersion")
		ok.String(*v.FileCacheTypeVersion)
	}

	if v.KmsKeyId != nil {
		ok := object.Key("KmsKeyId")
		ok.String(*v.KmsKeyId)
	}

	if v.LustreConfiguration != nil {
		ok := object.Key("LustreConfiguration")
		if err := awsAwsjson11_serializeDocumentCreateFileCacheLustreConfiguration(v.LustreConfiguration, ok); err != nil {
			return err
		}
	}

	if v.SecurityGroupIds != nil {
		ok := object.Key("SecurityGroupIds")
		if err := awsAwsjson11_serializeDocumentSecurityGroupIds(v.SecurityGroupIds, ok); err != nil {
			return err
		}
	}

	if v.StorageCapacity != nil {
		ok := object.Key("StorageCapacity")
		ok.Integer(*v.StorageCapacity)
	}

	if v.SubnetIds != nil {
		ok := object.Key("SubnetIds")
		if err := awsAwsjson11_serializeDocumentSubnetIds(v.SubnetIds, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateFileSystemFromBackupInput(v *CreateFileSystemFromBackupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BackupId != nil {
		ok := object.Key("BackupId")
		ok.String(*v.BackupId)
	}

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.FileSystemTypeVersion != nil {
		ok := object.Key("FileSystemTypeVersion")
		ok.String(*v.FileSystemTypeVersion)
	}

	if v.KmsKeyId != nil {
		ok := object.Key("KmsKeyId")
		ok.String(*v.KmsKeyId)
	}

	if v.LustreConfiguration != nil {
		ok := object.Key("LustreConfiguration")
		if err := awsAwsjson11_serializeDocumentCreateFileSystemLustreConfiguration(v.LustreConfiguration, ok); err != nil {
			return err
		}
	}

	if len(v.NetworkType) > 0 {
		ok := object.Key("NetworkType")
		ok.String(string(v.NetworkType))
	}

	if v.OpenZFSConfiguration != nil {
		ok := object.Key("OpenZFSConfiguration")
		if err := awsAwsjson11_serializeDocumentCreateFileSystemOpenZFSConfiguration(v.OpenZFSConfiguration, ok); err != nil {
			return err
		}
	}

	if v.SecurityGroupIds != nil {
		ok := object.Key("SecurityGroupIds")
		if err := awsAwsjson11_serializeDocumentSecurityGroupIds(v.SecurityGroupIds, ok); err != nil {
			return err
		}
	}

	if v.StorageCapacity != nil {
		ok := object.Key("StorageCapacity")
		ok.Integer(*v.StorageCapacity)
	}

	if len(v.StorageType) > 0 {
		ok := object.Key("StorageType")
		ok.String(string(v.StorageType))
	}

	if v.SubnetIds != nil {
		ok := object.Key("SubnetIds")
		if err := awsAwsjson11_serializeDocumentSubnetIds(v.SubnetIds, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.WindowsConfiguration != nil {
		ok := object.Key("WindowsConfiguration")
		if err := awsAwsjson11_serializeDocumentCreateFileSystemWindowsConfiguration(v.WindowsConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateFileSystemInput(v *CreateFileSystemInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if len(v.FileSystemType) > 0 {
		ok := object.Key("FileSystemType")
		ok.String(string(v.FileSystemType))
	}

	if v.FileSystemTypeVersion != nil {
		ok := object.Key("FileSystemTypeVersion")
		ok.String(*v.FileSystemTypeVersion)
	}

	if v.KmsKeyId != nil {
		ok := object.Key("KmsKeyId")
		ok.String(*v.KmsKeyId)
	}

	if v.LustreConfiguration != nil {
		ok := object.Key("LustreConfiguration")
		if err := awsAwsjson11_serializeDocumentCreateFileSystemLustreConfiguration(v.LustreConfiguration, ok); err != nil {
			return err
		}
	}

	if len(v.NetworkType) > 0 {
		ok := object.Key("NetworkType")
		ok.String(string(v.NetworkType))
	}

	if v.OntapConfiguration != nil {
		ok := object.Key("OntapConfiguration")
		if err := awsAwsjson11_serializeDocumentCreateFileSystemOntapConfiguration(v.OntapConfiguration, ok); err != nil {
			return err
		}
	}

	if v.OpenZFSConfiguration != nil {
		ok := object.Key("OpenZFSConfiguration")
		if err := awsAwsjson11_serializeDocumentCreateFileSystemOpenZFSConfiguration(v.OpenZFSConfiguration, ok); err != nil {
			return err
		}
	}

	if v.SecurityGroupIds != nil {
		ok := object.Key("SecurityGroupIds")
		if err := awsAwsjson11_serializeDocumentSecurityGroupIds(v.SecurityGroupIds, ok); err != nil {
			return err
		}
	}

	if v.StorageCapacity != nil {
		ok := object.Key("StorageCapacity")
		ok.Integer(*v.StorageCapacity)
	}

	if len(v.StorageType) > 0 {
		ok := object.Key("StorageType")
		ok.String(string(v.StorageType))
	}

	if v.SubnetIds != nil {
		ok := object.Key("SubnetIds")
		if err := awsAwsjson11_serializeDocumentSubnetIds(v.SubnetIds, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.WindowsConfiguration != nil {
		ok := object.Key("WindowsConfiguration")
		if err := awsAwsjson11_serializeDocumentCreateFileSystemWindowsConfiguration(v.WindowsConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateSnapshotInput(v *CreateSnapshotInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.VolumeId != nil {
		ok := object.Key("VolumeId")
		ok.String(*v.VolumeId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateStorageVirtualMachineInput(v *CreateStorageVirtualMachineInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ActiveDirectoryConfiguration != nil {
		ok := object.Key("ActiveDirectoryConfiguration")
		if err := awsAwsjson11_serializeDocumentCreateSvmActiveDirectoryConfiguration(v.ActiveDirectoryConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.FileSystemId != nil {
		ok := object.Key("FileSystemId")
		ok.String(*v.FileSystemId)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if len(v.RootVolumeSecurityStyle) > 0 {
		ok := object.Key("RootVolumeSecurityStyle")
		ok.String(string(v.RootVolumeSecurityStyle))
	}

	if v.SvmAdminPassword != nil {
		ok := object.Key("SvmAdminPassword")
		ok.String(*v.SvmAdminPassword)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateVolumeFromBackupInput(v *CreateVolumeFromBackupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BackupId != nil {
		ok := object.Key("BackupId")
		ok.String(*v.BackupId)
	}

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.OntapConfiguration != nil {
		ok := object.Key("OntapConfiguration")
		if err := awsAwsjson11_serializeDocumentCreateOntapVolumeConfiguration(v.OntapConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateVolumeInput(v *CreateVolumeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.OntapConfiguration != nil {
		ok := object.Key("OntapConfiguration")
		if err := awsAwsjson11_serializeDocumentCreateOntapVolumeConfiguration(v.OntapConfiguration, ok); err != nil {
			return err
		}
	}

	if v.OpenZFSConfiguration != nil {
		ok := object.Key("OpenZFSConfiguration")
		if err := awsAwsjson11_serializeDocumentCreateOpenZFSVolumeConfiguration(v.OpenZFSConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	if len(v.VolumeType) > 0 {
		ok := object.Key("VolumeType")
		ok.String(string(v.VolumeType))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteBackupInput(v *DeleteBackupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BackupId != nil {
		ok := object.Key("BackupId")
		ok.String(*v.BackupId)
	}

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteDataRepositoryAssociationInput(v *DeleteDataRepositoryAssociationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AssociationId != nil {
		ok := object.Key("AssociationId")
		ok.String(*v.AssociationId)
	}

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.DeleteDataInFileSystem != nil {
		ok := object.Key("DeleteDataInFileSystem")
		ok.Boolean(*v.DeleteDataInFileSystem)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteFileCacheInput(v *DeleteFileCacheInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.FileCacheId != nil {
		ok := object.Key("FileCacheId")
		ok.String(*v.FileCacheId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteFileSystemInput(v *DeleteFileSystemInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.FileSystemId != nil {
		ok := object.Key("FileSystemId")
		ok.String(*v.FileSystemId)
	}

	if v.LustreConfiguration != nil {
		ok := object.Key("LustreConfiguration")
		if err := awsAwsjson11_serializeDocumentDeleteFileSystemLustreConfiguration(v.LustreConfiguration, ok); err != nil {
			return err
		}
	}

	if v.OpenZFSConfiguration != nil {
		ok := object.Key("OpenZFSConfiguration")
		if err := awsAwsjson11_serializeDocumentDeleteFileSystemOpenZFSConfiguration(v.OpenZFSConfiguration, ok); err != nil {
			return err
		}
	}

	if v.WindowsConfiguration != nil {
		ok := object.Key("WindowsConfiguration")
		if err := awsAwsjson11_serializeDocumentDeleteFileSystemWindowsConfiguration(v.WindowsConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteSnapshotInput(v *DeleteSnapshotInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.SnapshotId != nil {
		ok := object.Key("SnapshotId")
		ok.String(*v.SnapshotId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteStorageVirtualMachineInput(v *DeleteStorageVirtualMachineInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.StorageVirtualMachineId != nil {
		ok := object.Key("StorageVirtualMachineId")
		ok.String(*v.StorageVirtualMachineId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDeleteVolumeInput(v *DeleteVolumeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.OntapConfiguration != nil {
		ok := object.Key("OntapConfiguration")
		if err := awsAwsjson11_serializeDocumentDeleteVolumeOntapConfiguration(v.OntapConfiguration, ok); err != nil {
			return err
		}
	}

	if v.OpenZFSConfiguration != nil {
		ok := object.Key("OpenZFSConfiguration")
		if err := awsAwsjson11_serializeDocumentDeleteVolumeOpenZFSConfiguration(v.OpenZFSConfiguration, ok); err != nil {
			return err
		}
	}

	if v.VolumeId != nil {
		ok := object.Key("VolumeId")
		ok.String(*v.VolumeId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeBackupsInput(v *DescribeBackupsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BackupIds != nil {
		ok := object.Key("BackupIds")
		if err := awsAwsjson11_serializeDocumentBackupIds(v.BackupIds, ok); err != nil {
			return err
		}
	}

	if v.Filters != nil {
		ok := object.Key("Filters")
		if err := awsAwsjson11_serializeDocumentFilters(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeDataRepositoryAssociationsInput(v *DescribeDataRepositoryAssociationsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AssociationIds != nil {
		ok := object.Key("AssociationIds")
		if err := awsAwsjson11_serializeDocumentDataRepositoryAssociationIds(v.AssociationIds, ok); err != nil {
			return err
		}
	}

	if v.Filters != nil {
		ok := object.Key("Filters")
		if err := awsAwsjson11_serializeDocumentFilters(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeDataRepositoryTasksInput(v *DescribeDataRepositoryTasksInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filters != nil {
		ok := object.Key("Filters")
		if err := awsAwsjson11_serializeDocumentDataRepositoryTaskFilters(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.TaskIds != nil {
		ok := object.Key("TaskIds")
		if err := awsAwsjson11_serializeDocumentTaskIds(v.TaskIds, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeFileCachesInput(v *DescribeFileCachesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FileCacheIds != nil {
		ok := object.Key("FileCacheIds")
		if err := awsAwsjson11_serializeDocumentFileCacheIds(v.FileCacheIds, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeFileSystemAliasesInput(v *DescribeFileSystemAliasesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.FileSystemId != nil {
		ok := object.Key("FileSystemId")
		ok.String(*v.FileSystemId)
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeFileSystemsInput(v *DescribeFileSystemsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FileSystemIds != nil {
		ok := object.Key("FileSystemIds")
		if err := awsAwsjson11_serializeDocumentFileSystemIds(v.FileSystemIds, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeS3AccessPointAttachmentsInput(v *DescribeS3AccessPointAttachmentsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filters != nil {
		ok := object.Key("Filters")
		if err := awsAwsjson11_serializeDocumentS3AccessPointAttachmentsFilters(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.Names != nil {
		ok := object.Key("Names")
		if err := awsAwsjson11_serializeDocumentS3AccessPointAttachmentNames(v.Names, ok); err != nil {
			return err
		}
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeSharedVpcConfigurationInput(v *DescribeSharedVpcConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeSnapshotsInput(v *DescribeSnapshotsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filters != nil {
		ok := object.Key("Filters")
		if err := awsAwsjson11_serializeDocumentSnapshotFilters(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.IncludeShared != nil {
		ok := object.Key("IncludeShared")
		ok.Boolean(*v.IncludeShared)
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.SnapshotIds != nil {
		ok := object.Key("SnapshotIds")
		if err := awsAwsjson11_serializeDocumentSnapshotIds(v.SnapshotIds, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeStorageVirtualMachinesInput(v *DescribeStorageVirtualMachinesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filters != nil {
		ok := object.Key("Filters")
		if err := awsAwsjson11_serializeDocumentStorageVirtualMachineFilters(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.StorageVirtualMachineIds != nil {
		ok := object.Key("StorageVirtualMachineIds")
		if err := awsAwsjson11_serializeDocumentStorageVirtualMachineIds(v.StorageVirtualMachineIds, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeVolumesInput(v *DescribeVolumesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filters != nil {
		ok := object.Key("Filters")
		if err := awsAwsjson11_serializeDocumentVolumeFilters(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.VolumeIds != nil {
		ok := object.Key("VolumeIds")
		if err := awsAwsjson11_serializeDocumentVolumeIds(v.VolumeIds, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDetachAndDeleteS3AccessPointInput(v *DetachAndDeleteS3AccessPointInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDisassociateFileSystemAliasesInput(v *DisassociateFileSystemAliasesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Aliases != nil {
		ok := object.Key("Aliases")
		if err := awsAwsjson11_serializeDocumentAlternateDNSNames(v.Aliases, ok); err != nil {
			return err
		}
	}

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.FileSystemId != nil {
		ok := object.Key("FileSystemId")
		ok.String(*v.FileSystemId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListTagsForResourceInput(v *ListTagsForResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.ResourceARN != nil {
		ok := object.Key("ResourceARN")
		ok.String(*v.ResourceARN)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentReleaseFileSystemNfsV3LocksInput(v *ReleaseFileSystemNfsV3LocksInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.FileSystemId != nil {
		ok := object.Key("FileSystemId")
		ok.String(*v.FileSystemId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentRestoreVolumeFromSnapshotInput(v *RestoreVolumeFromSnapshotInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.Options != nil {
		ok := object.Key("Options")
		if err := awsAwsjson11_serializeDocumentRestoreOpenZFSVolumeOptions(v.Options, ok); err != nil {
			return err
		}
	}

	if v.SnapshotId != nil {
		ok := object.Key("SnapshotId")
		ok.String(*v.SnapshotId)
	}

	if v.VolumeId != nil {
		ok := object.Key("VolumeId")
		ok.String(*v.VolumeId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentStartMisconfiguredStateRecoveryInput(v *StartMisconfiguredStateRecoveryInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.FileSystemId != nil {
		ok := object.Key("FileSystemId")
		ok.String(*v.FileSystemId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARN != nil {
		ok := object.Key("ResourceARN")
		ok.String(*v.ResourceARN)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson11_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUntagResourceInput(v *UntagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARN != nil {
		ok := object.Key("ResourceARN")
		ok.String(*v.ResourceARN)
	}

	if v.TagKeys != nil {
		ok := object.Key("TagKeys")
		if err := awsAwsjson11_serializeDocumentTagKeys(v.TagKeys, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateDataRepositoryAssociationInput(v *UpdateDataRepositoryAssociationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AssociationId != nil {
		ok := object.Key("AssociationId")
		ok.String(*v.AssociationId)
	}

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.ImportedFileChunkSize != nil {
		ok := object.Key("ImportedFileChunkSize")
		ok.Integer(*v.ImportedFileChunkSize)
	}

	if v.S3 != nil {
		ok := object.Key("S3")
		if err := awsAwsjson11_serializeDocumentS3DataRepositoryConfiguration(v.S3, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateFileCacheInput(v *UpdateFileCacheInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.FileCacheId != nil {
		ok := object.Key("FileCacheId")
		ok.String(*v.FileCacheId)
	}

	if v.LustreConfiguration != nil {
		ok := object.Key("LustreConfiguration")
		if err := awsAwsjson11_serializeDocumentUpdateFileCacheLustreConfiguration(v.LustreConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateFileSystemInput(v *UpdateFileSystemInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.FileSystemId != nil {
		ok := object.Key("FileSystemId")
		ok.String(*v.FileSystemId)
	}

	if v.FileSystemTypeVersion != nil {
		ok := object.Key("FileSystemTypeVersion")
		ok.String(*v.FileSystemTypeVersion)
	}

	if v.LustreConfiguration != nil {
		ok := object.Key("LustreConfiguration")
		if err := awsAwsjson11_serializeDocumentUpdateFileSystemLustreConfiguration(v.LustreConfiguration, ok); err != nil {
			return err
		}
	}

	if len(v.NetworkType) > 0 {
		ok := object.Key("NetworkType")
		ok.String(string(v.NetworkType))
	}

	if v.OntapConfiguration != nil {
		ok := object.Key("OntapConfiguration")
		if err := awsAwsjson11_serializeDocumentUpdateFileSystemOntapConfiguration(v.OntapConfiguration, ok); err != nil {
			return err
		}
	}

	if v.OpenZFSConfiguration != nil {
		ok := object.Key("OpenZFSConfiguration")
		if err := awsAwsjson11_serializeDocumentUpdateFileSystemOpenZFSConfiguration(v.OpenZFSConfiguration, ok); err != nil {
			return err
		}
	}

	if v.StorageCapacity != nil {
		ok := object.Key("StorageCapacity")
		ok.Integer(*v.StorageCapacity)
	}

	if len(v.StorageType) > 0 {
		ok := object.Key("StorageType")
		ok.String(string(v.StorageType))
	}

	if v.WindowsConfiguration != nil {
		ok := object.Key("WindowsConfiguration")
		if err := awsAwsjson11_serializeDocumentUpdateFileSystemWindowsConfiguration(v.WindowsConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateSharedVpcConfigurationInput(v *UpdateSharedVpcConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.EnableFsxRouteTableUpdatesFromParticipantAccounts != nil {
		ok := object.Key("EnableFsxRouteTableUpdatesFromParticipantAccounts")
		ok.String(*v.EnableFsxRouteTableUpdatesFromParticipantAccounts)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateSnapshotInput(v *UpdateSnapshotInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.SnapshotId != nil {
		ok := object.Key("SnapshotId")
		ok.String(*v.SnapshotId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateStorageVirtualMachineInput(v *UpdateStorageVirtualMachineInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ActiveDirectoryConfiguration != nil {
		ok := object.Key("ActiveDirectoryConfiguration")
		if err := awsAwsjson11_serializeDocumentUpdateSvmActiveDirectoryConfiguration(v.ActiveDirectoryConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.StorageVirtualMachineId != nil {
		ok := object.Key("StorageVirtualMachineId")
		ok.String(*v.StorageVirtualMachineId)
	}

	if v.SvmAdminPassword != nil {
		ok := object.Key("SvmAdminPassword")
		ok.String(*v.SvmAdminPassword)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateVolumeInput(v *UpdateVolumeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.OntapConfiguration != nil {
		ok := object.Key("OntapConfiguration")
		if err := awsAwsjson11_serializeDocumentUpdateOntapVolumeConfiguration(v.OntapConfiguration, ok); err != nil {
			return err
		}
	}

	if v.OpenZFSConfiguration != nil {
		ok := object.Key("OpenZFSConfiguration")
		if err := awsAwsjson11_serializeDocumentUpdateOpenZFSVolumeConfiguration(v.OpenZFSConfiguration, ok); err != nil {
			return err
		}
	}

	if v.VolumeId != nil {
		ok := object.Key("VolumeId")
		ok.String(*v.VolumeId)
	}

	return nil
}
