// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"fmt"
	smithy "github.com/aws/smithy-go"
)

// A service resource associated with the request could not be found. The resource
// might not be specified correctly, or it may have a state of DELETED .
type ResourceNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	ResourceId   *string
	ResourceType *string

	noSmithyDocumentSerde
}

func (e *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceNotFoundException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourceNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The number of one or more Amazon EVS resources exceeds the maximum allowed. For
// a list of Amazon EVS quotas, see [Amazon EVS endpoints and quotas]in the Amazon EVS User Guide. Delete some
// resources or request an increase in your service quota. To request an increase,
// see [Amazon Web Services Service Quotas]in the Amazon Web Services General Reference Guide.
//
// [Amazon Web Services Service Quotas]: https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html
// [Amazon EVS endpoints and quotas]: https://docs.aws.amazon.com/evs/latest/userguide/service-quotas-evs.html
type ServiceQuotaExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ServiceQuotaExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ServiceQuotaExceededException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ServiceQuotaExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *ServiceQuotaExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// TagPolicyException is deprecated. See [ValidationException]ValidationException instead.
//
// The request doesn't comply with IAM tag policy. Correct your request and then
// retry it.
//
// [ValidationException]: https://docs.aws.amazon.com/evs/latest/APIReference/API_ValidationException.html
type TagPolicyException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TagPolicyException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TagPolicyException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TagPolicyException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TagPolicyException"
	}
	return *e.ErrorCodeOverride
}
func (e *TagPolicyException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The CreateEnvironmentHost operation couldn't be performed because the service
// is throttling requests. This exception is thrown when the CreateEnvironmentHost
// request exceeds concurrency of 1 transaction per second (TPS).
type ThrottlingException struct {
	Message *string

	ErrorCodeOverride *string

	RetryAfterSeconds *int32

	noSmithyDocumentSerde
}

func (e *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ThrottlingException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ThrottlingException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ThrottlingException"
	}
	return *e.ErrorCodeOverride
}
func (e *ThrottlingException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// TooManyTagsException is deprecated. See [ServiceQuotaExceededException]ServiceQuotaExceededException instead.
//
// A service resource associated with the request has more than 200 tags.
//
// [ServiceQuotaExceededException]: https://docs.aws.amazon.com/evs/latest/APIReference/API_ServiceQuotaExceededException.html
type TooManyTagsException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyTagsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyTagsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyTagsException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyTagsException"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyTagsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The input fails to satisfy the specified constraints. You will see this
// exception if invalid inputs are provided for any of the Amazon EVS environment
// operations, or if a list operation is performed on an environment resource that
// is still initializing.
type ValidationException struct {
	Message *string

	ErrorCodeOverride *string

	Reason    ValidationExceptionReason
	FieldList []ValidationExceptionField

	noSmithyDocumentSerde
}

func (e *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ValidationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ValidationException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ValidationException"
	}
	return *e.ErrorCodeOverride
}
func (e *ValidationException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }
