// Code generated by smithy-go-codegen DO NOT EDIT.

package datazone

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datazone/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the accounts in the specified account pool.
func (c *Client) ListAccountsInAccountPool(ctx context.Context, params *ListAccountsInAccountPoolInput, optFns ...func(*Options)) (*ListAccountsInAccountPoolOutput, error) {
	if params == nil {
		params = &ListAccountsInAccountPoolInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAccountsInAccountPool", params, optFns, c.addOperationListAccountsInAccountPoolMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAccountsInAccountPoolOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAccountsInAccountPoolInput struct {

	// The ID of the domain in which the accounts in the specified account pool are to
	// be listed.
	//
	// This member is required.
	DomainIdentifier *string

	// The ID of the account pool whose accounts are to be listed.
	//
	// This member is required.
	Identifier *string

	// The maximum number of accounts to return in a single call to
	// ListAccountsInAccountPool. When the number of accounts to be listed is greater
	// than the value of MaxResults, the response contains a NextToken value that you
	// can use in a subsequent call to ListAccountsInAccountPool to list the next set
	// of accounts.
	MaxResults *int32

	// When the number of accounts is greater than the default value for the
	// MaxResults parameter, or if you explicitly specify a value for MaxResults that
	// is less than the number of accounts, the response includes a pagination token
	// named NextToken. You can specify this NextToken value in a subsequent call to
	// ListAccountsInAccountPool to list the next set of accounts.
	NextToken *string

	noSmithyDocumentSerde
}

type ListAccountsInAccountPoolOutput struct {

	// The results of the ListAccountsInAccountPool operation.
	Items []types.AccountInfo

	// When the number of accounts is greater than the default value for the
	// MaxResults parameter, or if you explicitly specify a value for MaxResults that
	// is less than the number of accounts, the response includes a pagination token
	// named NextToken. You can specify this NextToken value in a subsequent call to
	// ListAccountsInAccountPool to list the next set of accounts.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAccountsInAccountPoolMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListAccountsInAccountPool{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListAccountsInAccountPool{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAccountsInAccountPool"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListAccountsInAccountPoolValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAccountsInAccountPool(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListAccountsInAccountPoolPaginatorOptions is the paginator options for
// ListAccountsInAccountPool
type ListAccountsInAccountPoolPaginatorOptions struct {
	// The maximum number of accounts to return in a single call to
	// ListAccountsInAccountPool. When the number of accounts to be listed is greater
	// than the value of MaxResults, the response contains a NextToken value that you
	// can use in a subsequent call to ListAccountsInAccountPool to list the next set
	// of accounts.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAccountsInAccountPoolPaginator is a paginator for ListAccountsInAccountPool
type ListAccountsInAccountPoolPaginator struct {
	options   ListAccountsInAccountPoolPaginatorOptions
	client    ListAccountsInAccountPoolAPIClient
	params    *ListAccountsInAccountPoolInput
	nextToken *string
	firstPage bool
}

// NewListAccountsInAccountPoolPaginator returns a new
// ListAccountsInAccountPoolPaginator
func NewListAccountsInAccountPoolPaginator(client ListAccountsInAccountPoolAPIClient, params *ListAccountsInAccountPoolInput, optFns ...func(*ListAccountsInAccountPoolPaginatorOptions)) *ListAccountsInAccountPoolPaginator {
	if params == nil {
		params = &ListAccountsInAccountPoolInput{}
	}

	options := ListAccountsInAccountPoolPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAccountsInAccountPoolPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAccountsInAccountPoolPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAccountsInAccountPool page.
func (p *ListAccountsInAccountPoolPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAccountsInAccountPoolOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListAccountsInAccountPool(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListAccountsInAccountPoolAPIClient is a client that implements the
// ListAccountsInAccountPool operation.
type ListAccountsInAccountPoolAPIClient interface {
	ListAccountsInAccountPool(context.Context, *ListAccountsInAccountPoolInput, ...func(*Options)) (*ListAccountsInAccountPoolOutput, error)
}

var _ ListAccountsInAccountPoolAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListAccountsInAccountPool(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAccountsInAccountPool",
	}
}
