// Code generated by smithy-go-codegen DO NOT EDIT.

package cleanroomsml

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/cleanroomsml/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
)

type awsRestjson1_serializeOpCancelTrainedModel struct {
}

func (*awsRestjson1_serializeOpCancelTrainedModel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCancelTrainedModel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CancelTrainedModelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/memberships/{membershipIdentifier}/trained-models/{trainedModelArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCancelTrainedModelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCancelTrainedModelInput(v *CancelTrainedModelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MembershipIdentifier == nil || len(*v.MembershipIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member membershipIdentifier must not be empty")}
	}
	if v.MembershipIdentifier != nil {
		if err := encoder.SetURI("membershipIdentifier").String(*v.MembershipIdentifier); err != nil {
			return err
		}
	}

	if v.TrainedModelArn == nil || len(*v.TrainedModelArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member trainedModelArn must not be empty")}
	}
	if v.TrainedModelArn != nil {
		if err := encoder.SetURI("trainedModelArn").String(*v.TrainedModelArn); err != nil {
			return err
		}
	}

	if v.VersionIdentifier != nil {
		encoder.SetQuery("versionIdentifier").String(*v.VersionIdentifier)
	}

	return nil
}

type awsRestjson1_serializeOpCancelTrainedModelInferenceJob struct {
}

func (*awsRestjson1_serializeOpCancelTrainedModelInferenceJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCancelTrainedModelInferenceJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CancelTrainedModelInferenceJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/memberships/{membershipIdentifier}/trained-model-inference-jobs/{trainedModelInferenceJobArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCancelTrainedModelInferenceJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCancelTrainedModelInferenceJobInput(v *CancelTrainedModelInferenceJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MembershipIdentifier == nil || len(*v.MembershipIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member membershipIdentifier must not be empty")}
	}
	if v.MembershipIdentifier != nil {
		if err := encoder.SetURI("membershipIdentifier").String(*v.MembershipIdentifier); err != nil {
			return err
		}
	}

	if v.TrainedModelInferenceJobArn == nil || len(*v.TrainedModelInferenceJobArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member trainedModelInferenceJobArn must not be empty")}
	}
	if v.TrainedModelInferenceJobArn != nil {
		if err := encoder.SetURI("trainedModelInferenceJobArn").String(*v.TrainedModelInferenceJobArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateAudienceModel struct {
}

func (*awsRestjson1_serializeOpCreateAudienceModel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateAudienceModel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateAudienceModelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audience-model")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateAudienceModelInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateAudienceModelInput(v *CreateAudienceModelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateAudienceModelInput(v *CreateAudienceModelInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.KmsKeyArn != nil {
		ok := object.Key("kmsKeyArn")
		ok.String(*v.KmsKeyArn)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.TrainingDataEndTime != nil {
		ok := object.Key("trainingDataEndTime")
		ok.String(smithytime.FormatDateTime(*v.TrainingDataEndTime))
	}

	if v.TrainingDatasetArn != nil {
		ok := object.Key("trainingDatasetArn")
		ok.String(*v.TrainingDatasetArn)
	}

	if v.TrainingDataStartTime != nil {
		ok := object.Key("trainingDataStartTime")
		ok.String(smithytime.FormatDateTime(*v.TrainingDataStartTime))
	}

	return nil
}

type awsRestjson1_serializeOpCreateConfiguredAudienceModel struct {
}

func (*awsRestjson1_serializeOpCreateConfiguredAudienceModel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateConfiguredAudienceModel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateConfiguredAudienceModelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/configured-audience-model")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateConfiguredAudienceModelInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateConfiguredAudienceModelInput(v *CreateConfiguredAudienceModelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateConfiguredAudienceModelInput(v *CreateConfiguredAudienceModelInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AudienceModelArn != nil {
		ok := object.Key("audienceModelArn")
		ok.String(*v.AudienceModelArn)
	}

	if v.AudienceSizeConfig != nil {
		ok := object.Key("audienceSizeConfig")
		if err := awsRestjson1_serializeDocumentAudienceSizeConfig(v.AudienceSizeConfig, ok); err != nil {
			return err
		}
	}

	if len(v.ChildResourceTagOnCreatePolicy) > 0 {
		ok := object.Key("childResourceTagOnCreatePolicy")
		ok.String(string(v.ChildResourceTagOnCreatePolicy))
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.MinMatchingSeedSize != nil {
		ok := object.Key("minMatchingSeedSize")
		ok.Integer(*v.MinMatchingSeedSize)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.OutputConfig != nil {
		ok := object.Key("outputConfig")
		if err := awsRestjson1_serializeDocumentConfiguredAudienceModelOutputConfig(v.OutputConfig, ok); err != nil {
			return err
		}
	}

	if v.SharedAudienceMetrics != nil {
		ok := object.Key("sharedAudienceMetrics")
		if err := awsRestjson1_serializeDocumentMetricsList(v.SharedAudienceMetrics, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateConfiguredModelAlgorithm struct {
}

func (*awsRestjson1_serializeOpCreateConfiguredModelAlgorithm) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateConfiguredModelAlgorithm) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateConfiguredModelAlgorithmInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/configured-model-algorithms")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateConfiguredModelAlgorithmInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateConfiguredModelAlgorithmInput(v *CreateConfiguredModelAlgorithmInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateConfiguredModelAlgorithmInput(v *CreateConfiguredModelAlgorithmInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.InferenceContainerConfig != nil {
		ok := object.Key("inferenceContainerConfig")
		if err := awsRestjson1_serializeDocumentInferenceContainerConfig(v.InferenceContainerConfig, ok); err != nil {
			return err
		}
	}

	if v.KmsKeyArn != nil {
		ok := object.Key("kmsKeyArn")
		ok.String(*v.KmsKeyArn)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.TrainingContainerConfig != nil {
		ok := object.Key("trainingContainerConfig")
		if err := awsRestjson1_serializeDocumentContainerConfig(v.TrainingContainerConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateConfiguredModelAlgorithmAssociation struct {
}

func (*awsRestjson1_serializeOpCreateConfiguredModelAlgorithmAssociation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateConfiguredModelAlgorithmAssociation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateConfiguredModelAlgorithmAssociationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/memberships/{membershipIdentifier}/configured-model-algorithm-associations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateConfiguredModelAlgorithmAssociationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateConfiguredModelAlgorithmAssociationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateConfiguredModelAlgorithmAssociationInput(v *CreateConfiguredModelAlgorithmAssociationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MembershipIdentifier == nil || len(*v.MembershipIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member membershipIdentifier must not be empty")}
	}
	if v.MembershipIdentifier != nil {
		if err := encoder.SetURI("membershipIdentifier").String(*v.MembershipIdentifier); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateConfiguredModelAlgorithmAssociationInput(v *CreateConfiguredModelAlgorithmAssociationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConfiguredModelAlgorithmArn != nil {
		ok := object.Key("configuredModelAlgorithmArn")
		ok.String(*v.ConfiguredModelAlgorithmArn)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.PrivacyConfiguration != nil {
		ok := object.Key("privacyConfiguration")
		if err := awsRestjson1_serializeDocumentPrivacyConfiguration(v.PrivacyConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateMLInputChannel struct {
}

func (*awsRestjson1_serializeOpCreateMLInputChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateMLInputChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateMLInputChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/memberships/{membershipIdentifier}/ml-input-channels")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateMLInputChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateMLInputChannelInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateMLInputChannelInput(v *CreateMLInputChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MembershipIdentifier == nil || len(*v.MembershipIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member membershipIdentifier must not be empty")}
	}
	if v.MembershipIdentifier != nil {
		if err := encoder.SetURI("membershipIdentifier").String(*v.MembershipIdentifier); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateMLInputChannelInput(v *CreateMLInputChannelInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConfiguredModelAlgorithmAssociations != nil {
		ok := object.Key("configuredModelAlgorithmAssociations")
		if err := awsRestjson1_serializeDocumentConfiguredModelAlgorithmAssociationArnList(v.ConfiguredModelAlgorithmAssociations, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.InputChannel != nil {
		ok := object.Key("inputChannel")
		if err := awsRestjson1_serializeDocumentInputChannel(v.InputChannel, ok); err != nil {
			return err
		}
	}

	if v.KmsKeyArn != nil {
		ok := object.Key("kmsKeyArn")
		ok.String(*v.KmsKeyArn)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.RetentionInDays != nil {
		ok := object.Key("retentionInDays")
		ok.Integer(*v.RetentionInDays)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateTrainedModel struct {
}

func (*awsRestjson1_serializeOpCreateTrainedModel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateTrainedModel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateTrainedModelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/memberships/{membershipIdentifier}/trained-models")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateTrainedModelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateTrainedModelInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateTrainedModelInput(v *CreateTrainedModelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MembershipIdentifier == nil || len(*v.MembershipIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member membershipIdentifier must not be empty")}
	}
	if v.MembershipIdentifier != nil {
		if err := encoder.SetURI("membershipIdentifier").String(*v.MembershipIdentifier); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateTrainedModelInput(v *CreateTrainedModelInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConfiguredModelAlgorithmAssociationArn != nil {
		ok := object.Key("configuredModelAlgorithmAssociationArn")
		ok.String(*v.ConfiguredModelAlgorithmAssociationArn)
	}

	if v.DataChannels != nil {
		ok := object.Key("dataChannels")
		if err := awsRestjson1_serializeDocumentModelTrainingDataChannels(v.DataChannels, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Environment != nil {
		ok := object.Key("environment")
		if err := awsRestjson1_serializeDocumentEnvironment(v.Environment, ok); err != nil {
			return err
		}
	}

	if v.Hyperparameters != nil {
		ok := object.Key("hyperparameters")
		if err := awsRestjson1_serializeDocumentHyperParameters(v.Hyperparameters, ok); err != nil {
			return err
		}
	}

	if v.IncrementalTrainingDataChannels != nil {
		ok := object.Key("incrementalTrainingDataChannels")
		if err := awsRestjson1_serializeDocumentIncrementalTrainingDataChannels(v.IncrementalTrainingDataChannels, ok); err != nil {
			return err
		}
	}

	if v.KmsKeyArn != nil {
		ok := object.Key("kmsKeyArn")
		ok.String(*v.KmsKeyArn)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.ResourceConfig != nil {
		ok := object.Key("resourceConfig")
		if err := awsRestjson1_serializeDocumentResourceConfig(v.ResourceConfig, ok); err != nil {
			return err
		}
	}

	if v.StoppingCondition != nil {
		ok := object.Key("stoppingCondition")
		if err := awsRestjson1_serializeDocumentStoppingCondition(v.StoppingCondition, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	if len(v.TrainingInputMode) > 0 {
		ok := object.Key("trainingInputMode")
		ok.String(string(v.TrainingInputMode))
	}

	return nil
}

type awsRestjson1_serializeOpCreateTrainingDataset struct {
}

func (*awsRestjson1_serializeOpCreateTrainingDataset) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateTrainingDataset) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateTrainingDatasetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/training-dataset")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateTrainingDatasetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateTrainingDatasetInput(v *CreateTrainingDatasetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateTrainingDatasetInput(v *CreateTrainingDatasetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.TrainingData != nil {
		ok := object.Key("trainingData")
		if err := awsRestjson1_serializeDocumentDatasetList(v.TrainingData, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteAudienceGenerationJob struct {
}

func (*awsRestjson1_serializeOpDeleteAudienceGenerationJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteAudienceGenerationJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteAudienceGenerationJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audience-generation-job/{audienceGenerationJobArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteAudienceGenerationJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteAudienceGenerationJobInput(v *DeleteAudienceGenerationJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AudienceGenerationJobArn == nil || len(*v.AudienceGenerationJobArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member audienceGenerationJobArn must not be empty")}
	}
	if v.AudienceGenerationJobArn != nil {
		if err := encoder.SetURI("audienceGenerationJobArn").String(*v.AudienceGenerationJobArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteAudienceModel struct {
}

func (*awsRestjson1_serializeOpDeleteAudienceModel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteAudienceModel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteAudienceModelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audience-model/{audienceModelArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteAudienceModelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteAudienceModelInput(v *DeleteAudienceModelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AudienceModelArn == nil || len(*v.AudienceModelArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member audienceModelArn must not be empty")}
	}
	if v.AudienceModelArn != nil {
		if err := encoder.SetURI("audienceModelArn").String(*v.AudienceModelArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteConfiguredAudienceModel struct {
}

func (*awsRestjson1_serializeOpDeleteConfiguredAudienceModel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteConfiguredAudienceModel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteConfiguredAudienceModelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/configured-audience-model/{configuredAudienceModelArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteConfiguredAudienceModelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteConfiguredAudienceModelInput(v *DeleteConfiguredAudienceModelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ConfiguredAudienceModelArn == nil || len(*v.ConfiguredAudienceModelArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member configuredAudienceModelArn must not be empty")}
	}
	if v.ConfiguredAudienceModelArn != nil {
		if err := encoder.SetURI("configuredAudienceModelArn").String(*v.ConfiguredAudienceModelArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteConfiguredAudienceModelPolicy struct {
}

func (*awsRestjson1_serializeOpDeleteConfiguredAudienceModelPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteConfiguredAudienceModelPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteConfiguredAudienceModelPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/configured-audience-model/{configuredAudienceModelArn}/policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteConfiguredAudienceModelPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteConfiguredAudienceModelPolicyInput(v *DeleteConfiguredAudienceModelPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ConfiguredAudienceModelArn == nil || len(*v.ConfiguredAudienceModelArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member configuredAudienceModelArn must not be empty")}
	}
	if v.ConfiguredAudienceModelArn != nil {
		if err := encoder.SetURI("configuredAudienceModelArn").String(*v.ConfiguredAudienceModelArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteConfiguredModelAlgorithm struct {
}

func (*awsRestjson1_serializeOpDeleteConfiguredModelAlgorithm) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteConfiguredModelAlgorithm) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteConfiguredModelAlgorithmInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/configured-model-algorithms/{configuredModelAlgorithmArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteConfiguredModelAlgorithmInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteConfiguredModelAlgorithmInput(v *DeleteConfiguredModelAlgorithmInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ConfiguredModelAlgorithmArn == nil || len(*v.ConfiguredModelAlgorithmArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member configuredModelAlgorithmArn must not be empty")}
	}
	if v.ConfiguredModelAlgorithmArn != nil {
		if err := encoder.SetURI("configuredModelAlgorithmArn").String(*v.ConfiguredModelAlgorithmArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteConfiguredModelAlgorithmAssociation struct {
}

func (*awsRestjson1_serializeOpDeleteConfiguredModelAlgorithmAssociation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteConfiguredModelAlgorithmAssociation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteConfiguredModelAlgorithmAssociationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/memberships/{membershipIdentifier}/configured-model-algorithm-associations/{configuredModelAlgorithmAssociationArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteConfiguredModelAlgorithmAssociationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteConfiguredModelAlgorithmAssociationInput(v *DeleteConfiguredModelAlgorithmAssociationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ConfiguredModelAlgorithmAssociationArn == nil || len(*v.ConfiguredModelAlgorithmAssociationArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member configuredModelAlgorithmAssociationArn must not be empty")}
	}
	if v.ConfiguredModelAlgorithmAssociationArn != nil {
		if err := encoder.SetURI("configuredModelAlgorithmAssociationArn").String(*v.ConfiguredModelAlgorithmAssociationArn); err != nil {
			return err
		}
	}

	if v.MembershipIdentifier == nil || len(*v.MembershipIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member membershipIdentifier must not be empty")}
	}
	if v.MembershipIdentifier != nil {
		if err := encoder.SetURI("membershipIdentifier").String(*v.MembershipIdentifier); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteMLConfiguration struct {
}

func (*awsRestjson1_serializeOpDeleteMLConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteMLConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteMLConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/memberships/{membershipIdentifier}/ml-configurations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteMLConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteMLConfigurationInput(v *DeleteMLConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MembershipIdentifier == nil || len(*v.MembershipIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member membershipIdentifier must not be empty")}
	}
	if v.MembershipIdentifier != nil {
		if err := encoder.SetURI("membershipIdentifier").String(*v.MembershipIdentifier); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteMLInputChannelData struct {
}

func (*awsRestjson1_serializeOpDeleteMLInputChannelData) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteMLInputChannelData) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteMLInputChannelDataInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/memberships/{membershipIdentifier}/ml-input-channels/{mlInputChannelArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteMLInputChannelDataInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteMLInputChannelDataInput(v *DeleteMLInputChannelDataInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MembershipIdentifier == nil || len(*v.MembershipIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member membershipIdentifier must not be empty")}
	}
	if v.MembershipIdentifier != nil {
		if err := encoder.SetURI("membershipIdentifier").String(*v.MembershipIdentifier); err != nil {
			return err
		}
	}

	if v.MlInputChannelArn == nil || len(*v.MlInputChannelArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member mlInputChannelArn must not be empty")}
	}
	if v.MlInputChannelArn != nil {
		if err := encoder.SetURI("mlInputChannelArn").String(*v.MlInputChannelArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteTrainedModelOutput struct {
}

func (*awsRestjson1_serializeOpDeleteTrainedModelOutput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteTrainedModelOutput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteTrainedModelOutputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/memberships/{membershipIdentifier}/trained-models/{trainedModelArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteTrainedModelOutputInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteTrainedModelOutputInput(v *DeleteTrainedModelOutputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MembershipIdentifier == nil || len(*v.MembershipIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member membershipIdentifier must not be empty")}
	}
	if v.MembershipIdentifier != nil {
		if err := encoder.SetURI("membershipIdentifier").String(*v.MembershipIdentifier); err != nil {
			return err
		}
	}

	if v.TrainedModelArn == nil || len(*v.TrainedModelArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member trainedModelArn must not be empty")}
	}
	if v.TrainedModelArn != nil {
		if err := encoder.SetURI("trainedModelArn").String(*v.TrainedModelArn); err != nil {
			return err
		}
	}

	if v.VersionIdentifier != nil {
		encoder.SetQuery("versionIdentifier").String(*v.VersionIdentifier)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteTrainingDataset struct {
}

func (*awsRestjson1_serializeOpDeleteTrainingDataset) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteTrainingDataset) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteTrainingDatasetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/training-dataset/{trainingDatasetArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteTrainingDatasetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteTrainingDatasetInput(v *DeleteTrainingDatasetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TrainingDatasetArn == nil || len(*v.TrainingDatasetArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member trainingDatasetArn must not be empty")}
	}
	if v.TrainingDatasetArn != nil {
		if err := encoder.SetURI("trainingDatasetArn").String(*v.TrainingDatasetArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetAudienceGenerationJob struct {
}

func (*awsRestjson1_serializeOpGetAudienceGenerationJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetAudienceGenerationJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetAudienceGenerationJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audience-generation-job/{audienceGenerationJobArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetAudienceGenerationJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetAudienceGenerationJobInput(v *GetAudienceGenerationJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AudienceGenerationJobArn == nil || len(*v.AudienceGenerationJobArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member audienceGenerationJobArn must not be empty")}
	}
	if v.AudienceGenerationJobArn != nil {
		if err := encoder.SetURI("audienceGenerationJobArn").String(*v.AudienceGenerationJobArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetAudienceModel struct {
}

func (*awsRestjson1_serializeOpGetAudienceModel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetAudienceModel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetAudienceModelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audience-model/{audienceModelArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetAudienceModelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetAudienceModelInput(v *GetAudienceModelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AudienceModelArn == nil || len(*v.AudienceModelArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member audienceModelArn must not be empty")}
	}
	if v.AudienceModelArn != nil {
		if err := encoder.SetURI("audienceModelArn").String(*v.AudienceModelArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetCollaborationConfiguredModelAlgorithmAssociation struct {
}

func (*awsRestjson1_serializeOpGetCollaborationConfiguredModelAlgorithmAssociation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetCollaborationConfiguredModelAlgorithmAssociation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetCollaborationConfiguredModelAlgorithmAssociationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/collaborations/{collaborationIdentifier}/configured-model-algorithm-associations/{configuredModelAlgorithmAssociationArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetCollaborationConfiguredModelAlgorithmAssociationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetCollaborationConfiguredModelAlgorithmAssociationInput(v *GetCollaborationConfiguredModelAlgorithmAssociationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CollaborationIdentifier == nil || len(*v.CollaborationIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member collaborationIdentifier must not be empty")}
	}
	if v.CollaborationIdentifier != nil {
		if err := encoder.SetURI("collaborationIdentifier").String(*v.CollaborationIdentifier); err != nil {
			return err
		}
	}

	if v.ConfiguredModelAlgorithmAssociationArn == nil || len(*v.ConfiguredModelAlgorithmAssociationArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member configuredModelAlgorithmAssociationArn must not be empty")}
	}
	if v.ConfiguredModelAlgorithmAssociationArn != nil {
		if err := encoder.SetURI("configuredModelAlgorithmAssociationArn").String(*v.ConfiguredModelAlgorithmAssociationArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetCollaborationMLInputChannel struct {
}

func (*awsRestjson1_serializeOpGetCollaborationMLInputChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetCollaborationMLInputChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetCollaborationMLInputChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/collaborations/{collaborationIdentifier}/ml-input-channels/{mlInputChannelArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetCollaborationMLInputChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetCollaborationMLInputChannelInput(v *GetCollaborationMLInputChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CollaborationIdentifier == nil || len(*v.CollaborationIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member collaborationIdentifier must not be empty")}
	}
	if v.CollaborationIdentifier != nil {
		if err := encoder.SetURI("collaborationIdentifier").String(*v.CollaborationIdentifier); err != nil {
			return err
		}
	}

	if v.MlInputChannelArn == nil || len(*v.MlInputChannelArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member mlInputChannelArn must not be empty")}
	}
	if v.MlInputChannelArn != nil {
		if err := encoder.SetURI("mlInputChannelArn").String(*v.MlInputChannelArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetCollaborationTrainedModel struct {
}

func (*awsRestjson1_serializeOpGetCollaborationTrainedModel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetCollaborationTrainedModel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetCollaborationTrainedModelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/collaborations/{collaborationIdentifier}/trained-models/{trainedModelArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetCollaborationTrainedModelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetCollaborationTrainedModelInput(v *GetCollaborationTrainedModelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CollaborationIdentifier == nil || len(*v.CollaborationIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member collaborationIdentifier must not be empty")}
	}
	if v.CollaborationIdentifier != nil {
		if err := encoder.SetURI("collaborationIdentifier").String(*v.CollaborationIdentifier); err != nil {
			return err
		}
	}

	if v.TrainedModelArn == nil || len(*v.TrainedModelArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member trainedModelArn must not be empty")}
	}
	if v.TrainedModelArn != nil {
		if err := encoder.SetURI("trainedModelArn").String(*v.TrainedModelArn); err != nil {
			return err
		}
	}

	if v.VersionIdentifier != nil {
		encoder.SetQuery("versionIdentifier").String(*v.VersionIdentifier)
	}

	return nil
}

type awsRestjson1_serializeOpGetConfiguredAudienceModel struct {
}

func (*awsRestjson1_serializeOpGetConfiguredAudienceModel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetConfiguredAudienceModel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetConfiguredAudienceModelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/configured-audience-model/{configuredAudienceModelArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetConfiguredAudienceModelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetConfiguredAudienceModelInput(v *GetConfiguredAudienceModelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ConfiguredAudienceModelArn == nil || len(*v.ConfiguredAudienceModelArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member configuredAudienceModelArn must not be empty")}
	}
	if v.ConfiguredAudienceModelArn != nil {
		if err := encoder.SetURI("configuredAudienceModelArn").String(*v.ConfiguredAudienceModelArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetConfiguredAudienceModelPolicy struct {
}

func (*awsRestjson1_serializeOpGetConfiguredAudienceModelPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetConfiguredAudienceModelPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetConfiguredAudienceModelPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/configured-audience-model/{configuredAudienceModelArn}/policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetConfiguredAudienceModelPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetConfiguredAudienceModelPolicyInput(v *GetConfiguredAudienceModelPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ConfiguredAudienceModelArn == nil || len(*v.ConfiguredAudienceModelArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member configuredAudienceModelArn must not be empty")}
	}
	if v.ConfiguredAudienceModelArn != nil {
		if err := encoder.SetURI("configuredAudienceModelArn").String(*v.ConfiguredAudienceModelArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetConfiguredModelAlgorithm struct {
}

func (*awsRestjson1_serializeOpGetConfiguredModelAlgorithm) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetConfiguredModelAlgorithm) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetConfiguredModelAlgorithmInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/configured-model-algorithms/{configuredModelAlgorithmArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetConfiguredModelAlgorithmInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetConfiguredModelAlgorithmInput(v *GetConfiguredModelAlgorithmInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ConfiguredModelAlgorithmArn == nil || len(*v.ConfiguredModelAlgorithmArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member configuredModelAlgorithmArn must not be empty")}
	}
	if v.ConfiguredModelAlgorithmArn != nil {
		if err := encoder.SetURI("configuredModelAlgorithmArn").String(*v.ConfiguredModelAlgorithmArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetConfiguredModelAlgorithmAssociation struct {
}

func (*awsRestjson1_serializeOpGetConfiguredModelAlgorithmAssociation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetConfiguredModelAlgorithmAssociation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetConfiguredModelAlgorithmAssociationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/memberships/{membershipIdentifier}/configured-model-algorithm-associations/{configuredModelAlgorithmAssociationArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetConfiguredModelAlgorithmAssociationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetConfiguredModelAlgorithmAssociationInput(v *GetConfiguredModelAlgorithmAssociationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ConfiguredModelAlgorithmAssociationArn == nil || len(*v.ConfiguredModelAlgorithmAssociationArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member configuredModelAlgorithmAssociationArn must not be empty")}
	}
	if v.ConfiguredModelAlgorithmAssociationArn != nil {
		if err := encoder.SetURI("configuredModelAlgorithmAssociationArn").String(*v.ConfiguredModelAlgorithmAssociationArn); err != nil {
			return err
		}
	}

	if v.MembershipIdentifier == nil || len(*v.MembershipIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member membershipIdentifier must not be empty")}
	}
	if v.MembershipIdentifier != nil {
		if err := encoder.SetURI("membershipIdentifier").String(*v.MembershipIdentifier); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetMLConfiguration struct {
}

func (*awsRestjson1_serializeOpGetMLConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetMLConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetMLConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/memberships/{membershipIdentifier}/ml-configurations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetMLConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetMLConfigurationInput(v *GetMLConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MembershipIdentifier == nil || len(*v.MembershipIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member membershipIdentifier must not be empty")}
	}
	if v.MembershipIdentifier != nil {
		if err := encoder.SetURI("membershipIdentifier").String(*v.MembershipIdentifier); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetMLInputChannel struct {
}

func (*awsRestjson1_serializeOpGetMLInputChannel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetMLInputChannel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetMLInputChannelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/memberships/{membershipIdentifier}/ml-input-channels/{mlInputChannelArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetMLInputChannelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetMLInputChannelInput(v *GetMLInputChannelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MembershipIdentifier == nil || len(*v.MembershipIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member membershipIdentifier must not be empty")}
	}
	if v.MembershipIdentifier != nil {
		if err := encoder.SetURI("membershipIdentifier").String(*v.MembershipIdentifier); err != nil {
			return err
		}
	}

	if v.MlInputChannelArn == nil || len(*v.MlInputChannelArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member mlInputChannelArn must not be empty")}
	}
	if v.MlInputChannelArn != nil {
		if err := encoder.SetURI("mlInputChannelArn").String(*v.MlInputChannelArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetTrainedModel struct {
}

func (*awsRestjson1_serializeOpGetTrainedModel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetTrainedModel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetTrainedModelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/memberships/{membershipIdentifier}/trained-models/{trainedModelArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetTrainedModelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetTrainedModelInput(v *GetTrainedModelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MembershipIdentifier == nil || len(*v.MembershipIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member membershipIdentifier must not be empty")}
	}
	if v.MembershipIdentifier != nil {
		if err := encoder.SetURI("membershipIdentifier").String(*v.MembershipIdentifier); err != nil {
			return err
		}
	}

	if v.TrainedModelArn == nil || len(*v.TrainedModelArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member trainedModelArn must not be empty")}
	}
	if v.TrainedModelArn != nil {
		if err := encoder.SetURI("trainedModelArn").String(*v.TrainedModelArn); err != nil {
			return err
		}
	}

	if v.VersionIdentifier != nil {
		encoder.SetQuery("versionIdentifier").String(*v.VersionIdentifier)
	}

	return nil
}

type awsRestjson1_serializeOpGetTrainedModelInferenceJob struct {
}

func (*awsRestjson1_serializeOpGetTrainedModelInferenceJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetTrainedModelInferenceJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetTrainedModelInferenceJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/memberships/{membershipIdentifier}/trained-model-inference-jobs/{trainedModelInferenceJobArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetTrainedModelInferenceJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetTrainedModelInferenceJobInput(v *GetTrainedModelInferenceJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MembershipIdentifier == nil || len(*v.MembershipIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member membershipIdentifier must not be empty")}
	}
	if v.MembershipIdentifier != nil {
		if err := encoder.SetURI("membershipIdentifier").String(*v.MembershipIdentifier); err != nil {
			return err
		}
	}

	if v.TrainedModelInferenceJobArn == nil || len(*v.TrainedModelInferenceJobArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member trainedModelInferenceJobArn must not be empty")}
	}
	if v.TrainedModelInferenceJobArn != nil {
		if err := encoder.SetURI("trainedModelInferenceJobArn").String(*v.TrainedModelInferenceJobArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetTrainingDataset struct {
}

func (*awsRestjson1_serializeOpGetTrainingDataset) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetTrainingDataset) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetTrainingDatasetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/training-dataset/{trainingDatasetArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetTrainingDatasetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetTrainingDatasetInput(v *GetTrainingDatasetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TrainingDatasetArn == nil || len(*v.TrainingDatasetArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member trainingDatasetArn must not be empty")}
	}
	if v.TrainingDatasetArn != nil {
		if err := encoder.SetURI("trainingDatasetArn").String(*v.TrainingDatasetArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListAudienceExportJobs struct {
}

func (*awsRestjson1_serializeOpListAudienceExportJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListAudienceExportJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAudienceExportJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audience-export-job")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListAudienceExportJobsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListAudienceExportJobsInput(v *ListAudienceExportJobsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AudienceGenerationJobArn != nil {
		encoder.SetQuery("audienceGenerationJobArn").String(*v.AudienceGenerationJobArn)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListAudienceGenerationJobs struct {
}

func (*awsRestjson1_serializeOpListAudienceGenerationJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListAudienceGenerationJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAudienceGenerationJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audience-generation-job")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListAudienceGenerationJobsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListAudienceGenerationJobsInput(v *ListAudienceGenerationJobsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CollaborationId != nil {
		encoder.SetQuery("collaborationId").String(*v.CollaborationId)
	}

	if v.ConfiguredAudienceModelArn != nil {
		encoder.SetQuery("configuredAudienceModelArn").String(*v.ConfiguredAudienceModelArn)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListAudienceModels struct {
}

func (*awsRestjson1_serializeOpListAudienceModels) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListAudienceModels) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAudienceModelsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audience-model")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListAudienceModelsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListAudienceModelsInput(v *ListAudienceModelsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListCollaborationConfiguredModelAlgorithmAssociations struct {
}

func (*awsRestjson1_serializeOpListCollaborationConfiguredModelAlgorithmAssociations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListCollaborationConfiguredModelAlgorithmAssociations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListCollaborationConfiguredModelAlgorithmAssociationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/collaborations/{collaborationIdentifier}/configured-model-algorithm-associations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListCollaborationConfiguredModelAlgorithmAssociationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListCollaborationConfiguredModelAlgorithmAssociationsInput(v *ListCollaborationConfiguredModelAlgorithmAssociationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CollaborationIdentifier == nil || len(*v.CollaborationIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member collaborationIdentifier must not be empty")}
	}
	if v.CollaborationIdentifier != nil {
		if err := encoder.SetURI("collaborationIdentifier").String(*v.CollaborationIdentifier); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListCollaborationMLInputChannels struct {
}

func (*awsRestjson1_serializeOpListCollaborationMLInputChannels) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListCollaborationMLInputChannels) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListCollaborationMLInputChannelsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/collaborations/{collaborationIdentifier}/ml-input-channels")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListCollaborationMLInputChannelsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListCollaborationMLInputChannelsInput(v *ListCollaborationMLInputChannelsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CollaborationIdentifier == nil || len(*v.CollaborationIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member collaborationIdentifier must not be empty")}
	}
	if v.CollaborationIdentifier != nil {
		if err := encoder.SetURI("collaborationIdentifier").String(*v.CollaborationIdentifier); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListCollaborationTrainedModelExportJobs struct {
}

func (*awsRestjson1_serializeOpListCollaborationTrainedModelExportJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListCollaborationTrainedModelExportJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListCollaborationTrainedModelExportJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/collaborations/{collaborationIdentifier}/trained-models/{trainedModelArn}/export-jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListCollaborationTrainedModelExportJobsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListCollaborationTrainedModelExportJobsInput(v *ListCollaborationTrainedModelExportJobsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CollaborationIdentifier == nil || len(*v.CollaborationIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member collaborationIdentifier must not be empty")}
	}
	if v.CollaborationIdentifier != nil {
		if err := encoder.SetURI("collaborationIdentifier").String(*v.CollaborationIdentifier); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.TrainedModelArn == nil || len(*v.TrainedModelArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member trainedModelArn must not be empty")}
	}
	if v.TrainedModelArn != nil {
		if err := encoder.SetURI("trainedModelArn").String(*v.TrainedModelArn); err != nil {
			return err
		}
	}

	if v.TrainedModelVersionIdentifier != nil {
		encoder.SetQuery("trainedModelVersionIdentifier").String(*v.TrainedModelVersionIdentifier)
	}

	return nil
}

type awsRestjson1_serializeOpListCollaborationTrainedModelInferenceJobs struct {
}

func (*awsRestjson1_serializeOpListCollaborationTrainedModelInferenceJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListCollaborationTrainedModelInferenceJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListCollaborationTrainedModelInferenceJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/collaborations/{collaborationIdentifier}/trained-model-inference-jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListCollaborationTrainedModelInferenceJobsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListCollaborationTrainedModelInferenceJobsInput(v *ListCollaborationTrainedModelInferenceJobsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CollaborationIdentifier == nil || len(*v.CollaborationIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member collaborationIdentifier must not be empty")}
	}
	if v.CollaborationIdentifier != nil {
		if err := encoder.SetURI("collaborationIdentifier").String(*v.CollaborationIdentifier); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.TrainedModelArn != nil {
		encoder.SetQuery("trainedModelArn").String(*v.TrainedModelArn)
	}

	if v.TrainedModelVersionIdentifier != nil {
		encoder.SetQuery("trainedModelVersionIdentifier").String(*v.TrainedModelVersionIdentifier)
	}

	return nil
}

type awsRestjson1_serializeOpListCollaborationTrainedModels struct {
}

func (*awsRestjson1_serializeOpListCollaborationTrainedModels) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListCollaborationTrainedModels) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListCollaborationTrainedModelsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/collaborations/{collaborationIdentifier}/trained-models")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListCollaborationTrainedModelsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListCollaborationTrainedModelsInput(v *ListCollaborationTrainedModelsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.CollaborationIdentifier == nil || len(*v.CollaborationIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member collaborationIdentifier must not be empty")}
	}
	if v.CollaborationIdentifier != nil {
		if err := encoder.SetURI("collaborationIdentifier").String(*v.CollaborationIdentifier); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListConfiguredAudienceModels struct {
}

func (*awsRestjson1_serializeOpListConfiguredAudienceModels) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListConfiguredAudienceModels) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListConfiguredAudienceModelsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/configured-audience-model")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListConfiguredAudienceModelsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListConfiguredAudienceModelsInput(v *ListConfiguredAudienceModelsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListConfiguredModelAlgorithmAssociations struct {
}

func (*awsRestjson1_serializeOpListConfiguredModelAlgorithmAssociations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListConfiguredModelAlgorithmAssociations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListConfiguredModelAlgorithmAssociationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/memberships/{membershipIdentifier}/configured-model-algorithm-associations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListConfiguredModelAlgorithmAssociationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListConfiguredModelAlgorithmAssociationsInput(v *ListConfiguredModelAlgorithmAssociationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.MembershipIdentifier == nil || len(*v.MembershipIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member membershipIdentifier must not be empty")}
	}
	if v.MembershipIdentifier != nil {
		if err := encoder.SetURI("membershipIdentifier").String(*v.MembershipIdentifier); err != nil {
			return err
		}
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListConfiguredModelAlgorithms struct {
}

func (*awsRestjson1_serializeOpListConfiguredModelAlgorithms) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListConfiguredModelAlgorithms) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListConfiguredModelAlgorithmsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/configured-model-algorithms")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListConfiguredModelAlgorithmsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListConfiguredModelAlgorithmsInput(v *ListConfiguredModelAlgorithmsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListMLInputChannels struct {
}

func (*awsRestjson1_serializeOpListMLInputChannels) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListMLInputChannels) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListMLInputChannelsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/memberships/{membershipIdentifier}/ml-input-channels")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListMLInputChannelsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListMLInputChannelsInput(v *ListMLInputChannelsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.MembershipIdentifier == nil || len(*v.MembershipIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member membershipIdentifier must not be empty")}
	}
	if v.MembershipIdentifier != nil {
		if err := encoder.SetURI("membershipIdentifier").String(*v.MembershipIdentifier); err != nil {
			return err
		}
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListTrainedModelInferenceJobs struct {
}

func (*awsRestjson1_serializeOpListTrainedModelInferenceJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTrainedModelInferenceJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTrainedModelInferenceJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/memberships/{membershipIdentifier}/trained-model-inference-jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTrainedModelInferenceJobsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTrainedModelInferenceJobsInput(v *ListTrainedModelInferenceJobsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.MembershipIdentifier == nil || len(*v.MembershipIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member membershipIdentifier must not be empty")}
	}
	if v.MembershipIdentifier != nil {
		if err := encoder.SetURI("membershipIdentifier").String(*v.MembershipIdentifier); err != nil {
			return err
		}
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.TrainedModelArn != nil {
		encoder.SetQuery("trainedModelArn").String(*v.TrainedModelArn)
	}

	if v.TrainedModelVersionIdentifier != nil {
		encoder.SetQuery("trainedModelVersionIdentifier").String(*v.TrainedModelVersionIdentifier)
	}

	return nil
}

type awsRestjson1_serializeOpListTrainedModels struct {
}

func (*awsRestjson1_serializeOpListTrainedModels) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTrainedModels) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTrainedModelsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/memberships/{membershipIdentifier}/trained-models")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTrainedModelsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTrainedModelsInput(v *ListTrainedModelsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.MembershipIdentifier == nil || len(*v.MembershipIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member membershipIdentifier must not be empty")}
	}
	if v.MembershipIdentifier != nil {
		if err := encoder.SetURI("membershipIdentifier").String(*v.MembershipIdentifier); err != nil {
			return err
		}
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListTrainedModelVersions struct {
}

func (*awsRestjson1_serializeOpListTrainedModelVersions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTrainedModelVersions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTrainedModelVersionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/memberships/{membershipIdentifier}/trained-models/{trainedModelArn}/versions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTrainedModelVersionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTrainedModelVersionsInput(v *ListTrainedModelVersionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.MembershipIdentifier == nil || len(*v.MembershipIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member membershipIdentifier must not be empty")}
	}
	if v.MembershipIdentifier != nil {
		if err := encoder.SetURI("membershipIdentifier").String(*v.MembershipIdentifier); err != nil {
			return err
		}
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if len(v.Status) > 0 {
		encoder.SetQuery("status").String(string(v.Status))
	}

	if v.TrainedModelArn == nil || len(*v.TrainedModelArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member trainedModelArn must not be empty")}
	}
	if v.TrainedModelArn != nil {
		if err := encoder.SetURI("trainedModelArn").String(*v.TrainedModelArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListTrainingDatasets struct {
}

func (*awsRestjson1_serializeOpListTrainingDatasets) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTrainingDatasets) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTrainingDatasetsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/training-dataset")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTrainingDatasetsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTrainingDatasetsInput(v *ListTrainingDatasetsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpPutConfiguredAudienceModelPolicy struct {
}

func (*awsRestjson1_serializeOpPutConfiguredAudienceModelPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutConfiguredAudienceModelPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutConfiguredAudienceModelPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/configured-audience-model/{configuredAudienceModelArn}/policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutConfiguredAudienceModelPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutConfiguredAudienceModelPolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutConfiguredAudienceModelPolicyInput(v *PutConfiguredAudienceModelPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ConfiguredAudienceModelArn == nil || len(*v.ConfiguredAudienceModelArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member configuredAudienceModelArn must not be empty")}
	}
	if v.ConfiguredAudienceModelArn != nil {
		if err := encoder.SetURI("configuredAudienceModelArn").String(*v.ConfiguredAudienceModelArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutConfiguredAudienceModelPolicyInput(v *PutConfiguredAudienceModelPolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConfiguredAudienceModelPolicy != nil {
		ok := object.Key("configuredAudienceModelPolicy")
		ok.String(*v.ConfiguredAudienceModelPolicy)
	}

	if len(v.PolicyExistenceCondition) > 0 {
		ok := object.Key("policyExistenceCondition")
		ok.String(string(v.PolicyExistenceCondition))
	}

	if v.PreviousPolicyHash != nil {
		ok := object.Key("previousPolicyHash")
		ok.String(*v.PreviousPolicyHash)
	}

	return nil
}

type awsRestjson1_serializeOpPutMLConfiguration struct {
}

func (*awsRestjson1_serializeOpPutMLConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutMLConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutMLConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/memberships/{membershipIdentifier}/ml-configurations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutMLConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutMLConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutMLConfigurationInput(v *PutMLConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MembershipIdentifier == nil || len(*v.MembershipIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member membershipIdentifier must not be empty")}
	}
	if v.MembershipIdentifier != nil {
		if err := encoder.SetURI("membershipIdentifier").String(*v.MembershipIdentifier); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutMLConfigurationInput(v *PutMLConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DefaultOutputLocation != nil {
		ok := object.Key("defaultOutputLocation")
		if err := awsRestjson1_serializeDocumentMLOutputConfiguration(v.DefaultOutputLocation, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStartAudienceExportJob struct {
}

func (*awsRestjson1_serializeOpStartAudienceExportJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartAudienceExportJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartAudienceExportJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audience-export-job")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStartAudienceExportJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartAudienceExportJobInput(v *StartAudienceExportJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStartAudienceExportJobInput(v *StartAudienceExportJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AudienceGenerationJobArn != nil {
		ok := object.Key("audienceGenerationJobArn")
		ok.String(*v.AudienceGenerationJobArn)
	}

	if v.AudienceSize != nil {
		ok := object.Key("audienceSize")
		if err := awsRestjson1_serializeDocumentAudienceSize(v.AudienceSize, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

type awsRestjson1_serializeOpStartAudienceGenerationJob struct {
}

func (*awsRestjson1_serializeOpStartAudienceGenerationJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartAudienceGenerationJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartAudienceGenerationJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/audience-generation-job")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStartAudienceGenerationJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartAudienceGenerationJobInput(v *StartAudienceGenerationJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStartAudienceGenerationJobInput(v *StartAudienceGenerationJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CollaborationId != nil {
		ok := object.Key("collaborationId")
		ok.String(*v.CollaborationId)
	}

	if v.ConfiguredAudienceModelArn != nil {
		ok := object.Key("configuredAudienceModelArn")
		ok.String(*v.ConfiguredAudienceModelArn)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.IncludeSeedInOutput {
		ok := object.Key("includeSeedInOutput")
		ok.Boolean(v.IncludeSeedInOutput)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.SeedAudience != nil {
		ok := object.Key("seedAudience")
		if err := awsRestjson1_serializeDocumentAudienceGenerationJobDataSource(v.SeedAudience, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStartTrainedModelExportJob struct {
}

func (*awsRestjson1_serializeOpStartTrainedModelExportJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartTrainedModelExportJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartTrainedModelExportJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/memberships/{membershipIdentifier}/trained-models/{trainedModelArn}/export-jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStartTrainedModelExportJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStartTrainedModelExportJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartTrainedModelExportJobInput(v *StartTrainedModelExportJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MembershipIdentifier == nil || len(*v.MembershipIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member membershipIdentifier must not be empty")}
	}
	if v.MembershipIdentifier != nil {
		if err := encoder.SetURI("membershipIdentifier").String(*v.MembershipIdentifier); err != nil {
			return err
		}
	}

	if v.TrainedModelArn == nil || len(*v.TrainedModelArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member trainedModelArn must not be empty")}
	}
	if v.TrainedModelArn != nil {
		if err := encoder.SetURI("trainedModelArn").String(*v.TrainedModelArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStartTrainedModelExportJobInput(v *StartTrainedModelExportJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.OutputConfiguration != nil {
		ok := object.Key("outputConfiguration")
		if err := awsRestjson1_serializeDocumentTrainedModelExportOutputConfiguration(v.OutputConfiguration, ok); err != nil {
			return err
		}
	}

	if v.TrainedModelVersionIdentifier != nil {
		ok := object.Key("trainedModelVersionIdentifier")
		ok.String(*v.TrainedModelVersionIdentifier)
	}

	return nil
}

type awsRestjson1_serializeOpStartTrainedModelInferenceJob struct {
}

func (*awsRestjson1_serializeOpStartTrainedModelInferenceJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartTrainedModelInferenceJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartTrainedModelInferenceJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/memberships/{membershipIdentifier}/trained-model-inference-jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStartTrainedModelInferenceJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStartTrainedModelInferenceJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartTrainedModelInferenceJobInput(v *StartTrainedModelInferenceJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MembershipIdentifier == nil || len(*v.MembershipIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member membershipIdentifier must not be empty")}
	}
	if v.MembershipIdentifier != nil {
		if err := encoder.SetURI("membershipIdentifier").String(*v.MembershipIdentifier); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStartTrainedModelInferenceJobInput(v *StartTrainedModelInferenceJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConfiguredModelAlgorithmAssociationArn != nil {
		ok := object.Key("configuredModelAlgorithmAssociationArn")
		ok.String(*v.ConfiguredModelAlgorithmAssociationArn)
	}

	if v.ContainerExecutionParameters != nil {
		ok := object.Key("containerExecutionParameters")
		if err := awsRestjson1_serializeDocumentInferenceContainerExecutionParameters(v.ContainerExecutionParameters, ok); err != nil {
			return err
		}
	}

	if v.DataSource != nil {
		ok := object.Key("dataSource")
		if err := awsRestjson1_serializeDocumentModelInferenceDataSource(v.DataSource, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Environment != nil {
		ok := object.Key("environment")
		if err := awsRestjson1_serializeDocumentInferenceEnvironmentMap(v.Environment, ok); err != nil {
			return err
		}
	}

	if v.KmsKeyArn != nil {
		ok := object.Key("kmsKeyArn")
		ok.String(*v.KmsKeyArn)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.OutputConfiguration != nil {
		ok := object.Key("outputConfiguration")
		if err := awsRestjson1_serializeDocumentInferenceOutputConfiguration(v.OutputConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ResourceConfig != nil {
		ok := object.Key("resourceConfig")
		if err := awsRestjson1_serializeDocumentInferenceResourceConfig(v.ResourceConfig, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.TrainedModelArn != nil {
		ok := object.Key("trainedModelArn")
		ok.String(*v.TrainedModelArn)
	}

	if v.TrainedModelVersionIdentifier != nil {
		ok := object.Key("trainedModelVersionIdentifier")
		ok.String(*v.TrainedModelVersionIdentifier)
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	if v.TagKeys != nil {
		for i := range v.TagKeys {
			encoder.AddQuery("tagKeys").String(v.TagKeys[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateConfiguredAudienceModel struct {
}

func (*awsRestjson1_serializeOpUpdateConfiguredAudienceModel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateConfiguredAudienceModel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateConfiguredAudienceModelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/configured-audience-model/{configuredAudienceModelArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateConfiguredAudienceModelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateConfiguredAudienceModelInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateConfiguredAudienceModelInput(v *UpdateConfiguredAudienceModelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ConfiguredAudienceModelArn == nil || len(*v.ConfiguredAudienceModelArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member configuredAudienceModelArn must not be empty")}
	}
	if v.ConfiguredAudienceModelArn != nil {
		if err := encoder.SetURI("configuredAudienceModelArn").String(*v.ConfiguredAudienceModelArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateConfiguredAudienceModelInput(v *UpdateConfiguredAudienceModelInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AudienceModelArn != nil {
		ok := object.Key("audienceModelArn")
		ok.String(*v.AudienceModelArn)
	}

	if v.AudienceSizeConfig != nil {
		ok := object.Key("audienceSizeConfig")
		if err := awsRestjson1_serializeDocumentAudienceSizeConfig(v.AudienceSizeConfig, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.MinMatchingSeedSize != nil {
		ok := object.Key("minMatchingSeedSize")
		ok.Integer(*v.MinMatchingSeedSize)
	}

	if v.OutputConfig != nil {
		ok := object.Key("outputConfig")
		if err := awsRestjson1_serializeDocumentConfiguredAudienceModelOutputConfig(v.OutputConfig, ok); err != nil {
			return err
		}
	}

	if v.SharedAudienceMetrics != nil {
		ok := object.Key("sharedAudienceMetrics")
		if err := awsRestjson1_serializeDocumentMetricsList(v.SharedAudienceMetrics, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAccountIdList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentAudienceDestination(v *types.AudienceDestination, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.S3Destination != nil {
		ok := object.Key("s3Destination")
		if err := awsRestjson1_serializeDocumentS3ConfigMap(v.S3Destination, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAudienceGenerationJobDataSource(v *types.AudienceGenerationJobDataSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSource != nil {
		ok := object.Key("dataSource")
		if err := awsRestjson1_serializeDocumentS3ConfigMap(v.DataSource, ok); err != nil {
			return err
		}
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.SqlComputeConfiguration != nil {
		ok := object.Key("sqlComputeConfiguration")
		if err := awsRestjson1_serializeDocumentComputeConfiguration(v.SqlComputeConfiguration, ok); err != nil {
			return err
		}
	}

	if v.SqlParameters != nil {
		ok := object.Key("sqlParameters")
		if err := awsRestjson1_serializeDocumentProtectedQuerySQLParameters(v.SqlParameters, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAudienceSize(v *types.AudienceSize, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.Integer(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentAudienceSizeBins(v []int32, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.Integer(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentAudienceSizeConfig(v *types.AudienceSizeConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AudienceSizeBins != nil {
		ok := object.Key("audienceSizeBins")
		if err := awsRestjson1_serializeDocumentAudienceSizeBins(v.AudienceSizeBins, ok); err != nil {
			return err
		}
	}

	if len(v.AudienceSizeType) > 0 {
		ok := object.Key("audienceSizeType")
		ok.String(string(v.AudienceSizeType))
	}

	return nil
}

func awsRestjson1_serializeDocumentColumnSchema(v *types.ColumnSchema, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ColumnName != nil {
		ok := object.Key("columnName")
		ok.String(*v.ColumnName)
	}

	if v.ColumnTypes != nil {
		ok := object.Key("columnTypes")
		if err := awsRestjson1_serializeDocumentColumnTypeList(v.ColumnTypes, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentColumnTypeList(v []types.ColumnType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentComputeConfiguration(v types.ComputeConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.ComputeConfigurationMemberWorker:
		av := object.Key("worker")
		if err := awsRestjson1_serializeDocumentWorkerComputeConfiguration(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentConfiguredAudienceModelOutputConfig(v *types.ConfiguredAudienceModelOutputConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Destination != nil {
		ok := object.Key("destination")
		if err := awsRestjson1_serializeDocumentAudienceDestination(v.Destination, ok); err != nil {
			return err
		}
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentConfiguredModelAlgorithmAssociationArnList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentContainerArguments(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentContainerConfig(v *types.ContainerConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Arguments != nil {
		ok := object.Key("arguments")
		if err := awsRestjson1_serializeDocumentContainerArguments(v.Arguments, ok); err != nil {
			return err
		}
	}

	if v.Entrypoint != nil {
		ok := object.Key("entrypoint")
		if err := awsRestjson1_serializeDocumentContainerEntrypoint(v.Entrypoint, ok); err != nil {
			return err
		}
	}

	if v.ImageUri != nil {
		ok := object.Key("imageUri")
		ok.String(*v.ImageUri)
	}

	if v.MetricDefinitions != nil {
		ok := object.Key("metricDefinitions")
		if err := awsRestjson1_serializeDocumentMetricDefinitionList(v.MetricDefinitions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentContainerEntrypoint(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentDataset(v *types.Dataset, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InputConfig != nil {
		ok := object.Key("inputConfig")
		if err := awsRestjson1_serializeDocumentDatasetInputConfig(v.InputConfig, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentDatasetInputConfig(v *types.DatasetInputConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSource != nil {
		ok := object.Key("dataSource")
		if err := awsRestjson1_serializeDocumentDataSource(v.DataSource, ok); err != nil {
			return err
		}
	}

	if v.Schema != nil {
		ok := object.Key("schema")
		if err := awsRestjson1_serializeDocumentDatasetSchemaList(v.Schema, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDatasetList(v []types.Dataset, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDataset(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDatasetSchemaList(v []types.ColumnSchema, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentColumnSchema(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDataSource(v *types.DataSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GlueDataSource != nil {
		ok := object.Key("glueDataSource")
		if err := awsRestjson1_serializeDocumentGlueDataSource(v.GlueDataSource, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDestination(v *types.Destination, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.S3Destination != nil {
		ok := object.Key("s3Destination")
		if err := awsRestjson1_serializeDocumentS3ConfigMap(v.S3Destination, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentEnvironment(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentGlueDataSource(v *types.GlueDataSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CatalogId != nil {
		ok := object.Key("catalogId")
		ok.String(*v.CatalogId)
	}

	if v.DatabaseName != nil {
		ok := object.Key("databaseName")
		ok.String(*v.DatabaseName)
	}

	if v.TableName != nil {
		ok := object.Key("tableName")
		ok.String(*v.TableName)
	}

	return nil
}

func awsRestjson1_serializeDocumentHyperParameters(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentIncrementalTrainingDataChannel(v *types.IncrementalTrainingDataChannel, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ChannelName != nil {
		ok := object.Key("channelName")
		ok.String(*v.ChannelName)
	}

	if v.TrainedModelArn != nil {
		ok := object.Key("trainedModelArn")
		ok.String(*v.TrainedModelArn)
	}

	if v.VersionIdentifier != nil {
		ok := object.Key("versionIdentifier")
		ok.String(*v.VersionIdentifier)
	}

	return nil
}

func awsRestjson1_serializeDocumentIncrementalTrainingDataChannels(v []types.IncrementalTrainingDataChannel, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentIncrementalTrainingDataChannel(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentInferenceContainerConfig(v *types.InferenceContainerConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ImageUri != nil {
		ok := object.Key("imageUri")
		ok.String(*v.ImageUri)
	}

	return nil
}

func awsRestjson1_serializeDocumentInferenceContainerExecutionParameters(v *types.InferenceContainerExecutionParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxPayloadInMB != nil {
		ok := object.Key("maxPayloadInMB")
		ok.Integer(*v.MaxPayloadInMB)
	}

	return nil
}

func awsRestjson1_serializeDocumentInferenceEnvironmentMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentInferenceOutputConfiguration(v *types.InferenceOutputConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Accept != nil {
		ok := object.Key("accept")
		ok.String(*v.Accept)
	}

	if v.Members != nil {
		ok := object.Key("members")
		if err := awsRestjson1_serializeDocumentInferenceReceiverMembers(v.Members, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentInferenceReceiverMember(v *types.InferenceReceiverMember, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountId != nil {
		ok := object.Key("accountId")
		ok.String(*v.AccountId)
	}

	return nil
}

func awsRestjson1_serializeDocumentInferenceReceiverMembers(v []types.InferenceReceiverMember, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentInferenceReceiverMember(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentInferenceResourceConfig(v *types.InferenceResourceConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InstanceCount != nil {
		ok := object.Key("instanceCount")
		ok.Integer(*v.InstanceCount)
	}

	if len(v.InstanceType) > 0 {
		ok := object.Key("instanceType")
		ok.String(string(v.InstanceType))
	}

	return nil
}

func awsRestjson1_serializeDocumentInputChannel(v *types.InputChannel, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSource != nil {
		ok := object.Key("dataSource")
		if err := awsRestjson1_serializeDocumentInputChannelDataSource(v.DataSource, ok); err != nil {
			return err
		}
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentInputChannelDataSource(v types.InputChannelDataSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.InputChannelDataSourceMemberProtectedQueryInputParameters:
		av := object.Key("protectedQueryInputParameters")
		if err := awsRestjson1_serializeDocumentProtectedQueryInputParameters(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentLogsConfigurationPolicy(v *types.LogsConfigurationPolicy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllowedAccountIds != nil {
		ok := object.Key("allowedAccountIds")
		if err := awsRestjson1_serializeDocumentAccountIdList(v.AllowedAccountIds, ok); err != nil {
			return err
		}
	}

	if v.FilterPattern != nil {
		ok := object.Key("filterPattern")
		ok.String(*v.FilterPattern)
	}

	return nil
}

func awsRestjson1_serializeDocumentLogsConfigurationPolicyList(v []types.LogsConfigurationPolicy, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentLogsConfigurationPolicy(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentMetricDefinition(v *types.MetricDefinition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Regex != nil {
		ok := object.Key("regex")
		ok.String(*v.Regex)
	}

	return nil
}

func awsRestjson1_serializeDocumentMetricDefinitionList(v []types.MetricDefinition, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentMetricDefinition(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentMetricsConfigurationPolicy(v *types.MetricsConfigurationPolicy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.NoiseLevel) > 0 {
		ok := object.Key("noiseLevel")
		ok.String(string(v.NoiseLevel))
	}

	return nil
}

func awsRestjson1_serializeDocumentMetricsList(v []types.SharedAudienceMetrics, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentMLOutputConfiguration(v *types.MLOutputConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Destination != nil {
		ok := object.Key("destination")
		if err := awsRestjson1_serializeDocumentDestination(v.Destination, ok); err != nil {
			return err
		}
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentModelInferenceDataSource(v *types.ModelInferenceDataSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MlInputChannelArn != nil {
		ok := object.Key("mlInputChannelArn")
		ok.String(*v.MlInputChannelArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentModelTrainingDataChannel(v *types.ModelTrainingDataChannel, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ChannelName != nil {
		ok := object.Key("channelName")
		ok.String(*v.ChannelName)
	}

	if v.MlInputChannelArn != nil {
		ok := object.Key("mlInputChannelArn")
		ok.String(*v.MlInputChannelArn)
	}

	if len(v.S3DataDistributionType) > 0 {
		ok := object.Key("s3DataDistributionType")
		ok.String(string(v.S3DataDistributionType))
	}

	return nil
}

func awsRestjson1_serializeDocumentModelTrainingDataChannels(v []types.ModelTrainingDataChannel, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentModelTrainingDataChannel(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentParameterMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentPrivacyConfiguration(v *types.PrivacyConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Policies != nil {
		ok := object.Key("policies")
		if err := awsRestjson1_serializeDocumentPrivacyConfigurationPolicies(v.Policies, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPrivacyConfigurationPolicies(v *types.PrivacyConfigurationPolicies, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TrainedModelExports != nil {
		ok := object.Key("trainedModelExports")
		if err := awsRestjson1_serializeDocumentTrainedModelExportsConfigurationPolicy(v.TrainedModelExports, ok); err != nil {
			return err
		}
	}

	if v.TrainedModelInferenceJobs != nil {
		ok := object.Key("trainedModelInferenceJobs")
		if err := awsRestjson1_serializeDocumentTrainedModelInferenceJobsConfigurationPolicy(v.TrainedModelInferenceJobs, ok); err != nil {
			return err
		}
	}

	if v.TrainedModels != nil {
		ok := object.Key("trainedModels")
		if err := awsRestjson1_serializeDocumentTrainedModelsConfigurationPolicy(v.TrainedModels, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentProtectedQueryInputParameters(v *types.ProtectedQueryInputParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ComputeConfiguration != nil {
		ok := object.Key("computeConfiguration")
		if err := awsRestjson1_serializeDocumentComputeConfiguration(v.ComputeConfiguration, ok); err != nil {
			return err
		}
	}

	if len(v.ResultFormat) > 0 {
		ok := object.Key("resultFormat")
		ok.String(string(v.ResultFormat))
	}

	if v.SqlParameters != nil {
		ok := object.Key("sqlParameters")
		if err := awsRestjson1_serializeDocumentProtectedQuerySQLParameters(v.SqlParameters, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentProtectedQuerySQLParameters(v *types.ProtectedQuerySQLParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AnalysisTemplateArn != nil {
		ok := object.Key("analysisTemplateArn")
		ok.String(*v.AnalysisTemplateArn)
	}

	if v.Parameters != nil {
		ok := object.Key("parameters")
		if err := awsRestjson1_serializeDocumentParameterMap(v.Parameters, ok); err != nil {
			return err
		}
	}

	if v.QueryString != nil {
		ok := object.Key("queryString")
		ok.String(*v.QueryString)
	}

	return nil
}

func awsRestjson1_serializeDocumentResourceConfig(v *types.ResourceConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InstanceCount != nil {
		ok := object.Key("instanceCount")
		ok.Integer(*v.InstanceCount)
	}

	if len(v.InstanceType) > 0 {
		ok := object.Key("instanceType")
		ok.String(string(v.InstanceType))
	}

	if v.VolumeSizeInGB != nil {
		ok := object.Key("volumeSizeInGB")
		ok.Integer(*v.VolumeSizeInGB)
	}

	return nil
}

func awsRestjson1_serializeDocumentS3ConfigMap(v *types.S3ConfigMap, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.S3Uri != nil {
		ok := object.Key("s3Uri")
		ok.String(*v.S3Uri)
	}

	return nil
}

func awsRestjson1_serializeDocumentStoppingCondition(v *types.StoppingCondition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxRuntimeInSeconds != nil {
		ok := object.Key("maxRuntimeInSeconds")
		ok.Integer(*v.MaxRuntimeInSeconds)
	}

	return nil
}

func awsRestjson1_serializeDocumentTagMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentTrainedModelArtifactMaxSize(v *types.TrainedModelArtifactMaxSize, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Unit) > 0 {
		ok := object.Key("unit")
		ok.String(string(v.Unit))
	}

	if v.Value != nil {
		ok := object.Key("value")
		switch {
		case math.IsNaN(*v.Value):
			ok.String("NaN")

		case math.IsInf(*v.Value, 1):
			ok.String("Infinity")

		case math.IsInf(*v.Value, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.Value)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTrainedModelExportFileTypeList(v []types.TrainedModelExportFileType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentTrainedModelExportOutputConfiguration(v *types.TrainedModelExportOutputConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Members != nil {
		ok := object.Key("members")
		if err := awsRestjson1_serializeDocumentTrainedModelExportReceiverMembers(v.Members, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTrainedModelExportReceiverMember(v *types.TrainedModelExportReceiverMember, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountId != nil {
		ok := object.Key("accountId")
		ok.String(*v.AccountId)
	}

	return nil
}

func awsRestjson1_serializeDocumentTrainedModelExportReceiverMembers(v []types.TrainedModelExportReceiverMember, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentTrainedModelExportReceiverMember(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentTrainedModelExportsConfigurationPolicy(v *types.TrainedModelExportsConfigurationPolicy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FilesToExport != nil {
		ok := object.Key("filesToExport")
		if err := awsRestjson1_serializeDocumentTrainedModelExportFileTypeList(v.FilesToExport, ok); err != nil {
			return err
		}
	}

	if v.MaxSize != nil {
		ok := object.Key("maxSize")
		if err := awsRestjson1_serializeDocumentTrainedModelExportsMaxSize(v.MaxSize, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTrainedModelExportsMaxSize(v *types.TrainedModelExportsMaxSize, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Unit) > 0 {
		ok := object.Key("unit")
		ok.String(string(v.Unit))
	}

	if v.Value != nil {
		ok := object.Key("value")
		switch {
		case math.IsNaN(*v.Value):
			ok.String("NaN")

		case math.IsInf(*v.Value, 1):
			ok.String("Infinity")

		case math.IsInf(*v.Value, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.Value)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTrainedModelInferenceJobsConfigurationPolicy(v *types.TrainedModelInferenceJobsConfigurationPolicy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContainerLogs != nil {
		ok := object.Key("containerLogs")
		if err := awsRestjson1_serializeDocumentLogsConfigurationPolicyList(v.ContainerLogs, ok); err != nil {
			return err
		}
	}

	if v.MaxOutputSize != nil {
		ok := object.Key("maxOutputSize")
		if err := awsRestjson1_serializeDocumentTrainedModelInferenceMaxOutputSize(v.MaxOutputSize, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTrainedModelInferenceMaxOutputSize(v *types.TrainedModelInferenceMaxOutputSize, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Unit) > 0 {
		ok := object.Key("unit")
		ok.String(string(v.Unit))
	}

	if v.Value != nil {
		ok := object.Key("value")
		switch {
		case math.IsNaN(*v.Value):
			ok.String("NaN")

		case math.IsInf(*v.Value, 1):
			ok.String("Infinity")

		case math.IsInf(*v.Value, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.Value)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTrainedModelsConfigurationPolicy(v *types.TrainedModelsConfigurationPolicy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContainerLogs != nil {
		ok := object.Key("containerLogs")
		if err := awsRestjson1_serializeDocumentLogsConfigurationPolicyList(v.ContainerLogs, ok); err != nil {
			return err
		}
	}

	if v.ContainerMetrics != nil {
		ok := object.Key("containerMetrics")
		if err := awsRestjson1_serializeDocumentMetricsConfigurationPolicy(v.ContainerMetrics, ok); err != nil {
			return err
		}
	}

	if v.MaxArtifactSize != nil {
		ok := object.Key("maxArtifactSize")
		if err := awsRestjson1_serializeDocumentTrainedModelArtifactMaxSize(v.MaxArtifactSize, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentWorkerComputeConfiguration(v *types.WorkerComputeConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Number != nil {
		ok := object.Key("number")
		ok.Integer(*v.Number)
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}
