// Code generated by smithy-go-codegen DO NOT EDIT.

package arcregionswitch

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/arcregionswitch/types"
	smithy "github.com/aws/smithy-go"
	smithycbor "github.com/aws/smithy-go/encoding/cbor"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/ptr"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"io"
	"io/ioutil"
	"strings"
	"time"
)

type smithyRpcv2cbor_deserializeOpApprovePlanExecutionStep struct {
}

func (*smithyRpcv2cbor_deserializeOpApprovePlanExecutionStep) ID() string {
	return "OperationDeserializer"
}

func (m *smithyRpcv2cbor_deserializeOpApprovePlanExecutionStep) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()

	if err != nil {
		return out, metadata, err
	}

	resp, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", out.RawResponse)
	}

	if resp.Header.Get("smithy-protocol") != "rpc-v2-cbor" {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf(
				"unexpected smithy-protocol response header '%s' (HTTP status: %s)",
				resp.Header.Get("smithy-protocol"),
				resp.Status,
			),
		}
	}

	if resp.StatusCode != 200 {
		return out, metadata, rpc2_deserializeOpErrorApprovePlanExecutionStep(resp)
	}

	if _, err = io.Copy(ioutil.Discard, resp.Body); err != nil {
		return out, metadata, fmt.Errorf("discard response body: %w", err)
	}

	out.Result = &ApprovePlanExecutionStepOutput{}

	return out, metadata, nil
}

type smithyRpcv2cbor_deserializeOpCancelPlanExecution struct {
}

func (*smithyRpcv2cbor_deserializeOpCancelPlanExecution) ID() string {
	return "OperationDeserializer"
}

func (m *smithyRpcv2cbor_deserializeOpCancelPlanExecution) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()

	if err != nil {
		return out, metadata, err
	}

	resp, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", out.RawResponse)
	}

	if resp.Header.Get("smithy-protocol") != "rpc-v2-cbor" {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf(
				"unexpected smithy-protocol response header '%s' (HTTP status: %s)",
				resp.Header.Get("smithy-protocol"),
				resp.Status,
			),
		}
	}

	if resp.StatusCode != 200 {
		return out, metadata, rpc2_deserializeOpErrorCancelPlanExecution(resp)
	}

	if _, err = io.Copy(ioutil.Discard, resp.Body); err != nil {
		return out, metadata, fmt.Errorf("discard response body: %w", err)
	}

	out.Result = &CancelPlanExecutionOutput{}

	return out, metadata, nil
}

type smithyRpcv2cbor_deserializeOpCreatePlan struct {
}

func (*smithyRpcv2cbor_deserializeOpCreatePlan) ID() string {
	return "OperationDeserializer"
}

func (m *smithyRpcv2cbor_deserializeOpCreatePlan) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()

	if err != nil {
		return out, metadata, err
	}

	resp, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", out.RawResponse)
	}

	if resp.Header.Get("smithy-protocol") != "rpc-v2-cbor" {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf(
				"unexpected smithy-protocol response header '%s' (HTTP status: %s)",
				resp.Header.Get("smithy-protocol"),
				resp.Status,
			),
		}
	}

	if resp.StatusCode != 200 {
		return out, metadata, rpc2_deserializeOpErrorCreatePlan(resp)
	}

	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return out, metadata, err
	}

	if len(payload) == 0 {
		out.Result = &CreatePlanOutput{}
		return out, metadata, nil
	}

	cv, err := smithycbor.Decode(payload)
	if err != nil {
		return out, metadata, err
	}

	output, err := deserializeCBOR_CreatePlanOutput(cv)
	if err != nil {
		return out, metadata, err
	}

	out.Result = output

	return out, metadata, nil
}

type smithyRpcv2cbor_deserializeOpDeletePlan struct {
}

func (*smithyRpcv2cbor_deserializeOpDeletePlan) ID() string {
	return "OperationDeserializer"
}

func (m *smithyRpcv2cbor_deserializeOpDeletePlan) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()

	if err != nil {
		return out, metadata, err
	}

	resp, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", out.RawResponse)
	}

	if resp.Header.Get("smithy-protocol") != "rpc-v2-cbor" {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf(
				"unexpected smithy-protocol response header '%s' (HTTP status: %s)",
				resp.Header.Get("smithy-protocol"),
				resp.Status,
			),
		}
	}

	if resp.StatusCode != 200 {
		return out, metadata, rpc2_deserializeOpErrorDeletePlan(resp)
	}

	if _, err = io.Copy(ioutil.Discard, resp.Body); err != nil {
		return out, metadata, fmt.Errorf("discard response body: %w", err)
	}

	out.Result = &DeletePlanOutput{}

	return out, metadata, nil
}

type smithyRpcv2cbor_deserializeOpGetPlan struct {
}

func (*smithyRpcv2cbor_deserializeOpGetPlan) ID() string {
	return "OperationDeserializer"
}

func (m *smithyRpcv2cbor_deserializeOpGetPlan) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()

	if err != nil {
		return out, metadata, err
	}

	resp, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", out.RawResponse)
	}

	if resp.Header.Get("smithy-protocol") != "rpc-v2-cbor" {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf(
				"unexpected smithy-protocol response header '%s' (HTTP status: %s)",
				resp.Header.Get("smithy-protocol"),
				resp.Status,
			),
		}
	}

	if resp.StatusCode != 200 {
		return out, metadata, rpc2_deserializeOpErrorGetPlan(resp)
	}

	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return out, metadata, err
	}

	if len(payload) == 0 {
		out.Result = &GetPlanOutput{}
		return out, metadata, nil
	}

	cv, err := smithycbor.Decode(payload)
	if err != nil {
		return out, metadata, err
	}

	output, err := deserializeCBOR_GetPlanOutput(cv)
	if err != nil {
		return out, metadata, err
	}

	out.Result = output

	return out, metadata, nil
}

type smithyRpcv2cbor_deserializeOpGetPlanEvaluationStatus struct {
}

func (*smithyRpcv2cbor_deserializeOpGetPlanEvaluationStatus) ID() string {
	return "OperationDeserializer"
}

func (m *smithyRpcv2cbor_deserializeOpGetPlanEvaluationStatus) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()

	if err != nil {
		return out, metadata, err
	}

	resp, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", out.RawResponse)
	}

	if resp.Header.Get("smithy-protocol") != "rpc-v2-cbor" {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf(
				"unexpected smithy-protocol response header '%s' (HTTP status: %s)",
				resp.Header.Get("smithy-protocol"),
				resp.Status,
			),
		}
	}

	if resp.StatusCode != 200 {
		return out, metadata, rpc2_deserializeOpErrorGetPlanEvaluationStatus(resp)
	}

	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return out, metadata, err
	}

	if len(payload) == 0 {
		out.Result = &GetPlanEvaluationStatusOutput{}
		return out, metadata, nil
	}

	cv, err := smithycbor.Decode(payload)
	if err != nil {
		return out, metadata, err
	}

	output, err := deserializeCBOR_GetPlanEvaluationStatusOutput(cv)
	if err != nil {
		return out, metadata, err
	}

	out.Result = output

	return out, metadata, nil
}

type smithyRpcv2cbor_deserializeOpGetPlanExecution struct {
}

func (*smithyRpcv2cbor_deserializeOpGetPlanExecution) ID() string {
	return "OperationDeserializer"
}

func (m *smithyRpcv2cbor_deserializeOpGetPlanExecution) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()

	if err != nil {
		return out, metadata, err
	}

	resp, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", out.RawResponse)
	}

	if resp.Header.Get("smithy-protocol") != "rpc-v2-cbor" {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf(
				"unexpected smithy-protocol response header '%s' (HTTP status: %s)",
				resp.Header.Get("smithy-protocol"),
				resp.Status,
			),
		}
	}

	if resp.StatusCode != 200 {
		return out, metadata, rpc2_deserializeOpErrorGetPlanExecution(resp)
	}

	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return out, metadata, err
	}

	if len(payload) == 0 {
		out.Result = &GetPlanExecutionOutput{}
		return out, metadata, nil
	}

	cv, err := smithycbor.Decode(payload)
	if err != nil {
		return out, metadata, err
	}

	output, err := deserializeCBOR_GetPlanExecutionOutput(cv)
	if err != nil {
		return out, metadata, err
	}

	out.Result = output

	return out, metadata, nil
}

type smithyRpcv2cbor_deserializeOpGetPlanInRegion struct {
}

func (*smithyRpcv2cbor_deserializeOpGetPlanInRegion) ID() string {
	return "OperationDeserializer"
}

func (m *smithyRpcv2cbor_deserializeOpGetPlanInRegion) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()

	if err != nil {
		return out, metadata, err
	}

	resp, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", out.RawResponse)
	}

	if resp.Header.Get("smithy-protocol") != "rpc-v2-cbor" {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf(
				"unexpected smithy-protocol response header '%s' (HTTP status: %s)",
				resp.Header.Get("smithy-protocol"),
				resp.Status,
			),
		}
	}

	if resp.StatusCode != 200 {
		return out, metadata, rpc2_deserializeOpErrorGetPlanInRegion(resp)
	}

	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return out, metadata, err
	}

	if len(payload) == 0 {
		out.Result = &GetPlanInRegionOutput{}
		return out, metadata, nil
	}

	cv, err := smithycbor.Decode(payload)
	if err != nil {
		return out, metadata, err
	}

	output, err := deserializeCBOR_GetPlanInRegionOutput(cv)
	if err != nil {
		return out, metadata, err
	}

	out.Result = output

	return out, metadata, nil
}

type smithyRpcv2cbor_deserializeOpListPlanExecutionEvents struct {
}

func (*smithyRpcv2cbor_deserializeOpListPlanExecutionEvents) ID() string {
	return "OperationDeserializer"
}

func (m *smithyRpcv2cbor_deserializeOpListPlanExecutionEvents) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()

	if err != nil {
		return out, metadata, err
	}

	resp, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", out.RawResponse)
	}

	if resp.Header.Get("smithy-protocol") != "rpc-v2-cbor" {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf(
				"unexpected smithy-protocol response header '%s' (HTTP status: %s)",
				resp.Header.Get("smithy-protocol"),
				resp.Status,
			),
		}
	}

	if resp.StatusCode != 200 {
		return out, metadata, rpc2_deserializeOpErrorListPlanExecutionEvents(resp)
	}

	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return out, metadata, err
	}

	if len(payload) == 0 {
		out.Result = &ListPlanExecutionEventsOutput{}
		return out, metadata, nil
	}

	cv, err := smithycbor.Decode(payload)
	if err != nil {
		return out, metadata, err
	}

	output, err := deserializeCBOR_ListPlanExecutionEventsOutput(cv)
	if err != nil {
		return out, metadata, err
	}

	out.Result = output

	return out, metadata, nil
}

type smithyRpcv2cbor_deserializeOpListPlanExecutions struct {
}

func (*smithyRpcv2cbor_deserializeOpListPlanExecutions) ID() string {
	return "OperationDeserializer"
}

func (m *smithyRpcv2cbor_deserializeOpListPlanExecutions) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()

	if err != nil {
		return out, metadata, err
	}

	resp, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", out.RawResponse)
	}

	if resp.Header.Get("smithy-protocol") != "rpc-v2-cbor" {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf(
				"unexpected smithy-protocol response header '%s' (HTTP status: %s)",
				resp.Header.Get("smithy-protocol"),
				resp.Status,
			),
		}
	}

	if resp.StatusCode != 200 {
		return out, metadata, rpc2_deserializeOpErrorListPlanExecutions(resp)
	}

	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return out, metadata, err
	}

	if len(payload) == 0 {
		out.Result = &ListPlanExecutionsOutput{}
		return out, metadata, nil
	}

	cv, err := smithycbor.Decode(payload)
	if err != nil {
		return out, metadata, err
	}

	output, err := deserializeCBOR_ListPlanExecutionsOutput(cv)
	if err != nil {
		return out, metadata, err
	}

	out.Result = output

	return out, metadata, nil
}

type smithyRpcv2cbor_deserializeOpListPlans struct {
}

func (*smithyRpcv2cbor_deserializeOpListPlans) ID() string {
	return "OperationDeserializer"
}

func (m *smithyRpcv2cbor_deserializeOpListPlans) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()

	if err != nil {
		return out, metadata, err
	}

	resp, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", out.RawResponse)
	}

	if resp.Header.Get("smithy-protocol") != "rpc-v2-cbor" {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf(
				"unexpected smithy-protocol response header '%s' (HTTP status: %s)",
				resp.Header.Get("smithy-protocol"),
				resp.Status,
			),
		}
	}

	if resp.StatusCode != 200 {
		return out, metadata, rpc2_deserializeOpErrorListPlans(resp)
	}

	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return out, metadata, err
	}

	if len(payload) == 0 {
		out.Result = &ListPlansOutput{}
		return out, metadata, nil
	}

	cv, err := smithycbor.Decode(payload)
	if err != nil {
		return out, metadata, err
	}

	output, err := deserializeCBOR_ListPlansOutput(cv)
	if err != nil {
		return out, metadata, err
	}

	out.Result = output

	return out, metadata, nil
}

type smithyRpcv2cbor_deserializeOpListPlansInRegion struct {
}

func (*smithyRpcv2cbor_deserializeOpListPlansInRegion) ID() string {
	return "OperationDeserializer"
}

func (m *smithyRpcv2cbor_deserializeOpListPlansInRegion) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()

	if err != nil {
		return out, metadata, err
	}

	resp, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", out.RawResponse)
	}

	if resp.Header.Get("smithy-protocol") != "rpc-v2-cbor" {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf(
				"unexpected smithy-protocol response header '%s' (HTTP status: %s)",
				resp.Header.Get("smithy-protocol"),
				resp.Status,
			),
		}
	}

	if resp.StatusCode != 200 {
		return out, metadata, rpc2_deserializeOpErrorListPlansInRegion(resp)
	}

	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return out, metadata, err
	}

	if len(payload) == 0 {
		out.Result = &ListPlansInRegionOutput{}
		return out, metadata, nil
	}

	cv, err := smithycbor.Decode(payload)
	if err != nil {
		return out, metadata, err
	}

	output, err := deserializeCBOR_ListPlansInRegionOutput(cv)
	if err != nil {
		return out, metadata, err
	}

	out.Result = output

	return out, metadata, nil
}

type smithyRpcv2cbor_deserializeOpListRoute53HealthChecks struct {
}

func (*smithyRpcv2cbor_deserializeOpListRoute53HealthChecks) ID() string {
	return "OperationDeserializer"
}

func (m *smithyRpcv2cbor_deserializeOpListRoute53HealthChecks) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()

	if err != nil {
		return out, metadata, err
	}

	resp, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", out.RawResponse)
	}

	if resp.Header.Get("smithy-protocol") != "rpc-v2-cbor" {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf(
				"unexpected smithy-protocol response header '%s' (HTTP status: %s)",
				resp.Header.Get("smithy-protocol"),
				resp.Status,
			),
		}
	}

	if resp.StatusCode != 200 {
		return out, metadata, rpc2_deserializeOpErrorListRoute53HealthChecks(resp)
	}

	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return out, metadata, err
	}

	if len(payload) == 0 {
		out.Result = &ListRoute53HealthChecksOutput{}
		return out, metadata, nil
	}

	cv, err := smithycbor.Decode(payload)
	if err != nil {
		return out, metadata, err
	}

	output, err := deserializeCBOR_ListRoute53HealthChecksOutput(cv)
	if err != nil {
		return out, metadata, err
	}

	out.Result = output

	return out, metadata, nil
}

type smithyRpcv2cbor_deserializeOpListTagsForResource struct {
}

func (*smithyRpcv2cbor_deserializeOpListTagsForResource) ID() string {
	return "OperationDeserializer"
}

func (m *smithyRpcv2cbor_deserializeOpListTagsForResource) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()

	if err != nil {
		return out, metadata, err
	}

	resp, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", out.RawResponse)
	}

	if resp.Header.Get("smithy-protocol") != "rpc-v2-cbor" {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf(
				"unexpected smithy-protocol response header '%s' (HTTP status: %s)",
				resp.Header.Get("smithy-protocol"),
				resp.Status,
			),
		}
	}

	if resp.StatusCode != 200 {
		return out, metadata, rpc2_deserializeOpErrorListTagsForResource(resp)
	}

	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return out, metadata, err
	}

	if len(payload) == 0 {
		out.Result = &ListTagsForResourceOutput{}
		return out, metadata, nil
	}

	cv, err := smithycbor.Decode(payload)
	if err != nil {
		return out, metadata, err
	}

	output, err := deserializeCBOR_ListTagsForResourceOutput(cv)
	if err != nil {
		return out, metadata, err
	}

	out.Result = output

	return out, metadata, nil
}

type smithyRpcv2cbor_deserializeOpStartPlanExecution struct {
}

func (*smithyRpcv2cbor_deserializeOpStartPlanExecution) ID() string {
	return "OperationDeserializer"
}

func (m *smithyRpcv2cbor_deserializeOpStartPlanExecution) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()

	if err != nil {
		return out, metadata, err
	}

	resp, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", out.RawResponse)
	}

	if resp.Header.Get("smithy-protocol") != "rpc-v2-cbor" {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf(
				"unexpected smithy-protocol response header '%s' (HTTP status: %s)",
				resp.Header.Get("smithy-protocol"),
				resp.Status,
			),
		}
	}

	if resp.StatusCode != 200 {
		return out, metadata, rpc2_deserializeOpErrorStartPlanExecution(resp)
	}

	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return out, metadata, err
	}

	if len(payload) == 0 {
		out.Result = &StartPlanExecutionOutput{}
		return out, metadata, nil
	}

	cv, err := smithycbor.Decode(payload)
	if err != nil {
		return out, metadata, err
	}

	output, err := deserializeCBOR_StartPlanExecutionOutput(cv)
	if err != nil {
		return out, metadata, err
	}

	out.Result = output

	return out, metadata, nil
}

type smithyRpcv2cbor_deserializeOpTagResource struct {
}

func (*smithyRpcv2cbor_deserializeOpTagResource) ID() string {
	return "OperationDeserializer"
}

func (m *smithyRpcv2cbor_deserializeOpTagResource) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()

	if err != nil {
		return out, metadata, err
	}

	resp, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", out.RawResponse)
	}

	if resp.Header.Get("smithy-protocol") != "rpc-v2-cbor" {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf(
				"unexpected smithy-protocol response header '%s' (HTTP status: %s)",
				resp.Header.Get("smithy-protocol"),
				resp.Status,
			),
		}
	}

	if resp.StatusCode != 200 {
		return out, metadata, rpc2_deserializeOpErrorTagResource(resp)
	}

	if _, err = io.Copy(ioutil.Discard, resp.Body); err != nil {
		return out, metadata, fmt.Errorf("discard response body: %w", err)
	}

	out.Result = &TagResourceOutput{}

	return out, metadata, nil
}

type smithyRpcv2cbor_deserializeOpUntagResource struct {
}

func (*smithyRpcv2cbor_deserializeOpUntagResource) ID() string {
	return "OperationDeserializer"
}

func (m *smithyRpcv2cbor_deserializeOpUntagResource) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()

	if err != nil {
		return out, metadata, err
	}

	resp, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", out.RawResponse)
	}

	if resp.Header.Get("smithy-protocol") != "rpc-v2-cbor" {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf(
				"unexpected smithy-protocol response header '%s' (HTTP status: %s)",
				resp.Header.Get("smithy-protocol"),
				resp.Status,
			),
		}
	}

	if resp.StatusCode != 200 {
		return out, metadata, rpc2_deserializeOpErrorUntagResource(resp)
	}

	if _, err = io.Copy(ioutil.Discard, resp.Body); err != nil {
		return out, metadata, fmt.Errorf("discard response body: %w", err)
	}

	out.Result = &UntagResourceOutput{}

	return out, metadata, nil
}

type smithyRpcv2cbor_deserializeOpUpdatePlan struct {
}

func (*smithyRpcv2cbor_deserializeOpUpdatePlan) ID() string {
	return "OperationDeserializer"
}

func (m *smithyRpcv2cbor_deserializeOpUpdatePlan) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()

	if err != nil {
		return out, metadata, err
	}

	resp, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", out.RawResponse)
	}

	if resp.Header.Get("smithy-protocol") != "rpc-v2-cbor" {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf(
				"unexpected smithy-protocol response header '%s' (HTTP status: %s)",
				resp.Header.Get("smithy-protocol"),
				resp.Status,
			),
		}
	}

	if resp.StatusCode != 200 {
		return out, metadata, rpc2_deserializeOpErrorUpdatePlan(resp)
	}

	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return out, metadata, err
	}

	if len(payload) == 0 {
		out.Result = &UpdatePlanOutput{}
		return out, metadata, nil
	}

	cv, err := smithycbor.Decode(payload)
	if err != nil {
		return out, metadata, err
	}

	output, err := deserializeCBOR_UpdatePlanOutput(cv)
	if err != nil {
		return out, metadata, err
	}

	out.Result = output

	return out, metadata, nil
}

type smithyRpcv2cbor_deserializeOpUpdatePlanExecution struct {
}

func (*smithyRpcv2cbor_deserializeOpUpdatePlanExecution) ID() string {
	return "OperationDeserializer"
}

func (m *smithyRpcv2cbor_deserializeOpUpdatePlanExecution) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()

	if err != nil {
		return out, metadata, err
	}

	resp, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", out.RawResponse)
	}

	if resp.Header.Get("smithy-protocol") != "rpc-v2-cbor" {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf(
				"unexpected smithy-protocol response header '%s' (HTTP status: %s)",
				resp.Header.Get("smithy-protocol"),
				resp.Status,
			),
		}
	}

	if resp.StatusCode != 200 {
		return out, metadata, rpc2_deserializeOpErrorUpdatePlanExecution(resp)
	}

	if _, err = io.Copy(ioutil.Discard, resp.Body); err != nil {
		return out, metadata, fmt.Errorf("discard response body: %w", err)
	}

	out.Result = &UpdatePlanExecutionOutput{}

	return out, metadata, nil
}

type smithyRpcv2cbor_deserializeOpUpdatePlanExecutionStep struct {
}

func (*smithyRpcv2cbor_deserializeOpUpdatePlanExecutionStep) ID() string {
	return "OperationDeserializer"
}

func (m *smithyRpcv2cbor_deserializeOpUpdatePlanExecutionStep) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)

	_, span := tracing.StartSpan(ctx, "OperationDeserializer")
	endTimer := startMetricTimer(ctx, "client.call.deserialization_duration")
	defer endTimer()
	defer span.End()

	if err != nil {
		return out, metadata, err
	}

	resp, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", out.RawResponse)
	}

	if resp.Header.Get("smithy-protocol") != "rpc-v2-cbor" {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf(
				"unexpected smithy-protocol response header '%s' (HTTP status: %s)",
				resp.Header.Get("smithy-protocol"),
				resp.Status,
			),
		}
	}

	if resp.StatusCode != 200 {
		return out, metadata, rpc2_deserializeOpErrorUpdatePlanExecutionStep(resp)
	}

	if _, err = io.Copy(ioutil.Discard, resp.Body); err != nil {
		return out, metadata, fmt.Errorf("discard response body: %w", err)
	}

	out.Result = &UpdatePlanExecutionStepOutput{}

	return out, metadata, nil
}
func deserializeCBOR_AbbreviatedExecution(v smithycbor.Value) (*types.AbbreviatedExecution, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.AbbreviatedExecution{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "planArn" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.PlanArn = ptr.String(dv)
		}

		if key == "executionId" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.ExecutionId = ptr.String(dv)
		}

		if key == "version" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Version = ptr.String(dv)
		}

		if key == "updatedAt" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Time(sv)
			if err != nil {
				return nil, err
			}
			ds.UpdatedAt = ptr.Time(dv)
		}

		if key == "comment" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Comment = ptr.String(dv)
		}

		if key == "startTime" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Time(sv)
			if err != nil {
				return nil, err
			}
			ds.StartTime = ptr.Time(dv)
		}

		if key == "endTime" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Time(sv)
			if err != nil {
				return nil, err
			}
			ds.EndTime = ptr.Time(dv)
		}

		if key == "mode" {

			dv, err := deserializeCBOR_ExecutionMode(sv)
			if err != nil {
				return nil, err
			}
			ds.Mode = dv
		}

		if key == "executionState" {

			dv, err := deserializeCBOR_ExecutionState(sv)
			if err != nil {
				return nil, err
			}
			ds.ExecutionState = dv
		}

		if key == "executionAction" {

			dv, err := deserializeCBOR_ExecutionAction(sv)
			if err != nil {
				return nil, err
			}
			ds.ExecutionAction = dv
		}

		if key == "executionRegion" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.ExecutionRegion = ptr.String(dv)
		}

		if key == "actualRecoveryTime" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.ActualRecoveryTime = ptr.String(dv)
		}
	}
	return ds, nil
}

func deserializeCBOR_AbbreviatedExecutionsList(v smithycbor.Value) ([]types.AbbreviatedExecution, error) {
	av, ok := v.(smithycbor.List)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	var dl []types.AbbreviatedExecution
	for _, si := range av {

		di, err := deserializeCBOR_AbbreviatedExecution(si)
		if err != nil {
			return nil, err
		}
		dl = append(dl, *di)
	}
	return dl, nil
}

func deserializeCBOR_AbbreviatedPlan(v smithycbor.Value) (*types.AbbreviatedPlan, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.AbbreviatedPlan{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "arn" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Arn = ptr.String(dv)
		}

		if key == "owner" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Owner = ptr.String(dv)
		}

		if key == "name" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Name = ptr.String(dv)
		}

		if key == "regions" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_RegionList(sv)
			if err != nil {
				return nil, err
			}
			ds.Regions = dv
		}

		if key == "recoveryApproach" {

			dv, err := deserializeCBOR_RecoveryApproach(sv)
			if err != nil {
				return nil, err
			}
			ds.RecoveryApproach = dv
		}

		if key == "primaryRegion" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.PrimaryRegion = ptr.String(dv)
		}

		if key == "version" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Version = ptr.String(dv)
		}

		if key == "updatedAt" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Time(sv)
			if err != nil {
				return nil, err
			}
			ds.UpdatedAt = ptr.Time(dv)
		}

		if key == "description" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Description = ptr.String(dv)
		}

		if key == "executionRole" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.ExecutionRole = ptr.String(dv)
		}

		if key == "activePlanExecution" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.ActivePlanExecution = ptr.String(dv)
		}

		if key == "recoveryTimeObjectiveMinutes" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Int32(sv)
			if err != nil {
				return nil, err
			}
			ds.RecoveryTimeObjectiveMinutes = ptr.Int32(dv)
		}
	}
	return ds, nil
}

func deserializeCBOR_AccessDeniedException(v smithycbor.Value) (*types.AccessDeniedException, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.AccessDeniedException{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "message" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Message = ptr.String(dv)
		}
	}
	return ds, nil
}

func deserializeCBOR_AlarmCondition(v smithycbor.Value) (types.AlarmCondition, error) {
	av, ok := v.(smithycbor.String)
	if !ok {
		return types.AlarmCondition(""), fmt.Errorf("unexpected value type %T", v)
	}
	return types.AlarmCondition(av), nil
}

func deserializeCBOR_AlarmType(v smithycbor.Value) (types.AlarmType, error) {
	av, ok := v.(smithycbor.String)
	if !ok {
		return types.AlarmType(""), fmt.Errorf("unexpected value type %T", v)
	}
	return types.AlarmType(av), nil
}

func deserializeCBOR_ArcRoutingControlConfiguration(v smithycbor.Value) (*types.ArcRoutingControlConfiguration, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.ArcRoutingControlConfiguration{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "timeoutMinutes" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Int32(sv)
			if err != nil {
				return nil, err
			}
			ds.TimeoutMinutes = ptr.Int32(dv)
		}

		if key == "crossAccountRole" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.CrossAccountRole = ptr.String(dv)
		}

		if key == "externalId" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.ExternalId = ptr.String(dv)
		}

		if key == "regionAndRoutingControls" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_RegionAndRoutingControls(sv)
			if err != nil {
				return nil, err
			}
			ds.RegionAndRoutingControls = dv
		}
	}
	return ds, nil
}

func deserializeCBOR_ArcRoutingControlState(v smithycbor.Value) (*types.ArcRoutingControlState, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.ArcRoutingControlState{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "routingControlArn" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.RoutingControlArn = ptr.String(dv)
		}

		if key == "state" {

			dv, err := deserializeCBOR_RoutingControlStateChange(sv)
			if err != nil {
				return nil, err
			}
			ds.State = dv
		}
	}
	return ds, nil
}

func deserializeCBOR_ArcRoutingControlStates(v smithycbor.Value) ([]types.ArcRoutingControlState, error) {
	av, ok := v.(smithycbor.List)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	var dl []types.ArcRoutingControlState
	for _, si := range av {

		di, err := deserializeCBOR_ArcRoutingControlState(si)
		if err != nil {
			return nil, err
		}
		dl = append(dl, *di)
	}
	return dl, nil
}

func deserializeCBOR_Asg(v smithycbor.Value) (*types.Asg, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.Asg{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "crossAccountRole" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.CrossAccountRole = ptr.String(dv)
		}

		if key == "externalId" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.ExternalId = ptr.String(dv)
		}

		if key == "arn" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Arn = ptr.String(dv)
		}
	}
	return ds, nil
}

func deserializeCBOR_AsgList(v smithycbor.Value) ([]types.Asg, error) {
	av, ok := v.(smithycbor.List)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	var dl []types.Asg
	for _, si := range av {

		di, err := deserializeCBOR_Asg(si)
		if err != nil {
			return nil, err
		}
		dl = append(dl, *di)
	}
	return dl, nil
}

func deserializeCBOR_AssociatedAlarm(v smithycbor.Value) (*types.AssociatedAlarm, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.AssociatedAlarm{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "crossAccountRole" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.CrossAccountRole = ptr.String(dv)
		}

		if key == "externalId" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.ExternalId = ptr.String(dv)
		}

		if key == "resourceIdentifier" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.ResourceIdentifier = ptr.String(dv)
		}

		if key == "alarmType" {

			dv, err := deserializeCBOR_AlarmType(sv)
			if err != nil {
				return nil, err
			}
			ds.AlarmType = dv
		}
	}
	return ds, nil
}

func deserializeCBOR_AssociatedAlarmMap(v smithycbor.Value) (map[string]types.AssociatedAlarm, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	dm := map[string]types.AssociatedAlarm{}
	for key, sv := range av {

		dv, err := deserializeCBOR_AssociatedAlarm(sv)
		if err != nil {
			return nil, err
		}
		dm[key] = *dv
	}
	return dm, nil
}

func deserializeCBOR_AuroraClusterArns(v smithycbor.Value) ([]string, error) {
	av, ok := v.(smithycbor.List)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	var dl []string
	for _, si := range av {

		di, err := deserializeCBOR_String(si)
		if err != nil {
			return nil, err
		}
		dl = append(dl, di)
	}
	return dl, nil
}

func deserializeCBOR_CustomActionLambdaConfiguration(v smithycbor.Value) (*types.CustomActionLambdaConfiguration, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.CustomActionLambdaConfiguration{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "timeoutMinutes" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Int32(sv)
			if err != nil {
				return nil, err
			}
			ds.TimeoutMinutes = ptr.Int32(dv)
		}

		if key == "lambdas" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_LambdaList(sv)
			if err != nil {
				return nil, err
			}
			ds.Lambdas = dv
		}

		if key == "retryIntervalMinutes" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Float32(sv)
			if err != nil {
				return nil, err
			}
			ds.RetryIntervalMinutes = ptr.Float32(dv)
		}

		if key == "regionToRun" {

			dv, err := deserializeCBOR_RegionToRunIn(sv)
			if err != nil {
				return nil, err
			}
			ds.RegionToRun = dv
		}

		if key == "ungraceful" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_LambdaUngraceful(sv)
			if err != nil {
				return nil, err
			}
			ds.Ungraceful = dv
		}
	}
	return ds, nil
}

func deserializeCBOR_Ec2AsgCapacityIncreaseConfiguration(v smithycbor.Value) (*types.Ec2AsgCapacityIncreaseConfiguration, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.Ec2AsgCapacityIncreaseConfiguration{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "timeoutMinutes" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Int32(sv)
			if err != nil {
				return nil, err
			}
			ds.TimeoutMinutes = ptr.Int32(dv)
		}

		if key == "asgs" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_AsgList(sv)
			if err != nil {
				return nil, err
			}
			ds.Asgs = dv
		}

		if key == "ungraceful" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Ec2Ungraceful(sv)
			if err != nil {
				return nil, err
			}
			ds.Ungraceful = dv
		}

		if key == "targetPercent" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Int32(sv)
			if err != nil {
				return nil, err
			}
			ds.TargetPercent = ptr.Int32(dv)
		}

		if key == "capacityMonitoringApproach" {

			dv, err := deserializeCBOR_Ec2AsgCapacityMonitoringApproach(sv)
			if err != nil {
				return nil, err
			}
			ds.CapacityMonitoringApproach = dv
		}
	}
	return ds, nil
}

func deserializeCBOR_Ec2AsgCapacityMonitoringApproach(v smithycbor.Value) (types.Ec2AsgCapacityMonitoringApproach, error) {
	av, ok := v.(smithycbor.String)
	if !ok {
		return types.Ec2AsgCapacityMonitoringApproach(""), fmt.Errorf("unexpected value type %T", v)
	}
	return types.Ec2AsgCapacityMonitoringApproach(av), nil
}

func deserializeCBOR_Ec2Ungraceful(v smithycbor.Value) (*types.Ec2Ungraceful, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.Ec2Ungraceful{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "minimumSuccessPercentage" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Int32(sv)
			if err != nil {
				return nil, err
			}
			ds.MinimumSuccessPercentage = ptr.Int32(dv)
		}
	}
	return ds, nil
}

func deserializeCBOR_EcsCapacityIncreaseConfiguration(v smithycbor.Value) (*types.EcsCapacityIncreaseConfiguration, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.EcsCapacityIncreaseConfiguration{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "timeoutMinutes" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Int32(sv)
			if err != nil {
				return nil, err
			}
			ds.TimeoutMinutes = ptr.Int32(dv)
		}

		if key == "services" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_ServiceList(sv)
			if err != nil {
				return nil, err
			}
			ds.Services = dv
		}

		if key == "ungraceful" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_EcsUngraceful(sv)
			if err != nil {
				return nil, err
			}
			ds.Ungraceful = dv
		}

		if key == "targetPercent" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Int32(sv)
			if err != nil {
				return nil, err
			}
			ds.TargetPercent = ptr.Int32(dv)
		}

		if key == "capacityMonitoringApproach" {

			dv, err := deserializeCBOR_EcsCapacityMonitoringApproach(sv)
			if err != nil {
				return nil, err
			}
			ds.CapacityMonitoringApproach = dv
		}
	}
	return ds, nil
}

func deserializeCBOR_EcsCapacityMonitoringApproach(v smithycbor.Value) (types.EcsCapacityMonitoringApproach, error) {
	av, ok := v.(smithycbor.String)
	if !ok {
		return types.EcsCapacityMonitoringApproach(""), fmt.Errorf("unexpected value type %T", v)
	}
	return types.EcsCapacityMonitoringApproach(av), nil
}

func deserializeCBOR_EcsUngraceful(v smithycbor.Value) (*types.EcsUngraceful, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.EcsUngraceful{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "minimumSuccessPercentage" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Int32(sv)
			if err != nil {
				return nil, err
			}
			ds.MinimumSuccessPercentage = ptr.Int32(dv)
		}
	}
	return ds, nil
}

func deserializeCBOR_EksCapacityMonitoringApproach(v smithycbor.Value) (types.EksCapacityMonitoringApproach, error) {
	av, ok := v.(smithycbor.String)
	if !ok {
		return types.EksCapacityMonitoringApproach(""), fmt.Errorf("unexpected value type %T", v)
	}
	return types.EksCapacityMonitoringApproach(av), nil
}

func deserializeCBOR_EksCluster(v smithycbor.Value) (*types.EksCluster, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.EksCluster{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "crossAccountRole" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.CrossAccountRole = ptr.String(dv)
		}

		if key == "externalId" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.ExternalId = ptr.String(dv)
		}

		if key == "clusterArn" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.ClusterArn = ptr.String(dv)
		}
	}
	return ds, nil
}

func deserializeCBOR_EksClusters(v smithycbor.Value) ([]types.EksCluster, error) {
	av, ok := v.(smithycbor.List)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	var dl []types.EksCluster
	for _, si := range av {

		di, err := deserializeCBOR_EksCluster(si)
		if err != nil {
			return nil, err
		}
		dl = append(dl, *di)
	}
	return dl, nil
}

func deserializeCBOR_EksResourceScalingConfiguration(v smithycbor.Value) (*types.EksResourceScalingConfiguration, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.EksResourceScalingConfiguration{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "timeoutMinutes" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Int32(sv)
			if err != nil {
				return nil, err
			}
			ds.TimeoutMinutes = ptr.Int32(dv)
		}

		if key == "kubernetesResourceType" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_KubernetesResourceType(sv)
			if err != nil {
				return nil, err
			}
			ds.KubernetesResourceType = dv
		}

		if key == "scalingResources" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_KubernetesScalingApps(sv)
			if err != nil {
				return nil, err
			}
			ds.ScalingResources = dv
		}

		if key == "eksClusters" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_EksClusters(sv)
			if err != nil {
				return nil, err
			}
			ds.EksClusters = dv
		}

		if key == "ungraceful" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_EksResourceScalingUngraceful(sv)
			if err != nil {
				return nil, err
			}
			ds.Ungraceful = dv
		}

		if key == "targetPercent" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Int32(sv)
			if err != nil {
				return nil, err
			}
			ds.TargetPercent = ptr.Int32(dv)
		}

		if key == "capacityMonitoringApproach" {

			dv, err := deserializeCBOR_EksCapacityMonitoringApproach(sv)
			if err != nil {
				return nil, err
			}
			ds.CapacityMonitoringApproach = dv
		}
	}
	return ds, nil
}

func deserializeCBOR_EksResourceScalingUngraceful(v smithycbor.Value) (*types.EksResourceScalingUngraceful, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.EksResourceScalingUngraceful{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "minimumSuccessPercentage" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Int32(sv)
			if err != nil {
				return nil, err
			}
			ds.MinimumSuccessPercentage = ptr.Int32(dv)
		}
	}
	return ds, nil
}

func deserializeCBOR_EvaluationStatus(v smithycbor.Value) (types.EvaluationStatus, error) {
	av, ok := v.(smithycbor.String)
	if !ok {
		return types.EvaluationStatus(""), fmt.Errorf("unexpected value type %T", v)
	}
	return types.EvaluationStatus(av), nil
}

func deserializeCBOR_ExecutionAction(v smithycbor.Value) (types.ExecutionAction, error) {
	av, ok := v.(smithycbor.String)
	if !ok {
		return types.ExecutionAction(""), fmt.Errorf("unexpected value type %T", v)
	}
	return types.ExecutionAction(av), nil
}

func deserializeCBOR_ExecutionApprovalConfiguration(v smithycbor.Value) (*types.ExecutionApprovalConfiguration, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.ExecutionApprovalConfiguration{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "timeoutMinutes" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Int32(sv)
			if err != nil {
				return nil, err
			}
			ds.TimeoutMinutes = ptr.Int32(dv)
		}

		if key == "approvalRole" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.ApprovalRole = ptr.String(dv)
		}
	}
	return ds, nil
}

func deserializeCBOR_ExecutionBlockConfiguration(v smithycbor.Value) (types.ExecutionBlockConfiguration, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	for key, sv := range av {
		if key == "customActionLambdaConfig" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_CustomActionLambdaConfiguration(sv)
			if err != nil {
				return nil, err
			}
			return &types.ExecutionBlockConfigurationMemberCustomActionLambdaConfig{Value: *dv}, nil
		}

		if key == "ec2AsgCapacityIncreaseConfig" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Ec2AsgCapacityIncreaseConfiguration(sv)
			if err != nil {
				return nil, err
			}
			return &types.ExecutionBlockConfigurationMemberEc2AsgCapacityIncreaseConfig{Value: *dv}, nil
		}

		if key == "executionApprovalConfig" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_ExecutionApprovalConfiguration(sv)
			if err != nil {
				return nil, err
			}
			return &types.ExecutionBlockConfigurationMemberExecutionApprovalConfig{Value: *dv}, nil
		}

		if key == "arcRoutingControlConfig" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_ArcRoutingControlConfiguration(sv)
			if err != nil {
				return nil, err
			}
			return &types.ExecutionBlockConfigurationMemberArcRoutingControlConfig{Value: *dv}, nil
		}

		if key == "globalAuroraConfig" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_GlobalAuroraConfiguration(sv)
			if err != nil {
				return nil, err
			}
			return &types.ExecutionBlockConfigurationMemberGlobalAuroraConfig{Value: *dv}, nil
		}

		if key == "parallelConfig" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_ParallelExecutionBlockConfiguration(sv)
			if err != nil {
				return nil, err
			}
			return &types.ExecutionBlockConfigurationMemberParallelConfig{Value: *dv}, nil
		}

		if key == "regionSwitchPlanConfig" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_RegionSwitchPlanConfiguration(sv)
			if err != nil {
				return nil, err
			}
			return &types.ExecutionBlockConfigurationMemberRegionSwitchPlanConfig{Value: *dv}, nil
		}

		if key == "ecsCapacityIncreaseConfig" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_EcsCapacityIncreaseConfiguration(sv)
			if err != nil {
				return nil, err
			}
			return &types.ExecutionBlockConfigurationMemberEcsCapacityIncreaseConfig{Value: *dv}, nil
		}

		if key == "eksResourceScalingConfig" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_EksResourceScalingConfiguration(sv)
			if err != nil {
				return nil, err
			}
			return &types.ExecutionBlockConfigurationMemberEksResourceScalingConfig{Value: *dv}, nil
		}

		if key == "route53HealthCheckConfig" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Route53HealthCheckConfiguration(sv)
			if err != nil {
				return nil, err
			}
			return &types.ExecutionBlockConfigurationMemberRoute53HealthCheckConfig{Value: *dv}, nil
		}
	}
	return nil, fmt.Errorf("unrecognized variant")
}

func deserializeCBOR_ExecutionBlockType(v smithycbor.Value) (types.ExecutionBlockType, error) {
	av, ok := v.(smithycbor.String)
	if !ok {
		return types.ExecutionBlockType(""), fmt.Errorf("unexpected value type %T", v)
	}
	return types.ExecutionBlockType(av), nil
}

func deserializeCBOR_ExecutionEvent(v smithycbor.Value) (*types.ExecutionEvent, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.ExecutionEvent{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "timestamp" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Time(sv)
			if err != nil {
				return nil, err
			}
			ds.Timestamp = ptr.Time(dv)
		}

		if key == "type" {

			dv, err := deserializeCBOR_ExecutionEventType(sv)
			if err != nil {
				return nil, err
			}
			ds.Type = dv
		}

		if key == "stepName" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.StepName = ptr.String(dv)
		}

		if key == "executionBlockType" {

			dv, err := deserializeCBOR_ExecutionBlockType(sv)
			if err != nil {
				return nil, err
			}
			ds.ExecutionBlockType = dv
		}

		if key == "resources" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Resources(sv)
			if err != nil {
				return nil, err
			}
			ds.Resources = dv
		}

		if key == "error" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Error = ptr.String(dv)
		}

		if key == "description" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Description = ptr.String(dv)
		}

		if key == "eventId" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.EventId = ptr.String(dv)
		}

		if key == "previousEventId" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.PreviousEventId = ptr.String(dv)
		}
	}
	return ds, nil
}

func deserializeCBOR_ExecutionEventList(v smithycbor.Value) ([]types.ExecutionEvent, error) {
	av, ok := v.(smithycbor.List)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	var dl []types.ExecutionEvent
	for _, si := range av {

		di, err := deserializeCBOR_ExecutionEvent(si)
		if err != nil {
			return nil, err
		}
		dl = append(dl, *di)
	}
	return dl, nil
}

func deserializeCBOR_ExecutionEventType(v smithycbor.Value) (types.ExecutionEventType, error) {
	av, ok := v.(smithycbor.String)
	if !ok {
		return types.ExecutionEventType(""), fmt.Errorf("unexpected value type %T", v)
	}
	return types.ExecutionEventType(av), nil
}

func deserializeCBOR_ExecutionMode(v smithycbor.Value) (types.ExecutionMode, error) {
	av, ok := v.(smithycbor.String)
	if !ok {
		return types.ExecutionMode(""), fmt.Errorf("unexpected value type %T", v)
	}
	return types.ExecutionMode(av), nil
}

func deserializeCBOR_ExecutionState(v smithycbor.Value) (types.ExecutionState, error) {
	av, ok := v.(smithycbor.String)
	if !ok {
		return types.ExecutionState(""), fmt.Errorf("unexpected value type %T", v)
	}
	return types.ExecutionState(av), nil
}

func deserializeCBOR_GlobalAuroraConfiguration(v smithycbor.Value) (*types.GlobalAuroraConfiguration, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.GlobalAuroraConfiguration{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "timeoutMinutes" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Int32(sv)
			if err != nil {
				return nil, err
			}
			ds.TimeoutMinutes = ptr.Int32(dv)
		}

		if key == "crossAccountRole" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.CrossAccountRole = ptr.String(dv)
		}

		if key == "externalId" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.ExternalId = ptr.String(dv)
		}

		if key == "behavior" {

			dv, err := deserializeCBOR_GlobalAuroraDefaultBehavior(sv)
			if err != nil {
				return nil, err
			}
			ds.Behavior = dv
		}

		if key == "ungraceful" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_GlobalAuroraUngraceful(sv)
			if err != nil {
				return nil, err
			}
			ds.Ungraceful = dv
		}

		if key == "globalClusterIdentifier" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.GlobalClusterIdentifier = ptr.String(dv)
		}

		if key == "databaseClusterArns" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_AuroraClusterArns(sv)
			if err != nil {
				return nil, err
			}
			ds.DatabaseClusterArns = dv
		}
	}
	return ds, nil
}

func deserializeCBOR_GlobalAuroraDefaultBehavior(v smithycbor.Value) (types.GlobalAuroraDefaultBehavior, error) {
	av, ok := v.(smithycbor.String)
	if !ok {
		return types.GlobalAuroraDefaultBehavior(""), fmt.Errorf("unexpected value type %T", v)
	}
	return types.GlobalAuroraDefaultBehavior(av), nil
}

func deserializeCBOR_GlobalAuroraUngraceful(v smithycbor.Value) (*types.GlobalAuroraUngraceful, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.GlobalAuroraUngraceful{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "ungraceful" {

			dv, err := deserializeCBOR_GlobalAuroraUngracefulBehavior(sv)
			if err != nil {
				return nil, err
			}
			ds.Ungraceful = dv
		}
	}
	return ds, nil
}

func deserializeCBOR_GlobalAuroraUngracefulBehavior(v smithycbor.Value) (types.GlobalAuroraUngracefulBehavior, error) {
	av, ok := v.(smithycbor.String)
	if !ok {
		return types.GlobalAuroraUngracefulBehavior(""), fmt.Errorf("unexpected value type %T", v)
	}
	return types.GlobalAuroraUngracefulBehavior(av), nil
}

func deserializeCBOR_IllegalArgumentException(v smithycbor.Value) (*types.IllegalArgumentException, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.IllegalArgumentException{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "message" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Message = ptr.String(dv)
		}
	}
	return ds, nil
}

func deserializeCBOR_IllegalStateException(v smithycbor.Value) (*types.IllegalStateException, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.IllegalStateException{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "message" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Message = ptr.String(dv)
		}
	}
	return ds, nil
}

func deserializeCBOR_InternalServerException(v smithycbor.Value) (*types.InternalServerException, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.InternalServerException{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "message" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Message = ptr.String(dv)
		}
	}
	return ds, nil
}

func deserializeCBOR_KubernetesResourceType(v smithycbor.Value) (*types.KubernetesResourceType, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.KubernetesResourceType{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "apiVersion" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.ApiVersion = ptr.String(dv)
		}

		if key == "kind" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Kind = ptr.String(dv)
		}
	}
	return ds, nil
}

func deserializeCBOR_KubernetesScalingApplication(v smithycbor.Value) (map[string]map[string]types.KubernetesScalingResource, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	dm := map[string]map[string]types.KubernetesScalingResource{}
	for key, sv := range av {
		if _, ok := sv.(*smithycbor.Nil); ok {
			dm[key] = nil
			continue
		}
		dv, err := deserializeCBOR_RegionalScalingResource(sv)
		if err != nil {
			return nil, err
		}
		dm[key] = dv
	}
	return dm, nil
}

func deserializeCBOR_KubernetesScalingApps(v smithycbor.Value) ([]map[string]map[string]types.KubernetesScalingResource, error) {
	av, ok := v.(smithycbor.List)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	var dl []map[string]map[string]types.KubernetesScalingResource
	for _, si := range av {
		if _, ok := si.(*smithycbor.Nil); ok {
			dl = append(dl, nil)
			continue
		}
		di, err := deserializeCBOR_KubernetesScalingApplication(si)
		if err != nil {
			return nil, err
		}
		dl = append(dl, di)
	}
	return dl, nil
}

func deserializeCBOR_KubernetesScalingResource(v smithycbor.Value) (*types.KubernetesScalingResource, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.KubernetesScalingResource{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "namespace" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Namespace = ptr.String(dv)
		}

		if key == "name" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Name = ptr.String(dv)
		}

		if key == "hpaName" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.HpaName = ptr.String(dv)
		}
	}
	return ds, nil
}

func deserializeCBOR_LambdaList(v smithycbor.Value) ([]types.Lambdas, error) {
	av, ok := v.(smithycbor.List)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	var dl []types.Lambdas
	for _, si := range av {

		di, err := deserializeCBOR_Lambdas(si)
		if err != nil {
			return nil, err
		}
		dl = append(dl, *di)
	}
	return dl, nil
}

func deserializeCBOR_Lambdas(v smithycbor.Value) (*types.Lambdas, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.Lambdas{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "crossAccountRole" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.CrossAccountRole = ptr.String(dv)
		}

		if key == "externalId" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.ExternalId = ptr.String(dv)
		}

		if key == "arn" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Arn = ptr.String(dv)
		}
	}
	return ds, nil
}

func deserializeCBOR_LambdaUngraceful(v smithycbor.Value) (*types.LambdaUngraceful, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.LambdaUngraceful{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "behavior" {

			dv, err := deserializeCBOR_LambdaUngracefulBehavior(sv)
			if err != nil {
				return nil, err
			}
			ds.Behavior = dv
		}
	}
	return ds, nil
}

func deserializeCBOR_LambdaUngracefulBehavior(v smithycbor.Value) (types.LambdaUngracefulBehavior, error) {
	av, ok := v.(smithycbor.String)
	if !ok {
		return types.LambdaUngracefulBehavior(""), fmt.Errorf("unexpected value type %T", v)
	}
	return types.LambdaUngracefulBehavior(av), nil
}

func deserializeCBOR_MinimalWorkflow(v smithycbor.Value) (*types.MinimalWorkflow, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.MinimalWorkflow{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "action" {

			dv, err := deserializeCBOR_ExecutionAction(sv)
			if err != nil {
				return nil, err
			}
			ds.Action = dv
		}

		if key == "name" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Name = ptr.String(dv)
		}
	}
	return ds, nil
}

func deserializeCBOR_ParallelExecutionBlockConfiguration(v smithycbor.Value) (*types.ParallelExecutionBlockConfiguration, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.ParallelExecutionBlockConfiguration{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "steps" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Steps(sv)
			if err != nil {
				return nil, err
			}
			ds.Steps = dv
		}
	}
	return ds, nil
}

func deserializeCBOR_Plan(v smithycbor.Value) (*types.Plan, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.Plan{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "arn" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Arn = ptr.String(dv)
		}

		if key == "description" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Description = ptr.String(dv)
		}

		if key == "workflows" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_WorkflowList(sv)
			if err != nil {
				return nil, err
			}
			ds.Workflows = dv
		}

		if key == "executionRole" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.ExecutionRole = ptr.String(dv)
		}

		if key == "recoveryTimeObjectiveMinutes" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Int32(sv)
			if err != nil {
				return nil, err
			}
			ds.RecoveryTimeObjectiveMinutes = ptr.Int32(dv)
		}

		if key == "associatedAlarms" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_AssociatedAlarmMap(sv)
			if err != nil {
				return nil, err
			}
			ds.AssociatedAlarms = dv
		}

		if key == "triggers" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_TriggerList(sv)
			if err != nil {
				return nil, err
			}
			ds.Triggers = dv
		}

		if key == "name" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Name = ptr.String(dv)
		}

		if key == "regions" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_RegionList(sv)
			if err != nil {
				return nil, err
			}
			ds.Regions = dv
		}

		if key == "recoveryApproach" {

			dv, err := deserializeCBOR_RecoveryApproach(sv)
			if err != nil {
				return nil, err
			}
			ds.RecoveryApproach = dv
		}

		if key == "primaryRegion" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.PrimaryRegion = ptr.String(dv)
		}

		if key == "owner" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Owner = ptr.String(dv)
		}

		if key == "version" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Version = ptr.String(dv)
		}

		if key == "updatedAt" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Time(sv)
			if err != nil {
				return nil, err
			}
			ds.UpdatedAt = ptr.Time(dv)
		}
	}
	return ds, nil
}

func deserializeCBOR_PlanList(v smithycbor.Value) ([]types.AbbreviatedPlan, error) {
	av, ok := v.(smithycbor.List)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	var dl []types.AbbreviatedPlan
	for _, si := range av {

		di, err := deserializeCBOR_AbbreviatedPlan(si)
		if err != nil {
			return nil, err
		}
		dl = append(dl, *di)
	}
	return dl, nil
}

func deserializeCBOR_PlanWarnings(v smithycbor.Value) ([]types.ResourceWarning, error) {
	av, ok := v.(smithycbor.List)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	var dl []types.ResourceWarning
	for _, si := range av {

		di, err := deserializeCBOR_ResourceWarning(si)
		if err != nil {
			return nil, err
		}
		dl = append(dl, *di)
	}
	return dl, nil
}

func deserializeCBOR_RecoveryApproach(v smithycbor.Value) (types.RecoveryApproach, error) {
	av, ok := v.(smithycbor.String)
	if !ok {
		return types.RecoveryApproach(""), fmt.Errorf("unexpected value type %T", v)
	}
	return types.RecoveryApproach(av), nil
}

func deserializeCBOR_RegionalScalingResource(v smithycbor.Value) (map[string]types.KubernetesScalingResource, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	dm := map[string]types.KubernetesScalingResource{}
	for key, sv := range av {

		dv, err := deserializeCBOR_KubernetesScalingResource(sv)
		if err != nil {
			return nil, err
		}
		dm[key] = *dv
	}
	return dm, nil
}

func deserializeCBOR_RegionAndRoutingControls(v smithycbor.Value) (map[string][]types.ArcRoutingControlState, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	dm := map[string][]types.ArcRoutingControlState{}
	for key, sv := range av {
		if _, ok := sv.(*smithycbor.Nil); ok {
			dm[key] = nil
			continue
		}
		dv, err := deserializeCBOR_ArcRoutingControlStates(sv)
		if err != nil {
			return nil, err
		}
		dm[key] = dv
	}
	return dm, nil
}

func deserializeCBOR_RegionList(v smithycbor.Value) ([]string, error) {
	av, ok := v.(smithycbor.List)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	var dl []string
	for _, si := range av {

		di, err := deserializeCBOR_String(si)
		if err != nil {
			return nil, err
		}
		dl = append(dl, di)
	}
	return dl, nil
}

func deserializeCBOR_RegionSwitchPlanConfiguration(v smithycbor.Value) (*types.RegionSwitchPlanConfiguration, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.RegionSwitchPlanConfiguration{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "crossAccountRole" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.CrossAccountRole = ptr.String(dv)
		}

		if key == "externalId" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.ExternalId = ptr.String(dv)
		}

		if key == "arn" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Arn = ptr.String(dv)
		}
	}
	return ds, nil
}

func deserializeCBOR_RegionToRunIn(v smithycbor.Value) (types.RegionToRunIn, error) {
	av, ok := v.(smithycbor.String)
	if !ok {
		return types.RegionToRunIn(""), fmt.Errorf("unexpected value type %T", v)
	}
	return types.RegionToRunIn(av), nil
}

func deserializeCBOR_ResourceNotFoundException(v smithycbor.Value) (*types.ResourceNotFoundException, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.ResourceNotFoundException{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "message" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Message = ptr.String(dv)
		}
	}
	return ds, nil
}

func deserializeCBOR_Resources(v smithycbor.Value) ([]string, error) {
	av, ok := v.(smithycbor.List)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	var dl []string
	for _, si := range av {

		di, err := deserializeCBOR_String(si)
		if err != nil {
			return nil, err
		}
		dl = append(dl, di)
	}
	return dl, nil
}

func deserializeCBOR_ResourceWarning(v smithycbor.Value) (*types.ResourceWarning, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.ResourceWarning{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "workflow" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_MinimalWorkflow(sv)
			if err != nil {
				return nil, err
			}
			ds.Workflow = dv
		}

		if key == "version" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Version = ptr.String(dv)
		}

		if key == "stepName" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.StepName = ptr.String(dv)
		}

		if key == "resourceArn" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.ResourceArn = ptr.String(dv)
		}

		if key == "warningStatus" {

			dv, err := deserializeCBOR_ResourceWarningStatus(sv)
			if err != nil {
				return nil, err
			}
			ds.WarningStatus = dv
		}

		if key == "warningUpdatedTime" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Time(sv)
			if err != nil {
				return nil, err
			}
			ds.WarningUpdatedTime = ptr.Time(dv)
		}

		if key == "warningMessage" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.WarningMessage = ptr.String(dv)
		}
	}
	return ds, nil
}

func deserializeCBOR_ResourceWarningStatus(v smithycbor.Value) (types.ResourceWarningStatus, error) {
	av, ok := v.(smithycbor.String)
	if !ok {
		return types.ResourceWarningStatus(""), fmt.Errorf("unexpected value type %T", v)
	}
	return types.ResourceWarningStatus(av), nil
}

func deserializeCBOR_Route53HealthCheck(v smithycbor.Value) (*types.Route53HealthCheck, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.Route53HealthCheck{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "hostedZoneId" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.HostedZoneId = ptr.String(dv)
		}

		if key == "recordName" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.RecordName = ptr.String(dv)
		}

		if key == "healthCheckId" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.HealthCheckId = ptr.String(dv)
		}

		if key == "region" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Region = ptr.String(dv)
		}
	}
	return ds, nil
}

func deserializeCBOR_Route53HealthCheckConfiguration(v smithycbor.Value) (*types.Route53HealthCheckConfiguration, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.Route53HealthCheckConfiguration{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "timeoutMinutes" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Int32(sv)
			if err != nil {
				return nil, err
			}
			ds.TimeoutMinutes = ptr.Int32(dv)
		}

		if key == "crossAccountRole" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.CrossAccountRole = ptr.String(dv)
		}

		if key == "externalId" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.ExternalId = ptr.String(dv)
		}

		if key == "hostedZoneId" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.HostedZoneId = ptr.String(dv)
		}

		if key == "recordName" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.RecordName = ptr.String(dv)
		}

		if key == "recordSets" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Route53ResourceRecordSetList(sv)
			if err != nil {
				return nil, err
			}
			ds.RecordSets = dv
		}
	}
	return ds, nil
}

func deserializeCBOR_Route53HealthCheckList(v smithycbor.Value) ([]types.Route53HealthCheck, error) {
	av, ok := v.(smithycbor.List)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	var dl []types.Route53HealthCheck
	for _, si := range av {

		di, err := deserializeCBOR_Route53HealthCheck(si)
		if err != nil {
			return nil, err
		}
		dl = append(dl, *di)
	}
	return dl, nil
}

func deserializeCBOR_Route53ResourceRecordSet(v smithycbor.Value) (*types.Route53ResourceRecordSet, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.Route53ResourceRecordSet{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "recordSetIdentifier" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.RecordSetIdentifier = ptr.String(dv)
		}

		if key == "region" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Region = ptr.String(dv)
		}
	}
	return ds, nil
}

func deserializeCBOR_Route53ResourceRecordSetList(v smithycbor.Value) ([]types.Route53ResourceRecordSet, error) {
	av, ok := v.(smithycbor.List)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	var dl []types.Route53ResourceRecordSet
	for _, si := range av {

		di, err := deserializeCBOR_Route53ResourceRecordSet(si)
		if err != nil {
			return nil, err
		}
		dl = append(dl, *di)
	}
	return dl, nil
}

func deserializeCBOR_RoutingControlStateChange(v smithycbor.Value) (types.RoutingControlStateChange, error) {
	av, ok := v.(smithycbor.String)
	if !ok {
		return types.RoutingControlStateChange(""), fmt.Errorf("unexpected value type %T", v)
	}
	return types.RoutingControlStateChange(av), nil
}

func deserializeCBOR_Service(v smithycbor.Value) (*types.Service, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.Service{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "crossAccountRole" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.CrossAccountRole = ptr.String(dv)
		}

		if key == "externalId" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.ExternalId = ptr.String(dv)
		}

		if key == "clusterArn" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.ClusterArn = ptr.String(dv)
		}

		if key == "serviceArn" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.ServiceArn = ptr.String(dv)
		}
	}
	return ds, nil
}

func deserializeCBOR_ServiceList(v smithycbor.Value) ([]types.Service, error) {
	av, ok := v.(smithycbor.List)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	var dl []types.Service
	for _, si := range av {

		di, err := deserializeCBOR_Service(si)
		if err != nil {
			return nil, err
		}
		dl = append(dl, *di)
	}
	return dl, nil
}

func deserializeCBOR_Step(v smithycbor.Value) (*types.Step, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.Step{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "name" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Name = ptr.String(dv)
		}

		if key == "description" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Description = ptr.String(dv)
		}

		if key == "executionBlockConfiguration" {

			dv, err := deserializeCBOR_ExecutionBlockConfiguration(sv)
			if err != nil {
				return nil, err
			}
			ds.ExecutionBlockConfiguration = dv
		}

		if key == "executionBlockType" {

			dv, err := deserializeCBOR_ExecutionBlockType(sv)
			if err != nil {
				return nil, err
			}
			ds.ExecutionBlockType = dv
		}
	}
	return ds, nil
}

func deserializeCBOR_Steps(v smithycbor.Value) ([]types.Step, error) {
	av, ok := v.(smithycbor.List)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	var dl []types.Step
	for _, si := range av {

		di, err := deserializeCBOR_Step(si)
		if err != nil {
			return nil, err
		}
		dl = append(dl, *di)
	}
	return dl, nil
}

func deserializeCBOR_StepState(v smithycbor.Value) (*types.StepState, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.StepState{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "name" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Name = ptr.String(dv)
		}

		if key == "status" {

			dv, err := deserializeCBOR_StepStatus(sv)
			if err != nil {
				return nil, err
			}
			ds.Status = dv
		}

		if key == "startTime" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Time(sv)
			if err != nil {
				return nil, err
			}
			ds.StartTime = ptr.Time(dv)
		}

		if key == "endTime" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Time(sv)
			if err != nil {
				return nil, err
			}
			ds.EndTime = ptr.Time(dv)
		}

		if key == "stepMode" {

			dv, err := deserializeCBOR_ExecutionMode(sv)
			if err != nil {
				return nil, err
			}
			ds.StepMode = dv
		}
	}
	return ds, nil
}

func deserializeCBOR_StepStates(v smithycbor.Value) ([]types.StepState, error) {
	av, ok := v.(smithycbor.List)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	var dl []types.StepState
	for _, si := range av {

		di, err := deserializeCBOR_StepState(si)
		if err != nil {
			return nil, err
		}
		dl = append(dl, *di)
	}
	return dl, nil
}

func deserializeCBOR_StepStatus(v smithycbor.Value) (types.StepStatus, error) {
	av, ok := v.(smithycbor.String)
	if !ok {
		return types.StepStatus(""), fmt.Errorf("unexpected value type %T", v)
	}
	return types.StepStatus(av), nil
}

func deserializeCBOR_Tags(v smithycbor.Value) (map[string]string, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	dm := map[string]string{}
	for key, sv := range av {

		dv, err := deserializeCBOR_String(sv)
		if err != nil {
			return nil, err
		}
		dm[key] = dv
	}
	return dm, nil
}

func deserializeCBOR_Trigger(v smithycbor.Value) (*types.Trigger, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.Trigger{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "description" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Description = ptr.String(dv)
		}

		if key == "targetRegion" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.TargetRegion = ptr.String(dv)
		}

		if key == "action" {

			dv, err := deserializeCBOR_WorkflowTargetAction(sv)
			if err != nil {
				return nil, err
			}
			ds.Action = dv
		}

		if key == "conditions" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_TriggerConditionList(sv)
			if err != nil {
				return nil, err
			}
			ds.Conditions = dv
		}

		if key == "minDelayMinutesBetweenExecutions" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Int32(sv)
			if err != nil {
				return nil, err
			}
			ds.MinDelayMinutesBetweenExecutions = ptr.Int32(dv)
		}
	}
	return ds, nil
}

func deserializeCBOR_TriggerCondition(v smithycbor.Value) (*types.TriggerCondition, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.TriggerCondition{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "associatedAlarmName" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.AssociatedAlarmName = ptr.String(dv)
		}

		if key == "condition" {

			dv, err := deserializeCBOR_AlarmCondition(sv)
			if err != nil {
				return nil, err
			}
			ds.Condition = dv
		}
	}
	return ds, nil
}

func deserializeCBOR_TriggerConditionList(v smithycbor.Value) ([]types.TriggerCondition, error) {
	av, ok := v.(smithycbor.List)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	var dl []types.TriggerCondition
	for _, si := range av {

		di, err := deserializeCBOR_TriggerCondition(si)
		if err != nil {
			return nil, err
		}
		dl = append(dl, *di)
	}
	return dl, nil
}

func deserializeCBOR_TriggerList(v smithycbor.Value) ([]types.Trigger, error) {
	av, ok := v.(smithycbor.List)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	var dl []types.Trigger
	for _, si := range av {

		di, err := deserializeCBOR_Trigger(si)
		if err != nil {
			return nil, err
		}
		dl = append(dl, *di)
	}
	return dl, nil
}

func deserializeCBOR_Workflow(v smithycbor.Value) (*types.Workflow, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.Workflow{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "steps" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Steps(sv)
			if err != nil {
				return nil, err
			}
			ds.Steps = dv
		}

		if key == "workflowTargetAction" {

			dv, err := deserializeCBOR_WorkflowTargetAction(sv)
			if err != nil {
				return nil, err
			}
			ds.WorkflowTargetAction = dv
		}

		if key == "workflowTargetRegion" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.WorkflowTargetRegion = ptr.String(dv)
		}

		if key == "workflowDescription" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.WorkflowDescription = ptr.String(dv)
		}
	}
	return ds, nil
}

func deserializeCBOR_WorkflowList(v smithycbor.Value) ([]types.Workflow, error) {
	av, ok := v.(smithycbor.List)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	var dl []types.Workflow
	for _, si := range av {

		di, err := deserializeCBOR_Workflow(si)
		if err != nil {
			return nil, err
		}
		dl = append(dl, *di)
	}
	return dl, nil
}

func deserializeCBOR_WorkflowTargetAction(v smithycbor.Value) (types.WorkflowTargetAction, error) {
	av, ok := v.(smithycbor.String)
	if !ok {
		return types.WorkflowTargetAction(""), fmt.Errorf("unexpected value type %T", v)
	}
	return types.WorkflowTargetAction(av), nil
}

func deserializeCBOR_Float32(v smithycbor.Value) (float32, error) {
	return smithycbor.AsFloat32(v)
}

func deserializeCBOR_Int32(v smithycbor.Value) (int32, error) {
	return smithycbor.AsInt32(v)
}

func deserializeCBOR_String(v smithycbor.Value) (string, error) {
	av, ok := v.(smithycbor.String)
	if !ok {
		return "", fmt.Errorf("unexpected value type %T", v)
	}
	return string(av), nil
}

func deserializeCBOR_Time(v smithycbor.Value) (time.Time, error) {
	return smithycbor.AsTime(v)
}

func deserializeCBOR_CreatePlanOutput(v smithycbor.Value) (*CreatePlanOutput, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &CreatePlanOutput{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "plan" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Plan(sv)
			if err != nil {
				return nil, err
			}
			ds.Plan = dv
		}
	}
	return ds, nil
}

func deserializeCBOR_GetPlanEvaluationStatusOutput(v smithycbor.Value) (*GetPlanEvaluationStatusOutput, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &GetPlanEvaluationStatusOutput{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "planArn" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.PlanArn = ptr.String(dv)
		}

		if key == "lastEvaluationTime" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Time(sv)
			if err != nil {
				return nil, err
			}
			ds.LastEvaluationTime = ptr.Time(dv)
		}

		if key == "lastEvaluatedVersion" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.LastEvaluatedVersion = ptr.String(dv)
		}

		if key == "region" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Region = ptr.String(dv)
		}

		if key == "evaluationState" {

			dv, err := deserializeCBOR_EvaluationStatus(sv)
			if err != nil {
				return nil, err
			}
			ds.EvaluationState = dv
		}

		if key == "warnings" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_PlanWarnings(sv)
			if err != nil {
				return nil, err
			}
			ds.Warnings = dv
		}

		if key == "nextToken" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.NextToken = ptr.String(dv)
		}
	}
	return ds, nil
}

func deserializeCBOR_GetPlanExecutionOutput(v smithycbor.Value) (*GetPlanExecutionOutput, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &GetPlanExecutionOutput{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "planArn" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.PlanArn = ptr.String(dv)
		}

		if key == "executionId" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.ExecutionId = ptr.String(dv)
		}

		if key == "version" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Version = ptr.String(dv)
		}

		if key == "updatedAt" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Time(sv)
			if err != nil {
				return nil, err
			}
			ds.UpdatedAt = ptr.Time(dv)
		}

		if key == "comment" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Comment = ptr.String(dv)
		}

		if key == "startTime" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Time(sv)
			if err != nil {
				return nil, err
			}
			ds.StartTime = ptr.Time(dv)
		}

		if key == "endTime" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Time(sv)
			if err != nil {
				return nil, err
			}
			ds.EndTime = ptr.Time(dv)
		}

		if key == "mode" {

			dv, err := deserializeCBOR_ExecutionMode(sv)
			if err != nil {
				return nil, err
			}
			ds.Mode = dv
		}

		if key == "executionState" {

			dv, err := deserializeCBOR_ExecutionState(sv)
			if err != nil {
				return nil, err
			}
			ds.ExecutionState = dv
		}

		if key == "executionAction" {

			dv, err := deserializeCBOR_ExecutionAction(sv)
			if err != nil {
				return nil, err
			}
			ds.ExecutionAction = dv
		}

		if key == "executionRegion" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.ExecutionRegion = ptr.String(dv)
		}

		if key == "stepStates" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_StepStates(sv)
			if err != nil {
				return nil, err
			}
			ds.StepStates = dv
		}

		if key == "plan" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Plan(sv)
			if err != nil {
				return nil, err
			}
			ds.Plan = dv
		}

		if key == "actualRecoveryTime" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.ActualRecoveryTime = ptr.String(dv)
		}

		if key == "nextToken" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.NextToken = ptr.String(dv)
		}
	}
	return ds, nil
}

func deserializeCBOR_GetPlanInRegionOutput(v smithycbor.Value) (*GetPlanInRegionOutput, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &GetPlanInRegionOutput{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "plan" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Plan(sv)
			if err != nil {
				return nil, err
			}
			ds.Plan = dv
		}
	}
	return ds, nil
}

func deserializeCBOR_GetPlanOutput(v smithycbor.Value) (*GetPlanOutput, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &GetPlanOutput{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "plan" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Plan(sv)
			if err != nil {
				return nil, err
			}
			ds.Plan = dv
		}
	}
	return ds, nil
}

func deserializeCBOR_ListPlanExecutionEventsOutput(v smithycbor.Value) (*ListPlanExecutionEventsOutput, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &ListPlanExecutionEventsOutput{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "items" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_ExecutionEventList(sv)
			if err != nil {
				return nil, err
			}
			ds.Items = dv
		}

		if key == "nextToken" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.NextToken = ptr.String(dv)
		}
	}
	return ds, nil
}

func deserializeCBOR_ListPlanExecutionsOutput(v smithycbor.Value) (*ListPlanExecutionsOutput, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &ListPlanExecutionsOutput{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "items" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_AbbreviatedExecutionsList(sv)
			if err != nil {
				return nil, err
			}
			ds.Items = dv
		}

		if key == "nextToken" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.NextToken = ptr.String(dv)
		}
	}
	return ds, nil
}

func deserializeCBOR_ListPlansInRegionOutput(v smithycbor.Value) (*ListPlansInRegionOutput, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &ListPlansInRegionOutput{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "plans" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_PlanList(sv)
			if err != nil {
				return nil, err
			}
			ds.Plans = dv
		}

		if key == "nextToken" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.NextToken = ptr.String(dv)
		}
	}
	return ds, nil
}

func deserializeCBOR_ListPlansOutput(v smithycbor.Value) (*ListPlansOutput, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &ListPlansOutput{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "plans" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_PlanList(sv)
			if err != nil {
				return nil, err
			}
			ds.Plans = dv
		}

		if key == "nextToken" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.NextToken = ptr.String(dv)
		}
	}
	return ds, nil
}

func deserializeCBOR_ListRoute53HealthChecksOutput(v smithycbor.Value) (*ListRoute53HealthChecksOutput, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &ListRoute53HealthChecksOutput{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "healthChecks" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Route53HealthCheckList(sv)
			if err != nil {
				return nil, err
			}
			ds.HealthChecks = dv
		}

		if key == "nextToken" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.NextToken = ptr.String(dv)
		}
	}
	return ds, nil
}

func deserializeCBOR_ListTagsForResourceOutput(v smithycbor.Value) (*ListTagsForResourceOutput, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &ListTagsForResourceOutput{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "resourceTags" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Tags(sv)
			if err != nil {
				return nil, err
			}
			ds.ResourceTags = dv
		}
	}
	return ds, nil
}

func deserializeCBOR_StartPlanExecutionOutput(v smithycbor.Value) (*StartPlanExecutionOutput, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &StartPlanExecutionOutput{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "executionId" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.ExecutionId = ptr.String(dv)
		}

		if key == "plan" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Plan = ptr.String(dv)
		}

		if key == "planVersion" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.PlanVersion = ptr.String(dv)
		}

		if key == "activateRegion" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.ActivateRegion = ptr.String(dv)
		}

		if key == "deactivateRegion" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.DeactivateRegion = ptr.String(dv)
		}
	}
	return ds, nil
}

func deserializeCBOR_UpdatePlanOutput(v smithycbor.Value) (*UpdatePlanOutput, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &UpdatePlanOutput{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "plan" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Plan(sv)
			if err != nil {
				return nil, err
			}
			ds.Plan = dv
		}
	}
	return ds, nil
}
func rpc2_deserializeOpErrorApprovePlanExecutionStep(resp *smithyhttp.Response) error {
	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("read response body: %w", err)}
	}

	typ, msg, v, err := getProtocolErrorInfo(payload)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("get error info: %w", err)}
	}

	if len(typ) == 0 {
		typ = "UnknownError"
	}
	if len(msg) == 0 {
		msg = "UnknownError"
	}

	_ = v
	// namespace can be mangled by service, so matching by error shape name
	errorParts := strings.Split(typ, "#")
	errorName := errorParts[len(errorParts)-1]
	switch string(errorName) {
	case "AccessDeniedException":
		verr, err := deserializeCBOR_AccessDeniedException(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize com.amazonaws.arcregionswitch#AccessDeniedException: %w", err),
				Snapshot: payload,
			}
		}

		return verr
	case "ResourceNotFoundException":
		verr, err := deserializeCBOR_ResourceNotFoundException(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize com.amazonaws.arcregionswitch#ResourceNotFoundException: %w", err),
				Snapshot: payload,
			}
		}

		return verr
	default:

		return &smithy.GenericAPIError{Code: typ, Message: msg}
	}
}

func rpc2_deserializeOpErrorCancelPlanExecution(resp *smithyhttp.Response) error {
	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("read response body: %w", err)}
	}

	typ, msg, v, err := getProtocolErrorInfo(payload)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("get error info: %w", err)}
	}

	if len(typ) == 0 {
		typ = "UnknownError"
	}
	if len(msg) == 0 {
		msg = "UnknownError"
	}

	_ = v
	// namespace can be mangled by service, so matching by error shape name
	errorParts := strings.Split(typ, "#")
	errorName := errorParts[len(errorParts)-1]
	switch string(errorName) {
	case "AccessDeniedException":
		verr, err := deserializeCBOR_AccessDeniedException(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize com.amazonaws.arcregionswitch#AccessDeniedException: %w", err),
				Snapshot: payload,
			}
		}

		return verr
	case "ResourceNotFoundException":
		verr, err := deserializeCBOR_ResourceNotFoundException(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize com.amazonaws.arcregionswitch#ResourceNotFoundException: %w", err),
				Snapshot: payload,
			}
		}

		return verr
	default:

		return &smithy.GenericAPIError{Code: typ, Message: msg}
	}
}

func rpc2_deserializeOpErrorCreatePlan(resp *smithyhttp.Response) error {
	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("read response body: %w", err)}
	}

	typ, msg, v, err := getProtocolErrorInfo(payload)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("get error info: %w", err)}
	}

	if len(typ) == 0 {
		typ = "UnknownError"
	}
	if len(msg) == 0 {
		msg = "UnknownError"
	}

	_ = v
	// namespace can be mangled by service, so matching by error shape name
	errorParts := strings.Split(typ, "#")
	errorName := errorParts[len(errorParts)-1]
	switch string(errorName) {

	default:

		return &smithy.GenericAPIError{Code: typ, Message: msg}
	}
}

func rpc2_deserializeOpErrorDeletePlan(resp *smithyhttp.Response) error {
	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("read response body: %w", err)}
	}

	typ, msg, v, err := getProtocolErrorInfo(payload)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("get error info: %w", err)}
	}

	if len(typ) == 0 {
		typ = "UnknownError"
	}
	if len(msg) == 0 {
		msg = "UnknownError"
	}

	_ = v
	// namespace can be mangled by service, so matching by error shape name
	errorParts := strings.Split(typ, "#")
	errorName := errorParts[len(errorParts)-1]
	switch string(errorName) {
	case "IllegalStateException":
		verr, err := deserializeCBOR_IllegalStateException(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize com.amazonaws.arcregionswitch#IllegalStateException: %w", err),
				Snapshot: payload,
			}
		}

		return verr
	case "ResourceNotFoundException":
		verr, err := deserializeCBOR_ResourceNotFoundException(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize com.amazonaws.arcregionswitch#ResourceNotFoundException: %w", err),
				Snapshot: payload,
			}
		}

		return verr
	default:

		return &smithy.GenericAPIError{Code: typ, Message: msg}
	}
}

func rpc2_deserializeOpErrorGetPlan(resp *smithyhttp.Response) error {
	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("read response body: %w", err)}
	}

	typ, msg, v, err := getProtocolErrorInfo(payload)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("get error info: %w", err)}
	}

	if len(typ) == 0 {
		typ = "UnknownError"
	}
	if len(msg) == 0 {
		msg = "UnknownError"
	}

	_ = v
	// namespace can be mangled by service, so matching by error shape name
	errorParts := strings.Split(typ, "#")
	errorName := errorParts[len(errorParts)-1]
	switch string(errorName) {
	case "ResourceNotFoundException":
		verr, err := deserializeCBOR_ResourceNotFoundException(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize com.amazonaws.arcregionswitch#ResourceNotFoundException: %w", err),
				Snapshot: payload,
			}
		}

		return verr
	default:

		return &smithy.GenericAPIError{Code: typ, Message: msg}
	}
}

func rpc2_deserializeOpErrorGetPlanEvaluationStatus(resp *smithyhttp.Response) error {
	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("read response body: %w", err)}
	}

	typ, msg, v, err := getProtocolErrorInfo(payload)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("get error info: %w", err)}
	}

	if len(typ) == 0 {
		typ = "UnknownError"
	}
	if len(msg) == 0 {
		msg = "UnknownError"
	}

	_ = v
	// namespace can be mangled by service, so matching by error shape name
	errorParts := strings.Split(typ, "#")
	errorName := errorParts[len(errorParts)-1]
	switch string(errorName) {
	case "AccessDeniedException":
		verr, err := deserializeCBOR_AccessDeniedException(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize com.amazonaws.arcregionswitch#AccessDeniedException: %w", err),
				Snapshot: payload,
			}
		}

		return verr
	case "ResourceNotFoundException":
		verr, err := deserializeCBOR_ResourceNotFoundException(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize com.amazonaws.arcregionswitch#ResourceNotFoundException: %w", err),
				Snapshot: payload,
			}
		}

		return verr
	default:

		return &smithy.GenericAPIError{Code: typ, Message: msg}
	}
}

func rpc2_deserializeOpErrorGetPlanExecution(resp *smithyhttp.Response) error {
	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("read response body: %w", err)}
	}

	typ, msg, v, err := getProtocolErrorInfo(payload)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("get error info: %w", err)}
	}

	if len(typ) == 0 {
		typ = "UnknownError"
	}
	if len(msg) == 0 {
		msg = "UnknownError"
	}

	_ = v
	// namespace can be mangled by service, so matching by error shape name
	errorParts := strings.Split(typ, "#")
	errorName := errorParts[len(errorParts)-1]
	switch string(errorName) {
	case "AccessDeniedException":
		verr, err := deserializeCBOR_AccessDeniedException(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize com.amazonaws.arcregionswitch#AccessDeniedException: %w", err),
				Snapshot: payload,
			}
		}

		return verr
	case "ResourceNotFoundException":
		verr, err := deserializeCBOR_ResourceNotFoundException(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize com.amazonaws.arcregionswitch#ResourceNotFoundException: %w", err),
				Snapshot: payload,
			}
		}

		return verr
	default:

		return &smithy.GenericAPIError{Code: typ, Message: msg}
	}
}

func rpc2_deserializeOpErrorGetPlanInRegion(resp *smithyhttp.Response) error {
	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("read response body: %w", err)}
	}

	typ, msg, v, err := getProtocolErrorInfo(payload)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("get error info: %w", err)}
	}

	if len(typ) == 0 {
		typ = "UnknownError"
	}
	if len(msg) == 0 {
		msg = "UnknownError"
	}

	_ = v
	// namespace can be mangled by service, so matching by error shape name
	errorParts := strings.Split(typ, "#")
	errorName := errorParts[len(errorParts)-1]
	switch string(errorName) {
	case "AccessDeniedException":
		verr, err := deserializeCBOR_AccessDeniedException(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize com.amazonaws.arcregionswitch#AccessDeniedException: %w", err),
				Snapshot: payload,
			}
		}

		return verr
	case "ResourceNotFoundException":
		verr, err := deserializeCBOR_ResourceNotFoundException(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize com.amazonaws.arcregionswitch#ResourceNotFoundException: %w", err),
				Snapshot: payload,
			}
		}

		return verr
	default:

		return &smithy.GenericAPIError{Code: typ, Message: msg}
	}
}

func rpc2_deserializeOpErrorListPlanExecutionEvents(resp *smithyhttp.Response) error {
	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("read response body: %w", err)}
	}

	typ, msg, v, err := getProtocolErrorInfo(payload)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("get error info: %w", err)}
	}

	if len(typ) == 0 {
		typ = "UnknownError"
	}
	if len(msg) == 0 {
		msg = "UnknownError"
	}

	_ = v
	// namespace can be mangled by service, so matching by error shape name
	errorParts := strings.Split(typ, "#")
	errorName := errorParts[len(errorParts)-1]
	switch string(errorName) {
	case "AccessDeniedException":
		verr, err := deserializeCBOR_AccessDeniedException(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize com.amazonaws.arcregionswitch#AccessDeniedException: %w", err),
				Snapshot: payload,
			}
		}

		return verr
	case "ResourceNotFoundException":
		verr, err := deserializeCBOR_ResourceNotFoundException(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize com.amazonaws.arcregionswitch#ResourceNotFoundException: %w", err),
				Snapshot: payload,
			}
		}

		return verr
	default:

		return &smithy.GenericAPIError{Code: typ, Message: msg}
	}
}

func rpc2_deserializeOpErrorListPlanExecutions(resp *smithyhttp.Response) error {
	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("read response body: %w", err)}
	}

	typ, msg, v, err := getProtocolErrorInfo(payload)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("get error info: %w", err)}
	}

	if len(typ) == 0 {
		typ = "UnknownError"
	}
	if len(msg) == 0 {
		msg = "UnknownError"
	}

	_ = v
	// namespace can be mangled by service, so matching by error shape name
	errorParts := strings.Split(typ, "#")
	errorName := errorParts[len(errorParts)-1]
	switch string(errorName) {
	case "AccessDeniedException":
		verr, err := deserializeCBOR_AccessDeniedException(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize com.amazonaws.arcregionswitch#AccessDeniedException: %w", err),
				Snapshot: payload,
			}
		}

		return verr
	case "ResourceNotFoundException":
		verr, err := deserializeCBOR_ResourceNotFoundException(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize com.amazonaws.arcregionswitch#ResourceNotFoundException: %w", err),
				Snapshot: payload,
			}
		}

		return verr
	default:

		return &smithy.GenericAPIError{Code: typ, Message: msg}
	}
}

func rpc2_deserializeOpErrorListPlans(resp *smithyhttp.Response) error {
	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("read response body: %w", err)}
	}

	typ, msg, v, err := getProtocolErrorInfo(payload)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("get error info: %w", err)}
	}

	if len(typ) == 0 {
		typ = "UnknownError"
	}
	if len(msg) == 0 {
		msg = "UnknownError"
	}

	_ = v
	// namespace can be mangled by service, so matching by error shape name
	errorParts := strings.Split(typ, "#")
	errorName := errorParts[len(errorParts)-1]
	switch string(errorName) {

	default:

		return &smithy.GenericAPIError{Code: typ, Message: msg}
	}
}

func rpc2_deserializeOpErrorListPlansInRegion(resp *smithyhttp.Response) error {
	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("read response body: %w", err)}
	}

	typ, msg, v, err := getProtocolErrorInfo(payload)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("get error info: %w", err)}
	}

	if len(typ) == 0 {
		typ = "UnknownError"
	}
	if len(msg) == 0 {
		msg = "UnknownError"
	}

	_ = v
	// namespace can be mangled by service, so matching by error shape name
	errorParts := strings.Split(typ, "#")
	errorName := errorParts[len(errorParts)-1]
	switch string(errorName) {
	case "AccessDeniedException":
		verr, err := deserializeCBOR_AccessDeniedException(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize com.amazonaws.arcregionswitch#AccessDeniedException: %w", err),
				Snapshot: payload,
			}
		}

		return verr
	default:

		return &smithy.GenericAPIError{Code: typ, Message: msg}
	}
}

func rpc2_deserializeOpErrorListRoute53HealthChecks(resp *smithyhttp.Response) error {
	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("read response body: %w", err)}
	}

	typ, msg, v, err := getProtocolErrorInfo(payload)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("get error info: %w", err)}
	}

	if len(typ) == 0 {
		typ = "UnknownError"
	}
	if len(msg) == 0 {
		msg = "UnknownError"
	}

	_ = v
	// namespace can be mangled by service, so matching by error shape name
	errorParts := strings.Split(typ, "#")
	errorName := errorParts[len(errorParts)-1]
	switch string(errorName) {
	case "AccessDeniedException":
		verr, err := deserializeCBOR_AccessDeniedException(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize com.amazonaws.arcregionswitch#AccessDeniedException: %w", err),
				Snapshot: payload,
			}
		}

		return verr
	case "InternalServerException":
		verr, err := deserializeCBOR_InternalServerException(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize com.amazonaws.arcregionswitch#InternalServerException: %w", err),
				Snapshot: payload,
			}
		}

		return verr
	case "ResourceNotFoundException":
		verr, err := deserializeCBOR_ResourceNotFoundException(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize com.amazonaws.arcregionswitch#ResourceNotFoundException: %w", err),
				Snapshot: payload,
			}
		}

		return verr
	default:

		return &smithy.GenericAPIError{Code: typ, Message: msg}
	}
}

func rpc2_deserializeOpErrorListTagsForResource(resp *smithyhttp.Response) error {
	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("read response body: %w", err)}
	}

	typ, msg, v, err := getProtocolErrorInfo(payload)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("get error info: %w", err)}
	}

	if len(typ) == 0 {
		typ = "UnknownError"
	}
	if len(msg) == 0 {
		msg = "UnknownError"
	}

	_ = v
	// namespace can be mangled by service, so matching by error shape name
	errorParts := strings.Split(typ, "#")
	errorName := errorParts[len(errorParts)-1]
	switch string(errorName) {
	case "InternalServerException":
		verr, err := deserializeCBOR_InternalServerException(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize com.amazonaws.arcregionswitch#InternalServerException: %w", err),
				Snapshot: payload,
			}
		}

		return verr
	case "ResourceNotFoundException":
		verr, err := deserializeCBOR_ResourceNotFoundException(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize com.amazonaws.arcregionswitch#ResourceNotFoundException: %w", err),
				Snapshot: payload,
			}
		}

		return verr
	default:

		return &smithy.GenericAPIError{Code: typ, Message: msg}
	}
}

func rpc2_deserializeOpErrorStartPlanExecution(resp *smithyhttp.Response) error {
	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("read response body: %w", err)}
	}

	typ, msg, v, err := getProtocolErrorInfo(payload)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("get error info: %w", err)}
	}

	if len(typ) == 0 {
		typ = "UnknownError"
	}
	if len(msg) == 0 {
		msg = "UnknownError"
	}

	_ = v
	// namespace can be mangled by service, so matching by error shape name
	errorParts := strings.Split(typ, "#")
	errorName := errorParts[len(errorParts)-1]
	switch string(errorName) {
	case "AccessDeniedException":
		verr, err := deserializeCBOR_AccessDeniedException(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize com.amazonaws.arcregionswitch#AccessDeniedException: %w", err),
				Snapshot: payload,
			}
		}

		return verr
	case "IllegalArgumentException":
		verr, err := deserializeCBOR_IllegalArgumentException(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize com.amazonaws.arcregionswitch#IllegalArgumentException: %w", err),
				Snapshot: payload,
			}
		}

		return verr
	case "IllegalStateException":
		verr, err := deserializeCBOR_IllegalStateException(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize com.amazonaws.arcregionswitch#IllegalStateException: %w", err),
				Snapshot: payload,
			}
		}

		return verr
	case "ResourceNotFoundException":
		verr, err := deserializeCBOR_ResourceNotFoundException(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize com.amazonaws.arcregionswitch#ResourceNotFoundException: %w", err),
				Snapshot: payload,
			}
		}

		return verr
	default:

		return &smithy.GenericAPIError{Code: typ, Message: msg}
	}
}

func rpc2_deserializeOpErrorTagResource(resp *smithyhttp.Response) error {
	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("read response body: %w", err)}
	}

	typ, msg, v, err := getProtocolErrorInfo(payload)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("get error info: %w", err)}
	}

	if len(typ) == 0 {
		typ = "UnknownError"
	}
	if len(msg) == 0 {
		msg = "UnknownError"
	}

	_ = v
	// namespace can be mangled by service, so matching by error shape name
	errorParts := strings.Split(typ, "#")
	errorName := errorParts[len(errorParts)-1]
	switch string(errorName) {
	case "InternalServerException":
		verr, err := deserializeCBOR_InternalServerException(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize com.amazonaws.arcregionswitch#InternalServerException: %w", err),
				Snapshot: payload,
			}
		}

		return verr
	case "ResourceNotFoundException":
		verr, err := deserializeCBOR_ResourceNotFoundException(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize com.amazonaws.arcregionswitch#ResourceNotFoundException: %w", err),
				Snapshot: payload,
			}
		}

		return verr
	default:

		return &smithy.GenericAPIError{Code: typ, Message: msg}
	}
}

func rpc2_deserializeOpErrorUntagResource(resp *smithyhttp.Response) error {
	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("read response body: %w", err)}
	}

	typ, msg, v, err := getProtocolErrorInfo(payload)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("get error info: %w", err)}
	}

	if len(typ) == 0 {
		typ = "UnknownError"
	}
	if len(msg) == 0 {
		msg = "UnknownError"
	}

	_ = v
	// namespace can be mangled by service, so matching by error shape name
	errorParts := strings.Split(typ, "#")
	errorName := errorParts[len(errorParts)-1]
	switch string(errorName) {
	case "InternalServerException":
		verr, err := deserializeCBOR_InternalServerException(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize com.amazonaws.arcregionswitch#InternalServerException: %w", err),
				Snapshot: payload,
			}
		}

		return verr
	case "ResourceNotFoundException":
		verr, err := deserializeCBOR_ResourceNotFoundException(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize com.amazonaws.arcregionswitch#ResourceNotFoundException: %w", err),
				Snapshot: payload,
			}
		}

		return verr
	default:

		return &smithy.GenericAPIError{Code: typ, Message: msg}
	}
}

func rpc2_deserializeOpErrorUpdatePlan(resp *smithyhttp.Response) error {
	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("read response body: %w", err)}
	}

	typ, msg, v, err := getProtocolErrorInfo(payload)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("get error info: %w", err)}
	}

	if len(typ) == 0 {
		typ = "UnknownError"
	}
	if len(msg) == 0 {
		msg = "UnknownError"
	}

	_ = v
	// namespace can be mangled by service, so matching by error shape name
	errorParts := strings.Split(typ, "#")
	errorName := errorParts[len(errorParts)-1]
	switch string(errorName) {
	case "ResourceNotFoundException":
		verr, err := deserializeCBOR_ResourceNotFoundException(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize com.amazonaws.arcregionswitch#ResourceNotFoundException: %w", err),
				Snapshot: payload,
			}
		}

		return verr
	default:

		return &smithy.GenericAPIError{Code: typ, Message: msg}
	}
}

func rpc2_deserializeOpErrorUpdatePlanExecution(resp *smithyhttp.Response) error {
	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("read response body: %w", err)}
	}

	typ, msg, v, err := getProtocolErrorInfo(payload)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("get error info: %w", err)}
	}

	if len(typ) == 0 {
		typ = "UnknownError"
	}
	if len(msg) == 0 {
		msg = "UnknownError"
	}

	_ = v
	// namespace can be mangled by service, so matching by error shape name
	errorParts := strings.Split(typ, "#")
	errorName := errorParts[len(errorParts)-1]
	switch string(errorName) {
	case "AccessDeniedException":
		verr, err := deserializeCBOR_AccessDeniedException(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize com.amazonaws.arcregionswitch#AccessDeniedException: %w", err),
				Snapshot: payload,
			}
		}

		return verr
	case "IllegalStateException":
		verr, err := deserializeCBOR_IllegalStateException(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize com.amazonaws.arcregionswitch#IllegalStateException: %w", err),
				Snapshot: payload,
			}
		}

		return verr
	case "ResourceNotFoundException":
		verr, err := deserializeCBOR_ResourceNotFoundException(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize com.amazonaws.arcregionswitch#ResourceNotFoundException: %w", err),
				Snapshot: payload,
			}
		}

		return verr
	default:

		return &smithy.GenericAPIError{Code: typ, Message: msg}
	}
}

func rpc2_deserializeOpErrorUpdatePlanExecutionStep(resp *smithyhttp.Response) error {
	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("read response body: %w", err)}
	}

	typ, msg, v, err := getProtocolErrorInfo(payload)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("get error info: %w", err)}
	}

	if len(typ) == 0 {
		typ = "UnknownError"
	}
	if len(msg) == 0 {
		msg = "UnknownError"
	}

	_ = v
	// namespace can be mangled by service, so matching by error shape name
	errorParts := strings.Split(typ, "#")
	errorName := errorParts[len(errorParts)-1]
	switch string(errorName) {
	case "AccessDeniedException":
		verr, err := deserializeCBOR_AccessDeniedException(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize com.amazonaws.arcregionswitch#AccessDeniedException: %w", err),
				Snapshot: payload,
			}
		}

		return verr
	case "ResourceNotFoundException":
		verr, err := deserializeCBOR_ResourceNotFoundException(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize com.amazonaws.arcregionswitch#ResourceNotFoundException: %w", err),
				Snapshot: payload,
			}
		}

		return verr
	default:

		return &smithy.GenericAPIError{Code: typ, Message: msg}
	}
}
func getProtocolErrorInfo(payload []byte) (typ, msg string, v smithycbor.Value, err error) {
	v, err = smithycbor.Decode(payload)
	if err != nil {
		return "", "", nil, fmt.Errorf("decode: %w", err)
	}

	mv, ok := v.(smithycbor.Map)
	if !ok {
		return "", "", nil, fmt.Errorf("unexpected payload type %T", v)
	}

	if ctyp, ok := mv["__type"]; ok {
		if ttyp, ok := ctyp.(smithycbor.String); ok {
			typ = string(ttyp)
		}
	}

	if cmsg, ok := mv["message"]; ok {
		if tmsg, ok := cmsg.(smithycbor.String); ok {
			msg = string(tmsg)
		}
	}

	return typ, msg, mv, nil
}
func getAwsQueryErrorCode(resp *smithyhttp.Response) string {
	header := resp.Header.Get("x-amzn-query-error")
	if header == "" {
		return ""
	}

	parts := strings.Split(header, ";")
	if len(parts) != 2 {
		return ""
	}

	return parts[0]
}
