//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armstreamanalytics_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/streamanalytics/armstreamanalytics/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/fa469a1157c33837a46c9bcd524527e94125189a/specification/streamanalytics/resource-manager/Microsoft.StreamAnalytics/preview/2021-10-01-preview/examples/StreamingJob_GetSkus.json
func ExampleSKUClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstreamanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewSKUClient().NewListPager("sjrg3276", "sj7804", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.GetStreamingJobSKUResults = armstreamanalytics.GetStreamingJobSKUResults{
		// 	Value: []*armstreamanalytics.GetStreamingJobSKUResult{
		// 		{
		// 			Capacity: &armstreamanalytics.SKUCapacity{
		// 				Default: to.Ptr[int32](3),
		// 				AllowedValues: []*int32{
		// 					to.Ptr[int32](1),
		// 					to.Ptr[int32](3),
		// 					to.Ptr[int32](6),
		// 					to.Ptr[int32](12),
		// 					to.Ptr[int32](18),
		// 					to.Ptr[int32](24)},
		// 					Maximum: to.Ptr[int32](192),
		// 					Minimum: to.Ptr[int32](1),
		// 					ScaleType: to.Ptr(armstreamanalytics.SKUCapacityScaleTypeAutomatic),
		// 				},
		// 				ResourceType: to.Ptr(armstreamanalytics.ResourceTypeMicrosoftStreamAnalyticsStreamingjobs),
		// 				SKU: &armstreamanalytics.GetStreamingJobSKUResultSKU{
		// 					Name: to.Ptr(armstreamanalytics.SKUNameStandard),
		// 				},
		// 		}},
		// 	}
	}
}
