//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsecurity_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/preview/2021-10-01-preview/examples/MdeOnboardings/ListMdeOnboardings_example.json
func ExampleMdeOnboardingsClient_List() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMdeOnboardingsClient().List(ctx, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.MdeOnboardingDataList = armsecurity.MdeOnboardingDataList{
	// 	Value: []*armsecurity.MdeOnboardingData{
	// 		{
	// 			Name: to.Ptr("default"),
	// 			Type: to.Ptr("Microsoft.Security/mdeOnboarding"),
	// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/mdeOnboarding/default"),
	// 			Properties: &armsecurity.MdeOnboardingDataProperties{
	// 				OnboardingPackageLinux: []byte("QGVjaG8gb2ZmCgplY2hvLiA+TlVMIDI+JjEKZWNobyBTdGFydGluZyBXaW5kb3dzIERlZmVuZGVyIEFkdmFuY2VkIFRocmVhdCBQcm90ZWN0aW9uIG9uYm9hcmRpbmcgcHJvY2Vzcy4uLiA+TlVMIDI+JjEKZWNoby4gPk5VTCAyPiYxCgpzZXQgZXJyb3JDb2RlPTAKc2V0IGxhc3RFcnJvcj0wCnNldCAidHJvdWJsZXNob290SW5mbz1Gb3IgbW9yZSBpbmZvcm1hdGlvbiwgdmlzaXQ6IGh0dHBzOi8vZ28ubWljcm9zb2Z0LmNvbS9md2xpbmsvcC8/bGlua2lkPTgyMjgwNyIKc2V0ICJlcnJvckRlc2NyaXB0aW9uPSIKCmVjaG8gVGVzdGluZyBhZG1pbmlzdHJhdG9yIHByaXZpbGVnZXMgPk5VTCAyPiYxCgpuZXQgc2Vzc2lvbiA+TlVMIDI+JjEKaWYgJUVSUk9STEVWRUwlIE5FUSAwICgKCUBlY2hvIFNjcmlwdCBpcyBydW5uaW5nIHdpdGggaW5zdWZmaWNpZW50IHByaXZpbGVnZXMuIFBsZWFzZSBydW4gd2l0aCBhZG1pbmlzdHJhdG9yIHByaXZpbGVnZXM+ICVUTVAlXHNlbnNlVG1wLnR4dAoJc2V0IGVycm9yQ29kZT02NQogc2V0IGxhc3RFcnJvcj0lRVJST1JMRVZFTCUKCUdPVE8gRVJST1IKKQoKZWNobyBTY3JpcHQgaXMgcnVubmluZyB3aXRoIHN1ZmZpY2llbnQgcHJpdmlsZWdlcyA+TlVMIDI+JjEKZWNoby4gPk5VTCAyPiYxCmVjaG8gUGVyZm9ybWluZyBvbmJvYXJkaW5nIG9wZXJhdGlvbnMgPk5VTCAyPiYxCmVjaG8uID5OVUwgMj4mMQoKSUYgWyVQUk9DRVNTT1JfQVJDSElURVc2NDMyJV0gRVFVIFtdICgKICBzZXQgcG93ZXJzaGVsbFBhdGg9JXdpbmRpciVcU3lzdGVtMzJcV2luZG93c1Bvd2VyU2hlbGxcdjEuMFxwb3dlcnNoZWxsLmV4ZQopIEVMU0UgKAogIHNldCBwb3dlcnNoZWxsUGF0aD0ld2luZGlyJVxTeXNOYXRpdmVcV2luZG93c1Bvd2VyU2hlbGxcdjEuMFxwb3dlcnNoZWxsLmV4ZQopCgpzZXQgc2RiaW49MDEwMDA0ODA0NDAwMDAwMDU0MDAwMDAwMDAwMDAwMDAxNDAwMDAwMDAyMDAzMDAwMDIwMDAwMDAwMDAwMTQwMEZGMEYxMjAwMDEwMTAwMDAwMDAwMDAwNTEyMDAwMDAwMDAwMDE0MDBFMTA0MTIwMDAxMDEwMDAwMDAwMDAwMDUwQjAwMDAwMDAxMDIwMDAwMDAwMDAwMDUyMDAwMDAwMDIwMDIwMDAwMDEwMjAwMDAwMDAwMDAwNTIwMDAwMDAwMjAwMjAwMDAgPk5VTCAyPiYxCnJlZyBhZGQgSEtMTVxTWVNURU1cQ3VycmVudENvbnRyb2xTZXRcQ29udHJvbFxXTUlcU2VjdXJpdHkgL3YgMTRmODEzOGUtM2I2MS01ODBiLTU0NGItMjYwOTM3OGFlNDYwIC90IFJFR19CSU5BUlkgL2QgJXNkYmluJSAvZiA+TlVMIDI+JjEKcmVnIGFkZCBIS0xNXFNZU1RFTVxDdXJyZW50Q29udHJvbFNldFxDb250cm9sXFdNSVxTZWN1cml0eSAvdiBjYjJmZjcyZC1kNGU0LTU4NWQtMzNmOS1mM2EzOTVjNDBiZTcgL3QgUkVHX0JJTkFSWSAvZCAlc2RiaW4lIC9mID5OVUwgMj4mMQoKUkVHIGFkZCAiSEtMTVxTT0ZUV0FSRVxQb2xpY2llc1xNaWNyb3NvZnRcV2luZG93c1xEYXRhQ29sbGVjdGlvbiIgL3YgRGlzYWJsZUVudGVycHJpc2VBdXRoUHJveHkgL3QgUkVHX0RXT1JEIC9mIC9kIDEgPk5VTCAyPiYxCgolcG93ZXJzaGVsbFBhdGglIC1FeGVjdXRpb25Qb2xpY3kgQnlwYXNzIC1Ob1Byb2ZpbGUgLUNvbW1hbmQgIkFkZC1UeXBlICcgdXNpbmcgU3lzdGVtOyB1c2luZyBTeXN0ZW0uSU87IHVzaW5nIFN5c3RlbS5SdW50aW1lLkludGVyb3BTZXJ2aWNlczsgdXNpbmcgTWljcm9zb2Z0LldpbjMyLlNhZmVIYW5kbGVzOyB1c2luZyBTeXN0ZW0uQ29tcG9uZW50TW9kZWw7IHB1YmxpYyBzdGF0aWMgY2xhc3MgRWxhbXsgW0RsbEltcG9ydChcIktlcm5lbDMyXCIsIENoYXJTZXQ9Q2hhclNldC5BdXRvLCBTZXRMYXN0RXJyb3I9dHJ1ZSldIHB1YmxpYyBzdGF0aWMgZXh0ZXJuIGJvb2wgSW5zdGFsbEVMQU1DZXJ0aWZpY2F0ZUluZm8oU2FmZUZpbGVIYW5kbGUgaGFuZGxlKTsgcHVibGljIHN0YXRpYyB2b2lkIEluc3RhbGxXZEJvb3Qoc3RyaW5nIHBhdGgpIHsgQ29uc29sZS5PdXQuV3JpdGVMaW5lKFwiQWJvdXQgdG8gY2FsbCBjcmVhdGUgZmlsZSBvbiB7MH1cIiwgcGF0aCk7IHZhciBzdHJlYW0gPSBGaWxlLk9wZW4ocGF0aCwgRmlsZU1vZGUuT3BlbiwgRmlsZUFjY2Vzcy5SZWFkLCBGaWxlU2hhcmUuUmVhZCk7IHZhciBoYW5kbGUgPSBzdHJlYW0uU2FmZUZpbGVIYW5kbGU7IENvbnNvbGUuT3V0LldyaXRlTGluZShcIkFib3V0IHRvIGNhbGwgSW5zdGFsbEVMQU1DZXJ0aWZpY2F0ZUluZm8gb24gaGFuZGxlIHswfVwiLCBoYW5kbGUuRGFuZ2Vyb3VzR2V0SGFuZGxlKCkpOyBpZiAoIUluc3RhbGxFTEFNQ2VydGlmaWNhdGVJbmZvKGhhbmRsZSkpIHsgQ29uc29sZS5PdXQuV3JpdGVMaW5lKFwiQ2FsbCBmYWlsZWQuXCIpOyB0aHJvdyBuZXcgV2luMzJFeGNlcHRpb24oTWFyc2hhbC5HZXRMYXN0V2luMzJFcnJvcigpKTsgfSBDb25zb2xlLk91dC5Xcml0ZUxpbmUoXCJDYWxsIHN1Y2Nlc3NmdWwuXCIpOyB9IH0gJzsgJGRyaXZlclBhdGggPSAkZW52OlN5c3RlbVJvb3QgKyAnXFN5c3RlbTMyXERyaXZlcnNcV2RCb290LnN5cyc7IFtFbGFtXTo6SW5zdGFsbFdkQm9vdCgkZHJpdmVyUGF0aCkgIiA+TlVMIDI+JjEKClJFRyBxdWVyeSAiSEtMTVxTT0ZUV0FSRVxQb2xpY2llc1xNaWNyb3NvZnRcV2luZG93cyBBZHZhbmNlZCBUaHJlYXQgUHJvdGVjdGlvbiIgL3YgNjk2QzFGQTEtNDAzMC00RkE0LTg3MTMtRkFGOUIyRUE3QzBBIC9yZWc6NjQgPiAlVE1QJVxzZW5zZVRtcC50eHQgMj4mMQppZiAlRVJST1JMRVZFTCUgRVFVIDAgKCAgCiAgICBSRUcgZGVsZXRlICJIS0xNXFNPRlRXQVJFXFBvbGljaWVzXE1pY3Jvc29mdFxXaW5kb3dzIEFkdmFuY2VkIFRocmVhdCBQcm90ZWN0aW9uIiAvdiA2OTZDMUZBMS00MDMwLTRGQTQtODcxMy1GQUY5QjJFQTdDMEEgL2YgPiAlVE1QJVxzZW5zZVRtcC50eHQgMj4mMQogICAgaWYgJUVSUk9STEVWRUwlIE5FUSAwICgKICAgICAgICBzZXQgImVycm9yRGVzY3JpcHRpb249VW5hYmxlIHRvIGRlbGV0ZSBwcmV2aW91cyBvZmZib2FyZGluZyBpbmZvcm1hdGlvbiBmcm9tIHJlZ2lzdHJ5LiIKICAgICAgICBzZXQgZXJyb3JDb2RlPTUKICAgICAgICBzZXQgbGFzdEVycm9yPSVFUlJPUkxFVkVMJQogICAgICAgIEdPVE8gRVJST1IKICAgICkKKQoKUkVHIGFkZCAiSEtMTVxTT0ZUV0FSRVxQb2xpY2llc1xNaWNyb3NvZnRcV2luZG93cyBBZHZhbmNlZCBUaHJlYXQgUHJvdGVjdGlvbiIgL3YgT25ib2FyZGluZ0luZm8gL3QgUkVHX1NaIC9mIC9kICJ7XCJib2R5XCI6XCJ7XFxcInByZXZpb3VzT3JnSWRzXFxcIjpbXSxcXFwib3JnSWRcXFwiOlxcXCIwMDAwMDAwMC0wMDAwLTAwMDAtMDAwMC0wMDAwMDAwMGRlYWRcXFwiLFxcXCJnZW9Mb2NhdGlvblVybFxcXCI6XFxcImh0dHBzOi8vc2V2aWxsZWNsb3VkZ2F0ZXdheS1zdGcubWljcm9zb2Z0LmNvbS9cXFwiLFxcXCJkYXRhY2VudGVyXFxcIjpcXFwiRWFzdFVzMlxcXCIsXFxcInZvcnRleEdlb0xvY2F0aW9uXFxcIjpcXFwiU2FuZGJveFxcXCIsXFxcInZlcnNpb25cXFwiOlxcXCIxLjNcXFwifVwiLFwic2lnXCI6XCJKc0dGR2o3UCtIL1cvUEExcW9LTml3RXROZkU4YkhGblhxeks1SDhsQ09wc0RnRGNWTWpoT3BmQTZJTTJ3RFZadk5kWGhvZ0dEQ1FDWjNYdFJCbHRkcGFWc3pZNGtINVpHVkdnRUQxVE80ZCtCTjk2VDFSa3pOZ2NjZ2ZCWDNNQUw1bllUWXdiMGlUQUtFMGIxb3BmQmZrMzJQN3Q3b3A5dkhPeXZNMW5qdlZybVdWWWVSNk4rZFFrLzM4UDNUY2V3b2FkRmFUb3pidjBZK3dZOHgrbFcxeWN6bk1KMitQWTlxRHpabXoybE1rd0FlaDJwRTI4VW5MT0lhNjg0Y3U5RitHUlAveGhhR3dQWmpoc1JCSW51cHV5U1E2Y09YdE9kSERCQlRaZzVKSEhHMDBkNk9tUk5ONmxBelJWeFJURUVmaFFUVnN0U1poKzNMSjJTMGhmZGc9PVwiLFwic2hhMjU2c2lnXCI6XCJsVGI4ZittdkFveDRCckxPS0lqejFnTTNrRHREbG9wL21uNmZodmVEWjMvblVqb1lhNk81V2p4R0x2Z3lqZ0RtdThETkdPNUtqWWlxTVZ6Z0QzcHdqOVYwOXVOeUdYNGJUaXN0d1BnQTFLbGMrMUFLcmtWQTRGWGlQTHlST2tXdlhLM2dydFFJWU9nYjdSRlh6dzhnQlB5YlV0Z0FWbmNaMVFpdTAzblFLdGh5MFU3aXBlZUxaVE9oYVlhN001cTJxUTcya1BaSTZWUWlqSE42NVg3UTEvcm5rdUlSUkFmUEErZElIeE4wN0tpSlY2MGZsbDFZUUtOUlpSYUhKeGQ1UDd0RmdaaytEZE5mNVNXcHVaSTZTZE9MdExDN3VnbmdnK0krU2pUeUtvcVFKZElkWGRRaE5JK3I3WEM1L1M0ZlhnRVNtWmZKTUYxL0JtVlVFZUJDZlE9PVwiLFwiY2VydFwiOlwiTUlJRjVqQ0NBODZnQXdJQkFnSVRNd0FBQVkwdmh1VTl6R2x5b1FBQUFBQUJqVEFOQmdrcWhraUc5dzBCQVFzRkFEQitNUXN3Q1FZRFZRUUdFd0pWVXpFVE1CRUdBMVVFQ0JNS1YyRnphR2x1WjNSdmJqRVFNQTRHQTFVRUJ4TUhVbVZrYlc5dVpERWVNQndHQTFVRUNoTVZUV2xqY205emIyWjBJRU52Y25CdmNtRjBhVzl1TVNnd0pnWURWUVFERXg5TmFXTnliM052Wm5RZ1UyVmpkWEpsSUZObGNuWmxjaUJEUVNBeU1ERXhNQjRYRFRJd01EZ3dOakl3TlRBMU9Gb1hEVEl4TURnd05qSXdOVEExT0Zvd2dZb3hDekFKQmdOVkJBWVRBbFZUTVFzd0NRWURWUVFJRXdKWFFURVFNQTRHQTFVRUJ4TUhVbVZrYlc5dVpERWVNQndHQTFVRUNoTVZUV2xqY205emIyWjBJRU52Y25CdmNtRjBhVzl1TVI0d0hBWURWUVFMRXhWTmFXTnliM052Wm5RZ1EyOXljRzl5WVhScGIyNHhIREFhQmdOVkJBTVRFMU5sZG1sc2JHVXVWMmx1Wkc5M2N5NWpiMjB3Z2dFaU1BMEdDU3FHU0liM0RRRUJBUVVBQTRJQkR3QXdnZ0VLQW9JQkFRRENmcWtCcmV1Um1qdm90bDFFdURQWVplaVc1dUVERmV6MXhsYmh6cjVaa1BjSUJYT3RIMVZWRjRaUmVrdTFpK3ZMbTNON2xkVGl4c2RSZW0yU09iVkFGb1dDbjZ2cEYwL1ZYcWpmUTJHbyt2dk9UU1Q0Si9pQWxocXhialVVbkRyWFpXYUMvS2xtU0lYMjlHUng5bG1pT0IrWVBhRzlOTEE1U3F3emNad2hjTThzS3F0VDhHaWQ3Q3JFNGs1WldES0gyL1dPVTVsQ01iZTY2MWtrbWxKZDB2TlBDTXpyMUgzVmNmRG1qVVo4Q25WQzBFODlhVVA3VHhhME1uS0FzVFArQkpCNXJMenhkVlJRbGRNbmhHVXNXRU0ydUNOWXFOdWc4QWYrTGp3RytySXZrSVR3NVlDMUZDZy9qVHBvdHJnSFhmSGRqaURqa0F3ZWY1TlVkTmx0QWdNQkFBR2pnZ0ZPTUlJQlNqQU9CZ05WSFE4QkFmOEVCQU1DQjRBd0V3WURWUjBsQkF3d0NnWUlLd1lCQlFVSEF3RXdIUVlEVlIwT0JCWUVGT0U1NVFoeno5bEhuWTl2aDVTWmtyMTdjbEtzTUI0R0ExVWRFUVFYTUJXQ0UxTmxkbWxzYkdVdVYybHVaRzkzY3k1amIyMHdId1lEVlIwakJCZ3dGb0FVTmxhSlpVbkxXNXN2UEt4Q0ZsQk5rYmt6MTVFd1V3WURWUjBmQkV3d1NqQklvRWFnUklaQ2FIUjBjRG92TDNkM2R5NXRhV055YjNOdlpuUXVZMjl0TDNCcmFXOXdjeTlqY213dlRXbGpVMlZqVTJWeVEwRXlNREV4WHpJd01URXRNVEF0TVRndVkzSnNNR0FHQ0NzR0FRVUZCd0VCQkZRd1VqQlFCZ2dyQmdFRkJRY3dBb1pFYUhSMGNEb3ZMM2QzZHk1dGFXTnliM052Wm5RdVkyOXRMM0JyYVc5d2N5OWpaWEowY3k5TmFXTlRaV05UWlhKRFFUSXdNVEZmTWpBeE1TMHhNQzB4T0M1amNuUXdEQVlEVlIwVEFRSC9CQUl3QURBTkJna3Foa2lHOXcwQkFRc0ZBQU9DQWdFQVp3ZGxhWjg4U3BURFdUUjc5NWRHV2N0dUxUWmc2UDBqYmh4Q0dhOXBnb3AzSXZ1Qi9QYzJXT2Ruc1ZCYUpUZG5WN3NvcFZHa3V4Vjc1eWk2Q0NQM2sxNG0xQ1FhNk01cmNodmJuVEY0TFdjWld4U1g4Z0hjRWhObFdYV3hxU3FKMzNnSHVGNEc5SCs3VDM3UlNMb2Jqb1MyeVRhc21SRWtCNTI4b1gwWVU0cVpjeVdyK0xEMVovQk10dEhMUlZUZUtHdnpMaVpCNmhqWURybW9qUUxKZXZwSEdoTVdOTU9oR2RLd2pOS0crZGhVRHV6dTdsVXgwZzdhaUR3c1l4NzFTaU9ucDJWOSt5UEhET2R5OXlBRUNPb0N3bUprbW5qLzlDMmVNMDFDQjFZMUxTWHNiQUJtQVd3Si9iczhRNnhTWlJtSnkyRXJSQ3VTakl0MUQydzRTUFVMRFNNVTdIaDk3TWJpQVJDV25TMVRRMGg5azZFWVVmbW1ZaFNHQ0p3MXFlekFqZ2FmTngyYWcrRDhzRFFkQzRjVHhUSTk5aGthUm1DakFmeW1qcVdscUx5V0pCUmdvaXdTd21MVDFUbzRJNUVjZHFoQ1FNdEpoRVVRR2dpenk2ZUE2RlhtNHhmeExua08xSkNKSGJUejlqL2c4OW5zZ0hVN2V4SDVnZHhZQ0FDMGJkUlZLN1YrVlBDcExnLy9SemtlNm9mc1Y3WkxyQUpvN0EyQTZka0dVL09XeGhpVjJiY0VlUEpmSWsrVjM3UHp3c25yZ1JFV2RpM1pic3dBOU5aTTVzZGVSMFlFRm11bit0b2JCRGMzMlRidlVyTUpTb2tjcG9XNnRZczlkR0tUcE1GV01EZ09UeEZjSHljbHZrMjRVQVV2dXk2WVcvSVN2VlY4a3BRPVwiLFwiY2hhaW5cIjpbXCJNSUlHMkRDQ0JNQ2dBd0lCQWdJS1lUKzNHQUFBQUFBQUJEQU5CZ2txaGtpRzl3MEJBUXNGQURDQmlERUxNQWtHQTFVRUJoTUNWVk14RXpBUkJnTlZCQWdUQ2xkaGMyaHBibWQwYjI0eEVEQU9CZ05WQkFjVEIxSmxaRzF2Ym1ReEhqQWNCZ05WQkFvVEZVMXBZM0p2YzI5bWRDQkRiM0p3YjNKaGRHbHZiakV5TURBR0ExVUVBeE1wVFdsamNtOXpiMlowSUZKdmIzUWdRMlZ5ZEdsbWFXTmhkR1VnUVhWMGFHOXlhWFI1SURJd01URXdIaGNOTVRFeE1ERTRNakkxTlRFNVdoY05Nall4TURFNE1qTXdOVEU1V2pCK01Rc3dDUVlEVlFRR0V3SlZVekVUTUJFR0ExVUVDQk1LVjJGemFHbHVaM1J2YmpFUU1BNEdBMVVFQnhNSFVtVmtiVzl1WkRFZU1Cd0dBMVVFQ2hNVlRXbGpjbTl6YjJaMElFTnZjbkJ2Y21GMGFXOXVNU2d3SmdZRFZRUURFeDlOYVdOeWIzTnZablFnVTJWamRYSmxJRk5sY25abGNpQkRRU0F5TURFeE1JSUNJakFOQmdrcWhraUc5dzBCQVFFRkFBT0NBZzhBTUlJQ0NnS0NBZ0VBMEF2QXBLZ1pnZUkyNWVLcTVmT3lGVmgxdnJUbFNmSGdoUG03RFdUdmhjR0JWYmp6NS9GdFFGVTl6b3RxMFlTVDlYVjhXNlRVZEJES012TWowNjd1ejU0RVdNTFpSOHZSZkFCQlNIRWJBV2NYR0svRy9uTURmdVR2UTV6dkFYRXFINEVtUTNlWVZGZHpuVlVyOEo2T2ZRWU9yQnRVOHliMytDTUlJb3VlQmgwM09QMXkwc3JsWThHYVduMnliYk5TcVc3cHJyWDhpemI1bnZyMkhGZ2JsMWFsRWVXM1V0dTc2ZkJVdjdUL0xHeTRYU2JPb0FyWDM1UHRmOTJzOFN4ekd0a1pOMVc2M1NKNGpxSFVtd240QnlJeGNiQ1VydUN3NXlaRVY1Q0JseFhPWWV4bDRrdnhoVklXTXZpMWVLcCt6VTNzZ3lHa3FKdSttbW9FNEtNY3pWWVliUDFyTDBJKzRqZnljcXZRZUhOeWU5N3NBRmpsSVRDakNEcVo3NS9EOTNvV2xtVzF3NEd2OURsd1NhLzJxZlpxQURqNXRBZ1o0Qm8xcFZaMklsOXE4bW11UHExWVJrMjRWUGFKUVVRZWNyRzhFaWRUMHNIL3NzMVFtQjYxOUx1MndvSTUyYXdiOGpzbmhHcXd4aVlMMXpvUTU3UGJmTk5XckZOTUMvbzdNVGQwMkZrcitRQjVHUVo3L1J3ZFF0UkJEUzhGRHRWclNTUC96ODM0ZW9MUDJqd3QzK2pZRWdRWXVoNklkN2lZSHhBSHU4Z0ZmZ3NKdjJ2ZDQwNWJzUG5IaEtZN3lreWZXMklwOThlaXFKV0ljQ3psd1Q4OFVpTlBRSnJETVlXREw3OHA4UjFRanlHV0I4N3Y4b0RDUkgyYll1OHZ3M2VKcTBWTlV6NENlZE1DQXdFQUFhT0NBVXN3Z2dGSE1CQUdDU3NHQVFRQmdqY1ZBUVFEQWdFQU1CMEdBMVVkRGdRV0JCUTJWb2xsU2N0Ym15ODhyRUlXVUUyUnVUUFhrVEFaQmdrckJnRUVBWUkzRkFJRURCNEtBRk1BZFFCaUFFTUFRVEFMQmdOVkhROEVCQU1DQVlZd0R3WURWUjBUQVFIL0JBVXdBd0VCL3pBZkJnTlZIU01FR0RBV2dCUnlMVG9DTVpCRHVSUUZUdUhxcDhjeDBTT0pOREJhQmdOVkhSOEVVekJSTUUrZ1RhQkxoa2xvZEhSd09pOHZZM0pzTG0xcFkzSnZjMjltZEM1amIyMHZjR3RwTDJOeWJDOXdjbTlrZFdOMGN5OU5hV05TYjI5RFpYSkJkWFF5TURFeFh6SXdNVEZmTUROZk1qSXVZM0pzTUY0R0NDc0dBUVVGQndFQkJGSXdVREJPQmdnckJnRUZCUWN3QW9aQ2FIUjBjRG92TDNkM2R5NXRhV055YjNOdlpuUXVZMjl0TDNCcmFTOWpaWEowY3k5TmFXTlNiMjlEWlhKQmRYUXlNREV4WHpJd01URmZNRE5mTWpJdVkzSjBNQTBHQ1NxR1NJYjNEUUVCQ3dVQUE0SUNBUUJCeUdIQjlWdWVQcEV4OGJER3Z3a0J0SjIya0hUWENkdW1MZzJmeU9kMk5FYXZCMkNKVElHelBOWDBFalYxd25PbDlVMkVqTXVrWGErL2t2WVhDRmRDbFhKbEJYWjVyZTdSdXJndVZLTlJCNnhvNnlFTTR5V0J3czBxOHNQL3o4SzlTUmlheC9DRXhma1V2R3VWNVpidnMwTFNVOVZLb0JMRXJoSjJVd2xXRHAzMzA2WkppRkR5aWl5WElLSytUbmp2QldXM1M2RVdpTjR4eHdoQ0pIeWtlNTZkdkdBQVhtS1g0NVA4cC81YmV5WGY1Rk4vUzc3bVB2RGJBWGxDSEc2RmJIMjJSREQ3cFRlU2s3S2w3aUN0UDFQVnlmUW9hMWZCK0IxcXQxWXF0aWVCSEtZdG4rZjAwREdEbDZncXRxeStHMEgxNUlsZlZ2dmFXdE5lZlZXVUVINVRWL1JLUFVBcXlMMW5uNFRoRU83OTJtc1Zna244UmgzL1JRWjBuRUlVN2NVNTA3UE5DNE1ua0VOUmt2SkVncTV1bWhVWHNobjZ4MFZzbUFGN3Z6ZXBzSWlra3J3NE9PQWQ1SHlYbUJvdVgrODRaYmMxTDcxL1R5SDZ4SXpTYndiNVNUWHEzeUFQSmFycVlLc3NIMHVKL0xmNlhGU1FTejZpS0U5czVGSmx3ZjJRSElXQ2lHN3BwbFhkSVNoNVJiQVU1UXJNNWwvRXU5dGhOR21mckNZNDk4RXBRUWdWTGt5Zzkva01QdDVmcXdnSkxZT3NyRFNEWXZUSlNVS0pKYlZ1c2tmRnN6bWdzU0FiTExHT0JHK2xNRWtjMEVicFFGdjByVzY2MjRKS2h4SktnQWxOMjk5MnVRVmJHK0M3SUhCZkFDWEgwdzc2RnExN0lwNXhDQT09XCIsXCJNSUlGN1RDQ0E5V2dBd0lCQWdJUVA0dkl0Znlmc3BaRHRXbldiRUxoUkRBTkJna3Foa2lHOXcwQkFRc0ZBRENCaURFTE1Ba0dBMVVFQmhNQ1ZWTXhFekFSQmdOVkJBZ1RDbGRoYzJocGJtZDBiMjR4RURBT0JnTlZCQWNUQjFKbFpHMXZibVF4SGpBY0JnTlZCQW9URlUxcFkzSnZjMjltZENCRGIzSndiM0poZEdsdmJqRXlNREFHQTFVRUF4TXBUV2xqY205emIyWjBJRkp2YjNRZ1EyVnlkR2xtYVdOaGRHVWdRWFYwYUc5eWFYUjVJREl3TVRFd0hoY05NVEV3TXpJeU1qSXdOVEk0V2hjTk16WXdNekl5TWpJeE16QTBXakNCaURFTE1Ba0dBMVVFQmhNQ1ZWTXhFekFSQmdOVkJBZ1RDbGRoYzJocGJtZDBiMjR4RURBT0JnTlZCQWNUQjFKbFpHMXZibVF4SGpBY0JnTlZCQW9URlUxcFkzSnZjMjltZENCRGIzSndiM0poZEdsdmJqRXlNREFHQTFVRUF4TXBUV2xqY205emIyWjBJRkp2YjNRZ1EyVnlkR2xtYVdOaGRHVWdRWFYwYUc5eWFYUjVJREl3TVRFd2dnSWlNQTBHQ1NxR1NJYjNEUUVCQVFVQUE0SUNEd0F3Z2dJS0FvSUNBUUN5Z0VHcU5UaE5FM0l5YUNKTnVMTHgvOVZTdkd6SDlkSktqRGJ1MGNKY2ZveUtycThUS0cvQWMrTTZ6dEFscUZvNmJlK291Rm1yRXlOb3pRd3BoOUZ2Z0Z5UFJIOWRrQUZTV0t4UnhWOHFoOXpjMkFvZHdRTzVlN0JXNktQZVpHSENudmp6Zkxuc0RiVlUva3kyWlUrSThKeEltUXhDQ3dsOE1Wa1hlUVo0S0kySk9rd0RKYjV4YWx3TDU0UmdwSmtpNDlLdmhLU24rOUdZN1F5cDNwU0o0UTZnM01ET21UM3FDRks3Vm5ua0g0UzZIcmkweEVsY1R6RkxoOTNkQldjbW1ZRGdjUkdqdUtWQjRxUlR1ZmN5S1lNTUU3ODJYZ1N6UzBOSEwydmlrUjdUbUUvZFFnZkk2QjBTL0ptcGF6NlNmc2pXYVRyOFpMMjJDWjNLL1F3TG9wdDNZRXNEbEtRd2FSTFdRaTNCUVV6SzNLcjlqMXVEUnByWi9MSFI0N1BKZjBoNnpTVHdRWTljZE5Dc3NCQWdCa20zeHkwaHlGZmowSWJ6QTJqNzBNNXh3WW1aU21RQmJQM3NNSkhQUVR5U3grVzZoaDFoaE1kZmd6bGlyclNTTDBmekMvaFY2NkFmV2RDN2RKc2UwSGJtOHVrRzF4RG8rbVRlYWNZMWxvZ0M4RWE0UHllWmI4dHhpU2sxOTBnV0FqV1AxWGw4VFFMUFgrdUtnMDlGY1lqNXFRMU9jdW5DbkFmUFNSdE9CQTVqVVl4ZTJBREJWU3kyeHVEQ1pVN0pORG4xbkxQRWZ1aGhiaE5mRmNSZjJYN3RIYzd1Uk96TExvYXg3RGoyY08yclhCUEIyUThOeDRDeVZlMDA5NnliNU1QYTUwYzhwcldQTWQvRlM2L3I4UUlEQVFBQm8xRXdUekFMQmdOVkhROEVCQU1DQVlZd0R3WURWUjBUQVFIL0JBVXdBd0VCL3pBZEJnTlZIUTRFRmdRVWNpMDZBakdRUTdrVUJVN2g2cWZITWRFamlUUXdFQVlKS3dZQkJBR0NOeFVCQkFNQ0FRQXdEUVlKS29aSWh2Y05BUUVMQlFBRGdnSUJBSDl5encrM3hSWGJtOEJKeWlaYi9wNFQ1dFB3MHR1WFgvSkxQMDJ6cmhtdTdkZVhvS3p2cVRxandrR3c1YmlSbmhPQkpBUG1DZjAvVjBBNUlTUlcwUkF2UzBDcE5vWkx0Rk5YbXZ2eGZvbVBFZjRZYkZHcTZPMEpsYlhsY2NtaDZZZDFwaFYveVg0M1ZGNTBrOFhEWjh3TlQydW9Gd3h0Q0pKK2k5MkJxaTF3SWNNOUJoUzd2eVJlcDRUWFB3OGhJcjFMQUFiYmx4ellYdFRGQzF5SGJsQ2s2TU00cFB2TExNV1NacHVGWHN0NmJKTjhnQ2xZVzFlMVFHbTZDSG1tWkdJVm5ZZVdSYlZtSXlBRGl4eHpvTk9pZVRQZ1VGbUcyeS9sQWlYcWN5cWZBQlRJTnNlU08rbE9BT3pZVmdtNU0wa1MwbFFMQWF1c1I3YVJLWDFNdEhXQVVnSG95b0wybjh5c25JOFg2aThtc0t0eXJBditubEVleDBOVlowOVJzMWZXdHV6dVVyYzY2VTdoMTRHSXZFK09kYnRMcVBBMXFpYlVaMmRKc25CTU81UGNIZDk0a0laeXNqaWswZHlTVGNsWTZ5c1NYTlE3cm94cnNJUGxBVC80Q1RMMmt6VTBJcS9kTncxM0NZQXJ6VWdBOFl5WkdVY0ZBZW5SdjlGTzBPWW9RemVacEFwS0NObWFjWFBTcXMweEUyTjJvVGR2a2pnZWZSSThaakxueTIzaC9GS0ozY3JXWmdXYWxtRytvaWpISEtPbk5sQThPcVRmU203bWh6dk82L0RnZ1RlZEV6eFNqcjI1SFRUR0hkVUthajJZS1hDTWlTclJxNElRU0IvYzlPK2x4YnRWR2poamhFNjNiSzJWVk94bEloQkpGN2pBSHNjUHJGUkhcIl19IiA+ICVUTVAlXHNlbnNlVG1wLnR4dCAyPiYxCmlmICVFUlJPUkxFVkVMJSBORVEgMCAoCiAgIHNldCAiZXJyb3JEZXNjcmlwdGlvbj1VbmFibGUgdG8gd3JpdGUgb25ib2FyZGluZyBpbmZvcm1hdGlvbiB0byByZWdpc3RyeS4iCiAgIHNldCBlcnJvckNvZGU9MTAKICAgc2V0IGxhc3RFcnJvcj0lRVJST1JMRVZFTCUKICAgR09UTyBFUlJPUgopCgplY2hvIFN0YXJ0aW5nIHRoZSBzZXJ2aWNlLCBpZiBub3QgYWxyZWFkeSBydW5uaW5nID5OVUwgMj4mMQplY2hvLiA+TlVMIDI+JjEKc2MgcXVlcnkgIlNFTlNFIiB8IGZpbmQgL2kgIlJVTk5JTkciID5OVUwgMj4mMQppZiAlRVJST1JMRVZFTCUgRVFVIDAgR09UTyBSVU5OSU5HCgpuZXQgc3RhcnQgc2Vuc2UgPiAlVE1QJVxzZW5zZVRtcC50eHQgMj4mMQppZiAlRVJST1JMRVZFTCUgTkVRIDAgKAogICBlY2hvIFdpbmRvd3MgRGVmZW5kZXIgQWR2YW5jZWQgVGhyZWF0IFByb3RlY3Rpb24gU2VydmljZSBoYXMgbm90IHN0YXJ0ZWQgeWV0ID5OVUwgMj4mMQogICBHT1RPIFdBSVRfRk9SX1RIRV9TRVJWSUNFX1RPX1NUQVJUCikKZ290byBTVUNDRUVERUQKCjpSVU5OSU5HCnNldCAicnVubmluZ091dHB1dD1UaGUgV2luZG93cyBEZWZlbmRlciBBZHZhbmNlZCBUaHJlYXQgUHJvdGVjdGlvbiBTZXJ2aWNlIGlzIGFscmVhZHkgcnVubmluZyEiCmVjaG8gJXJ1bm5pbmdPdXRwdXQlID5OVUwgMj4mMQplY2hvLiA+TlVMIDI+JjEKZXZlbnRjcmVhdGUgL2wgQXBwbGljYXRpb24gL3NvIFdEQVRQT25ib2FyZGluZyAvdCBJbmZvcm1hdGlvbiAvaWQgMTAgL2QgIiVydW5uaW5nT3V0cHV0JSIgPk5VTCAyPiYxCkdPVE8gV0FJVF9GT1JfVEhFX1NFUlZJQ0VfVE9fU1RBUlQKCjpFUlJPUgpTZXQgL1AgZXJyb3JNc2c9PCVUTVAlXHNlbnNlVG1wLnR4dApzZXQgImVycm9yT3V0cHV0PVtFcnJvciBJZDogJWVycm9yQ29kZSUsIEVycm9yIExldmVsOiAlbGFzdEVycm9yJV0gJWVycm9yRGVzY3JpcHRpb24lIEVycm9yIG1lc3NhZ2U6ICVlcnJvck1zZyUiCiVwb3dlcnNoZWxsUGF0aCUgLUV4ZWN1dGlvblBvbGljeSBCeXBhc3MgLU5vUHJvZmlsZSAtQ29tbWFuZCAiQWRkLVR5cGUgJ3VzaW5nIFN5c3RlbTsgdXNpbmcgU3lzdGVtLkRpYWdub3N0aWNzOyB1c2luZyBTeXN0ZW0uRGlhZ25vc3RpY3MuVHJhY2luZzsgbmFtZXNwYWNlIFNlbnNlIHsgW0V2ZW50RGF0YShOYW1lID0gXCJPbmJvYXJkaW5nXCIpXXB1YmxpYyBzdHJ1Y3QgT25ib2FyZGluZ3twdWJsaWMgc3RyaW5nIE1lc3NhZ2UgeyBnZXQ7IHNldDsgfX0gcHVibGljIGNsYXNzIFRyYWNlIHtwdWJsaWMgc3RhdGljIEV2ZW50U291cmNlT3B0aW9ucyBUZWxlbWV0cnlDcml0aWNhbE9wdGlvbiA9IG5ldyBFdmVudFNvdXJjZU9wdGlvbnMoKXtMZXZlbCA9IEV2ZW50TGV2ZWwuRXJyb3IsIEtleXdvcmRzID0gKEV2ZW50S2V5d29yZHMpMHgwMDAwMjAwMDAwMDAwMDAwLCBUYWdzID0gKEV2ZW50VGFncykweDAyMDAwMDB9OyBwdWJsaWMgdm9pZCBXcml0ZU9uYm9hcmRpbmdNZXNzYWdlKHN0cmluZyBtZXNzYWdlKXtlcy5Xcml0ZShcIk9uYm9hcmRpbmdTY3JpcHRcIiwgVGVsZW1ldHJ5Q3JpdGljYWxPcHRpb24sIG5ldyBPbmJvYXJkaW5nIHtNZXNzYWdlID0gbWVzc2FnZX0pO30gcHJpdmF0ZSBzdGF0aWMgcmVhZG9ubHkgc3RyaW5nW10gdGVsZW1ldHJ5VHJhaXRzID0geyBcIkVUV19HUk9VUFwiLCBcIns1RUNCMEJBQy1COTMwLTQ3RjUtQThBNC1FODI1MzUyOUVEQjd9XCIgfTsgcHJpdmF0ZSBFdmVudFNvdXJjZSBlcyA9IG5ldyBFdmVudFNvdXJjZShcIk1pY3Jvc29mdC5XaW5kb3dzLlNlbnNlLkNsaWVudC5NYW5hZ2VtZW50XCIsRXZlbnRTb3VyY2VTZXR0aW5ncy5FdHdTZWxmRGVzY3JpYmluZ0V2ZW50Rm9ybWF0LHRlbGVtZXRyeVRyYWl0cyk7fX0nOyAkbG9nZ2VyID0gTmV3LU9iamVjdCAtVHlwZU5hbWUgU2Vuc2UuVHJhY2U7ICRsb2dnZXIuV3JpdGVPbmJvYXJkaW5nTWVzc2FnZSgnJWVycm9yT3V0cHV0JScpIiA+TlVMIDI+JjEKZWNobyAlZXJyb3JPdXRwdXQlID5OVUwgMj4mMQplY2hvLiA+TlVMIDI+JjEKZXZlbnRjcmVhdGUgL2wgQXBwbGljYXRpb24gL3NvIFdEQVRQT25ib2FyZGluZyAvdCBFcnJvciAvaWQgJWVycm9yQ29kZSUgL2QgIiVlcnJvck91dHB1dCUiID5OVUwgMj4mMQpHT1RPIENMRUFOVVAKCjpTVUNDRUVERUQKZWNobyBGaW5pc2hlZCBwZXJmb3JtaW5nIG9uYm9hcmRpbmcgb3BlcmF0aW9ucyA+TlVMIDI+JjEKZWNoby4gPk5VTCAyPiYxCkdPVE8gV0FJVF9GT1JfVEhFX1NFUlZJQ0VfVE9fU1RBUlQKCjpXQUlUX0ZPUl9USEVfU0VSVklDRV9UT19TVEFSVAplY2hvIFdhaXRpbmcgZm9yIHRoZSBzZXJ2aWNlIHRvIHN0YXJ0ID5OVUwgMj4mMQplY2hvLiA+TlVMIDI+JjEKCnNldCAvYSBjb3VudGVyPTAKCjpTRU5TRV9SVU5OSU5HX1dBSVQKc2MgcXVlcnkgIlNFTlNFIiB8IGZpbmQgL2kgIlJVTk5JTkciID5OVUwgMj4mMQppZiAlRVJST1JMRVZFTCUgTkVRIDAgKAoJSUYgJWNvdW50ZXIlIEVRVSA0ICgKCQlzZXQgImVycm9yRGVzY3JpcHRpb249VW5hYmxlIHRvIHN0YXJ0IFdpbmRvd3MgRGVmZW5kZXIgQWR2YW5jZWQgVGhyZWF0IFByb3RlY3Rpb24gU2VydmljZS4iCgkJc2V0IGVycm9yQ29kZT0xNQoJCXNldCBsYXN0RXJyb3I9JUVSUk9STEVWRUwlCgkJR09UTyBFUlJPUgoJKQoKCXNldCAvYSBjb3VudGVyPSVjb3VudGVyJSsxCgoJdGltZW91dCA1ID5OVUwgMj4mMQoJR09UTyA6U0VOU0VfUlVOTklOR19XQUlUCikKCnNldCAvYSBjb3VudGVyPTAKCjpTRU5TRV9PTkJPQVJERURfU1RBVFVTX1dBSVQKUkVHIHF1ZXJ5ICJIS0xNXFNPRlRXQVJFXE1pY3Jvc29mdFxXaW5kb3dzIEFkdmFuY2VkIFRocmVhdCBQcm90ZWN0aW9uXFN0YXR1cyIgL3YgT25ib2FyZGluZ1N0YXRlIC9yZWc6NjQgPk5VTCAyPiYxCmlmICVFUlJPUkxFVkVMJSBORVEgMCAoCglJRiAlY291bnRlciUgRVFVIDQgKAoJCUBlY2hvIFdpbmRvd3MgRGVmZW5kZXIgQWR2YW5jZWQgVGhyZWF0IFByb3RlY3Rpb24gU2VydmljZSBpcyBub3QgcnVubmluZyBhcyBleHBlY3RlZD4gJVRNUCVcc2Vuc2VUbXAudHh0CgkJc2V0IGVycm9yQ29kZT0zNQogICAgIHNldCBsYXN0RXJyb3I9JUVSUk9STEVWRUwlCgkJR09UTyBFUlJPUgoJKQoKCXNldCAvYSBjb3VudGVyPSVjb3VudGVyJSsxCgoJdGltZW91dCA1ID5OVUwgMj4mMQoJR09UTyA6U0VOU0VfT05CT0FSREVEX1NUQVRVU19XQUlUCikKCnNldCAvYSBjb3VudGVyPTAKCjpTRU5TRV9PTkJPQVJERURfV0FJVApSRUcgcXVlcnkgIkhLTE1cU09GVFdBUkVcTWljcm9zb2Z0XFdpbmRvd3MgQWR2YW5jZWQgVGhyZWF0IFByb3RlY3Rpb25cU3RhdHVzIiAvdiBPbmJvYXJkaW5nU3RhdGUgL3JlZzo2NCB8IGZpbmQgL2kgIjB4MSIgPk5VTCAyPiYxCmlmICVFUlJPUkxFVkVMJSBORVEgMCAoCglJRiAlY291bnRlciUgRVFVIDQgKAoJCUBlY2hvIFdpbmRvd3MgRGVmZW5kZXIgQWR2YW5jZWQgVGhyZWF0IFByb3RlY3Rpb24gU2VydmljZSBpcyBub3QgcnVubmluZyBhcyBleHBlY3RlZD4gJVRNUCVcc2Vuc2VUbXAudHh0CgkJc2V0IGVycm9yQ29kZT00MAogICAgIHNldCBsYXN0RXJyb3I9JUVSUk9STEVWRUwlCgkJR09UTyBFUlJPUgoJKQoKCXNldCAvYSBjb3VudGVyPSVjb3VudGVyJSsxCgoJdGltZW91dCA1ID5OVUwgMj4mMQoJR09UTyA6U0VOU0VfT05CT0FSREVEX1dBSVQKKQoKc2V0ICJzdWNjZXNzT3V0cHV0PVN1Y2Nlc3NmdWxseSBvbmJvYXJkZWQgbWFjaGluZSB0byBXaW5kb3dzIERlZmVuZGVyIEFkdmFuY2VkIFRocmVhdCBQcm90ZWN0aW9uIgplY2hvICVzdWNjZXNzT3V0cHV0JSA+TlVMIDI+JjEKZWNoby4KZXZlbnRjcmVhdGUgL2wgQXBwbGljYXRpb24gL3NvIFdEQVRQT25ib2FyZGluZyAvdCBJbmZvcm1hdGlvbiAvaWQgMjAgL2QgIiVzdWNjZXNzT3V0cHV0JSIgPk5VTCAyPiYxCiVwb3dlcnNoZWxsUGF0aCUgLUV4ZWN1dGlvblBvbGljeSBCeXBhc3MgLU5vUHJvZmlsZSAtQ29tbWFuZCAiQWRkLVR5cGUgJ3VzaW5nIFN5c3RlbTsgdXNpbmcgU3lzdGVtLkRpYWdub3N0aWNzOyB1c2luZyBTeXN0ZW0uRGlhZ25vc3RpY3MuVHJhY2luZzsgbmFtZXNwYWNlIFNlbnNlIHsgW0V2ZW50RGF0YShOYW1lID0gXCJPbmJvYXJkaW5nXCIpXXB1YmxpYyBzdHJ1Y3QgT25ib2FyZGluZ3twdWJsaWMgc3RyaW5nIE1lc3NhZ2UgeyBnZXQ7IHNldDsgfX0gcHVibGljIGNsYXNzIFRyYWNlIHtwdWJsaWMgc3RhdGljIEV2ZW50U291cmNlT3B0aW9ucyBUZWxlbWV0cnlDcml0aWNhbE9wdGlvbiA9IG5ldyBFdmVudFNvdXJjZU9wdGlvbnMoKXtMZXZlbCA9IEV2ZW50TGV2ZWwuSW5mb3JtYXRpb25hbCwgS2V5d29yZHMgPSAoRXZlbnRLZXl3b3JkcykweDAwMDAyMDAwMDAwMDAwMDAsIFRhZ3MgPSAoRXZlbnRUYWdzKTB4MDIwMDAwMH07IHB1YmxpYyB2b2lkIFdyaXRlT25ib2FyZGluZ01lc3NhZ2Uoc3RyaW5nIG1lc3NhZ2Upe2VzLldyaXRlKFwiT25ib2FyZGluZ1NjcmlwdFwiLCBUZWxlbWV0cnlDcml0aWNhbE9wdGlvbiwgbmV3IE9uYm9hcmRpbmcge01lc3NhZ2UgPSBtZXNzYWdlfSk7fSBwcml2YXRlIHN0YXRpYyByZWFkb25seSBzdHJpbmdbXSB0ZWxlbWV0cnlUcmFpdHMgPSB7IFwiRVRXX0dST1VQXCIsIFwiezVFQ0IwQkFDLUI5MzAtNDdGNS1BOEE0LUU4MjUzNTI5RURCN31cIiB9OyBwcml2YXRlIEV2ZW50U291cmNlIGVzID0gbmV3IEV2ZW50U291cmNlKFwiTWljcm9zb2Z0LldpbmRvd3MuU2Vuc2UuQ2xpZW50Lk1hbmFnZW1lbnRcIixFdmVudFNvdXJjZVNldHRpbmdzLkV0d1NlbGZEZXNjcmliaW5nRXZlbnRGb3JtYXQsdGVsZW1ldHJ5VHJhaXRzKTt9fSc7ICRsb2dnZXIgPSBOZXctT2JqZWN0IC1UeXBlTmFtZSBTZW5zZS5UcmFjZTsgJGxvZ2dlci5Xcml0ZU9uYm9hcmRpbmdNZXNzYWdlKCclc3VjY2Vzc091dHB1dCUnKSIgPk5VTCAyPiYxCiIlUFJPR1JBTUZJTEVTJVxXaW5kb3dzIERlZmVuZGVyXE1wQ21kUnVuLmV4ZSIgLVJlbG9hZEVuZ2luZSA+TlVMIDI+JjEKCkdPVE8gQ0xFQU5VUAoKOkNMRUFOVVAKaWYgZXhpc3QgJVRNUCVcc2Vuc2VUbXAudHh0IGRlbCAlVE1QJVxzZW5zZVRtcC50eHQKRVhJVCAvQiAlZXJyb3JDb2RlJQo=="),
	// 				OnboardingPackageWindows: []byte("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"),
	// 			},
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/preview/2021-10-01-preview/examples/MdeOnboardings/GetMdeOnboardings_example.json
func ExampleMdeOnboardingsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMdeOnboardingsClient().Get(ctx, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.MdeOnboardingData = armsecurity.MdeOnboardingData{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.Security/mdeOnboardings"),
	// 	ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/providers/Microsoft.Security/mdeOnboardings/default"),
	// 	Properties: &armsecurity.MdeOnboardingDataProperties{
	// 		OnboardingPackageLinux: []byte("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"),
	// 		OnboardingPackageWindows: []byte("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"),
	// 	},
	// }
}
