//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
	"net/http"
	"net/url"
	"regexp"
)

// TasksServer is a fake server for instances of the armsecurity.TasksClient type.
type TasksServer struct {
	// GetResourceGroupLevelTask is the fake for method TasksClient.GetResourceGroupLevelTask
	// HTTP status codes to indicate success: http.StatusOK
	GetResourceGroupLevelTask func(ctx context.Context, resourceGroupName string, ascLocation string, taskName string, options *armsecurity.TasksClientGetResourceGroupLevelTaskOptions) (resp azfake.Responder[armsecurity.TasksClientGetResourceGroupLevelTaskResponse], errResp azfake.ErrorResponder)

	// GetSubscriptionLevelTask is the fake for method TasksClient.GetSubscriptionLevelTask
	// HTTP status codes to indicate success: http.StatusOK
	GetSubscriptionLevelTask func(ctx context.Context, ascLocation string, taskName string, options *armsecurity.TasksClientGetSubscriptionLevelTaskOptions) (resp azfake.Responder[armsecurity.TasksClientGetSubscriptionLevelTaskResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method TasksClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armsecurity.TasksClientListOptions) (resp azfake.PagerResponder[armsecurity.TasksClientListResponse])

	// NewListByHomeRegionPager is the fake for method TasksClient.NewListByHomeRegionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByHomeRegionPager func(ascLocation string, options *armsecurity.TasksClientListByHomeRegionOptions) (resp azfake.PagerResponder[armsecurity.TasksClientListByHomeRegionResponse])

	// NewListByResourceGroupPager is the fake for method TasksClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, ascLocation string, options *armsecurity.TasksClientListByResourceGroupOptions) (resp azfake.PagerResponder[armsecurity.TasksClientListByResourceGroupResponse])

	// UpdateResourceGroupLevelTaskState is the fake for method TasksClient.UpdateResourceGroupLevelTaskState
	// HTTP status codes to indicate success: http.StatusNoContent
	UpdateResourceGroupLevelTaskState func(ctx context.Context, resourceGroupName string, ascLocation string, taskName string, taskUpdateActionType armsecurity.TaskUpdateActionType, options *armsecurity.TasksClientUpdateResourceGroupLevelTaskStateOptions) (resp azfake.Responder[armsecurity.TasksClientUpdateResourceGroupLevelTaskStateResponse], errResp azfake.ErrorResponder)

	// UpdateSubscriptionLevelTaskState is the fake for method TasksClient.UpdateSubscriptionLevelTaskState
	// HTTP status codes to indicate success: http.StatusNoContent
	UpdateSubscriptionLevelTaskState func(ctx context.Context, ascLocation string, taskName string, taskUpdateActionType armsecurity.TaskUpdateActionType, options *armsecurity.TasksClientUpdateSubscriptionLevelTaskStateOptions) (resp azfake.Responder[armsecurity.TasksClientUpdateSubscriptionLevelTaskStateResponse], errResp azfake.ErrorResponder)
}

// NewTasksServerTransport creates a new instance of TasksServerTransport with the provided implementation.
// The returned TasksServerTransport instance is connected to an instance of armsecurity.TasksClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewTasksServerTransport(srv *TasksServer) *TasksServerTransport {
	return &TasksServerTransport{
		srv:                         srv,
		newListPager:                newTracker[azfake.PagerResponder[armsecurity.TasksClientListResponse]](),
		newListByHomeRegionPager:    newTracker[azfake.PagerResponder[armsecurity.TasksClientListByHomeRegionResponse]](),
		newListByResourceGroupPager: newTracker[azfake.PagerResponder[armsecurity.TasksClientListByResourceGroupResponse]](),
	}
}

// TasksServerTransport connects instances of armsecurity.TasksClient to instances of TasksServer.
// Don't use this type directly, use NewTasksServerTransport instead.
type TasksServerTransport struct {
	srv                         *TasksServer
	newListPager                *tracker[azfake.PagerResponder[armsecurity.TasksClientListResponse]]
	newListByHomeRegionPager    *tracker[azfake.PagerResponder[armsecurity.TasksClientListByHomeRegionResponse]]
	newListByResourceGroupPager *tracker[azfake.PagerResponder[armsecurity.TasksClientListByResourceGroupResponse]]
}

// Do implements the policy.Transporter interface for TasksServerTransport.
func (t *TasksServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "TasksClient.GetResourceGroupLevelTask":
		resp, err = t.dispatchGetResourceGroupLevelTask(req)
	case "TasksClient.GetSubscriptionLevelTask":
		resp, err = t.dispatchGetSubscriptionLevelTask(req)
	case "TasksClient.NewListPager":
		resp, err = t.dispatchNewListPager(req)
	case "TasksClient.NewListByHomeRegionPager":
		resp, err = t.dispatchNewListByHomeRegionPager(req)
	case "TasksClient.NewListByResourceGroupPager":
		resp, err = t.dispatchNewListByResourceGroupPager(req)
	case "TasksClient.UpdateResourceGroupLevelTaskState":
		resp, err = t.dispatchUpdateResourceGroupLevelTaskState(req)
	case "TasksClient.UpdateSubscriptionLevelTaskState":
		resp, err = t.dispatchUpdateSubscriptionLevelTaskState(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (t *TasksServerTransport) dispatchGetResourceGroupLevelTask(req *http.Request) (*http.Response, error) {
	if t.srv.GetResourceGroupLevelTask == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetResourceGroupLevelTask not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/locations/(?P<ascLocation>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tasks/(?P<taskName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	ascLocationParam, err := url.PathUnescape(matches[regex.SubexpIndex("ascLocation")])
	if err != nil {
		return nil, err
	}
	taskNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("taskName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.GetResourceGroupLevelTask(req.Context(), resourceGroupNameParam, ascLocationParam, taskNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Task, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (t *TasksServerTransport) dispatchGetSubscriptionLevelTask(req *http.Request) (*http.Response, error) {
	if t.srv.GetSubscriptionLevelTask == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetSubscriptionLevelTask not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/locations/(?P<ascLocation>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tasks/(?P<taskName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	ascLocationParam, err := url.PathUnescape(matches[regex.SubexpIndex("ascLocation")])
	if err != nil {
		return nil, err
	}
	taskNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("taskName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.GetSubscriptionLevelTask(req.Context(), ascLocationParam, taskNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Task, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (t *TasksServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if t.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := t.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/tasks`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armsecurity.TasksClientListOptions
		if filterParam != nil {
			options = &armsecurity.TasksClientListOptions{
				Filter: filterParam,
			}
		}
		resp := t.srv.NewListPager(options)
		newListPager = &resp
		t.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armsecurity.TasksClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		t.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		t.newListPager.remove(req)
	}
	return resp, nil
}

func (t *TasksServerTransport) dispatchNewListByHomeRegionPager(req *http.Request) (*http.Response, error) {
	if t.srv.NewListByHomeRegionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByHomeRegionPager not implemented")}
	}
	newListByHomeRegionPager := t.newListByHomeRegionPager.get(req)
	if newListByHomeRegionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/locations/(?P<ascLocation>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tasks`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		ascLocationParam, err := url.PathUnescape(matches[regex.SubexpIndex("ascLocation")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armsecurity.TasksClientListByHomeRegionOptions
		if filterParam != nil {
			options = &armsecurity.TasksClientListByHomeRegionOptions{
				Filter: filterParam,
			}
		}
		resp := t.srv.NewListByHomeRegionPager(ascLocationParam, options)
		newListByHomeRegionPager = &resp
		t.newListByHomeRegionPager.add(req, newListByHomeRegionPager)
		server.PagerResponderInjectNextLinks(newListByHomeRegionPager, req, func(page *armsecurity.TasksClientListByHomeRegionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByHomeRegionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		t.newListByHomeRegionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByHomeRegionPager) {
		t.newListByHomeRegionPager.remove(req)
	}
	return resp, nil
}

func (t *TasksServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if t.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := t.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/locations/(?P<ascLocation>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tasks`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		ascLocationParam, err := url.PathUnescape(matches[regex.SubexpIndex("ascLocation")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armsecurity.TasksClientListByResourceGroupOptions
		if filterParam != nil {
			options = &armsecurity.TasksClientListByResourceGroupOptions{
				Filter: filterParam,
			}
		}
		resp := t.srv.NewListByResourceGroupPager(resourceGroupNameParam, ascLocationParam, options)
		newListByResourceGroupPager = &resp
		t.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armsecurity.TasksClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		t.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		t.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (t *TasksServerTransport) dispatchUpdateResourceGroupLevelTaskState(req *http.Request) (*http.Response, error) {
	if t.srv.UpdateResourceGroupLevelTaskState == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateResourceGroupLevelTaskState not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/locations/(?P<ascLocation>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tasks/(?P<taskName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<taskUpdateActionType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	ascLocationParam, err := url.PathUnescape(matches[regex.SubexpIndex("ascLocation")])
	if err != nil {
		return nil, err
	}
	taskNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("taskName")])
	if err != nil {
		return nil, err
	}
	taskUpdateActionTypeParam, err := parseWithCast(matches[regex.SubexpIndex("taskUpdateActionType")], func(v string) (armsecurity.TaskUpdateActionType, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsecurity.TaskUpdateActionType(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.UpdateResourceGroupLevelTaskState(req.Context(), resourceGroupNameParam, ascLocationParam, taskNameParam, taskUpdateActionTypeParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (t *TasksServerTransport) dispatchUpdateSubscriptionLevelTaskState(req *http.Request) (*http.Response, error) {
	if t.srv.UpdateSubscriptionLevelTaskState == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateSubscriptionLevelTaskState not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/locations/(?P<ascLocation>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tasks/(?P<taskName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<taskUpdateActionType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	ascLocationParam, err := url.PathUnescape(matches[regex.SubexpIndex("ascLocation")])
	if err != nil {
		return nil, err
	}
	taskNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("taskName")])
	if err != nil {
		return nil, err
	}
	taskUpdateActionTypeParam, err := parseWithCast(matches[regex.SubexpIndex("taskUpdateActionType")], func(v string) (armsecurity.TaskUpdateActionType, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsecurity.TaskUpdateActionType(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.UpdateSubscriptionLevelTaskState(req.Context(), ascLocationParam, taskNameParam, taskUpdateActionTypeParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
