//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsecurity

const (
	moduleName    = "github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
	moduleVersion = "v0.13.0"
)

// AADConnectivityState - The connectivity state of the external AAD solution
type AADConnectivityState string

const (
	AADConnectivityStateConnected   AADConnectivityState = "Connected"
	AADConnectivityStateDiscovered  AADConnectivityState = "Discovered"
	AADConnectivityStateNotLicensed AADConnectivityState = "NotLicensed"
)

// PossibleAADConnectivityStateValues returns the possible values for the AADConnectivityState const type.
func PossibleAADConnectivityStateValues() []AADConnectivityState {
	return []AADConnectivityState{
		AADConnectivityStateConnected,
		AADConnectivityStateDiscovered,
		AADConnectivityStateNotLicensed,
	}
}

// ActionType - The type of the action that will be triggered by the Automation
type ActionType string

const (
	ActionTypeEventHub  ActionType = "EventHub"
	ActionTypeLogicApp  ActionType = "LogicApp"
	ActionTypeWorkspace ActionType = "Workspace"
)

// PossibleActionTypeValues returns the possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{
		ActionTypeEventHub,
		ActionTypeLogicApp,
		ActionTypeWorkspace,
	}
}

// ActionableRemediationState - ActionableRemediation Setting. None - the setting was never set. Enabled - ActionableRemediation
// is enabled. Disabled - ActionableRemediation is disabled.
type ActionableRemediationState string

const (
	ActionableRemediationStateDisabled ActionableRemediationState = "Disabled"
	ActionableRemediationStateEnabled  ActionableRemediationState = "Enabled"
	ActionableRemediationStateNone     ActionableRemediationState = "None"
)

// PossibleActionableRemediationStateValues returns the possible values for the ActionableRemediationState const type.
func PossibleActionableRemediationStateValues() []ActionableRemediationState {
	return []ActionableRemediationState{
		ActionableRemediationStateDisabled,
		ActionableRemediationStateEnabled,
		ActionableRemediationStateNone,
	}
}

// AdaptiveApplicationControlIssue - An alert that machines within a group can have
type AdaptiveApplicationControlIssue string

const (
	AdaptiveApplicationControlIssueExecutableViolationsAudited   AdaptiveApplicationControlIssue = "ExecutableViolationsAudited"
	AdaptiveApplicationControlIssueMsiAndScriptViolationsAudited AdaptiveApplicationControlIssue = "MsiAndScriptViolationsAudited"
	AdaptiveApplicationControlIssueMsiAndScriptViolationsBlocked AdaptiveApplicationControlIssue = "MsiAndScriptViolationsBlocked"
	AdaptiveApplicationControlIssueRulesViolatedManually         AdaptiveApplicationControlIssue = "RulesViolatedManually"
	AdaptiveApplicationControlIssueViolationsAudited             AdaptiveApplicationControlIssue = "ViolationsAudited"
	AdaptiveApplicationControlIssueViolationsBlocked             AdaptiveApplicationControlIssue = "ViolationsBlocked"
)

// PossibleAdaptiveApplicationControlIssueValues returns the possible values for the AdaptiveApplicationControlIssue const type.
func PossibleAdaptiveApplicationControlIssueValues() []AdaptiveApplicationControlIssue {
	return []AdaptiveApplicationControlIssue{
		AdaptiveApplicationControlIssueExecutableViolationsAudited,
		AdaptiveApplicationControlIssueMsiAndScriptViolationsAudited,
		AdaptiveApplicationControlIssueMsiAndScriptViolationsBlocked,
		AdaptiveApplicationControlIssueRulesViolatedManually,
		AdaptiveApplicationControlIssueViolationsAudited,
		AdaptiveApplicationControlIssueViolationsBlocked,
	}
}

// AdditionalWorkspaceDataType - Data types sent to workspace.
type AdditionalWorkspaceDataType string

const (
	AdditionalWorkspaceDataTypeAlerts    AdditionalWorkspaceDataType = "Alerts"
	AdditionalWorkspaceDataTypeRawEvents AdditionalWorkspaceDataType = "RawEvents"
)

// PossibleAdditionalWorkspaceDataTypeValues returns the possible values for the AdditionalWorkspaceDataType const type.
func PossibleAdditionalWorkspaceDataTypeValues() []AdditionalWorkspaceDataType {
	return []AdditionalWorkspaceDataType{
		AdditionalWorkspaceDataTypeAlerts,
		AdditionalWorkspaceDataTypeRawEvents,
	}
}

// AdditionalWorkspaceType - Workspace type.
type AdditionalWorkspaceType string

const (
	AdditionalWorkspaceTypeSentinel AdditionalWorkspaceType = "Sentinel"
)

// PossibleAdditionalWorkspaceTypeValues returns the possible values for the AdditionalWorkspaceType const type.
func PossibleAdditionalWorkspaceTypeValues() []AdditionalWorkspaceType {
	return []AdditionalWorkspaceType{
		AdditionalWorkspaceTypeSentinel,
	}
}

// AlertSeverity - The risk level of the threat that was detected. Learn more: https://docs.microsoft.com/en-us/azure/security-center/security-center-alerts-overview#how-are-alerts-classified.
type AlertSeverity string

const (
	// AlertSeverityHigh - High
	AlertSeverityHigh AlertSeverity = "High"
	// AlertSeverityInformational - Informational
	AlertSeverityInformational AlertSeverity = "Informational"
	// AlertSeverityLow - Low
	AlertSeverityLow AlertSeverity = "Low"
	// AlertSeverityMedium - Medium
	AlertSeverityMedium AlertSeverity = "Medium"
)

// PossibleAlertSeverityValues returns the possible values for the AlertSeverity const type.
func PossibleAlertSeverityValues() []AlertSeverity {
	return []AlertSeverity{
		AlertSeverityHigh,
		AlertSeverityInformational,
		AlertSeverityLow,
		AlertSeverityMedium,
	}
}

// AlertStatus - The life cycle status of the alert.
type AlertStatus string

const (
	// AlertStatusActive - An alert which doesn't specify a value is assigned the status 'Active'
	AlertStatusActive AlertStatus = "Active"
	// AlertStatusDismissed - Alert dismissed as false positive
	AlertStatusDismissed AlertStatus = "Dismissed"
	// AlertStatusInProgress - An alert which is in handling state
	AlertStatusInProgress AlertStatus = "InProgress"
	// AlertStatusResolved - Alert closed after handling
	AlertStatusResolved AlertStatus = "Resolved"
)

// PossibleAlertStatusValues returns the possible values for the AlertStatus const type.
func PossibleAlertStatusValues() []AlertStatus {
	return []AlertStatus{
		AlertStatusActive,
		AlertStatusDismissed,
		AlertStatusInProgress,
		AlertStatusResolved,
	}
}

// AnnotateDefaultBranchState - Configuration of PR Annotations on default branch.
// Enabled - PR Annotations are enabled on the resource's default branch. Disabled - PR Annotations are disabled on the resource's
// default branch.
type AnnotateDefaultBranchState string

const (
	AnnotateDefaultBranchStateDisabled AnnotateDefaultBranchState = "Disabled"
	AnnotateDefaultBranchStateEnabled  AnnotateDefaultBranchState = "Enabled"
)

// PossibleAnnotateDefaultBranchStateValues returns the possible values for the AnnotateDefaultBranchState const type.
func PossibleAnnotateDefaultBranchStateValues() []AnnotateDefaultBranchState {
	return []AnnotateDefaultBranchState{
		AnnotateDefaultBranchStateDisabled,
		AnnotateDefaultBranchStateEnabled,
	}
}

// ApplicationConditionOperator - The application Condition's Operator, for example Contains for id or In for list of possible
// IDs, see examples
type ApplicationConditionOperator string

const (
	// ApplicationConditionOperatorContains - Checks that the string value of the data defined in Property contains the given
	// value
	ApplicationConditionOperatorContains ApplicationConditionOperator = "Contains"
	// ApplicationConditionOperatorEquals - Checks that the string value of the data defined in Property equals the given value
	ApplicationConditionOperatorEquals ApplicationConditionOperator = "Equals"
	// ApplicationConditionOperatorIn - Checks that the string value of the data defined in Property equals any of the given values
	// (exact fit)
	ApplicationConditionOperatorIn ApplicationConditionOperator = "In"
)

// PossibleApplicationConditionOperatorValues returns the possible values for the ApplicationConditionOperator const type.
func PossibleApplicationConditionOperatorValues() []ApplicationConditionOperator {
	return []ApplicationConditionOperator{
		ApplicationConditionOperatorContains,
		ApplicationConditionOperatorEquals,
		ApplicationConditionOperatorIn,
	}
}

// ApplicationSourceResourceType - The application source, what it affects, e.g. Assessments
type ApplicationSourceResourceType string

const (
	// ApplicationSourceResourceTypeAssessments - The source of the application is assessments
	ApplicationSourceResourceTypeAssessments ApplicationSourceResourceType = "Assessments"
)

// PossibleApplicationSourceResourceTypeValues returns the possible values for the ApplicationSourceResourceType const type.
func PossibleApplicationSourceResourceTypeValues() []ApplicationSourceResourceType {
	return []ApplicationSourceResourceType{
		ApplicationSourceResourceTypeAssessments,
	}
}

// AssessedResourceType - Sub-assessment resource type
type AssessedResourceType string

const (
	AssessedResourceTypeContainerRegistryVulnerability AssessedResourceType = "ContainerRegistryVulnerability"
	AssessedResourceTypeSQLServerVulnerability         AssessedResourceType = "SqlServerVulnerability"
	AssessedResourceTypeServerVulnerability            AssessedResourceType = "ServerVulnerability"
)

// PossibleAssessedResourceTypeValues returns the possible values for the AssessedResourceType const type.
func PossibleAssessedResourceTypeValues() []AssessedResourceType {
	return []AssessedResourceType{
		AssessedResourceTypeContainerRegistryVulnerability,
		AssessedResourceTypeSQLServerVulnerability,
		AssessedResourceTypeServerVulnerability,
	}
}

// AssessmentStatusCode - Programmatic code for the status of the assessment
type AssessmentStatusCode string

const (
	// AssessmentStatusCodeHealthy - The resource is healthy
	AssessmentStatusCodeHealthy AssessmentStatusCode = "Healthy"
	// AssessmentStatusCodeNotApplicable - Assessment for this resource did not happen
	AssessmentStatusCodeNotApplicable AssessmentStatusCode = "NotApplicable"
	// AssessmentStatusCodeUnhealthy - The resource has a security issue that needs to be addressed
	AssessmentStatusCodeUnhealthy AssessmentStatusCode = "Unhealthy"
)

// PossibleAssessmentStatusCodeValues returns the possible values for the AssessmentStatusCode const type.
func PossibleAssessmentStatusCodeValues() []AssessmentStatusCode {
	return []AssessmentStatusCode{
		AssessmentStatusCodeHealthy,
		AssessmentStatusCodeNotApplicable,
		AssessmentStatusCodeUnhealthy,
	}
}

// AssessmentType - BuiltIn if the assessment based on built-in Azure Policy definition, Custom if the assessment based on
// custom Azure Policy definition
type AssessmentType string

const (
	// AssessmentTypeBuiltIn - Microsoft Defender for Cloud managed assessments
	AssessmentTypeBuiltIn AssessmentType = "BuiltIn"
	// AssessmentTypeCustomPolicy - User defined policies that are automatically ingested from Azure Policy to Microsoft Defender
	// for Cloud
	AssessmentTypeCustomPolicy AssessmentType = "CustomPolicy"
	// AssessmentTypeCustomerManaged - User assessments pushed directly by the user or other third party to Microsoft Defender
	// for Cloud
	AssessmentTypeCustomerManaged AssessmentType = "CustomerManaged"
	// AssessmentTypeVerifiedPartner - An assessment that was created by a verified 3rd party if the user connected it to ASC
	AssessmentTypeVerifiedPartner AssessmentType = "VerifiedPartner"
)

// PossibleAssessmentTypeValues returns the possible values for the AssessmentType const type.
func PossibleAssessmentTypeValues() []AssessmentType {
	return []AssessmentType{
		AssessmentTypeBuiltIn,
		AssessmentTypeCustomPolicy,
		AssessmentTypeCustomerManaged,
		AssessmentTypeVerifiedPartner,
	}
}

// AuthenticationProvisioningState - State of the multi-cloud connector
type AuthenticationProvisioningState string

const (
	// AuthenticationProvisioningStateExpired - the connection has expired
	AuthenticationProvisioningStateExpired AuthenticationProvisioningState = "Expired"
	// AuthenticationProvisioningStateIncorrectPolicy - Incorrect policy of the connector
	AuthenticationProvisioningStateIncorrectPolicy AuthenticationProvisioningState = "IncorrectPolicy"
	// AuthenticationProvisioningStateInvalid - Invalid connector
	AuthenticationProvisioningStateInvalid AuthenticationProvisioningState = "Invalid"
	// AuthenticationProvisioningStateValid - Valid connector
	AuthenticationProvisioningStateValid AuthenticationProvisioningState = "Valid"
)

// PossibleAuthenticationProvisioningStateValues returns the possible values for the AuthenticationProvisioningState const type.
func PossibleAuthenticationProvisioningStateValues() []AuthenticationProvisioningState {
	return []AuthenticationProvisioningState{
		AuthenticationProvisioningStateExpired,
		AuthenticationProvisioningStateIncorrectPolicy,
		AuthenticationProvisioningStateInvalid,
		AuthenticationProvisioningStateValid,
	}
}

// AuthenticationType - Connect to your cloud account, for AWS use either account credentials or role-based authentication.
// For GCP use account organization credentials.
type AuthenticationType string

const (
	// AuthenticationTypeAwsAssumeRole - AWS account connector assume role authentication
	AuthenticationTypeAwsAssumeRole AuthenticationType = "awsAssumeRole"
	// AuthenticationTypeAwsCreds - AWS cloud account connector user credentials authentication
	AuthenticationTypeAwsCreds AuthenticationType = "awsCreds"
	// AuthenticationTypeGcpCredentials - GCP account connector service to service authentication
	AuthenticationTypeGcpCredentials AuthenticationType = "gcpCredentials"
)

// PossibleAuthenticationTypeValues returns the possible values for the AuthenticationType const type.
func PossibleAuthenticationTypeValues() []AuthenticationType {
	return []AuthenticationType{
		AuthenticationTypeAwsAssumeRole,
		AuthenticationTypeAwsCreds,
		AuthenticationTypeGcpCredentials,
	}
}

// AutoDiscovery - AutoDiscovery states.
type AutoDiscovery string

const (
	AutoDiscoveryDisabled      AutoDiscovery = "Disabled"
	AutoDiscoveryEnabled       AutoDiscovery = "Enabled"
	AutoDiscoveryNotApplicable AutoDiscovery = "NotApplicable"
)

// PossibleAutoDiscoveryValues returns the possible values for the AutoDiscovery const type.
func PossibleAutoDiscoveryValues() []AutoDiscovery {
	return []AutoDiscovery{
		AutoDiscoveryDisabled,
		AutoDiscoveryEnabled,
		AutoDiscoveryNotApplicable,
	}
}

// AutoProvision - Describes what kind of security agent provisioning action to take
type AutoProvision string

const (
	// AutoProvisionOff - Do not install security agent on the VMs automatically
	AutoProvisionOff AutoProvision = "Off"
	// AutoProvisionOn - Install missing security agent on VMs automatically
	AutoProvisionOn AutoProvision = "On"
)

// PossibleAutoProvisionValues returns the possible values for the AutoProvision const type.
func PossibleAutoProvisionValues() []AutoProvision {
	return []AutoProvision{
		AutoProvisionOff,
		AutoProvisionOn,
	}
}

// BundleType - Alert Simulator supported bundles.
type BundleType string

const (
	BundleTypeAppServices       BundleType = "AppServices"
	BundleTypeCosmosDbs         BundleType = "CosmosDbs"
	BundleTypeDNS               BundleType = "DNS"
	BundleTypeKeyVaults         BundleType = "KeyVaults"
	BundleTypeKubernetesService BundleType = "KubernetesService"
	BundleTypeResourceManager   BundleType = "ResourceManager"
	BundleTypeSQLServers        BundleType = "SqlServers"
	BundleTypeStorageAccounts   BundleType = "StorageAccounts"
	BundleTypeVirtualMachines   BundleType = "VirtualMachines"
)

// PossibleBundleTypeValues returns the possible values for the BundleType const type.
func PossibleBundleTypeValues() []BundleType {
	return []BundleType{
		BundleTypeAppServices,
		BundleTypeCosmosDbs,
		BundleTypeDNS,
		BundleTypeKeyVaults,
		BundleTypeKubernetesService,
		BundleTypeResourceManager,
		BundleTypeSQLServers,
		BundleTypeStorageAccounts,
		BundleTypeVirtualMachines,
	}
}

// Categories - The categories of resource that is at risk when the assessment is unhealthy
type Categories string

const (
	CategoriesCompute           Categories = "Compute"
	CategoriesData              Categories = "Data"
	CategoriesIdentityAndAccess Categories = "IdentityAndAccess"
	CategoriesIoT               Categories = "IoT"
	CategoriesNetworking        Categories = "Networking"
)

// PossibleCategoriesValues returns the possible values for the Categories const type.
func PossibleCategoriesValues() []Categories {
	return []Categories{
		CategoriesCompute,
		CategoriesData,
		CategoriesIdentityAndAccess,
		CategoriesIoT,
		CategoriesNetworking,
	}
}

// CloudName - The multi cloud resource's cloud name.
type CloudName string

const (
	CloudNameAWS         CloudName = "AWS"
	CloudNameAzure       CloudName = "Azure"
	CloudNameAzureDevOps CloudName = "AzureDevOps"
	CloudNameGCP         CloudName = "GCP"
	CloudNameGitLab      CloudName = "GitLab"
	CloudNameGithub      CloudName = "Github"
)

// PossibleCloudNameValues returns the possible values for the CloudName const type.
func PossibleCloudNameValues() []CloudName {
	return []CloudName{
		CloudNameAWS,
		CloudNameAzure,
		CloudNameAzureDevOps,
		CloudNameGCP,
		CloudNameGitLab,
		CloudNameGithub,
	}
}

// Code - The operation status code.
type Code string

const (
	// CodeFailed - Extension was not created/updated successfully. See operation status message for more details.
	CodeFailed Code = "Failed"
	// CodeSucceeded - Extension was created/updated successfully.
	CodeSucceeded Code = "Succeeded"
)

// PossibleCodeValues returns the possible values for the Code const type.
func PossibleCodeValues() []Code {
	return []Code{
		CodeFailed,
		CodeSucceeded,
	}
}

// ConfigurationStatus - The configuration status of the machines group or machine or rule
type ConfigurationStatus string

const (
	ConfigurationStatusConfigured    ConfigurationStatus = "Configured"
	ConfigurationStatusFailed        ConfigurationStatus = "Failed"
	ConfigurationStatusInProgress    ConfigurationStatus = "InProgress"
	ConfigurationStatusNoStatus      ConfigurationStatus = "NoStatus"
	ConfigurationStatusNotConfigured ConfigurationStatus = "NotConfigured"
)

// PossibleConfigurationStatusValues returns the possible values for the ConfigurationStatus const type.
func PossibleConfigurationStatusValues() []ConfigurationStatus {
	return []ConfigurationStatus{
		ConfigurationStatusConfigured,
		ConfigurationStatusFailed,
		ConfigurationStatusInProgress,
		ConfigurationStatusNoStatus,
		ConfigurationStatusNotConfigured,
	}
}

type ConnectionType string

const (
	ConnectionTypeExternal ConnectionType = "External"
	ConnectionTypeInternal ConnectionType = "Internal"
)

// PossibleConnectionTypeValues returns the possible values for the ConnectionType const type.
func PossibleConnectionTypeValues() []ConnectionType {
	return []ConnectionType{
		ConnectionTypeExternal,
		ConnectionTypeInternal,
	}
}

// ControlType - The type of security control (for example, BuiltIn)
type ControlType string

const (
	// ControlTypeBuiltIn - Microsoft Defender for Cloud managed assessments
	ControlTypeBuiltIn ControlType = "BuiltIn"
	// ControlTypeCustom - Non Microsoft Defender for Cloud managed assessments
	ControlTypeCustom ControlType = "Custom"
)

// PossibleControlTypeValues returns the possible values for the ControlType const type.
func PossibleControlTypeValues() []ControlType {
	return []ControlType{
		ControlTypeBuiltIn,
		ControlTypeCustom,
	}
}

// CreatedByType - The type of identity that created the resource.
type CreatedByType string

const (
	CreatedByTypeApplication     CreatedByType = "Application"
	CreatedByTypeKey             CreatedByType = "Key"
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	CreatedByTypeUser            CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns the possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{
		CreatedByTypeApplication,
		CreatedByTypeKey,
		CreatedByTypeManagedIdentity,
		CreatedByTypeUser,
	}
}

type DataSource string

const (
	// DataSourceTwinData - Devices twin data
	DataSourceTwinData DataSource = "TwinData"
)

// PossibleDataSourceValues returns the possible values for the DataSource const type.
func PossibleDataSourceValues() []DataSource {
	return []DataSource{
		DataSourceTwinData,
	}
}

// DesiredOnboardingState - Onboarding states.
type DesiredOnboardingState string

const (
	DesiredOnboardingStateDisabled DesiredOnboardingState = "Disabled"
	DesiredOnboardingStateEnabled  DesiredOnboardingState = "Enabled"
)

// PossibleDesiredOnboardingStateValues returns the possible values for the DesiredOnboardingState const type.
func PossibleDesiredOnboardingStateValues() []DesiredOnboardingState {
	return []DesiredOnboardingState{
		DesiredOnboardingStateDisabled,
		DesiredOnboardingStateEnabled,
	}
}

// DevOpsProvisioningState - The provisioning state of the resource.
// Pending - Provisioning pending. Failed - Provisioning failed. Succeeded - Successful provisioning. Canceled - Provisioning
// canceled. PendingDeletion - Deletion pending. DeletionSuccess - Deletion
// successful. DeletionFailure - Deletion failure.
type DevOpsProvisioningState string

const (
	DevOpsProvisioningStateCanceled        DevOpsProvisioningState = "Canceled"
	DevOpsProvisioningStateDeletionFailure DevOpsProvisioningState = "DeletionFailure"
	DevOpsProvisioningStateDeletionSuccess DevOpsProvisioningState = "DeletionSuccess"
	DevOpsProvisioningStateFailed          DevOpsProvisioningState = "Failed"
	DevOpsProvisioningStatePending         DevOpsProvisioningState = "Pending"
	DevOpsProvisioningStatePendingDeletion DevOpsProvisioningState = "PendingDeletion"
	DevOpsProvisioningStateSucceeded       DevOpsProvisioningState = "Succeeded"
)

// PossibleDevOpsProvisioningStateValues returns the possible values for the DevOpsProvisioningState const type.
func PossibleDevOpsProvisioningStateValues() []DevOpsProvisioningState {
	return []DevOpsProvisioningState{
		DevOpsProvisioningStateCanceled,
		DevOpsProvisioningStateDeletionFailure,
		DevOpsProvisioningStateDeletionSuccess,
		DevOpsProvisioningStateFailed,
		DevOpsProvisioningStatePending,
		DevOpsProvisioningStatePendingDeletion,
		DevOpsProvisioningStateSucceeded,
	}
}

// Direction - The rule's direction
type Direction string

const (
	DirectionInbound  Direction = "Inbound"
	DirectionOutbound Direction = "Outbound"
)

// PossibleDirectionValues returns the possible values for the Direction const type.
func PossibleDirectionValues() []Direction {
	return []Direction{
		DirectionInbound,
		DirectionOutbound,
	}
}

// EndOfSupportStatus - End of support status.
type EndOfSupportStatus string

const (
	EndOfSupportStatusNoLongerSupported                EndOfSupportStatus = "noLongerSupported"
	EndOfSupportStatusNone                             EndOfSupportStatus = "None"
	EndOfSupportStatusUpcomingNoLongerSupported        EndOfSupportStatus = "upcomingNoLongerSupported"
	EndOfSupportStatusUpcomingVersionNoLongerSupported EndOfSupportStatus = "upcomingVersionNoLongerSupported"
	EndOfSupportStatusVersionNoLongerSupported         EndOfSupportStatus = "versionNoLongerSupported"
)

// PossibleEndOfSupportStatusValues returns the possible values for the EndOfSupportStatus const type.
func PossibleEndOfSupportStatusValues() []EndOfSupportStatus {
	return []EndOfSupportStatus{
		EndOfSupportStatusNoLongerSupported,
		EndOfSupportStatusNone,
		EndOfSupportStatusUpcomingNoLongerSupported,
		EndOfSupportStatusUpcomingVersionNoLongerSupported,
		EndOfSupportStatusVersionNoLongerSupported,
	}
}

// Enforce - If set to "False", it allows the descendants of this scope to override the pricing configuration set on this
// scope (allows setting inherited="False"). If set to "True", it prevents overrides and
// forces this pricing configuration on all the descendants of this scope. This field is only available for subscription-level
// pricing.
type Enforce string

const (
	// EnforceFalse - Allows the descendants of this scope to override the pricing configuration set on this scope (allows setting
	// inherited="False")
	EnforceFalse Enforce = "False"
	// EnforceTrue - Prevents overrides and forces the current scope's pricing configuration to all descendants
	EnforceTrue Enforce = "True"
)

// PossibleEnforceValues returns the possible values for the Enforce const type.
func PossibleEnforceValues() []Enforce {
	return []Enforce{
		EnforceFalse,
		EnforceTrue,
	}
}

// EnforcementMode - The application control policy enforcement/protection mode of the machine group
type EnforcementMode string

const (
	EnforcementModeAudit   EnforcementMode = "Audit"
	EnforcementModeEnforce EnforcementMode = "Enforce"
	EnforcementModeNone    EnforcementMode = "None"
)

// PossibleEnforcementModeValues returns the possible values for the EnforcementMode const type.
func PossibleEnforcementModeValues() []EnforcementMode {
	return []EnforcementMode{
		EnforcementModeAudit,
		EnforcementModeEnforce,
		EnforcementModeNone,
	}
}

// EnforcementSupport - The machine supportability of Enforce feature
type EnforcementSupport string

const (
	EnforcementSupportNotSupported EnforcementSupport = "NotSupported"
	EnforcementSupportSupported    EnforcementSupport = "Supported"
	EnforcementSupportUnknown      EnforcementSupport = "Unknown"
)

// PossibleEnforcementSupportValues returns the possible values for the EnforcementSupport const type.
func PossibleEnforcementSupportValues() []EnforcementSupport {
	return []EnforcementSupport{
		EnforcementSupportNotSupported,
		EnforcementSupportSupported,
		EnforcementSupportUnknown,
	}
}

// EnvironmentType - The type of the environment data.
type EnvironmentType string

const (
	EnvironmentTypeAwsAccount       EnvironmentType = "AwsAccount"
	EnvironmentTypeAzureDevOpsScope EnvironmentType = "AzureDevOpsScope"
	EnvironmentTypeGcpProject       EnvironmentType = "GcpProject"
	EnvironmentTypeGithubScope      EnvironmentType = "GithubScope"
	EnvironmentTypeGitlabScope      EnvironmentType = "GitlabScope"
)

// PossibleEnvironmentTypeValues returns the possible values for the EnvironmentType const type.
func PossibleEnvironmentTypeValues() []EnvironmentType {
	return []EnvironmentType{
		EnvironmentTypeAwsAccount,
		EnvironmentTypeAzureDevOpsScope,
		EnvironmentTypeGcpProject,
		EnvironmentTypeGithubScope,
		EnvironmentTypeGitlabScope,
	}
}

// EventSource - A valid event source type.
type EventSource string

const (
	EventSourceAlerts                                 EventSource = "Alerts"
	EventSourceAssessments                            EventSource = "Assessments"
	EventSourceAssessmentsSnapshot                    EventSource = "AssessmentsSnapshot"
	EventSourceRegulatoryComplianceAssessment         EventSource = "RegulatoryComplianceAssessment"
	EventSourceRegulatoryComplianceAssessmentSnapshot EventSource = "RegulatoryComplianceAssessmentSnapshot"
	EventSourceSecureScoreControls                    EventSource = "SecureScoreControls"
	EventSourceSecureScoreControlsSnapshot            EventSource = "SecureScoreControlsSnapshot"
	EventSourceSecureScores                           EventSource = "SecureScores"
	EventSourceSecureScoresSnapshot                   EventSource = "SecureScoresSnapshot"
	EventSourceSubAssessments                         EventSource = "SubAssessments"
	EventSourceSubAssessmentsSnapshot                 EventSource = "SubAssessmentsSnapshot"
)

// PossibleEventSourceValues returns the possible values for the EventSource const type.
func PossibleEventSourceValues() []EventSource {
	return []EventSource{
		EventSourceAlerts,
		EventSourceAssessments,
		EventSourceAssessmentsSnapshot,
		EventSourceRegulatoryComplianceAssessment,
		EventSourceRegulatoryComplianceAssessmentSnapshot,
		EventSourceSecureScoreControls,
		EventSourceSecureScoreControlsSnapshot,
		EventSourceSecureScores,
		EventSourceSecureScoresSnapshot,
		EventSourceSubAssessments,
		EventSourceSubAssessmentsSnapshot,
	}
}

type ExpandControlsEnum string

const (
	// ExpandControlsEnumDefinition - Add definition object for each control
	ExpandControlsEnumDefinition ExpandControlsEnum = "definition"
)

// PossibleExpandControlsEnumValues returns the possible values for the ExpandControlsEnum const type.
func PossibleExpandControlsEnumValues() []ExpandControlsEnum {
	return []ExpandControlsEnum{
		ExpandControlsEnumDefinition,
	}
}

type ExpandEnum string

const (
	// ExpandEnumLinks - All links associated with an assessment
	ExpandEnumLinks ExpandEnum = "links"
	// ExpandEnumMetadata - Assessment metadata
	ExpandEnumMetadata ExpandEnum = "metadata"
)

// PossibleExpandEnumValues returns the possible values for the ExpandEnum const type.
func PossibleExpandEnumValues() []ExpandEnum {
	return []ExpandEnum{
		ExpandEnumLinks,
		ExpandEnumMetadata,
	}
}

type ExportData string

const (
	// ExportDataRawEvents - Agent raw events
	ExportDataRawEvents ExportData = "RawEvents"
)

// PossibleExportDataValues returns the possible values for the ExportData const type.
func PossibleExportDataValues() []ExportData {
	return []ExportData{
		ExportDataRawEvents,
	}
}

// ExternalSecuritySolutionKind - The kind of the external solution
type ExternalSecuritySolutionKind string

const (
	ExternalSecuritySolutionKindAAD ExternalSecuritySolutionKind = "AAD"
	ExternalSecuritySolutionKindATA ExternalSecuritySolutionKind = "ATA"
	ExternalSecuritySolutionKindCEF ExternalSecuritySolutionKind = "CEF"
)

// PossibleExternalSecuritySolutionKindValues returns the possible values for the ExternalSecuritySolutionKind const type.
func PossibleExternalSecuritySolutionKindValues() []ExternalSecuritySolutionKind {
	return []ExternalSecuritySolutionKind{
		ExternalSecuritySolutionKindAAD,
		ExternalSecuritySolutionKindATA,
		ExternalSecuritySolutionKindCEF,
	}
}

// FileType - The type of the file (for Linux files - Executable is used)
type FileType string

const (
	FileTypeDll        FileType = "Dll"
	FileTypeExe        FileType = "Exe"
	FileTypeExecutable FileType = "Executable"
	FileTypeMsi        FileType = "Msi"
	FileTypeScript     FileType = "Script"
	FileTypeUnknown    FileType = "Unknown"
)

// PossibleFileTypeValues returns the possible values for the FileType const type.
func PossibleFileTypeValues() []FileType {
	return []FileType{
		FileTypeDll,
		FileTypeExe,
		FileTypeExecutable,
		FileTypeMsi,
		FileTypeScript,
		FileTypeUnknown,
	}
}

// GovernanceRuleConditionOperator - The governance rule Condition's Operator, for example Equals for severity or In for list
// of assessments, see examples
type GovernanceRuleConditionOperator string

const (
	// GovernanceRuleConditionOperatorEquals - Checks that the string value of the data defined in Property equals the given value
	// - exact fit
	GovernanceRuleConditionOperatorEquals GovernanceRuleConditionOperator = "Equals"
	// GovernanceRuleConditionOperatorIn - Checks that the string value of the data defined in Property equals any of the given
	// values (exact fit)
	GovernanceRuleConditionOperatorIn GovernanceRuleConditionOperator = "In"
)

// PossibleGovernanceRuleConditionOperatorValues returns the possible values for the GovernanceRuleConditionOperator const type.
func PossibleGovernanceRuleConditionOperatorValues() []GovernanceRuleConditionOperator {
	return []GovernanceRuleConditionOperator{
		GovernanceRuleConditionOperatorEquals,
		GovernanceRuleConditionOperatorIn,
	}
}

// GovernanceRuleOwnerSourceType - The owner type for the governance rule owner source
type GovernanceRuleOwnerSourceType string

const (
	// GovernanceRuleOwnerSourceTypeByTag - The rule source type defined using resource tag
	GovernanceRuleOwnerSourceTypeByTag GovernanceRuleOwnerSourceType = "ByTag"
	// GovernanceRuleOwnerSourceTypeManually - The rule source type defined manually
	GovernanceRuleOwnerSourceTypeManually GovernanceRuleOwnerSourceType = "Manually"
)

// PossibleGovernanceRuleOwnerSourceTypeValues returns the possible values for the GovernanceRuleOwnerSourceType const type.
func PossibleGovernanceRuleOwnerSourceTypeValues() []GovernanceRuleOwnerSourceType {
	return []GovernanceRuleOwnerSourceType{
		GovernanceRuleOwnerSourceTypeByTag,
		GovernanceRuleOwnerSourceTypeManually,
	}
}

// GovernanceRuleSourceResourceType - The governance rule source, what the rule affects, e.g. Assessments
type GovernanceRuleSourceResourceType string

const (
	// GovernanceRuleSourceResourceTypeAssessments - The source of the governance rule is assessments
	GovernanceRuleSourceResourceTypeAssessments GovernanceRuleSourceResourceType = "Assessments"
)

// PossibleGovernanceRuleSourceResourceTypeValues returns the possible values for the GovernanceRuleSourceResourceType const type.
func PossibleGovernanceRuleSourceResourceTypeValues() []GovernanceRuleSourceResourceType {
	return []GovernanceRuleSourceResourceType{
		GovernanceRuleSourceResourceTypeAssessments,
	}
}

// GovernanceRuleType - The rule type of the governance rule, defines the source of the rule e.g. Integrated
type GovernanceRuleType string

const (
	// GovernanceRuleTypeIntegrated - The source of the rule type definition is integrated
	GovernanceRuleTypeIntegrated GovernanceRuleType = "Integrated"
	// GovernanceRuleTypeServiceNow - The source of the rule type definition is ServiceNow
	GovernanceRuleTypeServiceNow GovernanceRuleType = "ServiceNow"
)

// PossibleGovernanceRuleTypeValues returns the possible values for the GovernanceRuleType const type.
func PossibleGovernanceRuleTypeValues() []GovernanceRuleType {
	return []GovernanceRuleType{
		GovernanceRuleTypeIntegrated,
		GovernanceRuleTypeServiceNow,
	}
}

// HybridComputeProvisioningState - State of the service principal and its secret
type HybridComputeProvisioningState string

const (
	// HybridComputeProvisioningStateExpired - the service principal details are expired
	HybridComputeProvisioningStateExpired HybridComputeProvisioningState = "Expired"
	// HybridComputeProvisioningStateInvalid - Invalid service principal details.
	HybridComputeProvisioningStateInvalid HybridComputeProvisioningState = "Invalid"
	// HybridComputeProvisioningStateValid - Valid service principal details.
	HybridComputeProvisioningStateValid HybridComputeProvisioningState = "Valid"
)

// PossibleHybridComputeProvisioningStateValues returns the possible values for the HybridComputeProvisioningState const type.
func PossibleHybridComputeProvisioningStateValues() []HybridComputeProvisioningState {
	return []HybridComputeProvisioningState{
		HybridComputeProvisioningStateExpired,
		HybridComputeProvisioningStateInvalid,
		HybridComputeProvisioningStateValid,
	}
}

// ImplementationEffort - The implementation effort required to remediate this assessment
type ImplementationEffort string

const (
	ImplementationEffortHigh     ImplementationEffort = "High"
	ImplementationEffortLow      ImplementationEffort = "Low"
	ImplementationEffortModerate ImplementationEffort = "Moderate"
)

// PossibleImplementationEffortValues returns the possible values for the ImplementationEffort const type.
func PossibleImplementationEffortValues() []ImplementationEffort {
	return []ImplementationEffort{
		ImplementationEffortHigh,
		ImplementationEffortLow,
		ImplementationEffortModerate,
	}
}

type InformationProtectionPolicyName string

const (
	InformationProtectionPolicyNameCustom    InformationProtectionPolicyName = "custom"
	InformationProtectionPolicyNameEffective InformationProtectionPolicyName = "effective"
)

// PossibleInformationProtectionPolicyNameValues returns the possible values for the InformationProtectionPolicyName const type.
func PossibleInformationProtectionPolicyNameValues() []InformationProtectionPolicyName {
	return []InformationProtectionPolicyName{
		InformationProtectionPolicyNameCustom,
		InformationProtectionPolicyNameEffective,
	}
}

// InheritFromParentState - Update Settings.
// Enabled - Resource should inherit configurations from parent. Disabled - Resource should not inherit configurations from
// parent.
type InheritFromParentState string

const (
	InheritFromParentStateDisabled InheritFromParentState = "Disabled"
	InheritFromParentStateEnabled  InheritFromParentState = "Enabled"
)

// PossibleInheritFromParentStateValues returns the possible values for the InheritFromParentState const type.
func PossibleInheritFromParentStateValues() []InheritFromParentState {
	return []InheritFromParentState{
		InheritFromParentStateDisabled,
		InheritFromParentStateEnabled,
	}
}

// Inherited - "inherited" = "True" indicates that the current scope inherits its pricing configuration from its parent. The
// ID of the parent scope that provides the inherited configuration is displayed in the
// "inheritedFrom" field. On the other hand, "inherited" = "False" indicates that the current scope has its own pricing configuration
// explicitly set, and does not inherit from its parent. This field is
// read only and available only for resource-level pricing.
type Inherited string

const (
	// InheritedFalse - Indicates that the current scope sets its own pricing configuration and does not inherit it from its parent
	InheritedFalse Inherited = "False"
	// InheritedTrue - Indicates that the current scope is inheriting its pricing configuration from its parent
	InheritedTrue Inherited = "True"
)

// PossibleInheritedValues returns the possible values for the Inherited const type.
func PossibleInheritedValues() []Inherited {
	return []Inherited{
		InheritedFalse,
		InheritedTrue,
	}
}

// Intent - The kill chain related intent behind the alert. For list of supported values, and explanations of Azure Security
// Center's supported kill chain intents.
type Intent string

const (
	// IntentCollection - Collection consists of techniques used to identify and gather information, such as sensitive files,
	// from a target network prior to exfiltration.
	IntentCollection Intent = "Collection"
	// IntentCommandAndControl - The command and control tactic represents how adversaries communicate with systems under their
	// control within a target network.
	IntentCommandAndControl Intent = "CommandAndControl"
	// IntentCredentialAccess - Credential access represents techniques resulting in access to or control over system, domain,
	// or service credentials that are used within an enterprise environment.
	IntentCredentialAccess Intent = "CredentialAccess"
	// IntentDefenseEvasion - Defense evasion consists of techniques an adversary may use to evade detection or avoid other defenses.
	IntentDefenseEvasion Intent = "DefenseEvasion"
	// IntentDiscovery - Discovery consists of techniques that allow the adversary to gain knowledge about the system and internal
	// network.
	IntentDiscovery Intent = "Discovery"
	// IntentExecution - The execution tactic represents techniques that result in execution of adversary-controlled code on a
	// local or remote system.
	IntentExecution Intent = "Execution"
	// IntentExfiltration - Exfiltration refers to techniques and attributes that result or aid in the adversary removing files
	// and information from a target network.
	IntentExfiltration Intent = "Exfiltration"
	// IntentExploitation - Exploitation is the stage where an attacker manages to get a foothold on the attacked resource. This
	// stage is relevant for compute hosts and resources such as user accounts, certificates etc.
	IntentExploitation Intent = "Exploitation"
	// IntentImpact - Impact events primarily try to directly reduce the availability or integrity of a system, service, or network;
	// including manipulation of data to impact a business or operational process.
	IntentImpact Intent = "Impact"
	// IntentInitialAccess - InitialAccess is the stage where an attacker manages to get foothold on the attacked resource.
	IntentInitialAccess Intent = "InitialAccess"
	// IntentLateralMovement - Lateral movement consists of techniques that enable an adversary to access and control remote systems
	// on a network and could, but does not necessarily, include execution of tools on remote systems.
	IntentLateralMovement Intent = "LateralMovement"
	// IntentPersistence - Persistence is any access, action, or configuration change to a system that gives a threat actor a
	// persistent presence on that system.
	IntentPersistence Intent = "Persistence"
	// IntentPreAttack - PreAttack could be either an attempt to access a certain resource regardless of a malicious intent, or
	// a failed attempt to gain access to a target system to gather information prior to exploitation. This step is usually detected
	// as an attempt, originating from outside the network, to scan the target system and find a way in. Further details on the
	// PreAttack stage can be read in [MITRE Pre-Att&ck matrix](https://attack.mitre.org/matrices/pre/).
	IntentPreAttack Intent = "PreAttack"
	// IntentPrivilegeEscalation - Privilege escalation is the result of actions that allow an adversary to obtain a higher level
	// of permissions on a system or network.
	IntentPrivilegeEscalation Intent = "PrivilegeEscalation"
	// IntentProbing - Probing could be either an attempt to access a certain resource regardless of a malicious intent, or a
	// failed attempt to gain access to a target system to gather information prior to exploitation.
	IntentProbing Intent = "Probing"
	// IntentUnknown - Unknown
	IntentUnknown Intent = "Unknown"
)

// PossibleIntentValues returns the possible values for the Intent const type.
func PossibleIntentValues() []Intent {
	return []Intent{
		IntentCollection,
		IntentCommandAndControl,
		IntentCredentialAccess,
		IntentDefenseEvasion,
		IntentDiscovery,
		IntentExecution,
		IntentExfiltration,
		IntentExploitation,
		IntentImpact,
		IntentInitialAccess,
		IntentLateralMovement,
		IntentPersistence,
		IntentPreAttack,
		IntentPrivilegeEscalation,
		IntentProbing,
		IntentUnknown,
	}
}

// IsEnabled - Indicates whether the extension is enabled.
type IsEnabled string

const (
	// IsEnabledFalse - Indicates the extension is disabled
	IsEnabledFalse IsEnabled = "False"
	// IsEnabledTrue - Indicates the extension is enabled
	IsEnabledTrue IsEnabled = "True"
)

// PossibleIsEnabledValues returns the possible values for the IsEnabled const type.
func PossibleIsEnabledValues() []IsEnabled {
	return []IsEnabled{
		IsEnabledFalse,
		IsEnabledTrue,
	}
}

// Kind - The kind of alert simulation.
type Kind string

const (
	// KindBundles - Simulate alerts according to bundles
	KindBundles Kind = "Bundles"
)

// PossibleKindValues returns the possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{
		KindBundles,
	}
}

// MinimalSeverity - Defines the minimal alert severity which will be sent as email notifications
type MinimalSeverity string

const (
	// MinimalSeverityHigh - Get notifications on new alerts with High severity
	MinimalSeverityHigh MinimalSeverity = "High"
	// MinimalSeverityLow - Don't get notifications on new alerts with low, medium or high severity
	MinimalSeverityLow MinimalSeverity = "Low"
	// MinimalSeverityMedium - Get notifications on new alerts with medium or high severity
	MinimalSeverityMedium MinimalSeverity = "Medium"
)

// PossibleMinimalSeverityValues returns the possible values for the MinimalSeverity const type.
func PossibleMinimalSeverityValues() []MinimalSeverity {
	return []MinimalSeverity{
		MinimalSeverityHigh,
		MinimalSeverityLow,
		MinimalSeverityMedium,
	}
}

// MipIntegrationStatus - Microsoft information protection integration status
type MipIntegrationStatus string

const (
	MipIntegrationStatusNoAutoLabelingRules MipIntegrationStatus = "noAutoLabelingRules"
	MipIntegrationStatusNoConsent           MipIntegrationStatus = "noConsent"
	MipIntegrationStatusNoMipLabels         MipIntegrationStatus = "noMipLabels"
	MipIntegrationStatusOk                  MipIntegrationStatus = "Ok"
)

// PossibleMipIntegrationStatusValues returns the possible values for the MipIntegrationStatus const type.
func PossibleMipIntegrationStatusValues() []MipIntegrationStatus {
	return []MipIntegrationStatus{
		MipIntegrationStatusNoAutoLabelingRules,
		MipIntegrationStatusNoConsent,
		MipIntegrationStatusNoMipLabels,
		MipIntegrationStatusOk,
	}
}

// OfferingType - The type of the security offering.
type OfferingType string

const (
	OfferingTypeCspmMonitorAws               OfferingType = "CspmMonitorAws"
	OfferingTypeCspmMonitorAzureDevOps       OfferingType = "CspmMonitorAzureDevOps"
	OfferingTypeCspmMonitorGcp               OfferingType = "CspmMonitorGcp"
	OfferingTypeCspmMonitorGitLab            OfferingType = "CspmMonitorGitLab"
	OfferingTypeCspmMonitorGithub            OfferingType = "CspmMonitorGithub"
	OfferingTypeDefenderCspmAws              OfferingType = "DefenderCspmAws"
	OfferingTypeDefenderCspmGcp              OfferingType = "DefenderCspmGcp"
	OfferingTypeDefenderForContainersAws     OfferingType = "DefenderForContainersAws"
	OfferingTypeDefenderForContainersGcp     OfferingType = "DefenderForContainersGcp"
	OfferingTypeDefenderForDatabasesAws      OfferingType = "DefenderForDatabasesAws"
	OfferingTypeDefenderForDatabasesGcp      OfferingType = "DefenderForDatabasesGcp"
	OfferingTypeDefenderForDevOpsAzureDevOps OfferingType = "DefenderForDevOpsAzureDevOps"
	OfferingTypeDefenderForDevOpsGitLab      OfferingType = "DefenderForDevOpsGitLab"
	OfferingTypeDefenderForDevOpsGithub      OfferingType = "DefenderForDevOpsGithub"
	OfferingTypeDefenderForServersAws        OfferingType = "DefenderForServersAws"
	OfferingTypeDefenderForServersGcp        OfferingType = "DefenderForServersGcp"
	OfferingTypeInformationProtectionAws     OfferingType = "InformationProtectionAws"
)

// PossibleOfferingTypeValues returns the possible values for the OfferingType const type.
func PossibleOfferingTypeValues() []OfferingType {
	return []OfferingType{
		OfferingTypeCspmMonitorAws,
		OfferingTypeCspmMonitorAzureDevOps,
		OfferingTypeCspmMonitorGcp,
		OfferingTypeCspmMonitorGitLab,
		OfferingTypeCspmMonitorGithub,
		OfferingTypeDefenderCspmAws,
		OfferingTypeDefenderCspmGcp,
		OfferingTypeDefenderForContainersAws,
		OfferingTypeDefenderForContainersGcp,
		OfferingTypeDefenderForDatabasesAws,
		OfferingTypeDefenderForDatabasesGcp,
		OfferingTypeDefenderForDevOpsAzureDevOps,
		OfferingTypeDefenderForDevOpsGitLab,
		OfferingTypeDefenderForDevOpsGithub,
		OfferingTypeDefenderForServersAws,
		OfferingTypeDefenderForServersGcp,
		OfferingTypeInformationProtectionAws,
	}
}

// OnboardingState - Details about resource onboarding status across all connectors.
// OnboardedByOtherConnector - this resource has already been onboarded to another connector. This is only applicable to top-level
// resources. Onboarded - this resource has already been onboarded by the
// specified connector. NotOnboarded - this resource has not been onboarded to any connector. NotApplicable - the onboarding
// state is not applicable to the current endpoint.
type OnboardingState string

const (
	OnboardingStateNotApplicable             OnboardingState = "NotApplicable"
	OnboardingStateNotOnboarded              OnboardingState = "NotOnboarded"
	OnboardingStateOnboarded                 OnboardingState = "Onboarded"
	OnboardingStateOnboardedByOtherConnector OnboardingState = "OnboardedByOtherConnector"
)

// PossibleOnboardingStateValues returns the possible values for the OnboardingState const type.
func PossibleOnboardingStateValues() []OnboardingState {
	return []OnboardingState{
		OnboardingStateNotApplicable,
		OnboardingStateNotOnboarded,
		OnboardingStateOnboarded,
		OnboardingStateOnboardedByOtherConnector,
	}
}

// OperationResult - The status of the long run operation result of governance rule
type OperationResult string

const (
	// OperationResultCanceled - The operation canceled
	OperationResultCanceled OperationResult = "Canceled"
	// OperationResultFailed - The operation failed
	OperationResultFailed OperationResult = "Failed"
	// OperationResultSucceeded - The operation succeeded
	OperationResultSucceeded OperationResult = "Succeeded"
)

// PossibleOperationResultValues returns the possible values for the OperationResult const type.
func PossibleOperationResultValues() []OperationResult {
	return []OperationResult{
		OperationResultCanceled,
		OperationResultFailed,
		OperationResultSucceeded,
	}
}

// Operator - A valid comparer operator to use. A case-insensitive comparison will be applied for String PropertyType.
type Operator string

const (
	// OperatorContains - Applies only for non-decimal operands
	OperatorContains Operator = "Contains"
	// OperatorEndsWith - Applies only for non-decimal operands
	OperatorEndsWith Operator = "EndsWith"
	// OperatorEquals - Applies for decimal and non-decimal operands
	OperatorEquals Operator = "Equals"
	// OperatorGreaterThan - Applies only for decimal operands
	OperatorGreaterThan Operator = "GreaterThan"
	// OperatorGreaterThanOrEqualTo - Applies only for decimal operands
	OperatorGreaterThanOrEqualTo Operator = "GreaterThanOrEqualTo"
	// OperatorLesserThan - Applies only for decimal operands
	OperatorLesserThan Operator = "LesserThan"
	// OperatorLesserThanOrEqualTo - Applies only for decimal operands
	OperatorLesserThanOrEqualTo Operator = "LesserThanOrEqualTo"
	// OperatorNotEquals - Applies for decimal and non-decimal operands
	OperatorNotEquals Operator = "NotEquals"
	// OperatorStartsWith - Applies only for non-decimal operands
	OperatorStartsWith Operator = "StartsWith"
)

// PossibleOperatorValues returns the possible values for the Operator const type.
func PossibleOperatorValues() []Operator {
	return []Operator{
		OperatorContains,
		OperatorEndsWith,
		OperatorEquals,
		OperatorGreaterThan,
		OperatorGreaterThanOrEqualTo,
		OperatorLesserThan,
		OperatorLesserThanOrEqualTo,
		OperatorNotEquals,
		OperatorStartsWith,
	}
}

// OrganizationMembershipType - The multi cloud account's membership type in the organization
type OrganizationMembershipType string

const (
	OrganizationMembershipTypeMember       OrganizationMembershipType = "Member"
	OrganizationMembershipTypeOrganization OrganizationMembershipType = "Organization"
)

// PossibleOrganizationMembershipTypeValues returns the possible values for the OrganizationMembershipType const type.
func PossibleOrganizationMembershipTypeValues() []OrganizationMembershipType {
	return []OrganizationMembershipType{
		OrganizationMembershipTypeMember,
		OrganizationMembershipTypeOrganization,
	}
}

// PermissionProperty - A permission detected in the cloud account.
type PermissionProperty string

const (
	// PermissionPropertyAWSAWSSecurityHubReadOnlyAccess - This permission provides read only access to AWS Security Hub resources.
	PermissionPropertyAWSAWSSecurityHubReadOnlyAccess PermissionProperty = "AWS::AWSSecurityHubReadOnlyAccess"
	// PermissionPropertyAWSAmazonSSMAutomationRole - The permission provides for EC2 Automation service to execute activities
	// defined within Automation documents.
	PermissionPropertyAWSAmazonSSMAutomationRole PermissionProperty = "AWS::AmazonSSMAutomationRole"
	// PermissionPropertyAWSSecurityAudit - This permission grants access to read security configuration metadata.
	PermissionPropertyAWSSecurityAudit PermissionProperty = "AWS::SecurityAudit"
	// PermissionPropertyGCPSecurityCenterAdminViewer - This permission provides read only access to GCP Security Command Center.
	PermissionPropertyGCPSecurityCenterAdminViewer PermissionProperty = "GCP::Security Center Admin Viewer"
)

// PossiblePermissionPropertyValues returns the possible values for the PermissionProperty const type.
func PossiblePermissionPropertyValues() []PermissionProperty {
	return []PermissionProperty{
		PermissionPropertyAWSAWSSecurityHubReadOnlyAccess,
		PermissionPropertyAWSAmazonSSMAutomationRole,
		PermissionPropertyAWSSecurityAudit,
		PermissionPropertyGCPSecurityCenterAdminViewer,
	}
}

// PricingTier - Indicates whether the Defender plan is enabled on the selected scope. Microsoft Defender for Cloud is provided
// in two pricing tiers: free and standard. The standard tier offers advanced security
// capabilities, while the free tier offers basic security features.
type PricingTier string

const (
	// PricingTierFree - Get free Microsoft Defender for Cloud experience with basic security features
	PricingTierFree PricingTier = "Free"
	// PricingTierStandard - Get the standard Microsoft Defender for Cloud experience with advanced security features
	PricingTierStandard PricingTier = "Standard"
)

// PossiblePricingTierValues returns the possible values for the PricingTier const type.
func PossiblePricingTierValues() []PricingTier {
	return []PricingTier{
		PricingTierFree,
		PricingTierStandard,
	}
}

// PropertyType - The data type of the compared operands (string, integer, floating point number or a boolean [true/false]]
type PropertyType string

const (
	PropertyTypeBoolean PropertyType = "Boolean"
	PropertyTypeInteger PropertyType = "Integer"
	PropertyTypeNumber  PropertyType = "Number"
	PropertyTypeString  PropertyType = "String"
)

// PossiblePropertyTypeValues returns the possible values for the PropertyType const type.
func PossiblePropertyTypeValues() []PropertyType {
	return []PropertyType{
		PropertyTypeBoolean,
		PropertyTypeInteger,
		PropertyTypeNumber,
		PropertyTypeString,
	}
}

type Protocol string

const (
	ProtocolAll Protocol = "*"
	ProtocolTCP Protocol = "TCP"
	ProtocolUDP Protocol = "UDP"
)

// PossibleProtocolValues returns the possible values for the Protocol const type.
func PossibleProtocolValues() []Protocol {
	return []Protocol{
		ProtocolAll,
		ProtocolTCP,
		ProtocolUDP,
	}
}

// ProvisioningState - The security family provisioning State
type ProvisioningState string

const (
	ProvisioningStateFailed    ProvisioningState = "Failed"
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
	ProvisioningStateUpdating  ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns the possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{
		ProvisioningStateFailed,
		ProvisioningStateSucceeded,
		ProvisioningStateUpdating,
	}
}

// Rank - The rank of the sensitivity label.
type Rank string

const (
	RankCritical Rank = "Critical"
	RankHigh     Rank = "High"
	RankLow      Rank = "Low"
	RankMedium   Rank = "Medium"
	RankNone     Rank = "None"
)

// PossibleRankValues returns the possible values for the Rank const type.
func PossibleRankValues() []Rank {
	return []Rank{
		RankCritical,
		RankHigh,
		RankLow,
		RankMedium,
		RankNone,
	}
}

// RecommendationAction - The recommendation action of the machine or rule
type RecommendationAction string

const (
	RecommendationActionAdd         RecommendationAction = "Add"
	RecommendationActionRecommended RecommendationAction = "Recommended"
	RecommendationActionRemove      RecommendationAction = "Remove"
)

// PossibleRecommendationActionValues returns the possible values for the RecommendationAction const type.
func PossibleRecommendationActionValues() []RecommendationAction {
	return []RecommendationAction{
		RecommendationActionAdd,
		RecommendationActionRecommended,
		RecommendationActionRemove,
	}
}

// RecommendationConfigStatus - Recommendation status. When the recommendation status is disabled recommendations are not
// generated.
type RecommendationConfigStatus string

const (
	RecommendationConfigStatusDisabled RecommendationConfigStatus = "Disabled"
	RecommendationConfigStatusEnabled  RecommendationConfigStatus = "Enabled"
)

// PossibleRecommendationConfigStatusValues returns the possible values for the RecommendationConfigStatus const type.
func PossibleRecommendationConfigStatusValues() []RecommendationConfigStatus {
	return []RecommendationConfigStatus{
		RecommendationConfigStatusDisabled,
		RecommendationConfigStatusEnabled,
	}
}

// RecommendationStatus - The initial recommendation status of the machine group or machine
type RecommendationStatus string

const (
	RecommendationStatusNoStatus       RecommendationStatus = "NoStatus"
	RecommendationStatusNotAvailable   RecommendationStatus = "NotAvailable"
	RecommendationStatusNotRecommended RecommendationStatus = "NotRecommended"
	RecommendationStatusRecommended    RecommendationStatus = "Recommended"
)

// PossibleRecommendationStatusValues returns the possible values for the RecommendationStatus const type.
func PossibleRecommendationStatusValues() []RecommendationStatus {
	return []RecommendationStatus{
		RecommendationStatusNoStatus,
		RecommendationStatusNotAvailable,
		RecommendationStatusNotRecommended,
		RecommendationStatusRecommended,
	}
}

// RecommendationType - The type of IoT Security recommendation.
type RecommendationType string

const (
	// RecommendationTypeIoTAcrauthentication - Authentication schema used for pull an edge module from an ACR repository does
	// not use Service Principal Authentication.
	RecommendationTypeIoTAcrauthentication RecommendationType = "IoT_ACRAuthentication"
	// RecommendationTypeIoTAgentSendsUnutilizedMessages - IoT agent message size capacity is currently underutilized, causing
	// an increase in the number of sent messages. Adjust message intervals for better utilization.
	RecommendationTypeIoTAgentSendsUnutilizedMessages RecommendationType = "IoT_AgentSendsUnutilizedMessages"
	// RecommendationTypeIoTBaseline - Identified security related system configuration issues.
	RecommendationTypeIoTBaseline RecommendationType = "IoT_Baseline"
	// RecommendationTypeIoTEdgeHubMemOptimize - You can optimize Edge Hub memory usage by turning off protocol heads for any
	// protocols not used by Edge modules in your solution.
	RecommendationTypeIoTEdgeHubMemOptimize RecommendationType = "IoT_EdgeHubMemOptimize"
	// RecommendationTypeIoTEdgeLoggingOptions - Logging is disabled for this edge module.
	RecommendationTypeIoTEdgeLoggingOptions RecommendationType = "IoT_EdgeLoggingOptions"
	// RecommendationTypeIoTInconsistentModuleSettings - A minority within a device security group has inconsistent Edge Module
	// settings with the rest of their group.
	RecommendationTypeIoTInconsistentModuleSettings RecommendationType = "IoT_InconsistentModuleSettings"
	// RecommendationTypeIoTInstallAgent - Install the Azure Security of Things Agent.
	RecommendationTypeIoTInstallAgent RecommendationType = "IoT_InstallAgent"
	// RecommendationTypeIoTIpfilterDenyAll - IP Filter Configuration should have rules defined for allowed traffic and should
	// deny all other traffic by default.
	RecommendationTypeIoTIpfilterDenyAll RecommendationType = "IoT_IPFilter_DenyAll"
	// RecommendationTypeIoTIpfilterPermissiveRule - An Allow IP Filter rules source IP range is too large. Overly permissive
	// rules might expose your IoT hub to malicious intenders.
	RecommendationTypeIoTIpfilterPermissiveRule RecommendationType = "IoT_IPFilter_PermissiveRule"
	// RecommendationTypeIoTOpenPorts - A listening endpoint was found on the device.
	RecommendationTypeIoTOpenPorts RecommendationType = "IoT_OpenPorts"
	// RecommendationTypeIoTPermissiveFirewallPolicy - An Allowed firewall policy was found (INPUT/OUTPUT). The policy should
	// Deny all traffic by default and define rules to allow necessary communication to/from the device.
	RecommendationTypeIoTPermissiveFirewallPolicy RecommendationType = "IoT_PermissiveFirewallPolicy"
	// RecommendationTypeIoTPermissiveInputFirewallRules - A rule in the firewall has been found that contains a permissive pattern
	// for a wide range of IP addresses or Ports.
	RecommendationTypeIoTPermissiveInputFirewallRules RecommendationType = "IoT_PermissiveInputFirewallRules"
	// RecommendationTypeIoTPermissiveOutputFirewallRules - A rule in the firewall has been found that contains a permissive pattern
	// for a wide range of IP addresses or Ports.
	RecommendationTypeIoTPermissiveOutputFirewallRules RecommendationType = "IoT_PermissiveOutputFirewallRules"
	// RecommendationTypeIoTPrivilegedDockerOptions - Edge module is configured to run in privileged mode, with extensive Linux
	// capabilities or with host-level network access (send/receive data to host machine).
	RecommendationTypeIoTPrivilegedDockerOptions RecommendationType = "IoT_PrivilegedDockerOptions"
	// RecommendationTypeIoTSharedCredentials - Same authentication credentials to the IoT Hub used by multiple devices. This
	// could indicate an illegitimate device impersonating a legitimate device. It also exposes the risk of device impersonation
	// by an attacker.
	RecommendationTypeIoTSharedCredentials RecommendationType = "IoT_SharedCredentials"
	// RecommendationTypeIoTVulnerableTLSCipherSuite - Insecure TLS configurations detected. Immediate upgrade recommended.
	RecommendationTypeIoTVulnerableTLSCipherSuite RecommendationType = "IoT_VulnerableTLSCipherSuite"
)

// PossibleRecommendationTypeValues returns the possible values for the RecommendationType const type.
func PossibleRecommendationTypeValues() []RecommendationType {
	return []RecommendationType{
		RecommendationTypeIoTAcrauthentication,
		RecommendationTypeIoTAgentSendsUnutilizedMessages,
		RecommendationTypeIoTBaseline,
		RecommendationTypeIoTEdgeHubMemOptimize,
		RecommendationTypeIoTEdgeLoggingOptions,
		RecommendationTypeIoTInconsistentModuleSettings,
		RecommendationTypeIoTInstallAgent,
		RecommendationTypeIoTIpfilterDenyAll,
		RecommendationTypeIoTIpfilterPermissiveRule,
		RecommendationTypeIoTOpenPorts,
		RecommendationTypeIoTPermissiveFirewallPolicy,
		RecommendationTypeIoTPermissiveInputFirewallRules,
		RecommendationTypeIoTPermissiveOutputFirewallRules,
		RecommendationTypeIoTPrivilegedDockerOptions,
		RecommendationTypeIoTSharedCredentials,
		RecommendationTypeIoTVulnerableTLSCipherSuite,
	}
}

// ReportedSeverity - Assessed alert severity.
type ReportedSeverity string

const (
	ReportedSeverityHigh          ReportedSeverity = "High"
	ReportedSeverityInformational ReportedSeverity = "Informational"
	ReportedSeverityLow           ReportedSeverity = "Low"
	ReportedSeverityMedium        ReportedSeverity = "Medium"
)

// PossibleReportedSeverityValues returns the possible values for the ReportedSeverity const type.
func PossibleReportedSeverityValues() []ReportedSeverity {
	return []ReportedSeverity{
		ReportedSeverityHigh,
		ReportedSeverityInformational,
		ReportedSeverityLow,
		ReportedSeverityMedium,
	}
}

// ResourceIdentifierType - There can be multiple identifiers of different type per alert, this field specify the identifier
// type.
type ResourceIdentifierType string

const (
	ResourceIdentifierTypeAzureResource ResourceIdentifierType = "AzureResource"
	ResourceIdentifierTypeLogAnalytics  ResourceIdentifierType = "LogAnalytics"
)

// PossibleResourceIdentifierTypeValues returns the possible values for the ResourceIdentifierType const type.
func PossibleResourceIdentifierTypeValues() []ResourceIdentifierType {
	return []ResourceIdentifierType{
		ResourceIdentifierTypeAzureResource,
		ResourceIdentifierTypeLogAnalytics,
	}
}

// ResourceStatus - The status of the resource regarding a single assessment
type ResourceStatus string

const (
	// ResourceStatusHealthy - This assessment on the resource is healthy
	ResourceStatusHealthy ResourceStatus = "Healthy"
	// ResourceStatusNotApplicable - This assessment is not applicable to this resource
	ResourceStatusNotApplicable ResourceStatus = "NotApplicable"
	// ResourceStatusNotHealthy - This assessment on the resource is not healthy
	ResourceStatusNotHealthy ResourceStatus = "NotHealthy"
	// ResourceStatusOffByPolicy - This assessment is turned off by policy on this subscription
	ResourceStatusOffByPolicy ResourceStatus = "OffByPolicy"
)

// PossibleResourceStatusValues returns the possible values for the ResourceStatus const type.
func PossibleResourceStatusValues() []ResourceStatus {
	return []ResourceStatus{
		ResourceStatusHealthy,
		ResourceStatusNotApplicable,
		ResourceStatusNotHealthy,
		ResourceStatusOffByPolicy,
	}
}

// ResourcesCoverageStatus - This field is available for subscription-level only, and reflects the coverage status of the
// resources under the subscription. Please note: The "pricingTier" field reflects the plan status of the
// subscription. However, since the plan status can also be defined at the resource level, there might be misalignment between
// the subscription's plan status and the resource status. This field helps
// indicate the coverage status of the resources.
type ResourcesCoverageStatus string

const (
	// ResourcesCoverageStatusFullyCovered - This value indicates that all resources associated with the subscription have the
	// Defender plan enabled.
	ResourcesCoverageStatusFullyCovered ResourcesCoverageStatus = "FullyCovered"
	// ResourcesCoverageStatusNotCovered - This value indicates that the Defender plan is disabled for all resources under the
	// subscription. None of the resources are protected by the Defender plan.
	ResourcesCoverageStatusNotCovered ResourcesCoverageStatus = "NotCovered"
	// ResourcesCoverageStatusPartiallyCovered - This value indicates that some resources under the subscription have the Defender
	// plan enabled, while others have it disabled. There is a mixed coverage status among resources.
	ResourcesCoverageStatusPartiallyCovered ResourcesCoverageStatus = "PartiallyCovered"
)

// PossibleResourcesCoverageStatusValues returns the possible values for the ResourcesCoverageStatus const type.
func PossibleResourcesCoverageStatusValues() []ResourcesCoverageStatus {
	return []ResourcesCoverageStatus{
		ResourcesCoverageStatusFullyCovered,
		ResourcesCoverageStatusNotCovered,
		ResourcesCoverageStatusPartiallyCovered,
	}
}

// Roles - A possible role to configure sending security notification alerts to
type Roles string

const (
	// RolesAccountAdmin - If enabled, send notification on new alerts to the account admins
	RolesAccountAdmin Roles = "AccountAdmin"
	// RolesContributor - If enabled, send notification on new alerts to the subscription contributors
	RolesContributor Roles = "Contributor"
	// RolesOwner - If enabled, send notification on new alerts to the subscription owners
	RolesOwner Roles = "Owner"
	// RolesServiceAdmin - If enabled, send notification on new alerts to the service admins
	RolesServiceAdmin Roles = "ServiceAdmin"
)

// PossibleRolesValues returns the possible values for the Roles const type.
func PossibleRolesValues() []Roles {
	return []Roles{
		RolesAccountAdmin,
		RolesContributor,
		RolesOwner,
		RolesServiceAdmin,
	}
}

// RuleCategory - Rule categories. Code - code scanning results. Artifact scanning results. Dependencies scanning results.
// IaC results. Secrets scanning results. Container scanning results.
type RuleCategory string

const (
	RuleCategoryArtifacts    RuleCategory = "Artifacts"
	RuleCategoryCode         RuleCategory = "Code"
	RuleCategoryContainers   RuleCategory = "Containers"
	RuleCategoryDependencies RuleCategory = "Dependencies"
	RuleCategoryIaC          RuleCategory = "IaC"
	RuleCategorySecrets      RuleCategory = "Secrets"
)

// PossibleRuleCategoryValues returns the possible values for the RuleCategory const type.
func PossibleRuleCategoryValues() []RuleCategory {
	return []RuleCategory{
		RuleCategoryArtifacts,
		RuleCategoryCode,
		RuleCategoryContainers,
		RuleCategoryDependencies,
		RuleCategoryIaC,
		RuleCategorySecrets,
	}
}

// RuleSeverity - The rule severity.
type RuleSeverity string

const (
	// RuleSeverityHigh - High
	RuleSeverityHigh RuleSeverity = "High"
	// RuleSeverityInformational - Informational
	RuleSeverityInformational RuleSeverity = "Informational"
	// RuleSeverityLow - Low
	RuleSeverityLow RuleSeverity = "Low"
	// RuleSeverityMedium - Medium
	RuleSeverityMedium RuleSeverity = "Medium"
	// RuleSeverityObsolete - Obsolete
	RuleSeverityObsolete RuleSeverity = "Obsolete"
)

// PossibleRuleSeverityValues returns the possible values for the RuleSeverity const type.
func PossibleRuleSeverityValues() []RuleSeverity {
	return []RuleSeverity{
		RuleSeverityHigh,
		RuleSeverityInformational,
		RuleSeverityLow,
		RuleSeverityMedium,
		RuleSeverityObsolete,
	}
}

// RuleState - Possible states of the rule
type RuleState string

const (
	RuleStateDisabled RuleState = "Disabled"
	RuleStateEnabled  RuleState = "Enabled"
	RuleStateExpired  RuleState = "Expired"
)

// PossibleRuleStateValues returns the possible values for the RuleState const type.
func PossibleRuleStateValues() []RuleState {
	return []RuleState{
		RuleStateDisabled,
		RuleStateEnabled,
		RuleStateExpired,
	}
}

// RuleStatus - The rule result status.
type RuleStatus string

const (
	// RuleStatusFinding - Finding
	RuleStatusFinding RuleStatus = "Finding"
	// RuleStatusInternalError - InternalError
	RuleStatusInternalError RuleStatus = "InternalError"
	// RuleStatusNonFinding - NonFinding
	RuleStatusNonFinding RuleStatus = "NonFinding"
)

// PossibleRuleStatusValues returns the possible values for the RuleStatus const type.
func PossibleRuleStatusValues() []RuleStatus {
	return []RuleStatus{
		RuleStatusFinding,
		RuleStatusInternalError,
		RuleStatusNonFinding,
	}
}

// RuleType - The rule type.
type RuleType string

const (
	// RuleTypeBaselineExpected - BaselineExpected
	RuleTypeBaselineExpected RuleType = "BaselineExpected"
	// RuleTypeBinary - Binary
	RuleTypeBinary RuleType = "Binary"
	// RuleTypeNegativeList - NegativeList
	RuleTypeNegativeList RuleType = "NegativeList"
	// RuleTypePositiveList - PositiveList
	RuleTypePositiveList RuleType = "PositiveList"
)

// PossibleRuleTypeValues returns the possible values for the RuleType const type.
func PossibleRuleTypeValues() []RuleType {
	return []RuleType{
		RuleTypeBaselineExpected,
		RuleTypeBinary,
		RuleTypeNegativeList,
		RuleTypePositiveList,
	}
}

// ScanState - The scan status.
type ScanState string

const (
	// ScanStateFailed - Failed
	ScanStateFailed ScanState = "Failed"
	// ScanStateFailedToRun - FailedToRun
	ScanStateFailedToRun ScanState = "FailedToRun"
	// ScanStateInProgress - InProgress
	ScanStateInProgress ScanState = "InProgress"
	// ScanStatePassed - Passed
	ScanStatePassed ScanState = "Passed"
)

// PossibleScanStateValues returns the possible values for the ScanState const type.
func PossibleScanStateValues() []ScanState {
	return []ScanState{
		ScanStateFailed,
		ScanStateFailedToRun,
		ScanStateInProgress,
		ScanStatePassed,
	}
}

// ScanTriggerType - The scan trigger type.
type ScanTriggerType string

const (
	// ScanTriggerTypeOnDemand - OnDemand
	ScanTriggerTypeOnDemand ScanTriggerType = "OnDemand"
	// ScanTriggerTypeRecurring - Recurring
	ScanTriggerTypeRecurring ScanTriggerType = "Recurring"
)

// PossibleScanTriggerTypeValues returns the possible values for the ScanTriggerType const type.
func PossibleScanTriggerTypeValues() []ScanTriggerType {
	return []ScanTriggerType{
		ScanTriggerTypeOnDemand,
		ScanTriggerTypeRecurring,
	}
}

// ScanningMode - The scanning mode for the VM scan.
type ScanningMode string

const (
	ScanningModeDefault ScanningMode = "Default"
)

// PossibleScanningModeValues returns the possible values for the ScanningMode const type.
func PossibleScanningModeValues() []ScanningMode {
	return []ScanningMode{
		ScanningModeDefault,
	}
}

// SecurityFamily - The security family of the discovered solution
type SecurityFamily string

const (
	SecurityFamilyNgfw    SecurityFamily = "Ngfw"
	SecurityFamilySaasWaf SecurityFamily = "SaasWaf"
	SecurityFamilyVa      SecurityFamily = "Va"
	SecurityFamilyWaf     SecurityFamily = "Waf"
)

// PossibleSecurityFamilyValues returns the possible values for the SecurityFamily const type.
func PossibleSecurityFamilyValues() []SecurityFamily {
	return []SecurityFamily{
		SecurityFamilyNgfw,
		SecurityFamilySaasWaf,
		SecurityFamilyVa,
		SecurityFamilyWaf,
	}
}

// SecuritySolutionStatus - Status of the IoT Security solution.
type SecuritySolutionStatus string

const (
	SecuritySolutionStatusDisabled SecuritySolutionStatus = "Disabled"
	SecuritySolutionStatusEnabled  SecuritySolutionStatus = "Enabled"
)

// PossibleSecuritySolutionStatusValues returns the possible values for the SecuritySolutionStatus const type.
func PossibleSecuritySolutionStatusValues() []SecuritySolutionStatus {
	return []SecuritySolutionStatus{
		SecuritySolutionStatusDisabled,
		SecuritySolutionStatusEnabled,
	}
}

// ServerVulnerabilityAssessmentPropertiesProvisioningState - The provisioningState of the vulnerability assessment capability
// on the VM
type ServerVulnerabilityAssessmentPropertiesProvisioningState string

const (
	ServerVulnerabilityAssessmentPropertiesProvisioningStateCanceled       ServerVulnerabilityAssessmentPropertiesProvisioningState = "Canceled"
	ServerVulnerabilityAssessmentPropertiesProvisioningStateDeprovisioning ServerVulnerabilityAssessmentPropertiesProvisioningState = "Deprovisioning"
	ServerVulnerabilityAssessmentPropertiesProvisioningStateFailed         ServerVulnerabilityAssessmentPropertiesProvisioningState = "Failed"
	ServerVulnerabilityAssessmentPropertiesProvisioningStateProvisioning   ServerVulnerabilityAssessmentPropertiesProvisioningState = "Provisioning"
	ServerVulnerabilityAssessmentPropertiesProvisioningStateSucceeded      ServerVulnerabilityAssessmentPropertiesProvisioningState = "Succeeded"
)

// PossibleServerVulnerabilityAssessmentPropertiesProvisioningStateValues returns the possible values for the ServerVulnerabilityAssessmentPropertiesProvisioningState const type.
func PossibleServerVulnerabilityAssessmentPropertiesProvisioningStateValues() []ServerVulnerabilityAssessmentPropertiesProvisioningState {
	return []ServerVulnerabilityAssessmentPropertiesProvisioningState{
		ServerVulnerabilityAssessmentPropertiesProvisioningStateCanceled,
		ServerVulnerabilityAssessmentPropertiesProvisioningStateDeprovisioning,
		ServerVulnerabilityAssessmentPropertiesProvisioningStateFailed,
		ServerVulnerabilityAssessmentPropertiesProvisioningStateProvisioning,
		ServerVulnerabilityAssessmentPropertiesProvisioningStateSucceeded,
	}
}

// ServerVulnerabilityAssessmentsAzureSettingSelectedProvider - The selected vulnerability assessments provider on Azure servers
// in the defined scope.
type ServerVulnerabilityAssessmentsAzureSettingSelectedProvider string

const (
	// ServerVulnerabilityAssessmentsAzureSettingSelectedProviderMdeTvm - Microsoft Defender for Endpoints threat and vulnerability
	// management.
	ServerVulnerabilityAssessmentsAzureSettingSelectedProviderMdeTvm ServerVulnerabilityAssessmentsAzureSettingSelectedProvider = "MdeTvm"
)

// PossibleServerVulnerabilityAssessmentsAzureSettingSelectedProviderValues returns the possible values for the ServerVulnerabilityAssessmentsAzureSettingSelectedProvider const type.
func PossibleServerVulnerabilityAssessmentsAzureSettingSelectedProviderValues() []ServerVulnerabilityAssessmentsAzureSettingSelectedProvider {
	return []ServerVulnerabilityAssessmentsAzureSettingSelectedProvider{
		ServerVulnerabilityAssessmentsAzureSettingSelectedProviderMdeTvm,
	}
}

// ServerVulnerabilityAssessmentsSettingKind - The kind of the server vulnerability assessments setting
type ServerVulnerabilityAssessmentsSettingKind string

const (
	ServerVulnerabilityAssessmentsSettingKindAzureServersSetting ServerVulnerabilityAssessmentsSettingKind = "AzureServersSetting"
)

// PossibleServerVulnerabilityAssessmentsSettingKindValues returns the possible values for the ServerVulnerabilityAssessmentsSettingKind const type.
func PossibleServerVulnerabilityAssessmentsSettingKindValues() []ServerVulnerabilityAssessmentsSettingKind {
	return []ServerVulnerabilityAssessmentsSettingKind{
		ServerVulnerabilityAssessmentsSettingKindAzureServersSetting,
	}
}

type ServerVulnerabilityAssessmentsSettingKindName string

const (
	ServerVulnerabilityAssessmentsSettingKindNameAzureServersSetting ServerVulnerabilityAssessmentsSettingKindName = "azureServersSetting"
)

// PossibleServerVulnerabilityAssessmentsSettingKindNameValues returns the possible values for the ServerVulnerabilityAssessmentsSettingKindName const type.
func PossibleServerVulnerabilityAssessmentsSettingKindNameValues() []ServerVulnerabilityAssessmentsSettingKindName {
	return []ServerVulnerabilityAssessmentsSettingKindName{
		ServerVulnerabilityAssessmentsSettingKindNameAzureServersSetting,
	}
}

// SettingKind - the kind of the settings string
type SettingKind string

const (
	SettingKindAlertSuppressionSetting SettingKind = "AlertSuppressionSetting"
	SettingKindAlertSyncSettings       SettingKind = "AlertSyncSettings"
	SettingKindDataExportSettings      SettingKind = "DataExportSettings"
)

// PossibleSettingKindValues returns the possible values for the SettingKind const type.
func PossibleSettingKindValues() []SettingKind {
	return []SettingKind{
		SettingKindAlertSuppressionSetting,
		SettingKindAlertSyncSettings,
		SettingKindDataExportSettings,
	}
}

type SettingName string

const (
	// SettingNameCurrent - Name of the Defender for Storage Settings name.
	SettingNameCurrent SettingName = "current"
)

// PossibleSettingNameValues returns the possible values for the SettingName const type.
func PossibleSettingNameValues() []SettingName {
	return []SettingName{
		SettingNameCurrent,
	}
}

type SettingNameAutoGenerated string

const (
	SettingNameAutoGeneratedMCAS                           SettingNameAutoGenerated = "MCAS"
	SettingNameAutoGeneratedSentinel                       SettingNameAutoGenerated = "Sentinel"
	SettingNameAutoGeneratedWDATP                          SettingNameAutoGenerated = "WDATP"
	SettingNameAutoGeneratedWDATPEXCLUDELINUXPUBLICPREVIEW SettingNameAutoGenerated = "WDATP_EXCLUDE_LINUX_PUBLIC_PREVIEW"
	SettingNameAutoGeneratedWDATPUNIFIEDSOLUTION           SettingNameAutoGenerated = "WDATP_UNIFIED_SOLUTION"
)

// PossibleSettingNameAutoGeneratedValues returns the possible values for the SettingNameAutoGenerated const type.
func PossibleSettingNameAutoGeneratedValues() []SettingNameAutoGenerated {
	return []SettingNameAutoGenerated{
		SettingNameAutoGeneratedMCAS,
		SettingNameAutoGeneratedSentinel,
		SettingNameAutoGeneratedWDATP,
		SettingNameAutoGeneratedWDATPEXCLUDELINUXPUBLICPREVIEW,
		SettingNameAutoGeneratedWDATPUNIFIEDSOLUTION,
	}
}

// Severity - The sub-assessment severity level
type Severity string

const (
	SeverityHigh   Severity = "High"
	SeverityLow    Severity = "Low"
	SeverityMedium Severity = "Medium"
)

// PossibleSeverityValues returns the possible values for the Severity const type.
func PossibleSeverityValues() []Severity {
	return []Severity{
		SeverityHigh,
		SeverityLow,
		SeverityMedium,
	}
}

// SeverityEnum - The severity to relate to the assessments generated by this assessment automation.
type SeverityEnum string

const (
	SeverityEnumHigh   SeverityEnum = "High"
	SeverityEnumLow    SeverityEnum = "Low"
	SeverityEnumMedium SeverityEnum = "Medium"
)

// PossibleSeverityEnumValues returns the possible values for the SeverityEnum const type.
func PossibleSeverityEnumValues() []SeverityEnum {
	return []SeverityEnum{
		SeverityEnumHigh,
		SeverityEnumLow,
		SeverityEnumMedium,
	}
}

// Source - The platform where the assessed resource resides
type Source string

const (
	// SourceAzure - Resource is in Azure
	SourceAzure Source = "Azure"
	// SourceOnPremise - Resource in an on premise machine connected to Azure cloud
	SourceOnPremise Source = "OnPremise"
	// SourceOnPremiseSQL - SQL Resource in an on premise machine connected to Azure cloud
	SourceOnPremiseSQL Source = "OnPremiseSql"
)

// PossibleSourceValues returns the possible values for the Source const type.
func PossibleSourceValues() []Source {
	return []Source{
		SourceAzure,
		SourceOnPremise,
		SourceOnPremiseSQL,
	}
}

// SourceSystem - The source type of the machine group
type SourceSystem string

const (
	SourceSystemAzureAppLocker    SourceSystem = "Azure_AppLocker"
	SourceSystemAzureAuditD       SourceSystem = "Azure_AuditD"
	SourceSystemNonAzureAppLocker SourceSystem = "NonAzure_AppLocker"
	SourceSystemNonAzureAuditD    SourceSystem = "NonAzure_AuditD"
	SourceSystemNone              SourceSystem = "None"
)

// PossibleSourceSystemValues returns the possible values for the SourceSystem const type.
func PossibleSourceSystemValues() []SourceSystem {
	return []SourceSystem{
		SourceSystemAzureAppLocker,
		SourceSystemAzureAuditD,
		SourceSystemNonAzureAppLocker,
		SourceSystemNonAzureAuditD,
		SourceSystemNone,
	}
}

// State - Aggregative state based on the standard's supported controls states
type State string

const (
	// StateFailed - At least one supported regulatory compliance control in the given standard has a state of failed
	StateFailed State = "Failed"
	// StatePassed - All supported regulatory compliance controls in the given standard have a passed state
	StatePassed State = "Passed"
	// StateSkipped - All supported regulatory compliance controls in the given standard have a state of skipped
	StateSkipped State = "Skipped"
	// StateUnsupported - No supported regulatory compliance data for the given standard
	StateUnsupported State = "Unsupported"
)

// PossibleStateValues returns the possible values for the State const type.
func PossibleStateValues() []State {
	return []State{
		StateFailed,
		StatePassed,
		StateSkipped,
		StateUnsupported,
	}
}

// Status - The status of the port
type Status string

const (
	StatusInitiated Status = "Initiated"
	StatusRevoked   Status = "Revoked"
)

// PossibleStatusValues returns the possible values for the Status const type.
func PossibleStatusValues() []Status {
	return []Status{
		StatusInitiated,
		StatusRevoked,
	}
}

// StatusName - The status of the health report
type StatusName string

const (
	StatusNameHealthy       StatusName = "Healthy"
	StatusNameNotApplicable StatusName = "NotApplicable"
	StatusNameNotHealthy    StatusName = "NotHealthy"
)

// PossibleStatusNameValues returns the possible values for the StatusName const type.
func PossibleStatusNameValues() []StatusName {
	return []StatusName{
		StatusNameHealthy,
		StatusNameNotApplicable,
		StatusNameNotHealthy,
	}
}

// StatusReason - A description of why the status has its value
type StatusReason string

const (
	StatusReasonExpired               StatusReason = "Expired"
	StatusReasonNewerRequestInitiated StatusReason = "NewerRequestInitiated"
	StatusReasonUserRequested         StatusReason = "UserRequested"
)

// PossibleStatusReasonValues returns the possible values for the StatusReason const type.
func PossibleStatusReasonValues() []StatusReason {
	return []StatusReason{
		StatusReasonExpired,
		StatusReasonNewerRequestInitiated,
		StatusReasonUserRequested,
	}
}

// SubAssessmentStatusCode - Programmatic code for the status of the assessment
type SubAssessmentStatusCode string

const (
	// SubAssessmentStatusCodeHealthy - The resource is healthy
	SubAssessmentStatusCodeHealthy SubAssessmentStatusCode = "Healthy"
	// SubAssessmentStatusCodeNotApplicable - Assessment for this resource did not happen
	SubAssessmentStatusCodeNotApplicable SubAssessmentStatusCode = "NotApplicable"
	// SubAssessmentStatusCodeUnhealthy - The resource has a security issue that needs to be addressed
	SubAssessmentStatusCodeUnhealthy SubAssessmentStatusCode = "Unhealthy"
)

// PossibleSubAssessmentStatusCodeValues returns the possible values for the SubAssessmentStatusCode const type.
func PossibleSubAssessmentStatusCodeValues() []SubAssessmentStatusCode {
	return []SubAssessmentStatusCode{
		SubAssessmentStatusCodeHealthy,
		SubAssessmentStatusCodeNotApplicable,
		SubAssessmentStatusCodeUnhealthy,
	}
}

// SubPlan - The available sub plans
type SubPlan string

const (
	SubPlanP1 SubPlan = "P1"
	SubPlanP2 SubPlan = "P2"
)

// PossibleSubPlanValues returns the possible values for the SubPlan const type.
func PossibleSubPlanValues() []SubPlan {
	return []SubPlan{
		SubPlanP1,
		SubPlanP2,
	}
}

// SupportedCloudEnum - Relevant cloud for the custom assessment automation.
type SupportedCloudEnum string

const (
	SupportedCloudEnumAWS SupportedCloudEnum = "AWS"
	SupportedCloudEnumGCP SupportedCloudEnum = "GCP"
)

// PossibleSupportedCloudEnumValues returns the possible values for the SupportedCloudEnum const type.
func PossibleSupportedCloudEnumValues() []SupportedCloudEnum {
	return []SupportedCloudEnum{
		SupportedCloudEnumAWS,
		SupportedCloudEnumGCP,
	}
}

// Tactics - Tactic of the assessment
type Tactics string

const (
	TacticsCollection          Tactics = "Collection"
	TacticsCommandAndControl   Tactics = "Command and Control"
	TacticsCredentialAccess    Tactics = "Credential Access"
	TacticsDefenseEvasion      Tactics = "Defense Evasion"
	TacticsDiscovery           Tactics = "Discovery"
	TacticsExecution           Tactics = "Execution"
	TacticsExfiltration        Tactics = "Exfiltration"
	TacticsImpact              Tactics = "Impact"
	TacticsInitialAccess       Tactics = "Initial Access"
	TacticsLateralMovement     Tactics = "Lateral Movement"
	TacticsPersistence         Tactics = "Persistence"
	TacticsPrivilegeEscalation Tactics = "Privilege Escalation"
	TacticsReconnaissance      Tactics = "Reconnaissance"
	TacticsResourceDevelopment Tactics = "Resource Development"
)

// PossibleTacticsValues returns the possible values for the Tactics const type.
func PossibleTacticsValues() []Tactics {
	return []Tactics{
		TacticsCollection,
		TacticsCommandAndControl,
		TacticsCredentialAccess,
		TacticsDefenseEvasion,
		TacticsDiscovery,
		TacticsExecution,
		TacticsExfiltration,
		TacticsImpact,
		TacticsInitialAccess,
		TacticsLateralMovement,
		TacticsPersistence,
		TacticsPrivilegeEscalation,
		TacticsReconnaissance,
		TacticsResourceDevelopment,
	}
}

type TaskUpdateActionType string

const (
	TaskUpdateActionTypeActivate TaskUpdateActionType = "Activate"
	TaskUpdateActionTypeClose    TaskUpdateActionType = "Close"
	TaskUpdateActionTypeDismiss  TaskUpdateActionType = "Dismiss"
	TaskUpdateActionTypeResolve  TaskUpdateActionType = "Resolve"
	TaskUpdateActionTypeStart    TaskUpdateActionType = "Start"
)

// PossibleTaskUpdateActionTypeValues returns the possible values for the TaskUpdateActionType const type.
func PossibleTaskUpdateActionTypeValues() []TaskUpdateActionType {
	return []TaskUpdateActionType{
		TaskUpdateActionTypeActivate,
		TaskUpdateActionTypeClose,
		TaskUpdateActionTypeDismiss,
		TaskUpdateActionTypeResolve,
		TaskUpdateActionTypeStart,
	}
}

// Techniques - Techniques of the assessment
type Techniques string

const (
	TechniquesAbuseElevationControlMechanism          Techniques = "Abuse Elevation Control Mechanism"
	TechniquesAccessTokenManipulation                 Techniques = "Access Token Manipulation"
	TechniquesAccountDiscovery                        Techniques = "Account Discovery"
	TechniquesAccountManipulation                     Techniques = "Account Manipulation"
	TechniquesActiveScanning                          Techniques = "Active Scanning"
	TechniquesApplicationLayerProtocol                Techniques = "Application Layer Protocol"
	TechniquesAudioCapture                            Techniques = "Audio Capture"
	TechniquesBootOrLogonAutostartExecution           Techniques = "Boot or Logon Autostart Execution"
	TechniquesBootOrLogonInitializationScripts        Techniques = "Boot or Logon Initialization Scripts"
	TechniquesBruteForce                              Techniques = "Brute Force"
	TechniquesCloudInfrastructureDiscovery            Techniques = "Cloud Infrastructure Discovery"
	TechniquesCloudServiceDashboard                   Techniques = "Cloud Service Dashboard"
	TechniquesCloudServiceDiscovery                   Techniques = "Cloud Service Discovery"
	TechniquesCommandAndScriptingInterpreter          Techniques = "Command and Scripting Interpreter"
	TechniquesCompromiseClientSoftwareBinary          Techniques = "Compromise Client Software Binary"
	TechniquesCompromiseInfrastructure                Techniques = "Compromise Infrastructure"
	TechniquesContainerAndResourceDiscovery           Techniques = "Container and Resource Discovery"
	TechniquesCreateAccount                           Techniques = "Create Account"
	TechniquesCreateOrModifySystemProcess             Techniques = "Create or Modify System Process"
	TechniquesCredentialsFromPasswordStores           Techniques = "Credentials from Password Stores"
	TechniquesDataDestruction                         Techniques = "Data Destruction"
	TechniquesDataEncryptedForImpact                  Techniques = "Data Encrypted for Impact"
	TechniquesDataFromCloudStorageObject              Techniques = "Data from Cloud Storage Object"
	TechniquesDataFromConfigurationRepository         Techniques = "Data from Configuration Repository"
	TechniquesDataFromInformationRepositories         Techniques = "Data from Information Repositories"
	TechniquesDataFromLocalSystem                     Techniques = "Data from Local System"
	TechniquesDataManipulation                        Techniques = "Data Manipulation"
	TechniquesDataStaged                              Techniques = "Data Staged"
	TechniquesDefacement                              Techniques = "Defacement"
	TechniquesDeobfuscateDecodeFilesOrInformation     Techniques = "Deobfuscate/Decode Files or Information"
	TechniquesDiskWipe                                Techniques = "Disk Wipe"
	TechniquesDomainTrustDiscovery                    Techniques = "Domain Trust Discovery"
	TechniquesDriveByCompromise                       Techniques = "Drive-by Compromise"
	TechniquesDynamicResolution                       Techniques = "Dynamic Resolution"
	TechniquesEndpointDenialOfService                 Techniques = "Endpoint Denial of Service"
	TechniquesEventTriggeredExecution                 Techniques = "Event Triggered Execution"
	TechniquesExfiltrationOverAlternativeProtocol     Techniques = "Exfiltration Over Alternative Protocol"
	TechniquesExploitPublicFacingApplication          Techniques = "Exploit Public-Facing Application"
	TechniquesExploitationForClientExecution          Techniques = "Exploitation for Client Execution"
	TechniquesExploitationForCredentialAccess         Techniques = "Exploitation for Credential Access"
	TechniquesExploitationForDefenseEvasion           Techniques = "Exploitation for Defense Evasion"
	TechniquesExploitationForPrivilegeEscalation      Techniques = "Exploitation for Privilege Escalation"
	TechniquesExploitationOfRemoteServices            Techniques = "Exploitation of Remote Services"
	TechniquesExternalRemoteServices                  Techniques = "External Remote Services"
	TechniquesFallbackChannels                        Techniques = "Fallback Channels"
	TechniquesFileAndDirectoryDiscovery               Techniques = "File and Directory Discovery"
	TechniquesFileAndDirectoryPermissionsModification Techniques = "File and Directory Permissions Modification"
	TechniquesGatherVictimNetworkInformation          Techniques = "Gather Victim Network Information"
	TechniquesHideArtifacts                           Techniques = "Hide Artifacts"
	TechniquesHijackExecutionFlow                     Techniques = "Hijack Execution Flow"
	TechniquesImpairDefenses                          Techniques = "Impair Defenses"
	TechniquesImplantContainerImage                   Techniques = "Implant Container Image"
	TechniquesIndicatorRemovalOnHost                  Techniques = "Indicator Removal on Host"
	TechniquesIndirectCommandExecution                Techniques = "Indirect Command Execution"
	TechniquesIngressToolTransfer                     Techniques = "Ingress Tool Transfer"
	TechniquesInputCapture                            Techniques = "Input Capture"
	TechniquesInterProcessCommunication               Techniques = "Inter-Process Communication"
	TechniquesLateralToolTransfer                     Techniques = "Lateral Tool Transfer"
	TechniquesManInTheMiddle                          Techniques = "Man-in-the-Middle"
	TechniquesMasquerading                            Techniques = "Masquerading"
	TechniquesModifyAuthenticationProcess             Techniques = "Modify Authentication Process"
	TechniquesModifyRegistry                          Techniques = "Modify Registry"
	TechniquesNetworkDenialOfService                  Techniques = "Network Denial of Service"
	TechniquesNetworkServiceScanning                  Techniques = "Network Service Scanning"
	TechniquesNetworkSniffing                         Techniques = "Network Sniffing"
	TechniquesNonApplicationLayerProtocol             Techniques = "Non-Application Layer Protocol"
	TechniquesNonStandardPort                         Techniques = "Non-Standard Port"
	TechniquesOSCredentialDumping                     Techniques = "OS Credential Dumping"
	TechniquesObfuscatedFilesOrInformation            Techniques = "Obfuscated Files or Information"
	TechniquesObtainCapabilities                      Techniques = "Obtain Capabilities"
	TechniquesOfficeApplicationStartup                Techniques = "Office Application Startup"
	TechniquesPermissionGroupsDiscovery               Techniques = "Permission Groups Discovery"
	TechniquesPhishing                                Techniques = "Phishing"
	TechniquesPreOSBoot                               Techniques = "Pre-OS Boot"
	TechniquesProcessDiscovery                        Techniques = "Process Discovery"
	TechniquesProcessInjection                        Techniques = "Process Injection"
	TechniquesProtocolTunneling                       Techniques = "Protocol Tunneling"
	TechniquesProxy                                   Techniques = "Proxy"
	TechniquesQueryRegistry                           Techniques = "Query Registry"
	TechniquesRemoteAccessSoftware                    Techniques = "Remote Access Software"
	TechniquesRemoteServiceSessionHijacking           Techniques = "Remote Service Session Hijacking"
	TechniquesRemoteServices                          Techniques = "Remote Services"
	TechniquesRemoteSystemDiscovery                   Techniques = "Remote System Discovery"
	TechniquesResourceHijacking                       Techniques = "Resource Hijacking"
	TechniquesSQLStoredProcedures                     Techniques = "SQL Stored Procedures"
	TechniquesScheduledTaskJob                        Techniques = "Scheduled Task/Job"
	TechniquesScreenCapture                           Techniques = "Screen Capture"
	TechniquesSearchVictimOwnedWebsites               Techniques = "Search Victim-Owned Websites"
	TechniquesServerSoftwareComponent                 Techniques = "Server Software Component"
	TechniquesServiceStop                             Techniques = "Service Stop"
	TechniquesSignedBinaryProxyExecution              Techniques = "Signed Binary Proxy Execution"
	TechniquesSoftwareDeploymentTools                 Techniques = "Software Deployment Tools"
	TechniquesStealOrForgeKerberosTickets             Techniques = "Steal or Forge Kerberos Tickets"
	TechniquesSubvertTrustControls                    Techniques = "Subvert Trust Controls"
	TechniquesSupplyChainCompromise                   Techniques = "Supply Chain Compromise"
	TechniquesSystemInformationDiscovery              Techniques = "System Information Discovery"
	TechniquesTaintSharedContent                      Techniques = "Taint Shared Content"
	TechniquesTrafficSignaling                        Techniques = "Traffic Signaling"
	TechniquesTransferDataToCloudAccount              Techniques = "Transfer Data to Cloud Account"
	TechniquesTrustedRelationship                     Techniques = "Trusted Relationship"
	TechniquesUnsecuredCredentials                    Techniques = "Unsecured Credentials"
	TechniquesUserExecution                           Techniques = "User Execution"
	TechniquesValidAccounts                           Techniques = "Valid Accounts"
	TechniquesWindowsManagementInstrumentation        Techniques = "Windows Management Instrumentation"
)

// PossibleTechniquesValues returns the possible values for the Techniques const type.
func PossibleTechniquesValues() []Techniques {
	return []Techniques{
		TechniquesAbuseElevationControlMechanism,
		TechniquesAccessTokenManipulation,
		TechniquesAccountDiscovery,
		TechniquesAccountManipulation,
		TechniquesActiveScanning,
		TechniquesApplicationLayerProtocol,
		TechniquesAudioCapture,
		TechniquesBootOrLogonAutostartExecution,
		TechniquesBootOrLogonInitializationScripts,
		TechniquesBruteForce,
		TechniquesCloudInfrastructureDiscovery,
		TechniquesCloudServiceDashboard,
		TechniquesCloudServiceDiscovery,
		TechniquesCommandAndScriptingInterpreter,
		TechniquesCompromiseClientSoftwareBinary,
		TechniquesCompromiseInfrastructure,
		TechniquesContainerAndResourceDiscovery,
		TechniquesCreateAccount,
		TechniquesCreateOrModifySystemProcess,
		TechniquesCredentialsFromPasswordStores,
		TechniquesDataDestruction,
		TechniquesDataEncryptedForImpact,
		TechniquesDataFromCloudStorageObject,
		TechniquesDataFromConfigurationRepository,
		TechniquesDataFromInformationRepositories,
		TechniquesDataFromLocalSystem,
		TechniquesDataManipulation,
		TechniquesDataStaged,
		TechniquesDefacement,
		TechniquesDeobfuscateDecodeFilesOrInformation,
		TechniquesDiskWipe,
		TechniquesDomainTrustDiscovery,
		TechniquesDriveByCompromise,
		TechniquesDynamicResolution,
		TechniquesEndpointDenialOfService,
		TechniquesEventTriggeredExecution,
		TechniquesExfiltrationOverAlternativeProtocol,
		TechniquesExploitPublicFacingApplication,
		TechniquesExploitationForClientExecution,
		TechniquesExploitationForCredentialAccess,
		TechniquesExploitationForDefenseEvasion,
		TechniquesExploitationForPrivilegeEscalation,
		TechniquesExploitationOfRemoteServices,
		TechniquesExternalRemoteServices,
		TechniquesFallbackChannels,
		TechniquesFileAndDirectoryDiscovery,
		TechniquesFileAndDirectoryPermissionsModification,
		TechniquesGatherVictimNetworkInformation,
		TechniquesHideArtifacts,
		TechniquesHijackExecutionFlow,
		TechniquesImpairDefenses,
		TechniquesImplantContainerImage,
		TechniquesIndicatorRemovalOnHost,
		TechniquesIndirectCommandExecution,
		TechniquesIngressToolTransfer,
		TechniquesInputCapture,
		TechniquesInterProcessCommunication,
		TechniquesLateralToolTransfer,
		TechniquesManInTheMiddle,
		TechniquesMasquerading,
		TechniquesModifyAuthenticationProcess,
		TechniquesModifyRegistry,
		TechniquesNetworkDenialOfService,
		TechniquesNetworkServiceScanning,
		TechniquesNetworkSniffing,
		TechniquesNonApplicationLayerProtocol,
		TechniquesNonStandardPort,
		TechniquesOSCredentialDumping,
		TechniquesObfuscatedFilesOrInformation,
		TechniquesObtainCapabilities,
		TechniquesOfficeApplicationStartup,
		TechniquesPermissionGroupsDiscovery,
		TechniquesPhishing,
		TechniquesPreOSBoot,
		TechniquesProcessDiscovery,
		TechniquesProcessInjection,
		TechniquesProtocolTunneling,
		TechniquesProxy,
		TechniquesQueryRegistry,
		TechniquesRemoteAccessSoftware,
		TechniquesRemoteServiceSessionHijacking,
		TechniquesRemoteServices,
		TechniquesRemoteSystemDiscovery,
		TechniquesResourceHijacking,
		TechniquesSQLStoredProcedures,
		TechniquesScheduledTaskJob,
		TechniquesScreenCapture,
		TechniquesSearchVictimOwnedWebsites,
		TechniquesServerSoftwareComponent,
		TechniquesServiceStop,
		TechniquesSignedBinaryProxyExecution,
		TechniquesSoftwareDeploymentTools,
		TechniquesStealOrForgeKerberosTickets,
		TechniquesSubvertTrustControls,
		TechniquesSupplyChainCompromise,
		TechniquesSystemInformationDiscovery,
		TechniquesTaintSharedContent,
		TechniquesTrafficSignaling,
		TechniquesTransferDataToCloudAccount,
		TechniquesTrustedRelationship,
		TechniquesUnsecuredCredentials,
		TechniquesUserExecution,
		TechniquesValidAccounts,
		TechniquesWindowsManagementInstrumentation,
	}
}

// Threats - Threats impact of the assessment
type Threats string

const (
	ThreatsAccountBreach        Threats = "accountBreach"
	ThreatsDataExfiltration     Threats = "dataExfiltration"
	ThreatsDataSpillage         Threats = "dataSpillage"
	ThreatsDenialOfService      Threats = "denialOfService"
	ThreatsElevationOfPrivilege Threats = "elevationOfPrivilege"
	ThreatsMaliciousInsider     Threats = "maliciousInsider"
	ThreatsMissingCoverage      Threats = "missingCoverage"
	ThreatsThreatResistance     Threats = "threatResistance"
)

// PossibleThreatsValues returns the possible values for the Threats const type.
func PossibleThreatsValues() []Threats {
	return []Threats{
		ThreatsAccountBreach,
		ThreatsDataExfiltration,
		ThreatsDataSpillage,
		ThreatsDenialOfService,
		ThreatsElevationOfPrivilege,
		ThreatsMaliciousInsider,
		ThreatsMissingCoverage,
		ThreatsThreatResistance,
	}
}

type TransportProtocol string

const (
	TransportProtocolTCP TransportProtocol = "TCP"
	TransportProtocolUDP TransportProtocol = "UDP"
)

// PossibleTransportProtocolValues returns the possible values for the TransportProtocol const type.
func PossibleTransportProtocolValues() []TransportProtocol {
	return []TransportProtocol{
		TransportProtocolTCP,
		TransportProtocolUDP,
	}
}

// Type - The Vulnerability Assessment solution to be provisioned. Can be either 'TVM' or 'Qualys'
type Type string

const (
	TypeQualys Type = "Qualys"
	TypeTVM    Type = "TVM"
)

// PossibleTypeValues returns the possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{
		TypeQualys,
		TypeTVM,
	}
}

// UnmaskedIPLoggingStatus - Unmasked IP address logging status
type UnmaskedIPLoggingStatus string

const (
	// UnmaskedIPLoggingStatusDisabled - Unmasked IP logging is disabled
	UnmaskedIPLoggingStatusDisabled UnmaskedIPLoggingStatus = "Disabled"
	// UnmaskedIPLoggingStatusEnabled - Unmasked IP logging is enabled
	UnmaskedIPLoggingStatusEnabled UnmaskedIPLoggingStatus = "Enabled"
)

// PossibleUnmaskedIPLoggingStatusValues returns the possible values for the UnmaskedIPLoggingStatus const type.
func PossibleUnmaskedIPLoggingStatusValues() []UnmaskedIPLoggingStatus {
	return []UnmaskedIPLoggingStatus{
		UnmaskedIPLoggingStatusDisabled,
		UnmaskedIPLoggingStatusEnabled,
	}
}

// UserImpact - The user impact of the assessment
type UserImpact string

const (
	UserImpactHigh     UserImpact = "High"
	UserImpactLow      UserImpact = "Low"
	UserImpactModerate UserImpact = "Moderate"
)

// PossibleUserImpactValues returns the possible values for the UserImpact const type.
func PossibleUserImpactValues() []UserImpact {
	return []UserImpact{
		UserImpactHigh,
		UserImpactLow,
		UserImpactModerate,
	}
}

// ValueType - The value type of the items in the list.
type ValueType string

const (
	// ValueTypeIPCidr - An IP range in CIDR format (e.g. '192.168.0.1/8').
	ValueTypeIPCidr ValueType = "IpCidr"
	// ValueTypeString - Any string value.
	ValueTypeString ValueType = "String"
)

// PossibleValueTypeValues returns the possible values for the ValueType const type.
func PossibleValueTypeValues() []ValueType {
	return []ValueType{
		ValueTypeIPCidr,
		ValueTypeString,
	}
}
