//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armrecoveryservicesbackup_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/recoveryservices/armrecoveryservicesbackup/v4"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d402f685809d6d08be9c0b45065cadd7d78ab870/specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/TieringCost/FetchTieringCostForRehydrate.json
func ExampleFetchTieringCostClient_BeginPost_getTheRehydrationCostForRecoveryPoint() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armrecoveryservicesbackup.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewFetchTieringCostClient().BeginPost(ctx, "netsdktestrg", "testVault", &armrecoveryservicesbackup.FetchTieringCostInfoForRehydrationRequest{
		ObjectType:          to.Ptr("FetchTieringCostInfoForRehydrationRequest"),
		SourceTierType:      to.Ptr(armrecoveryservicesbackup.RecoveryPointTierTypeArchivedRP),
		TargetTierType:      to.Ptr(armrecoveryservicesbackup.RecoveryPointTierTypeHardenedRP),
		ContainerName:       to.Ptr("IaasVMContainer;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1"),
		ProtectedItemName:   to.Ptr("VM;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1"),
		RecoveryPointID:     to.Ptr("1222343434"),
		RehydrationPriority: to.Ptr(armrecoveryservicesbackup.RehydrationPriorityHigh),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res = armrecoveryservicesbackup.FetchTieringCostClientPostResponse{
	// 	                            TieringCostInfoClassification: &armrecoveryservicesbackup.TieringCostRehydrationInfo{
	// 		ObjectType: to.Ptr("TieringCostRehydrationInfo"),
	// 		RehydrationSizeInBytes: to.Ptr[int64](1204000),
	// 		RetailRehydrationCostPerGBPerMonth: to.Ptr[float64](0.02),
	// 	},
	// 	                        }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d402f685809d6d08be9c0b45065cadd7d78ab870/specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/TieringCost/FetchTieringCostForPolicy.json
func ExampleFetchTieringCostClient_BeginPost_getTheTieringSavingsCostInfoForPolicy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armrecoveryservicesbackup.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewFetchTieringCostClient().BeginPost(ctx, "netsdktestrg", "testVault", &armrecoveryservicesbackup.FetchTieringCostSavingsInfoForPolicyRequest{
		ObjectType:     to.Ptr("FetchTieringCostSavingsInfoForPolicyRequest"),
		SourceTierType: to.Ptr(armrecoveryservicesbackup.RecoveryPointTierTypeHardenedRP),
		TargetTierType: to.Ptr(armrecoveryservicesbackup.RecoveryPointTierTypeArchivedRP),
		PolicyName:     to.Ptr("monthly"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res = armrecoveryservicesbackup.FetchTieringCostClientPostResponse{
	// 	                            TieringCostInfoClassification: &armrecoveryservicesbackup.TieringCostSavingInfo{
	// 		ObjectType: to.Ptr("TieringCostSavingInfo"),
	// 		RetailSourceTierCostPerGBPerMonth: to.Ptr[float64](0.02),
	// 		RetailTargetTierCostPerGBPerMonth: to.Ptr[float64](0.003),
	// 		SourceTierSizeReductionInBytes: to.Ptr[int64](1204000),
	// 		TargetTierSizeIncreaseInBytes: to.Ptr[int64](1892),
	// 	},
	// 	                        }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d402f685809d6d08be9c0b45065cadd7d78ab870/specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/TieringCost/FetchTieringCostForProtectedItem.json
func ExampleFetchTieringCostClient_BeginPost_getTheTieringSavingsCostInfoForProtectedItem() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armrecoveryservicesbackup.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewFetchTieringCostClient().BeginPost(ctx, "netsdktestrg", "testVault", &armrecoveryservicesbackup.FetchTieringCostSavingsInfoForProtectedItemRequest{
		ObjectType:        to.Ptr("FetchTieringCostSavingsInfoForProtectedItemRequest"),
		SourceTierType:    to.Ptr(armrecoveryservicesbackup.RecoveryPointTierTypeHardenedRP),
		TargetTierType:    to.Ptr(armrecoveryservicesbackup.RecoveryPointTierTypeArchivedRP),
		ContainerName:     to.Ptr("IaasVMContainer;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1"),
		ProtectedItemName: to.Ptr("VM;iaasvmcontainerv2;netsdktestrg;netvmtestv2vm1"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res = armrecoveryservicesbackup.FetchTieringCostClientPostResponse{
	// 	                            TieringCostInfoClassification: &armrecoveryservicesbackup.TieringCostSavingInfo{
	// 		ObjectType: to.Ptr("TieringCostSavingInfo"),
	// 		RetailSourceTierCostPerGBPerMonth: to.Ptr[float64](0.02),
	// 		RetailTargetTierCostPerGBPerMonth: to.Ptr[float64](0.003),
	// 		SourceTierSizeReductionInBytes: to.Ptr[int64](1204000),
	// 		TargetTierSizeIncreaseInBytes: to.Ptr[int64](1892),
	// 	},
	// 	                        }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d402f685809d6d08be9c0b45065cadd7d78ab870/specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-06-01/examples/TieringCost/FetchTieringCostForVault.json
func ExampleFetchTieringCostClient_BeginPost_getTheTieringSavingsCostInfoForVault() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armrecoveryservicesbackup.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewFetchTieringCostClient().BeginPost(ctx, "netsdktestrg", "testVault", &armrecoveryservicesbackup.FetchTieringCostSavingsInfoForVaultRequest{
		ObjectType:     to.Ptr("FetchTieringCostSavingsInfoForVaultRequest"),
		SourceTierType: to.Ptr(armrecoveryservicesbackup.RecoveryPointTierTypeHardenedRP),
		TargetTierType: to.Ptr(armrecoveryservicesbackup.RecoveryPointTierTypeArchivedRP),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res = armrecoveryservicesbackup.FetchTieringCostClientPostResponse{
	// 	                            TieringCostInfoClassification: &armrecoveryservicesbackup.TieringCostSavingInfo{
	// 		ObjectType: to.Ptr("TieringCostSavingInfo"),
	// 		RetailSourceTierCostPerGBPerMonth: to.Ptr[float64](0.02),
	// 		RetailTargetTierCostPerGBPerMonth: to.Ptr[float64](0.003),
	// 		SourceTierSizeReductionInBytes: to.Ptr[int64](1204000),
	// 		TargetTierSizeIncreaseInBytes: to.Ptr[int64](1892),
	// 	},
	// 	                        }
}
