//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/recoveryservices/armrecoveryservices"
	"net/http"
	"net/url"
	"regexp"
)

// UsagesServer is a fake server for instances of the armrecoveryservices.UsagesClient type.
type UsagesServer struct {
	// NewListByVaultsPager is the fake for method UsagesClient.NewListByVaultsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByVaultsPager func(resourceGroupName string, vaultName string, options *armrecoveryservices.UsagesClientListByVaultsOptions) (resp azfake.PagerResponder[armrecoveryservices.UsagesClientListByVaultsResponse])
}

// NewUsagesServerTransport creates a new instance of UsagesServerTransport with the provided implementation.
// The returned UsagesServerTransport instance is connected to an instance of armrecoveryservices.UsagesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewUsagesServerTransport(srv *UsagesServer) *UsagesServerTransport {
	return &UsagesServerTransport{
		srv:                  srv,
		newListByVaultsPager: newTracker[azfake.PagerResponder[armrecoveryservices.UsagesClientListByVaultsResponse]](),
	}
}

// UsagesServerTransport connects instances of armrecoveryservices.UsagesClient to instances of UsagesServer.
// Don't use this type directly, use NewUsagesServerTransport instead.
type UsagesServerTransport struct {
	srv                  *UsagesServer
	newListByVaultsPager *tracker[azfake.PagerResponder[armrecoveryservices.UsagesClientListByVaultsResponse]]
}

// Do implements the policy.Transporter interface for UsagesServerTransport.
func (u *UsagesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "UsagesClient.NewListByVaultsPager":
		resp, err = u.dispatchNewListByVaultsPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (u *UsagesServerTransport) dispatchNewListByVaultsPager(req *http.Request) (*http.Response, error) {
	if u.srv.NewListByVaultsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByVaultsPager not implemented")}
	}
	newListByVaultsPager := u.newListByVaultsPager.get(req)
	if newListByVaultsPager == nil {
		const regexStr = `/Subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<vaultName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/usages`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		vaultNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("vaultName")])
		if err != nil {
			return nil, err
		}
		resp := u.srv.NewListByVaultsPager(resourceGroupNameParam, vaultNameParam, nil)
		newListByVaultsPager = &resp
		u.newListByVaultsPager.add(req, newListByVaultsPager)
	}
	resp, err := server.PagerResponderNext(newListByVaultsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		u.newListByVaultsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByVaultsPager) {
		u.newListByVaultsPager.remove(req)
	}
	return resp, nil
}
