//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/powerbiembedded/armpowerbiembedded"
	"net/http"
	"net/url"
	"regexp"
)

// WorkspaceCollectionsServer is a fake server for instances of the armpowerbiembedded.WorkspaceCollectionsClient type.
type WorkspaceCollectionsServer struct {
	// CheckNameAvailability is the fake for method WorkspaceCollectionsClient.CheckNameAvailability
	// HTTP status codes to indicate success: http.StatusOK
	CheckNameAvailability func(ctx context.Context, location string, body armpowerbiembedded.CheckNameRequest, options *armpowerbiembedded.WorkspaceCollectionsClientCheckNameAvailabilityOptions) (resp azfake.Responder[armpowerbiembedded.WorkspaceCollectionsClientCheckNameAvailabilityResponse], errResp azfake.ErrorResponder)

	// Create is the fake for method WorkspaceCollectionsClient.Create
	// HTTP status codes to indicate success: http.StatusOK
	Create func(ctx context.Context, resourceGroupName string, workspaceCollectionName string, body armpowerbiembedded.CreateWorkspaceCollectionRequest, options *armpowerbiembedded.WorkspaceCollectionsClientCreateOptions) (resp azfake.Responder[armpowerbiembedded.WorkspaceCollectionsClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method WorkspaceCollectionsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusAccepted
	BeginDelete func(ctx context.Context, resourceGroupName string, workspaceCollectionName string, options *armpowerbiembedded.WorkspaceCollectionsClientBeginDeleteOptions) (resp azfake.PollerResponder[armpowerbiembedded.WorkspaceCollectionsClientDeleteResponse], errResp azfake.ErrorResponder)

	// GetAccessKeys is the fake for method WorkspaceCollectionsClient.GetAccessKeys
	// HTTP status codes to indicate success: http.StatusOK
	GetAccessKeys func(ctx context.Context, resourceGroupName string, workspaceCollectionName string, options *armpowerbiembedded.WorkspaceCollectionsClientGetAccessKeysOptions) (resp azfake.Responder[armpowerbiembedded.WorkspaceCollectionsClientGetAccessKeysResponse], errResp azfake.ErrorResponder)

	// GetByName is the fake for method WorkspaceCollectionsClient.GetByName
	// HTTP status codes to indicate success: http.StatusOK
	GetByName func(ctx context.Context, resourceGroupName string, workspaceCollectionName string, options *armpowerbiembedded.WorkspaceCollectionsClientGetByNameOptions) (resp azfake.Responder[armpowerbiembedded.WorkspaceCollectionsClientGetByNameResponse], errResp azfake.ErrorResponder)

	// NewListByResourceGroupPager is the fake for method WorkspaceCollectionsClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armpowerbiembedded.WorkspaceCollectionsClientListByResourceGroupOptions) (resp azfake.PagerResponder[armpowerbiembedded.WorkspaceCollectionsClientListByResourceGroupResponse])

	// NewListBySubscriptionPager is the fake for method WorkspaceCollectionsClient.NewListBySubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySubscriptionPager func(options *armpowerbiembedded.WorkspaceCollectionsClientListBySubscriptionOptions) (resp azfake.PagerResponder[armpowerbiembedded.WorkspaceCollectionsClientListBySubscriptionResponse])

	// Migrate is the fake for method WorkspaceCollectionsClient.Migrate
	// HTTP status codes to indicate success: http.StatusOK
	Migrate func(ctx context.Context, resourceGroupName string, body armpowerbiembedded.MigrateWorkspaceCollectionRequest, options *armpowerbiembedded.WorkspaceCollectionsClientMigrateOptions) (resp azfake.Responder[armpowerbiembedded.WorkspaceCollectionsClientMigrateResponse], errResp azfake.ErrorResponder)

	// RegenerateKey is the fake for method WorkspaceCollectionsClient.RegenerateKey
	// HTTP status codes to indicate success: http.StatusOK
	RegenerateKey func(ctx context.Context, resourceGroupName string, workspaceCollectionName string, body armpowerbiembedded.WorkspaceCollectionAccessKey, options *armpowerbiembedded.WorkspaceCollectionsClientRegenerateKeyOptions) (resp azfake.Responder[armpowerbiembedded.WorkspaceCollectionsClientRegenerateKeyResponse], errResp azfake.ErrorResponder)

	// Update is the fake for method WorkspaceCollectionsClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, resourceGroupName string, workspaceCollectionName string, body armpowerbiembedded.UpdateWorkspaceCollectionRequest, options *armpowerbiembedded.WorkspaceCollectionsClientUpdateOptions) (resp azfake.Responder[armpowerbiembedded.WorkspaceCollectionsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewWorkspaceCollectionsServerTransport creates a new instance of WorkspaceCollectionsServerTransport with the provided implementation.
// The returned WorkspaceCollectionsServerTransport instance is connected to an instance of armpowerbiembedded.WorkspaceCollectionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewWorkspaceCollectionsServerTransport(srv *WorkspaceCollectionsServer) *WorkspaceCollectionsServerTransport {
	return &WorkspaceCollectionsServerTransport{
		srv:                         srv,
		beginDelete:                 newTracker[azfake.PollerResponder[armpowerbiembedded.WorkspaceCollectionsClientDeleteResponse]](),
		newListByResourceGroupPager: newTracker[azfake.PagerResponder[armpowerbiembedded.WorkspaceCollectionsClientListByResourceGroupResponse]](),
		newListBySubscriptionPager:  newTracker[azfake.PagerResponder[armpowerbiembedded.WorkspaceCollectionsClientListBySubscriptionResponse]](),
	}
}

// WorkspaceCollectionsServerTransport connects instances of armpowerbiembedded.WorkspaceCollectionsClient to instances of WorkspaceCollectionsServer.
// Don't use this type directly, use NewWorkspaceCollectionsServerTransport instead.
type WorkspaceCollectionsServerTransport struct {
	srv                         *WorkspaceCollectionsServer
	beginDelete                 *tracker[azfake.PollerResponder[armpowerbiembedded.WorkspaceCollectionsClientDeleteResponse]]
	newListByResourceGroupPager *tracker[azfake.PagerResponder[armpowerbiembedded.WorkspaceCollectionsClientListByResourceGroupResponse]]
	newListBySubscriptionPager  *tracker[azfake.PagerResponder[armpowerbiembedded.WorkspaceCollectionsClientListBySubscriptionResponse]]
}

// Do implements the policy.Transporter interface for WorkspaceCollectionsServerTransport.
func (w *WorkspaceCollectionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "WorkspaceCollectionsClient.CheckNameAvailability":
		resp, err = w.dispatchCheckNameAvailability(req)
	case "WorkspaceCollectionsClient.Create":
		resp, err = w.dispatchCreate(req)
	case "WorkspaceCollectionsClient.BeginDelete":
		resp, err = w.dispatchBeginDelete(req)
	case "WorkspaceCollectionsClient.GetAccessKeys":
		resp, err = w.dispatchGetAccessKeys(req)
	case "WorkspaceCollectionsClient.GetByName":
		resp, err = w.dispatchGetByName(req)
	case "WorkspaceCollectionsClient.NewListByResourceGroupPager":
		resp, err = w.dispatchNewListByResourceGroupPager(req)
	case "WorkspaceCollectionsClient.NewListBySubscriptionPager":
		resp, err = w.dispatchNewListBySubscriptionPager(req)
	case "WorkspaceCollectionsClient.Migrate":
		resp, err = w.dispatchMigrate(req)
	case "WorkspaceCollectionsClient.RegenerateKey":
		resp, err = w.dispatchRegenerateKey(req)
	case "WorkspaceCollectionsClient.Update":
		resp, err = w.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (w *WorkspaceCollectionsServerTransport) dispatchCheckNameAvailability(req *http.Request) (*http.Response, error) {
	if w.srv.CheckNameAvailability == nil {
		return nil, &nonRetriableError{errors.New("fake for method CheckNameAvailability not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PowerBI/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/checkNameAvailability`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armpowerbiembedded.CheckNameRequest](req)
	if err != nil {
		return nil, err
	}
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.CheckNameAvailability(req.Context(), locationParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CheckNameResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WorkspaceCollectionsServerTransport) dispatchCreate(req *http.Request) (*http.Response, error) {
	if w.srv.Create == nil {
		return nil, &nonRetriableError{errors.New("fake for method Create not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PowerBI/workspaceCollections/(?P<workspaceCollectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armpowerbiembedded.CreateWorkspaceCollectionRequest](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceCollectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceCollectionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.Create(req.Context(), resourceGroupNameParam, workspaceCollectionNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).WorkspaceCollection, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WorkspaceCollectionsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if w.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := w.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PowerBI/workspaceCollections/(?P<workspaceCollectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		workspaceCollectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceCollectionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := w.srv.BeginDelete(req.Context(), resourceGroupNameParam, workspaceCollectionNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		w.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted}, resp.StatusCode) {
		w.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		w.beginDelete.remove(req)
	}

	return resp, nil
}

func (w *WorkspaceCollectionsServerTransport) dispatchGetAccessKeys(req *http.Request) (*http.Response, error) {
	if w.srv.GetAccessKeys == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetAccessKeys not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PowerBI/workspaceCollections/(?P<workspaceCollectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listKeys`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceCollectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceCollectionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetAccessKeys(req.Context(), resourceGroupNameParam, workspaceCollectionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).WorkspaceCollectionAccessKeys, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WorkspaceCollectionsServerTransport) dispatchGetByName(req *http.Request) (*http.Response, error) {
	if w.srv.GetByName == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetByName not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PowerBI/workspaceCollections/(?P<workspaceCollectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceCollectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceCollectionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.GetByName(req.Context(), resourceGroupNameParam, workspaceCollectionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).WorkspaceCollection, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WorkspaceCollectionsServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := w.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PowerBI/workspaceCollections`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListByResourceGroupPager(resourceGroupNameParam, nil)
		newListByResourceGroupPager = &resp
		w.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		w.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (w *WorkspaceCollectionsServerTransport) dispatchNewListBySubscriptionPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListBySubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySubscriptionPager not implemented")}
	}
	newListBySubscriptionPager := w.newListBySubscriptionPager.get(req)
	if newListBySubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PowerBI/workspaceCollections`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := w.srv.NewListBySubscriptionPager(nil)
		newListBySubscriptionPager = &resp
		w.newListBySubscriptionPager.add(req, newListBySubscriptionPager)
	}
	resp, err := server.PagerResponderNext(newListBySubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListBySubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySubscriptionPager) {
		w.newListBySubscriptionPager.remove(req)
	}
	return resp, nil
}

func (w *WorkspaceCollectionsServerTransport) dispatchMigrate(req *http.Request) (*http.Response, error) {
	if w.srv.Migrate == nil {
		return nil, &nonRetriableError{errors.New("fake for method Migrate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/moveResources`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armpowerbiembedded.MigrateWorkspaceCollectionRequest](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.Migrate(req.Context(), resourceGroupNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WorkspaceCollectionsServerTransport) dispatchRegenerateKey(req *http.Request) (*http.Response, error) {
	if w.srv.RegenerateKey == nil {
		return nil, &nonRetriableError{errors.New("fake for method RegenerateKey not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PowerBI/workspaceCollections/(?P<workspaceCollectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/regenerateKey`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armpowerbiembedded.WorkspaceCollectionAccessKey](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceCollectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceCollectionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.RegenerateKey(req.Context(), resourceGroupNameParam, workspaceCollectionNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).WorkspaceCollectionAccessKeys, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WorkspaceCollectionsServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if w.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PowerBI/workspaceCollections/(?P<workspaceCollectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armpowerbiembedded.UpdateWorkspaceCollectionRequest](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceCollectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceCollectionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.Update(req.Context(), resourceGroupNameParam, workspaceCollectionNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).WorkspaceCollection, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
