//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armnetapp

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type Account.
func (a Account) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "identity", a.Identity)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Account.
func (a *Account) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &a.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountEncryption.
func (a AccountEncryption) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identity", a.Identity)
	populate(objectMap, "keySource", a.KeySource)
	populate(objectMap, "keyVaultProperties", a.KeyVaultProperties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountEncryption.
func (a *AccountEncryption) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identity":
			err = unpopulate(val, "Identity", &a.Identity)
			delete(rawMsg, key)
		case "keySource":
			err = unpopulate(val, "KeySource", &a.KeySource)
			delete(rawMsg, key)
		case "keyVaultProperties":
			err = unpopulate(val, "KeyVaultProperties", &a.KeyVaultProperties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountList.
func (a AccountList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountList.
func (a *AccountList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountPatch.
func (a AccountPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "identity", a.Identity)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountPatch.
func (a *AccountPatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &a.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountProperties.
func (a AccountProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "activeDirectories", a.ActiveDirectories)
	populate(objectMap, "disableShowmount", a.DisableShowmount)
	populate(objectMap, "encryption", a.Encryption)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountProperties.
func (a *AccountProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activeDirectories":
			err = unpopulate(val, "ActiveDirectories", &a.ActiveDirectories)
			delete(rawMsg, key)
		case "disableShowmount":
			err = unpopulate(val, "DisableShowmount", &a.DisableShowmount)
			delete(rawMsg, key)
		case "encryption":
			err = unpopulate(val, "Encryption", &a.Encryption)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ActiveDirectory.
func (a ActiveDirectory) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "activeDirectoryId", a.ActiveDirectoryID)
	populate(objectMap, "adName", a.AdName)
	populate(objectMap, "administrators", a.Administrators)
	populate(objectMap, "aesEncryption", a.AesEncryption)
	populate(objectMap, "allowLocalNfsUsersWithLdap", a.AllowLocalNfsUsersWithLdap)
	populate(objectMap, "backupOperators", a.BackupOperators)
	populate(objectMap, "dns", a.DNS)
	populate(objectMap, "domain", a.Domain)
	populate(objectMap, "encryptDCConnections", a.EncryptDCConnections)
	populate(objectMap, "kdcIP", a.KdcIP)
	populate(objectMap, "ldapOverTLS", a.LdapOverTLS)
	populate(objectMap, "ldapSearchScope", a.LdapSearchScope)
	populate(objectMap, "ldapSigning", a.LdapSigning)
	populate(objectMap, "organizationalUnit", a.OrganizationalUnit)
	populate(objectMap, "password", a.Password)
	populate(objectMap, "preferredServersForLdapClient", a.PreferredServersForLdapClient)
	populate(objectMap, "securityOperators", a.SecurityOperators)
	populate(objectMap, "serverRootCACertificate", a.ServerRootCACertificate)
	populate(objectMap, "site", a.Site)
	populate(objectMap, "smbServerName", a.SmbServerName)
	populate(objectMap, "status", a.Status)
	populate(objectMap, "statusDetails", a.StatusDetails)
	populate(objectMap, "username", a.Username)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ActiveDirectory.
func (a *ActiveDirectory) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activeDirectoryId":
			err = unpopulate(val, "ActiveDirectoryID", &a.ActiveDirectoryID)
			delete(rawMsg, key)
		case "adName":
			err = unpopulate(val, "AdName", &a.AdName)
			delete(rawMsg, key)
		case "administrators":
			err = unpopulate(val, "Administrators", &a.Administrators)
			delete(rawMsg, key)
		case "aesEncryption":
			err = unpopulate(val, "AesEncryption", &a.AesEncryption)
			delete(rawMsg, key)
		case "allowLocalNfsUsersWithLdap":
			err = unpopulate(val, "AllowLocalNfsUsersWithLdap", &a.AllowLocalNfsUsersWithLdap)
			delete(rawMsg, key)
		case "backupOperators":
			err = unpopulate(val, "BackupOperators", &a.BackupOperators)
			delete(rawMsg, key)
		case "dns":
			err = unpopulate(val, "DNS", &a.DNS)
			delete(rawMsg, key)
		case "domain":
			err = unpopulate(val, "Domain", &a.Domain)
			delete(rawMsg, key)
		case "encryptDCConnections":
			err = unpopulate(val, "EncryptDCConnections", &a.EncryptDCConnections)
			delete(rawMsg, key)
		case "kdcIP":
			err = unpopulate(val, "KdcIP", &a.KdcIP)
			delete(rawMsg, key)
		case "ldapOverTLS":
			err = unpopulate(val, "LdapOverTLS", &a.LdapOverTLS)
			delete(rawMsg, key)
		case "ldapSearchScope":
			err = unpopulate(val, "LdapSearchScope", &a.LdapSearchScope)
			delete(rawMsg, key)
		case "ldapSigning":
			err = unpopulate(val, "LdapSigning", &a.LdapSigning)
			delete(rawMsg, key)
		case "organizationalUnit":
			err = unpopulate(val, "OrganizationalUnit", &a.OrganizationalUnit)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &a.Password)
			delete(rawMsg, key)
		case "preferredServersForLdapClient":
			err = unpopulate(val, "PreferredServersForLdapClient", &a.PreferredServersForLdapClient)
			delete(rawMsg, key)
		case "securityOperators":
			err = unpopulate(val, "SecurityOperators", &a.SecurityOperators)
			delete(rawMsg, key)
		case "serverRootCACertificate":
			err = unpopulate(val, "ServerRootCACertificate", &a.ServerRootCACertificate)
			delete(rawMsg, key)
		case "site":
			err = unpopulate(val, "Site", &a.Site)
			delete(rawMsg, key)
		case "smbServerName":
			err = unpopulate(val, "SmbServerName", &a.SmbServerName)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		case "statusDetails":
			err = unpopulate(val, "StatusDetails", &a.StatusDetails)
			delete(rawMsg, key)
		case "username":
			err = unpopulate(val, "Username", &a.Username)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AuthorizeRequest.
func (a AuthorizeRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "remoteVolumeResourceId", a.RemoteVolumeResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AuthorizeRequest.
func (a *AuthorizeRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "remoteVolumeResourceId":
			err = unpopulate(val, "RemoteVolumeResourceID", &a.RemoteVolumeResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupPoliciesList.
func (b BackupPoliciesList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", b.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupPoliciesList.
func (b *BackupPoliciesList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &b.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupPolicy.
func (b BackupPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", b.Etag)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "location", b.Location)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "systemData", b.SystemData)
	populate(objectMap, "tags", b.Tags)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupPolicy.
func (b *BackupPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &b.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &b.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &b.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &b.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupPolicyPatch.
func (b BackupPolicyPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "location", b.Location)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "tags", b.Tags)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupPolicyPatch.
func (b *BackupPolicyPatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &b.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &b.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BackupPolicyProperties.
func (b BackupPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backupPolicyId", b.BackupPolicyID)
	populate(objectMap, "dailyBackupsToKeep", b.DailyBackupsToKeep)
	populate(objectMap, "enabled", b.Enabled)
	populate(objectMap, "monthlyBackupsToKeep", b.MonthlyBackupsToKeep)
	populate(objectMap, "provisioningState", b.ProvisioningState)
	populate(objectMap, "volumeBackups", b.VolumeBackups)
	populate(objectMap, "volumesAssigned", b.VolumesAssigned)
	populate(objectMap, "weeklyBackupsToKeep", b.WeeklyBackupsToKeep)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BackupPolicyProperties.
func (b *BackupPolicyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupPolicyId":
			err = unpopulate(val, "BackupPolicyID", &b.BackupPolicyID)
			delete(rawMsg, key)
		case "dailyBackupsToKeep":
			err = unpopulate(val, "DailyBackupsToKeep", &b.DailyBackupsToKeep)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &b.Enabled)
			delete(rawMsg, key)
		case "monthlyBackupsToKeep":
			err = unpopulate(val, "MonthlyBackupsToKeep", &b.MonthlyBackupsToKeep)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &b.ProvisioningState)
			delete(rawMsg, key)
		case "volumeBackups":
			err = unpopulate(val, "VolumeBackups", &b.VolumeBackups)
			delete(rawMsg, key)
		case "volumesAssigned":
			err = unpopulate(val, "VolumesAssigned", &b.VolumesAssigned)
			delete(rawMsg, key)
		case "weeklyBackupsToKeep":
			err = unpopulate(val, "WeeklyBackupsToKeep", &b.WeeklyBackupsToKeep)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BreakFileLocksRequest.
func (b BreakFileLocksRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientIp", b.ClientIP)
	populate(objectMap, "confirmRunningDisruptiveOperation", b.ConfirmRunningDisruptiveOperation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BreakFileLocksRequest.
func (b *BreakFileLocksRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientIp":
			err = unpopulate(val, "ClientIP", &b.ClientIP)
			delete(rawMsg, key)
		case "confirmRunningDisruptiveOperation":
			err = unpopulate(val, "ConfirmRunningDisruptiveOperation", &b.ConfirmRunningDisruptiveOperation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BreakReplicationRequest.
func (b BreakReplicationRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "forceBreakReplication", b.ForceBreakReplication)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BreakReplicationRequest.
func (b *BreakReplicationRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "forceBreakReplication":
			err = unpopulate(val, "ForceBreakReplication", &b.ForceBreakReplication)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CapacityPool.
func (c CapacityPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", c.Etag)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CapacityPool.
func (c *CapacityPool) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &c.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CapacityPoolList.
func (c CapacityPoolList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CapacityPoolList.
func (c *CapacityPoolList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CapacityPoolPatch.
func (c CapacityPoolPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CapacityPoolPatch.
func (c *CapacityPoolPatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CheckAvailabilityResponse.
func (c CheckAvailabilityResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "isAvailable", c.IsAvailable)
	populate(objectMap, "message", c.Message)
	populate(objectMap, "reason", c.Reason)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CheckAvailabilityResponse.
func (c *CheckAvailabilityResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isAvailable":
			err = unpopulate(val, "IsAvailable", &c.IsAvailable)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &c.Message)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &c.Reason)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DailySchedule.
func (d DailySchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hour", d.Hour)
	populate(objectMap, "minute", d.Minute)
	populate(objectMap, "snapshotsToKeep", d.SnapshotsToKeep)
	populate(objectMap, "usedBytes", d.UsedBytes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DailySchedule.
func (d *DailySchedule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hour":
			err = unpopulate(val, "Hour", &d.Hour)
			delete(rawMsg, key)
		case "minute":
			err = unpopulate(val, "Minute", &d.Minute)
			delete(rawMsg, key)
		case "snapshotsToKeep":
			err = unpopulate(val, "SnapshotsToKeep", &d.SnapshotsToKeep)
			delete(rawMsg, key)
		case "usedBytes":
			err = unpopulate(val, "UsedBytes", &d.UsedBytes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Dimension.
func (d Dimension) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", d.DisplayName)
	populate(objectMap, "name", d.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Dimension.
func (d *Dimension) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &d.DisplayName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EncryptionIdentity.
func (e EncryptionIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", e.PrincipalID)
	populate(objectMap, "userAssignedIdentity", e.UserAssignedIdentity)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EncryptionIdentity.
func (e *EncryptionIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &e.PrincipalID)
			delete(rawMsg, key)
		case "userAssignedIdentity":
			err = unpopulate(val, "UserAssignedIdentity", &e.UserAssignedIdentity)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExportPolicyRule.
func (e ExportPolicyRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedClients", e.AllowedClients)
	populate(objectMap, "chownMode", e.ChownMode)
	populate(objectMap, "cifs", e.Cifs)
	populate(objectMap, "hasRootAccess", e.HasRootAccess)
	populate(objectMap, "kerberos5iReadOnly", e.Kerberos5IReadOnly)
	populate(objectMap, "kerberos5iReadWrite", e.Kerberos5IReadWrite)
	populate(objectMap, "kerberos5pReadOnly", e.Kerberos5PReadOnly)
	populate(objectMap, "kerberos5pReadWrite", e.Kerberos5PReadWrite)
	populate(objectMap, "kerberos5ReadOnly", e.Kerberos5ReadOnly)
	populate(objectMap, "kerberos5ReadWrite", e.Kerberos5ReadWrite)
	populate(objectMap, "nfsv3", e.Nfsv3)
	populate(objectMap, "nfsv41", e.Nfsv41)
	populate(objectMap, "ruleIndex", e.RuleIndex)
	populate(objectMap, "unixReadOnly", e.UnixReadOnly)
	populate(objectMap, "unixReadWrite", e.UnixReadWrite)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExportPolicyRule.
func (e *ExportPolicyRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedClients":
			err = unpopulate(val, "AllowedClients", &e.AllowedClients)
			delete(rawMsg, key)
		case "chownMode":
			err = unpopulate(val, "ChownMode", &e.ChownMode)
			delete(rawMsg, key)
		case "cifs":
			err = unpopulate(val, "Cifs", &e.Cifs)
			delete(rawMsg, key)
		case "hasRootAccess":
			err = unpopulate(val, "HasRootAccess", &e.HasRootAccess)
			delete(rawMsg, key)
		case "kerberos5iReadOnly":
			err = unpopulate(val, "Kerberos5IReadOnly", &e.Kerberos5IReadOnly)
			delete(rawMsg, key)
		case "kerberos5iReadWrite":
			err = unpopulate(val, "Kerberos5IReadWrite", &e.Kerberos5IReadWrite)
			delete(rawMsg, key)
		case "kerberos5pReadOnly":
			err = unpopulate(val, "Kerberos5PReadOnly", &e.Kerberos5PReadOnly)
			delete(rawMsg, key)
		case "kerberos5pReadWrite":
			err = unpopulate(val, "Kerberos5PReadWrite", &e.Kerberos5PReadWrite)
			delete(rawMsg, key)
		case "kerberos5ReadOnly":
			err = unpopulate(val, "Kerberos5ReadOnly", &e.Kerberos5ReadOnly)
			delete(rawMsg, key)
		case "kerberos5ReadWrite":
			err = unpopulate(val, "Kerberos5ReadWrite", &e.Kerberos5ReadWrite)
			delete(rawMsg, key)
		case "nfsv3":
			err = unpopulate(val, "Nfsv3", &e.Nfsv3)
			delete(rawMsg, key)
		case "nfsv41":
			err = unpopulate(val, "Nfsv41", &e.Nfsv41)
			delete(rawMsg, key)
		case "ruleIndex":
			err = unpopulate(val, "RuleIndex", &e.RuleIndex)
			delete(rawMsg, key)
		case "unixReadOnly":
			err = unpopulate(val, "UnixReadOnly", &e.UnixReadOnly)
			delete(rawMsg, key)
		case "unixReadWrite":
			err = unpopulate(val, "UnixReadWrite", &e.UnixReadWrite)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FilePathAvailabilityRequest.
func (f FilePathAvailabilityRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "subnetId", f.SubnetID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FilePathAvailabilityRequest.
func (f *FilePathAvailabilityRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "subnetId":
			err = unpopulate(val, "SubnetID", &f.SubnetID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GetGroupIDListForLDAPUserRequest.
func (g GetGroupIDListForLDAPUserRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "username", g.Username)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GetGroupIDListForLDAPUserRequest.
func (g *GetGroupIDListForLDAPUserRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "username":
			err = unpopulate(val, "Username", &g.Username)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GetGroupIDListForLDAPUserResponse.
func (g GetGroupIDListForLDAPUserResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "groupIdsForLdapUser", g.GroupIDsForLdapUser)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GetGroupIDListForLDAPUserResponse.
func (g *GetGroupIDListForLDAPUserResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "groupIdsForLdapUser":
			err = unpopulate(val, "GroupIDsForLdapUser", &g.GroupIDsForLdapUser)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HourlySchedule.
func (h HourlySchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "minute", h.Minute)
	populate(objectMap, "snapshotsToKeep", h.SnapshotsToKeep)
	populate(objectMap, "usedBytes", h.UsedBytes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HourlySchedule.
func (h *HourlySchedule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "minute":
			err = unpopulate(val, "Minute", &h.Minute)
			delete(rawMsg, key)
		case "snapshotsToKeep":
			err = unpopulate(val, "SnapshotsToKeep", &h.SnapshotsToKeep)
			delete(rawMsg, key)
		case "usedBytes":
			err = unpopulate(val, "UsedBytes", &h.UsedBytes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyVaultProperties.
func (k KeyVaultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "keyName", k.KeyName)
	populate(objectMap, "keyVaultId", k.KeyVaultID)
	populate(objectMap, "keyVaultResourceId", k.KeyVaultResourceID)
	populate(objectMap, "keyVaultUri", k.KeyVaultURI)
	populate(objectMap, "status", k.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVaultProperties.
func (k *KeyVaultProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyName":
			err = unpopulate(val, "KeyName", &k.KeyName)
			delete(rawMsg, key)
		case "keyVaultId":
			err = unpopulate(val, "KeyVaultID", &k.KeyVaultID)
			delete(rawMsg, key)
		case "keyVaultResourceId":
			err = unpopulate(val, "KeyVaultResourceID", &k.KeyVaultResourceID)
			delete(rawMsg, key)
		case "keyVaultUri":
			err = unpopulate(val, "KeyVaultURI", &k.KeyVaultURI)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &k.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LdapSearchScopeOpt.
func (l LdapSearchScopeOpt) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "groupDN", l.GroupDN)
	populate(objectMap, "groupMembershipFilter", l.GroupMembershipFilter)
	populate(objectMap, "userDN", l.UserDN)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LdapSearchScopeOpt.
func (l *LdapSearchScopeOpt) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "groupDN":
			err = unpopulate(val, "GroupDN", &l.GroupDN)
			delete(rawMsg, key)
		case "groupMembershipFilter":
			err = unpopulate(val, "GroupMembershipFilter", &l.GroupMembershipFilter)
			delete(rawMsg, key)
		case "userDN":
			err = unpopulate(val, "UserDN", &l.UserDN)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListReplications.
func (l ListReplications) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListReplications.
func (l *ListReplications) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LogSpecification.
func (l LogSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", l.DisplayName)
	populate(objectMap, "name", l.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LogSpecification.
func (l *LogSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &l.DisplayName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedServiceIdentity.
func (m ManagedServiceIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", m.PrincipalID)
	populate(objectMap, "tenantId", m.TenantID)
	populate(objectMap, "type", m.Type)
	populate(objectMap, "userAssignedIdentities", m.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedServiceIdentity.
func (m *ManagedServiceIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &m.PrincipalID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &m.TenantID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		case "userAssignedIdentities":
			err = unpopulate(val, "UserAssignedIdentities", &m.UserAssignedIdentities)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MetricSpecification.
func (m MetricSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aggregationType", m.AggregationType)
	populate(objectMap, "category", m.Category)
	populate(objectMap, "dimensions", m.Dimensions)
	populate(objectMap, "displayDescription", m.DisplayDescription)
	populate(objectMap, "displayName", m.DisplayName)
	populate(objectMap, "enableRegionalMdmAccount", m.EnableRegionalMdmAccount)
	populate(objectMap, "fillGapWithZero", m.FillGapWithZero)
	populate(objectMap, "internalMetricName", m.InternalMetricName)
	populate(objectMap, "isInternal", m.IsInternal)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "resourceIdDimensionNameOverride", m.ResourceIDDimensionNameOverride)
	populate(objectMap, "sourceMdmAccount", m.SourceMdmAccount)
	populate(objectMap, "sourceMdmNamespace", m.SourceMdmNamespace)
	populate(objectMap, "supportedAggregationTypes", m.SupportedAggregationTypes)
	populate(objectMap, "supportedTimeGrainTypes", m.SupportedTimeGrainTypes)
	populate(objectMap, "unit", m.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MetricSpecification.
func (m *MetricSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aggregationType":
			err = unpopulate(val, "AggregationType", &m.AggregationType)
			delete(rawMsg, key)
		case "category":
			err = unpopulate(val, "Category", &m.Category)
			delete(rawMsg, key)
		case "dimensions":
			err = unpopulate(val, "Dimensions", &m.Dimensions)
			delete(rawMsg, key)
		case "displayDescription":
			err = unpopulate(val, "DisplayDescription", &m.DisplayDescription)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &m.DisplayName)
			delete(rawMsg, key)
		case "enableRegionalMdmAccount":
			err = unpopulate(val, "EnableRegionalMdmAccount", &m.EnableRegionalMdmAccount)
			delete(rawMsg, key)
		case "fillGapWithZero":
			err = unpopulate(val, "FillGapWithZero", &m.FillGapWithZero)
			delete(rawMsg, key)
		case "internalMetricName":
			err = unpopulate(val, "InternalMetricName", &m.InternalMetricName)
			delete(rawMsg, key)
		case "isInternal":
			err = unpopulate(val, "IsInternal", &m.IsInternal)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "resourceIdDimensionNameOverride":
			err = unpopulate(val, "ResourceIDDimensionNameOverride", &m.ResourceIDDimensionNameOverride)
			delete(rawMsg, key)
		case "sourceMdmAccount":
			err = unpopulate(val, "SourceMdmAccount", &m.SourceMdmAccount)
			delete(rawMsg, key)
		case "sourceMdmNamespace":
			err = unpopulate(val, "SourceMdmNamespace", &m.SourceMdmNamespace)
			delete(rawMsg, key)
		case "supportedAggregationTypes":
			err = unpopulate(val, "SupportedAggregationTypes", &m.SupportedAggregationTypes)
			delete(rawMsg, key)
		case "supportedTimeGrainTypes":
			err = unpopulate(val, "SupportedTimeGrainTypes", &m.SupportedTimeGrainTypes)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &m.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MonthlySchedule.
func (m MonthlySchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "daysOfMonth", m.DaysOfMonth)
	populate(objectMap, "hour", m.Hour)
	populate(objectMap, "minute", m.Minute)
	populate(objectMap, "snapshotsToKeep", m.SnapshotsToKeep)
	populate(objectMap, "usedBytes", m.UsedBytes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MonthlySchedule.
func (m *MonthlySchedule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "daysOfMonth":
			err = unpopulate(val, "DaysOfMonth", &m.DaysOfMonth)
			delete(rawMsg, key)
		case "hour":
			err = unpopulate(val, "Hour", &m.Hour)
			delete(rawMsg, key)
		case "minute":
			err = unpopulate(val, "Minute", &m.Minute)
			delete(rawMsg, key)
		case "snapshotsToKeep":
			err = unpopulate(val, "SnapshotsToKeep", &m.SnapshotsToKeep)
			delete(rawMsg, key)
		case "usedBytes":
			err = unpopulate(val, "UsedBytes", &m.UsedBytes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MountTargetProperties.
func (m MountTargetProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "fileSystemId", m.FileSystemID)
	populate(objectMap, "ipAddress", m.IPAddress)
	populate(objectMap, "mountTargetId", m.MountTargetID)
	populate(objectMap, "smbServerFqdn", m.SmbServerFqdn)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MountTargetProperties.
func (m *MountTargetProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fileSystemId":
			err = unpopulate(val, "FileSystemID", &m.FileSystemID)
			delete(rawMsg, key)
		case "ipAddress":
			err = unpopulate(val, "IPAddress", &m.IPAddress)
			delete(rawMsg, key)
		case "mountTargetId":
			err = unpopulate(val, "MountTargetID", &m.MountTargetID)
			delete(rawMsg, key)
		case "smbServerFqdn":
			err = unpopulate(val, "SmbServerFqdn", &m.SmbServerFqdn)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkSiblingSet.
func (n NetworkSiblingSet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "networkFeatures", n.NetworkFeatures)
	populate(objectMap, "networkSiblingSetId", n.NetworkSiblingSetID)
	populate(objectMap, "networkSiblingSetStateId", n.NetworkSiblingSetStateID)
	populate(objectMap, "nicInfoList", n.NicInfoList)
	populate(objectMap, "provisioningState", n.ProvisioningState)
	populate(objectMap, "subnetId", n.SubnetID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkSiblingSet.
func (n *NetworkSiblingSet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "networkFeatures":
			err = unpopulate(val, "NetworkFeatures", &n.NetworkFeatures)
			delete(rawMsg, key)
		case "networkSiblingSetId":
			err = unpopulate(val, "NetworkSiblingSetID", &n.NetworkSiblingSetID)
			delete(rawMsg, key)
		case "networkSiblingSetStateId":
			err = unpopulate(val, "NetworkSiblingSetStateID", &n.NetworkSiblingSetStateID)
			delete(rawMsg, key)
		case "nicInfoList":
			err = unpopulate(val, "NicInfoList", &n.NicInfoList)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &n.ProvisioningState)
			delete(rawMsg, key)
		case "subnetId":
			err = unpopulate(val, "SubnetID", &n.SubnetID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NicInfo.
func (n NicInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ipAddress", n.IPAddress)
	populate(objectMap, "volumeResourceIds", n.VolumeResourceIDs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NicInfo.
func (n *NicInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ipAddress":
			err = unpopulate(val, "IPAddress", &n.IPAddress)
			delete(rawMsg, key)
		case "volumeResourceIds":
			err = unpopulate(val, "VolumeResourceIDs", &n.VolumeResourceIDs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "origin", o.Origin)
	populate(objectMap, "properties", o.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationListResult.
func (o OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationListResult.
func (o *OperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationProperties.
func (o OperationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "serviceSpecification", o.ServiceSpecification)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationProperties.
func (o *OperationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "serviceSpecification":
			err = unpopulate(val, "ServiceSpecification", &o.ServiceSpecification)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PlacementKeyValuePairs.
func (p PlacementKeyValuePairs) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "key", p.Key)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PlacementKeyValuePairs.
func (p *PlacementKeyValuePairs) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "key":
			err = unpopulate(val, "Key", &p.Key)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PoolChangeRequest.
func (p PoolChangeRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "newPoolResourceId", p.NewPoolResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PoolChangeRequest.
func (p *PoolChangeRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "newPoolResourceId":
			err = unpopulate(val, "NewPoolResourceID", &p.NewPoolResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PoolPatchProperties.
func (p PoolPatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "coolAccess", p.CoolAccess)
	populate(objectMap, "qosType", p.QosType)
	populate(objectMap, "size", p.Size)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PoolPatchProperties.
func (p *PoolPatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "coolAccess":
			err = unpopulate(val, "CoolAccess", &p.CoolAccess)
			delete(rawMsg, key)
		case "qosType":
			err = unpopulate(val, "QosType", &p.QosType)
			delete(rawMsg, key)
		case "size":
			err = unpopulate(val, "Size", &p.Size)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PoolProperties.
func (p PoolProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "coolAccess", p.CoolAccess)
	populate(objectMap, "encryptionType", p.EncryptionType)
	populate(objectMap, "poolId", p.PoolID)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "qosType", p.QosType)
	populate(objectMap, "serviceLevel", p.ServiceLevel)
	populate(objectMap, "size", p.Size)
	populate(objectMap, "totalThroughputMibps", p.TotalThroughputMibps)
	populate(objectMap, "utilizedThroughputMibps", p.UtilizedThroughputMibps)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PoolProperties.
func (p *PoolProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "coolAccess":
			err = unpopulate(val, "CoolAccess", &p.CoolAccess)
			delete(rawMsg, key)
		case "encryptionType":
			err = unpopulate(val, "EncryptionType", &p.EncryptionType)
			delete(rawMsg, key)
		case "poolId":
			err = unpopulate(val, "PoolID", &p.PoolID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "qosType":
			err = unpopulate(val, "QosType", &p.QosType)
			delete(rawMsg, key)
		case "serviceLevel":
			err = unpopulate(val, "ServiceLevel", &p.ServiceLevel)
			delete(rawMsg, key)
		case "size":
			err = unpopulate(val, "Size", &p.Size)
			delete(rawMsg, key)
		case "totalThroughputMibps":
			err = unpopulate(val, "TotalThroughputMibps", &p.TotalThroughputMibps)
			delete(rawMsg, key)
		case "utilizedThroughputMibps":
			err = unpopulate(val, "UtilizedThroughputMibps", &p.UtilizedThroughputMibps)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QueryNetworkSiblingSetRequest.
func (q QueryNetworkSiblingSetRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "networkSiblingSetId", q.NetworkSiblingSetID)
	populate(objectMap, "subnetId", q.SubnetID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QueryNetworkSiblingSetRequest.
func (q *QueryNetworkSiblingSetRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "networkSiblingSetId":
			err = unpopulate(val, "NetworkSiblingSetID", &q.NetworkSiblingSetID)
			delete(rawMsg, key)
		case "subnetId":
			err = unpopulate(val, "SubnetID", &q.SubnetID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QuotaAvailabilityRequest.
func (q QuotaAvailabilityRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", q.Name)
	populate(objectMap, "resourceGroup", q.ResourceGroup)
	populate(objectMap, "type", q.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QuotaAvailabilityRequest.
func (q *QuotaAvailabilityRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &q.Name)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &q.ResourceGroup)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &q.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReestablishReplicationRequest.
func (r ReestablishReplicationRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "sourceVolumeId", r.SourceVolumeID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReestablishReplicationRequest.
func (r *ReestablishReplicationRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sourceVolumeId":
			err = unpopulate(val, "SourceVolumeID", &r.SourceVolumeID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RegionInfo.
func (r RegionInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "availabilityZoneMappings", r.AvailabilityZoneMappings)
	populate(objectMap, "storageToNetworkProximity", r.StorageToNetworkProximity)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegionInfo.
func (r *RegionInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availabilityZoneMappings":
			err = unpopulate(val, "AvailabilityZoneMappings", &r.AvailabilityZoneMappings)
			delete(rawMsg, key)
		case "storageToNetworkProximity":
			err = unpopulate(val, "StorageToNetworkProximity", &r.StorageToNetworkProximity)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RegionInfoAvailabilityZoneMappingsItem.
func (r RegionInfoAvailabilityZoneMappingsItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "availabilityZone", r.AvailabilityZone)
	populate(objectMap, "isAvailable", r.IsAvailable)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegionInfoAvailabilityZoneMappingsItem.
func (r *RegionInfoAvailabilityZoneMappingsItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availabilityZone":
			err = unpopulate(val, "AvailabilityZone", &r.AvailabilityZone)
			delete(rawMsg, key)
		case "isAvailable":
			err = unpopulate(val, "IsAvailable", &r.IsAvailable)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RelocateVolumeRequest.
func (r RelocateVolumeRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "creationToken", r.CreationToken)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RelocateVolumeRequest.
func (r *RelocateVolumeRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationToken":
			err = unpopulate(val, "CreationToken", &r.CreationToken)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Replication.
func (r Replication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "endpointType", r.EndpointType)
	populate(objectMap, "remoteVolumeRegion", r.RemoteVolumeRegion)
	populate(objectMap, "remoteVolumeResourceId", r.RemoteVolumeResourceID)
	populate(objectMap, "replicationSchedule", r.ReplicationSchedule)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Replication.
func (r *Replication) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endpointType":
			err = unpopulate(val, "EndpointType", &r.EndpointType)
			delete(rawMsg, key)
		case "remoteVolumeRegion":
			err = unpopulate(val, "RemoteVolumeRegion", &r.RemoteVolumeRegion)
			delete(rawMsg, key)
		case "remoteVolumeResourceId":
			err = unpopulate(val, "RemoteVolumeResourceID", &r.RemoteVolumeResourceID)
			delete(rawMsg, key)
		case "replicationSchedule":
			err = unpopulate(val, "ReplicationSchedule", &r.ReplicationSchedule)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReplicationObject.
func (r ReplicationObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "endpointType", r.EndpointType)
	populate(objectMap, "remoteVolumeRegion", r.RemoteVolumeRegion)
	populate(objectMap, "remoteVolumeResourceId", r.RemoteVolumeResourceID)
	populate(objectMap, "replicationId", r.ReplicationID)
	populate(objectMap, "replicationSchedule", r.ReplicationSchedule)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplicationObject.
func (r *ReplicationObject) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endpointType":
			err = unpopulate(val, "EndpointType", &r.EndpointType)
			delete(rawMsg, key)
		case "remoteVolumeRegion":
			err = unpopulate(val, "RemoteVolumeRegion", &r.RemoteVolumeRegion)
			delete(rawMsg, key)
		case "remoteVolumeResourceId":
			err = unpopulate(val, "RemoteVolumeResourceID", &r.RemoteVolumeResourceID)
			delete(rawMsg, key)
		case "replicationId":
			err = unpopulate(val, "ReplicationID", &r.ReplicationID)
			delete(rawMsg, key)
		case "replicationSchedule":
			err = unpopulate(val, "ReplicationSchedule", &r.ReplicationSchedule)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReplicationStatus.
func (r ReplicationStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "errorMessage", r.ErrorMessage)
	populate(objectMap, "healthy", r.Healthy)
	populate(objectMap, "mirrorState", r.MirrorState)
	populate(objectMap, "relationshipStatus", r.RelationshipStatus)
	populate(objectMap, "totalProgress", r.TotalProgress)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplicationStatus.
func (r *ReplicationStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errorMessage":
			err = unpopulate(val, "ErrorMessage", &r.ErrorMessage)
			delete(rawMsg, key)
		case "healthy":
			err = unpopulate(val, "Healthy", &r.Healthy)
			delete(rawMsg, key)
		case "mirrorState":
			err = unpopulate(val, "MirrorState", &r.MirrorState)
			delete(rawMsg, key)
		case "relationshipStatus":
			err = unpopulate(val, "RelationshipStatus", &r.RelationshipStatus)
			delete(rawMsg, key)
		case "totalProgress":
			err = unpopulate(val, "TotalProgress", &r.TotalProgress)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceNameAvailabilityRequest.
func (r ResourceNameAvailabilityRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "resourceGroup", r.ResourceGroup)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceNameAvailabilityRequest.
func (r *ResourceNameAvailabilityRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &r.ResourceGroup)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RestoreStatus.
func (r RestoreStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "errorMessage", r.ErrorMessage)
	populate(objectMap, "healthy", r.Healthy)
	populate(objectMap, "mirrorState", r.MirrorState)
	populate(objectMap, "relationshipStatus", r.RelationshipStatus)
	populate(objectMap, "totalTransferBytes", r.TotalTransferBytes)
	populate(objectMap, "unhealthyReason", r.UnhealthyReason)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RestoreStatus.
func (r *RestoreStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errorMessage":
			err = unpopulate(val, "ErrorMessage", &r.ErrorMessage)
			delete(rawMsg, key)
		case "healthy":
			err = unpopulate(val, "Healthy", &r.Healthy)
			delete(rawMsg, key)
		case "mirrorState":
			err = unpopulate(val, "MirrorState", &r.MirrorState)
			delete(rawMsg, key)
		case "relationshipStatus":
			err = unpopulate(val, "RelationshipStatus", &r.RelationshipStatus)
			delete(rawMsg, key)
		case "totalTransferBytes":
			err = unpopulate(val, "TotalTransferBytes", &r.TotalTransferBytes)
			delete(rawMsg, key)
		case "unhealthyReason":
			err = unpopulate(val, "UnhealthyReason", &r.UnhealthyReason)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceSpecification.
func (s ServiceSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "logSpecifications", s.LogSpecifications)
	populate(objectMap, "metricSpecifications", s.MetricSpecifications)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceSpecification.
func (s *ServiceSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "logSpecifications":
			err = unpopulate(val, "LogSpecifications", &s.LogSpecifications)
			delete(rawMsg, key)
		case "metricSpecifications":
			err = unpopulate(val, "MetricSpecifications", &s.MetricSpecifications)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Snapshot.
func (s Snapshot) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Snapshot.
func (s *Snapshot) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SnapshotPoliciesList.
func (s SnapshotPoliciesList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SnapshotPoliciesList.
func (s *SnapshotPoliciesList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SnapshotPolicy.
func (s SnapshotPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", s.Etag)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SnapshotPolicy.
func (s *SnapshotPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &s.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SnapshotPolicyPatch.
func (s SnapshotPolicyPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SnapshotPolicyPatch.
func (s *SnapshotPolicyPatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SnapshotPolicyProperties.
func (s SnapshotPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dailySchedule", s.DailySchedule)
	populate(objectMap, "enabled", s.Enabled)
	populate(objectMap, "hourlySchedule", s.HourlySchedule)
	populate(objectMap, "monthlySchedule", s.MonthlySchedule)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "weeklySchedule", s.WeeklySchedule)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SnapshotPolicyProperties.
func (s *SnapshotPolicyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dailySchedule":
			err = unpopulate(val, "DailySchedule", &s.DailySchedule)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &s.Enabled)
			delete(rawMsg, key)
		case "hourlySchedule":
			err = unpopulate(val, "HourlySchedule", &s.HourlySchedule)
			delete(rawMsg, key)
		case "monthlySchedule":
			err = unpopulate(val, "MonthlySchedule", &s.MonthlySchedule)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "weeklySchedule":
			err = unpopulate(val, "WeeklySchedule", &s.WeeklySchedule)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SnapshotPolicyVolumeList.
func (s SnapshotPolicyVolumeList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SnapshotPolicyVolumeList.
func (s *SnapshotPolicyVolumeList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SnapshotProperties.
func (s SnapshotProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "created", s.Created)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "snapshotId", s.SnapshotID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SnapshotProperties.
func (s *SnapshotProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "created":
			err = unpopulateDateTimeRFC3339(val, "Created", &s.Created)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "snapshotId":
			err = unpopulate(val, "SnapshotID", &s.SnapshotID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SnapshotRestoreFiles.
func (s SnapshotRestoreFiles) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "destinationPath", s.DestinationPath)
	populate(objectMap, "filePaths", s.FilePaths)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SnapshotRestoreFiles.
func (s *SnapshotRestoreFiles) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "destinationPath":
			err = unpopulate(val, "DestinationPath", &s.DestinationPath)
			delete(rawMsg, key)
		case "filePaths":
			err = unpopulate(val, "FilePaths", &s.FilePaths)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SnapshotsList.
func (s SnapshotsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SnapshotsList.
func (s *SnapshotsList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubscriptionQuotaItem.
func (s SubscriptionQuotaItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubscriptionQuotaItem.
func (s *SubscriptionQuotaItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubscriptionQuotaItemList.
func (s SubscriptionQuotaItemList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubscriptionQuotaItemList.
func (s *SubscriptionQuotaItemList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubscriptionQuotaItemProperties.
func (s SubscriptionQuotaItemProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "current", s.Current)
	populate(objectMap, "default", s.Default)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubscriptionQuotaItemProperties.
func (s *SubscriptionQuotaItemProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "current":
			err = unpopulate(val, "Current", &s.Current)
			delete(rawMsg, key)
		case "default":
			err = unpopulate(val, "Default", &s.Default)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubvolumeInfo.
func (s SubvolumeInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubvolumeInfo.
func (s *SubvolumeInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubvolumeModel.
func (s SubvolumeModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubvolumeModel.
func (s *SubvolumeModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubvolumeModelProperties.
func (s SubvolumeModelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "accessedTimeStamp", s.AccessedTimeStamp)
	populate(objectMap, "bytesUsed", s.BytesUsed)
	populateDateTimeRFC3339(objectMap, "changedTimeStamp", s.ChangedTimeStamp)
	populateDateTimeRFC3339(objectMap, "creationTimeStamp", s.CreationTimeStamp)
	populateDateTimeRFC3339(objectMap, "modifiedTimeStamp", s.ModifiedTimeStamp)
	populate(objectMap, "parentPath", s.ParentPath)
	populate(objectMap, "path", s.Path)
	populate(objectMap, "permissions", s.Permissions)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "size", s.Size)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubvolumeModelProperties.
func (s *SubvolumeModelProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessedTimeStamp":
			err = unpopulateDateTimeRFC3339(val, "AccessedTimeStamp", &s.AccessedTimeStamp)
			delete(rawMsg, key)
		case "bytesUsed":
			err = unpopulate(val, "BytesUsed", &s.BytesUsed)
			delete(rawMsg, key)
		case "changedTimeStamp":
			err = unpopulateDateTimeRFC3339(val, "ChangedTimeStamp", &s.ChangedTimeStamp)
			delete(rawMsg, key)
		case "creationTimeStamp":
			err = unpopulateDateTimeRFC3339(val, "CreationTimeStamp", &s.CreationTimeStamp)
			delete(rawMsg, key)
		case "modifiedTimeStamp":
			err = unpopulateDateTimeRFC3339(val, "ModifiedTimeStamp", &s.ModifiedTimeStamp)
			delete(rawMsg, key)
		case "parentPath":
			err = unpopulate(val, "ParentPath", &s.ParentPath)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &s.Path)
			delete(rawMsg, key)
		case "permissions":
			err = unpopulate(val, "Permissions", &s.Permissions)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "size":
			err = unpopulate(val, "Size", &s.Size)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubvolumePatchParams.
func (s SubvolumePatchParams) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "path", s.Path)
	populate(objectMap, "size", s.Size)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubvolumePatchParams.
func (s *SubvolumePatchParams) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "path":
			err = unpopulate(val, "Path", &s.Path)
			delete(rawMsg, key)
		case "size":
			err = unpopulate(val, "Size", &s.Size)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubvolumePatchRequest.
func (s SubvolumePatchRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubvolumePatchRequest.
func (s *SubvolumePatchRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubvolumeProperties.
func (s SubvolumeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "parentPath", s.ParentPath)
	populate(objectMap, "path", s.Path)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "size", s.Size)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubvolumeProperties.
func (s *SubvolumeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "parentPath":
			err = unpopulate(val, "ParentPath", &s.ParentPath)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &s.Path)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "size":
			err = unpopulate(val, "Size", &s.Size)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubvolumesList.
func (s SubvolumesList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubvolumesList.
func (s *SubvolumesList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateNetworkSiblingSetRequest.
func (u UpdateNetworkSiblingSetRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "networkFeatures", u.NetworkFeatures)
	populate(objectMap, "networkSiblingSetId", u.NetworkSiblingSetID)
	populate(objectMap, "networkSiblingSetStateId", u.NetworkSiblingSetStateID)
	populate(objectMap, "subnetId", u.SubnetID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateNetworkSiblingSetRequest.
func (u *UpdateNetworkSiblingSetRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "networkFeatures":
			err = unpopulate(val, "NetworkFeatures", &u.NetworkFeatures)
			delete(rawMsg, key)
		case "networkSiblingSetId":
			err = unpopulate(val, "NetworkSiblingSetID", &u.NetworkSiblingSetID)
			delete(rawMsg, key)
		case "networkSiblingSetStateId":
			err = unpopulate(val, "NetworkSiblingSetStateID", &u.NetworkSiblingSetStateID)
			delete(rawMsg, key)
		case "subnetId":
			err = unpopulate(val, "SubnetID", &u.SubnetID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserAssignedIdentity.
func (u UserAssignedIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", u.ClientID)
	populate(objectMap, "principalId", u.PrincipalID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserAssignedIdentity.
func (u *UserAssignedIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &u.ClientID)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &u.PrincipalID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Volume.
func (v Volume) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", v.Etag)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "systemData", v.SystemData)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	populate(objectMap, "zones", v.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Volume.
func (v *Volume) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &v.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &v.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &v.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VolumeBackups.
func (v VolumeBackups) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backupsCount", v.BackupsCount)
	populate(objectMap, "policyEnabled", v.PolicyEnabled)
	populate(objectMap, "volumeName", v.VolumeName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VolumeBackups.
func (v *VolumeBackups) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backupsCount":
			err = unpopulate(val, "BackupsCount", &v.BackupsCount)
			delete(rawMsg, key)
		case "policyEnabled":
			err = unpopulate(val, "PolicyEnabled", &v.PolicyEnabled)
			delete(rawMsg, key)
		case "volumeName":
			err = unpopulate(val, "VolumeName", &v.VolumeName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VolumeGroup.
func (v VolumeGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VolumeGroup.
func (v *VolumeGroup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VolumeGroupDetails.
func (v VolumeGroupDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VolumeGroupDetails.
func (v *VolumeGroupDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VolumeGroupList.
func (v VolumeGroupList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VolumeGroupList.
func (v *VolumeGroupList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VolumeGroupListProperties.
func (v VolumeGroupListProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "groupMetaData", v.GroupMetaData)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VolumeGroupListProperties.
func (v *VolumeGroupListProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "groupMetaData":
			err = unpopulate(val, "GroupMetaData", &v.GroupMetaData)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VolumeGroupMetaData.
func (v VolumeGroupMetaData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationIdentifier", v.ApplicationIdentifier)
	populate(objectMap, "applicationType", v.ApplicationType)
	populate(objectMap, "globalPlacementRules", v.GlobalPlacementRules)
	populate(objectMap, "groupDescription", v.GroupDescription)
	populate(objectMap, "volumesCount", v.VolumesCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VolumeGroupMetaData.
func (v *VolumeGroupMetaData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationIdentifier":
			err = unpopulate(val, "ApplicationIdentifier", &v.ApplicationIdentifier)
			delete(rawMsg, key)
		case "applicationType":
			err = unpopulate(val, "ApplicationType", &v.ApplicationType)
			delete(rawMsg, key)
		case "globalPlacementRules":
			err = unpopulate(val, "GlobalPlacementRules", &v.GlobalPlacementRules)
			delete(rawMsg, key)
		case "groupDescription":
			err = unpopulate(val, "GroupDescription", &v.GroupDescription)
			delete(rawMsg, key)
		case "volumesCount":
			err = unpopulate(val, "VolumesCount", &v.VolumesCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VolumeGroupProperties.
func (v VolumeGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "groupMetaData", v.GroupMetaData)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "volumes", v.Volumes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VolumeGroupProperties.
func (v *VolumeGroupProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "groupMetaData":
			err = unpopulate(val, "GroupMetaData", &v.GroupMetaData)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "volumes":
			err = unpopulate(val, "Volumes", &v.Volumes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VolumeGroupVolumeProperties.
func (v VolumeGroupVolumeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	populate(objectMap, "zones", v.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VolumeGroupVolumeProperties.
func (v *VolumeGroupVolumeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &v.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VolumeList.
func (v VolumeList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VolumeList.
func (v *VolumeList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VolumePatch.
func (v VolumePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VolumePatch.
func (v *VolumePatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VolumePatchProperties.
func (v VolumePatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "coolAccess", v.CoolAccess)
	populate(objectMap, "coolAccessRetrievalPolicy", v.CoolAccessRetrievalPolicy)
	populate(objectMap, "coolnessPeriod", v.CoolnessPeriod)
	populate(objectMap, "dataProtection", v.DataProtection)
	populate(objectMap, "defaultGroupQuotaInKiBs", v.DefaultGroupQuotaInKiBs)
	populate(objectMap, "defaultUserQuotaInKiBs", v.DefaultUserQuotaInKiBs)
	populate(objectMap, "exportPolicy", v.ExportPolicy)
	populate(objectMap, "isDefaultQuotaEnabled", v.IsDefaultQuotaEnabled)
	populate(objectMap, "serviceLevel", v.ServiceLevel)
	populate(objectMap, "smbAccessBasedEnumeration", v.SmbAccessBasedEnumeration)
	populate(objectMap, "smbNonBrowsable", v.SmbNonBrowsable)
	populate(objectMap, "snapshotDirectoryVisible", v.SnapshotDirectoryVisible)
	populate(objectMap, "throughputMibps", v.ThroughputMibps)
	populate(objectMap, "unixPermissions", v.UnixPermissions)
	populate(objectMap, "usageThreshold", v.UsageThreshold)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VolumePatchProperties.
func (v *VolumePatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "coolAccess":
			err = unpopulate(val, "CoolAccess", &v.CoolAccess)
			delete(rawMsg, key)
		case "coolAccessRetrievalPolicy":
			err = unpopulate(val, "CoolAccessRetrievalPolicy", &v.CoolAccessRetrievalPolicy)
			delete(rawMsg, key)
		case "coolnessPeriod":
			err = unpopulate(val, "CoolnessPeriod", &v.CoolnessPeriod)
			delete(rawMsg, key)
		case "dataProtection":
			err = unpopulate(val, "DataProtection", &v.DataProtection)
			delete(rawMsg, key)
		case "defaultGroupQuotaInKiBs":
			err = unpopulate(val, "DefaultGroupQuotaInKiBs", &v.DefaultGroupQuotaInKiBs)
			delete(rawMsg, key)
		case "defaultUserQuotaInKiBs":
			err = unpopulate(val, "DefaultUserQuotaInKiBs", &v.DefaultUserQuotaInKiBs)
			delete(rawMsg, key)
		case "exportPolicy":
			err = unpopulate(val, "ExportPolicy", &v.ExportPolicy)
			delete(rawMsg, key)
		case "isDefaultQuotaEnabled":
			err = unpopulate(val, "IsDefaultQuotaEnabled", &v.IsDefaultQuotaEnabled)
			delete(rawMsg, key)
		case "serviceLevel":
			err = unpopulate(val, "ServiceLevel", &v.ServiceLevel)
			delete(rawMsg, key)
		case "smbAccessBasedEnumeration":
			err = unpopulate(val, "SmbAccessBasedEnumeration", &v.SmbAccessBasedEnumeration)
			delete(rawMsg, key)
		case "smbNonBrowsable":
			err = unpopulate(val, "SmbNonBrowsable", &v.SmbNonBrowsable)
			delete(rawMsg, key)
		case "snapshotDirectoryVisible":
			err = unpopulate(val, "SnapshotDirectoryVisible", &v.SnapshotDirectoryVisible)
			delete(rawMsg, key)
		case "throughputMibps":
			err = unpopulate(val, "ThroughputMibps", &v.ThroughputMibps)
			delete(rawMsg, key)
		case "unixPermissions":
			err = unpopulate(val, "UnixPermissions", &v.UnixPermissions)
			delete(rawMsg, key)
		case "usageThreshold":
			err = unpopulate(val, "UsageThreshold", &v.UsageThreshold)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VolumePatchPropertiesDataProtection.
func (v VolumePatchPropertiesDataProtection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "snapshot", v.Snapshot)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VolumePatchPropertiesDataProtection.
func (v *VolumePatchPropertiesDataProtection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "snapshot":
			err = unpopulate(val, "Snapshot", &v.Snapshot)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VolumePatchPropertiesExportPolicy.
func (v VolumePatchPropertiesExportPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "rules", v.Rules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VolumePatchPropertiesExportPolicy.
func (v *VolumePatchPropertiesExportPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "rules":
			err = unpopulate(val, "Rules", &v.Rules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VolumeProperties.
func (v VolumeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actualThroughputMibps", v.ActualThroughputMibps)
	populate(objectMap, "avsDataStore", v.AvsDataStore)
	populate(objectMap, "backupId", v.BackupID)
	populate(objectMap, "baremetalTenantId", v.BaremetalTenantID)
	populate(objectMap, "capacityPoolResourceId", v.CapacityPoolResourceID)
	populate(objectMap, "cloneProgress", v.CloneProgress)
	populate(objectMap, "coolAccess", v.CoolAccess)
	populate(objectMap, "coolAccessRetrievalPolicy", v.CoolAccessRetrievalPolicy)
	populate(objectMap, "coolnessPeriod", v.CoolnessPeriod)
	populate(objectMap, "creationToken", v.CreationToken)
	populate(objectMap, "dataProtection", v.DataProtection)
	populate(objectMap, "dataStoreResourceId", v.DataStoreResourceID)
	populate(objectMap, "defaultGroupQuotaInKiBs", v.DefaultGroupQuotaInKiBs)
	populate(objectMap, "defaultUserQuotaInKiBs", v.DefaultUserQuotaInKiBs)
	populate(objectMap, "deleteBaseSnapshot", v.DeleteBaseSnapshot)
	populate(objectMap, "enableSubvolumes", v.EnableSubvolumes)
	populate(objectMap, "encrypted", v.Encrypted)
	populate(objectMap, "encryptionKeySource", v.EncryptionKeySource)
	populate(objectMap, "exportPolicy", v.ExportPolicy)
	populate(objectMap, "fileAccessLogs", v.FileAccessLogs)
	populate(objectMap, "fileSystemId", v.FileSystemID)
	populate(objectMap, "isDefaultQuotaEnabled", v.IsDefaultQuotaEnabled)
	populate(objectMap, "isLargeVolume", v.IsLargeVolume)
	populate(objectMap, "isRestoring", v.IsRestoring)
	populate(objectMap, "kerberosEnabled", v.KerberosEnabled)
	populate(objectMap, "keyVaultPrivateEndpointResourceId", v.KeyVaultPrivateEndpointResourceID)
	populate(objectMap, "ldapEnabled", v.LdapEnabled)
	populate(objectMap, "maximumNumberOfFiles", v.MaximumNumberOfFiles)
	populate(objectMap, "mountTargets", v.MountTargets)
	populate(objectMap, "networkFeatures", v.NetworkFeatures)
	populate(objectMap, "networkSiblingSetId", v.NetworkSiblingSetID)
	populate(objectMap, "originatingResourceId", v.OriginatingResourceID)
	populate(objectMap, "placementRules", v.PlacementRules)
	populate(objectMap, "protocolTypes", v.ProtocolTypes)
	populate(objectMap, "provisionedAvailabilityZone", v.ProvisionedAvailabilityZone)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "proximityPlacementGroup", v.ProximityPlacementGroup)
	populate(objectMap, "securityStyle", v.SecurityStyle)
	populate(objectMap, "serviceLevel", v.ServiceLevel)
	populate(objectMap, "smbAccessBasedEnumeration", v.SmbAccessBasedEnumeration)
	populate(objectMap, "smbContinuouslyAvailable", v.SmbContinuouslyAvailable)
	populate(objectMap, "smbEncryption", v.SmbEncryption)
	populate(objectMap, "smbNonBrowsable", v.SmbNonBrowsable)
	populate(objectMap, "snapshotDirectoryVisible", v.SnapshotDirectoryVisible)
	populate(objectMap, "snapshotId", v.SnapshotID)
	populate(objectMap, "storageToNetworkProximity", v.StorageToNetworkProximity)
	populate(objectMap, "subnetId", v.SubnetID)
	populate(objectMap, "t2Network", v.T2Network)
	populate(objectMap, "throughputMibps", v.ThroughputMibps)
	populate(objectMap, "unixPermissions", v.UnixPermissions)
	populate(objectMap, "usageThreshold", v.UsageThreshold)
	populate(objectMap, "volumeGroupName", v.VolumeGroupName)
	populate(objectMap, "volumeSpecName", v.VolumeSpecName)
	populate(objectMap, "volumeType", v.VolumeType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VolumeProperties.
func (v *VolumeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actualThroughputMibps":
			err = unpopulate(val, "ActualThroughputMibps", &v.ActualThroughputMibps)
			delete(rawMsg, key)
		case "avsDataStore":
			err = unpopulate(val, "AvsDataStore", &v.AvsDataStore)
			delete(rawMsg, key)
		case "backupId":
			err = unpopulate(val, "BackupID", &v.BackupID)
			delete(rawMsg, key)
		case "baremetalTenantId":
			err = unpopulate(val, "BaremetalTenantID", &v.BaremetalTenantID)
			delete(rawMsg, key)
		case "capacityPoolResourceId":
			err = unpopulate(val, "CapacityPoolResourceID", &v.CapacityPoolResourceID)
			delete(rawMsg, key)
		case "cloneProgress":
			err = unpopulate(val, "CloneProgress", &v.CloneProgress)
			delete(rawMsg, key)
		case "coolAccess":
			err = unpopulate(val, "CoolAccess", &v.CoolAccess)
			delete(rawMsg, key)
		case "coolAccessRetrievalPolicy":
			err = unpopulate(val, "CoolAccessRetrievalPolicy", &v.CoolAccessRetrievalPolicy)
			delete(rawMsg, key)
		case "coolnessPeriod":
			err = unpopulate(val, "CoolnessPeriod", &v.CoolnessPeriod)
			delete(rawMsg, key)
		case "creationToken":
			err = unpopulate(val, "CreationToken", &v.CreationToken)
			delete(rawMsg, key)
		case "dataProtection":
			err = unpopulate(val, "DataProtection", &v.DataProtection)
			delete(rawMsg, key)
		case "dataStoreResourceId":
			err = unpopulate(val, "DataStoreResourceID", &v.DataStoreResourceID)
			delete(rawMsg, key)
		case "defaultGroupQuotaInKiBs":
			err = unpopulate(val, "DefaultGroupQuotaInKiBs", &v.DefaultGroupQuotaInKiBs)
			delete(rawMsg, key)
		case "defaultUserQuotaInKiBs":
			err = unpopulate(val, "DefaultUserQuotaInKiBs", &v.DefaultUserQuotaInKiBs)
			delete(rawMsg, key)
		case "deleteBaseSnapshot":
			err = unpopulate(val, "DeleteBaseSnapshot", &v.DeleteBaseSnapshot)
			delete(rawMsg, key)
		case "enableSubvolumes":
			err = unpopulate(val, "EnableSubvolumes", &v.EnableSubvolumes)
			delete(rawMsg, key)
		case "encrypted":
			err = unpopulate(val, "Encrypted", &v.Encrypted)
			delete(rawMsg, key)
		case "encryptionKeySource":
			err = unpopulate(val, "EncryptionKeySource", &v.EncryptionKeySource)
			delete(rawMsg, key)
		case "exportPolicy":
			err = unpopulate(val, "ExportPolicy", &v.ExportPolicy)
			delete(rawMsg, key)
		case "fileAccessLogs":
			err = unpopulate(val, "FileAccessLogs", &v.FileAccessLogs)
			delete(rawMsg, key)
		case "fileSystemId":
			err = unpopulate(val, "FileSystemID", &v.FileSystemID)
			delete(rawMsg, key)
		case "isDefaultQuotaEnabled":
			err = unpopulate(val, "IsDefaultQuotaEnabled", &v.IsDefaultQuotaEnabled)
			delete(rawMsg, key)
		case "isLargeVolume":
			err = unpopulate(val, "IsLargeVolume", &v.IsLargeVolume)
			delete(rawMsg, key)
		case "isRestoring":
			err = unpopulate(val, "IsRestoring", &v.IsRestoring)
			delete(rawMsg, key)
		case "kerberosEnabled":
			err = unpopulate(val, "KerberosEnabled", &v.KerberosEnabled)
			delete(rawMsg, key)
		case "keyVaultPrivateEndpointResourceId":
			err = unpopulate(val, "KeyVaultPrivateEndpointResourceID", &v.KeyVaultPrivateEndpointResourceID)
			delete(rawMsg, key)
		case "ldapEnabled":
			err = unpopulate(val, "LdapEnabled", &v.LdapEnabled)
			delete(rawMsg, key)
		case "maximumNumberOfFiles":
			err = unpopulate(val, "MaximumNumberOfFiles", &v.MaximumNumberOfFiles)
			delete(rawMsg, key)
		case "mountTargets":
			err = unpopulate(val, "MountTargets", &v.MountTargets)
			delete(rawMsg, key)
		case "networkFeatures":
			err = unpopulate(val, "NetworkFeatures", &v.NetworkFeatures)
			delete(rawMsg, key)
		case "networkSiblingSetId":
			err = unpopulate(val, "NetworkSiblingSetID", &v.NetworkSiblingSetID)
			delete(rawMsg, key)
		case "originatingResourceId":
			err = unpopulate(val, "OriginatingResourceID", &v.OriginatingResourceID)
			delete(rawMsg, key)
		case "placementRules":
			err = unpopulate(val, "PlacementRules", &v.PlacementRules)
			delete(rawMsg, key)
		case "protocolTypes":
			err = unpopulate(val, "ProtocolTypes", &v.ProtocolTypes)
			delete(rawMsg, key)
		case "provisionedAvailabilityZone":
			err = unpopulate(val, "ProvisionedAvailabilityZone", &v.ProvisionedAvailabilityZone)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "proximityPlacementGroup":
			err = unpopulate(val, "ProximityPlacementGroup", &v.ProximityPlacementGroup)
			delete(rawMsg, key)
		case "securityStyle":
			err = unpopulate(val, "SecurityStyle", &v.SecurityStyle)
			delete(rawMsg, key)
		case "serviceLevel":
			err = unpopulate(val, "ServiceLevel", &v.ServiceLevel)
			delete(rawMsg, key)
		case "smbAccessBasedEnumeration":
			err = unpopulate(val, "SmbAccessBasedEnumeration", &v.SmbAccessBasedEnumeration)
			delete(rawMsg, key)
		case "smbContinuouslyAvailable":
			err = unpopulate(val, "SmbContinuouslyAvailable", &v.SmbContinuouslyAvailable)
			delete(rawMsg, key)
		case "smbEncryption":
			err = unpopulate(val, "SmbEncryption", &v.SmbEncryption)
			delete(rawMsg, key)
		case "smbNonBrowsable":
			err = unpopulate(val, "SmbNonBrowsable", &v.SmbNonBrowsable)
			delete(rawMsg, key)
		case "snapshotDirectoryVisible":
			err = unpopulate(val, "SnapshotDirectoryVisible", &v.SnapshotDirectoryVisible)
			delete(rawMsg, key)
		case "snapshotId":
			err = unpopulate(val, "SnapshotID", &v.SnapshotID)
			delete(rawMsg, key)
		case "storageToNetworkProximity":
			err = unpopulate(val, "StorageToNetworkProximity", &v.StorageToNetworkProximity)
			delete(rawMsg, key)
		case "subnetId":
			err = unpopulate(val, "SubnetID", &v.SubnetID)
			delete(rawMsg, key)
		case "t2Network":
			err = unpopulate(val, "T2Network", &v.T2Network)
			delete(rawMsg, key)
		case "throughputMibps":
			err = unpopulate(val, "ThroughputMibps", &v.ThroughputMibps)
			delete(rawMsg, key)
		case "unixPermissions":
			err = unpopulate(val, "UnixPermissions", &v.UnixPermissions)
			delete(rawMsg, key)
		case "usageThreshold":
			err = unpopulate(val, "UsageThreshold", &v.UsageThreshold)
			delete(rawMsg, key)
		case "volumeGroupName":
			err = unpopulate(val, "VolumeGroupName", &v.VolumeGroupName)
			delete(rawMsg, key)
		case "volumeSpecName":
			err = unpopulate(val, "VolumeSpecName", &v.VolumeSpecName)
			delete(rawMsg, key)
		case "volumeType":
			err = unpopulate(val, "VolumeType", &v.VolumeType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VolumePropertiesDataProtection.
func (v VolumePropertiesDataProtection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "replication", v.Replication)
	populate(objectMap, "snapshot", v.Snapshot)
	populate(objectMap, "volumeRelocation", v.VolumeRelocation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VolumePropertiesDataProtection.
func (v *VolumePropertiesDataProtection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "replication":
			err = unpopulate(val, "Replication", &v.Replication)
			delete(rawMsg, key)
		case "snapshot":
			err = unpopulate(val, "Snapshot", &v.Snapshot)
			delete(rawMsg, key)
		case "volumeRelocation":
			err = unpopulate(val, "VolumeRelocation", &v.VolumeRelocation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VolumePropertiesExportPolicy.
func (v VolumePropertiesExportPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "rules", v.Rules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VolumePropertiesExportPolicy.
func (v *VolumePropertiesExportPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "rules":
			err = unpopulate(val, "Rules", &v.Rules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VolumeQuotaRule.
func (v VolumeQuotaRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "systemData", v.SystemData)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VolumeQuotaRule.
func (v *VolumeQuotaRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &v.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VolumeQuotaRulePatch.
func (v VolumeQuotaRulePatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "tags", v.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VolumeQuotaRulePatch.
func (v *VolumeQuotaRulePatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VolumeQuotaRulesList.
func (v VolumeQuotaRulesList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VolumeQuotaRulesList.
func (v *VolumeQuotaRulesList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VolumeQuotaRulesProperties.
func (v VolumeQuotaRulesProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "quotaSizeInKiBs", v.QuotaSizeInKiBs)
	populate(objectMap, "quotaTarget", v.QuotaTarget)
	populate(objectMap, "quotaType", v.QuotaType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VolumeQuotaRulesProperties.
func (v *VolumeQuotaRulesProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "quotaSizeInKiBs":
			err = unpopulate(val, "QuotaSizeInKiBs", &v.QuotaSizeInKiBs)
			delete(rawMsg, key)
		case "quotaTarget":
			err = unpopulate(val, "QuotaTarget", &v.QuotaTarget)
			delete(rawMsg, key)
		case "quotaType":
			err = unpopulate(val, "QuotaType", &v.QuotaType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VolumeRelocationProperties.
func (v VolumeRelocationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "readyToBeFinalized", v.ReadyToBeFinalized)
	populate(objectMap, "relocationRequested", v.RelocationRequested)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VolumeRelocationProperties.
func (v *VolumeRelocationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "readyToBeFinalized":
			err = unpopulate(val, "ReadyToBeFinalized", &v.ReadyToBeFinalized)
			delete(rawMsg, key)
		case "relocationRequested":
			err = unpopulate(val, "RelocationRequested", &v.RelocationRequested)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VolumeRevert.
func (v VolumeRevert) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "snapshotId", v.SnapshotID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VolumeRevert.
func (v *VolumeRevert) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "snapshotId":
			err = unpopulate(val, "SnapshotID", &v.SnapshotID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VolumeSnapshotProperties.
func (v VolumeSnapshotProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "snapshotPolicyId", v.SnapshotPolicyID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VolumeSnapshotProperties.
func (v *VolumeSnapshotProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "snapshotPolicyId":
			err = unpopulate(val, "SnapshotPolicyID", &v.SnapshotPolicyID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WeeklySchedule.
func (w WeeklySchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "day", w.Day)
	populate(objectMap, "hour", w.Hour)
	populate(objectMap, "minute", w.Minute)
	populate(objectMap, "snapshotsToKeep", w.SnapshotsToKeep)
	populate(objectMap, "usedBytes", w.UsedBytes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WeeklySchedule.
func (w *WeeklySchedule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "day":
			err = unpopulate(val, "Day", &w.Day)
			delete(rawMsg, key)
		case "hour":
			err = unpopulate(val, "Hour", &w.Hour)
			delete(rawMsg, key)
		case "minute":
			err = unpopulate(val, "Minute", &w.Minute)
			delete(rawMsg, key)
		case "snapshotsToKeep":
			err = unpopulate(val, "SnapshotsToKeep", &w.SnapshotsToKeep)
			delete(rawMsg, key)
		case "usedBytes":
			err = unpopulate(val, "UsedBytes", &w.UsedBytes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil || string(data) == "null" {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
