//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/mobilenetwork/armmobilenetwork/v4"
	"net/http"
	"net/url"
	"regexp"
)

// PacketCapturesServer is a fake server for instances of the armmobilenetwork.PacketCapturesClient type.
type PacketCapturesServer struct {
	// BeginCreateOrUpdate is the fake for method PacketCapturesClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, packetCoreControlPlaneName string, packetCaptureName string, parameters armmobilenetwork.PacketCapture, options *armmobilenetwork.PacketCapturesClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armmobilenetwork.PacketCapturesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method PacketCapturesClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, packetCoreControlPlaneName string, packetCaptureName string, options *armmobilenetwork.PacketCapturesClientBeginDeleteOptions) (resp azfake.PollerResponder[armmobilenetwork.PacketCapturesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method PacketCapturesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, packetCoreControlPlaneName string, packetCaptureName string, options *armmobilenetwork.PacketCapturesClientGetOptions) (resp azfake.Responder[armmobilenetwork.PacketCapturesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByPacketCoreControlPlanePager is the fake for method PacketCapturesClient.NewListByPacketCoreControlPlanePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByPacketCoreControlPlanePager func(resourceGroupName string, packetCoreControlPlaneName string, options *armmobilenetwork.PacketCapturesClientListByPacketCoreControlPlaneOptions) (resp azfake.PagerResponder[armmobilenetwork.PacketCapturesClientListByPacketCoreControlPlaneResponse])

	// BeginStop is the fake for method PacketCapturesClient.BeginStop
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginStop func(ctx context.Context, resourceGroupName string, packetCoreControlPlaneName string, packetCaptureName string, options *armmobilenetwork.PacketCapturesClientBeginStopOptions) (resp azfake.PollerResponder[armmobilenetwork.PacketCapturesClientStopResponse], errResp azfake.ErrorResponder)
}

// NewPacketCapturesServerTransport creates a new instance of PacketCapturesServerTransport with the provided implementation.
// The returned PacketCapturesServerTransport instance is connected to an instance of armmobilenetwork.PacketCapturesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPacketCapturesServerTransport(srv *PacketCapturesServer) *PacketCapturesServerTransport {
	return &PacketCapturesServerTransport{
		srv:                                  srv,
		beginCreateOrUpdate:                  newTracker[azfake.PollerResponder[armmobilenetwork.PacketCapturesClientCreateOrUpdateResponse]](),
		beginDelete:                          newTracker[azfake.PollerResponder[armmobilenetwork.PacketCapturesClientDeleteResponse]](),
		newListByPacketCoreControlPlanePager: newTracker[azfake.PagerResponder[armmobilenetwork.PacketCapturesClientListByPacketCoreControlPlaneResponse]](),
		beginStop:                            newTracker[azfake.PollerResponder[armmobilenetwork.PacketCapturesClientStopResponse]](),
	}
}

// PacketCapturesServerTransport connects instances of armmobilenetwork.PacketCapturesClient to instances of PacketCapturesServer.
// Don't use this type directly, use NewPacketCapturesServerTransport instead.
type PacketCapturesServerTransport struct {
	srv                                  *PacketCapturesServer
	beginCreateOrUpdate                  *tracker[azfake.PollerResponder[armmobilenetwork.PacketCapturesClientCreateOrUpdateResponse]]
	beginDelete                          *tracker[azfake.PollerResponder[armmobilenetwork.PacketCapturesClientDeleteResponse]]
	newListByPacketCoreControlPlanePager *tracker[azfake.PagerResponder[armmobilenetwork.PacketCapturesClientListByPacketCoreControlPlaneResponse]]
	beginStop                            *tracker[azfake.PollerResponder[armmobilenetwork.PacketCapturesClientStopResponse]]
}

// Do implements the policy.Transporter interface for PacketCapturesServerTransport.
func (p *PacketCapturesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PacketCapturesClient.BeginCreateOrUpdate":
		resp, err = p.dispatchBeginCreateOrUpdate(req)
	case "PacketCapturesClient.BeginDelete":
		resp, err = p.dispatchBeginDelete(req)
	case "PacketCapturesClient.Get":
		resp, err = p.dispatchGet(req)
	case "PacketCapturesClient.NewListByPacketCoreControlPlanePager":
		resp, err = p.dispatchNewListByPacketCoreControlPlanePager(req)
	case "PacketCapturesClient.BeginStop":
		resp, err = p.dispatchBeginStop(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PacketCapturesServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if p.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := p.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.MobileNetwork/packetCoreControlPlanes/(?P<packetCoreControlPlaneName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/packetCaptures/(?P<packetCaptureName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmobilenetwork.PacketCapture](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		packetCoreControlPlaneNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("packetCoreControlPlaneName")])
		if err != nil {
			return nil, err
		}
		packetCaptureNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("packetCaptureName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, packetCoreControlPlaneNameParam, packetCaptureNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		p.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		p.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		p.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (p *PacketCapturesServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if p.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := p.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.MobileNetwork/packetCoreControlPlanes/(?P<packetCoreControlPlaneName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/packetCaptures/(?P<packetCaptureName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		packetCoreControlPlaneNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("packetCoreControlPlaneName")])
		if err != nil {
			return nil, err
		}
		packetCaptureNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("packetCaptureName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginDelete(req.Context(), resourceGroupNameParam, packetCoreControlPlaneNameParam, packetCaptureNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		p.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		p.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		p.beginDelete.remove(req)
	}

	return resp, nil
}

func (p *PacketCapturesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if p.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.MobileNetwork/packetCoreControlPlanes/(?P<packetCoreControlPlaneName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/packetCaptures/(?P<packetCaptureName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	packetCoreControlPlaneNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("packetCoreControlPlaneName")])
	if err != nil {
		return nil, err
	}
	packetCaptureNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("packetCaptureName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Get(req.Context(), resourceGroupNameParam, packetCoreControlPlaneNameParam, packetCaptureNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PacketCapture, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PacketCapturesServerTransport) dispatchNewListByPacketCoreControlPlanePager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListByPacketCoreControlPlanePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByPacketCoreControlPlanePager not implemented")}
	}
	newListByPacketCoreControlPlanePager := p.newListByPacketCoreControlPlanePager.get(req)
	if newListByPacketCoreControlPlanePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.MobileNetwork/packetCoreControlPlanes/(?P<packetCoreControlPlaneName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/packetCaptures`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		packetCoreControlPlaneNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("packetCoreControlPlaneName")])
		if err != nil {
			return nil, err
		}
		resp := p.srv.NewListByPacketCoreControlPlanePager(resourceGroupNameParam, packetCoreControlPlaneNameParam, nil)
		newListByPacketCoreControlPlanePager = &resp
		p.newListByPacketCoreControlPlanePager.add(req, newListByPacketCoreControlPlanePager)
		server.PagerResponderInjectNextLinks(newListByPacketCoreControlPlanePager, req, func(page *armmobilenetwork.PacketCapturesClientListByPacketCoreControlPlaneResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByPacketCoreControlPlanePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListByPacketCoreControlPlanePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByPacketCoreControlPlanePager) {
		p.newListByPacketCoreControlPlanePager.remove(req)
	}
	return resp, nil
}

func (p *PacketCapturesServerTransport) dispatchBeginStop(req *http.Request) (*http.Response, error) {
	if p.srv.BeginStop == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginStop not implemented")}
	}
	beginStop := p.beginStop.get(req)
	if beginStop == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.MobileNetwork/packetCoreControlPlanes/(?P<packetCoreControlPlaneName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/packetCaptures/(?P<packetCaptureName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/stop`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		packetCoreControlPlaneNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("packetCoreControlPlaneName")])
		if err != nil {
			return nil, err
		}
		packetCaptureNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("packetCaptureName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginStop(req.Context(), resourceGroupNameParam, packetCoreControlPlaneNameParam, packetCaptureNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginStop = &respr
		p.beginStop.add(req, beginStop)
	}

	resp, err := server.PollerResponderNext(beginStop, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		p.beginStop.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginStop) {
		p.beginStop.remove(req)
	}

	return resp, nil
}
