//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmigrationdiscoverysap

import "encoding/json"

func unmarshalPerformanceDataClassification(rawMsg json.RawMessage) (PerformanceDataClassification, error) {
	if rawMsg == nil || string(rawMsg) == "null" {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b PerformanceDataClassification
	switch m["dataSource"] {
	case string(DataSourceExcel):
		b = &ExcelPerformanceData{}
	case string(DataSourceNative):
		b = &NativePerformanceData{}
	default:
		b = &PerformanceData{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}
