//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/migrationdiscovery/armmigrationdiscoverysap"
	"net/http"
	"net/url"
	"regexp"
)

// ServerInstancesServer is a fake server for instances of the armmigrationdiscoverysap.ServerInstancesClient type.
type ServerInstancesServer struct {
	// BeginCreate is the fake for method ServerInstancesClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreate func(ctx context.Context, resourceGroupName string, sapDiscoverySiteName string, sapInstanceName string, serverInstanceName string, resource armmigrationdiscoverysap.ServerInstance, options *armmigrationdiscoverysap.ServerInstancesClientBeginCreateOptions) (resp azfake.PollerResponder[armmigrationdiscoverysap.ServerInstancesClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method ServerInstancesClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, sapDiscoverySiteName string, sapInstanceName string, serverInstanceName string, options *armmigrationdiscoverysap.ServerInstancesClientBeginDeleteOptions) (resp azfake.PollerResponder[armmigrationdiscoverysap.ServerInstancesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ServerInstancesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, sapDiscoverySiteName string, sapInstanceName string, serverInstanceName string, options *armmigrationdiscoverysap.ServerInstancesClientGetOptions) (resp azfake.Responder[armmigrationdiscoverysap.ServerInstancesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListBySapInstancePager is the fake for method ServerInstancesClient.NewListBySapInstancePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySapInstancePager func(resourceGroupName string, sapDiscoverySiteName string, sapInstanceName string, options *armmigrationdiscoverysap.ServerInstancesClientListBySapInstanceOptions) (resp azfake.PagerResponder[armmigrationdiscoverysap.ServerInstancesClientListBySapInstanceResponse])

	// Update is the fake for method ServerInstancesClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, resourceGroupName string, sapDiscoverySiteName string, sapInstanceName string, serverInstanceName string, properties armmigrationdiscoverysap.UpdateServerInstanceRequest, options *armmigrationdiscoverysap.ServerInstancesClientUpdateOptions) (resp azfake.Responder[armmigrationdiscoverysap.ServerInstancesClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewServerInstancesServerTransport creates a new instance of ServerInstancesServerTransport with the provided implementation.
// The returned ServerInstancesServerTransport instance is connected to an instance of armmigrationdiscoverysap.ServerInstancesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerInstancesServerTransport(srv *ServerInstancesServer) *ServerInstancesServerTransport {
	return &ServerInstancesServerTransport{
		srv:                       srv,
		beginCreate:               newTracker[azfake.PollerResponder[armmigrationdiscoverysap.ServerInstancesClientCreateResponse]](),
		beginDelete:               newTracker[azfake.PollerResponder[armmigrationdiscoverysap.ServerInstancesClientDeleteResponse]](),
		newListBySapInstancePager: newTracker[azfake.PagerResponder[armmigrationdiscoverysap.ServerInstancesClientListBySapInstanceResponse]](),
	}
}

// ServerInstancesServerTransport connects instances of armmigrationdiscoverysap.ServerInstancesClient to instances of ServerInstancesServer.
// Don't use this type directly, use NewServerInstancesServerTransport instead.
type ServerInstancesServerTransport struct {
	srv                       *ServerInstancesServer
	beginCreate               *tracker[azfake.PollerResponder[armmigrationdiscoverysap.ServerInstancesClientCreateResponse]]
	beginDelete               *tracker[azfake.PollerResponder[armmigrationdiscoverysap.ServerInstancesClientDeleteResponse]]
	newListBySapInstancePager *tracker[azfake.PagerResponder[armmigrationdiscoverysap.ServerInstancesClientListBySapInstanceResponse]]
}

// Do implements the policy.Transporter interface for ServerInstancesServerTransport.
func (s *ServerInstancesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ServerInstancesClient.BeginCreate":
		resp, err = s.dispatchBeginCreate(req)
	case "ServerInstancesClient.BeginDelete":
		resp, err = s.dispatchBeginDelete(req)
	case "ServerInstancesClient.Get":
		resp, err = s.dispatchGet(req)
	case "ServerInstancesClient.NewListBySapInstancePager":
		resp, err = s.dispatchNewListBySapInstancePager(req)
	case "ServerInstancesClient.Update":
		resp, err = s.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *ServerInstancesServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if s.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := s.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Workloads/sapDiscoverySites/(?P<sapDiscoverySiteName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sapInstances/(?P<sapInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/serverInstances/(?P<serverInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmigrationdiscoverysap.ServerInstance](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		sapDiscoverySiteNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sapDiscoverySiteName")])
		if err != nil {
			return nil, err
		}
		sapInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sapInstanceName")])
		if err != nil {
			return nil, err
		}
		serverInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverInstanceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginCreate(req.Context(), resourceGroupNameParam, sapDiscoverySiteNameParam, sapInstanceNameParam, serverInstanceNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		s.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		s.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		s.beginCreate.remove(req)
	}

	return resp, nil
}

func (s *ServerInstancesServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if s.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := s.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Workloads/sapDiscoverySites/(?P<sapDiscoverySiteName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sapInstances/(?P<sapInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/serverInstances/(?P<serverInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		sapDiscoverySiteNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sapDiscoverySiteName")])
		if err != nil {
			return nil, err
		}
		sapInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sapInstanceName")])
		if err != nil {
			return nil, err
		}
		serverInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverInstanceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginDelete(req.Context(), resourceGroupNameParam, sapDiscoverySiteNameParam, sapInstanceNameParam, serverInstanceNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		s.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		s.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		s.beginDelete.remove(req)
	}

	return resp, nil
}

func (s *ServerInstancesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Workloads/sapDiscoverySites/(?P<sapDiscoverySiteName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sapInstances/(?P<sapInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/serverInstances/(?P<serverInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	sapDiscoverySiteNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sapDiscoverySiteName")])
	if err != nil {
		return nil, err
	}
	sapInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sapInstanceName")])
	if err != nil {
		return nil, err
	}
	serverInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverInstanceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), resourceGroupNameParam, sapDiscoverySiteNameParam, sapInstanceNameParam, serverInstanceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ServerInstance, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ServerInstancesServerTransport) dispatchNewListBySapInstancePager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListBySapInstancePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySapInstancePager not implemented")}
	}
	newListBySapInstancePager := s.newListBySapInstancePager.get(req)
	if newListBySapInstancePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Workloads/sapDiscoverySites/(?P<sapDiscoverySiteName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sapInstances/(?P<sapInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/serverInstances`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		sapDiscoverySiteNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sapDiscoverySiteName")])
		if err != nil {
			return nil, err
		}
		sapInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sapInstanceName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListBySapInstancePager(resourceGroupNameParam, sapDiscoverySiteNameParam, sapInstanceNameParam, nil)
		newListBySapInstancePager = &resp
		s.newListBySapInstancePager.add(req, newListBySapInstancePager)
		server.PagerResponderInjectNextLinks(newListBySapInstancePager, req, func(page *armmigrationdiscoverysap.ServerInstancesClientListBySapInstanceResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySapInstancePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListBySapInstancePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySapInstancePager) {
		s.newListBySapInstancePager.remove(req)
	}
	return resp, nil
}

func (s *ServerInstancesServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if s.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Workloads/sapDiscoverySites/(?P<sapDiscoverySiteName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sapInstances/(?P<sapInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/serverInstances/(?P<serverInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armmigrationdiscoverysap.UpdateServerInstanceRequest](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	sapDiscoverySiteNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sapDiscoverySiteName")])
	if err != nil {
		return nil, err
	}
	sapInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sapInstanceName")])
	if err != nil {
		return nil, err
	}
	serverInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverInstanceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Update(req.Context(), resourceGroupNameParam, sapDiscoverySiteNameParam, sapInstanceNameParam, serverInstanceNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ServerInstance, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
