//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/mediaservices/armmediaservices/v3"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// AssetTrackOperationResultsServer is a fake server for instances of the armmediaservices.AssetTrackOperationResultsClient type.
type AssetTrackOperationResultsServer struct {
	// Get is the fake for method AssetTrackOperationResultsClient.Get
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	Get func(ctx context.Context, resourceGroupName string, accountName string, assetName string, trackName string, operationID string, options *armmediaservices.AssetTrackOperationResultsClientGetOptions) (resp azfake.Responder[armmediaservices.AssetTrackOperationResultsClientGetResponse], errResp azfake.ErrorResponder)
}

// NewAssetTrackOperationResultsServerTransport creates a new instance of AssetTrackOperationResultsServerTransport with the provided implementation.
// The returned AssetTrackOperationResultsServerTransport instance is connected to an instance of armmediaservices.AssetTrackOperationResultsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAssetTrackOperationResultsServerTransport(srv *AssetTrackOperationResultsServer) *AssetTrackOperationResultsServerTransport {
	return &AssetTrackOperationResultsServerTransport{srv: srv}
}

// AssetTrackOperationResultsServerTransport connects instances of armmediaservices.AssetTrackOperationResultsClient to instances of AssetTrackOperationResultsServer.
// Don't use this type directly, use NewAssetTrackOperationResultsServerTransport instead.
type AssetTrackOperationResultsServerTransport struct {
	srv *AssetTrackOperationResultsServer
}

// Do implements the policy.Transporter interface for AssetTrackOperationResultsServerTransport.
func (a *AssetTrackOperationResultsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AssetTrackOperationResultsClient.Get":
		resp, err = a.dispatchGet(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AssetTrackOperationResultsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if a.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Media/mediaServices/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/assets/(?P<assetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tracks/(?P<trackName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/operationResults/(?P<operationId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	assetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("assetName")])
	if err != nil {
		return nil, err
	}
	trackNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("trackName")])
	if err != nil {
		return nil, err
	}
	operationIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("operationId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Get(req.Context(), resourceGroupNameParam, accountNameParam, assetNameParam, trackNameParam, operationIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AssetTrack, req)
	if err != nil {
		return nil, err
	}
	if val := server.GetResponse(respr).AzureAsyncOperation; val != nil {
		resp.Header.Set("Azure-AsyncOperation", *val)
	}
	if val := server.GetResponse(respr).Location; val != nil {
		resp.Header.Set("Location", *val)
	}
	if val := server.GetResponse(respr).RetryAfter; val != nil {
		resp.Header.Set("Retry-After", strconv.FormatInt(int64(*val), 10))
	}
	return resp, nil
}
