//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/integrationspaces/armintegrationspaces"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// BusinessProcessesServer is a fake server for instances of the armintegrationspaces.BusinessProcessesClient type.
type BusinessProcessesServer struct {
	// CreateOrUpdate is the fake for method BusinessProcessesClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, spaceName string, applicationName string, businessProcessName string, resource armintegrationspaces.BusinessProcess, options *armintegrationspaces.BusinessProcessesClientCreateOrUpdateOptions) (resp azfake.Responder[armintegrationspaces.BusinessProcessesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method BusinessProcessesClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, spaceName string, applicationName string, businessProcessName string, options *armintegrationspaces.BusinessProcessesClientDeleteOptions) (resp azfake.Responder[armintegrationspaces.BusinessProcessesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method BusinessProcessesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, spaceName string, applicationName string, businessProcessName string, options *armintegrationspaces.BusinessProcessesClientGetOptions) (resp azfake.Responder[armintegrationspaces.BusinessProcessesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByApplicationPager is the fake for method BusinessProcessesClient.NewListByApplicationPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByApplicationPager func(resourceGroupName string, spaceName string, applicationName string, options *armintegrationspaces.BusinessProcessesClientListByApplicationOptions) (resp azfake.PagerResponder[armintegrationspaces.BusinessProcessesClientListByApplicationResponse])

	// Patch is the fake for method BusinessProcessesClient.Patch
	// HTTP status codes to indicate success: http.StatusOK
	Patch func(ctx context.Context, resourceGroupName string, spaceName string, applicationName string, businessProcessName string, properties armintegrationspaces.BusinessProcessUpdate, options *armintegrationspaces.BusinessProcessesClientPatchOptions) (resp azfake.Responder[armintegrationspaces.BusinessProcessesClientPatchResponse], errResp azfake.ErrorResponder)
}

// NewBusinessProcessesServerTransport creates a new instance of BusinessProcessesServerTransport with the provided implementation.
// The returned BusinessProcessesServerTransport instance is connected to an instance of armintegrationspaces.BusinessProcessesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewBusinessProcessesServerTransport(srv *BusinessProcessesServer) *BusinessProcessesServerTransport {
	return &BusinessProcessesServerTransport{
		srv:                       srv,
		newListByApplicationPager: newTracker[azfake.PagerResponder[armintegrationspaces.BusinessProcessesClientListByApplicationResponse]](),
	}
}

// BusinessProcessesServerTransport connects instances of armintegrationspaces.BusinessProcessesClient to instances of BusinessProcessesServer.
// Don't use this type directly, use NewBusinessProcessesServerTransport instead.
type BusinessProcessesServerTransport struct {
	srv                       *BusinessProcessesServer
	newListByApplicationPager *tracker[azfake.PagerResponder[armintegrationspaces.BusinessProcessesClientListByApplicationResponse]]
}

// Do implements the policy.Transporter interface for BusinessProcessesServerTransport.
func (b *BusinessProcessesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "BusinessProcessesClient.CreateOrUpdate":
		resp, err = b.dispatchCreateOrUpdate(req)
	case "BusinessProcessesClient.Delete":
		resp, err = b.dispatchDelete(req)
	case "BusinessProcessesClient.Get":
		resp, err = b.dispatchGet(req)
	case "BusinessProcessesClient.NewListByApplicationPager":
		resp, err = b.dispatchNewListByApplicationPager(req)
	case "BusinessProcessesClient.Patch":
		resp, err = b.dispatchPatch(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (b *BusinessProcessesServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if b.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IntegrationSpaces/spaces/(?P<spaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/applications/(?P<applicationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/businessProcesses/(?P<businessProcessName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armintegrationspaces.BusinessProcess](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	spaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("spaceName")])
	if err != nil {
		return nil, err
	}
	applicationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("applicationName")])
	if err != nil {
		return nil, err
	}
	businessProcessNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("businessProcessName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := b.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, spaceNameParam, applicationNameParam, businessProcessNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).BusinessProcess, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (b *BusinessProcessesServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if b.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IntegrationSpaces/spaces/(?P<spaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/applications/(?P<applicationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/businessProcesses/(?P<businessProcessName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	spaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("spaceName")])
	if err != nil {
		return nil, err
	}
	applicationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("applicationName")])
	if err != nil {
		return nil, err
	}
	businessProcessNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("businessProcessName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := b.srv.Delete(req.Context(), resourceGroupNameParam, spaceNameParam, applicationNameParam, businessProcessNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (b *BusinessProcessesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if b.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IntegrationSpaces/spaces/(?P<spaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/applications/(?P<applicationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/businessProcesses/(?P<businessProcessName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	spaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("spaceName")])
	if err != nil {
		return nil, err
	}
	applicationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("applicationName")])
	if err != nil {
		return nil, err
	}
	businessProcessNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("businessProcessName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := b.srv.Get(req.Context(), resourceGroupNameParam, spaceNameParam, applicationNameParam, businessProcessNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).BusinessProcess, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (b *BusinessProcessesServerTransport) dispatchNewListByApplicationPager(req *http.Request) (*http.Response, error) {
	if b.srv.NewListByApplicationPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByApplicationPager not implemented")}
	}
	newListByApplicationPager := b.newListByApplicationPager.get(req)
	if newListByApplicationPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IntegrationSpaces/spaces/(?P<spaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/applications/(?P<applicationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/businessProcesses`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		skipUnescaped, err := url.QueryUnescape(qp.Get("skip"))
		if err != nil {
			return nil, err
		}
		skipParam, err := parseOptional(skipUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		maxpagesizeUnescaped, err := url.QueryUnescape(qp.Get("maxpagesize"))
		if err != nil {
			return nil, err
		}
		maxpagesizeParam, err := parseOptional(maxpagesizeUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		selectEscaped := qp["select"]
		selectParam := make([]string, len(selectEscaped))
		for i, v := range selectEscaped {
			u, unescapeErr := url.QueryUnescape(v)
			if unescapeErr != nil {
				return nil, unescapeErr
			}
			selectParam[i] = u
		}
		expandEscaped := qp["expand"]
		expandParam := make([]string, len(expandEscaped))
		for i, v := range expandEscaped {
			u, unescapeErr := url.QueryUnescape(v)
			if unescapeErr != nil {
				return nil, unescapeErr
			}
			expandParam[i] = u
		}
		orderbyEscaped := qp["orderby"]
		orderbyParam := make([]string, len(orderbyEscaped))
		for i, v := range orderbyEscaped {
			u, unescapeErr := url.QueryUnescape(v)
			if unescapeErr != nil {
				return nil, unescapeErr
			}
			orderbyParam[i] = u
		}
		spaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("spaceName")])
		if err != nil {
			return nil, err
		}
		applicationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("applicationName")])
		if err != nil {
			return nil, err
		}
		var options *armintegrationspaces.BusinessProcessesClientListByApplicationOptions
		if topParam != nil || skipParam != nil || maxpagesizeParam != nil || filterParam != nil || len(selectParam) > 0 || len(expandParam) > 0 || len(orderbyParam) > 0 {
			options = &armintegrationspaces.BusinessProcessesClientListByApplicationOptions{
				Top:         topParam,
				Skip:        skipParam,
				Maxpagesize: maxpagesizeParam,
				Filter:      filterParam,
				Select:      selectParam,
				Expand:      expandParam,
				Orderby:     orderbyParam,
			}
		}
		resp := b.srv.NewListByApplicationPager(resourceGroupNameParam, spaceNameParam, applicationNameParam, options)
		newListByApplicationPager = &resp
		b.newListByApplicationPager.add(req, newListByApplicationPager)
		server.PagerResponderInjectNextLinks(newListByApplicationPager, req, func(page *armintegrationspaces.BusinessProcessesClientListByApplicationResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByApplicationPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		b.newListByApplicationPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByApplicationPager) {
		b.newListByApplicationPager.remove(req)
	}
	return resp, nil
}

func (b *BusinessProcessesServerTransport) dispatchPatch(req *http.Request) (*http.Response, error) {
	if b.srv.Patch == nil {
		return nil, &nonRetriableError{errors.New("fake for method Patch not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IntegrationSpaces/spaces/(?P<spaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/applications/(?P<applicationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/businessProcesses/(?P<businessProcessName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armintegrationspaces.BusinessProcessUpdate](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	spaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("spaceName")])
	if err != nil {
		return nil, err
	}
	applicationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("applicationName")])
	if err != nil {
		return nil, err
	}
	businessProcessNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("businessProcessName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := b.srv.Patch(req.Context(), resourceGroupNameParam, spaceNameParam, applicationNameParam, businessProcessNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).BusinessProcess, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
