//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armhdinsightcontainers

import "time"

// AksClusterProfileAksClusterAgentPoolIdentityProfile - Identity properties of the AKS cluster agentpool MSI
type AksClusterProfileAksClusterAgentPoolIdentityProfile struct {
	// REQUIRED; ClientId of the MSI.
	MsiClientID *string

	// REQUIRED; ObjectId of the MSI.
	MsiObjectID *string

	// REQUIRED; ResourceId of the MSI.
	MsiResourceID *string
}

// AuthorizationProfile - Authorization profile with details of AAD user Ids and group Ids authorized for data plane access.
type AuthorizationProfile struct {
	// AAD group Ids authorized for data plane access.
	GroupIDs []*string

	// AAD user Ids authorized for data plane access.
	UserIDs []*string
}

// AutoscaleProfile - This is the Autoscale profile for the cluster. This will allow customer to create cluster enabled with
// Autoscale.
type AutoscaleProfile struct {
	// REQUIRED; This indicates whether auto scale is enabled on HDInsight on AKS cluster.
	Enabled *bool

	// User to specify which type of Autoscale to be implemented - Scheduled Based or Load Based.
	AutoscaleType *AutoscaleType

	// This property is for graceful decommission timeout; It has a default setting of 3600 seconds before forced shutdown takes
	// place. This is the maximal time to wait for running containers and
	// applications to complete before transition a DECOMMISSIONING node into DECOMMISSIONED. The default value is 3600 seconds.
	// Negative value (like -1) is handled as infinite timeout.
	GracefulDecommissionTimeout *int32

	// Profiles of load based Autoscale.
	LoadBasedConfig *LoadBasedConfig

	// Profiles of schedule based Autoscale.
	ScheduleBasedConfig *ScheduleBasedConfig
}

// CatalogOptions - Trino cluster catalog options.
type CatalogOptions struct {
	// hive catalog options.
	Hive []*HiveCatalogOption
}

// Cluster - The cluster.
type Cluster struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Gets or sets the properties. Define cluster specific properties.
	Properties *ClusterResourceProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ClusterAKSPatchVersionUpgradeProperties - Properties of upgrading cluster's AKS patch version.
type ClusterAKSPatchVersionUpgradeProperties struct {
	// REQUIRED; Type of upgrade.
	UpgradeType *ClusterUpgradeType
}

// GetClusterUpgradeProperties implements the ClusterUpgradePropertiesClassification interface for type ClusterAKSPatchVersionUpgradeProperties.
func (c *ClusterAKSPatchVersionUpgradeProperties) GetClusterUpgradeProperties() *ClusterUpgradeProperties {
	return &ClusterUpgradeProperties{
		UpgradeType: c.UpgradeType,
	}
}

// ClusterAccessProfile - Cluster access profile.
type ClusterAccessProfile struct {
	// REQUIRED; Whether to create cluster using private IP instead of public IP. This property must be set at create time.
	EnableInternalIngress *bool

	// READ-ONLY; Private link service resource ID. Only when enableInternalIngress is true, this property will be returned.
	PrivateLinkServiceID *string
}

// ClusterAvailableUpgrade - Cluster available upgrade.
type ClusterAvailableUpgrade struct {
	// Gets or sets the properties. Define cluster upgrade specific properties.
	Properties ClusterAvailableUpgradePropertiesClassification

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ClusterAvailableUpgradeAksPatchUpgradeProperties - Cluster available AKS patch version upgrade.
type ClusterAvailableUpgradeAksPatchUpgradeProperties struct {
	// REQUIRED; Type of upgrade.
	UpgradeType *ClusterAvailableUpgradeType

	// Current node pool version.
	CurrentVersion *string

	// Current AKS version's status: whether it is deprecated or supported
	CurrentVersionStatus *CurrentClusterAksVersionStatus

	// Latest available version, which should be equal to AKS control plane version if it's not deprecated.
	LatestVersion *string
}

// GetClusterAvailableUpgradeProperties implements the ClusterAvailableUpgradePropertiesClassification interface for type
// ClusterAvailableUpgradeAksPatchUpgradeProperties.
func (c *ClusterAvailableUpgradeAksPatchUpgradeProperties) GetClusterAvailableUpgradeProperties() *ClusterAvailableUpgradeProperties {
	return &ClusterAvailableUpgradeProperties{
		UpgradeType: c.UpgradeType,
	}
}

// ClusterAvailableUpgradeHotfixUpgradeProperties - Cluster available hotfix version upgrade.
type ClusterAvailableUpgradeHotfixUpgradeProperties struct {
	// REQUIRED; Type of upgrade.
	UpgradeType *ClusterAvailableUpgradeType

	// Name of component to be upgraded.
	ComponentName *string

	// Created time of current available upgrade version
	CreatedTime *time.Time

	// Hotfix version upgrade description.
	Description *string

	// Extended properties of current available upgrade version
	ExtendedProperties *string

	// Severity of this upgrade.
	Severity *Severity

	// Source build number of current cluster component.
	SourceBuildNumber *string

	// Source cluster version of current cluster component.
	SourceClusterVersion *string

	// Source OSS version of current cluster component.
	SourceOssVersion *string

	// Target build number of component to be upgraded.
	TargetBuildNumber *string

	// Target cluster version of component to be upgraded.
	TargetClusterVersion *string

	// Target OSS version of component to be upgraded.
	TargetOssVersion *string
}

// GetClusterAvailableUpgradeProperties implements the ClusterAvailableUpgradePropertiesClassification interface for type
// ClusterAvailableUpgradeHotfixUpgradeProperties.
func (c *ClusterAvailableUpgradeHotfixUpgradeProperties) GetClusterAvailableUpgradeProperties() *ClusterAvailableUpgradeProperties {
	return &ClusterAvailableUpgradeProperties{
		UpgradeType: c.UpgradeType,
	}
}

// ClusterAvailableUpgradeList - Collection of cluster available upgrade.
type ClusterAvailableUpgradeList struct {
	// REQUIRED; Collection of Cluster available upgrade.
	Value []*ClusterAvailableUpgrade

	// The URL of next result page.
	NextLink *string
}

// ClusterAvailableUpgradeProperties - Cluster available upgrade properties.
type ClusterAvailableUpgradeProperties struct {
	// REQUIRED; Type of upgrade.
	UpgradeType *ClusterAvailableUpgradeType
}

// GetClusterAvailableUpgradeProperties implements the ClusterAvailableUpgradePropertiesClassification interface for type
// ClusterAvailableUpgradeProperties.
func (c *ClusterAvailableUpgradeProperties) GetClusterAvailableUpgradeProperties() *ClusterAvailableUpgradeProperties {
	return c
}

type ClusterComponentsItem struct {
	Name    *string
	Version *string
}

// ClusterConfigFile - Cluster configuration files.
type ClusterConfigFile struct {
	// REQUIRED; Configuration file name.
	FileName *string

	// Free form content of the entire configuration file.
	Content *string

	// This property indicates if the content is encoded and is case-insensitive. Please set the value to base64 if the content
	// is base64 encoded. Set it to none or skip it if the content is plain text.
	Encoding *ContentEncoding

	// Path of the config file if content is specified.
	Path *string

	// List of key value pairs where key represents a valid service configuration name and value represents the value of the config.
	Values map[string]*string
}

// ClusterHotfixUpgradeProperties - Properties of upgrading cluster's hotfix.
type ClusterHotfixUpgradeProperties struct {
	// REQUIRED; Type of upgrade.
	UpgradeType *ClusterUpgradeType

	// Name of component to be upgraded.
	ComponentName *string

	// Target build number of component to be upgraded.
	TargetBuildNumber *string

	// Target cluster version of component to be upgraded.
	TargetClusterVersion *string

	// Target OSS version of component to be upgraded.
	TargetOssVersion *string
}

// GetClusterUpgradeProperties implements the ClusterUpgradePropertiesClassification interface for type ClusterHotfixUpgradeProperties.
func (c *ClusterHotfixUpgradeProperties) GetClusterUpgradeProperties() *ClusterUpgradeProperties {
	return &ClusterUpgradeProperties{
		UpgradeType: c.UpgradeType,
	}
}

// ClusterInstanceViewPropertiesStatus - Status of the instance view.
type ClusterInstanceViewPropertiesStatus struct {
	// REQUIRED; The cluster ready status
	Ready *string

	// The additional message.
	Message *string

	// The status reason.
	Reason *string
}

// ClusterInstanceViewResult - Cluster Instance View.
type ClusterInstanceViewResult struct {
	// REQUIRED; Name of the instance view.
	Name *string

	// REQUIRED; Properties of the instance view.
	Properties *ClusterInstanceViewResultProperties
}

// ClusterInstanceViewResultProperties - Properties of the instance view.
type ClusterInstanceViewResultProperties struct {
	// REQUIRED; List of statuses of relevant services that make up the HDInsight on AKS cluster to surface to the customer.
	ServiceStatuses []*ServiceStatus

	// REQUIRED; Status of the instance view.
	Status *ClusterInstanceViewPropertiesStatus
}

// ClusterInstanceViewsResult - The instance view of a HDInsight Cluster.
type ClusterInstanceViewsResult struct {
	// Cluster instance view array.
	Value []*ClusterInstanceViewResult

	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string
}

// ClusterJob - Cluster job.
type ClusterJob struct {
	// REQUIRED; Properties of cluster job.
	Properties ClusterJobPropertiesClassification

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ClusterJobList - Collection of cluster job.
type ClusterJobList struct {
	// REQUIRED; Collection of cluster job.
	Value []*ClusterJob

	// The Url of next result page.
	NextLink *string
}

// ClusterJobProperties - Properties of cluster job.
type ClusterJobProperties struct {
	// REQUIRED; Type of cluster job.
	JobType *JobType
}

// GetClusterJobProperties implements the ClusterJobPropertiesClassification interface for type ClusterJobProperties.
func (c *ClusterJobProperties) GetClusterJobProperties() *ClusterJobProperties { return c }

// ClusterListResult - The list cluster operation response.
type ClusterListResult struct {
	// The list of clusters.
	Value []*Cluster

	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string
}

// ClusterLogAnalyticsApplicationLogs - Collection of logs to be enabled or disabled for log analytics.
type ClusterLogAnalyticsApplicationLogs struct {
	// True if stderror is enabled, otherwise false.
	StdErrorEnabled *bool

	// True if stdout is enabled, otherwise false.
	StdOutEnabled *bool
}

// ClusterLogAnalyticsProfile - Cluster log analytics profile to enable or disable OMS agent for cluster.
type ClusterLogAnalyticsProfile struct {
	// REQUIRED; True if log analytics is enabled for the cluster, otherwise false.
	Enabled *bool

	// Collection of logs to be enabled or disabled for log analytics.
	ApplicationLogs *ClusterLogAnalyticsApplicationLogs

	// True if metrics are enabled, otherwise false.
	MetricsEnabled *bool
}

// ClusterPatch - The patch for a cluster.
type ClusterPatch struct {
	// Define cluster patch specific properties.
	Properties *ClusterPatchProperties

	// Resource tags.
	Tags map[string]*string
}

// ClusterPatchProperties - Cluster resource patch data.
type ClusterPatchProperties struct {
	// Cluster resource patch properties.
	ClusterProfile *UpdatableClusterProfile
}

// ClusterPool - Cluster pool.
type ClusterPool struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Gets or sets the properties. Define cluster pool specific properties.
	Properties *ClusterPoolResourceProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ClusterPoolAKSPatchVersionUpgradeProperties - Properties of upgrading cluster pool's AKS patch version.
type ClusterPoolAKSPatchVersionUpgradeProperties struct {
	// REQUIRED; Type of upgrade.
	UpgradeType *ClusterPoolUpgradeType

	// Target AKS version. When it's not set, latest version will be used. When upgradeClusterPool is true and upgradeAllClusterNodes
	// is false, target version should be greater or equal to current version.
	// When upgradeClusterPool is false and upgradeAllClusterNodes is true, target version should be equal to AKS version of cluster
	// pool.
	TargetAksVersion *string

	// whether upgrade all clusters' nodes. If it's true, upgradeClusterPool should be false.
	UpgradeAllClusterNodes *bool

	// whether upgrade cluster pool or not. If it's true, upgradeAllClusterNodes should be false.
	UpgradeClusterPool *bool
}

// GetClusterPoolUpgradeProperties implements the ClusterPoolUpgradePropertiesClassification interface for type ClusterPoolAKSPatchVersionUpgradeProperties.
func (c *ClusterPoolAKSPatchVersionUpgradeProperties) GetClusterPoolUpgradeProperties() *ClusterPoolUpgradeProperties {
	return &ClusterPoolUpgradeProperties{
		UpgradeType: c.UpgradeType,
	}
}

// ClusterPoolAvailableUpgrade - Cluster pool available upgrade.
type ClusterPoolAvailableUpgrade struct {
	// Gets or sets the properties. Define cluster pool upgrade specific properties.
	Properties ClusterPoolAvailableUpgradePropertiesClassification

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ClusterPoolAvailableUpgradeAksPatchUpgradeProperties - Cluster pool available AKS patch version upgrade.
type ClusterPoolAvailableUpgradeAksPatchUpgradeProperties struct {
	// REQUIRED; Type of upgrade.
	UpgradeType *ClusterPoolAvailableUpgradeType

	// Current AKS version.
	CurrentVersion *string

	// Current AKS version's status: whether it is deprecated or supported
	CurrentVersionStatus *CurrentClusterPoolAksVersionStatus

	// Latest AKS patch version.
	LatestVersion *string
}

// GetClusterPoolAvailableUpgradeProperties implements the ClusterPoolAvailableUpgradePropertiesClassification interface for
// type ClusterPoolAvailableUpgradeAksPatchUpgradeProperties.
func (c *ClusterPoolAvailableUpgradeAksPatchUpgradeProperties) GetClusterPoolAvailableUpgradeProperties() *ClusterPoolAvailableUpgradeProperties {
	return &ClusterPoolAvailableUpgradeProperties{
		UpgradeType: c.UpgradeType,
	}
}

// ClusterPoolAvailableUpgradeList - collection of cluster pool available upgrade.
type ClusterPoolAvailableUpgradeList struct {
	// REQUIRED; Collection of cluster pool available upgrade.
	Value []*ClusterPoolAvailableUpgrade

	// The Url of next result page.
	NextLink *string
}

// ClusterPoolAvailableUpgradeNodeOsUpgradeProperties - Cluster pool available node OS update.
type ClusterPoolAvailableUpgradeNodeOsUpgradeProperties struct {
	// REQUIRED; Type of upgrade.
	UpgradeType *ClusterPoolAvailableUpgradeType

	// The latest node OS version.
	LatestVersion *string
}

// GetClusterPoolAvailableUpgradeProperties implements the ClusterPoolAvailableUpgradePropertiesClassification interface for
// type ClusterPoolAvailableUpgradeNodeOsUpgradeProperties.
func (c *ClusterPoolAvailableUpgradeNodeOsUpgradeProperties) GetClusterPoolAvailableUpgradeProperties() *ClusterPoolAvailableUpgradeProperties {
	return &ClusterPoolAvailableUpgradeProperties{
		UpgradeType: c.UpgradeType,
	}
}

// ClusterPoolAvailableUpgradeProperties - Cluster pool available upgrade properties.
type ClusterPoolAvailableUpgradeProperties struct {
	// REQUIRED; Type of upgrade.
	UpgradeType *ClusterPoolAvailableUpgradeType
}

// GetClusterPoolAvailableUpgradeProperties implements the ClusterPoolAvailableUpgradePropertiesClassification interface for
// type ClusterPoolAvailableUpgradeProperties.
func (c *ClusterPoolAvailableUpgradeProperties) GetClusterPoolAvailableUpgradeProperties() *ClusterPoolAvailableUpgradeProperties {
	return c
}

// ClusterPoolListResult - The list cluster pools operation response.
type ClusterPoolListResult struct {
	// The list of cluster pools.
	Value []*ClusterPool

	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string
}

// ClusterPoolNodeOsImageUpdateProperties - Properties of upgrading cluster pool's AKS patch version.
type ClusterPoolNodeOsImageUpdateProperties struct {
	// REQUIRED; Type of upgrade.
	UpgradeType *ClusterPoolUpgradeType
}

// GetClusterPoolUpgradeProperties implements the ClusterPoolUpgradePropertiesClassification interface for type ClusterPoolNodeOsImageUpdateProperties.
func (c *ClusterPoolNodeOsImageUpdateProperties) GetClusterPoolUpgradeProperties() *ClusterPoolUpgradeProperties {
	return &ClusterPoolUpgradeProperties{
		UpgradeType: c.UpgradeType,
	}
}

// ClusterPoolResourceProperties - Cluster pool resource properties.
type ClusterPoolResourceProperties struct {
	// REQUIRED; CLuster pool compute profile.
	ComputeProfile *ClusterPoolResourcePropertiesComputeProfile

	// CLuster pool profile.
	ClusterPoolProfile *ClusterPoolResourcePropertiesClusterPoolProfile

	// Cluster pool log analytics profile to enable OMS agent for AKS cluster.
	LogAnalyticsProfile *ClusterPoolResourcePropertiesLogAnalyticsProfile

	// A resource group created by RP, to hold the resources created by RP on-behalf of customers. It will also be used to generate
	// aksManagedResourceGroupName by pattern: MC{managedResourceGroupName}
	// {clusterPoolName}_{region}. Please make sure it meets resource group name restriction.
	ManagedResourceGroupName *string

	// Cluster pool network profile.
	NetworkProfile *ClusterPoolResourcePropertiesNetworkProfile

	// READ-ONLY; Properties of underlying AKS cluster.
	AksClusterProfile *ClusterPoolResourcePropertiesAksClusterProfile

	// READ-ONLY; A resource group created by AKS, to hold the infrastructure resources created by AKS on-behalf of customers.
	// It is generated by cluster pool name and managed resource group name by pattern: MC
	// {managedResourceGroupName}{clusterPoolName}_{region}
	AksManagedResourceGroupName *string

	// READ-ONLY; A unique id generated by the RP to identify the resource.
	DeploymentID *string

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningStatus

	// READ-ONLY; Business status of the resource.
	Status *string
}

// ClusterPoolResourcePropertiesAksClusterProfile - Properties of underlying AKS cluster.
type ClusterPoolResourcePropertiesAksClusterProfile struct {
	// Identity properties of the AKS cluster agentpool MSI
	AksClusterAgentPoolIdentityProfile *AksClusterProfileAksClusterAgentPoolIdentityProfile

	// ARM Resource ID of the AKS cluster
	AksClusterResourceID *string

	// READ-ONLY; AKS control plane and default node pool version of this ClusterPool
	AksVersion *string
}

// ClusterPoolResourcePropertiesClusterPoolProfile - CLuster pool profile.
type ClusterPoolResourcePropertiesClusterPoolProfile struct {
	// REQUIRED; Cluster pool version is a 2-part version.
	ClusterPoolVersion *string
}

// ClusterPoolResourcePropertiesComputeProfile - CLuster pool compute profile.
type ClusterPoolResourcePropertiesComputeProfile struct {
	// REQUIRED; The virtual machine SKU.
	VMSize *string

	// READ-ONLY; The number of virtual machines.
	Count *int32
}

// ClusterPoolResourcePropertiesLogAnalyticsProfile - Cluster pool log analytics profile to enable OMS agent for AKS cluster.
type ClusterPoolResourcePropertiesLogAnalyticsProfile struct {
	// REQUIRED; True if log analytics is enabled for cluster pool, otherwise false.
	Enabled *bool

	// Log analytics workspace to associate with the OMS agent.
	WorkspaceID *string
}

// ClusterPoolResourcePropertiesNetworkProfile - Cluster pool network profile.
type ClusterPoolResourcePropertiesNetworkProfile struct {
	// REQUIRED; Cluster pool subnet resource id.
	SubnetID *string

	// IP ranges are specified in CIDR format, e.g. 137.117.106.88/29. This feature is not compatible with private AKS clusters.
	// So you cannot set enablePrivateApiServer to true and
	// apiServerAuthorizedIpRanges at the same time.
	APIServerAuthorizedIPRanges []*string

	// ClusterPool is based on AKS cluster. AKS cluster exposes the API server to public internet by default. If you set this
	// property to true, a private AKS cluster will be created, and it will use private
	// apiserver, which is not exposed to public internet.
	EnablePrivateAPIServer *bool

	// This can only be set at cluster pool creation time and cannot be changed later.
	OutboundType *OutboundType
}

// ClusterPoolUpgrade - Cluster Pool Upgrade.
type ClusterPoolUpgrade struct {
	// REQUIRED; Properties of upgrading cluster pool.
	Properties ClusterPoolUpgradePropertiesClassification
}

// ClusterPoolUpgradeProperties - Properties of upgrading cluster pool.
type ClusterPoolUpgradeProperties struct {
	// REQUIRED; Type of upgrade.
	UpgradeType *ClusterPoolUpgradeType
}

// GetClusterPoolUpgradeProperties implements the ClusterPoolUpgradePropertiesClassification interface for type ClusterPoolUpgradeProperties.
func (c *ClusterPoolUpgradeProperties) GetClusterPoolUpgradeProperties() *ClusterPoolUpgradeProperties {
	return c
}

// ClusterPoolVersion - Available cluster pool version.
type ClusterPoolVersion struct {
	// Cluster pool version properties.
	Properties *ClusterPoolVersionProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ClusterPoolVersionProperties - Cluster pool version properties.
type ClusterPoolVersionProperties struct {
	// AKS version.
	AksVersion *string

	// Cluster pool version is a 2-part version.
	ClusterPoolVersion *string

	// Indicate if this version is in preview or not.
	IsPreview *bool
}

// ClusterPoolVersionsListResult - Represents a list of cluster pool versions.
type ClusterPoolVersionsListResult struct {
	// The list of cluster pool versions.
	Value []*ClusterPoolVersion

	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string
}

// ClusterProfile - Cluster profile.
type ClusterProfile struct {
	// REQUIRED; Authorization profile with details of AAD user Ids and group Ids authorized for data plane access.
	AuthorizationProfile *AuthorizationProfile

	// REQUIRED; Version with 3/4 part.
	ClusterVersion *string

	// REQUIRED; Version with three part.
	OssVersion *string

	// This is the Autoscale profile for the cluster. This will allow customer to create cluster enabled with Autoscale.
	AutoscaleProfile *AutoscaleProfile

	// Cluster access profile.
	ClusterAccessProfile *ClusterAccessProfile

	// The Flink cluster profile.
	FlinkProfile *FlinkProfile

	// This property is required by Trino, Spark and Flink cluster but is optional for Kafka cluster.
	IdentityProfile *IdentityProfile

	// The Kafka cluster profile.
	KafkaProfile *KafkaProfile

	// LLAP cluster profile.
	LlapProfile map[string]any

	// Cluster log analytics profile to enable or disable OMS agent for cluster.
	LogAnalyticsProfile *ClusterLogAnalyticsProfile

	// Cluster Prometheus profile.
	PrometheusProfile *ClusterPrometheusProfile

	// Cluster Ranger plugin profile.
	RangerPluginProfile *ClusterRangerPluginProfile

	// The ranger cluster profile.
	RangerProfile *RangerProfile

	// Ssh profile for the cluster.
	SSHProfile *SSHProfile

	// The script action profile list.
	ScriptActionProfiles []*ScriptActionProfile

	// The cluster secret profile.
	SecretsProfile *SecretsProfile

	// The service configs profiles.
	ServiceConfigsProfiles []*ClusterServiceConfigsProfile

	// The spark cluster profile.
	SparkProfile *SparkProfile

	// Stub cluster profile.
	StubProfile map[string]any

	// Trino Cluster profile.
	TrinoProfile *TrinoProfile

	// READ-ONLY; Component list of this cluster type and version.
	Components []*ClusterComponentsItem

	// READ-ONLY; Cluster connectivity profile.
	ConnectivityProfile *ConnectivityProfile
}

// ClusterPrometheusProfile - Cluster Prometheus profile.
type ClusterPrometheusProfile struct {
	// REQUIRED; Enable Prometheus for cluster or not.
	Enabled *bool
}

// ClusterRangerPluginProfile - Cluster Ranger plugin profile.
type ClusterRangerPluginProfile struct {
	// REQUIRED; Enable Ranger for cluster or not.
	Enabled *bool
}

// ClusterResizeData - The parameters for resizing a cluster.
type ClusterResizeData struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Sets the properties. Define cluster resize specific properties.
	Properties *ClusterResizeProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ClusterResizeProperties - The properties for resizing a cluster.
type ClusterResizeProperties struct {
	// REQUIRED; Target node count of worker node.
	TargetWorkerNodeCount *int32
}

// ClusterResourceProperties - Cluster resource properties.
type ClusterResourceProperties struct {
	// REQUIRED; Cluster profile.
	ClusterProfile *ClusterProfile

	// REQUIRED; The type of cluster.
	ClusterType *string

	// REQUIRED; The compute profile.
	ComputeProfile *ComputeProfile

	// READ-ONLY; A unique id generated by the RP to identify the resource.
	DeploymentID *string

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningStatus

	// READ-ONLY; Business status of the resource.
	Status *string
}

// ClusterServiceConfig - Cluster configs per component.
type ClusterServiceConfig struct {
	// REQUIRED; Name of the component the config files should apply to.
	Component *string

	// REQUIRED; List of Config Files.
	Files []*ClusterConfigFile
}

// ClusterServiceConfigsProfile - Cluster service configs.
type ClusterServiceConfigsProfile struct {
	// REQUIRED; List of service configs.
	Configs []*ClusterServiceConfig

	// REQUIRED; Name of the service the configurations should apply to.
	ServiceName *string
}

// ClusterUpgrade - Cluster Upgrade.
type ClusterUpgrade struct {
	// REQUIRED; Properties of upgrading cluster.
	Properties ClusterUpgradePropertiesClassification
}

// ClusterUpgradeProperties - Properties of upgrading cluster.
type ClusterUpgradeProperties struct {
	// REQUIRED; Type of upgrade.
	UpgradeType *ClusterUpgradeType
}

// GetClusterUpgradeProperties implements the ClusterUpgradePropertiesClassification interface for type ClusterUpgradeProperties.
func (c *ClusterUpgradeProperties) GetClusterUpgradeProperties() *ClusterUpgradeProperties { return c }

// ClusterVersion - Available cluster version.
type ClusterVersion struct {
	// Cluster version properties.
	Properties *ClusterVersionProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ClusterVersionProperties - Cluster version properties.
type ClusterVersionProperties struct {
	// The two part cluster pool version. If the cluster version is before cluster pool version on-board, the return value will
	// be empty string
	ClusterPoolVersion *string

	// The type of cluster.
	ClusterType *string

	// Version with three part.
	ClusterVersion *string

	// Indicate if this version is in preview or not.
	IsPreview *bool

	// Version with three part.
	OssVersion *string

	// READ-ONLY; Component list of this cluster type and version.
	Components []*ClusterComponentsItem
}

// ClusterVersionsListResult - Represents a list of cluster versions.
type ClusterVersionsListResult struct {
	// The list of cluster versions.
	Value []*ClusterVersion

	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string
}

// ComparisonRule - The comparison rule.
type ComparisonRule struct {
	// REQUIRED; The comparison operator.
	Operator *ComparisonOperator

	// REQUIRED; Threshold setting.
	Threshold *float32
}

// ComputeProfile - The compute profile.
type ComputeProfile struct {
	// REQUIRED; The nodes definitions.
	Nodes []*NodeProfile
}

// ComputeResourceDefinition - The cpu and memory requirement definition.
type ComputeResourceDefinition struct {
	// REQUIRED; The required CPU.
	CPU *float32

	// REQUIRED; The required memory in MB, Container memory will be 110 percentile
	Memory *int64
}

// ConnectivityProfile - Cluster connectivity profile.
type ConnectivityProfile struct {
	// REQUIRED; Web connectivity endpoint details.
	Web *ConnectivityProfileWeb

	// List of SSH connectivity endpoints.
	SSH []*SSHConnectivityEndpoint
}

// ConnectivityProfileWeb - Web connectivity endpoint details.
type ConnectivityProfileWeb struct {
	// REQUIRED; Web connectivity endpoint.
	Fqdn *string

	// Private web connectivity endpoint. This property will only be returned when enableInternalIngress is true.
	PrivateFqdn *string
}

// DiskStorageProfile - Kafka disk storage profile.
type DiskStorageProfile struct {
	// REQUIRED; Managed Disk size in GB. The maximum supported disk size for Standard and Premium HDD/SSD is 32TB, except for
	// Premium SSD v2, which supports up to 64TB.
	DataDiskSize *int32

	// REQUIRED; Managed Disk Type.
	DataDiskType *DataDiskType
}

// FlinkCatalogOptions - Flink cluster catalog options.
type FlinkCatalogOptions struct {
	// Hive Catalog Option for Flink cluster.
	Hive *FlinkHiveCatalogOption
}

// FlinkHiveCatalogOption - Hive Catalog Option for Flink cluster.
type FlinkHiveCatalogOption struct {
	// REQUIRED; Connection string for hive metastore database.
	MetastoreDbConnectionURL *string

	// The authentication mode to connect to your Hive metastore database. More details:
	// https://learn.microsoft.com/en-us/azure/azure-sql/database/logins-create-manage?view=azuresql#authentication-and-authorization
	MetastoreDbConnectionAuthenticationMode *MetastoreDbConnectionAuthenticationMode

	// Secret reference name from secretsProfile.secrets containing password for database connection.
	MetastoreDbConnectionPasswordSecret *string

	// User name for database connection.
	MetastoreDbConnectionUserName *string
}

// FlinkJobProfile - Job specifications for flink clusters in application deployment mode. The specification is immutable
// even if job properties are changed by calling the RunJob API, please use the ListJob API to get the
// latest job information.
type FlinkJobProfile struct {
	// REQUIRED; A string property that represents the name of the job JAR.
	JarName *string

	// REQUIRED; A string property that specifies the directory where the job JAR is located.
	JobJarDirectory *string

	// REQUIRED; A string property that indicates the upgrade mode to be performed on the Flink job. It can have one of the following
	// enum values => STATELESSUPDATE, UPDATE, LASTSTATE_UPDATE.
	UpgradeMode *UpgradeMode

	// A string property representing additional JVM arguments for the Flink job. It should be space separated value.
	Args *string

	// A string property that specifies the entry class for the Flink job. If not specified, the entry point is auto-detected
	// from the flink job jar package.
	EntryClass *string

	// A string property that represents the name of the savepoint for the Flink job
	SavePointName *string
}

// FlinkJobProperties - Properties of flink job.
type FlinkJobProperties struct {
	// REQUIRED; Type of cluster job.
	JobType *JobType

	// A string property that indicates the action to be performed on the Flink job. It can have one of the following enum values
	// => NEW, UPDATE, STATELESSUPDATE, STOP, START, CANCEL, SAVEPOINT, LIST
	// SAVEPOINT, or DELETE.
	Action *Action

	// A string property representing additional JVM arguments for the Flink job. It should be space separated value.
	Args *string

	// A string property that specifies the entry class for the Flink job.
	EntryClass *string

	// Additional properties used to configure Flink jobs. It allows users to set properties such as parallelism and jobSavePointDirectory.
	// It accepts additional key-value pairs as properties, where the keys
	// are strings and the values are strings as well.
	FlinkConfiguration map[string]*string

	// A string property that represents the name of the job JAR.
	JarName *string

	// A string property that specifies the directory where the job JAR is located.
	JobJarDirectory *string

	// Name of job
	JobName *string

	// Run id of job
	RunID *string

	// A string property that represents the name of the savepoint for the Flink job
	SavePointName *string

	// READ-ONLY; Action result of job.
	ActionResult *string

	// READ-ONLY; Unique id for identifying a job
	JobID *string

	// READ-ONLY; Output of job.
	JobOutput *string

	// READ-ONLY; The last savepoint.
	LastSavePoint *string

	// READ-ONLY; Status of job.
	Status *string
}

// GetClusterJobProperties implements the ClusterJobPropertiesClassification interface for type FlinkJobProperties.
func (f *FlinkJobProperties) GetClusterJobProperties() *ClusterJobProperties {
	return &ClusterJobProperties{
		JobType: f.JobType,
	}
}

// FlinkProfile - The Flink cluster profile.
type FlinkProfile struct {
	// REQUIRED; Job Manager container/ process CPU and memory requirements
	JobManager *ComputeResourceDefinition

	// REQUIRED; The storage profile
	Storage *FlinkStorageProfile

	// REQUIRED; Task Manager container/ process CPU and memory requirements
	TaskManager *ComputeResourceDefinition

	// Flink cluster catalog options.
	CatalogOptions *FlinkCatalogOptions

	// A string property that indicates the deployment mode of Flink cluster. It can have one of the following enum values =>
	// Application, Session. Default value is Session
	DeploymentMode *DeploymentMode

	// History Server container/ process CPU and memory requirements
	HistoryServer *ComputeResourceDefinition

	// Job specifications for flink clusters in application deployment mode. The specification is immutable even if job properties
	// are changed by calling the RunJob API, please use the ListJob API to get the
	// latest job information.
	JobSpec *FlinkJobProfile

	// The number of task managers.
	NumReplicas *int32
}

// FlinkStorageProfile - The storage profile
type FlinkStorageProfile struct {
	// REQUIRED; Storage account uri which is used for savepoint and checkpoint state.
	StorageURI *string

	// Storage key is only required for wasb(s) storage.
	Storagekey *string
}

// HiveCatalogOption - Hive Catalog Option
type HiveCatalogOption struct {
	// REQUIRED; Name of trino catalog which should use specified hive metastore.
	CatalogName *string

	// REQUIRED; Connection string for hive metastore database.
	MetastoreDbConnectionURL *string

	// REQUIRED; Metastore root directory URI, format: abfs[s]://@.dfs.core.windows.net/. More details: https://docs.microsoft.com/en-us/azure/storage/blobs/data-lake-storage-introduction-abfs-uri
	MetastoreWarehouseDir *string

	// The authentication mode to connect to your Hive metastore database. More details:
	// https://learn.microsoft.com/en-us/azure/azure-sql/database/logins-create-manage?view=azuresql#authentication-and-authorization
	MetastoreDbConnectionAuthenticationMode *MetastoreDbConnectionAuthenticationMode

	// Secret reference name from secretsProfile.secrets containing password for database connection.
	MetastoreDbConnectionPasswordSecret *string

	// User name for database connection.
	MetastoreDbConnectionUserName *string
}

// IdentityProfile - Identity Profile with details of an MSI.
type IdentityProfile struct {
	// REQUIRED; ClientId of the MSI.
	MsiClientID *string

	// REQUIRED; ObjectId of the MSI.
	MsiObjectID *string

	// REQUIRED; ResourceId of the MSI.
	MsiResourceID *string
}

// KafkaConnectivityEndpoints - Kafka bootstrap server and broker related connectivity endpoints.
type KafkaConnectivityEndpoints struct {
	// bootstrap server connectivity endpoint.
	BootstrapServerEndpoint *string

	// Kafka broker endpoint list.
	BrokerEndpoints []*string
}

// KafkaProfile - The Kafka cluster profile.
type KafkaProfile struct {
	// REQUIRED; Kafka disk storage profile.
	DiskStorage *DiskStorageProfile

	// Expose Kafka cluster in KRaft mode.
	EnableKRaft *bool

	// Expose worker nodes as public endpoints.
	EnablePublicEndpoints *bool

	// Fully qualified path of Azure Storage container used for Tiered Storage.
	RemoteStorageURI *string

	// READ-ONLY; Identity of the internal service components inside the Kafka cluster.
	ClusterIdentity *IdentityProfile

	// READ-ONLY; Kafka bootstrap server and brokers related connectivity endpoints.
	ConnectivityEndpoints *KafkaConnectivityEndpoints
}

// LoadBasedConfig - Profile of load based Autoscale.
type LoadBasedConfig struct {
	// REQUIRED; User needs to set the maximum number of nodes for load based scaling, the load based scaling will use this to
	// scale up and scale down between minimum and maximum number of nodes.
	MaxNodes *int32

	// REQUIRED; User needs to set the minimum number of nodes for load based scaling, the load based scaling will use this to
	// scale up and scale down between minimum and maximum number of nodes.
	MinNodes *int32

	// REQUIRED; The scaling rules.
	ScalingRules []*ScalingRule

	// This is a cool down period, this is a time period in seconds, which determines the amount of time that must elapse between
	// a scaling activity started by a rule and the start of the next scaling
	// activity, regardless of the rule that triggers it. The default value is 300 seconds.
	CooldownPeriod *int32

	// User can specify the poll interval, this is the time period (in seconds) after which scaling metrics are polled for triggering
	// a scaling operation.
	PollInterval *int32
}

// NameAvailabilityParameters - Details of check name availability request body.
type NameAvailabilityParameters struct {
	// Name for checking availability.
	Name *string

	// The resource type in Microsoft.HDInsight.
	Type *string
}

// NameAvailabilityResult - Result of check name availability.
type NameAvailabilityResult struct {
	// The error message of unavailability.
	Message *string

	// Indicator of availability of the Microsoft.HDInsight resource name.
	NameAvailable *bool

	// The reason of unavailability.
	Reason *string
}

// NodeProfile - The node profile.
type NodeProfile struct {
	// REQUIRED; The number of virtual machines.
	Count *int32

	// REQUIRED; The node type.
	Type *string

	// REQUIRED; The virtual machine SKU.
	VMSize *string
}

// Operation - Details of a REST API operation, returned from the Resource Provider Operations API
type Operation struct {
	// Localized display information for this particular operation.
	Display *OperationDisplay

	// READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
	ActionType *ActionType

	// READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane
	// operations.
	IsDataAction *bool

	// READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write",
	// "Microsoft.Compute/virtualMachines/capture/action"
	Name *string

	// READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
	// value is "user,system"
	Origin *Origin
}

// OperationDisplay - Localized display information for this particular operation.
type OperationDisplay struct {
	// READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string

	// READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual
	// Machine", "Restart Virtual Machine".
	Operation *string

	// READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft
	// Compute".
	Provider *string

	// READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job
	// Schedule Collections".
	Resource *string
}

// OperationListResult - A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to
// get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string

	// READ-ONLY; List of operations supported by the resource provider
	Value []*Operation
}

// RangerAdminSpec - Specification for the Ranger Admin service.
type RangerAdminSpec struct {
	// REQUIRED; List of usernames that should be marked as ranger admins. These usernames should match the user principal name
	// (UPN) of the respective AAD users.
	Admins []*string

	// REQUIRED
	Database *RangerAdminSpecDatabase
}

type RangerAdminSpecDatabase struct {
	// REQUIRED; The database URL
	Host *string

	// REQUIRED; The database name
	Name *string

	// Reference for the database password
	PasswordSecretRef *string

	// The name of the database user
	Username *string
}

// RangerAuditSpec - Properties required to describe audit log storage.
type RangerAuditSpec struct {
	// Azure storage location of the blobs. MSI should have read/write access to this Storage account.
	StorageAccount *string
}

// RangerProfile - The ranger cluster profile.
type RangerProfile struct {
	// REQUIRED; Specification for the Ranger Admin service.
	RangerAdmin *RangerAdminSpec

	// REQUIRED; Specification for the Ranger Usersync service
	RangerUsersync *RangerUsersyncSpec

	// Properties required to describe audit log storage.
	RangerAudit *RangerAuditSpec
}

// RangerUsersyncSpec - Specification for the Ranger Usersync service
type RangerUsersyncSpec struct {
	// Denotes whether usersync service should be enabled
	Enabled *bool

	// List of groups that should be synced. These group names should match the object id of the respective AAD groups.
	Groups []*string

	// User & groups can be synced automatically or via a static list that's refreshed.
	Mode *RangerUsersyncMode

	// Azure storage location of a mapping file that lists user & group associations.
	UserMappingLocation *string

	// List of user names that should be synced. These usernames should match the User principal name of the respective AAD users.
	Users []*string
}

// SSHConnectivityEndpoint - SSH connectivity endpoint details.
type SSHConnectivityEndpoint struct {
	// REQUIRED; SSH connectivity endpoint.
	Endpoint *string

	// Private SSH connectivity endpoint. This property will only be returned when enableInternalIngress is true.
	PrivateSSHEndpoint *string
}

// SSHProfile - Ssh profile for the cluster.
type SSHProfile struct {
	// REQUIRED; Number of ssh pods per cluster.
	Count *int32

	// READ-ONLY; Prefix of the pod names. Pod number will be appended to the prefix. The ingress URLs for the pods will be available
	// at //-
	PodPrefix *string
}

// ScalingRule - The scaling rule.
type ScalingRule struct {
	// REQUIRED; The action type.
	ActionType *ScaleActionType

	// REQUIRED; The comparison rule.
	ComparisonRule *ComparisonRule

	// REQUIRED; This is an evaluation count for a scaling condition, the number of times a trigger condition should be successful,
	// before scaling activity is triggered.
	EvaluationCount *int32

	// REQUIRED; Metrics name for individual workloads. For example: cpu
	ScalingMetric *string
}

// Schedule definition.
type Schedule struct {
	// REQUIRED; User has to set the node count anticipated at end of the scaling operation of the set current schedule configuration,
	// format is integer.
	Count *int32

	// REQUIRED; User has to set the days where schedule has to be set for autoscale operation.
	Days []*ScheduleDay

	// REQUIRED; User has to set the end time of current schedule configuration, format like 10:30 (HH:MM).
	EndTime *string

	// REQUIRED; User has to set the start time of current schedule configuration, format like 10:30 (HH:MM).
	StartTime *string
}

// ScheduleBasedConfig - Profile of schedule based Autoscale.
type ScheduleBasedConfig struct {
	// REQUIRED; Setting default node count of current schedule configuration. Default node count specifies the number of nodes
	// which are default when an specified scaling operation is executed (scale up/scale down)
	DefaultCount *int32

	// REQUIRED; This specifies the schedules where scheduled based Autoscale to be enabled, the user has a choice to set multiple
	// rules within the schedule across days and times (start/end).
	Schedules []*Schedule

	// REQUIRED; User has to specify the timezone on which the schedule has to be set for schedule based autoscale configuration.
	TimeZone *string
}

// ScriptActionProfile - The script action profile.
type ScriptActionProfile struct {
	// REQUIRED; Script name.
	Name *string

	// REQUIRED; List of services to apply the script action.
	Services []*string

	// REQUIRED; Type of the script action. Supported type is bash scripts.
	Type *string

	// REQUIRED; Url of the script file.
	URL *string

	// Additional parameters for the script action. It should be space-separated list of arguments required for script execution.
	Parameters *string

	// Specify if the script should persist on the cluster.
	ShouldPersist *bool

	// Timeout duration for the script action in minutes.
	TimeoutInMinutes *int32
}

// SecretReference - Secret reference and corresponding properties of a key vault secret.
type SecretReference struct {
	// REQUIRED; Object identifier name of the secret in key vault.
	KeyVaultObjectName *string

	// REQUIRED; Reference name of the secret to be used in service configs.
	ReferenceName *string

	// REQUIRED; Type of key vault object: secret, key or certificate.
	Type *KeyVaultObjectType

	// Version of the secret in key vault.
	Version *string
}

// SecretsProfile - The cluster secret profile.
type SecretsProfile struct {
	// REQUIRED; Name of the user Key Vault where all the cluster specific user secrets are stored.
	KeyVaultResourceID *string

	// Properties of Key Vault secret.
	Secrets []*SecretReference
}

// ServiceConfigListResult - Cluster instance service configs api response.
type ServiceConfigListResult struct {
	// Cluster instance service config array.
	Value []*ServiceConfigResult

	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string
}

// ServiceConfigListResultValueEntity - Default config details.
type ServiceConfigListResultValueEntity struct {
	// REQUIRED; Config value.
	Value *string

	// Config description.
	Description *string
}

// ServiceConfigResult - Cluster instance service config.
type ServiceConfigResult struct {
	// Cluster instance service config properties.
	Properties *ServiceConfigResultProperties
}

// ServiceConfigResultProperties - Cluster instance service config properties.
type ServiceConfigResultProperties struct {
	// REQUIRED; Component Name.
	ComponentName *string

	// REQUIRED; File Name.
	FileName *string

	// REQUIRED; Service Config Name.
	ServiceName *string

	// Content in the service config file.
	Content *string

	// The custom keys.
	CustomKeys map[string]*string

	// The default keys.
	DefaultKeys map[string]*ServiceConfigListResultValueEntity

	// Config file path.
	Path *string

	// Config type.
	Type *string
}

// ServiceStatus - Describes the status of a service of a HDInsight on AKS cluster.
type ServiceStatus struct {
	// REQUIRED; Kind of the service. E.g. "Zookeeper".
	Kind *string

	// REQUIRED; Indicates if the service is ready / healthy. Values can be "true", "false", "unknown" or anything else.
	Ready *string

	// A message describing the error if any.
	Message *string
}

// SparkMetastoreSpec - The metastore specification for Spark cluster.
type SparkMetastoreSpec struct {
	// REQUIRED; The database name.
	DbName *string

	// REQUIRED; The database server host.
	DbServerHost *string

	// The authentication mode to connect to your Hive metastore database. More details:
	// https://learn.microsoft.com/en-us/azure/azure-sql/database/logins-create-manage?view=azuresql#authentication-and-authorization
	DbConnectionAuthenticationMode *DbConnectionAuthenticationMode

	// The secret name which contains the database user password.
	DbPasswordSecretName *string

	// The database user name.
	DbUserName *string

	// The key vault resource id.
	KeyVaultID *string

	// The thrift url.
	ThriftURL *string
}

// SparkProfile - The spark cluster profile.
type SparkProfile struct {
	// The default storage URL.
	DefaultStorageURL *string

	// The metastore specification for Spark cluster.
	MetastoreSpec *SparkMetastoreSpec

	// Spark user plugins spec
	UserPluginsSpec *SparkUserPlugins
}

// SparkUserPlugin - Spark user plugin.
type SparkUserPlugin struct {
	// REQUIRED; Fully qualified path to the folder containing the plugins.
	Path *string
}

// SparkUserPlugins - Spark user plugins spec
type SparkUserPlugins struct {
	// Spark user plugins.
	Plugins []*SparkUserPlugin
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// TagsObject - Tags object for patch operations.
type TagsObject struct {
	// Resource tags.
	Tags map[string]*string
}

// TrinoCoordinator - Trino Coordinator.
type TrinoCoordinator struct {
	// Trino debug configuration.
	Debug *TrinoDebugConfig

	// The flag that if enable coordinator HA, uses multiple coordinator replicas with auto failover, one per each head node.
	// Default: true.
	HighAvailabilityEnabled *bool
}

// TrinoDebugConfig - Trino debug configuration.
type TrinoDebugConfig struct {
	// The flag that if enable debug or not.
	Enable *bool

	// The debug port.
	Port *int32

	// The flag that if suspend debug or not.
	Suspend *bool
}

// TrinoProfile - Trino Cluster profile.
type TrinoProfile struct {
	// Trino cluster catalog options.
	CatalogOptions *CatalogOptions

	// Trino Coordinator.
	Coordinator *TrinoCoordinator

	// Trino user plugins spec
	UserPluginsSpec *TrinoUserPlugins

	// User telemetry
	UserTelemetrySpec *TrinoUserTelemetry

	// Trino worker.
	Worker *TrinoWorker
}

// TrinoTelemetryConfig - Trino user telemetry definition.
type TrinoTelemetryConfig struct {
	// Hive Catalog name used to mount external tables on the logs written by trino, if not specified there tables are not created.
	HivecatalogName *string

	// Schema of the above catalog to use, to mount query logs as external tables, if not specified tables will be mounted under
	// schema trinologs.
	HivecatalogSchema *string

	// Retention period for query log table partitions, this doesn't have any affect on actual data.
	PartitionRetentionInDays *int32

	// Azure storage location of the blobs.
	Path *string
}

// TrinoUserPlugin - Trino user plugin.
type TrinoUserPlugin struct {
	// Denotes whether the plugin is active or not.
	Enabled *bool

	// This field maps to the sub-directory in trino plugins location, that will contain all the plugins under path.
	Name *string

	// Fully qualified path to the folder containing the plugins.
	Path *string
}

// TrinoUserPlugins - Trino user plugins spec
type TrinoUserPlugins struct {
	// Trino user plugins.
	Plugins []*TrinoUserPlugin
}

// TrinoUserTelemetry - User telemetry
type TrinoUserTelemetry struct {
	// Trino user telemetry definition.
	Storage *TrinoTelemetryConfig
}

// TrinoWorker - Trino worker.
type TrinoWorker struct {
	// Trino debug configuration.
	Debug *TrinoDebugConfig
}

// UpdatableClusterProfile - Cluster resource patch properties.
type UpdatableClusterProfile struct {
	// Authorization profile with details of AAD user Ids and group Ids authorized for data plane access.
	AuthorizationProfile *AuthorizationProfile

	// This is the Autoscale profile for the cluster. This will allow customer to create cluster enabled with Autoscale.
	AutoscaleProfile *AutoscaleProfile

	// Cluster log analytics profile to enable or disable OMS agent for cluster.
	LogAnalyticsProfile *ClusterLogAnalyticsProfile

	// Cluster Prometheus profile.
	PrometheusProfile *ClusterPrometheusProfile

	// Cluster Ranger plugin profile.
	RangerPluginProfile *ClusterRangerPluginProfile

	// The ranger cluster profile.
	RangerProfile *RangerProfile

	// Ssh profile for the cluster.
	SSHProfile *SSHProfile

	// The script action profile list.
	ScriptActionProfiles []*ScriptActionProfile

	// The service configs profiles.
	ServiceConfigsProfiles []*ClusterServiceConfigsProfile
}
