//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcosmosforpostgresql

import "time"

// AuthConfig - Authentication configuration of a cluster.
type AuthConfig struct {
	ActiveDirectoryAuth *ActiveDirectoryAuth
	PasswordAuth        *PasswordAuth
}

// Cluster - Represents a cluster.
type Cluster struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Properties of the cluster.
	Properties *ClusterProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ClusterConfigurationListResult - A list of cluster configurations.
type ClusterConfigurationListResult struct {
	// The list of cluster configurations.
	Value []*Configuration

	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string
}

// ClusterForUpdate - Represents a cluster for update.
type ClusterForUpdate struct {
	// Properties of the cluster.
	Properties *ClusterPropertiesForUpdate

	// Application-specific metadata in the form of key-value pairs.
	Tags map[string]*string
}

// ClusterListResult - A list of clusters.
type ClusterListResult struct {
	// The list of clusters
	Value []*Cluster

	// READ-ONLY; The link used to get the next page of cluster list.
	NextLink *string
}

// ClusterProperties - Properties of the cluster.
type ClusterProperties struct {
	// The password of the administrator login. Required for creation.
	AdministratorLoginPassword *string

	// Authentication configuration of a cluster.
	AuthConfig *AuthConfig

	// The Citus extension version on all cluster servers.
	CitusVersion *string

	// If public access is enabled on coordinator.
	CoordinatorEnablePublicIPAccess *bool

	// The edition of a coordinator server (default: GeneralPurpose). Required for creation.
	CoordinatorServerEdition *string

	// The storage of a server in MB. Required for creation. See https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute
	// for more information.
	CoordinatorStorageQuotaInMb *int32

	// The vCores count of a server (max: 96). Required for creation. See https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute
	// for more information.
	CoordinatorVCores *int32

	// The database name of the cluster. Only one database per cluster is supported.
	DatabaseName *string

	// If cluster backup is stored in another Azure region in addition to the copy of the backup stored in the cluster's region.
	// Enabled only at the time of cluster creation.
	EnableGeoBackup *bool

	// If high availability (HA) is enabled or not for the cluster.
	EnableHa *bool

	// If distributed tables are placed on coordinator or not. Should be set to 'true' on single node clusters. Requires shard
	// rebalancing after value is changed.
	EnableShardsOnCoordinator *bool

	// Maintenance window of a cluster.
	MaintenanceWindow *MaintenanceWindow

	// Worker node count of the cluster. When node count is 0, it represents a single node configuration with the ability to create
	// distributed tables on that node. 2 or more worker nodes represent
	// multi-node configuration. Node count value cannot be 1. Required for creation.
	NodeCount *int32

	// If public access is enabled on worker nodes.
	NodeEnablePublicIPAccess *bool

	// The edition of a node server (default: MemoryOptimized).
	NodeServerEdition *string

	// The storage in MB on each worker node. See https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute for
	// more information.
	NodeStorageQuotaInMb *int32

	// The compute in vCores on each worker node (max: 104). See https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute
	// for more information.
	NodeVCores *int32

	// Date and time in UTC (ISO8601 format) for cluster restore.
	PointInTimeUTC *time.Time

	// The major PostgreSQL version on all cluster servers.
	PostgresqlVersion *string

	// Preferred primary availability zone (AZ) for all cluster servers.
	PreferredPrimaryZone *string

	// The Azure region of source cluster for read replica clusters.
	SourceLocation *string

	// The resource id of source cluster for read replica clusters.
	SourceResourceID *string

	// READ-ONLY; The administrator's login name of the servers in the cluster.
	AdministratorLogin *string

	// READ-ONLY; The earliest restore point time (ISO8601 format) for the cluster.
	EarliestRestoreTime *time.Time

	// READ-ONLY; The private endpoint connections for a cluster.
	PrivateEndpointConnections []*SimplePrivateEndpointConnection

	// READ-ONLY; Provisioning state of the cluster
	ProvisioningState *string

	// READ-ONLY; The array of read replica clusters.
	ReadReplicas []*string

	// READ-ONLY; The list of server names in the cluster
	ServerNames []*ServerNameItem

	// READ-ONLY; A state of a cluster/server that is visible to user.
	State *string
}

// ClusterPropertiesForUpdate - The properties used to update a cluster.
type ClusterPropertiesForUpdate struct {
	// The password of the administrator login. Each cluster is created with pre-defined administrative role called ‘citus’.
	AdministratorLoginPassword *string

	// The Citus extension version on all cluster servers.
	CitusVersion *string

	// If public access is enabled on coordinator.
	CoordinatorEnablePublicIPAccess *bool

	// The edition of the coordinator (default: GeneralPurpose).
	CoordinatorServerEdition *string

	// The storage of the coordinator in MB.
	CoordinatorStorageQuotaInMb *int32

	// The vCores count of the coordinator (max: 96).
	CoordinatorVCores *int32

	// If high availability (HA) is enabled or not for the cluster.
	EnableHa *bool

	// If distributed tables are placed on coordinator or not. Should be set to 'true' on single node clusters. Requires shard
	// rebalancing after value is changed.
	EnableShardsOnCoordinator *bool

	// Maintenance window of a cluster.
	MaintenanceWindow *MaintenanceWindow

	// Worker node count of the cluster. When node count is 0, it represents a single node configuration with the ability to create
	// distributed tables on that node. 2 or more worker nodes represent
	// multi-node configuration. Node count value cannot be 1.
	NodeCount *int32

	// The edition of a node (default: MemoryOptimized).
	NodeServerEdition *string

	// The storage in MB on each worker node.
	NodeStorageQuotaInMb *int32

	// The compute in vCores on each worker node (max: 104).
	NodeVCores *int32

	// The major PostgreSQL version on all cluster servers.
	PostgresqlVersion *string

	// Preferred primary availability zone (AZ) for all cluster servers.
	PreferredPrimaryZone *string

	// READ-ONLY; If public access is enabled on worker nodes.
	NodeEnablePublicIPAccess *bool
}

// ClusterServer - Represents a server in a cluster.
type ClusterServer struct {
	// The properties of a server in a cluster.
	Properties *ClusterServerProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ClusterServerListResult - A list of servers in a cluster.
type ClusterServerListResult struct {
	// The list of servers in a cluster.
	Value []*ClusterServer
}

// ClusterServerProperties - The properties of a server in cluster.
type ClusterServerProperties struct {
	// Availability Zone information of the server.
	AvailabilityZone *string

	// The Citus extension version of server.
	CitusVersion *string

	// If high availability (HA) is enabled or not for the server.
	EnableHa *bool

	// The major PostgreSQL version of server.
	PostgresqlVersion *string

	// The role of server in the cluster.
	Role *ServerRole

	// The edition of a server.
	ServerEdition *string

	// The storage of a server in MB.
	StorageQuotaInMb *int32

	// The vCores count of a server.
	VCores *int32

	// READ-ONLY; The administrator's login name of the servers in the cluster.
	AdministratorLogin *string

	// READ-ONLY; If public access is enabled on server.
	EnablePublicIPAccess *bool

	// READ-ONLY; The fully qualified domain name of a server.
	FullyQualifiedDomainName *string

	// READ-ONLY; A state of HA feature for the cluster.
	HaState *string

	// READ-ONLY; If server database is set to read-only by system maintenance depending on high disk space usage.
	IsReadOnly *bool

	// READ-ONLY; A state of a cluster/server that is visible to user.
	State *string
}

// Configuration - Represents configuration details for coordinator and node.
type Configuration struct {
	// The properties of configuration.
	Properties *ConfigurationProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ConfigurationProperties - The properties of configuration.
type ConfigurationProperties struct {
	// REQUIRED; The list of server role group configuration values.
	ServerRoleGroupConfigurations []*ServerRoleGroupConfiguration

	// If configuration change requires restart.
	RequiresRestart *bool

	// READ-ONLY; Allowed values of the configuration.
	AllowedValues *string

	// READ-ONLY; Data type of the configuration.
	DataType *ConfigurationDataType

	// READ-ONLY; Description of the configuration.
	Description *string

	// READ-ONLY; Provisioning state of the configuration
	ProvisioningState *ProvisioningState
}

// FirewallRule - Represents a cluster firewall rule.
type FirewallRule struct {
	// REQUIRED; The properties of a firewall rule.
	Properties *FirewallRuleProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// FirewallRuleListResult - A list of firewall rules.
type FirewallRuleListResult struct {
	// The list of firewall rules in a cluster.
	Value []*FirewallRule
}

// FirewallRuleProperties - The properties of a cluster firewall rule.
type FirewallRuleProperties struct {
	// REQUIRED; The end IP address of the cluster firewall rule. Must be IPv4 format.
	EndIPAddress *string

	// REQUIRED; The start IP address of the cluster firewall rule. Must be IPv4 format.
	StartIPAddress *string

	// READ-ONLY; Provisioning state of the firewall rule.
	ProvisioningState *ProvisioningState
}

// MaintenanceWindow - Schedule settings for regular cluster updates.
type MaintenanceWindow struct {
	// Indicates whether custom maintenance window is enabled or not.
	CustomWindow *string

	// Preferred day of the week for maintenance window.
	DayOfWeek *int32

	// Start hour within preferred day of the week for maintenance window.
	StartHour *int32

	// Start minute within the start hour for maintenance window.
	StartMinute *int32
}

// NameAvailability - Represents cluster name availability.
type NameAvailability struct {
	// Error message.
	Message *string

	// Name of the cluster.
	Name *string

	// Indicates whether the cluster name is available.
	NameAvailable *bool

	// Type of the cluster.
	Type *string
}

// NameAvailabilityRequest - Request from client to check cluster name availability.
type NameAvailabilityRequest struct {
	// REQUIRED; Cluster name to verify.
	Name *string

	// CONSTANT; Resource type used for verification.
	// Field has constant value "Microsoft.DBforPostgreSQL/serverGroupsv2", any specified value is ignored.
	Type *string
}

// Operation - REST API operation definition.
type Operation struct {
	// Indicates whether the operation is a data action.
	IsDataAction *bool

	// READ-ONLY; The localized display information for this particular operation or action.
	Display *OperationDisplay

	// READ-ONLY; The name of the operation being performed on this particular object.
	Name *string

	// READ-ONLY; The intended executor of the operation.
	Origin *OperationOrigin

	// READ-ONLY; Additional descriptions for the operation.
	Properties map[string]any
}

// OperationDisplay - Display metadata associated with the operation.
type OperationDisplay struct {
	// READ-ONLY; Operation description.
	Description *string

	// READ-ONLY; Localized friendly name for the operation.
	Operation *string

	// READ-ONLY; Operation resource provider name.
	Provider *string

	// READ-ONLY; Resource on which the operation is performed.
	Resource *string
}

// OperationListResult - A list of resource provider operations.
type OperationListResult struct {
	// Collection of available operation details.
	Value []*Operation

	// READ-ONLY; URL client should use to fetch the next page (per server side paging). It's null for now, added for future use.
	NextLink *string
}

// PrivateEndpoint - The private endpoint resource.
type PrivateEndpoint struct {
	// READ-ONLY; The ARM identifier for private endpoint.
	ID *string
}

// PrivateEndpointConnection - The private endpoint connection resource.
type PrivateEndpointConnection struct {
	// Resource properties.
	Properties *PrivateEndpointConnectionProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PrivateEndpointConnectionListResult - List of private endpoint connections associated with the specified resource.
type PrivateEndpointConnectionListResult struct {
	// Array of private endpoint connections.
	Value []*PrivateEndpointConnection
}

// PrivateEndpointConnectionProperties - Properties of the private endpoint connection.
type PrivateEndpointConnectionProperties struct {
	// REQUIRED; A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState

	// The private endpoint resource.
	PrivateEndpoint *PrivateEndpoint

	// READ-ONLY; The group ids for the private endpoint resource.
	GroupIDs []*string

	// READ-ONLY; The provisioning state of the private endpoint connection resource.
	ProvisioningState *PrivateEndpointConnectionProvisioningState
}

// PrivateEndpointConnectionSimpleProperties - The properties in private endpoint connection
type PrivateEndpointConnectionSimpleProperties struct {
	// Group ids of the private endpoint connection.
	GroupIDs []*string

	// Private endpoint which the connection belongs to.
	PrivateEndpoint *PrivateEndpointProperty

	// A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState
}

// PrivateEndpointProperty - Property to represent resource id of the private endpoint.
type PrivateEndpointProperty struct {
	// Resource id of the private endpoint.
	ID *string
}

// PrivateLinkResource - A private link resource.
type PrivateLinkResource struct {
	// Resource properties.
	Properties *PrivateLinkResourceProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PrivateLinkResourceListResult - A list of private link resources.
type PrivateLinkResourceListResult struct {
	// Array of private link resources
	Value []*PrivateLinkResource
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// The private link resource private link DNS zone name.
	RequiredZoneNames []*string

	// READ-ONLY; The private link resource group id.
	GroupID *string

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string
}

// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer
// and provider.
type PrivateLinkServiceConnectionState struct {
	// A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string

	// The reason for approval/rejection of the connection.
	Description *string

	// Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
	Status *PrivateEndpointServiceConnectionStatus
}

// PromoteRequest - Request from client to promote geo-redundant replica
type PromoteRequest struct {
	// Cluster name to verify.
	EnableGeoBackup *bool
}

// Role - Represents a cluster role.
type Role struct {
	// REQUIRED; The properties of a role.
	Properties *RoleProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// RoleListResult - A list of roles.
type RoleListResult struct {
	// The list of roles in a cluster.
	Value []*Role
}

// RoleProperties - The properties of a cluster role.
type RoleProperties struct {
	ExternalIdentity *RolePropertiesExternalIdentity

	// The password of the cluster role. If an identity is used, password will not be required.
	Password *string
	RoleType *RoleType

	// READ-ONLY; Provisioning state of the role
	ProvisioningState *ProvisioningState
}

type RolePropertiesExternalIdentity struct {
	// REQUIRED
	ObjectID *string

	// REQUIRED
	PrincipalType *PrincipalType
	TenantID      *string
}

// ServerConfiguration - Represents a configuration.
type ServerConfiguration struct {
	// The properties of a configuration.
	Properties *ServerConfigurationProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ServerConfigurationListResult - A list of server configurations.
type ServerConfigurationListResult struct {
	// The list of server configurations.
	Value []*ServerConfiguration

	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string
}

// ServerConfigurationProperties - The properties of a configuration.
type ServerConfigurationProperties struct {
	// REQUIRED; Value of the configuration.
	Value *string

	// READ-ONLY; Allowed values of the configuration.
	AllowedValues *string

	// READ-ONLY; Data type of the configuration.
	DataType *ConfigurationDataType

	// READ-ONLY; Default value of the configuration.
	DefaultValue *string

	// READ-ONLY; Description of the configuration.
	Description *string

	// READ-ONLY; Provisioning state of the configuration.
	ProvisioningState *ProvisioningState

	// READ-ONLY; If configuration change requires restart.
	RequiresRestart *bool

	// READ-ONLY; Source of the configuration.
	Source *string
}

// ServerNameItem - The name object for a server.
type ServerNameItem struct {
	// The name of a server.
	Name *string

	// READ-ONLY; The fully qualified domain name of a server.
	FullyQualifiedDomainName *string
}

// ServerRoleGroupConfiguration - Represents server role group configuration value.
type ServerRoleGroupConfiguration struct {
	// REQUIRED; The role of servers in the server role group.
	Role *ServerRole

	// REQUIRED; Value of the configuration.
	Value *string

	// READ-ONLY; Default value of the configuration.
	DefaultValue *string

	// READ-ONLY; Source of the configuration.
	Source *string
}

// SimplePrivateEndpointConnection - A private endpoint connection.
type SimplePrivateEndpointConnection struct {
	// Properties of the private endpoint connection.
	Properties *PrivateEndpointConnectionSimpleProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}
