//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/cosmos/armcosmos/v3"
	"net/http"
	"net/url"
	"regexp"
)

// ThroughputPoolAccountServer is a fake server for instances of the armcosmos.ThroughputPoolAccountClient type.
type ThroughputPoolAccountServer struct {
	// BeginCreate is the fake for method ThroughputPoolAccountClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreate func(ctx context.Context, resourceGroupName string, throughputPoolName string, throughputPoolAccountName string, body armcosmos.ThroughputPoolAccountResource, options *armcosmos.ThroughputPoolAccountClientBeginCreateOptions) (resp azfake.PollerResponder[armcosmos.ThroughputPoolAccountClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method ThroughputPoolAccountClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, throughputPoolName string, throughputPoolAccountName string, options *armcosmos.ThroughputPoolAccountClientBeginDeleteOptions) (resp azfake.PollerResponder[armcosmos.ThroughputPoolAccountClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ThroughputPoolAccountClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, throughputPoolName string, throughputPoolAccountName string, options *armcosmos.ThroughputPoolAccountClientGetOptions) (resp azfake.Responder[armcosmos.ThroughputPoolAccountClientGetResponse], errResp azfake.ErrorResponder)
}

// NewThroughputPoolAccountServerTransport creates a new instance of ThroughputPoolAccountServerTransport with the provided implementation.
// The returned ThroughputPoolAccountServerTransport instance is connected to an instance of armcosmos.ThroughputPoolAccountClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewThroughputPoolAccountServerTransport(srv *ThroughputPoolAccountServer) *ThroughputPoolAccountServerTransport {
	return &ThroughputPoolAccountServerTransport{
		srv:         srv,
		beginCreate: newTracker[azfake.PollerResponder[armcosmos.ThroughputPoolAccountClientCreateResponse]](),
		beginDelete: newTracker[azfake.PollerResponder[armcosmos.ThroughputPoolAccountClientDeleteResponse]](),
	}
}

// ThroughputPoolAccountServerTransport connects instances of armcosmos.ThroughputPoolAccountClient to instances of ThroughputPoolAccountServer.
// Don't use this type directly, use NewThroughputPoolAccountServerTransport instead.
type ThroughputPoolAccountServerTransport struct {
	srv         *ThroughputPoolAccountServer
	beginCreate *tracker[azfake.PollerResponder[armcosmos.ThroughputPoolAccountClientCreateResponse]]
	beginDelete *tracker[azfake.PollerResponder[armcosmos.ThroughputPoolAccountClientDeleteResponse]]
}

// Do implements the policy.Transporter interface for ThroughputPoolAccountServerTransport.
func (t *ThroughputPoolAccountServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ThroughputPoolAccountClient.BeginCreate":
		resp, err = t.dispatchBeginCreate(req)
	case "ThroughputPoolAccountClient.BeginDelete":
		resp, err = t.dispatchBeginDelete(req)
	case "ThroughputPoolAccountClient.Get":
		resp, err = t.dispatchGet(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (t *ThroughputPoolAccountServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if t.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := t.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/throughputPools/(?P<throughputPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputPoolAccounts/(?P<throughputPoolAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.ThroughputPoolAccountResource](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		throughputPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("throughputPoolName")])
		if err != nil {
			return nil, err
		}
		throughputPoolAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("throughputPoolAccountName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := t.srv.BeginCreate(req.Context(), resourceGroupNameParam, throughputPoolNameParam, throughputPoolAccountNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		t.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		t.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		t.beginCreate.remove(req)
	}

	return resp, nil
}

func (t *ThroughputPoolAccountServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if t.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := t.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/throughputPools/(?P<throughputPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputPoolAccounts/(?P<throughputPoolAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		throughputPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("throughputPoolName")])
		if err != nil {
			return nil, err
		}
		throughputPoolAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("throughputPoolAccountName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := t.srv.BeginDelete(req.Context(), resourceGroupNameParam, throughputPoolNameParam, throughputPoolAccountNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		t.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		t.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		t.beginDelete.remove(req)
	}

	return resp, nil
}

func (t *ThroughputPoolAccountServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if t.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/throughputPools/(?P<throughputPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputPoolAccounts/(?P<throughputPoolAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	throughputPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("throughputPoolName")])
	if err != nil {
		return nil, err
	}
	throughputPoolAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("throughputPoolAccountName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.Get(req.Context(), resourceGroupNameParam, throughputPoolNameParam, throughputPoolAccountNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ThroughputPoolAccountResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
