//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// Code generated by Microsoft (R) AutoRest Code Generator.Changes may cause incorrect behavior and will be lost if the code
// is regenerated.
// Code generated by @autorest/go. DO NOT EDIT.

package armconnectedvmware

import "time"

// Cluster - Define the cluster.
type Cluster struct {
	// REQUIRED; Gets or sets the location.
	Location *string

	// REQUIRED; Resource properties.
	Properties *ClusterProperties

	// Gets or sets the extended location.
	ExtendedLocation *ExtendedLocation

	// Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are
	// a kind of Microsoft.Web/sites type. If supported, the resource provider must
	// validate and persist this value.
	Kind *string

	// Gets or sets the Resource tags.
	Tags map[string]*string

	// READ-ONLY; Gets or sets the Id.
	ID *string

	// READ-ONLY; Gets or sets the name.
	Name *string

	// READ-ONLY; The system data.
	SystemData *SystemData

	// READ-ONLY; Gets or sets the type of the resource.
	Type *string
}

// ClusterInventoryItem - The cluster inventory item.
type ClusterInventoryItem struct {
	// REQUIRED; They inventory type.
	InventoryType *InventoryType

	// Gets or sets the tracked resource id corresponding to the inventory resource.
	ManagedResourceID *string

	// Gets or sets the vCenter Managed Object name for the inventory item.
	MoName *string

	// Gets or sets the MoRef (Managed Object Reference) ID for the inventory item.
	MoRefID *string

	// READ-ONLY; Gets the provisioning state.
	ProvisioningState *ProvisioningState
}

// GetInventoryItemProperties implements the InventoryItemPropertiesClassification interface for type ClusterInventoryItem.
func (c *ClusterInventoryItem) GetInventoryItemProperties() *InventoryItemProperties {
	return &InventoryItemProperties{
		InventoryType:     c.InventoryType,
		ManagedResourceID: c.ManagedResourceID,
		MoName:            c.MoName,
		MoRefID:           c.MoRefID,
		ProvisioningState: c.ProvisioningState,
	}
}

// ClusterProperties - Describes the properties of a Cluster.
type ClusterProperties struct {
	// Gets or sets the inventory Item ID for the cluster.
	InventoryItemID *string

	// Gets or sets the vCenter MoRef (Managed Object Reference) ID for the cluster.
	MoRefID *string

	// Gets or sets the ARM Id of the vCenter resource in which this cluster resides.
	VCenterID *string

	// READ-ONLY; Gets the name of the corresponding resource in Kubernetes.
	CustomResourceName *string

	// READ-ONLY; Gets the datastore ARM ids.
	DatastoreIDs []*string

	// READ-ONLY; Gets or sets the vCenter Managed Object name for the cluster.
	MoName *string

	// READ-ONLY; Gets the network ARM ids.
	NetworkIDs []*string

	// READ-ONLY; Gets the provisioning state.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The resource status information.
	Statuses []*ResourceStatus

	// READ-ONLY; Gets the max CPU usage across all cores on the cluster in MHz.
	TotalCPUMHz *int64

	// READ-ONLY; Gets the total amount of physical memory on the cluster in GB.
	TotalMemoryGB *int64

	// READ-ONLY; Gets or sets a unique identifier for this resource.
	UUID *string

	// READ-ONLY; Gets the used CPU usage across all cores on the cluster in MHz.
	UsedCPUMHz *int64

	// READ-ONLY; Gets the used physical memory on the cluster in GB.
	UsedMemoryGB *int64
}

// ClustersList - List of Clusters.
type ClustersList struct {
	// REQUIRED; Array of Clusters
	Value []*Cluster

	// Url to follow for getting next page of Clusters.
	NextLink *string
}

// Datastore - Define the datastore.
type Datastore struct {
	// REQUIRED; Gets or sets the location.
	Location *string

	// REQUIRED; Resource properties.
	Properties *DatastoreProperties

	// Gets or sets the extended location.
	ExtendedLocation *ExtendedLocation

	// Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are
	// a kind of Microsoft.Web/sites type. If supported, the resource provider must
	// validate and persist this value.
	Kind *string

	// Gets or sets the Resource tags.
	Tags map[string]*string

	// READ-ONLY; Gets or sets the Id.
	ID *string

	// READ-ONLY; Gets or sets the name.
	Name *string

	// READ-ONLY; The system data.
	SystemData *SystemData

	// READ-ONLY; Gets or sets the type of the resource.
	Type *string
}

// DatastoreInventoryItem - The datastore inventory item.
type DatastoreInventoryItem struct {
	// REQUIRED; They inventory type.
	InventoryType *InventoryType

	// Gets or sets Maximum capacity of this datastore, in GBs.
	CapacityGB *int64

	// Gets or sets Available space of this datastore, in GBs.
	FreeSpaceGB *int64

	// Gets or sets the tracked resource id corresponding to the inventory resource.
	ManagedResourceID *string

	// Gets or sets the vCenter Managed Object name for the inventory item.
	MoName *string

	// Gets or sets the MoRef (Managed Object Reference) ID for the inventory item.
	MoRefID *string

	// READ-ONLY; Gets the provisioning state.
	ProvisioningState *ProvisioningState
}

// GetInventoryItemProperties implements the InventoryItemPropertiesClassification interface for type DatastoreInventoryItem.
func (d *DatastoreInventoryItem) GetInventoryItemProperties() *InventoryItemProperties {
	return &InventoryItemProperties{
		InventoryType:     d.InventoryType,
		ManagedResourceID: d.ManagedResourceID,
		MoName:            d.MoName,
		MoRefID:           d.MoRefID,
		ProvisioningState: d.ProvisioningState,
	}
}

// DatastoreProperties - Describes the properties of a Datastore.
type DatastoreProperties struct {
	// Gets or sets the inventory Item ID for the datastore.
	InventoryItemID *string

	// Gets or sets the vCenter MoRef (Managed Object Reference) ID for the datastore.
	MoRefID *string

	// Gets or sets the ARM Id of the vCenter resource in which this datastore resides.
	VCenterID *string

	// READ-ONLY; Gets or sets Maximum capacity of this datastore in GBs.
	CapacityGB *int64

	// READ-ONLY; Gets the name of the corresponding resource in Kubernetes.
	CustomResourceName *string

	// READ-ONLY; Gets or sets Available space of this datastore in GBs.
	FreeSpaceGB *int64

	// READ-ONLY; Gets or sets the vCenter Managed Object name for the datastore.
	MoName *string

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The resource status information.
	Statuses []*ResourceStatus

	// READ-ONLY; Gets or sets a unique identifier for this resource.
	UUID *string
}

// DatastoresList - List of Datastores.
type DatastoresList struct {
	// REQUIRED; Array of Datastores
	Value []*Datastore

	// Url to follow for getting next page of Datastores.
	NextLink *string
}

// ExtendedLocation - The extended location.
type ExtendedLocation struct {
	// The extended location name.
	Name *string

	// The extended location type.
	Type *string
}

// GuestAgent - Defines the GuestAgent.
type GuestAgent struct {
	// REQUIRED; Resource properties.
	Properties *GuestAgentProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GuestAgentList - List of GuestAgent.
type GuestAgentList struct {
	// REQUIRED; Array of GuestAgent
	Value []*GuestAgent

	// Url to follow for getting next page of GuestAgent.
	NextLink *string
}

// GuestAgentProperties - Describes the properties of a Virtual Machine Guest Agent.
type GuestAgentProperties struct {
	// Username / Password Credentials to provision guest agent.
	Credentials *GuestCredential

	// HTTP Proxy configuration for the VM.
	HTTPProxyConfig *HTTPProxyConfiguration

	// The resource id of the private link scope this machine is assigned to, if any.
	PrivateLinkScopeResourceID *string

	// Gets or sets the guest agent provisioning action.
	ProvisioningAction *ProvisioningAction

	// READ-ONLY; Gets the name of the corresponding resource in Kubernetes.
	CustomResourceName *string

	// READ-ONLY; Gets the provisioning state.
	ProvisioningState *ProvisioningState

	// READ-ONLY; Gets or sets the guest agent status.
	Status *string

	// READ-ONLY; The resource status information.
	Statuses []*ResourceStatus

	// READ-ONLY; Gets or sets a unique identifier for this resource.
	UUID *string
}

// GuestCredential - Username / Password Credentials to connect to guest.
type GuestCredential struct {
	// Gets or sets the password to connect with the guest.
	Password *string

	// Gets or sets username to connect with the guest.
	Username *string
}

// HTTPProxyConfiguration - HTTP Proxy configuration for the VM.
type HTTPProxyConfiguration struct {
	// Gets or sets httpsProxy url.
	HTTPSProxy *string
}

// HardwareProfile - Specifies the hardware settings for the virtual machine.
type HardwareProfile struct {
	// Gets or sets memory size in MBs for the vm.
	MemorySizeMB *int32

	// Gets or sets the number of vCPUs for the vm.
	NumCPUs *int32

	// Gets or sets the number of cores per socket for the vm. Defaults to 1 if unspecified.
	NumCoresPerSocket *int32

	// READ-ONLY; Gets or sets a value indicating whether virtual processors can be added while this virtual machine is running.
	CPUHotAddEnabled *bool

	// READ-ONLY; Gets or sets a value indicating whether virtual processors can be removed while this virtual machine is running.
	CPUHotRemoveEnabled *bool

	// READ-ONLY; Gets or sets a value indicating whether memory can be added while this virtual machine is running.
	MemoryHotAddEnabled *bool
}

// Host - Define the host.
type Host struct {
	// REQUIRED; Gets or sets the location.
	Location *string

	// REQUIRED; Resource properties.
	Properties *HostProperties

	// Gets or sets the extended location.
	ExtendedLocation *ExtendedLocation

	// Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are
	// a kind of Microsoft.Web/sites type. If supported, the resource provider must
	// validate and persist this value.
	Kind *string

	// Gets or sets the Resource tags.
	Tags map[string]*string

	// READ-ONLY; Gets or sets the Id.
	ID *string

	// READ-ONLY; Gets or sets the name.
	Name *string

	// READ-ONLY; The system data.
	SystemData *SystemData

	// READ-ONLY; Gets or sets the type of the resource.
	Type *string
}

// HostInventoryItem - The host inventory item.
type HostInventoryItem struct {
	// REQUIRED; They inventory type.
	InventoryType *InventoryType

	// Gets or sets the tracked resource id corresponding to the inventory resource.
	ManagedResourceID *string

	// Gets or sets the vCenter Managed Object name for the inventory item.
	MoName *string

	// Gets or sets the MoRef (Managed Object Reference) ID for the inventory item.
	MoRefID *string

	// Parent host inventory resource details.
	Parent *InventoryItemDetails

	// READ-ONLY; Gets the provisioning state.
	ProvisioningState *ProvisioningState
}

// GetInventoryItemProperties implements the InventoryItemPropertiesClassification interface for type HostInventoryItem.
func (h *HostInventoryItem) GetInventoryItemProperties() *InventoryItemProperties {
	return &InventoryItemProperties{
		InventoryType:     h.InventoryType,
		ManagedResourceID: h.ManagedResourceID,
		MoName:            h.MoName,
		MoRefID:           h.MoRefID,
		ProvisioningState: h.ProvisioningState,
	}
}

// HostProperties - Describes the properties of a Host.
type HostProperties struct {
	// Gets or sets the inventory Item ID for the host.
	InventoryItemID *string

	// Gets or sets the vCenter MoRef (Managed Object Reference) ID for the host.
	MoRefID *string

	// Gets or sets the ARM Id of the vCenter resource in which this host resides.
	VCenterID *string

	// READ-ONLY; Gets the max CPU usage across all cores in MHz.
	CPUMhz *int64

	// READ-ONLY; Gets the name of the corresponding resource in Kubernetes.
	CustomResourceName *string

	// READ-ONLY; Gets the datastore ARM ids.
	DatastoreIDs []*string

	// READ-ONLY; Gets the total amount of physical memory on the host in GB.
	MemorySizeGB *int64

	// READ-ONLY; Gets or sets the vCenter Managed Object name for the host.
	MoName *string

	// READ-ONLY; Gets the network ARM ids.
	NetworkIDs []*string

	// READ-ONLY; Gets the used CPU usage across all cores in MHz.
	OverallCPUUsageMHz *int64

	// READ-ONLY; Gets the used physical memory on the host in GB.
	OverallMemoryUsageGB *int64

	// READ-ONLY; Gets the provisioning state.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The resource status information.
	Statuses []*ResourceStatus

	// READ-ONLY; Gets or sets a unique identifier for this resource.
	UUID *string
}

// HostsList - List of Hosts.
type HostsList struct {
	// REQUIRED; Array of Hosts
	Value []*Host

	// Url to follow for getting next page of Hosts.
	NextLink *string
}

// InfrastructureProfile - Specifies the vCenter infrastructure specific settings for the virtual machine.
type InfrastructureProfile struct {
	// Firmware type
	FirmwareType *FirmwareType

	// Gets or sets the inventory Item ID for the virtual machine.
	InventoryItemID *string

	// Gets or sets the SMBIOS UUID of the vm.
	SmbiosUUID *string

	// Gets or sets the ARM Id of the template resource to deploy the virtual machine.
	TemplateID *string

	// Gets or sets the ARM Id of the vCenter resource in which this resource pool resides.
	VCenterID *string

	// READ-ONLY; Gets the name of the corresponding resource in Kubernetes.
	CustomResourceName *string

	// READ-ONLY; Gets or sets the folder path of the vm.
	FolderPath *string

	// READ-ONLY; Gets or sets the instance uuid of the vm.
	InstanceUUID *string

	// READ-ONLY; Gets or sets the vCenter Managed Object name for the virtual machine.
	MoName *string

	// READ-ONLY; Gets or sets the vCenter MoRef (Managed Object Reference) ID for the virtual machine.
	MoRefID *string
}

// InventoryItem - Defines the inventory item.
type InventoryItem struct {
	// REQUIRED; Resource properties.
	Properties InventoryItemPropertiesClassification

	// Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are
	// a kind of Microsoft.Web/sites type. If supported, the resource provider must
	// validate and persist this value.
	Kind *string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// InventoryItemDetails - Describes the properties of an Inventory Item reference.
type InventoryItemDetails struct {
	// Gets or sets the inventory Item ID for the resource.
	InventoryItemID *string

	// The inventory type.
	InventoryType *InventoryType

	// Gets or sets the vCenter Managed Object name for the resource.
	MoName *string
}

// InventoryItemProperties - Describes the properties of an Inventory Item.
type InventoryItemProperties struct {
	// REQUIRED; They inventory type.
	InventoryType *InventoryType

	// Gets or sets the tracked resource id corresponding to the inventory resource.
	ManagedResourceID *string

	// Gets or sets the vCenter Managed Object name for the inventory item.
	MoName *string

	// Gets or sets the MoRef (Managed Object Reference) ID for the inventory item.
	MoRefID *string

	// READ-ONLY; Gets the provisioning state.
	ProvisioningState *ProvisioningState
}

// GetInventoryItemProperties implements the InventoryItemPropertiesClassification interface for type InventoryItemProperties.
func (i *InventoryItemProperties) GetInventoryItemProperties() *InventoryItemProperties { return i }

// InventoryItemsList - List of InventoryItems.
type InventoryItemsList struct {
	// REQUIRED; Array of InventoryItems
	Value []*InventoryItem

	// Url to follow for getting next page of InventoryItems.
	NextLink *string
}

// NetworkInterface - Network Interface model
type NetworkInterface struct {
	// Gets or sets the device key value.
	DeviceKey *int32

	// Gets or sets the ipsettings.
	IPSettings *NicIPSettings

	// Gets or sets the name of the network interface.
	Name *string

	// Gets or sets the ARM Id of the network resource to connect the virtual machine.
	NetworkID *string

	// NIC type
	NicType *NICType

	// Gets or sets the power on boot.
	PowerOnBoot *PowerOnBootOption

	// READ-ONLY; Gets or sets the nic ip addresses.
	IPAddresses []*string

	// READ-ONLY; Gets or sets the label of the virtual network in vCenter that the nic is connected to.
	Label *string

	// READ-ONLY; Gets or sets the NIC MAC address.
	MacAddress *string

	// READ-ONLY; Gets or sets the name of the virtual network in vCenter that the nic is connected to.
	NetworkMoName *string

	// READ-ONLY; Gets or sets the vCenter MoRef (Managed Object Reference) ID of the virtual network that the nic is connected
	// to.
	NetworkMoRefID *string
}

// NetworkInterfaceUpdate - Defines the network interface update.
type NetworkInterfaceUpdate struct {
	// Gets or sets the device key value.
	DeviceKey *int32

	// Gets or sets the name of the network interface.
	Name *string

	// Gets or sets the ARM Id of the network resource to connect the virtual machine.
	NetworkID *string

	// NIC type
	NicType *NICType

	// Gets or sets the power on boot.
	PowerOnBoot *PowerOnBootOption
}

// NetworkProfile - Specifies the network interfaces of the virtual machine.
type NetworkProfile struct {
	// Gets or sets the list of network interfaces associated with the virtual machine.
	NetworkInterfaces []*NetworkInterface
}

// NetworkProfileUpdate - Specifies the network interfaces of the virtual machine.
type NetworkProfileUpdate struct {
	// Gets or sets the list of network interfaces associated with the virtual machine.
	NetworkInterfaces []*NetworkInterfaceUpdate
}

// NicIPAddressSettings - IP address information for a virtual network adapter reported by the fabric.
type NicIPAddressSettings struct {
	// READ-ONLY; Gets the ip address allocation method.
	AllocationMethod *string

	// READ-ONLY; Gets the ip address for the nic.
	IPAddress *string

	// READ-ONLY; Gets the mask.
	SubnetMask *string
}

// NicIPSettings - Defines the network interface ip settings.
type NicIPSettings struct {
	// Gets or sets the nic allocation method.
	AllocationMethod *IPAddressAllocationMethod

	// Gets or sets the dns servers.
	DNSServers []*string

	// Gets or sets the gateway.
	Gateway []*string

	// Gets or sets the ip address for the nic.
	IPAddress *string

	// Gets or sets the mask.
	SubnetMask *string

	// READ-ONLY; Gets or sets the IP address information being reported for this NIC. This contains the same IPv4 information
	// above plus IPV6 information.
	IPAddressInfo []*NicIPAddressSettings

	// READ-ONLY; Gets or sets the primary server.
	PrimaryWinsServer *string

	// READ-ONLY; Gets or sets the secondary server.
	SecondaryWinsServer *string
}

// Operation provided by provider
type Operation struct {
	// Properties of the operation
	Display *OperationDisplay

	// Indicates whether the operation is data action or not.
	IsDataAction *bool

	// Name of the operation
	Name *string
}

// OperationDisplay - Properties of the operation
type OperationDisplay struct {
	// Description of the operation
	Description *string

	// Operation name
	Operation *string

	// Provider name
	Provider *string

	// Resource name
	Resource *string
}

// OperationsList - Lists the operations available.
type OperationsList struct {
	// REQUIRED; Array of operations
	Value []*Operation

	// Url to follow for getting next page of operations.
	NextLink *string
}

// OsProfileForVMInstance - Specifies the operating system settings for the virtual machine.
type OsProfileForVMInstance struct {
	// Sets administrator password.
	AdminPassword *string

	// Gets or sets administrator username.
	AdminUsername *string

	// Gets or sets computer name.
	ComputerName *string

	// Gets or sets the guestId.
	GuestID *string

	// Gets or sets the type of the os.
	OSType *OsType

	// READ-ONLY; Gets or sets os sku.
	OSSKU *string

	// READ-ONLY; Gets or sets the current running status of VMware Tools running in the guest operating system.
	ToolsRunningStatus *string

	// READ-ONLY; Gets or sets the current version of VMware Tools.
	ToolsVersion *string

	// READ-ONLY; Gets or sets the current version status of VMware Tools installed in the guest operating system.
	ToolsVersionStatus *string
}

// PlacementProfile - Specifies the compute and storage placement settings for the virtual machine.
type PlacementProfile struct {
	// Gets or sets the ARM Id of the cluster resource on which this virtual machine will deploy.
	ClusterID *string

	// Gets or sets the ARM Id of the datastore resource on which the data for the virtual machine will be kept.
	DatastoreID *string

	// Gets or sets the ARM Id of the host resource on which this virtual machine will deploy.
	HostID *string

	// Gets or sets the ARM Id of the resourcePool resource on which this virtual machine will deploy.
	ResourcePoolID *string
}

// ResourcePatch - Object containing updates for patch operations.
type ResourcePatch struct {
	// Resource tags.
	Tags map[string]*string
}

// ResourcePool - Define the resourcePool.
type ResourcePool struct {
	// REQUIRED; Gets or sets the location.
	Location *string

	// REQUIRED; Resource properties.
	Properties *ResourcePoolProperties

	// Gets or sets the extended location.
	ExtendedLocation *ExtendedLocation

	// Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are
	// a kind of Microsoft.Web/sites type. If supported, the resource provider must
	// validate and persist this value.
	Kind *string

	// Gets or sets the Resource tags.
	Tags map[string]*string

	// READ-ONLY; Gets or sets the Id.
	ID *string

	// READ-ONLY; Gets or sets the name.
	Name *string

	// READ-ONLY; The system data.
	SystemData *SystemData

	// READ-ONLY; Gets or sets the type of the resource.
	Type *string
}

// ResourcePoolInventoryItem - The resource pool inventory item.
type ResourcePoolInventoryItem struct {
	// REQUIRED; They inventory type.
	InventoryType *InventoryType

	// Gets or sets the tracked resource id corresponding to the inventory resource.
	ManagedResourceID *string

	// Gets or sets the vCenter Managed Object name for the inventory item.
	MoName *string

	// Gets or sets the MoRef (Managed Object Reference) ID for the inventory item.
	MoRefID *string

	// Parent resourcePool inventory resource details.
	Parent *InventoryItemDetails

	// READ-ONLY; Gets the provisioning state.
	ProvisioningState *ProvisioningState
}

// GetInventoryItemProperties implements the InventoryItemPropertiesClassification interface for type ResourcePoolInventoryItem.
func (r *ResourcePoolInventoryItem) GetInventoryItemProperties() *InventoryItemProperties {
	return &InventoryItemProperties{
		InventoryType:     r.InventoryType,
		ManagedResourceID: r.ManagedResourceID,
		MoName:            r.MoName,
		MoRefID:           r.MoRefID,
		ProvisioningState: r.ProvisioningState,
	}
}

// ResourcePoolProperties - Describes the properties of a Resource Pool.
type ResourcePoolProperties struct {
	// Gets or sets the inventory Item ID for the resource pool.
	InventoryItemID *string

	// Gets or sets the vCenter MoRef (Managed Object Reference) ID for the resource pool.
	MoRefID *string

	// Gets or sets the ARM Id of the vCenter resource in which this resource pool resides.
	VCenterID *string

	// READ-ONLY; Gets the max CPU usage across all cores on the pool in MHz.
	CPUCapacityMHz *int64

	// READ-ONLY; Gets or sets CPULimitMHz which specifies a CPU usage limit in MHz. Utilization will not exceed this limit even
	// if there are available resources.
	CPULimitMHz *int64

	// READ-ONLY; Gets the used CPU usage across all cores on the pool in MHz.
	CPUOverallUsageMHz *int64

	// READ-ONLY; Gets or sets CPUReservationMHz which specifies the CPU size in MHz that is guaranteed to be available.
	CPUReservationMHz *int64

	// READ-ONLY; Gets or sets CPUSharesLevel which specifies the CPU allocation level for this pool. This property is used in
	// relative allocation between resource consumers.
	CPUSharesLevel *string

	// READ-ONLY; Gets the name of the corresponding resource in Kubernetes.
	CustomResourceName *string

	// READ-ONLY; Gets the datastore ARM ids.
	DatastoreIDs []*string

	// READ-ONLY; Gets the total amount of physical memory on the pool in GB.
	MemCapacityGB *int64

	// READ-ONLY; Gets or sets MemLimitMB specifies a memory usage limit in megabytes. Utilization will not exceed the specified
	// limit even if there are available resources.
	MemLimitMB *int64

	// READ-ONLY; Gets the used physical memory on the pool in GB.
	MemOverallUsageGB *int64

	// READ-ONLY; Gets or sets MemReservationMB which specifies the guaranteed available memory in megabytes.
	MemReservationMB *int64

	// READ-ONLY; Gets or sets CPUSharesLevel which specifies the memory allocation level for this pool. This property is used
	// in relative allocation between resource consumers.
	MemSharesLevel *string

	// READ-ONLY; Gets or sets the vCenter Managed Object name for the resource pool.
	MoName *string

	// READ-ONLY; Gets the network ARM ids.
	NetworkIDs []*string

	// READ-ONLY; Gets the provisioning state.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The resource status information.
	Statuses []*ResourceStatus

	// READ-ONLY; Gets or sets a unique identifier for this resource.
	UUID *string
}

// ResourcePoolsList - List of ResourcePools.
type ResourcePoolsList struct {
	// REQUIRED; Array of ResourcePools
	Value []*ResourcePool

	// Url to follow for getting next page of ResourcePools.
	NextLink *string
}

// ResourceStatus - The resource status information.
type ResourceStatus struct {
	// READ-ONLY; The last update time for this condition.
	LastUpdatedAt *time.Time

	// READ-ONLY; A human readable message indicating details about the status.
	Message *string

	// READ-ONLY; The reason for the condition's status.
	Reason *string

	// READ-ONLY; Severity with which to treat failures of this type of condition.
	Severity *string

	// READ-ONLY; Status of the condition.
	Status *string

	// READ-ONLY; The type of the condition.
	Type *string
}

// SecurityProfile - Specifies the Security profile settings for the virtual machine.
type SecurityProfile struct {
	// Specifies the security settings like secure boot used while creating the virtual machine.
	UefiSettings *UefiSettings
}

// StopVirtualMachineOptions - Defines the stop action properties.
type StopVirtualMachineOptions struct {
	// Gets or sets a value indicating whether to request non-graceful VM shutdown. True value for this flag indicates non-graceful
	// shutdown whereas false indicates otherwise. Defaults to false.
	SkipShutdown *bool
}

// StorageProfile - Specifies the storage settings for the virtual machine disks.
type StorageProfile struct {
	// Gets or sets the list of virtual disks associated with the virtual machine.
	Disks []*VirtualDisk

	// READ-ONLY; Gets or sets the list of virtual SCSI controllers associated with the virtual machine.
	ScsiControllers []*VirtualSCSIController
}

// StorageProfileUpdate - Specifies the storage settings for the virtual machine disks.
type StorageProfileUpdate struct {
	// Gets or sets the list of virtual disks associated with the virtual machine.
	Disks []*VirtualDiskUpdate
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// UefiSettings - Specifies the security settings like secure boot used while creating the virtual machine.
type UefiSettings struct {
	// Specifies whether secure boot should be enabled on the virtual machine.
	SecureBootEnabled *bool
}

// VCenter - Defines the vCenter.
type VCenter struct {
	// REQUIRED; Gets or sets the location.
	Location *string

	// REQUIRED; Resource properties.
	Properties *VCenterProperties

	// Gets or sets the extended location.
	ExtendedLocation *ExtendedLocation

	// Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are
	// a kind of Microsoft.Web/sites type. If supported, the resource provider must
	// validate and persist this value.
	Kind *string

	// Gets or sets the Resource tags.
	Tags map[string]*string

	// READ-ONLY; Gets or sets the Id.
	ID *string

	// READ-ONLY; Gets or sets the name.
	Name *string

	// READ-ONLY; The system data.
	SystemData *SystemData

	// READ-ONLY; Gets or sets the type of the resource.
	Type *string
}

// VCenterProperties - Describes the properties of a VCenter.
type VCenterProperties struct {
	// REQUIRED; Gets or sets the FQDN/IPAddress of the vCenter.
	Fqdn *string

	// Username / Password Credentials to connect to vcenter.
	Credentials *VICredential

	// Gets or sets the port of the vCenter.
	Port *int32

	// READ-ONLY; Gets or sets the connection status to the vCenter.
	ConnectionStatus *string

	// READ-ONLY; Gets the name of the corresponding resource in Kubernetes.
	CustomResourceName *string

	// READ-ONLY; Gets or sets the instance UUID of the vCenter.
	InstanceUUID *string

	// READ-ONLY; Gets the provisioning state.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The resource status information.
	Statuses []*ResourceStatus

	// READ-ONLY; Gets or sets a unique identifier for this resource.
	UUID *string

	// READ-ONLY; Gets or sets the version of the vCenter.
	Version *string
}

// VCentersList - List of VCenters.
type VCentersList struct {
	// REQUIRED; Array of VCenters
	Value []*VCenter

	// Url to follow for getting next page of VCenters.
	NextLink *string
}

// VICredential - Username / Password Credentials to connect to vcenter.
type VICredential struct {
	// Gets or sets the password to connect with the vCenter.
	Password *string

	// Gets or sets username to connect with the vCenter.
	Username *string
}

// VMInstanceHybridIdentityMetadata - Defines the HybridIdentityMetadata.
type VMInstanceHybridIdentityMetadata struct {
	// REQUIRED; Resource properties.
	Properties *VMInstanceHybridIdentityMetadataProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// VMInstanceHybridIdentityMetadataList - List of HybridIdentityMetadata.
type VMInstanceHybridIdentityMetadataList struct {
	// REQUIRED; Array of HybridIdentityMetadata
	Value []*VMInstanceHybridIdentityMetadata

	// Url to follow for getting next page of HybridIdentityMetadata.
	NextLink *string
}

// VMInstanceHybridIdentityMetadataProperties - Describes the properties of Hybrid Identity Metadata for a Virtual Machine.
type VMInstanceHybridIdentityMetadataProperties struct {
	// Gets or sets the Public Key.
	PublicKey *string

	// The unique identifier for the resource.
	ResourceUID *string

	// READ-ONLY; Gets the provisioning state.
	ProvisioningState *ProvisioningState
}

// VirtualDisk - Virtual disk model
type VirtualDisk struct {
	// Gets or sets the controller id.
	ControllerKey *int32

	// Gets or sets the device key value.
	DeviceKey *int32

	// Gets or sets the device name.
	DeviceName *string

	// Gets or sets the disk mode.
	DiskMode *DiskMode

	// Gets or sets the disk total size.
	DiskSizeGB *int32

	// Gets or sets the disk backing type.
	DiskType *DiskType

	// Gets or sets the name of the virtual disk.
	Name *string

	// Gets or sets the unit number of the disk on the controller.
	UnitNumber *int32

	// READ-ONLY; Gets or sets the disk object id.
	DiskObjectID *string

	// READ-ONLY; Gets or sets the label of the virtual disk in vCenter.
	Label *string
}

// VirtualDiskUpdate - Defines the virtual disk update.
type VirtualDiskUpdate struct {
	// Gets or sets the controller id.
	ControllerKey *int32

	// Gets or sets the device key value.
	DeviceKey *int32

	// Gets or sets the device name.
	DeviceName *string

	// Gets or sets the disk mode.
	DiskMode *DiskMode

	// Gets or sets the disk total size.
	DiskSizeGB *int32

	// Gets or sets the disk backing type.
	DiskType *DiskType

	// Gets or sets the name of the virtual disk.
	Name *string

	// Gets or sets the unit number of the disk on the controller.
	UnitNumber *int32
}

// VirtualMachineInstance - Define the virtualMachineInstance.
type VirtualMachineInstance struct {
	// REQUIRED; Resource properties.
	Properties *VirtualMachineInstanceProperties

	// Gets or sets the extended location.
	ExtendedLocation *ExtendedLocation

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// VirtualMachineInstanceProperties - Describes the properties of a Virtual Machine Instance.
type VirtualMachineInstanceProperties struct {
	// Hardware properties.
	HardwareProfile *HardwareProfile

	// Gets the infrastructure profile.
	InfrastructureProfile *InfrastructureProfile

	// Network properties.
	NetworkProfile *NetworkProfile

	// OS properties.
	OSProfile *OsProfileForVMInstance

	// Placement properties.
	PlacementProfile *PlacementProfile

	// Gets the security profile.
	SecurityProfile *SecurityProfile

	// Storage properties.
	StorageProfile *StorageProfile

	// READ-ONLY; Gets the power state of the virtual machine.
	PowerState *string

	// READ-ONLY; Gets the provisioning state.
	ProvisioningState *ProvisioningState

	// READ-ONLY; Gets or sets a unique identifier for the vm resource.
	ResourceUID *string

	// READ-ONLY; The resource status information.
	Statuses []*ResourceStatus
}

// VirtualMachineInstanceUpdate - Defines the virtualMachineInstanceUpdate.
type VirtualMachineInstanceUpdate struct {
	// Resource properties.
	Properties *VirtualMachineInstanceUpdateProperties
}

// VirtualMachineInstanceUpdateProperties - Describes the properties of a Virtual Machine.
type VirtualMachineInstanceUpdateProperties struct {
	// Specifies the hardware settings for the virtual machine.
	HardwareProfile *HardwareProfile

	// Specifies the network interfaces of the virtual machine.
	NetworkProfile *NetworkProfileUpdate

	// Specifies the storage settings for the virtual machine disks.
	StorageProfile *StorageProfileUpdate
}

// VirtualMachineInstancesList - List of VirtualMachineInstances.
type VirtualMachineInstancesList struct {
	// REQUIRED; Array of VirtualMachines
	Value []*VirtualMachineInstance

	// Url to follow for getting next page of VirtualMachines.
	NextLink *string
}

// VirtualMachineInventoryItem - The VM inventory item.
type VirtualMachineInventoryItem struct {
	// REQUIRED; They inventory type.
	InventoryType *InventoryType

	// Cluster inventory resource details.
	Cluster *InventoryItemDetails

	// Gets or sets the folder path of the vm.
	FolderPath *string

	// Host inventory resource details.
	Host *InventoryItemDetails

	// Gets or sets the nic ip addresses.
	IPAddresses []*string

	// Gets or sets the instance uuid of the vm.
	InstanceUUID *string

	// Gets or sets the tracked resource id corresponding to the inventory resource.
	ManagedResourceID *string

	// Gets or sets the vCenter Managed Object name for the inventory item.
	MoName *string

	// Gets or sets the MoRef (Managed Object Reference) ID for the inventory item.
	MoRefID *string

	// Gets or sets os name.
	OSName *string

	// Gets or sets the type of the os.
	OSType *OsType

	// ResourcePool inventory resource details.
	ResourcePool *InventoryItemDetails

	// Gets or sets the SMBIOS UUID of the vm.
	SmbiosUUID *string

	// READ-ONLY; Gets the power state of the virtual machine.
	PowerState *string

	// READ-ONLY; Gets the provisioning state.
	ProvisioningState *ProvisioningState

	// READ-ONLY; Gets or sets the current running status of VMware Tools running in the guest operating system.
	ToolsRunningStatus *string

	// READ-ONLY; Gets or sets the current version of VMware Tools.
	ToolsVersion *string

	// READ-ONLY; Gets or sets the current version status of VMware Tools installed in the guest operating system.
	ToolsVersionStatus *string
}

// GetInventoryItemProperties implements the InventoryItemPropertiesClassification interface for type VirtualMachineInventoryItem.
func (v *VirtualMachineInventoryItem) GetInventoryItemProperties() *InventoryItemProperties {
	return &InventoryItemProperties{
		InventoryType:     v.InventoryType,
		ManagedResourceID: v.ManagedResourceID,
		MoName:            v.MoName,
		MoRefID:           v.MoRefID,
		ProvisioningState: v.ProvisioningState,
	}
}

// VirtualMachineTemplate - Define the virtualMachineTemplate.
type VirtualMachineTemplate struct {
	// REQUIRED; Gets or sets the location.
	Location *string

	// REQUIRED; Resource properties.
	Properties *VirtualMachineTemplateProperties

	// Gets or sets the extended location.
	ExtendedLocation *ExtendedLocation

	// Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are
	// a kind of Microsoft.Web/sites type. If supported, the resource provider must
	// validate and persist this value.
	Kind *string

	// Gets or sets the Resource tags.
	Tags map[string]*string

	// READ-ONLY; Gets or sets the Id.
	ID *string

	// READ-ONLY; Gets or sets the name.
	Name *string

	// READ-ONLY; The system data.
	SystemData *SystemData

	// READ-ONLY; Gets or sets the type of the resource.
	Type *string
}

// VirtualMachineTemplateInventoryItem - The VM Template inventory item.
type VirtualMachineTemplateInventoryItem struct {
	// REQUIRED; They inventory type.
	InventoryType *InventoryType

	// Gets or sets the folder path of the template.
	FolderPath *string

	// Gets or sets the tracked resource id corresponding to the inventory resource.
	ManagedResourceID *string

	// Gets or sets memory size in MBs for the template.
	MemorySizeMB *int32

	// Gets or sets the vCenter Managed Object name for the inventory item.
	MoName *string

	// Gets or sets the MoRef (Managed Object Reference) ID for the inventory item.
	MoRefID *string

	// Gets or sets the number of vCPUs for the template.
	NumCPUs *int32

	// Gets or sets the number of cores per socket for the template. Defaults to 1 if unspecified.
	NumCoresPerSocket *int32

	// Gets or sets os name.
	OSName *string

	// Gets or sets the type of the os.
	OSType *OsType

	// READ-ONLY; Gets the provisioning state.
	ProvisioningState *ProvisioningState

	// READ-ONLY; Gets or sets the current version of VMware Tools.
	ToolsVersion *string

	// READ-ONLY; Gets or sets the current version status of VMware Tools installed in the guest operating system.
	ToolsVersionStatus *string
}

// GetInventoryItemProperties implements the InventoryItemPropertiesClassification interface for type VirtualMachineTemplateInventoryItem.
func (v *VirtualMachineTemplateInventoryItem) GetInventoryItemProperties() *InventoryItemProperties {
	return &InventoryItemProperties{
		InventoryType:     v.InventoryType,
		ManagedResourceID: v.ManagedResourceID,
		MoName:            v.MoName,
		MoRefID:           v.MoRefID,
		ProvisioningState: v.ProvisioningState,
	}
}

// VirtualMachineTemplateProperties - Describes the properties of a Virtual Machine Template.
type VirtualMachineTemplateProperties struct {
	// Gets or sets the inventory Item ID for the virtual machine template.
	InventoryItemID *string

	// Gets or sets the vCenter MoRef (Managed Object Reference) ID for the virtual machine template.
	MoRefID *string

	// Gets or sets the ARM Id of the vCenter resource in which this template resides.
	VCenterID *string

	// READ-ONLY; Gets the name of the corresponding resource in Kubernetes.
	CustomResourceName *string

	// READ-ONLY; Gets or sets the disks the template.
	Disks []*VirtualDisk

	// READ-ONLY; Firmware type
	FirmwareType *FirmwareType

	// READ-ONLY; Gets or sets the folder path of the template.
	FolderPath *string

	// READ-ONLY; Gets or sets memory size in MBs for the template.
	MemorySizeMB *int32

	// READ-ONLY; Gets or sets the vCenter Managed Object name for the virtual machine template.
	MoName *string

	// READ-ONLY; Gets or sets the network interfaces of the template.
	NetworkInterfaces []*NetworkInterface

	// READ-ONLY; Gets or sets the number of vCPUs for the template.
	NumCPUs *int32

	// READ-ONLY; Gets or sets the number of cores per socket for the template. Defaults to 1 if unspecified.
	NumCoresPerSocket *int32

	// READ-ONLY; Gets or sets os name.
	OSName *string

	// READ-ONLY; Gets or sets the type of the os.
	OSType *OsType

	// READ-ONLY; Gets the provisioning state.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The resource status information.
	Statuses []*ResourceStatus

	// READ-ONLY; Gets or sets the current version of VMware Tools.
	ToolsVersion *string

	// READ-ONLY; Gets or sets the current version status of VMware Tools installed in the guest operating system.
	ToolsVersionStatus *string

	// READ-ONLY; Gets or sets a unique identifier for this resource.
	UUID *string
}

// VirtualMachineTemplatesList - List of VirtualMachineTemplates.
type VirtualMachineTemplatesList struct {
	// REQUIRED; Array of VirtualMachineTemplates
	Value []*VirtualMachineTemplate

	// Url to follow for getting next page of VirtualMachineTemplates.
	NextLink *string
}

// VirtualNetwork - Define the virtualNetwork.
type VirtualNetwork struct {
	// REQUIRED; Gets or sets the location.
	Location *string

	// REQUIRED; Resource properties.
	Properties *VirtualNetworkProperties

	// Gets or sets the extended location.
	ExtendedLocation *ExtendedLocation

	// Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are
	// a kind of Microsoft.Web/sites type. If supported, the resource provider must
	// validate and persist this value.
	Kind *string

	// Gets or sets the Resource tags.
	Tags map[string]*string

	// READ-ONLY; Gets or sets the Id.
	ID *string

	// READ-ONLY; Gets or sets the name.
	Name *string

	// READ-ONLY; The system data.
	SystemData *SystemData

	// READ-ONLY; Gets or sets the type of the resource.
	Type *string
}

// VirtualNetworkInventoryItem - The Virtual network inventory item.
type VirtualNetworkInventoryItem struct {
	// REQUIRED; They inventory type.
	InventoryType *InventoryType

	// Gets or sets the tracked resource id corresponding to the inventory resource.
	ManagedResourceID *string

	// Gets or sets the vCenter Managed Object name for the inventory item.
	MoName *string

	// Gets or sets the MoRef (Managed Object Reference) ID for the inventory item.
	MoRefID *string

	// READ-ONLY; Gets the provisioning state.
	ProvisioningState *ProvisioningState
}

// GetInventoryItemProperties implements the InventoryItemPropertiesClassification interface for type VirtualNetworkInventoryItem.
func (v *VirtualNetworkInventoryItem) GetInventoryItemProperties() *InventoryItemProperties {
	return &InventoryItemProperties{
		InventoryType:     v.InventoryType,
		ManagedResourceID: v.ManagedResourceID,
		MoName:            v.MoName,
		MoRefID:           v.MoRefID,
		ProvisioningState: v.ProvisioningState,
	}
}

// VirtualNetworkProperties - Describes the properties of a Virtual Network.
type VirtualNetworkProperties struct {
	// Gets or sets the inventory Item ID for the virtual network.
	InventoryItemID *string

	// Gets or sets the vCenter MoRef (Managed Object Reference) ID for the virtual network.
	MoRefID *string

	// Gets or sets the ARM Id of the vCenter resource in which this template resides.
	VCenterID *string

	// READ-ONLY; Gets the name of the corresponding resource in Kubernetes.
	CustomResourceName *string

	// READ-ONLY; Gets or sets the vCenter Managed Object name for the virtual network.
	MoName *string

	// READ-ONLY; Gets the provisioning state.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The resource status information.
	Statuses []*ResourceStatus

	// READ-ONLY; Gets or sets a unique identifier for this resource.
	UUID *string
}

// VirtualNetworksList - List of VirtualNetworks.
type VirtualNetworksList struct {
	// REQUIRED; Array of VirtualNetworks
	Value []*VirtualNetwork

	// Url to follow for getting next page of VirtualNetworks.
	NextLink *string
}

// VirtualSCSIController - This data object type contains the properties of a SCSI controller device attached to a virtual
// machine that is reported by the controller.
type VirtualSCSIController struct {
	// Gets or sets the bus number of the controller.
	BusNumber *int32

	// Gets or sets the key of the controller.
	ControllerKey *int32

	// Gets or sets the SCSI controller unit number.
	ScsiCtlrUnitNumber *int32

	// Gets or sets the sharing mode.
	Sharing *VirtualSCSISharing

	// Gets or sets the controller type.
	Type *SCSIControllerType
}
