//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/cognitiveservices/armcognitiveservices"
	"net/http"
	"net/url"
	"regexp"
)

// CommitmentPlansServer is a fake server for instances of the armcognitiveservices.CommitmentPlansClient type.
type CommitmentPlansServer struct {
	// CreateOrUpdate is the fake for method CommitmentPlansClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, accountName string, commitmentPlanName string, commitmentPlan armcognitiveservices.CommitmentPlan, options *armcognitiveservices.CommitmentPlansClientCreateOrUpdateOptions) (resp azfake.Responder[armcognitiveservices.CommitmentPlansClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdateAssociation is the fake for method CommitmentPlansClient.BeginCreateOrUpdateAssociation
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdateAssociation func(ctx context.Context, resourceGroupName string, commitmentPlanName string, commitmentPlanAssociationName string, association armcognitiveservices.CommitmentPlanAccountAssociation, options *armcognitiveservices.CommitmentPlansClientBeginCreateOrUpdateAssociationOptions) (resp azfake.PollerResponder[armcognitiveservices.CommitmentPlansClientCreateOrUpdateAssociationResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdatePlan is the fake for method CommitmentPlansClient.BeginCreateOrUpdatePlan
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdatePlan func(ctx context.Context, resourceGroupName string, commitmentPlanName string, commitmentPlan armcognitiveservices.CommitmentPlan, options *armcognitiveservices.CommitmentPlansClientBeginCreateOrUpdatePlanOptions) (resp azfake.PollerResponder[armcognitiveservices.CommitmentPlansClientCreateOrUpdatePlanResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method CommitmentPlansClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, accountName string, commitmentPlanName string, options *armcognitiveservices.CommitmentPlansClientBeginDeleteOptions) (resp azfake.PollerResponder[armcognitiveservices.CommitmentPlansClientDeleteResponse], errResp azfake.ErrorResponder)

	// BeginDeleteAssociation is the fake for method CommitmentPlansClient.BeginDeleteAssociation
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDeleteAssociation func(ctx context.Context, resourceGroupName string, commitmentPlanName string, commitmentPlanAssociationName string, options *armcognitiveservices.CommitmentPlansClientBeginDeleteAssociationOptions) (resp azfake.PollerResponder[armcognitiveservices.CommitmentPlansClientDeleteAssociationResponse], errResp azfake.ErrorResponder)

	// BeginDeletePlan is the fake for method CommitmentPlansClient.BeginDeletePlan
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDeletePlan func(ctx context.Context, resourceGroupName string, commitmentPlanName string, options *armcognitiveservices.CommitmentPlansClientBeginDeletePlanOptions) (resp azfake.PollerResponder[armcognitiveservices.CommitmentPlansClientDeletePlanResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method CommitmentPlansClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, accountName string, commitmentPlanName string, options *armcognitiveservices.CommitmentPlansClientGetOptions) (resp azfake.Responder[armcognitiveservices.CommitmentPlansClientGetResponse], errResp azfake.ErrorResponder)

	// GetAssociation is the fake for method CommitmentPlansClient.GetAssociation
	// HTTP status codes to indicate success: http.StatusOK
	GetAssociation func(ctx context.Context, resourceGroupName string, commitmentPlanName string, commitmentPlanAssociationName string, options *armcognitiveservices.CommitmentPlansClientGetAssociationOptions) (resp azfake.Responder[armcognitiveservices.CommitmentPlansClientGetAssociationResponse], errResp azfake.ErrorResponder)

	// GetPlan is the fake for method CommitmentPlansClient.GetPlan
	// HTTP status codes to indicate success: http.StatusOK
	GetPlan func(ctx context.Context, resourceGroupName string, commitmentPlanName string, options *armcognitiveservices.CommitmentPlansClientGetPlanOptions) (resp azfake.Responder[armcognitiveservices.CommitmentPlansClientGetPlanResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method CommitmentPlansClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, accountName string, options *armcognitiveservices.CommitmentPlansClientListOptions) (resp azfake.PagerResponder[armcognitiveservices.CommitmentPlansClientListResponse])

	// NewListAssociationsPager is the fake for method CommitmentPlansClient.NewListAssociationsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListAssociationsPager func(resourceGroupName string, commitmentPlanName string, options *armcognitiveservices.CommitmentPlansClientListAssociationsOptions) (resp azfake.PagerResponder[armcognitiveservices.CommitmentPlansClientListAssociationsResponse])

	// NewListPlansByResourceGroupPager is the fake for method CommitmentPlansClient.NewListPlansByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPlansByResourceGroupPager func(resourceGroupName string, options *armcognitiveservices.CommitmentPlansClientListPlansByResourceGroupOptions) (resp azfake.PagerResponder[armcognitiveservices.CommitmentPlansClientListPlansByResourceGroupResponse])

	// NewListPlansBySubscriptionPager is the fake for method CommitmentPlansClient.NewListPlansBySubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPlansBySubscriptionPager func(options *armcognitiveservices.CommitmentPlansClientListPlansBySubscriptionOptions) (resp azfake.PagerResponder[armcognitiveservices.CommitmentPlansClientListPlansBySubscriptionResponse])

	// BeginUpdatePlan is the fake for method CommitmentPlansClient.BeginUpdatePlan
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdatePlan func(ctx context.Context, resourceGroupName string, commitmentPlanName string, commitmentPlan armcognitiveservices.PatchResourceTagsAndSKU, options *armcognitiveservices.CommitmentPlansClientBeginUpdatePlanOptions) (resp azfake.PollerResponder[armcognitiveservices.CommitmentPlansClientUpdatePlanResponse], errResp azfake.ErrorResponder)
}

// NewCommitmentPlansServerTransport creates a new instance of CommitmentPlansServerTransport with the provided implementation.
// The returned CommitmentPlansServerTransport instance is connected to an instance of armcognitiveservices.CommitmentPlansClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewCommitmentPlansServerTransport(srv *CommitmentPlansServer) *CommitmentPlansServerTransport {
	return &CommitmentPlansServerTransport{
		srv:                              srv,
		beginCreateOrUpdateAssociation:   newTracker[azfake.PollerResponder[armcognitiveservices.CommitmentPlansClientCreateOrUpdateAssociationResponse]](),
		beginCreateOrUpdatePlan:          newTracker[azfake.PollerResponder[armcognitiveservices.CommitmentPlansClientCreateOrUpdatePlanResponse]](),
		beginDelete:                      newTracker[azfake.PollerResponder[armcognitiveservices.CommitmentPlansClientDeleteResponse]](),
		beginDeleteAssociation:           newTracker[azfake.PollerResponder[armcognitiveservices.CommitmentPlansClientDeleteAssociationResponse]](),
		beginDeletePlan:                  newTracker[azfake.PollerResponder[armcognitiveservices.CommitmentPlansClientDeletePlanResponse]](),
		newListPager:                     newTracker[azfake.PagerResponder[armcognitiveservices.CommitmentPlansClientListResponse]](),
		newListAssociationsPager:         newTracker[azfake.PagerResponder[armcognitiveservices.CommitmentPlansClientListAssociationsResponse]](),
		newListPlansByResourceGroupPager: newTracker[azfake.PagerResponder[armcognitiveservices.CommitmentPlansClientListPlansByResourceGroupResponse]](),
		newListPlansBySubscriptionPager:  newTracker[azfake.PagerResponder[armcognitiveservices.CommitmentPlansClientListPlansBySubscriptionResponse]](),
		beginUpdatePlan:                  newTracker[azfake.PollerResponder[armcognitiveservices.CommitmentPlansClientUpdatePlanResponse]](),
	}
}

// CommitmentPlansServerTransport connects instances of armcognitiveservices.CommitmentPlansClient to instances of CommitmentPlansServer.
// Don't use this type directly, use NewCommitmentPlansServerTransport instead.
type CommitmentPlansServerTransport struct {
	srv                              *CommitmentPlansServer
	beginCreateOrUpdateAssociation   *tracker[azfake.PollerResponder[armcognitiveservices.CommitmentPlansClientCreateOrUpdateAssociationResponse]]
	beginCreateOrUpdatePlan          *tracker[azfake.PollerResponder[armcognitiveservices.CommitmentPlansClientCreateOrUpdatePlanResponse]]
	beginDelete                      *tracker[azfake.PollerResponder[armcognitiveservices.CommitmentPlansClientDeleteResponse]]
	beginDeleteAssociation           *tracker[azfake.PollerResponder[armcognitiveservices.CommitmentPlansClientDeleteAssociationResponse]]
	beginDeletePlan                  *tracker[azfake.PollerResponder[armcognitiveservices.CommitmentPlansClientDeletePlanResponse]]
	newListPager                     *tracker[azfake.PagerResponder[armcognitiveservices.CommitmentPlansClientListResponse]]
	newListAssociationsPager         *tracker[azfake.PagerResponder[armcognitiveservices.CommitmentPlansClientListAssociationsResponse]]
	newListPlansByResourceGroupPager *tracker[azfake.PagerResponder[armcognitiveservices.CommitmentPlansClientListPlansByResourceGroupResponse]]
	newListPlansBySubscriptionPager  *tracker[azfake.PagerResponder[armcognitiveservices.CommitmentPlansClientListPlansBySubscriptionResponse]]
	beginUpdatePlan                  *tracker[azfake.PollerResponder[armcognitiveservices.CommitmentPlansClientUpdatePlanResponse]]
}

// Do implements the policy.Transporter interface for CommitmentPlansServerTransport.
func (c *CommitmentPlansServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "CommitmentPlansClient.CreateOrUpdate":
		resp, err = c.dispatchCreateOrUpdate(req)
	case "CommitmentPlansClient.BeginCreateOrUpdateAssociation":
		resp, err = c.dispatchBeginCreateOrUpdateAssociation(req)
	case "CommitmentPlansClient.BeginCreateOrUpdatePlan":
		resp, err = c.dispatchBeginCreateOrUpdatePlan(req)
	case "CommitmentPlansClient.BeginDelete":
		resp, err = c.dispatchBeginDelete(req)
	case "CommitmentPlansClient.BeginDeleteAssociation":
		resp, err = c.dispatchBeginDeleteAssociation(req)
	case "CommitmentPlansClient.BeginDeletePlan":
		resp, err = c.dispatchBeginDeletePlan(req)
	case "CommitmentPlansClient.Get":
		resp, err = c.dispatchGet(req)
	case "CommitmentPlansClient.GetAssociation":
		resp, err = c.dispatchGetAssociation(req)
	case "CommitmentPlansClient.GetPlan":
		resp, err = c.dispatchGetPlan(req)
	case "CommitmentPlansClient.NewListPager":
		resp, err = c.dispatchNewListPager(req)
	case "CommitmentPlansClient.NewListAssociationsPager":
		resp, err = c.dispatchNewListAssociationsPager(req)
	case "CommitmentPlansClient.NewListPlansByResourceGroupPager":
		resp, err = c.dispatchNewListPlansByResourceGroupPager(req)
	case "CommitmentPlansClient.NewListPlansBySubscriptionPager":
		resp, err = c.dispatchNewListPlansBySubscriptionPager(req)
	case "CommitmentPlansClient.BeginUpdatePlan":
		resp, err = c.dispatchBeginUpdatePlan(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *CommitmentPlansServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if c.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CognitiveServices/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/commitmentPlans/(?P<commitmentPlanName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armcognitiveservices.CommitmentPlan](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	commitmentPlanNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("commitmentPlanName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, accountNameParam, commitmentPlanNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CommitmentPlan, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CommitmentPlansServerTransport) dispatchBeginCreateOrUpdateAssociation(req *http.Request) (*http.Response, error) {
	if c.srv.BeginCreateOrUpdateAssociation == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdateAssociation not implemented")}
	}
	beginCreateOrUpdateAssociation := c.beginCreateOrUpdateAssociation.get(req)
	if beginCreateOrUpdateAssociation == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CognitiveServices/commitmentPlans/(?P<commitmentPlanName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/accountAssociations/(?P<commitmentPlanAssociationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcognitiveservices.CommitmentPlanAccountAssociation](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		commitmentPlanNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("commitmentPlanName")])
		if err != nil {
			return nil, err
		}
		commitmentPlanAssociationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("commitmentPlanAssociationName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginCreateOrUpdateAssociation(req.Context(), resourceGroupNameParam, commitmentPlanNameParam, commitmentPlanAssociationNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdateAssociation = &respr
		c.beginCreateOrUpdateAssociation.add(req, beginCreateOrUpdateAssociation)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdateAssociation, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		c.beginCreateOrUpdateAssociation.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdateAssociation) {
		c.beginCreateOrUpdateAssociation.remove(req)
	}

	return resp, nil
}

func (c *CommitmentPlansServerTransport) dispatchBeginCreateOrUpdatePlan(req *http.Request) (*http.Response, error) {
	if c.srv.BeginCreateOrUpdatePlan == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdatePlan not implemented")}
	}
	beginCreateOrUpdatePlan := c.beginCreateOrUpdatePlan.get(req)
	if beginCreateOrUpdatePlan == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CognitiveServices/commitmentPlans/(?P<commitmentPlanName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcognitiveservices.CommitmentPlan](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		commitmentPlanNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("commitmentPlanName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginCreateOrUpdatePlan(req.Context(), resourceGroupNameParam, commitmentPlanNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdatePlan = &respr
		c.beginCreateOrUpdatePlan.add(req, beginCreateOrUpdatePlan)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdatePlan, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		c.beginCreateOrUpdatePlan.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdatePlan) {
		c.beginCreateOrUpdatePlan.remove(req)
	}

	return resp, nil
}

func (c *CommitmentPlansServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if c.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := c.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CognitiveServices/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/commitmentPlans/(?P<commitmentPlanName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		commitmentPlanNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("commitmentPlanName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginDelete(req.Context(), resourceGroupNameParam, accountNameParam, commitmentPlanNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		c.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		c.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		c.beginDelete.remove(req)
	}

	return resp, nil
}

func (c *CommitmentPlansServerTransport) dispatchBeginDeleteAssociation(req *http.Request) (*http.Response, error) {
	if c.srv.BeginDeleteAssociation == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeleteAssociation not implemented")}
	}
	beginDeleteAssociation := c.beginDeleteAssociation.get(req)
	if beginDeleteAssociation == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CognitiveServices/commitmentPlans/(?P<commitmentPlanName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/accountAssociations/(?P<commitmentPlanAssociationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		commitmentPlanNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("commitmentPlanName")])
		if err != nil {
			return nil, err
		}
		commitmentPlanAssociationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("commitmentPlanAssociationName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginDeleteAssociation(req.Context(), resourceGroupNameParam, commitmentPlanNameParam, commitmentPlanAssociationNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeleteAssociation = &respr
		c.beginDeleteAssociation.add(req, beginDeleteAssociation)
	}

	resp, err := server.PollerResponderNext(beginDeleteAssociation, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		c.beginDeleteAssociation.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeleteAssociation) {
		c.beginDeleteAssociation.remove(req)
	}

	return resp, nil
}

func (c *CommitmentPlansServerTransport) dispatchBeginDeletePlan(req *http.Request) (*http.Response, error) {
	if c.srv.BeginDeletePlan == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeletePlan not implemented")}
	}
	beginDeletePlan := c.beginDeletePlan.get(req)
	if beginDeletePlan == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CognitiveServices/commitmentPlans/(?P<commitmentPlanName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		commitmentPlanNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("commitmentPlanName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginDeletePlan(req.Context(), resourceGroupNameParam, commitmentPlanNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeletePlan = &respr
		c.beginDeletePlan.add(req, beginDeletePlan)
	}

	resp, err := server.PollerResponderNext(beginDeletePlan, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		c.beginDeletePlan.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeletePlan) {
		c.beginDeletePlan.remove(req)
	}

	return resp, nil
}

func (c *CommitmentPlansServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if c.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CognitiveServices/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/commitmentPlans/(?P<commitmentPlanName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	commitmentPlanNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("commitmentPlanName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Get(req.Context(), resourceGroupNameParam, accountNameParam, commitmentPlanNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CommitmentPlan, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CommitmentPlansServerTransport) dispatchGetAssociation(req *http.Request) (*http.Response, error) {
	if c.srv.GetAssociation == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetAssociation not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CognitiveServices/commitmentPlans/(?P<commitmentPlanName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/accountAssociations/(?P<commitmentPlanAssociationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	commitmentPlanNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("commitmentPlanName")])
	if err != nil {
		return nil, err
	}
	commitmentPlanAssociationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("commitmentPlanAssociationName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.GetAssociation(req.Context(), resourceGroupNameParam, commitmentPlanNameParam, commitmentPlanAssociationNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CommitmentPlanAccountAssociation, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CommitmentPlansServerTransport) dispatchGetPlan(req *http.Request) (*http.Response, error) {
	if c.srv.GetPlan == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetPlan not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CognitiveServices/commitmentPlans/(?P<commitmentPlanName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	commitmentPlanNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("commitmentPlanName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.GetPlan(req.Context(), resourceGroupNameParam, commitmentPlanNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CommitmentPlan, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CommitmentPlansServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := c.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CognitiveServices/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/commitmentPlans`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		resp := c.srv.NewListPager(resourceGroupNameParam, accountNameParam, nil)
		newListPager = &resp
		c.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armcognitiveservices.CommitmentPlansClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		c.newListPager.remove(req)
	}
	return resp, nil
}

func (c *CommitmentPlansServerTransport) dispatchNewListAssociationsPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListAssociationsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListAssociationsPager not implemented")}
	}
	newListAssociationsPager := c.newListAssociationsPager.get(req)
	if newListAssociationsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CognitiveServices/commitmentPlans/(?P<commitmentPlanName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/accountAssociations`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		commitmentPlanNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("commitmentPlanName")])
		if err != nil {
			return nil, err
		}
		resp := c.srv.NewListAssociationsPager(resourceGroupNameParam, commitmentPlanNameParam, nil)
		newListAssociationsPager = &resp
		c.newListAssociationsPager.add(req, newListAssociationsPager)
		server.PagerResponderInjectNextLinks(newListAssociationsPager, req, func(page *armcognitiveservices.CommitmentPlansClientListAssociationsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListAssociationsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListAssociationsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListAssociationsPager) {
		c.newListAssociationsPager.remove(req)
	}
	return resp, nil
}

func (c *CommitmentPlansServerTransport) dispatchNewListPlansByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListPlansByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPlansByResourceGroupPager not implemented")}
	}
	newListPlansByResourceGroupPager := c.newListPlansByResourceGroupPager.get(req)
	if newListPlansByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CognitiveServices/commitmentPlans`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := c.srv.NewListPlansByResourceGroupPager(resourceGroupNameParam, nil)
		newListPlansByResourceGroupPager = &resp
		c.newListPlansByResourceGroupPager.add(req, newListPlansByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListPlansByResourceGroupPager, req, func(page *armcognitiveservices.CommitmentPlansClientListPlansByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPlansByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListPlansByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPlansByResourceGroupPager) {
		c.newListPlansByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (c *CommitmentPlansServerTransport) dispatchNewListPlansBySubscriptionPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListPlansBySubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPlansBySubscriptionPager not implemented")}
	}
	newListPlansBySubscriptionPager := c.newListPlansBySubscriptionPager.get(req)
	if newListPlansBySubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CognitiveServices/commitmentPlans`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := c.srv.NewListPlansBySubscriptionPager(nil)
		newListPlansBySubscriptionPager = &resp
		c.newListPlansBySubscriptionPager.add(req, newListPlansBySubscriptionPager)
		server.PagerResponderInjectNextLinks(newListPlansBySubscriptionPager, req, func(page *armcognitiveservices.CommitmentPlansClientListPlansBySubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPlansBySubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListPlansBySubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPlansBySubscriptionPager) {
		c.newListPlansBySubscriptionPager.remove(req)
	}
	return resp, nil
}

func (c *CommitmentPlansServerTransport) dispatchBeginUpdatePlan(req *http.Request) (*http.Response, error) {
	if c.srv.BeginUpdatePlan == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdatePlan not implemented")}
	}
	beginUpdatePlan := c.beginUpdatePlan.get(req)
	if beginUpdatePlan == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CognitiveServices/commitmentPlans/(?P<commitmentPlanName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcognitiveservices.PatchResourceTagsAndSKU](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		commitmentPlanNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("commitmentPlanName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginUpdatePlan(req.Context(), resourceGroupNameParam, commitmentPlanNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdatePlan = &respr
		c.beginUpdatePlan.add(req, beginUpdatePlan)
	}

	resp, err := server.PollerResponderNext(beginUpdatePlan, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		c.beginUpdatePlan.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdatePlan) {
		c.beginUpdatePlan.remove(req)
	}

	return resp, nil
}
