//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/appcontainers/armappcontainers/v3"
	"net/http"
	"net/url"
	"regexp"
)

// ContainerAppsSourceControlsServer is a fake server for instances of the armappcontainers.ContainerAppsSourceControlsClient type.
type ContainerAppsSourceControlsServer struct {
	// BeginCreateOrUpdate is the fake for method ContainerAppsSourceControlsClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, containerAppName string, sourceControlName string, sourceControlEnvelope armappcontainers.SourceControl, options *armappcontainers.ContainerAppsSourceControlsClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armappcontainers.ContainerAppsSourceControlsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method ContainerAppsSourceControlsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, containerAppName string, sourceControlName string, options *armappcontainers.ContainerAppsSourceControlsClientBeginDeleteOptions) (resp azfake.PollerResponder[armappcontainers.ContainerAppsSourceControlsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ContainerAppsSourceControlsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, containerAppName string, sourceControlName string, options *armappcontainers.ContainerAppsSourceControlsClientGetOptions) (resp azfake.Responder[armappcontainers.ContainerAppsSourceControlsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByContainerAppPager is the fake for method ContainerAppsSourceControlsClient.NewListByContainerAppPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByContainerAppPager func(resourceGroupName string, containerAppName string, options *armappcontainers.ContainerAppsSourceControlsClientListByContainerAppOptions) (resp azfake.PagerResponder[armappcontainers.ContainerAppsSourceControlsClientListByContainerAppResponse])
}

// NewContainerAppsSourceControlsServerTransport creates a new instance of ContainerAppsSourceControlsServerTransport with the provided implementation.
// The returned ContainerAppsSourceControlsServerTransport instance is connected to an instance of armappcontainers.ContainerAppsSourceControlsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewContainerAppsSourceControlsServerTransport(srv *ContainerAppsSourceControlsServer) *ContainerAppsSourceControlsServerTransport {
	return &ContainerAppsSourceControlsServerTransport{
		srv:                        srv,
		beginCreateOrUpdate:        newTracker[azfake.PollerResponder[armappcontainers.ContainerAppsSourceControlsClientCreateOrUpdateResponse]](),
		beginDelete:                newTracker[azfake.PollerResponder[armappcontainers.ContainerAppsSourceControlsClientDeleteResponse]](),
		newListByContainerAppPager: newTracker[azfake.PagerResponder[armappcontainers.ContainerAppsSourceControlsClientListByContainerAppResponse]](),
	}
}

// ContainerAppsSourceControlsServerTransport connects instances of armappcontainers.ContainerAppsSourceControlsClient to instances of ContainerAppsSourceControlsServer.
// Don't use this type directly, use NewContainerAppsSourceControlsServerTransport instead.
type ContainerAppsSourceControlsServerTransport struct {
	srv                        *ContainerAppsSourceControlsServer
	beginCreateOrUpdate        *tracker[azfake.PollerResponder[armappcontainers.ContainerAppsSourceControlsClientCreateOrUpdateResponse]]
	beginDelete                *tracker[azfake.PollerResponder[armappcontainers.ContainerAppsSourceControlsClientDeleteResponse]]
	newListByContainerAppPager *tracker[azfake.PagerResponder[armappcontainers.ContainerAppsSourceControlsClientListByContainerAppResponse]]
}

// Do implements the policy.Transporter interface for ContainerAppsSourceControlsServerTransport.
func (c *ContainerAppsSourceControlsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ContainerAppsSourceControlsClient.BeginCreateOrUpdate":
		resp, err = c.dispatchBeginCreateOrUpdate(req)
	case "ContainerAppsSourceControlsClient.BeginDelete":
		resp, err = c.dispatchBeginDelete(req)
	case "ContainerAppsSourceControlsClient.Get":
		resp, err = c.dispatchGet(req)
	case "ContainerAppsSourceControlsClient.NewListByContainerAppPager":
		resp, err = c.dispatchNewListByContainerAppPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *ContainerAppsSourceControlsServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if c.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := c.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.App/containerApps/(?P<containerAppName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sourcecontrols/(?P<sourceControlName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappcontainers.SourceControl](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		containerAppNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("containerAppName")])
		if err != nil {
			return nil, err
		}
		sourceControlNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sourceControlName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, containerAppNameParam, sourceControlNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		c.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		c.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		c.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (c *ContainerAppsSourceControlsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if c.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := c.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.App/containerApps/(?P<containerAppName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sourcecontrols/(?P<sourceControlName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		containerAppNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("containerAppName")])
		if err != nil {
			return nil, err
		}
		sourceControlNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sourceControlName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginDelete(req.Context(), resourceGroupNameParam, containerAppNameParam, sourceControlNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		c.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		c.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		c.beginDelete.remove(req)
	}

	return resp, nil
}

func (c *ContainerAppsSourceControlsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if c.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.App/containerApps/(?P<containerAppName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sourcecontrols/(?P<sourceControlName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	containerAppNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("containerAppName")])
	if err != nil {
		return nil, err
	}
	sourceControlNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sourceControlName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Get(req.Context(), resourceGroupNameParam, containerAppNameParam, sourceControlNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SourceControl, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *ContainerAppsSourceControlsServerTransport) dispatchNewListByContainerAppPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListByContainerAppPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByContainerAppPager not implemented")}
	}
	newListByContainerAppPager := c.newListByContainerAppPager.get(req)
	if newListByContainerAppPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.App/containerApps/(?P<containerAppName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sourcecontrols`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		containerAppNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("containerAppName")])
		if err != nil {
			return nil, err
		}
		resp := c.srv.NewListByContainerAppPager(resourceGroupNameParam, containerAppNameParam, nil)
		newListByContainerAppPager = &resp
		c.newListByContainerAppPager.add(req, newListByContainerAppPager)
		server.PagerResponderInjectNextLinks(newListByContainerAppPager, req, func(page *armappcontainers.ContainerAppsSourceControlsClientListByContainerAppResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByContainerAppPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListByContainerAppPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByContainerAppPager) {
		c.newListByContainerAppPager.remove(req)
	}
	return resp, nil
}
