//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armcontainerservice

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AccessProfile.
func (a AccessProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateByteArray(objectMap, "kubeConfig", a.KubeConfig, runtime.Base64StdFormat)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessProfile.
func (a *AccessProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kubeConfig":
			err = runtime.DecodeByteArray(string(val), &a.KubeConfig, runtime.Base64StdFormat)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentPool.
func (a AgentPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentPool.
func (a *AgentPool) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentPoolAvailableVersions.
func (a AgentPoolAvailableVersions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentPoolAvailableVersions.
func (a *AgentPoolAvailableVersions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentPoolAvailableVersionsProperties.
func (a AgentPoolAvailableVersionsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "agentPoolVersions", a.AgentPoolVersions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentPoolAvailableVersionsProperties.
func (a *AgentPoolAvailableVersionsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentPoolVersions":
			err = unpopulate(val, "AgentPoolVersions", &a.AgentPoolVersions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem.
func (a AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "default", a.Default)
	populate(objectMap, "isPreview", a.IsPreview)
	populate(objectMap, "kubernetesVersion", a.KubernetesVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem.
func (a *AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "default":
			err = unpopulate(val, "Default", &a.Default)
			delete(rawMsg, key)
		case "isPreview":
			err = unpopulate(val, "IsPreview", &a.IsPreview)
			delete(rawMsg, key)
		case "kubernetesVersion":
			err = unpopulate(val, "KubernetesVersion", &a.KubernetesVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentPoolListResult.
func (a AgentPoolListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentPoolListResult.
func (a *AgentPoolListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentPoolProfile.
func (a AgentPoolProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", a.Count)
	populate(objectMap, "dnsPrefix", a.DNSPrefix)
	populate(objectMap, "fqdn", a.Fqdn)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "osDiskSizeGB", a.OSDiskSizeGB)
	populate(objectMap, "osType", a.OSType)
	populate(objectMap, "ports", a.Ports)
	populate(objectMap, "storageProfile", a.StorageProfile)
	populate(objectMap, "vmSize", a.VMSize)
	populate(objectMap, "vnetSubnetID", a.VnetSubnetID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentPoolProfile.
func (a *AgentPoolProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &a.Count)
			delete(rawMsg, key)
		case "dnsPrefix":
			err = unpopulate(val, "DNSPrefix", &a.DNSPrefix)
			delete(rawMsg, key)
		case "fqdn":
			err = unpopulate(val, "Fqdn", &a.Fqdn)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "osDiskSizeGB":
			err = unpopulate(val, "OSDiskSizeGB", &a.OSDiskSizeGB)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &a.OSType)
			delete(rawMsg, key)
		case "ports":
			err = unpopulate(val, "Ports", &a.Ports)
			delete(rawMsg, key)
		case "storageProfile":
			err = unpopulate(val, "StorageProfile", &a.StorageProfile)
			delete(rawMsg, key)
		case "vmSize":
			err = unpopulate(val, "VMSize", &a.VMSize)
			delete(rawMsg, key)
		case "vnetSubnetID":
			err = unpopulate(val, "VnetSubnetID", &a.VnetSubnetID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentPoolUpgradeProfile.
func (a AgentPoolUpgradeProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentPoolUpgradeProfile.
func (a *AgentPoolUpgradeProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentPoolUpgradeProfileProperties.
func (a AgentPoolUpgradeProfileProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "kubernetesVersion", a.KubernetesVersion)
	populate(objectMap, "latestNodeImageVersion", a.LatestNodeImageVersion)
	populate(objectMap, "osType", a.OSType)
	populate(objectMap, "upgrades", a.Upgrades)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentPoolUpgradeProfileProperties.
func (a *AgentPoolUpgradeProfileProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kubernetesVersion":
			err = unpopulate(val, "KubernetesVersion", &a.KubernetesVersion)
			delete(rawMsg, key)
		case "latestNodeImageVersion":
			err = unpopulate(val, "LatestNodeImageVersion", &a.LatestNodeImageVersion)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &a.OSType)
			delete(rawMsg, key)
		case "upgrades":
			err = unpopulate(val, "Upgrades", &a.Upgrades)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentPoolUpgradeProfilePropertiesUpgradesItem.
func (a AgentPoolUpgradeProfilePropertiesUpgradesItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "isPreview", a.IsPreview)
	populate(objectMap, "kubernetesVersion", a.KubernetesVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentPoolUpgradeProfilePropertiesUpgradesItem.
func (a *AgentPoolUpgradeProfilePropertiesUpgradesItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isPreview":
			err = unpopulate(val, "IsPreview", &a.IsPreview)
			delete(rawMsg, key)
		case "kubernetesVersion":
			err = unpopulate(val, "KubernetesVersion", &a.KubernetesVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentPoolUpgradeSettings.
func (a AgentPoolUpgradeSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "maxSurge", a.MaxSurge)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentPoolUpgradeSettings.
func (a *AgentPoolUpgradeSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "maxSurge":
			err = unpopulate(val, "MaxSurge", &a.MaxSurge)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BasicOrchestratorProfile.
func (b BasicOrchestratorProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "orchestratorType", b.OrchestratorType)
	populate(objectMap, "orchestratorVersion", b.OrchestratorVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BasicOrchestratorProfile.
func (b *BasicOrchestratorProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "orchestratorType":
			err = unpopulate(val, "OrchestratorType", &b.OrchestratorType)
			delete(rawMsg, key)
		case "orchestratorVersion":
			err = unpopulate(val, "OrchestratorVersion", &b.OrchestratorVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudError.
func (c CloudError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", c.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudError.
func (c *CloudError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &c.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudErrorBody.
func (c CloudErrorBody) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", c.Code)
	populate(objectMap, "details", c.Details)
	populate(objectMap, "message", c.Message)
	populate(objectMap, "target", c.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudErrorBody.
func (c *CloudErrorBody) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &c.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &c.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &c.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &c.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Components1Q1Og48SchemasManagedclusterAllof1.
func (c Components1Q1Og48SchemasManagedclusterAllof1) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identity", c.Identity)
	populate(objectMap, "properties", c.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Components1Q1Og48SchemasManagedclusterAllof1.
func (c *Components1Q1Og48SchemasManagedclusterAllof1) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identity":
			err = unpopulate(val, "Identity", &c.Identity)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Components1Umhcm8SchemasManagedclusteridentityPropertiesUserassignedidentitiesAdditionalproperties.
func (c Components1Umhcm8SchemasManagedclusteridentityPropertiesUserassignedidentitiesAdditionalproperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", c.ClientID)
	populate(objectMap, "principalId", c.PrincipalID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Components1Umhcm8SchemasManagedclusteridentityPropertiesUserassignedidentitiesAdditionalproperties.
func (c *Components1Umhcm8SchemasManagedclusteridentityPropertiesUserassignedidentitiesAdditionalproperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &c.ClientID)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &c.PrincipalID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComponentsQit0EtSchemasManagedclusterpropertiesPropertiesIdentityprofileAdditionalproperties.
func (c ComponentsQit0EtSchemasManagedclusterpropertiesPropertiesIdentityprofileAdditionalproperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", c.ClientID)
	populate(objectMap, "objectId", c.ObjectID)
	populate(objectMap, "resourceId", c.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComponentsQit0EtSchemasManagedclusterpropertiesPropertiesIdentityprofileAdditionalproperties.
func (c *ComponentsQit0EtSchemasManagedclusterpropertiesPropertiesIdentityprofileAdditionalproperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &c.ClientID)
			delete(rawMsg, key)
		case "objectId":
			err = unpopulate(val, "ObjectID", &c.ObjectID)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &c.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerService.
func (c ContainerService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerService.
func (c *ContainerService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CredentialResult.
func (c CredentialResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", c.Name)
	populateByteArray(objectMap, "value", c.Value, runtime.Base64StdFormat)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CredentialResult.
func (c *CredentialResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "value":
			err = runtime.DecodeByteArray(string(val), &c.Value, runtime.Base64StdFormat)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CredentialResults.
func (c CredentialResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "kubeconfigs", c.Kubeconfigs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CredentialResults.
func (c *CredentialResults) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kubeconfigs":
			err = unpopulate(val, "Kubeconfigs", &c.Kubeconfigs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomProfile.
func (c CustomProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "orchestrator", c.Orchestrator)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomProfile.
func (c *CustomProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "orchestrator":
			err = unpopulate(val, "Orchestrator", &c.Orchestrator)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnosticsProfile.
func (d DiagnosticsProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "vmDiagnostics", d.VMDiagnostics)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnosticsProfile.
func (d *DiagnosticsProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "vmDiagnostics":
			err = unpopulate(val, "VMDiagnostics", &d.VMDiagnostics)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyVaultSecretRef.
func (k KeyVaultSecretRef) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "secretName", k.SecretName)
	populate(objectMap, "vaultID", k.VaultID)
	populate(objectMap, "version", k.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVaultSecretRef.
func (k *KeyVaultSecretRef) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "secretName":
			err = unpopulate(val, "SecretName", &k.SecretName)
			delete(rawMsg, key)
		case "vaultID":
			err = unpopulate(val, "VaultID", &k.VaultID)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &k.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KubeletConfig.
func (k KubeletConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedUnsafeSysctls", k.AllowedUnsafeSysctls)
	populate(objectMap, "cpuCfsQuota", k.CPUCfsQuota)
	populate(objectMap, "cpuCfsQuotaPeriod", k.CPUCfsQuotaPeriod)
	populate(objectMap, "cpuManagerPolicy", k.CPUManagerPolicy)
	populate(objectMap, "failSwapOn", k.FailSwapOn)
	populate(objectMap, "imageGcHighThreshold", k.ImageGcHighThreshold)
	populate(objectMap, "imageGcLowThreshold", k.ImageGcLowThreshold)
	populate(objectMap, "topologyManagerPolicy", k.TopologyManagerPolicy)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KubeletConfig.
func (k *KubeletConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedUnsafeSysctls":
			err = unpopulate(val, "AllowedUnsafeSysctls", &k.AllowedUnsafeSysctls)
			delete(rawMsg, key)
		case "cpuCfsQuota":
			err = unpopulate(val, "CPUCfsQuota", &k.CPUCfsQuota)
			delete(rawMsg, key)
		case "cpuCfsQuotaPeriod":
			err = unpopulate(val, "CPUCfsQuotaPeriod", &k.CPUCfsQuotaPeriod)
			delete(rawMsg, key)
		case "cpuManagerPolicy":
			err = unpopulate(val, "CPUManagerPolicy", &k.CPUManagerPolicy)
			delete(rawMsg, key)
		case "failSwapOn":
			err = unpopulate(val, "FailSwapOn", &k.FailSwapOn)
			delete(rawMsg, key)
		case "imageGcHighThreshold":
			err = unpopulate(val, "ImageGcHighThreshold", &k.ImageGcHighThreshold)
			delete(rawMsg, key)
		case "imageGcLowThreshold":
			err = unpopulate(val, "ImageGcLowThreshold", &k.ImageGcLowThreshold)
			delete(rawMsg, key)
		case "topologyManagerPolicy":
			err = unpopulate(val, "TopologyManagerPolicy", &k.TopologyManagerPolicy)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinuxOSConfig.
func (l LinuxOSConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "swapFileSizeMB", l.SwapFileSizeMB)
	populate(objectMap, "sysctls", l.Sysctls)
	populate(objectMap, "transparentHugePageDefrag", l.TransparentHugePageDefrag)
	populate(objectMap, "transparentHugePageEnabled", l.TransparentHugePageEnabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinuxOSConfig.
func (l *LinuxOSConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "swapFileSizeMB":
			err = unpopulate(val, "SwapFileSizeMB", &l.SwapFileSizeMB)
			delete(rawMsg, key)
		case "sysctls":
			err = unpopulate(val, "Sysctls", &l.Sysctls)
			delete(rawMsg, key)
		case "transparentHugePageDefrag":
			err = unpopulate(val, "TransparentHugePageDefrag", &l.TransparentHugePageDefrag)
			delete(rawMsg, key)
		case "transparentHugePageEnabled":
			err = unpopulate(val, "TransparentHugePageEnabled", &l.TransparentHugePageEnabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinuxProfile.
func (l LinuxProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "adminUsername", l.AdminUsername)
	populate(objectMap, "ssh", l.SSH)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinuxProfile.
func (l *LinuxProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adminUsername":
			err = unpopulate(val, "AdminUsername", &l.AdminUsername)
			delete(rawMsg, key)
		case "ssh":
			err = unpopulate(val, "SSH", &l.SSH)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListResult.
func (l ListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListResult.
func (l *ListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedCluster.
func (m ManagedCluster) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "identity", m.Identity)
	populate(objectMap, "location", m.Location)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "sku", m.SKU)
	populate(objectMap, "tags", m.Tags)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedCluster.
func (m *ManagedCluster) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &m.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &m.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &m.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &m.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterAADProfile.
func (m ManagedClusterAADProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "adminGroupObjectIDs", m.AdminGroupObjectIDs)
	populate(objectMap, "clientAppID", m.ClientAppID)
	populate(objectMap, "enableAzureRBAC", m.EnableAzureRBAC)
	populate(objectMap, "managed", m.Managed)
	populate(objectMap, "serverAppID", m.ServerAppID)
	populate(objectMap, "serverAppSecret", m.ServerAppSecret)
	populate(objectMap, "tenantID", m.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterAADProfile.
func (m *ManagedClusterAADProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adminGroupObjectIDs":
			err = unpopulate(val, "AdminGroupObjectIDs", &m.AdminGroupObjectIDs)
			delete(rawMsg, key)
		case "clientAppID":
			err = unpopulate(val, "ClientAppID", &m.ClientAppID)
			delete(rawMsg, key)
		case "enableAzureRBAC":
			err = unpopulate(val, "EnableAzureRBAC", &m.EnableAzureRBAC)
			delete(rawMsg, key)
		case "managed":
			err = unpopulate(val, "Managed", &m.Managed)
			delete(rawMsg, key)
		case "serverAppID":
			err = unpopulate(val, "ServerAppID", &m.ServerAppID)
			delete(rawMsg, key)
		case "serverAppSecret":
			err = unpopulate(val, "ServerAppSecret", &m.ServerAppSecret)
			delete(rawMsg, key)
		case "tenantID":
			err = unpopulate(val, "TenantID", &m.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterAPIServerAccessProfile.
func (m ManagedClusterAPIServerAccessProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authorizedIPRanges", m.AuthorizedIPRanges)
	populate(objectMap, "enablePrivateCluster", m.EnablePrivateCluster)
	populate(objectMap, "privateDNSZone", m.PrivateDNSZone)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterAPIServerAccessProfile.
func (m *ManagedClusterAPIServerAccessProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authorizedIPRanges":
			err = unpopulate(val, "AuthorizedIPRanges", &m.AuthorizedIPRanges)
			delete(rawMsg, key)
		case "enablePrivateCluster":
			err = unpopulate(val, "EnablePrivateCluster", &m.EnablePrivateCluster)
			delete(rawMsg, key)
		case "privateDNSZone":
			err = unpopulate(val, "PrivateDNSZone", &m.PrivateDNSZone)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterAccessProfile.
func (m ManagedClusterAccessProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "location", m.Location)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "tags", m.Tags)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterAccessProfile.
func (m *ManagedClusterAccessProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &m.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &m.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterAddonProfile.
func (m ManagedClusterAddonProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "config", m.Config)
	populate(objectMap, "enabled", m.Enabled)
	populate(objectMap, "identity", m.Identity)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterAddonProfile.
func (m *ManagedClusterAddonProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "config":
			err = unpopulate(val, "Config", &m.Config)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &m.Enabled)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &m.Identity)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterAddonProfileIdentity.
func (m ManagedClusterAddonProfileIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", m.ClientID)
	populate(objectMap, "objectId", m.ObjectID)
	populate(objectMap, "resourceId", m.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterAddonProfileIdentity.
func (m *ManagedClusterAddonProfileIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &m.ClientID)
			delete(rawMsg, key)
		case "objectId":
			err = unpopulate(val, "ObjectID", &m.ObjectID)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &m.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterAgentPoolProfile.
func (m ManagedClusterAgentPoolProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "availabilityZones", m.AvailabilityZones)
	populate(objectMap, "count", m.Count)
	populate(objectMap, "enableAutoScaling", m.EnableAutoScaling)
	populate(objectMap, "enableNodePublicIP", m.EnableNodePublicIP)
	populate(objectMap, "kubeletConfig", m.KubeletConfig)
	populate(objectMap, "linuxOSConfig", m.LinuxOSConfig)
	populate(objectMap, "maxCount", m.MaxCount)
	populate(objectMap, "maxPods", m.MaxPods)
	populate(objectMap, "minCount", m.MinCount)
	populate(objectMap, "mode", m.Mode)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "nodeImageVersion", m.NodeImageVersion)
	populate(objectMap, "nodeLabels", m.NodeLabels)
	populate(objectMap, "nodeTaints", m.NodeTaints)
	populate(objectMap, "osDiskSizeGB", m.OSDiskSizeGB)
	populate(objectMap, "osDiskType", m.OSDiskType)
	populate(objectMap, "osType", m.OSType)
	populate(objectMap, "orchestratorVersion", m.OrchestratorVersion)
	populate(objectMap, "podSubnetID", m.PodSubnetID)
	populate(objectMap, "powerState", m.PowerState)
	populate(objectMap, "provisioningState", m.ProvisioningState)
	populate(objectMap, "proximityPlacementGroupID", m.ProximityPlacementGroupID)
	populate(objectMap, "scaleSetEvictionPolicy", m.ScaleSetEvictionPolicy)
	populate(objectMap, "scaleSetPriority", m.ScaleSetPriority)
	populate(objectMap, "spotMaxPrice", m.SpotMaxPrice)
	populate(objectMap, "tags", m.Tags)
	populate(objectMap, "type", m.Type)
	populate(objectMap, "upgradeSettings", m.UpgradeSettings)
	populate(objectMap, "vmSize", m.VMSize)
	populate(objectMap, "vnetSubnetID", m.VnetSubnetID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterAgentPoolProfile.
func (m *ManagedClusterAgentPoolProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availabilityZones":
			err = unpopulate(val, "AvailabilityZones", &m.AvailabilityZones)
			delete(rawMsg, key)
		case "count":
			err = unpopulate(val, "Count", &m.Count)
			delete(rawMsg, key)
		case "enableAutoScaling":
			err = unpopulate(val, "EnableAutoScaling", &m.EnableAutoScaling)
			delete(rawMsg, key)
		case "enableNodePublicIP":
			err = unpopulate(val, "EnableNodePublicIP", &m.EnableNodePublicIP)
			delete(rawMsg, key)
		case "kubeletConfig":
			err = unpopulate(val, "KubeletConfig", &m.KubeletConfig)
			delete(rawMsg, key)
		case "linuxOSConfig":
			err = unpopulate(val, "LinuxOSConfig", &m.LinuxOSConfig)
			delete(rawMsg, key)
		case "maxCount":
			err = unpopulate(val, "MaxCount", &m.MaxCount)
			delete(rawMsg, key)
		case "maxPods":
			err = unpopulate(val, "MaxPods", &m.MaxPods)
			delete(rawMsg, key)
		case "minCount":
			err = unpopulate(val, "MinCount", &m.MinCount)
			delete(rawMsg, key)
		case "mode":
			err = unpopulate(val, "Mode", &m.Mode)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "nodeImageVersion":
			err = unpopulate(val, "NodeImageVersion", &m.NodeImageVersion)
			delete(rawMsg, key)
		case "nodeLabels":
			err = unpopulate(val, "NodeLabels", &m.NodeLabels)
			delete(rawMsg, key)
		case "nodeTaints":
			err = unpopulate(val, "NodeTaints", &m.NodeTaints)
			delete(rawMsg, key)
		case "osDiskSizeGB":
			err = unpopulate(val, "OSDiskSizeGB", &m.OSDiskSizeGB)
			delete(rawMsg, key)
		case "osDiskType":
			err = unpopulate(val, "OSDiskType", &m.OSDiskType)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &m.OSType)
			delete(rawMsg, key)
		case "orchestratorVersion":
			err = unpopulate(val, "OrchestratorVersion", &m.OrchestratorVersion)
			delete(rawMsg, key)
		case "podSubnetID":
			err = unpopulate(val, "PodSubnetID", &m.PodSubnetID)
			delete(rawMsg, key)
		case "powerState":
			err = unpopulate(val, "PowerState", &m.PowerState)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &m.ProvisioningState)
			delete(rawMsg, key)
		case "proximityPlacementGroupID":
			err = unpopulate(val, "ProximityPlacementGroupID", &m.ProximityPlacementGroupID)
			delete(rawMsg, key)
		case "scaleSetEvictionPolicy":
			err = unpopulate(val, "ScaleSetEvictionPolicy", &m.ScaleSetEvictionPolicy)
			delete(rawMsg, key)
		case "scaleSetPriority":
			err = unpopulate(val, "ScaleSetPriority", &m.ScaleSetPriority)
			delete(rawMsg, key)
		case "spotMaxPrice":
			err = unpopulate(val, "SpotMaxPrice", &m.SpotMaxPrice)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &m.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		case "upgradeSettings":
			err = unpopulate(val, "UpgradeSettings", &m.UpgradeSettings)
			delete(rawMsg, key)
		case "vmSize":
			err = unpopulate(val, "VMSize", &m.VMSize)
			delete(rawMsg, key)
		case "vnetSubnetID":
			err = unpopulate(val, "VnetSubnetID", &m.VnetSubnetID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterAgentPoolProfileProperties.
func (m ManagedClusterAgentPoolProfileProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "availabilityZones", m.AvailabilityZones)
	populate(objectMap, "count", m.Count)
	populate(objectMap, "enableAutoScaling", m.EnableAutoScaling)
	populate(objectMap, "enableNodePublicIP", m.EnableNodePublicIP)
	populate(objectMap, "kubeletConfig", m.KubeletConfig)
	populate(objectMap, "linuxOSConfig", m.LinuxOSConfig)
	populate(objectMap, "maxCount", m.MaxCount)
	populate(objectMap, "maxPods", m.MaxPods)
	populate(objectMap, "minCount", m.MinCount)
	populate(objectMap, "mode", m.Mode)
	populate(objectMap, "nodeImageVersion", m.NodeImageVersion)
	populate(objectMap, "nodeLabels", m.NodeLabels)
	populate(objectMap, "nodeTaints", m.NodeTaints)
	populate(objectMap, "osDiskSizeGB", m.OSDiskSizeGB)
	populate(objectMap, "osDiskType", m.OSDiskType)
	populate(objectMap, "osType", m.OSType)
	populate(objectMap, "orchestratorVersion", m.OrchestratorVersion)
	populate(objectMap, "podSubnetID", m.PodSubnetID)
	populate(objectMap, "powerState", m.PowerState)
	populate(objectMap, "provisioningState", m.ProvisioningState)
	populate(objectMap, "proximityPlacementGroupID", m.ProximityPlacementGroupID)
	populate(objectMap, "scaleSetEvictionPolicy", m.ScaleSetEvictionPolicy)
	populate(objectMap, "scaleSetPriority", m.ScaleSetPriority)
	populate(objectMap, "spotMaxPrice", m.SpotMaxPrice)
	populate(objectMap, "tags", m.Tags)
	populate(objectMap, "type", m.Type)
	populate(objectMap, "upgradeSettings", m.UpgradeSettings)
	populate(objectMap, "vmSize", m.VMSize)
	populate(objectMap, "vnetSubnetID", m.VnetSubnetID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterAgentPoolProfileProperties.
func (m *ManagedClusterAgentPoolProfileProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availabilityZones":
			err = unpopulate(val, "AvailabilityZones", &m.AvailabilityZones)
			delete(rawMsg, key)
		case "count":
			err = unpopulate(val, "Count", &m.Count)
			delete(rawMsg, key)
		case "enableAutoScaling":
			err = unpopulate(val, "EnableAutoScaling", &m.EnableAutoScaling)
			delete(rawMsg, key)
		case "enableNodePublicIP":
			err = unpopulate(val, "EnableNodePublicIP", &m.EnableNodePublicIP)
			delete(rawMsg, key)
		case "kubeletConfig":
			err = unpopulate(val, "KubeletConfig", &m.KubeletConfig)
			delete(rawMsg, key)
		case "linuxOSConfig":
			err = unpopulate(val, "LinuxOSConfig", &m.LinuxOSConfig)
			delete(rawMsg, key)
		case "maxCount":
			err = unpopulate(val, "MaxCount", &m.MaxCount)
			delete(rawMsg, key)
		case "maxPods":
			err = unpopulate(val, "MaxPods", &m.MaxPods)
			delete(rawMsg, key)
		case "minCount":
			err = unpopulate(val, "MinCount", &m.MinCount)
			delete(rawMsg, key)
		case "mode":
			err = unpopulate(val, "Mode", &m.Mode)
			delete(rawMsg, key)
		case "nodeImageVersion":
			err = unpopulate(val, "NodeImageVersion", &m.NodeImageVersion)
			delete(rawMsg, key)
		case "nodeLabels":
			err = unpopulate(val, "NodeLabels", &m.NodeLabels)
			delete(rawMsg, key)
		case "nodeTaints":
			err = unpopulate(val, "NodeTaints", &m.NodeTaints)
			delete(rawMsg, key)
		case "osDiskSizeGB":
			err = unpopulate(val, "OSDiskSizeGB", &m.OSDiskSizeGB)
			delete(rawMsg, key)
		case "osDiskType":
			err = unpopulate(val, "OSDiskType", &m.OSDiskType)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &m.OSType)
			delete(rawMsg, key)
		case "orchestratorVersion":
			err = unpopulate(val, "OrchestratorVersion", &m.OrchestratorVersion)
			delete(rawMsg, key)
		case "podSubnetID":
			err = unpopulate(val, "PodSubnetID", &m.PodSubnetID)
			delete(rawMsg, key)
		case "powerState":
			err = unpopulate(val, "PowerState", &m.PowerState)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &m.ProvisioningState)
			delete(rawMsg, key)
		case "proximityPlacementGroupID":
			err = unpopulate(val, "ProximityPlacementGroupID", &m.ProximityPlacementGroupID)
			delete(rawMsg, key)
		case "scaleSetEvictionPolicy":
			err = unpopulate(val, "ScaleSetEvictionPolicy", &m.ScaleSetEvictionPolicy)
			delete(rawMsg, key)
		case "scaleSetPriority":
			err = unpopulate(val, "ScaleSetPriority", &m.ScaleSetPriority)
			delete(rawMsg, key)
		case "spotMaxPrice":
			err = unpopulate(val, "SpotMaxPrice", &m.SpotMaxPrice)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &m.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		case "upgradeSettings":
			err = unpopulate(val, "UpgradeSettings", &m.UpgradeSettings)
			delete(rawMsg, key)
		case "vmSize":
			err = unpopulate(val, "VMSize", &m.VMSize)
			delete(rawMsg, key)
		case "vnetSubnetID":
			err = unpopulate(val, "VnetSubnetID", &m.VnetSubnetID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterAutoUpgradeProfile.
func (m ManagedClusterAutoUpgradeProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "upgradeChannel", m.UpgradeChannel)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterAutoUpgradeProfile.
func (m *ManagedClusterAutoUpgradeProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "upgradeChannel":
			err = unpopulate(val, "UpgradeChannel", &m.UpgradeChannel)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterIdentity.
func (m ManagedClusterIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", m.PrincipalID)
	populate(objectMap, "tenantId", m.TenantID)
	populate(objectMap, "type", m.Type)
	populate(objectMap, "userAssignedIdentities", m.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterIdentity.
func (m *ManagedClusterIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &m.PrincipalID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &m.TenantID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		case "userAssignedIdentities":
			err = unpopulate(val, "UserAssignedIdentities", &m.UserAssignedIdentities)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterListResult.
func (m ManagedClusterListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", m.NextLink)
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterListResult.
func (m *ManagedClusterListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &m.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &m.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterLoadBalancerProfile.
func (m ManagedClusterLoadBalancerProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allocatedOutboundPorts", m.AllocatedOutboundPorts)
	populate(objectMap, "effectiveOutboundIPs", m.EffectiveOutboundIPs)
	populate(objectMap, "idleTimeoutInMinutes", m.IdleTimeoutInMinutes)
	populate(objectMap, "managedOutboundIPs", m.ManagedOutboundIPs)
	populate(objectMap, "outboundIPPrefixes", m.OutboundIPPrefixes)
	populate(objectMap, "outboundIPs", m.OutboundIPs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterLoadBalancerProfile.
func (m *ManagedClusterLoadBalancerProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allocatedOutboundPorts":
			err = unpopulate(val, "AllocatedOutboundPorts", &m.AllocatedOutboundPorts)
			delete(rawMsg, key)
		case "effectiveOutboundIPs":
			err = unpopulate(val, "EffectiveOutboundIPs", &m.EffectiveOutboundIPs)
			delete(rawMsg, key)
		case "idleTimeoutInMinutes":
			err = unpopulate(val, "IdleTimeoutInMinutes", &m.IdleTimeoutInMinutes)
			delete(rawMsg, key)
		case "managedOutboundIPs":
			err = unpopulate(val, "ManagedOutboundIPs", &m.ManagedOutboundIPs)
			delete(rawMsg, key)
		case "outboundIPPrefixes":
			err = unpopulate(val, "OutboundIPPrefixes", &m.OutboundIPPrefixes)
			delete(rawMsg, key)
		case "outboundIPs":
			err = unpopulate(val, "OutboundIPs", &m.OutboundIPs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterLoadBalancerProfileManagedOutboundIPs.
func (m ManagedClusterLoadBalancerProfileManagedOutboundIPs) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", m.Count)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterLoadBalancerProfileManagedOutboundIPs.
func (m *ManagedClusterLoadBalancerProfileManagedOutboundIPs) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &m.Count)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterLoadBalancerProfileOutboundIPPrefixes.
func (m ManagedClusterLoadBalancerProfileOutboundIPPrefixes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "publicIPPrefixes", m.PublicIPPrefixes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterLoadBalancerProfileOutboundIPPrefixes.
func (m *ManagedClusterLoadBalancerProfileOutboundIPPrefixes) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "publicIPPrefixes":
			err = unpopulate(val, "PublicIPPrefixes", &m.PublicIPPrefixes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterLoadBalancerProfileOutboundIPs.
func (m ManagedClusterLoadBalancerProfileOutboundIPs) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "publicIPs", m.PublicIPs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterLoadBalancerProfileOutboundIPs.
func (m *ManagedClusterLoadBalancerProfileOutboundIPs) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "publicIPs":
			err = unpopulate(val, "PublicIPs", &m.PublicIPs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterPodIdentity.
func (m ManagedClusterPodIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identity", m.Identity)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "namespace", m.Namespace)
	populate(objectMap, "provisioningInfo", m.ProvisioningInfo)
	populate(objectMap, "provisioningState", m.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterPodIdentity.
func (m *ManagedClusterPodIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identity":
			err = unpopulate(val, "Identity", &m.Identity)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "namespace":
			err = unpopulate(val, "Namespace", &m.Namespace)
			delete(rawMsg, key)
		case "provisioningInfo":
			err = unpopulate(val, "ProvisioningInfo", &m.ProvisioningInfo)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &m.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterPodIdentityException.
func (m ManagedClusterPodIdentityException) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "namespace", m.Namespace)
	populate(objectMap, "podLabels", m.PodLabels)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterPodIdentityException.
func (m *ManagedClusterPodIdentityException) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "namespace":
			err = unpopulate(val, "Namespace", &m.Namespace)
			delete(rawMsg, key)
		case "podLabels":
			err = unpopulate(val, "PodLabels", &m.PodLabels)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterPodIdentityProfile.
func (m ManagedClusterPodIdentityProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", m.Enabled)
	populate(objectMap, "userAssignedIdentities", m.UserAssignedIdentities)
	populate(objectMap, "userAssignedIdentityExceptions", m.UserAssignedIdentityExceptions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterPodIdentityProfile.
func (m *ManagedClusterPodIdentityProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &m.Enabled)
			delete(rawMsg, key)
		case "userAssignedIdentities":
			err = unpopulate(val, "UserAssignedIdentities", &m.UserAssignedIdentities)
			delete(rawMsg, key)
		case "userAssignedIdentityExceptions":
			err = unpopulate(val, "UserAssignedIdentityExceptions", &m.UserAssignedIdentityExceptions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterPodIdentityProvisioningInfo.
func (m ManagedClusterPodIdentityProvisioningInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", m.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterPodIdentityProvisioningInfo.
func (m *ManagedClusterPodIdentityProvisioningInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &m.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterPoolUpgradeProfile.
func (m ManagedClusterPoolUpgradeProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "kubernetesVersion", m.KubernetesVersion)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "osType", m.OSType)
	populate(objectMap, "upgrades", m.Upgrades)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterPoolUpgradeProfile.
func (m *ManagedClusterPoolUpgradeProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kubernetesVersion":
			err = unpopulate(val, "KubernetesVersion", &m.KubernetesVersion)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &m.OSType)
			delete(rawMsg, key)
		case "upgrades":
			err = unpopulate(val, "Upgrades", &m.Upgrades)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterPoolUpgradeProfileUpgradesItem.
func (m ManagedClusterPoolUpgradeProfileUpgradesItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "isPreview", m.IsPreview)
	populate(objectMap, "kubernetesVersion", m.KubernetesVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterPoolUpgradeProfileUpgradesItem.
func (m *ManagedClusterPoolUpgradeProfileUpgradesItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isPreview":
			err = unpopulate(val, "IsPreview", &m.IsPreview)
			delete(rawMsg, key)
		case "kubernetesVersion":
			err = unpopulate(val, "KubernetesVersion", &m.KubernetesVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterProperties.
func (m ManagedClusterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aadProfile", m.AADProfile)
	populate(objectMap, "apiServerAccessProfile", m.APIServerAccessProfile)
	populate(objectMap, "addonProfiles", m.AddonProfiles)
	populate(objectMap, "agentPoolProfiles", m.AgentPoolProfiles)
	populate(objectMap, "autoScalerProfile", m.AutoScalerProfile)
	populate(objectMap, "autoUpgradeProfile", m.AutoUpgradeProfile)
	populate(objectMap, "dnsPrefix", m.DNSPrefix)
	populate(objectMap, "diskEncryptionSetID", m.DiskEncryptionSetID)
	populate(objectMap, "enablePodSecurityPolicy", m.EnablePodSecurityPolicy)
	populate(objectMap, "enableRBAC", m.EnableRBAC)
	populate(objectMap, "fqdn", m.Fqdn)
	populate(objectMap, "identityProfile", m.IdentityProfile)
	populate(objectMap, "kubernetesVersion", m.KubernetesVersion)
	populate(objectMap, "linuxProfile", m.LinuxProfile)
	populate(objectMap, "maxAgentPools", m.MaxAgentPools)
	populate(objectMap, "networkProfile", m.NetworkProfile)
	populate(objectMap, "nodeResourceGroup", m.NodeResourceGroup)
	populate(objectMap, "podIdentityProfile", m.PodIdentityProfile)
	populate(objectMap, "powerState", m.PowerState)
	populate(objectMap, "privateFQDN", m.PrivateFQDN)
	populate(objectMap, "provisioningState", m.ProvisioningState)
	populate(objectMap, "servicePrincipalProfile", m.ServicePrincipalProfile)
	populate(objectMap, "windowsProfile", m.WindowsProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterProperties.
func (m *ManagedClusterProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aadProfile":
			err = unpopulate(val, "AADProfile", &m.AADProfile)
			delete(rawMsg, key)
		case "apiServerAccessProfile":
			err = unpopulate(val, "APIServerAccessProfile", &m.APIServerAccessProfile)
			delete(rawMsg, key)
		case "addonProfiles":
			err = unpopulate(val, "AddonProfiles", &m.AddonProfiles)
			delete(rawMsg, key)
		case "agentPoolProfiles":
			err = unpopulate(val, "AgentPoolProfiles", &m.AgentPoolProfiles)
			delete(rawMsg, key)
		case "autoScalerProfile":
			err = unpopulate(val, "AutoScalerProfile", &m.AutoScalerProfile)
			delete(rawMsg, key)
		case "autoUpgradeProfile":
			err = unpopulate(val, "AutoUpgradeProfile", &m.AutoUpgradeProfile)
			delete(rawMsg, key)
		case "dnsPrefix":
			err = unpopulate(val, "DNSPrefix", &m.DNSPrefix)
			delete(rawMsg, key)
		case "diskEncryptionSetID":
			err = unpopulate(val, "DiskEncryptionSetID", &m.DiskEncryptionSetID)
			delete(rawMsg, key)
		case "enablePodSecurityPolicy":
			err = unpopulate(val, "EnablePodSecurityPolicy", &m.EnablePodSecurityPolicy)
			delete(rawMsg, key)
		case "enableRBAC":
			err = unpopulate(val, "EnableRBAC", &m.EnableRBAC)
			delete(rawMsg, key)
		case "fqdn":
			err = unpopulate(val, "Fqdn", &m.Fqdn)
			delete(rawMsg, key)
		case "identityProfile":
			err = unpopulate(val, "IdentityProfile", &m.IdentityProfile)
			delete(rawMsg, key)
		case "kubernetesVersion":
			err = unpopulate(val, "KubernetesVersion", &m.KubernetesVersion)
			delete(rawMsg, key)
		case "linuxProfile":
			err = unpopulate(val, "LinuxProfile", &m.LinuxProfile)
			delete(rawMsg, key)
		case "maxAgentPools":
			err = unpopulate(val, "MaxAgentPools", &m.MaxAgentPools)
			delete(rawMsg, key)
		case "networkProfile":
			err = unpopulate(val, "NetworkProfile", &m.NetworkProfile)
			delete(rawMsg, key)
		case "nodeResourceGroup":
			err = unpopulate(val, "NodeResourceGroup", &m.NodeResourceGroup)
			delete(rawMsg, key)
		case "podIdentityProfile":
			err = unpopulate(val, "PodIdentityProfile", &m.PodIdentityProfile)
			delete(rawMsg, key)
		case "powerState":
			err = unpopulate(val, "PowerState", &m.PowerState)
			delete(rawMsg, key)
		case "privateFQDN":
			err = unpopulate(val, "PrivateFQDN", &m.PrivateFQDN)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &m.ProvisioningState)
			delete(rawMsg, key)
		case "servicePrincipalProfile":
			err = unpopulate(val, "ServicePrincipalProfile", &m.ServicePrincipalProfile)
			delete(rawMsg, key)
		case "windowsProfile":
			err = unpopulate(val, "WindowsProfile", &m.WindowsProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterPropertiesAutoScalerProfile.
func (m ManagedClusterPropertiesAutoScalerProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "balance-similar-node-groups", m.BalanceSimilarNodeGroups)
	populate(objectMap, "expander", m.Expander)
	populate(objectMap, "max-empty-bulk-delete", m.MaxEmptyBulkDelete)
	populate(objectMap, "max-graceful-termination-sec", m.MaxGracefulTerminationSec)
	populate(objectMap, "max-total-unready-percentage", m.MaxTotalUnreadyPercentage)
	populate(objectMap, "new-pod-scale-up-delay", m.NewPodScaleUpDelay)
	populate(objectMap, "ok-total-unready-count", m.OkTotalUnreadyCount)
	populate(objectMap, "scale-down-delay-after-add", m.ScaleDownDelayAfterAdd)
	populate(objectMap, "scale-down-delay-after-delete", m.ScaleDownDelayAfterDelete)
	populate(objectMap, "scale-down-delay-after-failure", m.ScaleDownDelayAfterFailure)
	populate(objectMap, "scale-down-unneeded-time", m.ScaleDownUnneededTime)
	populate(objectMap, "scale-down-unready-time", m.ScaleDownUnreadyTime)
	populate(objectMap, "scale-down-utilization-threshold", m.ScaleDownUtilizationThreshold)
	populate(objectMap, "scan-interval", m.ScanInterval)
	populate(objectMap, "skip-nodes-with-local-storage", m.SkipNodesWithLocalStorage)
	populate(objectMap, "skip-nodes-with-system-pods", m.SkipNodesWithSystemPods)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterPropertiesAutoScalerProfile.
func (m *ManagedClusterPropertiesAutoScalerProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "balance-similar-node-groups":
			err = unpopulate(val, "BalanceSimilarNodeGroups", &m.BalanceSimilarNodeGroups)
			delete(rawMsg, key)
		case "expander":
			err = unpopulate(val, "Expander", &m.Expander)
			delete(rawMsg, key)
		case "max-empty-bulk-delete":
			err = unpopulate(val, "MaxEmptyBulkDelete", &m.MaxEmptyBulkDelete)
			delete(rawMsg, key)
		case "max-graceful-termination-sec":
			err = unpopulate(val, "MaxGracefulTerminationSec", &m.MaxGracefulTerminationSec)
			delete(rawMsg, key)
		case "max-total-unready-percentage":
			err = unpopulate(val, "MaxTotalUnreadyPercentage", &m.MaxTotalUnreadyPercentage)
			delete(rawMsg, key)
		case "new-pod-scale-up-delay":
			err = unpopulate(val, "NewPodScaleUpDelay", &m.NewPodScaleUpDelay)
			delete(rawMsg, key)
		case "ok-total-unready-count":
			err = unpopulate(val, "OkTotalUnreadyCount", &m.OkTotalUnreadyCount)
			delete(rawMsg, key)
		case "scale-down-delay-after-add":
			err = unpopulate(val, "ScaleDownDelayAfterAdd", &m.ScaleDownDelayAfterAdd)
			delete(rawMsg, key)
		case "scale-down-delay-after-delete":
			err = unpopulate(val, "ScaleDownDelayAfterDelete", &m.ScaleDownDelayAfterDelete)
			delete(rawMsg, key)
		case "scale-down-delay-after-failure":
			err = unpopulate(val, "ScaleDownDelayAfterFailure", &m.ScaleDownDelayAfterFailure)
			delete(rawMsg, key)
		case "scale-down-unneeded-time":
			err = unpopulate(val, "ScaleDownUnneededTime", &m.ScaleDownUnneededTime)
			delete(rawMsg, key)
		case "scale-down-unready-time":
			err = unpopulate(val, "ScaleDownUnreadyTime", &m.ScaleDownUnreadyTime)
			delete(rawMsg, key)
		case "scale-down-utilization-threshold":
			err = unpopulate(val, "ScaleDownUtilizationThreshold", &m.ScaleDownUtilizationThreshold)
			delete(rawMsg, key)
		case "scan-interval":
			err = unpopulate(val, "ScanInterval", &m.ScanInterval)
			delete(rawMsg, key)
		case "skip-nodes-with-local-storage":
			err = unpopulate(val, "SkipNodesWithLocalStorage", &m.SkipNodesWithLocalStorage)
			delete(rawMsg, key)
		case "skip-nodes-with-system-pods":
			err = unpopulate(val, "SkipNodesWithSystemPods", &m.SkipNodesWithSystemPods)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterSKU.
func (m ManagedClusterSKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "tier", m.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterSKU.
func (m *ManagedClusterSKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &m.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterServicePrincipalProfile.
func (m ManagedClusterServicePrincipalProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", m.ClientID)
	populate(objectMap, "secret", m.Secret)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterServicePrincipalProfile.
func (m *ManagedClusterServicePrincipalProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &m.ClientID)
			delete(rawMsg, key)
		case "secret":
			err = unpopulate(val, "Secret", &m.Secret)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterUpgradeProfile.
func (m ManagedClusterUpgradeProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterUpgradeProfile.
func (m *ManagedClusterUpgradeProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterUpgradeProfileProperties.
func (m ManagedClusterUpgradeProfileProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "agentPoolProfiles", m.AgentPoolProfiles)
	populate(objectMap, "controlPlaneProfile", m.ControlPlaneProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterUpgradeProfileProperties.
func (m *ManagedClusterUpgradeProfileProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentPoolProfiles":
			err = unpopulate(val, "AgentPoolProfiles", &m.AgentPoolProfiles)
			delete(rawMsg, key)
		case "controlPlaneProfile":
			err = unpopulate(val, "ControlPlaneProfile", &m.ControlPlaneProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterWindowsProfile.
func (m ManagedClusterWindowsProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "adminPassword", m.AdminPassword)
	populate(objectMap, "adminUsername", m.AdminUsername)
	populate(objectMap, "licenseType", m.LicenseType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterWindowsProfile.
func (m *ManagedClusterWindowsProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adminPassword":
			err = unpopulate(val, "AdminPassword", &m.AdminPassword)
			delete(rawMsg, key)
		case "adminUsername":
			err = unpopulate(val, "AdminUsername", &m.AdminUsername)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &m.LicenseType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MasterProfile.
func (m MasterProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", m.Count)
	populate(objectMap, "dnsPrefix", m.DNSPrefix)
	populate(objectMap, "firstConsecutiveStaticIP", m.FirstConsecutiveStaticIP)
	populate(objectMap, "fqdn", m.Fqdn)
	populate(objectMap, "osDiskSizeGB", m.OSDiskSizeGB)
	populate(objectMap, "storageProfile", m.StorageProfile)
	populate(objectMap, "vmSize", m.VMSize)
	populate(objectMap, "vnetSubnetID", m.VnetSubnetID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MasterProfile.
func (m *MasterProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &m.Count)
			delete(rawMsg, key)
		case "dnsPrefix":
			err = unpopulate(val, "DNSPrefix", &m.DNSPrefix)
			delete(rawMsg, key)
		case "firstConsecutiveStaticIP":
			err = unpopulate(val, "FirstConsecutiveStaticIP", &m.FirstConsecutiveStaticIP)
			delete(rawMsg, key)
		case "fqdn":
			err = unpopulate(val, "Fqdn", &m.Fqdn)
			delete(rawMsg, key)
		case "osDiskSizeGB":
			err = unpopulate(val, "OSDiskSizeGB", &m.OSDiskSizeGB)
			delete(rawMsg, key)
		case "storageProfile":
			err = unpopulate(val, "StorageProfile", &m.StorageProfile)
			delete(rawMsg, key)
		case "vmSize":
			err = unpopulate(val, "VMSize", &m.VMSize)
			delete(rawMsg, key)
		case "vnetSubnetID":
			err = unpopulate(val, "VnetSubnetID", &m.VnetSubnetID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkProfile.
func (n NetworkProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dnsServiceIP", n.DNSServiceIP)
	populate(objectMap, "dockerBridgeCidr", n.DockerBridgeCidr)
	populate(objectMap, "loadBalancerProfile", n.LoadBalancerProfile)
	populate(objectMap, "loadBalancerSku", n.LoadBalancerSKU)
	populate(objectMap, "networkMode", n.NetworkMode)
	populate(objectMap, "networkPlugin", n.NetworkPlugin)
	populate(objectMap, "networkPolicy", n.NetworkPolicy)
	populate(objectMap, "outboundType", n.OutboundType)
	populate(objectMap, "podCidr", n.PodCidr)
	populate(objectMap, "serviceCidr", n.ServiceCidr)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkProfile.
func (n *NetworkProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dnsServiceIP":
			err = unpopulate(val, "DNSServiceIP", &n.DNSServiceIP)
			delete(rawMsg, key)
		case "dockerBridgeCidr":
			err = unpopulate(val, "DockerBridgeCidr", &n.DockerBridgeCidr)
			delete(rawMsg, key)
		case "loadBalancerProfile":
			err = unpopulate(val, "LoadBalancerProfile", &n.LoadBalancerProfile)
			delete(rawMsg, key)
		case "loadBalancerSku":
			err = unpopulate(val, "LoadBalancerSKU", &n.LoadBalancerSKU)
			delete(rawMsg, key)
		case "networkMode":
			err = unpopulate(val, "NetworkMode", &n.NetworkMode)
			delete(rawMsg, key)
		case "networkPlugin":
			err = unpopulate(val, "NetworkPlugin", &n.NetworkPlugin)
			delete(rawMsg, key)
		case "networkPolicy":
			err = unpopulate(val, "NetworkPolicy", &n.NetworkPolicy)
			delete(rawMsg, key)
		case "outboundType":
			err = unpopulate(val, "OutboundType", &n.OutboundType)
			delete(rawMsg, key)
		case "podCidr":
			err = unpopulate(val, "PodCidr", &n.PodCidr)
			delete(rawMsg, key)
		case "serviceCidr":
			err = unpopulate(val, "ServiceCidr", &n.ServiceCidr)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationListResult.
func (o OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationListResult.
func (o *OperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationValue.
func (o OperationValue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "origin", o.Origin)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationValue.
func (o *OperationValue) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationValueDisplay.
func (o OperationValueDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationValueDisplay.
func (o *OperationValueDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OrchestratorProfile.
func (o OrchestratorProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "isPreview", o.IsPreview)
	populate(objectMap, "orchestratorType", o.OrchestratorType)
	populate(objectMap, "orchestratorVersion", o.OrchestratorVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OrchestratorProfile.
func (o *OrchestratorProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isPreview":
			err = unpopulate(val, "IsPreview", &o.IsPreview)
			delete(rawMsg, key)
		case "orchestratorType":
			err = unpopulate(val, "OrchestratorType", &o.OrchestratorType)
			delete(rawMsg, key)
		case "orchestratorVersion":
			err = unpopulate(val, "OrchestratorVersion", &o.OrchestratorVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OrchestratorVersionProfile.
func (o OrchestratorVersionProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "default", o.Default)
	populate(objectMap, "isPreview", o.IsPreview)
	populate(objectMap, "orchestratorType", o.OrchestratorType)
	populate(objectMap, "orchestratorVersion", o.OrchestratorVersion)
	populate(objectMap, "upgrades", o.Upgrades)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OrchestratorVersionProfile.
func (o *OrchestratorVersionProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "default":
			err = unpopulate(val, "Default", &o.Default)
			delete(rawMsg, key)
		case "isPreview":
			err = unpopulate(val, "IsPreview", &o.IsPreview)
			delete(rawMsg, key)
		case "orchestratorType":
			err = unpopulate(val, "OrchestratorType", &o.OrchestratorType)
			delete(rawMsg, key)
		case "orchestratorVersion":
			err = unpopulate(val, "OrchestratorVersion", &o.OrchestratorVersion)
			delete(rawMsg, key)
		case "upgrades":
			err = unpopulate(val, "Upgrades", &o.Upgrades)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OrchestratorVersionProfileListResult.
func (o OrchestratorVersionProfileListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", o.ID)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "properties", o.Properties)
	populate(objectMap, "type", o.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OrchestratorVersionProfileListResult.
func (o *OrchestratorVersionProfileListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &o.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OrchestratorVersionProfileProperties.
func (o OrchestratorVersionProfileProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "orchestrators", o.Orchestrators)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OrchestratorVersionProfileProperties.
func (o *OrchestratorVersionProfileProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "orchestrators":
			err = unpopulate(val, "Orchestrators", &o.Orchestrators)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PowerState.
func (p PowerState) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", p.Code)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PowerState.
func (p *PowerState) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &p.Code)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrincipalProfile.
func (p PrincipalProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", p.ClientID)
	populate(objectMap, "keyVaultSecretRef", p.KeyVaultSecretRef)
	populate(objectMap, "secret", p.Secret)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrincipalProfile.
func (p *PrincipalProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &p.ClientID)
			delete(rawMsg, key)
		case "keyVaultSecretRef":
			err = unpopulate(val, "KeyVaultSecretRef", &p.KeyVaultSecretRef)
			delete(rawMsg, key)
		case "secret":
			err = unpopulate(val, "Secret", &p.Secret)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpoint.
func (p PrivateEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpoint.
func (p *PrivateEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnection.
func (p PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnection.
func (p *PrivateEndpointConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionListResult.
func (p PrivateEndpointConnectionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnectionListResult.
func (p *PrivateEndpointConnectionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionProperties.
func (p PrivateEndpointConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "privateEndpoint", p.PrivateEndpoint)
	populate(objectMap, "privateLinkServiceConnectionState", p.PrivateLinkServiceConnectionState)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnectionProperties.
func (p *PrivateEndpointConnectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "privateEndpoint":
			err = unpopulate(val, "PrivateEndpoint", &p.PrivateEndpoint)
			delete(rawMsg, key)
		case "privateLinkServiceConnectionState":
			err = unpopulate(val, "PrivateLinkServiceConnectionState", &p.PrivateLinkServiceConnectionState)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResource.
func (p PrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "groupId", p.GroupID)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "privateLinkServiceID", p.PrivateLinkServiceID)
	populate(objectMap, "requiredMembers", p.RequiredMembers)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResource.
func (p *PrivateLinkResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "groupId":
			err = unpopulate(val, "GroupID", &p.GroupID)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "privateLinkServiceID":
			err = unpopulate(val, "PrivateLinkServiceID", &p.PrivateLinkServiceID)
			delete(rawMsg, key)
		case "requiredMembers":
			err = unpopulate(val, "RequiredMembers", &p.RequiredMembers)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResourcesListResult.
func (p PrivateLinkResourcesListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResourcesListResult.
func (p *PrivateLinkResourcesListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkServiceConnectionState.
func (p PrivateLinkServiceConnectionState) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "status", p.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkServiceConnectionState.
func (p *PrivateLinkServiceConnectionState) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Properties.
func (p Properties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "agentPoolProfiles", p.AgentPoolProfiles)
	populate(objectMap, "customProfile", p.CustomProfile)
	populate(objectMap, "diagnosticsProfile", p.DiagnosticsProfile)
	populate(objectMap, "linuxProfile", p.LinuxProfile)
	populate(objectMap, "masterProfile", p.MasterProfile)
	populate(objectMap, "orchestratorProfile", p.OrchestratorProfile)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "servicePrincipalProfile", p.ServicePrincipalProfile)
	populate(objectMap, "windowsProfile", p.WindowsProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Properties.
func (p *Properties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentPoolProfiles":
			err = unpopulate(val, "AgentPoolProfiles", &p.AgentPoolProfiles)
			delete(rawMsg, key)
		case "customProfile":
			err = unpopulate(val, "CustomProfile", &p.CustomProfile)
			delete(rawMsg, key)
		case "diagnosticsProfile":
			err = unpopulate(val, "DiagnosticsProfile", &p.DiagnosticsProfile)
			delete(rawMsg, key)
		case "linuxProfile":
			err = unpopulate(val, "LinuxProfile", &p.LinuxProfile)
			delete(rawMsg, key)
		case "masterProfile":
			err = unpopulate(val, "MasterProfile", &p.MasterProfile)
			delete(rawMsg, key)
		case "orchestratorProfile":
			err = unpopulate(val, "OrchestratorProfile", &p.OrchestratorProfile)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "servicePrincipalProfile":
			err = unpopulate(val, "ServicePrincipalProfile", &p.ServicePrincipalProfile)
			delete(rawMsg, key)
		case "windowsProfile":
			err = unpopulate(val, "WindowsProfile", &p.WindowsProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceReference.
func (r ResourceReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceReference.
func (r *ResourceReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SSHConfiguration.
func (s SSHConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "publicKeys", s.PublicKeys)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SSHConfiguration.
func (s *SSHConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "publicKeys":
			err = unpopulate(val, "PublicKeys", &s.PublicKeys)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SSHPublicKey.
func (s SSHPublicKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "keyData", s.KeyData)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SSHPublicKey.
func (s *SSHPublicKey) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyData":
			err = unpopulate(val, "KeyData", &s.KeyData)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubResource.
func (s SubResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubResource.
func (s *SubResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SysctlConfig.
func (s SysctlConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "fsAioMaxNr", s.FsAioMaxNr)
	populate(objectMap, "fsFileMax", s.FsFileMax)
	populate(objectMap, "fsInotifyMaxUserWatches", s.FsInotifyMaxUserWatches)
	populate(objectMap, "fsNrOpen", s.FsNrOpen)
	populate(objectMap, "kernelThreadsMax", s.KernelThreadsMax)
	populate(objectMap, "netCoreNetdevMaxBacklog", s.NetCoreNetdevMaxBacklog)
	populate(objectMap, "netCoreOptmemMax", s.NetCoreOptmemMax)
	populate(objectMap, "netCoreRmemMax", s.NetCoreRmemMax)
	populate(objectMap, "netCoreSomaxconn", s.NetCoreSomaxconn)
	populate(objectMap, "netCoreWmemMax", s.NetCoreWmemMax)
	populate(objectMap, "netIpv4IpLocalPortRange", s.NetIPv4IPLocalPortRange)
	populate(objectMap, "netIpv4NeighDefaultGcThresh1", s.NetIPv4NeighDefaultGcThresh1)
	populate(objectMap, "netIpv4NeighDefaultGcThresh2", s.NetIPv4NeighDefaultGcThresh2)
	populate(objectMap, "netIpv4NeighDefaultGcThresh3", s.NetIPv4NeighDefaultGcThresh3)
	populate(objectMap, "netIpv4TcpFinTimeout", s.NetIPv4TCPFinTimeout)
	populate(objectMap, "netIpv4TcpKeepaliveProbes", s.NetIPv4TCPKeepaliveProbes)
	populate(objectMap, "netIpv4TcpKeepaliveTime", s.NetIPv4TCPKeepaliveTime)
	populate(objectMap, "netIpv4TcpMaxSynBacklog", s.NetIPv4TCPMaxSynBacklog)
	populate(objectMap, "netIpv4TcpMaxTwBuckets", s.NetIPv4TCPMaxTwBuckets)
	populate(objectMap, "netIpv4TcpRmem", s.NetIPv4TCPRmem)
	populate(objectMap, "netIpv4TcpTwReuse", s.NetIPv4TCPTwReuse)
	populate(objectMap, "netIpv4TcpWmem", s.NetIPv4TCPWmem)
	populate(objectMap, "netIpv4TcpkeepaliveIntvl", s.NetIPv4TcpkeepaliveIntvl)
	populate(objectMap, "netNetfilterNfConntrackBuckets", s.NetNetfilterNfConntrackBuckets)
	populate(objectMap, "netNetfilterNfConntrackMax", s.NetNetfilterNfConntrackMax)
	populate(objectMap, "vmMaxMapCount", s.VMMaxMapCount)
	populate(objectMap, "vmSwappiness", s.VMSwappiness)
	populate(objectMap, "vmVfsCachePressure", s.VMVfsCachePressure)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SysctlConfig.
func (s *SysctlConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fsAioMaxNr":
			err = unpopulate(val, "FsAioMaxNr", &s.FsAioMaxNr)
			delete(rawMsg, key)
		case "fsFileMax":
			err = unpopulate(val, "FsFileMax", &s.FsFileMax)
			delete(rawMsg, key)
		case "fsInotifyMaxUserWatches":
			err = unpopulate(val, "FsInotifyMaxUserWatches", &s.FsInotifyMaxUserWatches)
			delete(rawMsg, key)
		case "fsNrOpen":
			err = unpopulate(val, "FsNrOpen", &s.FsNrOpen)
			delete(rawMsg, key)
		case "kernelThreadsMax":
			err = unpopulate(val, "KernelThreadsMax", &s.KernelThreadsMax)
			delete(rawMsg, key)
		case "netCoreNetdevMaxBacklog":
			err = unpopulate(val, "NetCoreNetdevMaxBacklog", &s.NetCoreNetdevMaxBacklog)
			delete(rawMsg, key)
		case "netCoreOptmemMax":
			err = unpopulate(val, "NetCoreOptmemMax", &s.NetCoreOptmemMax)
			delete(rawMsg, key)
		case "netCoreRmemMax":
			err = unpopulate(val, "NetCoreRmemMax", &s.NetCoreRmemMax)
			delete(rawMsg, key)
		case "netCoreSomaxconn":
			err = unpopulate(val, "NetCoreSomaxconn", &s.NetCoreSomaxconn)
			delete(rawMsg, key)
		case "netCoreWmemMax":
			err = unpopulate(val, "NetCoreWmemMax", &s.NetCoreWmemMax)
			delete(rawMsg, key)
		case "netIpv4IpLocalPortRange":
			err = unpopulate(val, "NetIPv4IPLocalPortRange", &s.NetIPv4IPLocalPortRange)
			delete(rawMsg, key)
		case "netIpv4NeighDefaultGcThresh1":
			err = unpopulate(val, "NetIPv4NeighDefaultGcThresh1", &s.NetIPv4NeighDefaultGcThresh1)
			delete(rawMsg, key)
		case "netIpv4NeighDefaultGcThresh2":
			err = unpopulate(val, "NetIPv4NeighDefaultGcThresh2", &s.NetIPv4NeighDefaultGcThresh2)
			delete(rawMsg, key)
		case "netIpv4NeighDefaultGcThresh3":
			err = unpopulate(val, "NetIPv4NeighDefaultGcThresh3", &s.NetIPv4NeighDefaultGcThresh3)
			delete(rawMsg, key)
		case "netIpv4TcpFinTimeout":
			err = unpopulate(val, "NetIPv4TCPFinTimeout", &s.NetIPv4TCPFinTimeout)
			delete(rawMsg, key)
		case "netIpv4TcpKeepaliveProbes":
			err = unpopulate(val, "NetIPv4TCPKeepaliveProbes", &s.NetIPv4TCPKeepaliveProbes)
			delete(rawMsg, key)
		case "netIpv4TcpKeepaliveTime":
			err = unpopulate(val, "NetIPv4TCPKeepaliveTime", &s.NetIPv4TCPKeepaliveTime)
			delete(rawMsg, key)
		case "netIpv4TcpMaxSynBacklog":
			err = unpopulate(val, "NetIPv4TCPMaxSynBacklog", &s.NetIPv4TCPMaxSynBacklog)
			delete(rawMsg, key)
		case "netIpv4TcpMaxTwBuckets":
			err = unpopulate(val, "NetIPv4TCPMaxTwBuckets", &s.NetIPv4TCPMaxTwBuckets)
			delete(rawMsg, key)
		case "netIpv4TcpRmem":
			err = unpopulate(val, "NetIPv4TCPRmem", &s.NetIPv4TCPRmem)
			delete(rawMsg, key)
		case "netIpv4TcpTwReuse":
			err = unpopulate(val, "NetIPv4TCPTwReuse", &s.NetIPv4TCPTwReuse)
			delete(rawMsg, key)
		case "netIpv4TcpWmem":
			err = unpopulate(val, "NetIPv4TCPWmem", &s.NetIPv4TCPWmem)
			delete(rawMsg, key)
		case "netIpv4TcpkeepaliveIntvl":
			err = unpopulate(val, "NetIPv4TcpkeepaliveIntvl", &s.NetIPv4TcpkeepaliveIntvl)
			delete(rawMsg, key)
		case "netNetfilterNfConntrackBuckets":
			err = unpopulate(val, "NetNetfilterNfConntrackBuckets", &s.NetNetfilterNfConntrackBuckets)
			delete(rawMsg, key)
		case "netNetfilterNfConntrackMax":
			err = unpopulate(val, "NetNetfilterNfConntrackMax", &s.NetNetfilterNfConntrackMax)
			delete(rawMsg, key)
		case "vmMaxMapCount":
			err = unpopulate(val, "VMMaxMapCount", &s.VMMaxMapCount)
			delete(rawMsg, key)
		case "vmSwappiness":
			err = unpopulate(val, "VMSwappiness", &s.VMSwappiness)
			delete(rawMsg, key)
		case "vmVfsCachePressure":
			err = unpopulate(val, "VMVfsCachePressure", &s.VMVfsCachePressure)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TagsObject.
func (t TagsObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", t.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TagsObject.
func (t *TagsObject) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &t.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserAssignedIdentity.
func (u UserAssignedIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", u.ClientID)
	populate(objectMap, "objectId", u.ObjectID)
	populate(objectMap, "resourceId", u.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserAssignedIdentity.
func (u *UserAssignedIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &u.ClientID)
			delete(rawMsg, key)
		case "objectId":
			err = unpopulate(val, "ObjectID", &u.ObjectID)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &u.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMDiagnostics.
func (v VMDiagnostics) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", v.Enabled)
	populate(objectMap, "storageUri", v.StorageURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMDiagnostics.
func (v *VMDiagnostics) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &v.Enabled)
			delete(rawMsg, key)
		case "storageUri":
			err = unpopulate(val, "StorageURI", &v.StorageURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WindowsProfile.
func (w WindowsProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "adminPassword", w.AdminPassword)
	populate(objectMap, "adminUsername", w.AdminUsername)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WindowsProfile.
func (w *WindowsProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adminPassword":
			err = unpopulate(val, "AdminPassword", &w.AdminPassword)
			delete(rawMsg, key)
		case "adminUsername":
			err = unpopulate(val, "AdminUsername", &w.AdminUsername)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateByteArray(m map[string]any, k string, b []byte, f runtime.Base64Encoding) {
	if azcore.IsNullValue(b) {
		m[k] = nil
	} else if len(b) == 0 {
		return
	} else {
		m[k] = runtime.EncodeByteArray(b, f)
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
