/**
 * @license
 * Copyright 2026 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import type { ReadStream } from 'node:tty';
import { type EditorType } from '@google/gemini-cli-core';
/**
 * Opens a file in an external editor and waits for it to close.
 * Handles raw mode switching to ensure the editor can interact with the terminal.
 *
 * @param filePath Path to the file to open
 * @param stdin The stdin stream from Ink/Node
 * @param setRawMode Function to toggle raw mode
 * @param preferredEditorType The user's preferred editor from config
 */
export declare function openFileInEditor(filePath: string, stdin: ReadStream | null | undefined, setRawMode: ((mode: boolean) => void) | undefined, preferredEditorType?: EditorType): Promise<void>;
