import { jsx as _jsx } from "react/jsx-runtime";
/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import React from 'react';
import { Text } from 'ink';
import { parseMarkdownToANSI } from './markdownParsingUtils.js';
import { stripUnsafeCharacters } from './textUtils.js';
const RenderInlineInternal = ({ text: rawText, defaultColor, }) => {
    const text = stripUnsafeCharacters(rawText);
    const ansiText = parseMarkdownToANSI(text, defaultColor);
    return _jsx(Text, { children: ansiText });
};
export const RenderInline = React.memo(RenderInlineInternal);
//# sourceMappingURL=InlineMarkdownRenderer.js.map