/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { useConfig } from '../contexts/ConfigContext.js';
export const isAlternateBufferEnabled = (config) => config.getUseAlternateBuffer();
// This is read from Config so that the UI reads the same value per application session
export const useAlternateBuffer = () => {
    const config = useConfig();
    return isAlternateBufferEnabled(config);
};
//# sourceMappingURL=useAlternateBuffer.js.map