/**
 * @license
 * Copyright 2026 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import type React from 'react';
/** Available choices in the overage menu dialog */
export type OverageMenuChoice = 'use_credits' | 'use_fallback' | 'manage' | 'stop';
interface OverageMenuDialogProps {
    /** The model that hit the quota limit */
    failedModel: string;
    /** The fallback model to offer (omit if none available) */
    fallbackModel?: string;
    /** Time when access resets (human-readable) */
    resetTime?: string;
    /** Available G1 AI credit balance */
    creditBalance: number;
    /** Callback when user makes a selection */
    onChoice: (choice: OverageMenuChoice) => void;
}
export declare function OverageMenuDialog({ failedModel, fallbackModel, resetTime, creditBalance, onChoice, }: OverageMenuDialogProps): React.JSX.Element;
export {};
