/**
 * @license
 * Copyright 2026 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { EventEmitter } from 'node:events';
import type React from 'react';
import { Terminal } from '@xterm/headless';
import { LoadedSettings } from '../config/settings.js';
import { type UIState } from '../ui/contexts/UIStateContext.js';
import { type UIActions } from '../ui/contexts/UIActionsContext.js';
import { type OverflowActions, type OverflowState } from '../ui/contexts/OverflowContext.js';
import { type Config } from '@google/gemini-cli-core';
import { FakePersistentState } from './persistentStateFake.js';
import { type AppState } from '../ui/contexts/AppContext.js';
export declare const persistentStateMock: FakePersistentState;
type TerminalState = {
    terminal: Terminal;
    cols: number;
    rows: number;
};
declare class XtermStdout extends EventEmitter {
    private state;
    private pendingWrites;
    private renderCount;
    private queue;
    isTTY: boolean;
    getColorDepth(): number;
    private lastRenderOutput;
    private lastRenderStaticContent;
    constructor(state: TerminalState, queue: {
        promise: Promise<void>;
    });
    get columns(): number;
    get rows(): number;
    get frames(): string[];
    write: (data: string) => void;
    clear: () => void;
    dispose: () => void;
    onRender: (staticContent: string, output: string) => void;
    private normalizeFrame;
    generateSvg: () => string;
    lastFrameRaw: (options?: {
        allowEmpty?: boolean;
    }) => string;
    lastFrame: (options?: {
        allowEmpty?: boolean;
    }) => string;
    waitUntilReady(): Promise<void>;
}
declare class XtermStderr extends EventEmitter {
    private state;
    private pendingWrites;
    private queue;
    isTTY: boolean;
    constructor(state: TerminalState, queue: {
        promise: Promise<void>;
    });
    write: (data: string) => void;
    dispose: () => void;
    lastFrame: () => string;
}
declare class XtermStdin extends EventEmitter {
    isTTY: boolean;
    data: string | null;
    constructor(options?: {
        isTTY?: boolean;
    });
    write: (data: string) => void;
    setEncoding(): void;
    setRawMode(): void;
    resume(): void;
    pause(): void;
    ref(): void;
    unref(): void;
    read: () => string | null;
}
export type RenderInstance = {
    rerender: (tree: React.ReactElement) => void;
    unmount: () => void;
    cleanup: () => void;
    stdout: XtermStdout;
    stderr: XtermStderr;
    stdin: XtermStdin;
    frames: string[];
    lastFrame: (options?: {
        allowEmpty?: boolean;
    }) => string;
    lastFrameRaw: (options?: {
        allowEmpty?: boolean;
    }) => string;
    generateSvg: () => string;
    terminal: Terminal;
    waitUntilReady: () => Promise<void>;
    capturedOverflowState: OverflowState | undefined;
    capturedOverflowActions: OverflowActions | undefined;
};
export declare const render: (tree: React.ReactElement, terminalWidth?: number) => Omit<RenderInstance, "capturedOverflowState" | "capturedOverflowActions">;
export declare const cleanup: () => void;
export declare const simulateClick: (stdin: XtermStdin, col: number, row: number, button?: 0 | 1 | 2) => Promise<void>;
export declare const mockSettings: LoadedSettings;
export declare const mockAppState: AppState;
export declare const renderWithProviders: (component: React.ReactElement, { shellFocus, settings, uiState: providedUiState, width, mouseEventsEnabled, config, useAlternateBuffer, uiActions, persistentState, appState, }?: {
    shellFocus?: boolean;
    settings?: LoadedSettings;
    uiState?: Partial<UIState>;
    width?: number;
    mouseEventsEnabled?: boolean;
    config?: Config;
    useAlternateBuffer?: boolean;
    uiActions?: Partial<UIActions>;
    persistentState?: {
        get?: typeof persistentStateMock.get;
        set?: typeof persistentStateMock.set;
    };
    appState?: AppState;
}) => RenderInstance & {
    simulateClick: (col: number, row: number, button?: 0 | 1 | 2) => Promise<void>;
};
export declare function renderHook<Result, Props>(renderCallback: (props: Props) => Result, options?: {
    initialProps?: Props;
    wrapper?: React.ComponentType<{
        children: React.ReactNode;
    }>;
}): {
    result: {
        current: Result;
    };
    rerender: (props?: Props) => void;
    unmount: () => void;
    waitUntilReady: () => Promise<void>;
    generateSvg: () => string;
};
export declare function renderHookWithProviders<Result, Props>(renderCallback: (props: Props) => Result, options?: {
    initialProps?: Props;
    wrapper?: React.ComponentType<{
        children: React.ReactNode;
    }>;
    shellFocus?: boolean;
    settings?: LoadedSettings;
    uiState?: Partial<UIState>;
    width?: number;
    mouseEventsEnabled?: boolean;
    config?: Config;
    useAlternateBuffer?: boolean;
}): {
    result: {
        current: Result;
    };
    rerender: (props?: Props) => void;
    unmount: () => void;
    waitUntilReady: () => Promise<void>;
    generateSvg: () => string;
};
export {};
