/**
 * @license
 * Copyright 2026 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { CoreToolCallStatus } from '@google/gemini-cli-core';
/**
 * Constants used for calculating available height for tool results.
 * These MUST be kept in sync between ToolGroupMessage (for overflow detection)
 * and ToolResultDisplay (for actual truncation).
 */
export declare const TOOL_RESULT_STATIC_HEIGHT = 1;
export declare const TOOL_RESULT_ASB_RESERVED_LINE_COUNT = 6;
export declare const TOOL_RESULT_STANDARD_RESERVED_LINE_COUNT = 2;
export declare const TOOL_RESULT_MIN_LINES_SHOWN = 2;
/**
 * Calculates the final height available for the content of a tool result display.
 *
 * This accounts for:
 * 1. The static height of the tool message (name, status line).
 * 2. Reserved space for hints and padding (different in ASB vs Standard mode).
 * 3. Enforcing a minimum number of lines shown.
 */
export declare function calculateToolContentMaxLines(options: {
    availableTerminalHeight: number | undefined;
    isAlternateBuffer: boolean;
    maxLinesLimit?: number;
}): number | undefined;
/**
 * Calculates the maximum number of lines to display for shell output.
 *
 * This logic distinguishes between:
 * 1. Process Status: Active (Executing) vs Completed.
 * 2. UI Focus: Whether the user is currently interacting with the shell.
 * 3. Expansion State: Whether the user has explicitly requested to "Show More Lines" (CTRL+O).
 */
export declare function calculateShellMaxLines(options: {
    status: CoreToolCallStatus;
    isAlternateBuffer: boolean;
    isThisShellFocused: boolean;
    availableTerminalHeight: number | undefined;
    constrainHeight: boolean;
    isExpandable: boolean | undefined;
}): number | undefined;
