import { jsx as _jsx } from "react/jsx-runtime";
/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { render } from '../../test-utils/render.js';
import { describe, it, expect, vi, beforeEach } from 'vitest';
import { act } from 'react';
import { GeminiPrivacyNotice } from './GeminiPrivacyNotice.js';
import { useKeypress } from '../hooks/useKeypress.js';
// Mocks
vi.mock('../hooks/useKeypress.js', () => ({
    useKeypress: vi.fn(),
}));
const mockedUseKeypress = useKeypress;
describe('GeminiPrivacyNotice', () => {
    const onExit = vi.fn();
    beforeEach(() => {
        vi.resetAllMocks();
    });
    it('renders correctly', async () => {
        const { lastFrame, waitUntilReady, unmount } = render(_jsx(GeminiPrivacyNotice, { onExit: onExit }));
        await waitUntilReady();
        expect(lastFrame()).toContain('Gemini API Key Notice');
        expect(lastFrame()).toContain('By using the Gemini API');
        expect(lastFrame()).toContain('Press Esc to exit');
        unmount();
    });
    it('exits on Escape', async () => {
        const { waitUntilReady, unmount } = render(_jsx(GeminiPrivacyNotice, { onExit: onExit }));
        await waitUntilReady();
        const keypressHandler = mockedUseKeypress.mock.calls[0][0];
        await act(async () => {
            keypressHandler({ name: 'escape' });
        });
        // Escape key has a 50ms timeout in KeypressContext, so we need to wrap waitUntilReady in act
        await act(async () => {
            await waitUntilReady();
        });
        expect(onExit).toHaveBeenCalled();
        unmount();
    });
});
//# sourceMappingURL=GeminiPrivacyNotice.test.js.map