/**
 * @license
 * Copyright 2026 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import type { Suggestion } from '../components/SuggestionsDisplay.js';
/**
 * Escapes special shell characters in a path segment.
 */
export declare function escapeShellPath(segment: string): string;
export interface TokenInfo {
    /** The raw token text (without surrounding quotes but with internal escapes). */
    token: string;
    /** Offset in the original line where this token begins. */
    start: number;
    /** Offset in the original line where this token ends (exclusive). */
    end: number;
    /** Whether this is the first token (command position). */
    isFirstToken: boolean;
    /** The fully built list of tokens parsing the string. */
    tokens: string[];
    /** The index in the tokens list where the cursor lies. */
    cursorIndex: number;
    /** The command token (always tokens[0] if length > 0, otherwise empty string) */
    commandToken: string;
}
export declare function getTokenAtCursor(line: string, cursorCol: number): TokenInfo | null;
export declare function scanPathExecutables(signal?: AbortSignal): Promise<string[]>;
export declare function resolvePathCompletions(partial: string, cwd: string, signal?: AbortSignal): Promise<Suggestion[]>;
export interface UseShellCompletionProps {
    /** Whether shell completion is active. */
    enabled: boolean;
    /** The current line text. */
    line: string;
    /** The current cursor column. */
    cursorCol: number;
    /** The current working directory for path resolution. */
    cwd: string;
    /** Callback to set suggestions on the parent state. */
    setSuggestions: (suggestions: Suggestion[]) => void;
    /** Callback to set loading state on the parent. */
    setIsLoadingSuggestions: (isLoading: boolean) => void;
}
export interface UseShellCompletionReturn {
    completionStart: number;
    completionEnd: number;
    query: string;
}
export declare function useShellCompletion({ enabled, line, cursorCol, cwd, setSuggestions, setIsLoadingSuggestions, }: UseShellCompletionProps): UseShellCompletionReturn;
