/**
 * @license
 * Copyright 2026 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { type Config, type FallbackIntent, type ValidationIntent, type UserTierId, type GeminiUserTier } from '@google/gemini-cli-core';
import { type UseHistoryManagerReturn } from './useHistoryManager.js';
import { type ProQuotaDialogRequest, type ValidationDialogRequest, type OverageMenuDialogRequest, type OverageMenuIntent, type EmptyWalletDialogRequest, type EmptyWalletIntent } from '../contexts/UIStateContext.js';
import type { LoadedSettings } from '../../config/settings.js';
interface UseQuotaAndFallbackArgs {
    config: Config;
    historyManager: UseHistoryManagerReturn;
    userTier: UserTierId | undefined;
    paidTier: GeminiUserTier | null | undefined;
    settings: LoadedSettings;
    setModelSwitchedFromQuotaError: (value: boolean) => void;
    onShowAuthSelection: () => void;
    errorVerbosity?: 'low' | 'full';
}
export declare function useQuotaAndFallback({ config, historyManager, userTier, paidTier, settings, setModelSwitchedFromQuotaError, onShowAuthSelection, errorVerbosity, }: UseQuotaAndFallbackArgs): {
    proQuotaRequest: ProQuotaDialogRequest | null;
    handleProQuotaChoice: (choice: FallbackIntent) => void;
    validationRequest: ValidationDialogRequest | null;
    handleValidationChoice: (choice: ValidationIntent) => void;
    overageMenuRequest: OverageMenuDialogRequest | null;
    handleOverageMenuChoice: (choice: OverageMenuIntent) => void;
    emptyWalletRequest: EmptyWalletDialogRequest | null;
    handleEmptyWalletChoice: (choice: EmptyWalletIntent) => void;
};
export {};
