/**
 * @license
 * Copyright 2026 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import type { Suggestion } from '../../components/SuggestionsDisplay.js';
export interface CompletionResult {
    suggestions: Suggestion[];
    exclusive?: boolean;
}
export interface ShellCompletionProvider {
    command: string;
    getCompletions(tokens: string[], // List of arguments parsed from the input
    cursorIndex: number, // Which token index the cursor is currently on
    cwd: string, signal?: AbortSignal): Promise<CompletionResult>;
}
