/**
 * @license
 * Copyright 2026 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { gitProvider } from './gitProvider.js';
import { npmProvider } from './npmProvider.js';
const providers = [gitProvider, npmProvider];
export async function getArgumentCompletions(commandToken, tokens, cursorIndex, cwd, signal) {
    const provider = providers.find((p) => p.command === commandToken);
    if (!provider) {
        return null;
    }
    return provider.getCompletions(tokens, cursorIndex, cwd, signal);
}
//# sourceMappingURL=index.js.map