/**
 * @license
 * Copyright 2026 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { type Config, type FallbackIntent, type GeminiUserTier } from '@google/gemini-cli-core';
import type { UseHistoryManagerReturn } from './useHistoryManager.js';
import type { OverageMenuIntent, EmptyWalletDialogRequest } from '../contexts/UIStateContext.js';
interface CreditsFlowArgs {
    config: Config;
    paidTier: GeminiUserTier;
    overageStrategy: 'ask' | 'always' | 'never';
    failedModel: string;
    fallbackModel: string;
    usageLimitReachedModel: string;
    resetTime: string | undefined;
    historyManager: UseHistoryManagerReturn;
    setModelSwitchedFromQuotaError: (value: boolean) => void;
    isDialogPending: React.MutableRefObject<boolean>;
    setOverageMenuRequest: (req: {
        failedModel: string;
        fallbackModel: string;
        resetTime: string | undefined;
        creditBalance: number;
        resolve: (intent: OverageMenuIntent) => void;
    } | null) => void;
    setEmptyWalletRequest: (req: EmptyWalletDialogRequest | null) => void;
}
/**
 * Handles the G1 AI Credits flow when a quota error occurs.
 * Returns a FallbackIntent if the credits flow handled the error,
 * or null to fall through to the default ProQuotaDialog.
 */
export declare function handleCreditsFlow(args: CreditsFlowArgs): Promise<FallbackIntent | null>;
export {};
