import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { Box, Text } from 'ink';
import { theme } from '../semantic-colors.js';
import { useConfig } from '../contexts/ConfigContext.js';
import { ToolConfirmationMessage } from './messages/ToolConfirmationMessage.js';
import { ToolStatusIndicator, ToolInfo } from './messages/ToolShared.js';
import { useUIState } from '../contexts/UIStateContext.js';
import { OverflowProvider } from '../contexts/OverflowContext.js';
import { ShowMoreLines } from './ShowMoreLines.js';
import { StickyHeader } from './StickyHeader.js';
import { useAlternateBuffer } from '../hooks/useAlternateBuffer.js';
import { useUIActions } from '../contexts/UIActionsContext.js';
function getConfirmationHeader(details) {
    const headers = {
        ask_user: 'Answer Questions',
        exit_plan_mode: 'Ready to start implementation?',
    };
    if (!details?.type) {
        return 'Action Required';
    }
    return headers[details.type] ?? 'Action Required';
}
export const ToolConfirmationQueue = ({ confirmingTool, }) => {
    const config = useConfig();
    const { getPreferredEditor } = useUIActions();
    const isAlternateBuffer = useAlternateBuffer();
    const { mainAreaWidth, terminalHeight, constrainHeight, availableTerminalHeight: uiAvailableHeight, } = useUIState();
    const { tool, index, total } = confirmingTool;
    // Safety check: ToolConfirmationMessage requires confirmationDetails
    if (!tool.confirmationDetails)
        return null;
    // Render up to 100% of the available terminal height (minus 1 line for safety)
    // to maximize space for diffs and other content.
    const maxHeight = uiAvailableHeight !== undefined
        ? Math.max(uiAvailableHeight - 1, 4)
        : Math.floor(terminalHeight * 0.5);
    const isRoutine = tool.confirmationDetails?.type === 'ask_user' ||
        tool.confirmationDetails?.type === 'exit_plan_mode';
    const borderColor = isRoutine ? theme.status.success : theme.status.warning;
    const hideToolIdentity = isRoutine;
    // ToolConfirmationMessage needs to know the height available for its OWN content.
    // We subtract the lines used by the Queue wrapper:
    // - 2 lines for the rounded border
    // - 2 lines for the Header (text + margin)
    // - 2 lines for Tool Identity (text + margin)
    const availableContentHeight = constrainHeight
        ? Math.max(maxHeight - (hideToolIdentity ? 4 : 6), 4)
        : undefined;
    const content = (_jsxs(_Fragment, { children: [_jsxs(Box, { flexDirection: "column", width: mainAreaWidth, flexShrink: 0, children: [_jsx(StickyHeader, { width: mainAreaWidth, isFirst: true, borderColor: borderColor, borderDimColor: false, children: _jsxs(Box, { flexDirection: "column", width: mainAreaWidth - 4, children: [_jsxs(Box, { marginBottom: hideToolIdentity ? 0 : 1, justifyContent: "space-between", children: [_jsx(Text, { color: borderColor, bold: true, children: getConfirmationHeader(tool.confirmationDetails) }), total > 1 && (_jsxs(Text, { color: theme.text.secondary, children: [index, " of ", total] }))] }), !hideToolIdentity && (_jsxs(Box, { children: [_jsx(ToolStatusIndicator, { status: tool.status, name: tool.name }), _jsx(ToolInfo, { name: tool.name, status: tool.status, description: tool.description, emphasis: "high" })] }))] }) }), _jsx(Box, { width: mainAreaWidth, borderStyle: "round", borderColor: borderColor, borderTop: false, borderBottom: false, borderLeft: true, borderRight: true, paddingX: 1, flexDirection: "column", children: _jsx(ToolConfirmationMessage, { callId: tool.callId, confirmationDetails: tool.confirmationDetails, config: config, getPreferredEditor: getPreferredEditor, terminalWidth: mainAreaWidth - 4, availableTerminalHeight: availableContentHeight, isFocused: true }) }), _jsx(Box, { height: 1, width: mainAreaWidth, borderLeft: true, borderRight: true, borderTop: false, borderBottom: true, borderColor: borderColor, borderStyle: "round" })] }), _jsx(ShowMoreLines, { constrainHeight: constrainHeight })] }));
    return isAlternateBuffer ? (
    /* Shadow the global provider to maintain isolation in ASB mode. */
    _jsx(OverflowProvider, { children: content })) : (content);
};
//# sourceMappingURL=ToolConfirmationQueue.js.map