import { jsx as _jsx } from "react/jsx-runtime";
import { useState, useEffect, useMemo } from 'react';
import { Text, useIsScreenReaderEnabled } from 'ink';
import { CliSpinner } from './CliSpinner.js';
import { Colors } from '../colors.js';
import tinygradient from 'tinygradient';
const COLOR_CYCLE_DURATION_MS = 4000;
export const GeminiSpinner = ({ spinnerType = 'dots', altText, }) => {
    const isScreenReaderEnabled = useIsScreenReaderEnabled();
    const [time, setTime] = useState(0);
    const googleGradient = useMemo(() => {
        const brandColors = [
            Colors.AccentPurple,
            Colors.AccentBlue,
            Colors.AccentCyan,
            Colors.AccentGreen,
            Colors.AccentYellow,
            Colors.AccentRed,
        ];
        return tinygradient([...brandColors, brandColors[0]]);
    }, []);
    useEffect(() => {
        if (isScreenReaderEnabled) {
            return;
        }
        const interval = setInterval(() => {
            setTime((prevTime) => prevTime + 30);
        }, 30); // ~33fps for smooth color transitions
        return () => clearInterval(interval);
    }, [isScreenReaderEnabled]);
    const progress = (time % COLOR_CYCLE_DURATION_MS) / COLOR_CYCLE_DURATION_MS;
    const currentColor = googleGradient.rgbAt(progress).toHexString();
    return isScreenReaderEnabled ? (_jsx(Text, { children: altText })) : (_jsx(Text, { color: currentColor, children: _jsx(CliSpinner, { type: spinnerType }) }));
};
//# sourceMappingURL=GeminiSpinner.js.map