import { jsxs as _jsxs, jsx as _jsx } from "react/jsx-runtime";
import { Box, Text } from 'ink';
import { RadioButtonSelect } from './shared/RadioButtonSelect.js';
import { theme } from '../semantic-colors.js';
export function EmptyWalletDialog({ failedModel, fallbackModel, resetTime, onGetCredits, onChoice, }) {
    const items = [
        {
            label: 'Get AI Credits - Open browser to purchase credits',
            value: 'get_credits',
            key: 'get_credits',
        },
    ];
    if (fallbackModel) {
        items.push({
            label: `Switch to ${fallbackModel}`,
            value: 'use_fallback',
            key: 'use_fallback',
        });
    }
    items.push({
        label: 'Stop - Abort request',
        value: 'stop',
        key: 'stop',
    });
    const handleSelect = (choice) => {
        if (choice === 'get_credits') {
            onGetCredits?.();
        }
        onChoice(choice);
    };
    return (_jsxs(Box, { borderStyle: "round", flexDirection: "column", padding: 1, children: [_jsxs(Box, { marginBottom: 1, flexDirection: "column", children: [_jsxs(Text, { color: theme.status.warning, children: ["Usage limit reached for ", failedModel, "."] }), resetTime && _jsxs(Text, { children: ["Access resets at ", resetTime, "."] }), _jsxs(Text, { children: [_jsx(Text, { bold: true, color: theme.text.accent, children: "/stats" }), ' ', "model for usage details"] }), _jsxs(Text, { children: [_jsx(Text, { bold: true, color: theme.text.accent, children: "/model" }), ' ', "to switch models."] }), _jsxs(Text, { children: [_jsx(Text, { bold: true, color: theme.text.accent, children: "/auth" }), ' ', "to switch to API key."] })] }), _jsx(Box, { marginBottom: 1, children: _jsx(Text, { children: "To continue using this model now, purchase more AI Credits." }) }), _jsx(Box, { marginBottom: 1, children: _jsx(Text, { dimColor: true, children: "Newly purchased AI credits may take a few minutes to update." }) }), _jsx(Box, { marginBottom: 1, children: _jsx(Text, { children: "How would you like to proceed?" }) }), _jsx(Box, { marginTop: 1, marginBottom: 1, children: _jsx(RadioButtonSelect, { items: items, onSelect: handleSelect }) })] }));
}
//# sourceMappingURL=EmptyWalletDialog.js.map