/**
 * @license
 * Copyright 2026 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import type React from 'react';
/** Available choices in the empty wallet dialog */
export type EmptyWalletChoice = 'get_credits' | 'use_fallback' | 'stop';
interface EmptyWalletDialogProps {
    /** The model that hit the quota limit */
    failedModel: string;
    /** The fallback model to offer (omit if none available) */
    fallbackModel?: string;
    /** Time when access resets (human-readable) */
    resetTime?: string;
    /** Callback to log click and open the browser for purchasing credits */
    onGetCredits?: () => void;
    /** Callback when user makes a selection */
    onChoice: (choice: EmptyWalletChoice) => void;
}
export declare function EmptyWalletDialog({ failedModel, fallbackModel, resetTime, onGetCredits, onChoice, }: EmptyWalletDialogProps): React.JSX.Element;
export {};
